/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections;

import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.ModalityKt;
import org.jetbrains.kotlin.descriptors.PropertyAccessorDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.inspections.AbstractKotlinInspection;
import org.jetbrains.kotlin.idea.inspections.RemoveSelfAssignmentFix;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtDotQualifiedExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtNameReferenceExpression;
import org.jetbrains.kotlin.psi.KtThisExpression;
import org.jetbrains.kotlin.psi.KtVisitorVoid;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;
import org.jetbrains.kotlin.resolve.scopes.receivers.ImplicitReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/SelfAssignmentInspection;", "Lorg/jetbrains/kotlin/idea/inspections/AbstractKotlinInspection;", "Lcom/intellij/codeInspection/CleanupLocalInspectionTool;", "()V", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "session", "Lcom/intellij/codeInspection/LocalInspectionToolSession;", "idea"})
public final class SelfAssignmentInspection
extends AbstractKotlinInspection
implements CleanupLocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        Intrinsics.checkParameterIsNotNull((Object)holder, (String)"holder");
        Intrinsics.checkParameterIsNotNull((Object)session, (String)"session");
        return new KtVisitorVoid(holder){
            final /* synthetic */ ProblemsHolder $holder;

            private final KtNameReferenceExpression asNameReferenceExpression(@NotNull KtExpression $receiver) {
                KtNameReferenceExpression ktNameReferenceExpression;
                KtExpression ktExpression = $receiver;
                if (ktExpression instanceof KtNameReferenceExpression) {
                    ktNameReferenceExpression = (KtNameReferenceExpression)$receiver;
                } else if (ktExpression instanceof KtDotQualifiedExpression) {
                    KtExpression ktExpression2 = ((KtDotQualifiedExpression)$receiver).getSelectorExpression();
                    if (!(ktExpression2 instanceof KtNameReferenceExpression)) {
                        ktExpression2 = null;
                    }
                    KtNameReferenceExpression ktNameReferenceExpression2 = (KtNameReferenceExpression)ktExpression2;
                    if (ktNameReferenceExpression2 != null) {
                        KtNameReferenceExpression ktNameReferenceExpression3;
                        KtNameReferenceExpression it = ktNameReferenceExpression3 = ktNameReferenceExpression2;
                        ktNameReferenceExpression = ((KtDotQualifiedExpression)$receiver).getReceiverExpression() instanceof KtThisExpression ? ktNameReferenceExpression3 : null;
                    } else {
                        ktNameReferenceExpression = null;
                    }
                } else {
                    ktNameReferenceExpression = null;
                }
                return ktNameReferenceExpression;
            }

            private final DeclarationDescriptor receiverDeclarationDescriptor(@NotNull KtExpression $receiver, ResolvedCall<? extends CallableDescriptor> resolvedCall2, BindingContext context) {
                ImplicitReceiver implicitReceiver;
                ReceiverValue receiverValue;
                KtThisExpression thisExpression;
                KtExpression ktExpression = $receiver;
                if (!(ktExpression instanceof KtDotQualifiedExpression)) {
                    ktExpression = null;
                }
                KtDotQualifiedExpression ktDotQualifiedExpression = (KtDotQualifiedExpression)ktExpression;
                KtExpression ktExpression2 = ktDotQualifiedExpression != null ? ktDotQualifiedExpression.getReceiverExpression() : null;
                if (!(ktExpression2 instanceof KtThisExpression)) {
                    ktExpression2 = null;
                }
                if ((thisExpression = (KtThisExpression)ktExpression2) != null) {
                    ResolvedCall<? extends CallableDescriptor> resolvedCall3 = CallUtilKt.getResolvedCall(thisExpression, context);
                    return resolvedCall3 != null && (resolvedCall3 = resolvedCall3.getResultingDescriptor()) != null ? resolvedCall3.getContainingDeclaration() : null;
                }
                ResolvedCall<? extends CallableDescriptor> $receiver2 = resolvedCall2;
                ReceiverValue receiverValue2 = $receiver2.getDispatchReceiver();
                if (receiverValue2 == null) {
                    receiverValue2 = receiverValue = $receiver2.getExtensionReceiver();
                }
                if (!(receiverValue2 instanceof ImplicitReceiver)) {
                    receiverValue = null;
                }
                ImplicitReceiver implicitReceiver2 = implicitReceiver = (ImplicitReceiver)receiverValue;
                return implicitReceiver2 != null ? implicitReceiver2.getDeclarationDescriptor() : null;
            }

            public void visitBinaryExpression(@NotNull KtBinaryExpression expression2) {
                ResolvedCall<? extends CallableDescriptor> rightResolvedCall;
                ResolvedCall<? extends CallableDescriptor> leftResolvedCall;
                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                super.visitBinaryExpression(expression2);
                if (Intrinsics.areEqual((Object)expression2.getOperationToken(), (Object)((Object)KtTokens.EQ)) ^ true) {
                    return;
                }
                KtExpression left = expression2.getLeft();
                KtExpression ktExpression = left;
                if (ktExpression == null || (ktExpression = this.asNameReferenceExpression(ktExpression)) == null) {
                    return;
                }
                KtExpression leftRefExpr = ktExpression;
                KtExpression right = expression2.getRight();
                KtExpression ktExpression2 = right;
                if (ktExpression2 == null || (ktExpression2 = this.asNameReferenceExpression(ktExpression2)) == null) {
                    return;
                }
                KtExpression rightRefExpr = ktExpression2;
                if (Intrinsics.areEqual((Object)leftRefExpr.getText(), (Object)rightRefExpr.getText()) ^ true) {
                    return;
                }
                BindingContext context = ResolutionUtils.analyze(expression2, BodyResolveMode.PARTIAL);
                ResolvedCall<? extends CallableDescriptor> resolvedCall2 = leftResolvedCall = CallUtilKt.getResolvedCall(left, context);
                CallableDescriptor callableDescriptor = resolvedCall2 != null ? resolvedCall2.getResultingDescriptor() : null;
                if (!(callableDescriptor instanceof VariableDescriptor)) {
                    callableDescriptor = null;
                }
                VariableDescriptor variableDescriptor = (VariableDescriptor)callableDescriptor;
                if (variableDescriptor == null) {
                    return;
                }
                VariableDescriptor leftCallee = variableDescriptor;
                ResolvedCall<? extends CallableDescriptor> resolvedCall3 = rightResolvedCall = CallUtilKt.getResolvedCall(right, context);
                CallableDescriptor callableDescriptor2 = resolvedCall3 != null ? resolvedCall3.getResultingDescriptor() : null;
                if (!(callableDescriptor2 instanceof VariableDescriptor)) {
                    callableDescriptor2 = null;
                }
                VariableDescriptor variableDescriptor2 = (VariableDescriptor)callableDescriptor2;
                if (variableDescriptor2 == null) {
                    return;
                }
                VariableDescriptor rightCallee = variableDescriptor2;
                if (Intrinsics.areEqual((Object)leftCallee, (Object)rightCallee) ^ true) {
                    return;
                }
                if (!rightCallee.isVar()) {
                    return;
                }
                if (rightCallee instanceof PropertyDescriptor) {
                    boolean bl;
                    block17: {
                        if (ModalityKt.isOverridable((CallableMemberDescriptor)((Object)rightCallee))) {
                            return;
                        }
                        List<PropertyAccessorDescriptor> list2 = ((PropertyDescriptor)rightCallee).getAccessors();
                        Intrinsics.checkExpressionValueIsNotNull(list2, (String)"rightCallee.accessors");
                        Iterable $receiver$iv = list2;
                        if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                            bl = false;
                        } else {
                            for (T element$iv : $receiver$iv) {
                                PropertyAccessorDescriptor it;
                                PropertyAccessorDescriptor propertyAccessorDescriptor = it = (PropertyAccessorDescriptor)element$iv;
                                Intrinsics.checkExpressionValueIsNotNull((Object)propertyAccessorDescriptor, (String)"it");
                                if (!(!propertyAccessorDescriptor.isDefault())) continue;
                                bl = true;
                                break block17;
                            }
                            bl = false;
                        }
                    }
                    if (bl) {
                        return;
                    }
                }
                if (Intrinsics.areEqual((Object)this.receiverDeclarationDescriptor(left, leftResolvedCall, context), (Object)this.receiverDeclarationDescriptor(right, rightResolvedCall, context)) ^ true) {
                    return;
                }
                this.$holder.registerProblem((PsiElement)right, "Variable '" + rightCallee.getName() + "' is assigned to itself", ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[]{new RemoveSelfAssignmentFix()});
            }
            {
                this.$holder = $captured_local_variable$0;
            }
        };
    }
}

