/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections;

import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.tree.IElementType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.inspections.AbstractKotlinInspection;
import org.jetbrains.kotlin.idea.inspections.SortModifiersFix;
import org.jetbrains.kotlin.lexer.KtModifierKeywordToken;
import org.jetbrains.kotlin.psi.KtAnnotation;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtModifierList;
import org.jetbrains.kotlin.psi.KtVisitorVoid;
import org.jetbrains.kotlin.psi.addRemoveModifier.AddRemoveModifierKt;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/SortModifiersInspection;", "Lorg/jetbrains/kotlin/idea/inspections/AbstractKotlinInspection;", "Lcom/intellij/codeInspection/CleanupLocalInspectionTool;", "()V", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "session", "Lcom/intellij/codeInspection/LocalInspectionToolSession;", "idea"})
public final class SortModifiersInspection
extends AbstractKotlinInspection
implements CleanupLocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        Intrinsics.checkParameterIsNotNull((Object)holder, (String)"holder");
        Intrinsics.checkParameterIsNotNull((Object)session, (String)"session");
        return new KtVisitorVoid(holder){
            final /* synthetic */ ProblemsHolder $holder;

            /*
             * WARNING - void declaration
             */
            public void visitModifierList(@NotNull KtModifierList list2) {
                void $receiver$iv$iv;
                Iterable $receiver$iv;
                Intrinsics.checkParameterIsNotNull((Object)list2, (String)"list");
                super.visitModifierList(list2);
                List modifierElements = SequencesKt.toList((Sequence)PsiUtilsKt.getAllChildren((PsiElement)list2));
                boolean modifiersBeforeAnnotations = false;
                boolean seenModifiers = false;
                for (PsiElement modifierElement : modifierElements) {
                    ASTNode aSTNode = modifierElement.getNode();
                    Intrinsics.checkExpressionValueIsNotNull((Object)aSTNode, (String)"modifierElement.node");
                    if (aSTNode.getElementType() instanceof KtModifierKeywordToken) {
                        seenModifiers = true;
                        continue;
                    }
                    if (!seenModifiers || !(modifierElement instanceof KtAnnotationEntry) && !(modifierElement instanceof KtAnnotation)) continue;
                    modifiersBeforeAnnotations = true;
                }
                Iterable iterable = $receiver$iv = (Iterable)modifierElements;
                Collection destination$iv$iv = new ArrayList<E>();
                void $receiver$iv$iv$iv = $receiver$iv$iv;
                Iterator<T> iterator2 = $receiver$iv$iv$iv.iterator();
                while (iterator2.hasNext()) {
                    KtModifierKeywordToken ktModifierKeywordToken;
                    T element$iv$iv$iv;
                    T element$iv$iv = element$iv$iv$iv = iterator2.next();
                    PsiElement it = (PsiElement)element$iv$iv;
                    ASTNode aSTNode = it.getNode();
                    Intrinsics.checkExpressionValueIsNotNull((Object)aSTNode, (String)"it.node");
                    IElementType iElementType = aSTNode.getElementType();
                    if (!(iElementType instanceof KtModifierKeywordToken)) {
                        iElementType = null;
                    }
                    if ((KtModifierKeywordToken)iElementType == null) continue;
                    KtModifierKeywordToken it$iv$iv = ktModifierKeywordToken;
                    destination$iv$iv.add(it$iv$iv);
                }
                List modifiers2 = CollectionsKt.toList((Iterable)((List)destination$iv$iv));
                if (modifiers2.isEmpty()) {
                    return;
                }
                List<KtModifierKeywordToken> sortedModifiers = AddRemoveModifierKt.sortModifiers(modifiers2);
                if (Intrinsics.areEqual((Object)modifiers2, sortedModifiers) && !modifiersBeforeAnnotations) {
                    return;
                }
                String message2 = modifiersBeforeAnnotations ? "Modifiers should follow annotations" : "Non-canonical modifiers order";
                this.$holder.registerProblem((PsiElement)list2, message2, ProblemHighlightType.WEAK_WARNING, new LocalQuickFix[]{new SortModifiersFix(sortedModifiers)});
            }
            {
                this.$holder = $captured_local_variable$0;
            }
        };
    }
}

