/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.intentions;

import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiElement;
import java.util.Collection;
import java.util.List;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntProgression;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.core.GenerateUtilKt;
import org.jetbrains.kotlin.idea.intentions.ConvertBinaryExpressionWithDemorgansLawIntention;
import org.jetbrains.kotlin.idea.intentions.SelfTargetingIntention;
import org.jetbrains.kotlin.idea.intentions.UtilsKt;
import org.jetbrains.kotlin.idea.util.CommentSaver;
import org.jetbrains.kotlin.idea.util.psi.patternMatching.KotlinPsiUnifierKt;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.CreateByPatternKt;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtContainerNode;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtDeclarationWithBody;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtIfExpression;
import org.jetbrains.kotlin.psi.KtLoopExpression;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtParenthesizedExpression;
import org.jetbrains.kotlin.psi.KtPrefixExpression;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtPsiFactoryKt;
import org.jetbrains.kotlin.psi.KtReturnExpression;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.psi.psiUtil.PsiChildRange;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00022\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0016J\u0010\u0010\t\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u0002H\u0002J\u0012\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\fH\u0002J\u001a\u0010\u000e\u001a\u0004\u0018\u00010\u00022\u0006\u0010\n\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\fH\u0002J\u0018\u0010\u0010\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\fH\u0002J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\fH\u0002J\u0012\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0006\u001a\u00020\u0002H\u0002\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/idea/intentions/InvertIfConditionIntention;", "Lorg/jetbrains/kotlin/idea/intentions/SelfTargetingIntention;", "Lorg/jetbrains/kotlin/psi/KtIfExpression;", "()V", "applyTo", "", "element", "editor", "Lcom/intellij/openapi/editor/Editor;", "copyThenBranchAfter", "ifExpression", "exitStatementExecutedAfter", "Lorg/jetbrains/kotlin/psi/KtExpression;", "expression", "handleSpecialCases", "newCondition", "handleStandardCase", "isApplicableTo", "", "caretOffset", "", "isEmptyReturn", "statement", "parentBlockRBrace", "Lcom/intellij/psi/PsiElement;", "idea"})
public final class InvertIfConditionIntention
extends SelfTargetingIntention<KtIfExpression> {
    @Override
    public boolean isApplicableTo(@NotNull KtIfExpression element3, int caretOffset) {
        Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
        PsiElement psiElement2 = element3.getIfKeyword();
        Intrinsics.checkExpressionValueIsNotNull((Object)psiElement2, (String)"element.ifKeyword");
        if (!psiElement2.getTextRange().containsOffset(caretOffset)) {
            return false;
        }
        return element3.getCondition() != null && element3.getThen() != null;
    }

    @Override
    public void applyTo(@NotNull KtIfExpression element3, @Nullable Editor editor) {
        block10: {
            KtPrefixExpression ktPrefixExpression;
            KtPrefixExpression it;
            PsiChildRange psiChildRange;
            KtIfExpression newIf;
            Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
            PsiElement rBrace = this.parentBlockRBrace(element3);
            PsiChildRange commentSavingRange = rBrace != null ? new PsiChildRange((PsiElement)element3, rBrace) : PsiChildRange.Companion.singleElement((PsiElement)element3);
            CommentSaver commentSaver = new CommentSaver(commentSavingRange, false, 2, null);
            KtExpression ktExpression = element3.getCondition();
            if (ktExpression == null) {
                Intrinsics.throwNpe();
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression, (String)"element.condition!!");
            KtExpression newCondition = UtilsKt.negate$default(ktExpression, false, 1, null);
            KtIfExpression ktIfExpression = this.handleSpecialCases(element3, newCondition);
            if (ktIfExpression == null) {
                ktIfExpression = newIf = this.handleStandardCase(element3, newCondition);
            }
            if (rBrace != null) {
                psiChildRange = new PsiChildRange((PsiElement)newIf, rBrace);
            } else {
                PsiElement psiElement2 = (PsiElement)newIf;
                PsiElement psiElement3 = this.parentBlockRBrace(newIf);
                if (psiElement3 == null) {
                    psiElement3 = (PsiElement)newIf;
                }
                psiChildRange = new PsiChildRange(psiElement2, psiElement3);
            }
            PsiChildRange commentRestoreRange = psiChildRange;
            CommentSaver.restore$default(commentSaver, commentRestoreRange, false, 2, null);
            KtExpression newIfCondition = newIf.getCondition();
            ConvertBinaryExpressionWithDemorgansLawIntention simplifyIntention = new ConvertBinaryExpressionWithDemorgansLawIntention();
            KtExpression ktExpression2 = newIfCondition;
            if (!(ktExpression2 instanceof KtPrefixExpression)) {
                ktExpression2 = null;
            }
            KtPrefixExpression ktPrefixExpression2 = (KtPrefixExpression)ktExpression2;
            if (ktPrefixExpression2 != null && Intrinsics.areEqual((Object)(it = (ktPrefixExpression = ktPrefixExpression2)).getOperationReference().getReferencedNameElementType(), (Object)((Object)KtTokens.EXCL))) {
                KtBinaryExpression binaryExpr;
                KtExpression ktExpression3 = it.getBaseExpression();
                if (!(ktExpression3 instanceof KtParenthesizedExpression)) {
                    ktExpression3 = null;
                }
                KtParenthesizedExpression ktParenthesizedExpression = (KtParenthesizedExpression)ktExpression3;
                KtExpression ktExpression4 = ktParenthesizedExpression != null ? ktParenthesizedExpression.getExpression() : null;
                if (!(ktExpression4 instanceof KtBinaryExpression)) {
                    ktExpression4 = null;
                }
                if ((binaryExpr = (KtBinaryExpression)ktExpression4) != null && simplifyIntention.isApplicableTo(binaryExpr)) {
                    simplifyIntention.applyTo(binaryExpr);
                }
            }
            Editor editor2 = editor;
            if (editor2 == null) break block10;
            KtPrefixExpression $receiver = ktPrefixExpression = editor2;
            GenerateUtilKt.unblockDocument((Editor)$receiver);
            GenerateUtilKt.moveCaret$default((Editor)$receiver, newIf.getTextOffset(), null, 2, null);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final KtIfExpression handleStandardCase(KtIfExpression ifExpression2, KtExpression newCondition) {
        Object object;
        void $receiver$iv;
        KtPsiFactory psiFactory = KtPsiFactoryKt.KtPsiFactory$default((PsiElement)ifExpression2, false, 2, null);
        KtExpression ktExpression = ifExpression2.getThen();
        if (ktExpression == null) {
            Intrinsics.throwNpe();
        }
        KtExpression thenBranch = ktExpression;
        KtExpression ktExpression2 = ifExpression2.getElse();
        if (ktExpression2 == null) {
            ktExpression2 = psiFactory.createEmptyBody();
        }
        KtExpression elseBranch = ktExpression2;
        KtExpression newThen = elseBranch instanceof KtIfExpression ? (KtExpression)psiFactory.createSingleStatementBlock(elseBranch) : elseBranch;
        KtExpression newElse = thenBranch instanceof KtBlockExpression && ((KtBlockExpression)thenBranch).getStatements().isEmpty() ? null : thenBranch;
        PsiElement psiElement2 = (PsiElement)ifExpression2;
        PsiElement newElement$iv = (PsiElement)psiFactory.createIf(newCondition, newThen, newElse);
        PsiElement result$iv = $receiver$iv.replace(newElement$iv);
        if (result$iv instanceof KtIfExpression) {
            object = result$iv;
        } else {
            PsiElement psiElement3 = result$iv;
            if (psiElement3 == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtParenthesizedExpression");
            }
            KtExpression ktExpression3 = ((KtParenthesizedExpression)psiElement3).getExpression();
            if (ktExpression3 == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtIfExpression");
            }
            object = (KtIfExpression)ktExpression3;
        }
        return (KtIfExpression)object;
    }

    /*
     * WARNING - void declaration
     */
    private final KtIfExpression handleSpecialCases(KtIfExpression ifExpression2, KtExpression newCondition) {
        KtExpression thenBranch;
        KtExpression elseBranch = ifExpression2.getElse();
        if (elseBranch != null) {
            return null;
        }
        KtPsiFactory factory2 = KtPsiFactoryKt.KtPsiFactory$default((PsiElement)ifExpression2, false, 2, null);
        KtExpression ktExpression = ifExpression2.getThen();
        if (ktExpression == null) {
            Intrinsics.throwNpe();
        }
        KtExpression ktExpression2 = thenBranch = ktExpression;
        Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression2, (String)"thenBranch");
        KtExpression lastThenStatement = KtPsiUtilKt.lastBlockStatementOrThis(ktExpression2);
        if (UtilsKt.isExitStatement(lastThenStatement)) {
            KtBlockExpression block;
            PsiElement psiElement2 = ifExpression2.getParent();
            if (!(psiElement2 instanceof KtBlockExpression)) {
                psiElement2 = null;
            }
            if ((block = (KtBlockExpression)psiElement2) != null) {
                Object v6;
                List afterIfInBlock2;
                block20: {
                    PsiElement rBrace = block.getRBrace();
                    afterIfInBlock2 = SequencesKt.toList((Sequence)SequencesKt.takeWhile((Sequence)PsiUtilsKt.siblings$default((PsiElement)ifExpression2, false, false, 1, null), (Function1)((Function1)new Function1<PsiElement, Boolean>(rBrace){
                        final /* synthetic */ PsiElement $rBrace;

                        public final boolean invoke(@NotNull PsiElement it) {
                            Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                            return Intrinsics.areEqual((Object)it, (Object)this.$rBrace) ^ true;
                        }
                        {
                            this.$rBrace = psiElement2;
                            super(1);
                        }
                    })));
                    Iterable $receiver$iv = afterIfInBlock2;
                    Iterable iterable = $receiver$iv;
                    if (iterable instanceof List) {
                        IntProgression intProgression = RangesKt.reversed((IntProgression)((IntProgression)CollectionsKt.getIndices((Collection)((Collection)$receiver$iv))));
                        int n = intProgression.getFirst();
                        int n2 = intProgression.getLast();
                        int n3 = intProgression.getStep();
                        int n4 = n;
                        int n5 = n2;
                        if (n3 > 0 ? n4 <= n5 : n4 >= n5) {
                            while (true) {
                                void i$iv;
                                Object element$iv;
                                if ((element$iv = ((List)$receiver$iv).get((int)i$iv)) instanceof KtExpression) {
                                    v6 = element$iv;
                                    break block20;
                                }
                                if (i$iv == n2) break;
                                i$iv += n3;
                            }
                        }
                        v6 = null;
                    } else {
                        Iterable $receiver$iv$iv = CollectionsKt.reversed((Iterable)$receiver$iv);
                        for (Object element$iv$iv : $receiver$iv$iv) {
                            if (!(element$iv$iv instanceof KtExpression)) continue;
                            v6 = element$iv$iv;
                            break block20;
                        }
                        v6 = null;
                    }
                }
                KtExpression lastStatementInBlock = v6;
                if (lastStatementInBlock != null) {
                    KtExpression exitStatementAfterIf;
                    KtExpression ktExpression3 = exitStatementAfterIf = UtilsKt.isExitStatement(lastStatementInBlock) ? lastStatementInBlock : this.exitStatementExecutedAfter(lastStatementInBlock);
                    if (exitStatementAfterIf != null) {
                        KtExpression exitAfterNewIf;
                        PsiElement first = (PsiElement)CollectionsKt.first((List)afterIfInBlock2);
                        PsiElement last = (PsiElement)CollectionsKt.last((List)afterIfInBlock2);
                        PsiChildRange newThenRange = this.isEmptyReturn(lastThenStatement) && this.isEmptyReturn(lastStatementInBlock) ? PsiUtilsKt.trimWhiteSpaces(new PsiChildRange(first, lastStatementInBlock.getPrevSibling())) : PsiUtilsKt.trimWhiteSpaces(new PsiChildRange(first, last));
                        KtExpression ktExpression4 = CreateByPatternKt.createExpressionByPattern$default(factory2, "if ($0) { $1 }", new Object[]{newCondition, newThenRange}, false, 4, null);
                        if (ktExpression4 == null) {
                            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtIfExpression");
                        }
                        KtIfExpression newIf = (KtIfExpression)ktExpression4;
                        block.deleteChildRange(first, last);
                        if (this.isEmptyReturn(lastThenStatement) && block.getParent() instanceof KtDeclarationWithBody && !(block.getParent() instanceof KtFunctionLiteral)) {
                            lastThenStatement.delete();
                        }
                        KtIfExpression updatedIf = this.copyThenBranchAfter(ifExpression2);
                        if (Intrinsics.areEqual((Object)exitStatementAfterIf, (Object)lastStatementInBlock) ^ true && ((exitAfterNewIf = this.exitStatementExecutedAfter(updatedIf)) == null || !KotlinPsiUnifierKt.matches((PsiElement)exitAfterNewIf, (PsiElement)exitStatementAfterIf))) {
                            KtExpression ktExpression5 = newIf.getThen();
                            if (ktExpression5 == null) {
                                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtBlockExpression");
                            }
                            KtBlockExpression newThen = (KtBlockExpression)ktExpression5;
                            newThen.addBefore((PsiElement)exitStatementAfterIf, newThen.getRBrace());
                        }
                        PsiElement psiElement3 = updatedIf.replace((PsiElement)newIf);
                        if (psiElement3 == null) {
                            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtIfExpression");
                        }
                        return (KtIfExpression)psiElement3;
                    }
                }
            }
        }
        KtExpression ktExpression6 = this.exitStatementExecutedAfter(ifExpression2);
        if (ktExpression6 == null) {
            return null;
        }
        KtExpression exitStatement = ktExpression6;
        KtIfExpression updatedIf = this.copyThenBranchAfter(ifExpression2);
        KtExpression newIf = CreateByPatternKt.createExpressionByPattern$default(factory2, "if ($0) $1", new Object[]{newCondition, exitStatement}, false, 4, null);
        PsiElement psiElement4 = updatedIf.replace((PsiElement)newIf);
        if (psiElement4 == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtIfExpression");
        }
        return (KtIfExpression)psiElement4;
    }

    private final boolean isEmptyReturn(KtExpression statement2) {
        return statement2 instanceof KtReturnExpression && ((KtReturnExpression)statement2).getReturnedExpression() == null && ((KtReturnExpression)statement2).getLabeledExpression() == null;
    }

    private final KtIfExpression copyThenBranchAfter(KtIfExpression ifExpression2) {
        KtPsiFactory factory2 = KtPsiFactoryKt.KtPsiFactory$default((PsiElement)ifExpression2, false, 2, null);
        KtExpression ktExpression = ifExpression2.getThen();
        if (ktExpression == null) {
            return ifExpression2;
        }
        KtExpression thenBranch = ktExpression;
        PsiElement parent2 = ifExpression2.getParent();
        if (!(parent2 instanceof KtBlockExpression)) {
            Object object;
            boolean bl = parent2 instanceof KtContainerNode;
            if (_Assertions.ENABLED && !bl) {
                String string = "Assertion failed";
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
            KtBlockExpression block = factory2.createEmptyBody();
            block.addAfter((PsiElement)ifExpression2, block.getLBrace());
            PsiElement $receiver$iv = (PsiElement)ifExpression2;
            PsiElement result$iv = $receiver$iv.replace((PsiElement)block);
            if (result$iv instanceof KtBlockExpression) {
                object = result$iv;
            } else {
                PsiElement psiElement2 = result$iv;
                if (psiElement2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtParenthesizedExpression");
                }
                KtExpression ktExpression2 = ((KtParenthesizedExpression)psiElement2).getExpression();
                if (ktExpression2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtBlockExpression");
                }
                object = (KtBlockExpression)ktExpression2;
            }
            KtBlockExpression newBlock = (KtBlockExpression)object;
            List<KtExpression> list2 = newBlock.getStatements();
            Intrinsics.checkExpressionValueIsNotNull(list2, (String)"newBlock.statements");
            Object object2 = CollectionsKt.single(list2);
            if (object2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtIfExpression");
            }
            KtIfExpression newIf = (KtIfExpression)object2;
            return this.copyThenBranchAfter(newIf);
        }
        if (thenBranch instanceof KtBlockExpression) {
            PsiChildRange range = KtPsiUtilKt.contentRange((KtBlockExpression)thenBranch);
            if (!range.isEmpty()) {
                parent2.addRangeAfter(range.getFirst(), range.getLast(), (PsiElement)ifExpression2);
                parent2.addAfter(factory2.createNewLine(), (PsiElement)ifExpression2);
            }
        } else {
            parent2.addAfter((PsiElement)thenBranch, (PsiElement)ifExpression2);
            parent2.addAfter(factory2.createNewLine(), (PsiElement)ifExpression2);
        }
        return ifExpression2;
    }

    private final KtExpression exitStatementExecutedAfter(KtExpression expression2) {
        PsiElement parent2 = expression2.getParent();
        if (parent2 instanceof KtBlockExpression) {
            List<KtExpression> list2 = ((KtBlockExpression)parent2).getStatements();
            Intrinsics.checkExpressionValueIsNotNull(list2, (String)"parent.statements");
            KtExpression lastStatement = (KtExpression)CollectionsKt.last(list2);
            if (Intrinsics.areEqual((Object)expression2, (Object)lastStatement)) {
                return this.exitStatementExecutedAfter((KtExpression)parent2);
            }
            KtExpression ktExpression = lastStatement;
            Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression, (String)"lastStatement");
            if (UtilsKt.isExitStatement(ktExpression)) {
                Object element$iv2;
                block16: {
                    Sequence $receiver$iv = PsiUtilsKt.siblings$default((PsiElement)expression2, false, false, 1, null);
                    for (Object element$iv2 : $receiver$iv) {
                        if (!(element$iv2 instanceof KtExpression)) continue;
                        break block16;
                    }
                    throw (Throwable)new NoSuchElementException("No element of given type found");
                }
                if (Intrinsics.areEqual((Object)((KtExpression)element$iv2), (Object)lastStatement)) {
                    return lastStatement;
                }
            }
            return null;
        }
        PsiElement psiElement2 = parent2;
        if (psiElement2 instanceof KtNamedFunction) {
            if (Intrinsics.areEqual((Object)((KtNamedFunction)parent2).getBodyExpression(), (Object)expression2)) {
                KotlinType returnType2;
                if (!((KtNamedFunction)parent2).hasBlockBody()) {
                    return null;
                }
                DeclarationDescriptor declarationDescriptor = ResolutionUtils.resolveToDescriptorIfAny$default((KtDeclaration)parent2, null, 1, null);
                if (!(declarationDescriptor instanceof FunctionDescriptor)) {
                    declarationDescriptor = null;
                }
                FunctionDescriptor functionDescriptor2 = (FunctionDescriptor)declarationDescriptor;
                KotlinType kotlinType = returnType2 = functionDescriptor2 != null ? functionDescriptor2.getReturnType() : null;
                if (returnType2 == null || !TypeUtilsKt.isUnit(returnType2)) {
                    return null;
                }
                return KtPsiFactoryKt.KtPsiFactory$default((PsiElement)expression2, false, 2, null).createExpression("return");
            }
        } else if (psiElement2 instanceof KtContainerNode) {
            PsiElement pparent = ((KtContainerNode)parent2).getParent();
            PsiElement psiElement3 = pparent;
            if (psiElement3 instanceof KtLoopExpression) {
                if (Intrinsics.areEqual((Object)expression2, (Object)((KtLoopExpression)pparent).getBody())) {
                    return KtPsiFactoryKt.KtPsiFactory$default((PsiElement)expression2, false, 2, null).createExpression("continue");
                }
            } else if (psiElement3 instanceof KtIfExpression && (Intrinsics.areEqual((Object)expression2, (Object)((KtIfExpression)pparent).getThen()) || Intrinsics.areEqual((Object)expression2, (Object)((KtIfExpression)pparent).getElse()))) {
                return this.exitStatementExecutedAfter((KtExpression)pparent);
            }
        }
        return null;
    }

    private final PsiElement parentBlockRBrace(KtIfExpression element3) {
        PsiElement psiElement2 = element3.getParent();
        if (!(psiElement2 instanceof KtBlockExpression)) {
            psiElement2 = null;
        }
        KtBlockExpression ktBlockExpression = (KtBlockExpression)psiElement2;
        return ktBlockExpression != null ? ktBlockExpression.getRBrace() : null;
    }

    public InvertIfConditionIntention() {
        super(KtIfExpression.class, "Invert 'if' condition", null, 4, null);
    }
}

