/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.maven.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.util.xml.highlighting.DomElementAnnotationHolder;
import com.intellij.util.xml.highlighting.DomElementsInspection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.dom.model.MavenDomDependency;
import org.jetbrains.idea.maven.dom.model.MavenDomGoal;
import org.jetbrains.idea.maven.dom.model.MavenDomPlugin;
import org.jetbrains.idea.maven.dom.model.MavenDomPluginExecution;
import org.jetbrains.idea.maven.dom.model.MavenDomProjectModel;
import org.jetbrains.idea.maven.model.MavenId;
import org.jetbrains.idea.maven.model.MavenPlugin;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.utils.MavenArtifactScope;
import org.jetbrains.kotlin.idea.maven.PomFile;
import org.jetbrains.kotlin.idea.maven.configuration.KotlinMavenConfigurator;
import org.jetbrains.kotlin.idea.maven.inspections.KotlinMavenPluginPhaseInspectionKt;
import org.jetbrains.kotlin.idea.versions.KotlinRuntimeLibraryUtilKt;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0005\f\r\u000e\u000f\u0010B\u0005\u00a2\u0006\u0002\u0010\u0003J\"\u0010\u0004\u001a\u00020\u00052\u000e\u0010\u0006\u001a\n\u0012\u0004\u0012\u00020\u0002\u0018\u00010\u00072\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/idea/maven/inspections/KotlinMavenPluginPhaseInspection;", "Lcom/intellij/util/xml/highlighting/DomElementsInspection;", "Lorg/jetbrains/idea/maven/dom/model/MavenDomProjectModel;", "()V", "checkFileElement", "", "domFileElement", "Lcom/intellij/util/xml/DomFileElement;", "holder", "Lcom/intellij/util/xml/highlighting/DomElementAnnotationHolder;", "getStaticDescription", "", "AddExecutionLocalFix", "AddJavaExecutionsLocalFix", "ConfigurePluginExecutionLocalFix", "FixAddStdlibLocalFix", "FixExecutionPhaseLocalFix", "idea-maven"})
public final class KotlinMavenPluginPhaseInspection
extends DomElementsInspection<MavenDomProjectModel> {
    @NotNull
    public String getStaticDescription() {
        return "Reports kotlin-maven-plugin configuration issues";
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public void checkFileElement(@Nullable DomFileElement<MavenDomProjectModel> domFileElement, @Nullable DomElementAnnotationHolder holder) {
        if (domFileElement == null || holder == null) {
            return;
        }
        v0 = domFileElement.getModule();
        if (v0 == null) {
            return;
        }
        v1 = module = v0;
        Intrinsics.checkExpressionValueIsNotNull((Object)v1, (String)"module");
        manager = MavenProjectsManager.getInstance((Project)v1.getProject());
        v2 = manager.findProject(module);
        if (v2 == null) {
            return;
        }
        mavenProject = v2;
        v3 = domFileElement.getFile();
        Intrinsics.checkExpressionValueIsNotNull((Object)v3, (String)"domFileElement.file");
        v4 = PomFile.Companion.forFileOrNull(v3);
        if (v4 == null) {
            return;
        }
        pom = v4;
        hasJavaFiles = KotlinMavenPluginPhaseInspectionKt.hasJavaFiles(module);
        v5 = mavenProject;
        Intrinsics.checkExpressionValueIsNotNull((Object)v5, (String)"mavenProject");
        v6 = v5.getPlugins();
        Intrinsics.checkExpressionValueIsNotNull((Object)v6, (String)"mavenProject.plugins");
        var9_8 = v6;
        var10_9 = $receiver$iv;
        destination$iv$iv = new ArrayList<E>();
        for (T element$iv$iv : $receiver$iv$iv) {
            v7 = it = (MavenPlugin)element$iv$iv;
            Intrinsics.checkExpressionValueIsNotNull((Object)v7, (String)"it");
            if (!KotlinMavenPluginPhaseInspectionKt.access$isKotlinMavenPlugin(v7)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $receiver$iv = (List)destination$iv$iv;
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv = new ArrayList<E>();
        for (T element$iv$iv : $receiver$iv$iv) {
            v8 = it = (MavenPlugin)element$iv$iv;
            Intrinsics.checkExpressionValueIsNotNull((Object)v8, (String)"it");
            list$iv$iv = v8.getExecutions();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        executions = (List)destination$iv$iv;
        $receiver$iv$iv = executions;
        destination$iv = new HashSet<E>();
        for (T element$iv : $receiver$iv) {
            v9 = it = (MavenPlugin.Execution)element$iv;
            Intrinsics.checkExpressionValueIsNotNull((Object)v9, (String)"it");
            v10 = v9.getGoals();
            Intrinsics.checkExpressionValueIsNotNull((Object)v10, (String)"it.goals");
            list$iv = v10;
            CollectionsKt.addAll((Collection)destination$iv, (Iterable)list$iv);
        }
        allGoalsSet = (Set)destination$iv;
        hasJvmExecution = allGoalsSet.contains(PomFile.KotlinGoals.INSTANCE.getCompile()) != false || allGoalsSet.contains(PomFile.KotlinGoals.INSTANCE.getTestCompile()) != false;
        hasJsExecution = allGoalsSet.contains(PomFile.KotlinGoals.INSTANCE.getJs()) != false || allGoalsSet.contains(PomFile.KotlinGoals.INSTANCE.getTestJs()) != false;
        pomKotlinPlugins = pom.findKotlinPlugins();
        list$iv = pomKotlinPlugins.iterator();
        while (list$iv.hasNext()) {
            block36: {
                kotlinPlugin = (MavenDomPlugin)list$iv.next();
                if (!allGoalsSet.contains(PomFile.KotlinGoals.INSTANCE.getCompile()) && !allGoalsSet.contains(PomFile.KotlinGoals.INSTANCE.getJs())) {
                    if (hasJavaFiles) {
                        v11 = new AddExecutionLocalFix[1];
                        v12 = v11;
                        v13 = domFileElement.getFile();
                        Intrinsics.checkExpressionValueIsNotNull((Object)v13, (String)"domFileElement.file");
                        v14 = kotlinPlugin;
                        Intrinsics.checkExpressionValueIsNotNull((Object)v14, (String)"kotlinPlugin");
                        v11[0] = new AddExecutionLocalFix(v13, module, v14, PomFile.KotlinGoals.INSTANCE.getCompile());
                    } else {
                        v15 = new AddExecutionLocalFix[2];
                        v16 = domFileElement.getFile();
                        Intrinsics.checkExpressionValueIsNotNull((Object)v16, (String)"domFileElement.file");
                        v17 = kotlinPlugin;
                        Intrinsics.checkExpressionValueIsNotNull((Object)v17, (String)"kotlinPlugin");
                        v15[0] = new AddExecutionLocalFix(v16, module, v17, PomFile.KotlinGoals.INSTANCE.getCompile());
                        v12 = v15;
                        v18 = domFileElement.getFile();
                        Intrinsics.checkExpressionValueIsNotNull((Object)v18, (String)"domFileElement.file");
                        v15[1] = new AddExecutionLocalFix(v18, module, kotlinPlugin, PomFile.KotlinGoals.INSTANCE.getJs());
                    }
                    fixes = v12;
                    v19 = fixes;
                    holder.createProblem(kotlinPlugin.getArtifactId().createStableCopy(), HighlightSeverity.WARNING, "Kotlin plugin has no compile executions", Arrays.copyOf(v19, v19.length));
                    continue;
                }
                if (!hasJavaFiles) break block36;
                v20 = kotlinPlugin;
                Intrinsics.checkExpressionValueIsNotNull((Object)v20, (String)"kotlinPlugin");
                $receiver$iv = KotlinMavenPluginPhaseInspectionKt.access$notAtPhase(pom.findExecutions(v20, new String[]{PomFile.KotlinGoals.INSTANCE.getCompile()}), PomFile.DefaultPhases.INSTANCE.getProcessSources());
                for (T element$iv : $receiver$iv) {
                    block32: {
                        badExecution = (MavenDomPluginExecution)element$iv /* !! */ ;
                        javacPlugin /* !! */  = mavenProject.findPlugin("org.apache.maven.plugins", "maven-compiler-plugin");
                        v21 = pom.getDomModel().getBuild();
                        Intrinsics.checkExpressionValueIsNotNull((Object)v21, (String)"pom.domModel.build");
                        v22 = v21.getPlugins();
                        Intrinsics.checkExpressionValueIsNotNull((Object)v22, (String)"pom.domModel.build.plugins");
                        v23 = v22.getPlugins();
                        Intrinsics.checkExpressionValueIsNotNull((Object)v23, (String)"pom.domModel.build.plugins.plugins");
                        $receiver$iv = v23;
                        for (T element$iv : $receiver$iv) {
                            v24 = it = (MavenDomPlugin)element$iv;
                            Intrinsics.checkExpressionValueIsNotNull((Object)v24, (String)"it");
                            v25 = v24.getGroupId();
                            Intrinsics.checkExpressionValueIsNotNull((Object)v25, (String)"it.groupId");
                            if (!Intrinsics.areEqual((Object)v25.getStringValue(), (Object)"org.apache.maven.plugins")) ** GOTO lbl-1000
                            v26 = it.getArtifactId();
                            Intrinsics.checkExpressionValueIsNotNull((Object)v26, (String)"it.artifactId");
                            if (Intrinsics.areEqual((Object)v26.getStringValue(), (Object)"maven-compiler-plugin")) {
                                v27 = true;
                            } else lbl-1000:
                            // 2 sources

                            {
                                v27 = false;
                            }
                            if (!v27) continue;
                            v28 = element$iv;
                            break block32;
                        }
                        v28 = null;
                    }
                    if ((existingJavac /* !! */  = (MavenDomPlugin)v28) != null && pom.isPluginAfter(existingJavac /* !! */ , kotlinPlugin) && !pom.isExecutionEnabled(javacPlugin /* !! */ , "default-compile") && !pom.isExecutionEnabled(javacPlugin /* !! */ , "default-testCompile") && !pom.isPluginExecutionMissing(javacPlugin /* !! */ , "default-compile", "compile") && !pom.isPluginExecutionMissing(javacPlugin /* !! */ , "default-testCompile", "testCompile")) continue;
                    v29 = badExecution.getPhase().createStableCopy();
                    v30 = new LocalQuickFix[2];
                    v30[0] = new FixExecutionPhaseLocalFix(badExecution, PomFile.DefaultPhases.INSTANCE.getProcessSources());
                    v31 = domFileElement.getFile();
                    Intrinsics.checkExpressionValueIsNotNull((Object)v31, (String)"domFileElement.file");
                    v30[1] = new AddJavaExecutionsLocalFix(module, v31, kotlinPlugin);
                    holder.createProblem(v29, HighlightSeverity.WARNING, "Kotlin plugin should run before javac so kotlin classes could be visible from Java", v30);
                }
                $receiver$iv = pom.findExecutions(kotlinPlugin, new String[]{PomFile.KotlinGoals.INSTANCE.getJs(), PomFile.KotlinGoals.INSTANCE.getTestJs()});
                for (T element$iv : $receiver$iv) {
                    block33: {
                        v32 = badExecution = (MavenDomPluginExecution)element$iv /* !! */ ;
                        Intrinsics.checkExpressionValueIsNotNull((Object)v32, (String)"badExecution");
                        v33 = v32.getGoals();
                        Intrinsics.checkExpressionValueIsNotNull((Object)v33, (String)"badExecution.goals");
                        v34 = v33.getGoals();
                        Intrinsics.checkExpressionValueIsNotNull((Object)v34, (String)"badExecution.goals.goals");
                        javacPlugin /* !! */  = v34;
                        $receiver$iv = holder;
                        for (T element$iv : $receiver$iv) {
                            v35 = it = (MavenDomGoal)element$iv;
                            Intrinsics.checkExpressionValueIsNotNull((Object)v35, (String)"it");
                            if (!KotlinMavenPluginPhaseInspectionKt.access$isJsGoal((MavenDomGoal)v35)) continue;
                            break block33;
                        }
                        throw (Throwable)new NoSuchElementException("Collection contains no element matching the predicate.");
                    }
                    existingJavac /* !! */  = element$iv;
                    $receiver$iv.createProblem(((MavenDomGoal)existingJavac /* !! */ ).createStableCopy(), HighlightSeverity.WARNING, "JavaScript goal configured for module with Java files");
                }
            }
            stdlibDependencies = mavenProject.findDependencies(KotlinMavenConfigurator.Companion.getGROUP_ID(), KotlinRuntimeLibraryUtilKt.getMAVEN_STDLIB_ID());
            jsDependencies = mavenProject.findDependencies(KotlinMavenConfigurator.Companion.getGROUP_ID(), KotlinRuntimeLibraryUtilKt.getMAVEN_JS_STDLIB_ID());
            if (hasJvmExecution && stdlibDependencies.isEmpty()) {
                v36 = kotlinPlugin;
                Intrinsics.checkExpressionValueIsNotNull((Object)v36, (String)"kotlinPlugin");
                v37 = v36.getArtifactId().createStableCopy();
                v38 = "Kotlin JVM compiler configured but no " + KotlinRuntimeLibraryUtilKt.getMAVEN_STDLIB_ID() + " dependency";
                v39 = new LocalQuickFix[1];
                v40 = domFileElement.getFile();
                Intrinsics.checkExpressionValueIsNotNull((Object)v40, (String)"domFileElement.file");
                v41 = KotlinRuntimeLibraryUtilKt.getMAVEN_STDLIB_ID();
                v42 = kotlinPlugin.getVersion();
                Intrinsics.checkExpressionValueIsNotNull((Object)v42, (String)"kotlinPlugin.version");
                v39[0] = new FixAddStdlibLocalFix(v40, v41, v42.getRawText());
                holder.createProblem(v37, HighlightSeverity.WARNING, v38, v39);
            }
            if (!hasJsExecution || !jsDependencies.isEmpty()) continue;
            v43 = kotlinPlugin;
            Intrinsics.checkExpressionValueIsNotNull((Object)v43, (String)"kotlinPlugin");
            v44 = v43.getArtifactId().createStableCopy();
            v45 = "Kotlin JavaScript compiler configured but no " + KotlinRuntimeLibraryUtilKt.getMAVEN_JS_STDLIB_ID() + " dependency";
            v46 = new LocalQuickFix[1];
            v47 = domFileElement.getFile();
            Intrinsics.checkExpressionValueIsNotNull((Object)v47, (String)"domFileElement.file");
            v48 = KotlinRuntimeLibraryUtilKt.getMAVEN_JS_STDLIB_ID();
            v49 = kotlinPlugin.getVersion();
            Intrinsics.checkExpressionValueIsNotNull((Object)v49, (String)"kotlinPlugin.version");
            v46[0] = new FixAddStdlibLocalFix(v47, v48, v49.getRawText());
            holder.createProblem(v44, HighlightSeverity.WARNING, v45, v46);
        }
        stdlibDependencies = PomFile.findDependencies$default(pom, new MavenId(KotlinMavenConfigurator.Companion.getGROUP_ID(), KotlinRuntimeLibraryUtilKt.getMAVEN_STDLIB_ID(), null), null, 2, null);
        if (!hasJvmExecution && (list$iv = (Collection)stdlibDependencies).isEmpty() == false) {
            $receiver$iv = stdlibDependencies;
            stdlibDependencies = $receiver$iv.iterator();
            while (stdlibDependencies.hasNext()) {
                element$iv = stdlibDependencies.next();
                v50 = dep = (MavenDomDependency)element$iv;
                Intrinsics.checkExpressionValueIsNotNull((Object)v50, (String)"dep");
                v51 = v50.getArtifactId().createStableCopy();
                v52 = "You have " + dep.getArtifactId() + " configured but no corresponding plugin execution";
                v53 = new LocalQuickFix[1];
                v54 = domFileElement.getFile();
                Intrinsics.checkExpressionValueIsNotNull((Object)v54, (String)"domFileElement.file");
                v55 = PomFile.KotlinGoals.INSTANCE.getCompile();
                v56 = dep.getVersion();
                Intrinsics.checkExpressionValueIsNotNull((Object)v56, (String)"dep.version");
                v53[0] = new ConfigurePluginExecutionLocalFix(module, v54, v55, v56.getRawText());
                holder.createProblem(v51, HighlightSeverity.WARNING, v52, v53);
            }
        }
        stdlibJsDependencies = PomFile.findDependencies$default(pom, new MavenId(KotlinMavenConfigurator.Companion.getGROUP_ID(), KotlinRuntimeLibraryUtilKt.getMAVEN_JS_STDLIB_ID(), null), null, 2, null);
        if (!hasJsExecution && (stdlibDependencies = (Collection)stdlibJsDependencies).isEmpty() == false) {
            $receiver$iv = stdlibJsDependencies;
            for (T element$iv : $receiver$iv) {
                v57 = dep = (MavenDomDependency)element$iv /* !! */ ;
                Intrinsics.checkExpressionValueIsNotNull((Object)v57, (String)"dep");
                v58 = v57.getArtifactId().createStableCopy();
                v59 = "You have " + dep.getArtifactId() + " configured but no corresponding plugin execution";
                v60 = new LocalQuickFix[1];
                v61 = domFileElement.getFile();
                Intrinsics.checkExpressionValueIsNotNull((Object)v61, (String)"domFileElement.file");
                v62 = PomFile.KotlinGoals.INSTANCE.getJs();
                v63 = dep.getVersion();
                Intrinsics.checkExpressionValueIsNotNull((Object)v63, (String)"dep.version");
                v60[0] = new ConfigurePluginExecutionLocalFix(module, v61, v62, v63.getRawText());
                holder.createProblem(v58, HighlightSeverity.WARNING, v59, v60);
            }
        }
        $receiver$iv = pom.findKotlinExecutions();
        element$iv = $receiver$iv;
        destination$iv$iv = new ArrayList<E>();
        for (T element$iv$iv : $receiver$iv$iv) {
            block35: {
                block34: {
                    v64 = it = (MavenDomPluginExecution)element$iv$iv;
                    Intrinsics.checkExpressionValueIsNotNull((Object)v64, (String)"it");
                    v65 = v64.getGoals();
                    Intrinsics.checkExpressionValueIsNotNull((Object)v65, (String)"it.goals");
                    v66 = v65.getGoals();
                    Intrinsics.checkExpressionValueIsNotNull((Object)v66, (String)"it.goals.goals");
                    $receiver$iv = v66;
                    if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                        v67 = false;
                    } else {
                        for (T element$iv : $receiver$iv) {
                            v68 = it = (MavenDomGoal)element$iv;
                            Intrinsics.checkExpressionValueIsNotNull((Object)v68, (String)"it");
                            if (!(Intrinsics.areEqual((Object)v68.getRawText(), (Object)PomFile.KotlinGoals.INSTANCE.getCompile()) != false || Intrinsics.areEqual((Object)it.getRawText(), (Object)PomFile.KotlinGoals.INSTANCE.getJs()) != false)) continue;
                            v67 = true;
                            break block34;
                        }
                        v67 = false;
                    }
                }
                if (!v67) ** GOTO lbl-1000
                v69 = it.getGoals();
                Intrinsics.checkExpressionValueIsNotNull((Object)v69, (String)"it.goals");
                v70 = v69.getGoals();
                Intrinsics.checkExpressionValueIsNotNull((Object)v70, (String)"it.goals.goals");
                $receiver$iv = v70;
                if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                    v71 = false;
                } else {
                    for (T element$iv : $receiver$iv) {
                        v72 = it = (MavenDomGoal)element$iv;
                        Intrinsics.checkExpressionValueIsNotNull((Object)v72, (String)"it");
                        if (!(Intrinsics.areEqual((Object)v72.getRawText(), (Object)PomFile.KotlinGoals.INSTANCE.getTestCompile()) != false || Intrinsics.areEqual((Object)it.getRawText(), (Object)PomFile.KotlinGoals.INSTANCE.getTestJs()) != false)) continue;
                        v71 = true;
                        break block35;
                    }
                    v71 = false;
                }
            }
            if (v71) {
                v73 = true;
            } else lbl-1000:
            // 2 sources

            {
                v73 = false;
            }
            if (!v73) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $receiver$iv = (List)destination$iv$iv;
        for (T element$iv : $receiver$iv) {
            v74 = badExecution = (MavenDomPluginExecution)element$iv /* !! */ ;
            Intrinsics.checkExpressionValueIsNotNull((Object)v74, (String)"badExecution");
            holder.createProblem(v74.getGoals().createStableCopy(), HighlightSeverity.WEAK_WARNING, "It is not recommended to have both test and compile goals in the same execution");
        }
    }

    public KotlinMavenPluginPhaseInspection() {
        super(MavenDomProjectModel.class, new Class[0]);
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\b\u0010\u0019\u001a\u00020\tH\u0016J\b\u0010\u001a\u001a\u00020\tH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/kotlin/idea/maven/inspections/KotlinMavenPluginPhaseInspection$AddExecutionLocalFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "file", "Lcom/intellij/psi/xml/XmlFile;", "module", "Lcom/intellij/openapi/module/Module;", "kotlinPlugin", "Lorg/jetbrains/idea/maven/dom/model/MavenDomPlugin;", "goal", "", "(Lcom/intellij/psi/xml/XmlFile;Lcom/intellij/openapi/module/Module;Lorg/jetbrains/idea/maven/dom/model/MavenDomPlugin;Ljava/lang/String;)V", "getFile", "()Lcom/intellij/psi/xml/XmlFile;", "getGoal", "()Ljava/lang/String;", "getKotlinPlugin", "()Lorg/jetbrains/idea/maven/dom/model/MavenDomPlugin;", "getModule", "()Lcom/intellij/openapi/module/Module;", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "getFamilyName", "getName", "idea-maven"})
    private static final class AddExecutionLocalFix
    implements LocalQuickFix {
        @NotNull
        private final XmlFile file;
        @NotNull
        private final Module module;
        @NotNull
        private final MavenDomPlugin kotlinPlugin;
        @NotNull
        private final String goal;

        @NotNull
        public String getName() {
            return "Create " + this.goal + " execution";
        }

        @NotNull
        public String getFamilyName() {
            return "Create kotlin execution";
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
            block0: {
                Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
                Intrinsics.checkParameterIsNotNull((Object)descriptor2, (String)"descriptor");
                PomFile pomFile = PomFile.Companion.forFileOrNull(this.file);
                if (pomFile == null) break block0;
                pomFile.addKotlinExecution(this.module, this.kotlinPlugin, this.goal, PomFile.Companion.getPhase(KotlinMavenPluginPhaseInspectionKt.hasJavaFiles(this.module), false), false, CollectionsKt.listOf((Object)this.goal));
            }
        }

        @NotNull
        public final XmlFile getFile() {
            return this.file;
        }

        @NotNull
        public final Module getModule() {
            return this.module;
        }

        @NotNull
        public final MavenDomPlugin getKotlinPlugin() {
            return this.kotlinPlugin;
        }

        @NotNull
        public final String getGoal() {
            return this.goal;
        }

        public AddExecutionLocalFix(@NotNull XmlFile file2, @NotNull Module module, @NotNull MavenDomPlugin kotlinPlugin, @NotNull String goal) {
            Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
            Intrinsics.checkParameterIsNotNull((Object)module, (String)"module");
            Intrinsics.checkParameterIsNotNull((Object)kotlinPlugin, (String)"kotlinPlugin");
            Intrinsics.checkParameterIsNotNull((Object)goal, (String)"goal");
            this.file = file2;
            this.module = module;
            this.kotlinPlugin = kotlinPlugin;
            this.goal = goal;
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u0005H\u0016J\b\u0010\u0012\u001a\u00020\u0005H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/idea/maven/inspections/KotlinMavenPluginPhaseInspection$FixExecutionPhaseLocalFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "execution", "Lorg/jetbrains/idea/maven/dom/model/MavenDomPluginExecution;", "newPhase", "", "(Lorg/jetbrains/idea/maven/dom/model/MavenDomPluginExecution;Ljava/lang/String;)V", "getExecution", "()Lorg/jetbrains/idea/maven/dom/model/MavenDomPluginExecution;", "getNewPhase", "()Ljava/lang/String;", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "getFamilyName", "getName", "idea-maven"})
    private static final class FixExecutionPhaseLocalFix
    implements LocalQuickFix {
        @NotNull
        private final MavenDomPluginExecution execution;
        @NotNull
        private final String newPhase;

        @NotNull
        public String getName() {
            return "Change phase to " + this.newPhase;
        }

        @NotNull
        public String getFamilyName() {
            return "Change phase";
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            Intrinsics.checkParameterIsNotNull((Object)descriptor2, (String)"descriptor");
            GenericDomValue genericDomValue = this.execution.getPhase();
            Intrinsics.checkExpressionValueIsNotNull((Object)genericDomValue, (String)"execution.phase");
            genericDomValue.setValue((Object)this.newPhase);
        }

        @NotNull
        public final MavenDomPluginExecution getExecution() {
            return this.execution;
        }

        @NotNull
        public final String getNewPhase() {
            return this.newPhase;
        }

        public FixExecutionPhaseLocalFix(@NotNull MavenDomPluginExecution execution, @NotNull String newPhase) {
            Intrinsics.checkParameterIsNotNull((Object)execution, (String)"execution");
            Intrinsics.checkParameterIsNotNull((Object)newPhase, (String)"newPhase");
            this.execution = execution;
            this.newPhase = newPhase;
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\b\u0010\u0017\u001a\u00020\u0016H\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/idea/maven/inspections/KotlinMavenPluginPhaseInspection$AddJavaExecutionsLocalFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "module", "Lcom/intellij/openapi/module/Module;", "file", "Lcom/intellij/psi/xml/XmlFile;", "kotlinPlugin", "Lorg/jetbrains/idea/maven/dom/model/MavenDomPlugin;", "(Lcom/intellij/openapi/module/Module;Lcom/intellij/psi/xml/XmlFile;Lorg/jetbrains/idea/maven/dom/model/MavenDomPlugin;)V", "getFile", "()Lcom/intellij/psi/xml/XmlFile;", "getKotlinPlugin", "()Lorg/jetbrains/idea/maven/dom/model/MavenDomPlugin;", "getModule", "()Lcom/intellij/openapi/module/Module;", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "getFamilyName", "", "getName", "idea-maven"})
    private static final class AddJavaExecutionsLocalFix
    implements LocalQuickFix {
        @NotNull
        private final Module module;
        @NotNull
        private final XmlFile file;
        @NotNull
        private final MavenDomPlugin kotlinPlugin;

        @NotNull
        public String getName() {
            return "Configure maven-compiler-plugin executions in the right order";
        }

        @NotNull
        public String getFamilyName() {
            return this.getName();
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
            block0: {
                Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
                Intrinsics.checkParameterIsNotNull((Object)descriptor2, (String)"descriptor");
                PomFile pomFile = PomFile.Companion.forFileOrNull(this.file);
                if (pomFile == null) break block0;
                pomFile.addJavacExecutions(this.module, this.kotlinPlugin);
            }
        }

        @NotNull
        public final Module getModule() {
            return this.module;
        }

        @NotNull
        public final XmlFile getFile() {
            return this.file;
        }

        @NotNull
        public final MavenDomPlugin getKotlinPlugin() {
            return this.kotlinPlugin;
        }

        public AddJavaExecutionsLocalFix(@NotNull Module module, @NotNull XmlFile file2, @NotNull MavenDomPlugin kotlinPlugin) {
            Intrinsics.checkParameterIsNotNull((Object)module, (String)"module");
            Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
            Intrinsics.checkParameterIsNotNull((Object)kotlinPlugin, (String)"kotlinPlugin");
            this.module = module;
            this.file = file2;
            this.kotlinPlugin = kotlinPlugin;
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0007J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0005H\u0016J\b\u0010\u0014\u001a\u00020\u0005H\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\t\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/idea/maven/inspections/KotlinMavenPluginPhaseInspection$FixAddStdlibLocalFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "pomFile", "Lcom/intellij/psi/xml/XmlFile;", "id", "", "version", "(Lcom/intellij/psi/xml/XmlFile;Ljava/lang/String;Ljava/lang/String;)V", "getId", "()Ljava/lang/String;", "getPomFile", "()Lcom/intellij/psi/xml/XmlFile;", "getVersion", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "getFamilyName", "getName", "idea-maven"})
    private static final class FixAddStdlibLocalFix
    implements LocalQuickFix {
        @NotNull
        private final XmlFile pomFile;
        @NotNull
        private final String id;
        @Nullable
        private final String version;

        @NotNull
        public String getName() {
            return "Add " + this.id + " dependency";
        }

        @NotNull
        public String getFamilyName() {
            return "Add dependency";
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
            block0: {
                Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
                Intrinsics.checkParameterIsNotNull((Object)descriptor2, (String)"descriptor");
                PomFile pomFile = PomFile.Companion.forFileOrNull(this.pomFile);
                if (pomFile == null) break block0;
                PomFile.addDependency$default(pomFile, new MavenId(KotlinMavenConfigurator.Companion.getGROUP_ID(), this.id, this.version), MavenArtifactScope.COMPILE, null, false, null, 28, null);
            }
        }

        @NotNull
        public final XmlFile getPomFile() {
            return this.pomFile;
        }

        @NotNull
        public final String getId() {
            return this.id;
        }

        @Nullable
        public final String getVersion() {
            return this.version;
        }

        public FixAddStdlibLocalFix(@NotNull XmlFile pomFile, @NotNull String id, @Nullable String version) {
            Intrinsics.checkParameterIsNotNull((Object)pomFile, (String)"pomFile");
            Intrinsics.checkParameterIsNotNull((Object)id, (String)"id");
            this.pomFile = pomFile;
            this.id = id;
            this.version = version;
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\tJ\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\b\u0010\u0017\u001a\u00020\u0007H\u0016J\b\u0010\u0018\u001a\u00020\u0007H\u0016R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0013\u0010\b\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/idea/maven/inspections/KotlinMavenPluginPhaseInspection$ConfigurePluginExecutionLocalFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "module", "Lcom/intellij/openapi/module/Module;", "xmlFile", "Lcom/intellij/psi/xml/XmlFile;", "goal", "", "version", "(Lcom/intellij/openapi/module/Module;Lcom/intellij/psi/xml/XmlFile;Ljava/lang/String;Ljava/lang/String;)V", "getGoal", "()Ljava/lang/String;", "getModule", "()Lcom/intellij/openapi/module/Module;", "getVersion", "getXmlFile", "()Lcom/intellij/psi/xml/XmlFile;", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "getFamilyName", "getName", "idea-maven"})
    private static final class ConfigurePluginExecutionLocalFix
    implements LocalQuickFix {
        @NotNull
        private final Module module;
        @NotNull
        private final XmlFile xmlFile;
        @NotNull
        private final String goal;
        @Nullable
        private final String version;

        @NotNull
        public String getName() {
            return "Create " + this.goal + " execution of kotlin-maven-compiler";
        }

        @NotNull
        public String getFamilyName() {
            return "Create kotlin execution";
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
            block0: {
                PomFile pomFile;
                Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
                Intrinsics.checkParameterIsNotNull((Object)descriptor2, (String)"descriptor");
                PomFile pomFile2 = PomFile.Companion.forFileOrNull(this.xmlFile);
                if (pomFile2 == null) break block0;
                PomFile pom = pomFile = pomFile2;
                MavenDomPlugin plugin = pom.addKotlinPlugin(this.version);
                pom.addKotlinExecution(this.module, plugin, "compile", PomFile.Companion.getPhase(KotlinMavenPluginPhaseInspectionKt.hasJavaFiles(this.module), false), false, CollectionsKt.listOf((Object)this.goal));
            }
        }

        @NotNull
        public final Module getModule() {
            return this.module;
        }

        @NotNull
        public final XmlFile getXmlFile() {
            return this.xmlFile;
        }

        @NotNull
        public final String getGoal() {
            return this.goal;
        }

        @Nullable
        public final String getVersion() {
            return this.version;
        }

        public ConfigurePluginExecutionLocalFix(@NotNull Module module, @NotNull XmlFile xmlFile, @NotNull String goal, @Nullable String version) {
            Intrinsics.checkParameterIsNotNull((Object)module, (String)"module");
            Intrinsics.checkParameterIsNotNull((Object)xmlFile, (String)"xmlFile");
            Intrinsics.checkParameterIsNotNull((Object)goal, (String)"goal");
            this.module = module;
            this.xmlFile = xmlFile;
            this.goal = goal;
            this.version = version;
        }
    }
}

