/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.nodejs.protractor;

import com.intellij.execution.Executor;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.LocatableConfigurationBase;
import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.interpreter.local.NodeJsLocalInterpreter;
import com.intellij.javascript.nodejs.util.NodePackage;
import com.intellij.javascript.protractor.ProtractorUtil;
import com.intellij.openapi.project.Project;
import com.intellij.util.PathUtil;
import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.nodejs.protractor.KotlinProtractorRunConfigurationEditor;
import org.jetbrains.kotlin.idea.nodejs.protractor.KotlinProtractorRunSettings;
import org.jetbrains.kotlin.idea.nodejs.protractor.KotlinProtractorRunState;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\u0018\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0006\u0010\u001d\u001a\u00020\u0014J\u0010\u0010\u001e\u001a\u00020\u00142\u0006\u0010\u001f\u001a\u00020 H\u0016J\n\u0010!\u001a\u0004\u0018\u00010\u0007H\u0016J*\u0010\"\u001a\u00020\u00142\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010#\u001a\u0004\u0018\u00010\u00072\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020%H\u0002J\u0010\u0010'\u001a\u00020\u00142\u0006\u0010\u001f\u001a\u00020 H\u0016R\u0011\u0010\t\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u001a\u0010\r\u001a\u00020\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012\u00a8\u0006("}, d2={"Lorg/jetbrains/kotlin/idea/nodejs/protractor/KotlinProtractorRunConfiguration;", "Lcom/intellij/execution/configurations/LocatableConfigurationBase;", "project", "Lcom/intellij/openapi/project/Project;", "factory", "Lcom/intellij/execution/configurations/ConfigurationFactory;", "name", "", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/execution/configurations/ConfigurationFactory;Ljava/lang/String;)V", "protractorPackage", "Lcom/intellij/javascript/nodejs/util/NodePackage;", "getProtractorPackage", "()Lcom/intellij/javascript/nodejs/util/NodePackage;", "runSettings", "Lorg/jetbrains/kotlin/idea/nodejs/protractor/KotlinProtractorRunSettings;", "getRunSettings", "()Lorg/jetbrains/kotlin/idea/nodejs/protractor/KotlinProtractorRunSettings;", "setRunSettings", "(Lorg/jetbrains/kotlin/idea/nodejs/protractor/KotlinProtractorRunSettings;)V", "checkConfiguration", "", "getConfigurationEditor", "Lorg/jetbrains/kotlin/idea/nodejs/protractor/KotlinProtractorRunConfigurationEditor;", "getState", "Lorg/jetbrains/kotlin/idea/nodejs/protractor/KotlinProtractorRunState;", "executor", "Lcom/intellij/execution/Executor;", "environment", "Lcom/intellij/execution/runners/ExecutionEnvironment;", "initialize", "readExternal", "element", "Lorg/jdom/Element;", "suggestedName", "validatePath", "path", "shouldBeAbsolute", "", "shouldBeDirectory", "writeExternal", "ultimate"})
public final class KotlinProtractorRunConfiguration
extends LocatableConfigurationBase {
    @NotNull
    private KotlinProtractorRunSettings runSettings;

    @NotNull
    public final KotlinProtractorRunSettings getRunSettings() {
        return this.runSettings;
    }

    public final void setRunSettings(@NotNull KotlinProtractorRunSettings kotlinProtractorRunSettings) {
        Intrinsics.checkParameterIsNotNull((Object)kotlinProtractorRunSettings, (String)"<set-?>");
        this.runSettings = kotlinProtractorRunSettings;
    }

    @NotNull
    public final NodePackage getProtractorPackage() {
        Project project = this.getProject();
        NodeJsInterpreter interpreter = this.runSettings.getInterpreterRef().resolve(project);
        NodePackage nodePackage = ProtractorUtil.getProtractorPackage((Project)project, null, (NodeJsInterpreter)interpreter, (boolean)true);
        Intrinsics.checkExpressionValueIsNotNull((Object)nodePackage, (String)"ProtractorUtil.getProtra\u2026 null, interpreter, true)");
        return nodePackage;
    }

    @NotNull
    public KotlinProtractorRunState getState(@NotNull Executor executor, @NotNull ExecutionEnvironment environment) {
        Intrinsics.checkParameterIsNotNull((Object)executor, (String)"executor");
        Intrinsics.checkParameterIsNotNull((Object)environment, (String)"environment");
        return new KotlinProtractorRunState(this, environment, this.getProtractorPackage());
    }

    @NotNull
    public KotlinProtractorRunConfigurationEditor getConfigurationEditor() {
        Project project = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"project");
        return new KotlinProtractorRunConfigurationEditor(project);
    }

    public void readExternal(@NotNull Element element3) {
        Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
        super.readExternal(element3);
        this.runSettings = KotlinProtractorRunSettings.Companion.readFromXML(element3);
    }

    public void writeExternal(@NotNull Element element3) {
        Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
        super.writeExternal(element3);
        this.runSettings.writeToXML(element3);
    }

    public final void initialize() {
        this.setNameChangedByUser(false);
    }

    public void checkConfiguration() {
        block6: {
            block5: {
                boolean isOptionalConfig;
                String string = this.runSettings.getTestFileSystemDependentPath();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"runSettings.testFileSystemDependentPath");
                CharSequence charSequence = string;
                boolean bl = !StringsKt.isBlank((CharSequence)charSequence) || !StringsKt.isBlank((CharSequence)(charSequence = (CharSequence)this.runSettings.getSeleniumAddress())) ? true : (isOptionalConfig = false);
                if (isOptionalConfig) {
                    this.validatePath("test file", this.runSettings.getTestFileSystemDependentPath(), true, false);
                    if (StringsKt.isBlank((CharSequence)this.runSettings.getSeleniumAddress())) {
                        throw (Throwable)new RuntimeConfigurationError("Unspecified Selenium address");
                    }
                }
                if (!isOptionalConfig) break block5;
                String string2 = this.runSettings.getConfigFileSystemDependentPath();
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"runSettings.configFileSystemDependentPath");
                charSequence = string2;
                if (!(!StringsKt.isBlank((CharSequence)charSequence))) break block6;
            }
            this.validatePath("configuration file", this.runSettings.getConfigFileSystemDependentPath(), true, false);
        }
        NodeJsInterpreter interpreter = this.runSettings.getInterpreterRef().resolve(this.getProject());
        NodeJsLocalInterpreter.checkForRunConfiguration((NodeJsInterpreter)interpreter);
        this.validatePath("protractor package", this.getProtractorPackage().getSystemDependentPath(), true, true);
    }

    @Nullable
    public String suggestedName() {
        String name2;
        String string = name2 = PathUtil.getFileName((String)this.runSettings.getTestFileSystemDependentPath());
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"name");
        CharSequence charSequence = string;
        return !StringsKt.isBlank((CharSequence)charSequence) ? name2 : null;
    }

    private final void validatePath(String name2, String path, boolean shouldBeAbsolute, boolean shouldBeDirectory) {
        boolean exists;
        CharSequence charSequence = path;
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
            throw (Throwable)new RuntimeConfigurationError("Unspecified " + name2);
        }
        String string = path;
        if (string == null) {
            Intrinsics.throwNpe();
        }
        File file2 = new File(string);
        if (shouldBeAbsolute && !file2.isAbsolute()) {
            throw (Throwable)new RuntimeConfigurationError("No such " + name2);
        }
        boolean bl = exists = shouldBeDirectory ? file2.isDirectory() : file2.isFile();
        if (!exists) {
            throw (Throwable)new RuntimeConfigurationError("No such " + name2);
        }
    }

    public KotlinProtractorRunConfiguration(@NotNull Project project, @NotNull ConfigurationFactory factory2, @NotNull String name2) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)factory2, (String)"factory");
        Intrinsics.checkParameterIsNotNull((Object)name2, (String)"name");
        super(project, factory2, name2);
        this.runSettings = new KotlinProtractorRunSettings(null, null, null, null, null, null, 63, null);
    }
}

