/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.run;

import com.intellij.execution.JavaRunConfigurationExtensionManager;
import com.intellij.execution.Location;
import com.intellij.execution.PsiLocation;
import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.actions.ConfigurationFromContext;
import com.intellij.execution.configurations.JavaRunConfigurationModule;
import com.intellij.execution.configurations.ModuleBasedConfiguration;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.junit.InheritorChooser;
import com.intellij.execution.junit2.info.MethodLocation;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.util.PsiClassUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.theoryinpractice.testng.configuration.TestNGConfiguration;
import com.theoryinpractice.testng.configuration.TestNGConfigurationProducer;
import com.theoryinpractice.testng.util.TestNGUtil;
import java.util.List;
import kotlin.collections.CollectionsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.asJava.LightClassUtilsKt;
import org.jetbrains.kotlin.asJava.classes.KtLightClass;
import org.jetbrains.kotlin.idea.project.TargetPlatformDetector;
import org.jetbrains.kotlin.idea.util.ProjectRootsUtil;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.resolve.jvm.platform.JvmPlatform;

public class KotlinTestNgConfigurationProducer
extends TestNGConfigurationProducer {
    public boolean shouldReplace(ConfigurationFromContext self, ConfigurationFromContext other) {
        return other.isProducedBy(TestNGConfigurationProducer.class);
    }

    protected boolean setupConfigurationFromContext(TestNGConfiguration configuration2, ConfigurationContext context, Ref<PsiElement> sourceElement) {
        KtLightClass delegate;
        KtNamedFunction function2;
        KtElement owner;
        Location location2 = context.getLocation();
        if (location2 == null) {
            return false;
        }
        Project project = context.getProject();
        PsiElement leaf = location2.getPsiElement();
        if (!ProjectRootsUtil.isInProjectOrLibSource(leaf)) {
            return false;
        }
        if (!(leaf.getContainingFile() instanceof KtFile)) {
            return false;
        }
        KtFile ktFile = (KtFile)leaf.getContainingFile();
        if (TargetPlatformDetector.getPlatform(ktFile) != JvmPlatform.INSTANCE) {
            return false;
        }
        KtNamedDeclaration declarationToRun = KotlinTestNgConfigurationProducer.getDeclarationToRun(leaf);
        if (declarationToRun instanceof KtNamedFunction && (owner = (KtElement)PsiTreeUtil.getParentOfType((PsiElement)(function2 = (KtNamedFunction)declarationToRun), (Class[])new Class[]{KtFunction.class, KtClass.class})) instanceof KtClass && (delegate = LightClassUtilsKt.toLightClass((KtClass)owner)) != null) {
            for (PsiMethod method : delegate.getMethods()) {
                if (method.getNavigationElement() != function2) continue;
                if (!TestNGUtil.hasTest((PsiModifierListOwner)method)) break;
                return this.configure(configuration2, location2, context, project, delegate, method);
            }
        }
        if (declarationToRun instanceof KtClass) {
            KtLightClass delegate2 = LightClassUtilsKt.toLightClass((KtClassOrObject)declarationToRun);
            if (!KotlinTestNgConfigurationProducer.isTestNGClass(delegate2)) {
                return false;
            }
            return this.configure(configuration2, location2, context, project, delegate2, null);
        }
        return false;
    }

    public void onFirstRun(ConfigurationFromContext configuration2, ConfigurationContext context, Runnable startRunnable) {
        KtNamedDeclaration declarationToRun = KotlinTestNgConfigurationProducer.getDeclarationToRun(configuration2.getSourceElement());
        final PsiNamedElement lightElement = (PsiNamedElement)CollectionsKt.firstOrNull(LightClassUtilsKt.toLightElements(declarationToRun));
        if (lightElement instanceof PsiMethod || lightElement instanceof PsiClass) {
            PsiClass containingClass;
            PsiMethod psiMethod;
            if (lightElement instanceof PsiMethod) {
                psiMethod = (PsiMethod)lightElement;
                containingClass = psiMethod.getContainingClass();
            } else {
                psiMethod = null;
                containingClass = (PsiClass)lightElement;
            }
            InheritorChooser inheritorChooser = new InheritorChooser(){

                protected void runForClasses(List<PsiClass> classes2, PsiMethod method, ConfigurationContext context, Runnable performRunnable) {
                    ((TestNGConfiguration)context.getConfiguration().getConfiguration()).bePatternConfiguration(classes2, method);
                    super.runForClasses(classes2, method, context, performRunnable);
                }

                protected void runForClass(PsiClass aClass2, PsiMethod psiMethod, ConfigurationContext context, Runnable performRunnable) {
                    if (lightElement instanceof PsiMethod) {
                        Project project = psiMethod.getProject();
                        MethodLocation methodLocation = new MethodLocation(project, psiMethod, PsiLocation.fromPsiElement((PsiElement)aClass2));
                        ((TestNGConfiguration)context.getConfiguration().getConfiguration()).setMethodConfiguration((Location)methodLocation);
                    } else {
                        ((TestNGConfiguration)context.getConfiguration().getConfiguration()).setClassConfiguration(aClass2);
                    }
                    super.runForClass(aClass2, psiMethod, context, performRunnable);
                }
            };
            if (inheritorChooser.runMethodInAbstractClass(context, startRunnable, psiMethod, containingClass, (Condition)new Condition<PsiClass>(){

                public boolean value(PsiClass aClass2) {
                    return aClass2.hasModifierProperty("abstract") && TestNGUtil.hasTest((PsiModifierListOwner)aClass2);
                }
            })) {
                return;
            }
        }
        super.onFirstRun(configuration2, context, startRunnable);
    }

    @Nullable
    private static KtNamedDeclaration getDeclarationToRun(@NotNull PsiElement leaf) {
        if (!(leaf.getContainingFile() instanceof KtFile)) {
            return null;
        }
        KtFile jetFile = (KtFile)leaf.getContainingFile();
        KtNamedFunction function2 = (KtNamedFunction)PsiTreeUtil.getParentOfType((PsiElement)leaf, KtNamedFunction.class, (boolean)false);
        if (function2 != null) {
            return function2;
        }
        KtClass ktClass2 = (KtClass)PsiTreeUtil.getParentOfType((PsiElement)leaf, KtClass.class, (boolean)false);
        if (ktClass2 != null) {
            return ktClass2;
        }
        return KotlinTestNgConfigurationProducer.getClassDeclarationInFile(jetFile);
    }

    private boolean configure(TestNGConfiguration configuration2, Location location2, ConfigurationContext context, Project project, @Nullable PsiClass delegate, @Nullable PsiMethod method) {
        if (delegate == null) {
            return false;
        }
        this.setupConfigurationModule(context, (ModuleBasedConfiguration)configuration2);
        Module originalModule = ((JavaRunConfigurationModule)configuration2.getConfigurationModule()).getModule();
        configuration2.setClassConfiguration(delegate);
        if (method != null) {
            configuration2.setMethodConfiguration(PsiLocation.fromPsiElement((Project)project, (PsiElement)method));
        }
        configuration2.restoreOriginalModule(originalModule);
        configuration2.setName(configuration2.getName());
        JavaRunConfigurationExtensionManager.getInstance().extendCreatedConfiguration((RunConfigurationBase)configuration2, location2);
        return true;
    }

    private static boolean isTestNGClass(PsiClass psiClass2) {
        return psiClass2 != null && PsiClassUtil.isRunnableClass((PsiClass)psiClass2, (boolean)true, (boolean)false) && TestNGUtil.hasTest((PsiModifierListOwner)psiClass2);
    }

    @Nullable
    static KtClass getClassDeclarationInFile(KtFile jetFile) {
        KtClass tempSingleDeclaration = null;
        for (KtDeclaration ktDeclaration : jetFile.getDeclarations()) {
            if (!(ktDeclaration instanceof KtClass)) continue;
            KtClass declaration2 = (KtClass)ktDeclaration;
            if (tempSingleDeclaration == null) {
                tempSingleDeclaration = declaration2;
                continue;
            }
            return null;
        }
        return tempSingleDeclaration;
    }
}

