/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.search.ideaExtensions;

import com.intellij.openapi.application.QueryExecutorBase;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.cache.TodoCacheManager;
import com.intellij.psi.search.IndexPattern;
import com.intellij.psi.search.IndexPatternOccurrence;
import com.intellij.psi.search.IndexPatternProvider;
import com.intellij.psi.search.searches.IndexPatternSearch;
import com.intellij.util.Processor;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.search.ideaExtensions.KotlinTodoOccurrence;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtTreeVisitorVoid;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0005\u00a2\u0006\u0002\u0010\u0004J\u001e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00032\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/idea/search/ideaExtensions/KotlinTodoSearcher;", "Lcom/intellij/openapi/application/QueryExecutorBase;", "Lcom/intellij/psi/search/IndexPatternOccurrence;", "Lcom/intellij/psi/search/searches/IndexPatternSearch$SearchParameters;", "()V", "processQuery", "", "queryParameters", "consumer", "Lcom/intellij/util/Processor;", "idea"})
public final class KotlinTodoSearcher
extends QueryExecutorBase<IndexPatternOccurrence, IndexPatternSearch.SearchParameters> {
    /*
     * WARNING - void declaration
     */
    public void processQuery(@NotNull IndexPatternSearch.SearchParameters queryParameters, @NotNull Processor<IndexPatternOccurrence> consumer2) {
        int count;
        PsiFile file2;
        void pattern;
        Intrinsics.checkParameterIsNotNull((Object)queryParameters, (String)"queryParameters");
        Intrinsics.checkParameterIsNotNull(consumer2, (String)"consumer");
        Ref.ObjectRef objectRef = new Ref.ObjectRef();
        objectRef.element = queryParameters.getPattern();
        if ((IndexPattern)pattern.element != null) {
            String string = ((IndexPattern)pattern.element).getPatternString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"pattern.patternString");
            if (!StringsKt.contains((CharSequence)string, (CharSequence)"TODO", (boolean)true)) {
                return;
            }
        }
        if ((IndexPattern)pattern.element == null) {
            Object v5;
            block6: {
                void $receiver$iv;
                IndexPatternProvider indexPatternProvider = queryParameters.getPatternProvider();
                Intrinsics.checkExpressionValueIsNotNull((Object)indexPatternProvider, (String)"queryParameters.patternProvider");
                IndexPattern[] indexPatternArray = indexPatternProvider.getIndexPatterns();
                Intrinsics.checkExpressionValueIsNotNull((Object)indexPatternArray, (String)"queryParameters.patternProvider.indexPatterns");
                Object[] objectArray = indexPatternArray;
                void var11_5 = pattern;
                for (void element$iv : $receiver$iv) {
                    IndexPattern it;
                    IndexPattern indexPattern = it = (IndexPattern)element$iv;
                    Intrinsics.checkExpressionValueIsNotNull((Object)indexPattern, (String)"it");
                    String string = indexPattern.getPatternString();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"it.patternString");
                    if (!StringsKt.contains((CharSequence)string, (CharSequence)"TODO", (boolean)true)) continue;
                    v5 = element$iv;
                    break block6;
                }
                v5 = null;
            }
            Object var12_13 = v5;
            IndexPattern indexPattern = var12_13;
            if (indexPattern == null) {
                return;
            }
            var11_5.element = indexPattern;
        }
        PsiFile psiFile = file2 = queryParameters.getFile();
        Intrinsics.checkExpressionValueIsNotNull((Object)psiFile, (String)"file");
        TodoCacheManager cacheManager = TodoCacheManager.SERVICE.getInstance((Project)psiFile.getProject());
        IndexPatternProvider patternProvider = queryParameters.getPatternProvider();
        int n = count = patternProvider != null ? cacheManager.getTodoCount(file2.getVirtualFile(), patternProvider) : cacheManager.getTodoCount(file2.getVirtualFile(), (IndexPattern)pattern.element);
        if (count == 0) {
            return;
        }
        file2.accept((PsiElementVisitor)new KtTreeVisitorVoid(consumer2, file2, (Ref.ObjectRef)pattern){
            final /* synthetic */ Processor $consumer;
            final /* synthetic */ PsiFile $file;
            final /* synthetic */ Ref.ObjectRef $pattern;

            public void visitCallExpression(@NotNull KtCallExpression expression2) {
                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                super.visitCallExpression(expression2);
                KtExpression ktExpression = expression2.getCalleeExpression();
                if (Intrinsics.areEqual((Object)(ktExpression != null ? ktExpression.getText() : null), (Object)"TODO")) {
                    PsiFile psiFile = this.$file;
                    Intrinsics.checkExpressionValueIsNotNull((Object)psiFile, (String)"file");
                    TextRange textRange = expression2.getTextRange();
                    Intrinsics.checkExpressionValueIsNotNull((Object)textRange, (String)"expression.textRange");
                    this.$consumer.process((Object)new KotlinTodoOccurrence(psiFile, textRange, (IndexPattern)this.$pattern.element));
                }
            }
            {
                this.$consumer = $captured_local_variable$0;
                this.$file = $captured_local_variable$1;
                this.$pattern = $captured_local_variable$2;
            }
        });
    }

    public KotlinTodoSearcher() {
        super(true);
    }
}

