/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.psi.stubs.elements;

import com.intellij.psi.PsiElement;
import com.intellij.psi.stubs.IndexSink;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.stubs.StubInputStream;
import com.intellij.psi.stubs.StubOutputStream;
import com.intellij.util.io.StringRef;
import java.io.IOException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.stubs.KotlinFunctionStub;
import org.jetbrains.kotlin.psi.stubs.elements.KtStubElementType;
import org.jetbrains.kotlin.psi.stubs.elements.StubIndexService;
import org.jetbrains.kotlin.psi.stubs.impl.KotlinFunctionStubImpl;
import org.jetbrains.kotlin.resolve.lazy.ResolveSessionUtils;

public class KtFunctionElementType
extends KtStubElementType<KotlinFunctionStub, KtNamedFunction> {
    public KtFunctionElementType(@NotNull @NonNls String debugName) {
        super(debugName, KtNamedFunction.class, KotlinFunctionStub.class);
    }

    public KotlinFunctionStub createStub(@NotNull KtNamedFunction psi2, @NotNull StubElement parentStub) {
        boolean isTopLevel = psi2.getParent() instanceof KtFile;
        boolean isExtension = psi2.getReceiverTypeReference() != null;
        FqName fqName2 = ResolveSessionUtils.safeFqNameForLazyResolve(psi2);
        boolean hasBlockBody = psi2.hasBlockBody();
        boolean hasBody = psi2.hasBody();
        return new KotlinFunctionStubImpl((StubElement<? extends PsiElement>)parentStub, StringRef.fromString((String)psi2.getName()), isTopLevel, fqName2, isExtension, hasBlockBody, hasBody, psi2.hasTypeParameterListBeforeFunctionName());
    }

    public void serialize(@NotNull KotlinFunctionStub stub, @NotNull StubOutputStream dataStream) throws IOException {
        dataStream.writeName(stub.getName());
        dataStream.writeBoolean(stub.isTopLevel());
        FqName fqName2 = stub.getFqName();
        dataStream.writeName(fqName2 != null ? fqName2.asString() : null);
        dataStream.writeBoolean(stub.isExtension());
        dataStream.writeBoolean(stub.hasBlockBody());
        dataStream.writeBoolean(stub.hasBody());
        dataStream.writeBoolean(stub.hasTypeParameterListBeforeFunctionName());
    }

    @NotNull
    public KotlinFunctionStub deserialize(@NotNull StubInputStream dataStream, StubElement parentStub) throws IOException {
        StringRef name2 = dataStream.readName();
        boolean isTopLevel = dataStream.readBoolean();
        StringRef fqNameAsString = dataStream.readName();
        FqName fqName2 = fqNameAsString != null ? new FqName(fqNameAsString.toString()) : null;
        boolean isExtension = dataStream.readBoolean();
        boolean hasBlockBody = dataStream.readBoolean();
        boolean hasBody = dataStream.readBoolean();
        boolean hasTypeParameterListBeforeFunctionName = dataStream.readBoolean();
        return new KotlinFunctionStubImpl((StubElement<? extends PsiElement>)parentStub, name2, isTopLevel, fqName2, isExtension, hasBlockBody, hasBody, hasTypeParameterListBeforeFunctionName);
    }

    @Override
    public void indexStub(@NotNull KotlinFunctionStub stub, @NotNull IndexSink sink) {
        StubIndexService.getInstance().indexFunction(stub, sink);
    }
}

