/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.components;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.resolve.calls.components.ArgumentsUtilsKt;
import org.jetbrains.kotlin.resolve.calls.model.ExpressionKotlinCallArgument;
import org.jetbrains.kotlin.resolve.calls.model.KotlinCallArgument;
import org.jetbrains.kotlin.resolve.calls.model.KotlinCallDiagnostic;
import org.jetbrains.kotlin.resolve.calls.model.KotlinDiagnosticsHolder;
import org.jetbrains.kotlin.resolve.calls.model.ResolutionCandidateKt;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCallArgument;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCallAtom;
import org.jetbrains.kotlin.resolve.calls.model.SimpleKotlinCallArgument;
import org.jetbrains.kotlin.resolve.calls.model.SmartCastDiagnostic;
import org.jetbrains.kotlin.resolve.calls.model.UnsafeCallError;
import org.jetbrains.kotlin.resolve.calls.model.UnstableSmartCast;
import org.jetbrains.kotlin.types.UnwrappedType;
import org.jetbrains.kotlin.types.checker.KotlinTypeChecker;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\"\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J,\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014J4\u0010\u0016\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\u0017\u001a\u0004\u0018\u00010\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014H\u0002J.\u0010\u001b\u001a\u00020\u000e2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/kotlin/resolve/calls/components/AdditionalDiagnosticReporter;", "", "languageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "(Lorg/jetbrains/kotlin/config/LanguageVersionSettings;)V", "createSmartCastDiagnostic", "Lorg/jetbrains/kotlin/resolve/calls/model/SmartCastDiagnostic;", "candidate", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCallAtom;", "argument", "Lorg/jetbrains/kotlin/resolve/calls/model/KotlinCallArgument;", "expectedResultType", "Lorg/jetbrains/kotlin/types/UnwrappedType;", "reportAdditionalDiagnostics", "", "resultingDescriptor", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "kotlinDiagnosticsHolder", "Lorg/jetbrains/kotlin/resolve/calls/model/KotlinDiagnosticsHolder;", "diagnostics", "", "Lorg/jetbrains/kotlin/resolve/calls/model/KotlinCallDiagnostic;", "reportSmartCastOnReceiver", "receiver", "Lorg/jetbrains/kotlin/resolve/calls/model/SimpleKotlinCallArgument;", "parameter", "Lorg/jetbrains/kotlin/descriptors/ReceiverParameterDescriptor;", "reportSmartCasts", "resolution"})
public final class AdditionalDiagnosticReporter {
    private final LanguageVersionSettings languageVersionSettings;

    public final void reportAdditionalDiagnostics(@NotNull ResolvedCallAtom candidate, @NotNull CallableDescriptor resultingDescriptor, @NotNull KotlinDiagnosticsHolder kotlinDiagnosticsHolder, @NotNull Collection<? extends KotlinCallDiagnostic> diagnostics2) {
        Intrinsics.checkParameterIsNotNull((Object)candidate, (String)"candidate");
        Intrinsics.checkParameterIsNotNull((Object)resultingDescriptor, (String)"resultingDescriptor");
        Intrinsics.checkParameterIsNotNull((Object)kotlinDiagnosticsHolder, (String)"kotlinDiagnosticsHolder");
        Intrinsics.checkParameterIsNotNull(diagnostics2, (String)"diagnostics");
        this.reportSmartCasts(candidate, resultingDescriptor, kotlinDiagnosticsHolder, diagnostics2);
    }

    private final SmartCastDiagnostic createSmartCastDiagnostic(ResolvedCallAtom candidate, KotlinCallArgument argument2, UnwrappedType expectedResultType) {
        if (!(argument2 instanceof ExpressionKotlinCallArgument)) {
            return null;
        }
        if (!KotlinTypeChecker.DEFAULT.isSubtypeOf(((ExpressionKotlinCallArgument)argument2).getReceiver().getReceiverValue().getType(), expectedResultType)) {
            return new SmartCastDiagnostic((ExpressionKotlinCallArgument)argument2, expectedResultType.unwrap(), candidate.getAtom());
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final SmartCastDiagnostic reportSmartCastOnReceiver(ResolvedCallAtom candidate, SimpleKotlinCallArgument receiver, ReceiverParameterDescriptor parameter, Collection<? extends KotlinCallDiagnostic> diagnostics2) {
        boolean bl;
        Object it;
        boolean bl2;
        Iterable $receiver$iv$iv;
        SmartCastDiagnostic smartCastDiagnostic;
        SmartCastDiagnostic smartCastDiagnostic2;
        UnwrappedType unwrappedType2;
        if (receiver == null) return null;
        if (parameter == null) {
            return null;
        }
        UnwrappedType it2 = unwrappedType2 = parameter.getType().unwrap();
        UnwrappedType expectedType2 = receiver.isSafeCall() ? it2.makeNullableAsSpecified(true) : it2;
        SmartCastDiagnostic smartCastDiagnostic3 = this.createSmartCastDiagnostic(candidate, receiver, expectedType2);
        if (smartCastDiagnostic3 == null) return null;
        SmartCastDiagnostic it3 = smartCastDiagnostic2 = (smartCastDiagnostic = smartCastDiagnostic3);
        Iterable $receiver$iv = diagnostics2;
        Iterable iterable = $receiver$iv;
        Collection collection = new ArrayList();
        Iterator iterator2 = $receiver$iv$iv.iterator();
        while (iterator2.hasNext()) {
            Object t = iterator2.next();
            if (!(t instanceof UnsafeCallError)) continue;
            collection.add(t);
        }
        $receiver$iv = (List)collection;
        if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
            bl2 = true;
        } else {
            for (Object t : $receiver$iv) {
                it = (UnsafeCallError)t;
                if (!Intrinsics.areEqual((Object)((UnsafeCallError)it).getReceiver(), (Object)receiver)) continue;
                return null;
            }
            bl2 = true;
        }
        if (!bl2) return null;
        $receiver$iv = diagnostics2;
        $receiver$iv$iv = $receiver$iv;
        Collection collection2 = new ArrayList();
        it = $receiver$iv$iv.iterator();
        while (it.hasNext()) {
            Object e = it.next();
            if (!(e instanceof UnstableSmartCast)) continue;
            collection2.add(e);
        }
        $receiver$iv = (List)collection2;
        if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
            bl = true;
        } else {
            for (Object e : $receiver$iv) {
                it = (UnstableSmartCast)e;
                if (!Intrinsics.areEqual((Object)((UnstableSmartCast)it).getArgument(), (Object)receiver)) continue;
                return null;
            }
            bl = true;
        }
        if (!bl) return null;
        boolean bl3 = true;
        if (!bl3) return null;
        SmartCastDiagnostic smartCastDiagnostic4 = smartCastDiagnostic2;
        return smartCastDiagnostic4;
    }

    /*
     * WARNING - void declaration
     */
    private final void reportSmartCasts(ResolvedCallAtom candidate, CallableDescriptor resultingDescriptor, KotlinDiagnosticsHolder kotlinDiagnosticsHolder, Collection<? extends KotlinCallDiagnostic> diagnostics2) {
        ResolutionCandidateKt.addDiagnosticIfNotNull(kotlinDiagnosticsHolder, this.reportSmartCastOnReceiver(candidate, candidate.getExtensionReceiverArgument(), resultingDescriptor.getExtensionReceiverParameter(), diagnostics2));
        ResolutionCandidateKt.addDiagnosticIfNotNull(kotlinDiagnosticsHolder, this.reportSmartCastOnReceiver(candidate, candidate.getDispatchReceiverArgument(), resultingDescriptor.getDispatchReceiverParameter(), diagnostics2));
        for (ValueParameterDescriptor parameter : resultingDescriptor.getValueParameters()) {
            Map<ValueParameterDescriptor, ResolvedCallArgument> map2 = candidate.getArgumentMappingByOriginal();
            ValueParameterDescriptor valueParameterDescriptor = parameter;
            Intrinsics.checkExpressionValueIsNotNull((Object)valueParameterDescriptor, (String)"parameter");
            Object object = map2.get(valueParameterDescriptor.getOriginal());
            if (object == null || (object = ((ResolvedCallArgument)object).getArguments()) == null) {
                continue;
            }
            Iterator iterator2 = object.iterator();
            while (iterator2.hasNext()) {
                SmartCastDiagnostic smartCastDiagnostic;
                boolean thereIsUnstableSmartCastError;
                boolean bl;
                block8: {
                    void $receiver$iv$iv;
                    UnwrappedType effectiveExpectedType;
                    KotlinCallArgument argument2 = (KotlinCallArgument)iterator2.next();
                    if (this.createSmartCastDiagnostic(candidate, argument2, effectiveExpectedType = ArgumentsUtilsKt.getExpectedType(argument2, parameter, this.languageVersionSettings)) == null) {
                        continue;
                    }
                    Iterable $receiver$iv = diagnostics2;
                    Iterable iterable = $receiver$iv;
                    Collection destination$iv$iv = new ArrayList();
                    for (Object element$iv$iv : $receiver$iv$iv) {
                        if (!(element$iv$iv instanceof UnstableSmartCast)) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    $receiver$iv = (List)destination$iv$iv;
                    if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv : $receiver$iv) {
                            UnstableSmartCast it = (UnstableSmartCast)element$iv;
                            if (!Intrinsics.areEqual((Object)it.getArgument(), (Object)argument2)) continue;
                            bl = true;
                            break block8;
                        }
                        bl = false;
                    }
                }
                if (thereIsUnstableSmartCastError = bl) continue;
                kotlinDiagnosticsHolder.addDiagnostic(smartCastDiagnostic);
            }
        }
    }

    public AdditionalDiagnosticReporter(@NotNull LanguageVersionSettings languageVersionSettings) {
        Intrinsics.checkParameterIsNotNull((Object)languageVersionSettings, (String)"languageVersionSettings");
        this.languageVersionSettings = languageVersionSettings;
    }
}

