/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jam.view.treetable;

import com.intellij.ide.util.treeView.AbstractTreeBuilder;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.jam.view.tree.JamAbstractTreeBuilder;
import com.intellij.jam.view.tree.JamNodeDescriptor;
import com.intellij.jam.view.treetable.JamSpacerColumnInfo;
import com.intellij.jam.view.treetable.JamToolTipRenderer;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.ui.JBColor;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.dualView.TreeTableView;
import com.intellij.ui.treeStructure.SimpleNode;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.ui.treeStructure.treetable.ListTreeTableModelOnColumns;
import com.intellij.ui.treeStructure.treetable.TreeTable;
import com.intellij.ui.treeStructure.treetable.TreeTableCellRenderer;
import com.intellij.ui.treeStructure.treetable.TreeTableModel;
import com.intellij.ui.treeStructure.treetable.TreeTableTree;
import com.intellij.util.EditSourceOnDoubleClickHandler;
import com.intellij.util.PlatformIcons;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.SoftArrayHashMap;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.tree.TreeUtil;
import com.intellij.util.xml.ui.CommittablePanel;
import com.intellij.util.xml.ui.EmptyPane;
import com.intellij.util.xml.ui.StripeTableCellRenderer;
import com.intellij.xml.util.XmlStringUtil;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class JamTreeTableView
implements CommittablePanel,
DataProvider {
    private static final DefaultTableCellRenderer LOADING_NODE_RENDERER = new DefaultTableCellRenderer(){

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component cellRendererComponent = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            this.setText("");
            return cellRendererComponent;
        }
    };
    @NonNls
    private static final String TREE = "tree";
    @NonNls
    private static final String EMPTY = "empty";
    private final CardLayout myCardLayout;
    private final JPanel myContentPanel = new JPanel();
    private final EmptyPane myEmptyPane = new EmptyPane("If you see this text, please, submit a bug");
    private final JPanel myPanel = new PanelToViewDataDelegator();
    private final TreeTableView myTreeTableView;
    private final JamAbstractTreeBuilder myBuilder;
    private final Project myProject;
    private final JamNodeDescriptor myRootDescriptor;
    private final ListTreeTableModelOnColumns myModel;
    private final SoftArrayHashMap<Object, List<Object>> myCache = new SoftArrayHashMap();
    private boolean myTreeShowing = false;

    public JamTreeTableView(Project project, JamNodeDescriptor rootDescriptor) {
        this.myProject = project;
        this.myRootDescriptor = rootDescriptor;
        DefaultMutableTreeNode rootNode = new DefaultMutableTreeNode();
        this.myModel = new ListTreeTableModelOnColumns(rootNode, ColumnInfo.EMPTY_ARRAY){

            public boolean isCellEditable(Object node, int column) {
                try {
                    return super.isCellEditable((Object)JamTreeTableView.getJamNodeDescriptor(node), column);
                }
                catch (LoadingNodeException e) {
                    return false;
                }
            }

            public void setValueAt(Object aValue, Object node, int column) {
                try {
                    ColumnInfo columnInfo = this.getColumnInfos()[column];
                    JamNodeDescriptor descriptor = JamTreeTableView.getJamNodeDescriptor(node);
                    if (descriptor == null) {
                        return;
                    }
                    Object[] path = ((DefaultMutableTreeNode)node).getUserObjectPath();
                    JamTreeTableView.this.getCachedColumnValues(path).set(column, aValue);
                    JamTreeTableView.this.setValueAt(columnInfo, descriptor, aValue);
                }
                catch (LoadingNodeException loadingNodeException) {
                    // empty catch block
                }
            }

            public Object getValueAt(Object value, int column) {
                Object[] path = ((DefaultMutableTreeNode)value).getUserObjectPath();
                return JamTreeTableView.this.getCachedColumnValues(path).get(column);
            }
        };
        this.myTreeTableView = new MyTreeTableView(this.myModel);
        this.myTreeTableView.setVisible(this.myTreeShowing);
        this.myBuilder = new JamAbstractTreeBuilder(project, (JTree)this.getTree(), (DefaultTreeModel)this.myModel, (SimpleNode)rootDescriptor){

            protected boolean updateNodeDescriptor(@NotNull NodeDescriptor descriptor) {
                if (descriptor == null) {
                    3.$$$reportNull$$$0(0);
                }
                boolean result = super.updateNodeDescriptor(descriptor);
                if ((!descriptor.equals(JamTreeTableView.this.myRootDescriptor) || this.getTree().isRootVisible()) && ((JamNodeDescriptor)descriptor).isValid()) {
                    JamTreeTableView.this.cacheNode((JamNodeDescriptor)descriptor);
                }
                return result;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/jam/view/treetable/JamTreeTableView$3", "updateNodeDescriptor"));
            }
        };
        Disposer.register((Disposable)this, (Disposable)this.myBuilder);
        this.myTreeTableView.setDragEnabled(false);
        this.myTreeTableView.getSelectionModel().setSelectionMode(0);
        this.myTreeTableView.setRowHeight(PlatformIcons.CLASS_ICON.getIconHeight());
        JTableHeader header = this.myTreeTableView.getTableHeader();
        header.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                JamTreeTableView.this.updateTooltip(e);
            }
        });
        header.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                JamTreeTableView.this.updateTooltip(e);
            }
        });
        header.setReorderingAllowed(false);
        this.getTree().setShowsRootHandles(true);
        UIUtil.setLineStyleAngled((JTree)this.getTree());
        this.getTree().setCellRenderer((TreeCellRenderer)((Object)new JamToolTipRenderer()));
        this.getTree().getSelectionModel().setSelectionMode(1);
        EditSourceOnDoubleClickHandler.install((TreeTable)this.myTreeTableView);
        this.myBuilder.init();
        this.myPanel.setLayout(new BorderLayout());
        this.myPanel.add((Component)this.myContentPanel, "Center");
        this.myCardLayout = new CardLayout();
        this.myContentPanel.setLayout(this.myCardLayout);
        this.myContentPanel.add((Component)this.myEmptyPane.getComponent(), EMPTY);
        this.myContentPanel.add((Component)ScrollPaneFactory.createScrollPane((Component)this.myTreeTableView), TREE);
    }

    protected final void updateTooltip(MouseEvent e) {
        int i = this.myTreeTableView.columnAtPoint(e.getPoint());
        if (i >= 0) {
            this.myTreeTableView.getTableHeader().setToolTipText(this.getColumnInfos()[i].getTooltipText());
        }
    }

    protected void setValueAt(ColumnInfo columnInfo, JamNodeDescriptor descriptor, Object aValue) {
        columnInfo.setValue((Object)descriptor, aValue);
    }

    protected final void init() {
        ActionGroup actionGroup;
        JComponent toolbar = this.createToolbar();
        if (toolbar != null) {
            this.myPanel.add((Component)toolbar, "North");
        }
        if ((actionGroup = this.createActionGroup(true)) != null) {
            PopupHandler.installPopupHandler((JComponent)this.myEmptyPane.getComponent(), (ActionGroup)actionGroup, (String)"J2EEAttributesViewPopup", (ActionManager)ActionManager.getInstance());
            PopupHandler.installPopupHandler((JComponent)this.myTreeTableView, (ActionGroup)actionGroup, (String)"J2EEAttributesViewPopup", (ActionManager)ActionManager.getInstance());
        }
        this.reset();
        TreeUtil.expandAll((JTree)this.getTree());
    }

    public final TreeTableView getTreeTableView() {
        return this.myTreeTableView;
    }

    public final Project getProject() {
        return this.myProject;
    }

    public final Tree getTree() {
        return this.myTreeTableView.getTree();
    }

    public final ActionCallback refreshTreeTable() {
        ActionCallback result;
        boolean visibilityChanged;
        boolean showTree = this.isShowTree();
        boolean bl = visibilityChanged = showTree != this.myTreeShowing;
        if (visibilityChanged || showTree) {
            TreePath[] selection = this.myTreeTableView.getTree().getSelectionPaths();
            this.cacheValues();
            result = this.myBuilder.queueUpdate();
            result.doWhenDone(() -> {
                this.myTreeTableView.getSelectionModel().clearSelection();
                if (selection != null) {
                    for (TreePath treePath : selection) {
                        int row = this.myTreeTableView.getTree().getRowForPath(treePath);
                        this.myTreeTableView.getSelectionModel().addSelectionInterval(row, row);
                    }
                }
                this.myTreeTableView.revalidate();
                this.myTreeTableView.repaint();
            });
        } else {
            result = ActionCallback.DONE;
        }
        if (!showTree) {
            this.myEmptyPane.setText(XmlStringUtil.wrapInHtml((CharSequence)this.getEmptyPaneText()));
        }
        if (visibilityChanged) {
            this.myTreeShowing = showTree;
            this.myTreeTableView.setVisible(this.myTreeShowing);
            if (showTree) {
                this.myCardLayout.show(this.myContentPanel, TREE);
            } else {
                this.myCardLayout.show(this.myContentPanel, EMPTY);
            }
            IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus((Component)this.myContentPanel, true));
        }
        return result;
    }

    protected void setColumnsPreferredWidth() {
        ColumnInfo[] columnInfos = this.getColumnInfos();
        TableColumnModel columnModel = this.myTreeTableView.getColumnModel();
        JTableHeader header = this.myTreeTableView.getTableHeader();
        FontMetrics fontMetrics = header.getFontMetrics(header.getFont());
        int maxPreferredWidth = 0;
        for (int i = 0; i < columnInfos.length; ++i) {
            int preferredWidth;
            ColumnInfo columnInfo = columnInfos[i];
            TableColumn column = columnModel.getColumn(i);
            String name = columnInfo.getName();
            int minWidth = StringUtil.isNotEmpty((String)name.trim()) ? fontMetrics.stringWidth(name) + 15 : 0;
            column.setMinWidth(minWidth);
            if (TreeTableModel.class.isAssignableFrom(columnInfo.getColumnClass())) {
                TreeTableTree tree = this.myTreeTableView.getTree();
                tree.setPreferredSize(null);
                preferredWidth = tree.getPreferredSize().width;
                column.setPreferredWidth(preferredWidth);
                if (preferredWidth > minWidth) {
                    column.setMinWidth(preferredWidth);
                }
            } else if (!(columnInfo instanceof JamSpacerColumnInfo)) {
                int fixedWidth = columnInfo.getWidth((JTable)this.myTreeTableView);
                if (fixedWidth > 0) {
                    int realWidth = Math.max(minWidth, fixedWidth);
                    column.setMaxWidth(realWidth);
                    column.setMinWidth(realWidth);
                    column.setPreferredWidth(realWidth);
                } else {
                    preferredWidth = minWidth;
                    String preferredValue = columnInfo.getPreferredStringValue();
                    if (preferredValue != null) {
                        preferredWidth = Math.max(preferredWidth, fontMetrics.stringWidth(preferredValue));
                    }
                    column.setPreferredWidth(preferredWidth + columnInfo.getAdditionalWidth());
                    String maxValue = columnInfo.getMaxStringValue();
                    if (maxValue != null) {
                        column.setMaxWidth(fontMetrics.stringWidth(preferredValue) + columnInfo.getAdditionalWidth());
                    }
                }
            }
            maxPreferredWidth = Math.max(maxPreferredWidth, column.getPreferredWidth());
        }
    }

    @Nullable
    protected ActionGroup createActionGroup(boolean isPopup) {
        return isPopup ? this.createPopupActionGroup() : this.createToolbarActions();
    }

    @Nullable
    protected ActionGroup createPopupActionGroup() {
        return null;
    }

    @Nullable
    protected ActionGroup createToolbarActions() {
        return null;
    }

    @Nullable
    protected JComponent createToolbar() {
        ActionGroup actionGroup = this.createActionGroup(false);
        if (actionGroup == null) {
            return null;
        }
        JComponent component = ActionManager.getInstance().createActionToolbar("ProjectViewToolbar", actionGroup, true).getComponent();
        component.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, (Color)JBColor.darkGray), component.getBorder()));
        return component;
    }

    public void dispose() {
    }

    public JComponent getComponent() {
        return this.myPanel;
    }

    public void reset() {
        boolean columnsChanged = this.myModel.setColumns(this.createColumnInfos());
        this.refreshTreeTable().doWhenDone(() -> {
            AbstractTableModel tableModel = (AbstractTableModel)this.myTreeTableView.getModel();
            if (columnsChanged) {
                tableModel.fireTableStructureChanged();
                this.setColumnsPreferredWidth();
            }
            if (this.myTreeShowing) {
                tableModel.fireTableDataChanged();
            }
        });
    }

    public void commit() {
    }

    protected void cacheValues() {
    }

    protected void recacheColumn(int columnIndex) {
        assert (columnIndex >= 0 && columnIndex < this.getColumnInfos().length);
        ColumnInfo columnInfo = this.getColumnInfos()[columnIndex];
        this.myCache.processLeafEntries((o, objects) -> {
            objects.set(columnIndex, columnInfo.valueOf(o));
            return true;
        });
    }

    private static JamNodeDescriptor getJamNodeDescriptor(Object nodeDescriptor) throws LoadingNodeException {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)nodeDescriptor;
        if (AbstractTreeBuilder.isLoadingNode((DefaultMutableTreeNode)node)) {
            throw new LoadingNodeException();
        }
        return (JamNodeDescriptor)node.getUserObject();
    }

    protected final void setCachedValue(Object value, int column, Object ... path) {
        Object[] path1 = this.getDescriptorPath(path);
        if (path1 == null) {
            return;
        }
        this.getCachedColumnValues(path1).set(column, value);
    }

    private static JamNodeDescriptor[] getDescriptorPath(JamNodeDescriptor descriptor) {
        LinkedList<JamNodeDescriptor> list = new LinkedList<JamNodeDescriptor>();
        while (descriptor != null) {
            list.addFirst(descriptor);
            descriptor = (JamNodeDescriptor)descriptor.getParent();
        }
        return list.toArray(new JamNodeDescriptor[list.size()]);
    }

    @Nullable
    private JamNodeDescriptor[] getDescriptorPath(Object ... path) {
        assert (JamTreeTableView.corresponds(this.myRootDescriptor, path[0]));
        JamNodeDescriptor[] result = new JamNodeDescriptor[path.length];
        result[0] = this.myRootDescriptor;
        DefaultMutableTreeNode parent = this.myBuilder.getRootNode();
        for (int i = 1; i < path.length; ++i) {
            DefaultMutableTreeNode treeNode;
            Object pathElement = path[i];
            DefaultMutableTreeNode defaultMutableTreeNode = treeNode = parent == null ? null : this.myBuilder.getNodeForElement(pathElement);
            if (treeNode == null || !parent.equals(treeNode.getParent())) {
                result[i] = (JamNodeDescriptor)ContainerUtil.find((Object[])result[i - 1].getChildren(), object -> object instanceof JamNodeDescriptor && JamTreeTableView.corresponds((JamNodeDescriptor)object, pathElement));
                parent = treeNode;
            } else {
                result[i] = (JamNodeDescriptor)treeNode.getUserObject();
                parent = null;
            }
            if (result[i] != null) continue;
            return null;
        }
        return result;
    }

    private static boolean corresponds(JamNodeDescriptor object, Object pathElement) {
        return Comparing.equal((Object)object.getElement(), (Object)pathElement);
    }

    private List<Object> getCachedColumnValues(@NotNull Object[] path) {
        ArrayList<Object> result;
        if (path == null) {
            JamTreeTableView.$$$reportNull$$$0(0);
        }
        if ((result = (ArrayList<Object>)this.myCache.get(path)) == null) {
            result = new ArrayList<Object>(this.getEmptyColumnValues());
            this.myCache.put(path, result);
        }
        return result;
    }

    protected void cacheNode(JamNodeDescriptor node) {
        Object[] path = JamTreeTableView.getDescriptorPath(node);
        this.myCache.put(path, this.getColumnValues(node));
    }

    private List<Object> getColumnValues(JamNodeDescriptor descriptor) {
        return ContainerUtil.map2List((Object[])this.getColumnInfos(), s -> s.valueOf((Object)descriptor));
    }

    protected List<Object> getEmptyColumnValues() {
        return Arrays.asList(new Object[this.getColumnInfos().length]);
    }

    protected ColumnInfo[] getColumnInfos() {
        return this.myModel.getColumnInfos();
    }

    protected abstract boolean isShowTree();

    @NotNull
    protected String getEmptyPaneText() {
        if ("" == null) {
            JamTreeTableView.$$$reportNull$$$0(1);
        }
        return "";
    }

    protected abstract ColumnInfo[] createColumnInfos();

    @Nullable
    private Object getSelectedElement() {
        NodeDescriptor descriptor = this.getSelectedDescriptor();
        return descriptor == null ? null : descriptor.getElement();
    }

    @Nullable
    public final NodeDescriptor getSelectedDescriptor() {
        Object lastPathComponent;
        TreePath path = this.getSelectedPath();
        if (path != null && (lastPathComponent = path.getLastPathComponent()) instanceof DefaultMutableTreeNode) {
            try {
                return JamTreeTableView.getJamNodeDescriptor(lastPathComponent);
            }
            catch (LoadingNodeException loadingNodeException) {
                // empty catch block
            }
        }
        return null;
    }

    @NotNull
    public JamAbstractTreeBuilder getTreeBuilder() {
        JamAbstractTreeBuilder jamAbstractTreeBuilder = this.myBuilder;
        if (jamAbstractTreeBuilder == null) {
            JamTreeTableView.$$$reportNull$$$0(2);
        }
        return jamAbstractTreeBuilder;
    }

    @Nullable
    private TreePath getSelectedPath() {
        TreePath[] paths = this.getTree() == null ? null : this.getTree().getSelectionPaths();
        return paths != null && paths.length == 1 ? paths[0] : null;
    }

    public Object getData(String dataId) {
        if (CommonDataKeys.PSI_ELEMENT.is(dataId)) {
            Object element = this.getSelectedElement();
            return element instanceof PsiElement && ((PsiElement)element).isValid() ? element : null;
        }
        if (CommonDataKeys.PSI_FILE.is(dataId)) {
            Object element = this.getSelectedElement();
            return element instanceof PsiFile ? element : null;
        }
        if (CommonDataKeys.PROJECT.is(dataId)) {
            return this.myProject;
        }
        NodeDescriptor descriptor = this.getSelectedDescriptor();
        if (descriptor instanceof JamNodeDescriptor) {
            return ((JamNodeDescriptor)descriptor).getDataForElement(dataId);
        }
        return null;
    }

    protected void setCachedValues(Object value, Collection<Integer> columns, Object ... url) {
        for (int column : columns) {
            this.setCachedValue(value, column, url);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/jam/view/treetable/JamTreeTableView";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/jam/view/treetable/JamTreeTableView";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getEmptyPaneText";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getTreeBuilder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getCachedColumnValues";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyTreeTableView
    extends TreeTableView {
        public MyTreeTableView(ListTreeTableModelOnColumns model) {
            super(model);
        }

        public TreeTableCellRenderer createTableRenderer(TreeTableModel treeTableModel) {
            final TreeTableCellRenderer tableRenderer = super.createTableRenderer(treeTableModel);
            tableRenderer.setDefaultBorder(null);
            final TreeTableTree tree = this.getTree();
            return new TreeTableCellRenderer((TreeTable)this, tree){

                public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                    Component component1 = tableRenderer.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                    tree.setCellFocused(true);
                    return component1;
                }
            };
        }

        protected final Object getRowElement(int row) {
            try {
                return JamTreeTableView.getJamNodeDescriptor(super.getRowElement(row));
            }
            catch (LoadingNodeException e) {
                return null;
            }
        }

        public void setSize(int width, int height) {
            super.setSize(width, height);
        }

        public TableCellRenderer getCellRenderer(int row, int column) {
            try {
                JamNodeDescriptor node = JamTreeTableView.getJamNodeDescriptor(super.getRowElement(row));
                return this.getColumnInfo(column).getCustomizedRenderer((Object)node, (TableCellRenderer)new StripeTableCellRenderer(super.getCellRenderer(row, column)));
            }
            catch (LoadingNodeException e) {
                return LOADING_NODE_RENDERER;
            }
        }
    }

    private class PanelToViewDataDelegator
    extends JPanel
    implements DataProvider {
        private PanelToViewDataDelegator() {
        }

        public Object getData(String dataId) {
            return JamTreeTableView.this.getData(dataId);
        }
    }

    private static class LoadingNodeException
    extends Exception {
        private LoadingNodeException() {
        }
    }
}

