/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.artifact;

import com.intellij.facet.Facet;
import com.intellij.facet.FacetTypeId;
import com.intellij.facet.pointers.FacetPointersManager;
import com.intellij.javaee.artifact.JavaeeArtifactUtil;
import com.intellij.javaee.facet.JavaeeFacet;
import com.intellij.javaee.facet.JavaeeFacetType;
import com.intellij.javaee.ui.packaging.EarArtifactType;
import com.intellij.javaee.ui.packaging.EjbJarArtifactType;
import com.intellij.javaee.ui.packaging.ExplodedEarArtifactType;
import com.intellij.javaee.ui.packaging.ExplodedEjbArtifactType;
import com.intellij.javaee.ui.packaging.ExplodedWarArtifactType;
import com.intellij.javaee.ui.packaging.JavaeeArtifactTypeBase;
import com.intellij.javaee.ui.packaging.JavaeeFacetResourcesElementType;
import com.intellij.javaee.ui.packaging.JavaeeFacetResourcesPackagingElement;
import com.intellij.javaee.ui.packaging.WarArtifactType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.MultiValuesMap;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.artifacts.ArtifactManager;
import com.intellij.packaging.artifacts.ArtifactType;
import com.intellij.packaging.elements.ComplexPackagingElement;
import com.intellij.packaging.elements.PackagingElement;
import com.intellij.packaging.elements.PackagingElementFactory;
import com.intellij.packaging.elements.PackagingElementResolvingContext;
import com.intellij.packaging.elements.PackagingElementType;
import com.intellij.packaging.impl.artifacts.ArtifactUtil;
import com.intellij.packaging.impl.artifacts.PackagingElementPath;
import com.intellij.packaging.impl.artifacts.PackagingElementProcessor;
import com.intellij.packaging.impl.elements.ArtifactPackagingElement;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaeeArtifactUtilImpl
extends JavaeeArtifactUtil {
    private static final Key<CachedValue<MultiValuesMap<FacetTypeId<?>, JavaeeFacet>>> FACETS_INCLUDED_IN_ARTIFACT_KEY = Key.create((String)"included_javaee_facets");
    private static final Key<Map<Pair<? extends Collection<? extends ArtifactType>, Boolean>, CachedValue<Collection<Artifact>>>> ARTIFACTS_CONTAINING_FACET_KEY = Key.create((String)"artifacts_containing_facet");

    public Collection<? extends ArtifactType> getAllJavaeeArtifactTypes() {
        return Arrays.asList(new JavaeeArtifactTypeBase[]{ExplodedWarArtifactType.getInstance(), WarArtifactType.getInstance(), ExplodedEjbArtifactType.getInstance(), EjbJarArtifactType.getInstance(), ExplodedEarArtifactType.getInstance(), EarArtifactType.getInstance()});
    }

    public ExplodedEarArtifactType getExplodedEarArtifactType() {
        return ExplodedEarArtifactType.getInstance();
    }

    public ExplodedEjbArtifactType getExplodedEjbArtifactType() {
        return ExplodedEjbArtifactType.getInstance();
    }

    public EarArtifactType getEarArtifactType() {
        return EarArtifactType.getInstance();
    }

    public EjbJarArtifactType getEjbJarArtifactType() {
        return EjbJarArtifactType.getInstance();
    }

    public PackagingElement<?> createFacetResourcesElement(@NotNull JavaeeFacet facet) {
        if (facet == null) {
            JavaeeArtifactUtilImpl.$$$reportNull$$$0(0);
        }
        return new JavaeeFacetResourcesPackagingElement(facet);
    }

    public boolean isArchive(ArtifactType artifactType) {
        return artifactType instanceof JavaeeArtifactTypeBase && ((JavaeeArtifactTypeBase)artifactType).isArchive();
    }

    public boolean isJavaeeApplication(@NotNull ArtifactType artifactType) {
        if (artifactType == null) {
            JavaeeArtifactUtilImpl.$$$reportNull$$$0(1);
        }
        return artifactType.equals((Object)ExplodedEarArtifactType.getInstance()) || artifactType.equals((Object)EarArtifactType.getInstance());
    }

    public boolean isEjbApplication(@NotNull ArtifactType artifactType) {
        if (artifactType == null) {
            JavaeeArtifactUtilImpl.$$$reportNull$$$0(2);
        }
        return artifactType.equals((Object)EjbJarArtifactType.getInstance()) || artifactType.equals((Object)ExplodedEjbArtifactType.getInstance());
    }

    public <F extends JavaeeFacet> Collection<F> getFacetsIncludedInArtifact(@NotNull Project project, @NotNull Artifact artifact, @Nullable FacetTypeId<F> facetType) {
        if (project == null) {
            JavaeeArtifactUtilImpl.$$$reportNull$$$0(3);
        }
        if (artifact == null) {
            JavaeeArtifactUtilImpl.$$$reportNull$$$0(4);
        }
        if (project.isDisposed()) {
            return Collections.emptyList();
        }
        MultiValuesMap map = (MultiValuesMap)CachedValuesManager.getManager((Project)project).getCachedValue((UserDataHolder)artifact, FACETS_INCLUDED_IN_ARTIFACT_KEY, () -> {
            if (project == null) {
                JavaeeArtifactUtilImpl.$$$reportNull$$$0(14);
            }
            if (artifact == null) {
                JavaeeArtifactUtilImpl.$$$reportNull$$$0(15);
            }
            MultiValuesMap map1 = new MultiValuesMap();
            PackagingElementResolvingContext resolvingContext = ArtifactManager.getInstance((Project)project).getResolvingContext();
            ArtifactUtil.processPackagingElements((Artifact)artifact, (PackagingElementType)JavaeeFacetResourcesElementType.getInstance(), element -> {
                JavaeeFacet facet = element.findFacet(resolvingContext);
                if (facet != null) {
                    map1.put(null, (Object)facet);
                    map1.put((Object)facet.getTypeId(), (Object)facet);
                }
                return true;
            }, (PackagingElementResolvingContext)resolvingContext, (boolean)true);
            return CachedValueProvider.Result.create((Object)map1, (Object[])new Object[]{ArtifactManager.getInstance((Project)project).getModificationTracker()});
        }, false);
        List fs = map.get(facetType);
        return fs != null ? fs : Collections.emptyList();
    }

    @NotNull
    public Collection<Artifact> getArtifactsContainingFacet(@NotNull JavaeeFacet facet, ArtifactType artifactType) {
        if (facet == null) {
            JavaeeArtifactUtilImpl.$$$reportNull$$$0(5);
        }
        Collection<Object> artifactTypes = artifactType != null ? Collections.singleton(artifactType) : this.getAllJavaeeArtifactTypes();
        PackagingElementResolvingContext context = ArtifactManager.getInstance((Project)facet.getModule().getProject()).getResolvingContext();
        Collection<Artifact> collection = this.getArtifactsContainingFacet(facet, context, artifactTypes, false);
        if (collection == null) {
            JavaeeArtifactUtilImpl.$$$reportNull$$$0(6);
        }
        return collection;
    }

    @NotNull
    public Collection<Artifact> getArtifactsContainingFacet(@NotNull JavaeeFacet facet, PackagingElementResolvingContext context, Collection<? extends ArtifactType> artifactTypes, boolean transitively) {
        Project project;
        if (facet == null) {
            JavaeeArtifactUtilImpl.$$$reportNull$$$0(7);
        }
        if (ArtifactManager.getInstance((Project)(project = facet.getModule().getProject())).getResolvingContext() == context) {
            CachedValue value;
            Pair param = Pair.create(artifactTypes, (Object)transitively);
            HashMap<Pair, CachedValue> map = (HashMap<Pair, CachedValue>)facet.getUserData(ARTIFACTS_CONTAINING_FACET_KEY);
            if (map == null) {
                map = new HashMap<Pair, CachedValue>();
                facet.putUserData(ARTIFACTS_CONTAINING_FACET_KEY, map);
            }
            if ((value = (CachedValue)map.get(param)) == null) {
                value = CachedValuesManager.getManager((Project)project).createCachedValue((CachedValueProvider)new ContainingArtifactsCachedValueProvider(facet, context, (Pair<? extends Collection<? extends ArtifactType>, Boolean>)param, project), false);
                map.put(param, value);
            }
            Collection collection = (Collection)value.getValue();
            if (collection == null) {
                JavaeeArtifactUtilImpl.$$$reportNull$$$0(8);
            }
            return collection;
        }
        Collection<Artifact> collection = JavaeeArtifactUtilImpl.computeArtifactsContainingFacet(facet, context, artifactTypes, transitively);
        if (collection == null) {
            JavaeeArtifactUtilImpl.$$$reportNull$$$0(9);
        }
        return collection;
    }

    private static Collection<Artifact> computeArtifactsContainingFacet(final JavaeeFacet facet, final PackagingElementResolvingContext context, final Collection<? extends ArtifactType> artifactTypes, final boolean transitively) {
        final ArrayList<Artifact> result = new ArrayList<Artifact>();
        ArrayList artifacts = new ArrayList();
        for (ArtifactType artifactType : artifactTypes) {
            artifacts.addAll(context.getArtifactModel().getArtifactsByType(artifactType));
        }
        for (final Artifact artifact : artifacts) {
            PackagingElementProcessor<JavaeeFacetResourcesPackagingElement> processor = new PackagingElementProcessor<JavaeeFacetResourcesPackagingElement>(){

                public boolean process(@NotNull JavaeeFacetResourcesPackagingElement element, @NotNull PackagingElementPath path) {
                    if (element == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (path == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    if (element.getFacetPointer().getId().equals(FacetPointersManager.constructId((Facet)facet))) {
                        result.add(artifact);
                        return false;
                    }
                    return true;
                }

                public boolean shouldProcessSubstitution(ComplexPackagingElement<?> element) {
                    Artifact included;
                    if (!transitively && element instanceof ArtifactPackagingElement && (included = ((ArtifactPackagingElement)element).findArtifact(context)) != null && artifactTypes.contains(included.getArtifactType())) {
                        return false;
                    }
                    return super.shouldProcessSubstitution(element);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[0] = "element";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[0] = "path";
                            break;
                        }
                    }
                    objectArray[1] = "com/intellij/javaee/artifact/JavaeeArtifactUtilImpl$1";
                    objectArray[2] = "process";
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            };
            ArtifactUtil.processPackagingElements((Artifact)artifact, (PackagingElementType)JavaeeFacetResourcesElementType.getInstance(), (PackagingElementProcessor)processor, (PackagingElementResolvingContext)context, (boolean)true);
        }
        return result;
    }

    public void addLibraryToAllArtifactsContainingFacet(@NotNull Library library, @NotNull JavaeeFacet facet) {
        if (library == null) {
            JavaeeArtifactUtilImpl.$$$reportNull$$$0(10);
        }
        if (facet == null) {
            JavaeeArtifactUtilImpl.$$$reportNull$$$0(11);
        }
        ArtifactManager artifactManager = ArtifactManager.getInstance((Project)facet.getModule().getProject());
        PackagingElementResolvingContext context = artifactManager.getResolvingContext();
        JavaeeFacetType facetType = (JavaeeFacetType)facet.getType();
        for (Artifact artifact : this.getArtifactsContainingFacet(facet, context, facetType.getArtifactTypes(), false)) {
            List elements = PackagingElementFactory.getInstance().createLibraryElements(library);
            for (PackagingElement element : elements) {
                String dir = element.getFilesKind(artifactManager.getResolvingContext()).containsJarFiles() ? facetType.getDefaultUriForJar() : facetType.getDefaultUriForDirectory();
                artifactManager.addElementsToDirectory(artifact, dir, element);
            }
        }
    }

    public String getRelativePath(@NotNull JavaeeFacet from, @NotNull JavaeeFacet to) {
        if (from == null) {
            JavaeeArtifactUtilImpl.$$$reportNull$$$0(12);
        }
        if (to == null) {
            JavaeeArtifactUtilImpl.$$$reportNull$$$0(13);
        }
        Project project = from.getModule().getProject();
        PackagingElementResolvingContext context = ArtifactManager.getInstance((Project)project).getResolvingContext();
        for (Artifact artifact : ArtifactManager.getInstance((Project)project).getArtifacts()) {
            String path;
            if (!this.getAllJavaeeArtifactTypes().contains(artifact.getArtifactType()) || (path = JavaeeArtifactUtilImpl.getRelativePath(artifact, from, to, context)) == null) continue;
            return path;
        }
        return null;
    }

    @Nullable
    private static String getRelativePath(Artifact artifact, JavaeeFacet from, JavaeeFacet to, PackagingElementResolvingContext context) {
        String fromPath = JavaeeArtifactUtilImpl.getPathFromRoot(artifact, from, context);
        if (fromPath == null) {
            return null;
        }
        String toPath = JavaeeArtifactUtilImpl.getPathFromRoot(artifact, to, context);
        if (toPath == null) {
            return null;
        }
        return FileUtil.getRelativePath((String)("/" + fromPath), (String)("/" + toPath), (char)'/');
    }

    private static String getPathFromRoot(Artifact artifact, final JavaeeFacet facet, PackagingElementResolvingContext context) {
        final Ref pathRef = Ref.create(null);
        ArtifactUtil.processPackagingElements((Artifact)artifact, (PackagingElementType)JavaeeFacetResourcesElementType.getInstance(), (PackagingElementProcessor)new PackagingElementProcessor<JavaeeFacetResourcesPackagingElement>(){

            public boolean process(@NotNull JavaeeFacetResourcesPackagingElement element, @NotNull PackagingElementPath path) {
                if (element == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (path == null) {
                    2.$$$reportNull$$$0(1);
                }
                if (element.getFacetPointer().getId().equals(FacetPointersManager.constructId((Facet)facet))) {
                    pathRef.set((Object)path.getPathString());
                }
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "element";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "path";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/javaee/artifact/JavaeeArtifactUtilImpl$2";
                objectArray[2] = "process";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }, (PackagingElementResolvingContext)context, (boolean)true);
        return (String)pathRef.get();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 8: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 8: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facet";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "artifactType";
                break;
            }
            case 3: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "artifact";
                break;
            }
            case 6: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javaee/artifact/JavaeeArtifactUtilImpl";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "library";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "from";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "to";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javaee/artifact/JavaeeArtifactUtilImpl";
                break;
            }
            case 6: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getArtifactsContainingFacet";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createFacetResourcesElement";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isJavaeeApplication";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isEjbApplication";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getFacetsIncludedInArtifact";
                break;
            }
            case 5: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getArtifactsContainingFacet";
                break;
            }
            case 6: 
            case 8: 
            case 9: {
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "addLibraryToAllArtifactsContainingFacet";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getRelativePath";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getFacetsIncludedInArtifact$1";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 8: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ContainingArtifactsCachedValueProvider
    implements CachedValueProvider<Collection<Artifact>> {
        private final JavaeeFacet myFacet;
        private final PackagingElementResolvingContext myContext;
        private final Pair<? extends Collection<? extends ArtifactType>, Boolean> myParam;
        private final Project myProject;

        public ContainingArtifactsCachedValueProvider(JavaeeFacet facet, PackagingElementResolvingContext context, Pair<? extends Collection<? extends ArtifactType>, Boolean> param, Project project) {
            this.myFacet = facet;
            this.myContext = context;
            this.myParam = param;
            this.myProject = project;
        }

        public CachedValueProvider.Result<Collection<Artifact>> compute() {
            Collection value = JavaeeArtifactUtilImpl.computeArtifactsContainingFacet(this.myFacet, this.myContext, (Collection)this.myParam.getFirst(), (Boolean)this.myParam.getSecond());
            return CachedValueProvider.Result.create((Object)value, (Object[])new Object[]{ArtifactManager.getInstance((Project)this.myProject).getModificationTracker()});
        }
    }
}

