/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.ejb.migration;

import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.jam.view.treetable.JamTreeTableView;
import com.intellij.javaee.J2EEBundle;
import com.intellij.javaee.ejb.EjbUtil;
import com.intellij.javaee.ejb.facet.EjbFacet;
import com.intellij.javaee.ejb.migration.ApplyJavaeeStyleConfiguration;
import com.intellij.javaee.ejb.migration.ApplyJavaeeStyleProcessor;
import com.intellij.javaee.model.common.EnvironmentGroup;
import com.intellij.javaee.model.common.ejb.EjbCommonModelUtil;
import com.intellij.javaee.model.common.ejb.EjbDescriptorVersion;
import com.intellij.javaee.model.common.ejb.EjbWithHome;
import com.intellij.javaee.model.common.ejb.EnterpriseBean;
import com.intellij.javaee.model.common.ejb.EntityBean;
import com.intellij.javaee.model.common.ejb.Interceptor;
import com.intellij.javaee.model.enums.PersistenceType;
import com.intellij.javaee.module.view.ejb.editor.EjbAsVirtualFile;
import com.intellij.javaee.module.view.ejb.editor.EjbAsVirtualFileImpl;
import com.intellij.javaee.module.view.ejb.editor.InterceptorAsVirtualFile;
import com.intellij.javaee.module.view.ejb.editor.InterceptorAsVirtualFileImpl;
import com.intellij.javaee.module.view.ejb.nodes.EjbFacetNodeDescriptor;
import com.intellij.javaee.module.view.nodes.J2EEModuleParameters;
import com.intellij.javaee.module.view.nodes.JavaeeNodeDescriptor;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.help.HelpManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.refactoring.ui.RefactoringDialog;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.ui.BooleanTableCellEditor;
import com.intellij.ui.BooleanTableCellRenderer;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.JBColor;
import com.intellij.ui.TreeTableSpeedSearch;
import com.intellij.ui.border.IdeaTitledBorder;
import com.intellij.ui.treeStructure.treetable.TreeColumnInfo;
import com.intellij.ui.treeStructure.treetable.TreeTable;
import com.intellij.util.Processor;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import org.jetbrains.annotations.NotNull;

public class ApplyJavaeeStyleDialog
extends RefactoringDialog
implements ApplyJavaeeStyleConfiguration {
    private final Project myProject;
    private final EjbFacet myEjbFacet;
    private final Map<VirtualFile, Info> infoMap = new HashMap<VirtualFile, Info>();
    private boolean createUnit = false;
    private final JCheckBox myCbConvertEntities = new JCheckBox();
    private final JRadioButton myRbPreferInjection = new JRadioButton();
    private final JRadioButton myRbPreferLookup = new JRadioButton();
    private final JRadioButton myRbPreferAsIs = new JRadioButton();
    private final JCheckBox myCbReplaceJndi = new JCheckBox();
    private final JCheckBox myCbInlineInjectedFields = new JCheckBox();
    private final JCheckBox myCbCopyFromXml = new JCheckBox();
    private final JCheckBox myCbDeleteXmlTags = new JCheckBox();
    private MyJavaeeTreeTableView treeTable;

    public ApplyJavaeeStyleDialog(Project project, EjbFacet ejbFacet, Processor<EnvironmentGroup> selector) {
        super(project, true);
        Info info;
        this.myEjbFacet = ejbFacet;
        this.myProject = project;
        for (EnterpriseBean ejb : EjbCommonModelUtil.getAllEjbs((Project)this.myProject, null, (EjbFacet)ejbFacet)) {
            info = this.getInfo((EnvironmentGroup)ejb);
            info.entity = ejb instanceof EntityBean;
            info.enabled = selector.process((Object)ejb);
            info.homeFlag = info.hasHome = ApplyJavaeeStyleDialog.hasHomeInterfacesNow(ejb);
        }
        for (Interceptor interceptor : EjbCommonModelUtil.getAllInterceptors((Project)this.myProject, null, (EjbFacet)ejbFacet)) {
            info = this.getInfo((EnvironmentGroup)interceptor);
            info.enabled = selector.process((Object)interceptor);
            info.hasHome = false;
            info.homeFlag = false;
        }
        EjbDescriptorVersion ejbDescriptorVersion = EjbUtil.getVersion(this.myEjbFacet);
        String refactoringName = EjbDescriptorVersion.EJB_VERSION_3_0.compareTo((Enum)ejbDescriptorVersion) <= 0 ? J2EEBundle.message((String)"apply.javaee.style.title", (Object[])new Object[0]) : J2EEBundle.message((String)"apply.javaee.style.title.migrate", (Object[])new Object[0]);
        this.setTitle(refactoringName + " - " + this.myEjbFacet.getName());
        this.init();
    }

    protected void doHelpAction() {
        HelpManager.getInstance().invokeHelp("newEJBmigration");
    }

    private Info getInfo(EnvironmentGroup env) {
        VirtualFile key = this.getKey(env);
        Info info = this.infoMap.get(key);
        if (info == null) {
            info = new Info();
            this.infoMap.put(key, info);
        }
        return info;
    }

    private VirtualFile getKey(EnvironmentGroup env) {
        if (env instanceof EnterpriseBean) {
            return EjbAsVirtualFileImpl.findFile((EnterpriseBean)env);
        }
        return InterceptorAsVirtualFileImpl.findFile((Interceptor)env);
    }

    @Override
    public ApplyJavaeeStyleConfiguration.EnvironmentAccess getPreferredAccess() {
        return this.myRbPreferInjection.isSelected() ? ApplyJavaeeStyleConfiguration.EnvironmentAccess.INJECTION : (this.myRbPreferLookup.isSelected() ? ApplyJavaeeStyleConfiguration.EnvironmentAccess.LOOKUP : ApplyJavaeeStyleConfiguration.EnvironmentAccess.DEFAULT);
    }

    @Override
    public Module getModule() {
        return this.myEjbFacet.getModule();
    }

    @Override
    public EjbFacet getEjbFacet() {
        return this.myEjbFacet;
    }

    @Override
    public EnterpriseBean[] getEnterpriseBeans() {
        ArrayList<EnterpriseBean> result = new ArrayList<EnterpriseBean>();
        for (Map.Entry<VirtualFile, Info> entry : this.infoMap.entrySet()) {
            EnterpriseBean o;
            if (!(entry.getKey() instanceof EjbAsVirtualFile) || !entry.getValue().enabled || (o = ((EjbAsVirtualFile)entry.getKey()).findElement(this.myProject)) == null) continue;
            result.add(o);
        }
        return result.toArray(new EnterpriseBean[result.size()]);
    }

    @Override
    public Interceptor[] getInterceptors() {
        ArrayList<Interceptor> result = new ArrayList<Interceptor>();
        for (Map.Entry<VirtualFile, Info> entry : this.infoMap.entrySet()) {
            Interceptor o;
            if (!(entry.getKey() instanceof InterceptorAsVirtualFile) || !entry.getValue().enabled || (o = ((InterceptorAsVirtualFile)entry.getKey()).findElement(this.myProject)) == null) continue;
            result.add(o);
        }
        return result.toArray(new Interceptor[result.size()]);
    }

    @Override
    public boolean isHomeInterfaceEnabled(EnterpriseBean ejb) {
        return this.getInfo((EnvironmentGroup)ejb).homeFlag;
    }

    @Override
    public boolean isEnlisted(EnvironmentGroup ejbEnvironment) {
        return this.getInfo((EnvironmentGroup)ejbEnvironment).enabled;
    }

    @Override
    public boolean isReplaceJndiLookups() {
        return this.myCbReplaceJndi.isSelected();
    }

    @Override
    public boolean isInlineInjectedFields() {
        return this.myCbInlineInjectedFields.isSelected();
    }

    @Override
    public boolean isCopyFromXml() {
        return this.myCbCopyFromXml.isSelected();
    }

    @Override
    public boolean isDeleteCopiedXmlTags() {
        return this.myCbDeleteXmlTags.isSelected();
    }

    @Override
    public boolean isCreatePersistenceUnit() {
        return this.myCbConvertEntities.isSelected();
    }

    protected String getDimensionServiceKey() {
        return "#com.intellij.javaee.ejb.migration.ApplyJavaeeStyleDialog";
    }

    private static boolean hasHomeInterfacesNow(Object o) {
        if (o instanceof EjbWithHome) {
            EjbWithHome ejbWithHome = (EjbWithHome)o;
            return ejbWithHome.getLocalHome().getValue() != null || ejbWithHome.getHome().getValue() != null;
        }
        return false;
    }

    protected void dispose() {
        Disposer.dispose((Disposable)this.treeTable);
        super.dispose();
    }

    protected JComponent createCenterPanel() {
        this.treeTable = new MyJavaeeTreeTableView(this.myEjbFacet);
        IdeaTitledBorder titledBorder = IdeBorderFactory.createTitledBorder((String)J2EEBundle.message((String)"apply.javaee.style.ejb.table.border.title", (Object[])new Object[0]), (boolean)false);
        CompoundBorder border = BorderFactory.createCompoundBorder((Border)titledBorder, this.treeTable.getComponent().getBorder());
        this.treeTable.getComponent().setBorder(border);
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)this.treeTable.getComponent(), "Center");
        this.myCbConvertEntities.setText(J2EEBundle.message((String)"migrate.entity.beans.to.persistence.module", (Object[])new Object[0]));
        this.myCbConvertEntities.addChangeListener(new ChangeListener(){
            private final Color defColor;
            {
                this.defColor = ApplyJavaeeStyleDialog.this.myCbConvertEntities.getForeground();
            }

            @Override
            public void stateChanged(ChangeEvent e) {
                boolean selected = ApplyJavaeeStyleDialog.this.myCbConvertEntities.isSelected();
                if (selected) {
                    ApplyJavaeeStyleDialog.this.myCbConvertEntities.setForeground((Color)JBColor.RED);
                } else {
                    ApplyJavaeeStyleDialog.this.myCbConvertEntities.setForeground(this.defColor);
                }
                ApplyJavaeeStyleDialog.this.createUnit = selected;
                for (EnterpriseBean ejb : EjbCommonModelUtil.getAllEjbs((Project)ApplyJavaeeStyleDialog.this.myProject, null, (EjbFacet)ApplyJavaeeStyleDialog.this.myEjbFacet)) {
                    EntityBean entity;
                    if (!(ejb instanceof EntityBean) || (entity = (EntityBean)ejb).getPersistenceType().getValue() != PersistenceType.CONTAINER) continue;
                    Info info = ApplyJavaeeStyleDialog.this.getInfo((EnvironmentGroup)ejb);
                    if (selected) {
                        info.enabled = true;
                        info.homeFlag = false;
                        continue;
                    }
                    info.homeFlag = true;
                }
                ApplyJavaeeStyleDialog.this.treeTable.reset();
                ApplyJavaeeStyleDialog.this.updateOKButton();
            }
        });
        int cmpBeansCount = 0;
        for (EnterpriseBean ejb : EjbCommonModelUtil.getAllEjbs((Project)this.myProject, null, (EjbFacet)this.myEjbFacet)) {
            EntityBean entity;
            if (!(ejb instanceof EntityBean) || (entity = (EntityBean)ejb).getPersistenceType().getValue() != PersistenceType.CONTAINER) continue;
            ++cmpBeansCount;
        }
        this.myCbConvertEntities.setEnabled(cmpBeansCount > 0);
        this.myRbPreferInjection.setText(J2EEBundle.message((String)"apply.javaee.style.prefer.injection", (Object[])new Object[0]));
        this.myRbPreferLookup.setText(J2EEBundle.message((String)"apply.javaee.style.prefer.lookup", (Object[])new Object[0]));
        this.myRbPreferAsIs.setText(J2EEBundle.message((String)"apply.javaee.style.prefer.default", (Object[])new Object[0]));
        this.myCbReplaceJndi.setText(J2EEBundle.message((String)"apply.javaee.style.prefer.replace.jndi.lookups", (Object[])new Object[0]));
        this.myCbInlineInjectedFields.setText(J2EEBundle.message((String)"apply.javaee.style.prefer.inline.injected.fields", (Object[])new Object[0]));
        this.myCbCopyFromXml.setText(J2EEBundle.message((String)"apply.javaee.style.copy.metadata.from.xml", (Object[])new Object[0]));
        this.myCbDeleteXmlTags.setText(J2EEBundle.message((String)"apply.javaee.style.drop.copied.tags", (Object[])new Object[0]));
        this.myRbPreferInjection.setSelected(true);
        this.myCbInlineInjectedFields.setSelected(true);
        this.myCbReplaceJndi.setSelected(true);
        this.myCbCopyFromXml.setSelected(true);
        ButtonGroup preferenceGroup = new ButtonGroup();
        preferenceGroup.add(this.myRbPreferInjection);
        preferenceGroup.add(this.myRbPreferLookup);
        preferenceGroup.add(this.myRbPreferAsIs);
        Box leftBox = Box.createVerticalBox();
        leftBox.add(this.myRbPreferInjection);
        leftBox.add(this.myRbPreferLookup);
        leftBox.add(this.myRbPreferAsIs);
        leftBox.add(new JLabel(" "));
        leftBox.add(this.myCbReplaceJndi);
        leftBox.add(this.myCbInlineInjectedFields);
        JPanel leftPanel = new JPanel(new BorderLayout());
        leftPanel.setBorder((Border)IdeBorderFactory.createTitledBorder((String)J2EEBundle.message((String)"apply.javaee.style.environment.access.border.title", (Object[])new Object[0]), (boolean)true));
        leftPanel.add((Component)leftBox, "Center");
        leftPanel.add(Box.createHorizontalStrut(5), "West");
        Box rightBox = Box.createVerticalBox();
        rightBox.add(this.myCbCopyFromXml);
        rightBox.add(this.myCbDeleteXmlTags);
        JPanel rightPanel = new JPanel(new BorderLayout());
        rightPanel.setBorder((Border)IdeBorderFactory.createTitledBorder((String)J2EEBundle.message((String)"apply.javaee.style.metadata.border.title", (Object[])new Object[0]), (boolean)true));
        rightPanel.add((Component)rightBox, "Center");
        rightPanel.add(Box.createHorizontalStrut(5), "West");
        Box horizontalBox = Box.createHorizontalBox();
        horizontalBox.add(leftPanel);
        horizontalBox.add(Box.createHorizontalStrut(5));
        horizontalBox.add(rightPanel);
        JPanel boxPanel = new JPanel(new BorderLayout());
        boxPanel.add((Component)horizontalBox, "Center");
        boxPanel.add(Box.createVerticalStrut(5), "North");
        panel.add((Component)boxPanel, "South");
        boxPanel.add((Component)this.myCbConvertEntities, "South");
        return panel;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.treeTable.getComponent();
    }

    private void updateOKButton() {
        boolean empty = true;
        for (Info info : this.infoMap.values()) {
            if (!info.enabled) continue;
            empty = false;
            break;
        }
        this.getRefactorAction().setEnabled(!empty);
        this.getPreviewAction().setEnabled(!empty);
    }

    protected void doAction() {
        String errorString = this.validateData();
        if (errorString != null) {
            CommonRefactoringUtil.showErrorMessage((String)this.getTitle(), (String)errorString, null, (Project)this.myProject);
            return;
        }
        this.invokeRefactoring(new ApplyJavaeeStyleProcessor(this.myProject, this));
    }

    private String validateData() {
        return null;
    }

    public void refreshEnterpriseBeans() {
    }

    private static class Info {
        boolean entity;
        boolean enabled;
        boolean hasHome;
        boolean homeFlag;

        private Info() {
        }
    }

    private class MyJavaeeTreeTableView
    extends JamTreeTableView {
        public MyJavaeeTreeTableView(EjbFacet facet) {
            super(facet.getModule().getProject(), new EjbFacetNodeDescriptor(facet, (Object)new J2EEModuleParameters(true){

                public boolean isNodeEnabled(NodeDescriptor nodeDescriptor) {
                    Object element = nodeDescriptor.getElement();
                    return element instanceof EnterpriseBean || element instanceof Interceptor;
                }
            }));
            this.getTreeTableView().setShowVerticalLines(true);
            this.getTreeTableView().setIntercellSpacing((Dimension)JBUI.size((int)1, (int)0));
            this.init();
            TreeUtil.expandAll((JTree)this.getTree());
            new TreeTableSpeedSearch((TreeTable)this.getTreeTableView());
        }

        @Override
        protected boolean isShowTree() {
            return true;
        }

        @Override
        @NotNull
        protected String getEmptyPaneText() {
            if ("" == null) {
                MyJavaeeTreeTableView.$$$reportNull$$$0(0);
            }
            return "";
        }

        @Override
        protected ColumnInfo[] createColumnInfos() {
            return new ColumnInfo[]{new ColumnInfo<JavaeeNodeDescriptor, Boolean>(" "){

                public int getWidth(JTable table) {
                    return 15;
                }

                public Boolean valueOf(JavaeeNodeDescriptor object) {
                    Object element = object.getElement();
                    return ((ApplyJavaeeStyleDialog)ApplyJavaeeStyleDialog.this).getInfo((EnvironmentGroup)((EnvironmentGroup)element)).enabled;
                }

                public void setValue(JavaeeNodeDescriptor o, Boolean aValue) {
                    ((ApplyJavaeeStyleDialog)ApplyJavaeeStyleDialog.this).getInfo((EnvironmentGroup)((EnvironmentGroup)o.getElement())).enabled = aValue;
                    ApplyJavaeeStyleDialog.this.updateOKButton();
                }

                public boolean isCellEditable(JavaeeNodeDescriptor o) {
                    return !ApplyJavaeeStyleDialog.this.createUnit || !((ApplyJavaeeStyleDialog)ApplyJavaeeStyleDialog.this).getInfo((EnvironmentGroup)((EnvironmentGroup)o.getElement())).entity;
                }

                public TableCellRenderer getRenderer(JavaeeNodeDescriptor p0) {
                    return new BooleanTableCellRenderer();
                }

                public TableCellEditor getEditor(JavaeeNodeDescriptor item) {
                    return new BooleanTableCellEditor();
                }
            }, new TreeColumnInfo(J2EEBundle.message((String)"apply.javaee.style.ejb.column.title", (Object[])new Object[0])), new ColumnInfo<JavaeeNodeDescriptor, Boolean>(J2EEBundle.message((String)"apply.javaee.style.home.column.title", (Object[])new Object[0])){

                public int getWidth(JTable table) {
                    return 15;
                }

                public Boolean valueOf(JavaeeNodeDescriptor object) {
                    Info info = ApplyJavaeeStyleDialog.this.getInfo((EnvironmentGroup)object.getElement());
                    return info.hasHome ? Boolean.valueOf(info.homeFlag) : null;
                }

                public void setValue(JavaeeNodeDescriptor o, Boolean aValue) {
                    Info info = ApplyJavaeeStyleDialog.this.getInfo((EnvironmentGroup)o.getElement());
                    if (info.hasHome) {
                        info.homeFlag = aValue;
                    }
                }

                public boolean isCellEditable(JavaeeNodeDescriptor o) {
                    Info info = ApplyJavaeeStyleDialog.this.getInfo((EnvironmentGroup)o.getElement());
                    return info.hasHome && !info.entity;
                }

                public TableCellRenderer getRenderer(JavaeeNodeDescriptor p0) {
                    Info info = ApplyJavaeeStyleDialog.this.getInfo((EnvironmentGroup)p0.getElement());
                    BooleanTableCellRenderer cellRenderer = new BooleanTableCellRenderer();
                    cellRenderer.setEnabled(!info.entity);
                    return cellRenderer;
                }

                public TableCellEditor getEditor(JavaeeNodeDescriptor item) {
                    return new BooleanTableCellEditor();
                }
            }};
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/ejb/migration/ApplyJavaeeStyleDialog$MyJavaeeTreeTableView", "getEmptyPaneText"));
        }
    }
}

