/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.process.common;

import com.intellij.javaee.process.common.JavaeeProcessUtilException;
import com.intellij.util.Base64;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;

public class OutputWriter {
    private static DocumentBuilder ourBuilder;
    private final OutputStreamWriter myWriter;

    private static DocumentBuilder getBuilder() throws ParserConfigurationException {
        if (ourBuilder == null) {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            ourBuilder = factory.newDocumentBuilder();
        }
        return ourBuilder;
    }

    public static Document createDocument() throws JavaeeProcessUtilException {
        try {
            return OutputWriter.getBuilder().newDocument();
        }
        catch (ParserConfigurationException e) {
            throw new JavaeeProcessUtilException(e);
        }
    }

    public OutputWriter(OutputStream outputStream) throws IOException {
        this.myWriter = new OutputStreamWriter(outputStream, "UTF8");
    }

    public static void putDocument(StreamResult streamResult, Document document) throws JavaeeProcessUtilException {
        try {
            DOMSource xmlSource = new DOMSource(document);
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.transform(xmlSource, streamResult);
        }
        catch (TransformerException e) {
            throw new JavaeeProcessUtilException(e);
        }
    }

    public void putDocument(Document document) throws JavaeeProcessUtilException {
        try {
            ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
            StreamResult result = new StreamResult(byteStream);
            OutputWriter.putDocument(result, document);
            String packet = Base64.encode((byte[])byteStream.toByteArray()) + "\n";
            this.myWriter.write(packet);
            this.myWriter.flush();
        }
        catch (IOException e) {
            throw new JavaeeProcessUtilException(e);
        }
    }

    public void close() throws IOException {
        this.myWriter.close();
    }
}

