/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa;

import com.intellij.database.run.ConsoleRunConfiguration;
import com.intellij.database.script.PersistenceConsoleProvider;
import com.intellij.database.script.ScriptModel;
import com.intellij.database.script.ScriptModelUtil;
import com.intellij.execution.CommonJavaRunConfigurationParameters;
import com.intellij.execution.RunManager;
import com.intellij.execution.application.ApplicationConfiguration;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.ide.presentation.VirtualFilePresentation;
import com.intellij.jam.JamMessages;
import com.intellij.jam.model.util.JamCommonUtil;
import com.intellij.javaee.model.xml.persistence.PersistenceUnit;
import com.intellij.jpa.JpaQueryReferenceProvider;
import com.intellij.jpa.engine.JpaConsole;
import com.intellij.jpa.engine.JpaConsoleBase;
import com.intellij.jpa.engine.JpaEngine;
import com.intellij.jpa.engine.QlScriptModel;
import com.intellij.jpa.facet.JpaFacet;
import com.intellij.jpa.ql.QlFile;
import com.intellij.jpa.util.JpaUtil;
import com.intellij.jpa.view.editor.PersistencePackageAsVirtualFileImpl;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.LanguageLevelProjectExtension;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.persistence.PersistenceDataKeys;
import com.intellij.persistence.facet.PersistenceFacet;
import com.intellij.persistence.model.PersistencePackage;
import com.intellij.persistence.model.PersistencePackagePointer;
import com.intellij.persistence.util.PersistenceCommonUtil;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Consumer;
import com.intellij.util.JavaeeIcons;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JpaConsoleProvider
extends PersistenceConsoleProvider {
    public static boolean canOpenConsoleInSeparatedProcess(PersistencePackage unit) {
        return unit.getModelHelper().getAdditionalMapping() == null;
    }

    public boolean hasRunners(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            JpaConsoleProvider.$$$reportNull$$$0(0);
        }
        Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        PersistenceFacet facet = (PersistenceFacet)PersistenceDataKeys.PERSISTENCE_FACET.getData(dataContext);
        PersistencePackage unit = (PersistencePackage)PersistenceDataKeys.PERSISTENCE_UNIT.getData(dataContext);
        return project != null && facet != null && unit instanceof PersistenceUnit && unit.isValid() && JpaConsoleProvider.canOpenConsoleInSeparatedProcess(unit) && facet.getQlLanguage() != null && JpaEngine.isAvailable(facet.getModule());
    }

    public boolean hasRunners(@NotNull PsiElement element, @Nullable Editor editor) {
        PsiFile file;
        if (element == null) {
            JpaConsoleProvider.$$$reportNull$$$0(1);
        }
        if (!((file = element.getContainingFile()) instanceof QlFile || JamCommonUtil.isPlainJavaFile((PsiElement)file) || JamCommonUtil.isPlainXmlFile((PsiElement)file))) {
            return false;
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)file);
        if (module == null || !JpaEngine.isAvailable(module)) {
            return false;
        }
        return JpaConsoleProvider.findQlFile(file, element) != null;
    }

    @NotNull
    public List<PersistenceConsoleProvider.Runner> getRunners(@NotNull DataContext dataContext) {
        boolean enable;
        if (dataContext == null) {
            JpaConsoleProvider.$$$reportNull$$$0(2);
        }
        Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        PersistenceFacet facet = (PersistenceFacet)PersistenceDataKeys.PERSISTENCE_FACET.getData(dataContext);
        PersistencePackage unit = (PersistencePackage)PersistenceDataKeys.PERSISTENCE_UNIT.getData(dataContext);
        boolean bl = enable = project != null && facet instanceof JpaFacet && unit != null && unit.isValid() && JpaConsoleProvider.canOpenConsoleInSeparatedProcess(unit) && facet.getQlLanguage() != null && JpaEngine.isAvailable(facet.getModule());
        if (!enable) {
            List<PersistenceConsoleProvider.Runner> list = Collections.emptyList();
            if (list == null) {
                JpaConsoleProvider.$$$reportNull$$$0(3);
            }
            return list;
        }
        PersistencePackageAsVirtualFileImpl unitFile = PersistencePackageAsVirtualFileImpl.findFile(unit, facet);
        if (unitFile == null) {
            List<PersistenceConsoleProvider.Runner> list = Collections.emptyList();
            if (list == null) {
                JpaConsoleProvider.$$$reportNull$$$0(4);
            }
            return list;
        }
        ArrayList<PersistenceConsoleProvider.Runner> result = new ArrayList<PersistenceConsoleProvider.Runner>();
        result.add(new MyRunner(project, unitFile));
        JpaConsoleProvider.addDefaultRunners(result, project, unitFile, null);
        ArrayList<PersistenceConsoleProvider.Runner> arrayList = result;
        if (arrayList == null) {
            JpaConsoleProvider.$$$reportNull$$$0(5);
        }
        return arrayList;
    }

    @NotNull
    public List<PersistenceConsoleProvider.Runner> getRunners(@NotNull PsiElement element, Editor editor) {
        QlScriptModel model;
        PsiFile file;
        if (element == null) {
            JpaConsoleProvider.$$$reportNull$$$0(6);
        }
        if (!((file = element.getContainingFile()) instanceof QlFile || JamCommonUtil.isPlainJavaFile((PsiElement)file) || JamCommonUtil.isPlainXmlFile((PsiElement)file))) {
            List<PersistenceConsoleProvider.Runner> list = Collections.emptyList();
            if (list == null) {
                JpaConsoleProvider.$$$reportNull$$$0(7);
            }
            return list;
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)file);
        if (module == null || !JpaEngine.isAvailable(module)) {
            List<PersistenceConsoleProvider.Runner> list = Collections.emptyList();
            if (list == null) {
                JpaConsoleProvider.$$$reportNull$$$0(8);
            }
            return list;
        }
        ArrayList<PersistencePackagePointer> unitFiles = new ArrayList<PersistencePackagePointer>();
        for (PersistenceFacet facet : PersistenceCommonUtil.getAllPersistenceFacetsWithDependencies((Module)module)) {
            if (facet.getQlLanguage() == null) continue;
            for (PersistencePackage unit : facet.getPersistenceUnits()) {
                if (!(unit instanceof PersistenceUnit) || !JpaConsoleProvider.canOpenConsoleInSeparatedProcess(unit)) continue;
                ContainerUtil.addIfNotNull(unitFiles, (Object)((Object)PersistencePackageAsVirtualFileImpl.findFile(unit, facet)));
            }
        }
        if (unitFiles.isEmpty()) {
            List<PersistenceConsoleProvider.Runner> list = Collections.emptyList();
            if (list == null) {
                JpaConsoleProvider.$$$reportNull$$$0(9);
            }
            return list;
        }
        QlFile qlFile = JpaConsoleProvider.findQlFile(file, element);
        QlScriptModel qlScriptModel = model = qlFile == null ? null : JpaConsoleProvider.createScriptModel(file, qlFile);
        if (model == null || model.statements().isEmpty()) {
            List<PersistenceConsoleProvider.Runner> list = Collections.emptyList();
            if (list == null) {
                JpaConsoleProvider.$$$reportNull$$$0(10);
            }
            return list;
        }
        ArrayList<PersistenceConsoleProvider.Runner> result = new ArrayList<PersistenceConsoleProvider.Runner>();
        result.add(new MyQueryRunner(module.getProject(), unitFiles, model));
        for (PersistencePackagePointer unit : unitFiles) {
            JpaConsoleProvider.addDefaultRunners(result, module.getProject(), unit, model);
        }
        ArrayList<PersistenceConsoleProvider.Runner> arrayList = result;
        if (arrayList == null) {
            JpaConsoleProvider.$$$reportNull$$$0(11);
        }
        return arrayList;
    }

    private static void addDefaultRunners(Collection<PersistenceConsoleProvider.Runner> result, Project project, PersistencePackagePointer unit, QlScriptModel model) {
        for (JpaConsole jpaConsole : JpaConsole.getActiveConsoles(project)) {
            if (!((PersistencePackagePointer)jpaConsole.getTarget()).equals(unit)) continue;
            result.add(new MyConsoleRunner(jpaConsole, model));
        }
    }

    public static QlScriptModel createScriptModel(@NotNull PsiFile file, @NotNull QlFile qlFile) {
        Project project;
        InjectedLanguageManager manager;
        if (file == null) {
            JpaConsoleProvider.$$$reportNull$$$0(12);
        }
        if (qlFile == null) {
            JpaConsoleProvider.$$$reportNull$$$0(13);
        }
        if ((manager = InjectedLanguageManager.getInstance((Project)(project = file.getProject()))).isInjectedFragment((PsiFile)qlFile)) {
            String fileText = manager.getUnescapedText((PsiElement)qlFile);
            PsiFile file2 = PsiFileFactory.getInstance((Project)project).createFileFromText("a.ql", qlFile.getLanguage(), (CharSequence)fileText);
            QlFile qlFile2 = (QlFile)file2;
            return new QlScriptModel(qlFile2);
        }
        return new QlScriptModel(qlFile);
    }

    @Nullable
    public static QlFile findQlFile(PsiFile file, PsiElement element) {
        QlFile qlFile;
        if (file instanceof QlFile) {
            qlFile = (QlFile)file;
        } else {
            PsiLanguageInjectionHost host;
            if (JamCommonUtil.isPlainJavaFile((PsiElement)file)) {
                PsiLiteralExpression literal = (PsiLiteralExpression)PsiTreeUtil.getParentOfType((PsiElement)element, PsiLiteralExpression.class);
                JpaQueryReferenceProvider.QueryReference queryReference = literal == null ? null : JpaUtil.findReferenceOfType(literal.getReferences(), JpaQueryReferenceProvider.QueryReference.class);
                PsiElement queryElement = queryReference == null ? null : JpaUtil.getQueryElement(queryReference.resolveQuery());
                host = (PsiLanguageInjectionHost)ObjectUtils.tryCast((Object)ObjectUtils.chooseNotNull((Object)queryElement, (Object)literal), PsiLanguageInjectionHost.class);
            } else {
                host = (PsiLanguageInjectionHost)PsiTreeUtil.getParentOfType((PsiElement)element, PsiLanguageInjectionHost.class);
            }
            Ref qlFileRef = Ref.create(null);
            if (host != null) {
                InjectedLanguageUtil.forceInjectionOnElement((PsiElement)host);
                InjectedLanguageManager.getInstance((Project)host.getProject()).enumerate((PsiElement)host, (injectedPsi, places) -> {
                    if (injectedPsi instanceof QlFile) {
                        qlFileRef.set((Object)((QlFile)injectedPsi));
                    }
                });
                qlFile = (QlFile)qlFileRef.get();
            } else {
                qlFile = null;
            }
        }
        return qlFile;
    }

    @NotNull
    private static List<RunConfiguration> getJavaRunConfigurations(@NotNull Project project) {
        if (project == null) {
            JpaConsoleProvider.$$$reportNull$$$0(14);
        }
        ArrayList list = ContainerUtil.newArrayList();
        for (RunConfiguration o : RunManager.getInstance((Project)project).getAllConfigurationsList()) {
            String vmParameters = o instanceof ApplicationConfiguration ? ((CommonJavaRunConfigurationParameters)o).getVMParameters() : null;
            if (!StringUtil.isNotEmpty((String)vmParameters)) continue;
            list.add(o);
        }
        ArrayList arrayList = list;
        if (arrayList == null) {
            JpaConsoleProvider.$$$reportNull$$$0(15);
        }
        return arrayList;
    }

    @NotNull
    private static List<PersistenceConsoleProvider.Runner> getCfgSubRunners(@NotNull Project project, @Nullable String selectedName, @NotNull Consumer<ConsoleRunConfiguration> consumer) {
        List<RunConfiguration> runConfigurations;
        if (project == null) {
            JpaConsoleProvider.$$$reportNull$$$0(16);
        }
        if (consumer == null) {
            JpaConsoleProvider.$$$reportNull$$$0(17);
        }
        if ((runConfigurations = JpaConsoleProvider.getJavaRunConfigurations(project)).isEmpty()) {
            List<PersistenceConsoleProvider.Runner> list = Collections.emptyList();
            if (list == null) {
                JpaConsoleProvider.$$$reportNull$$$0(18);
            }
            return list;
        }
        ConsoleRunConfiguration noArgs = ConsoleRunConfiguration.newConfiguration((Project)project);
        noArgs.setName("<empty>");
        RunConfiguration selected = (RunConfiguration)ObjectUtils.notNull(runConfigurations.stream().filter(cfg -> cfg.getName().equals(selectedName)).findFirst().orElse(null), (Object)noArgs);
        runConfigurations.add(0, (RunConfiguration)noArgs);
        List list = (List)JBIterable.from(runConfigurations).map(cfg -> {
            if (project == null) {
                JpaConsoleProvider.$$$reportNull$$$0(24);
            }
            if (consumer == null) {
                JpaConsoleProvider.$$$reportNull$$$0(25);
            }
            return JpaConsoleProvider.newRunner(project, cfg, cfg == selected, consumer);
        }).addAllTo(new ArrayList());
        if (list == null) {
            JpaConsoleProvider.$$$reportNull$$$0(19);
        }
        return list;
    }

    @NotNull
    private static PersistenceConsoleProvider.Runner newRunner(final @NotNull Project project, final @NotNull RunConfiguration profile, final boolean isDefault, final @NotNull Consumer<ConsoleRunConfiguration> consumer) {
        if (project == null) {
            JpaConsoleProvider.$$$reportNull$$$0(20);
        }
        if (profile == null) {
            JpaConsoleProvider.$$$reportNull$$$0(21);
        }
        if (consumer == null) {
            JpaConsoleProvider.$$$reportNull$$$0(22);
        }
        PersistenceConsoleProvider.Runner runner = new PersistenceConsoleProvider.Runner(){

            public String getDisplayName() {
                return profile.getName() + (this.isDefaultSubRunner() ? " *" : "");
            }

            public Icon getIcon() {
                return profile.getIcon();
            }

            public boolean isDefaultSubRunner() {
                return isDefault;
            }

            public void run() {
                ConsoleRunConfiguration result = ConsoleRunConfiguration.newConfiguration((Project)project);
                if (profile instanceof CommonJavaRunConfigurationParameters) {
                    CommonJavaRunConfigurationParameters javaParams = (CommonJavaRunConfigurationParameters)profile;
                    result.VM_PARAMETERS = javaParams.getVMParameters();
                    result.VM_ENV = ContainerUtil.newLinkedHashMap((Map)javaParams.getEnvs());
                    result.setName(profile.getName());
                }
                consumer.consume((Object)result);
            }
        };
        if (runner == null) {
            JpaConsoleProvider.$$$reportNull$$$0(23);
        }
        return runner;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 15: 
            case 18: 
            case 19: 
            case 23: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 15: 
            case 18: 
            case 19: 
            case 23: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 1: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 15: 
            case 18: 
            case 19: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/jpa/JpaConsoleProvider";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qlFile";
                break;
            }
            case 14: 
            case 16: 
            case 20: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 17: 
            case 22: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "profile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/jpa/JpaConsoleProvider";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getRunners";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getJavaRunConfigurations";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getCfgSubRunners";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "newRunner";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "hasRunners";
                break;
            }
            case 2: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getRunners";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 15: 
            case 18: 
            case 19: 
            case 23: {
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "createScriptModel";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getJavaRunConfigurations";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getCfgSubRunners";
                break;
            }
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "newRunner";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getCfgSubRunners$2";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 15: 
            case 18: 
            case 19: 
            case 23: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class MyConsoleRunner
    extends PersistenceConsoleProvider.Runner {
        private final JpaConsoleBase myConsole;
        private final ScriptModel myModel;

        public MyConsoleRunner(@NotNull JpaConsoleBase console, @Nullable ScriptModel model) {
            if (console == null) {
                MyConsoleRunner.$$$reportNull$$$0(0);
            }
            this.myConsole = console;
            this.myModel = model;
        }

        public String getDisplayName() {
            return this.myConsole.getTitle();
        }

        public Icon getIcon() {
            return this.myConsole.getToolWindowIcon();
        }

        public boolean isAlreadyRunning() {
            return true;
        }

        public void run() {
            if (this.myModel == null) {
                this.myConsole.showConsole(true);
            } else if (this.myConsole.beforeExecuteQueries(this.myModel)) {
                this.myConsole.executeQueries((Editor)this.myConsole.getLanguageConsole().getCurrentEditor(), this.myModel);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "console", "com/intellij/jpa/JpaConsoleProvider$MyConsoleRunner", "<init>"));
        }
    }

    public static class MyQueryRunner
    extends PersistenceConsoleProvider.Runner {
        private final Project myProject;
        private final List<PersistencePackagePointer> myUnits;
        private final QlScriptModel myModel;

        public MyQueryRunner(Project project, List<PersistencePackagePointer> units, QlScriptModel model) {
            this.myProject = project;
            this.myUnits = units;
            this.myModel = model;
        }

        public String getDisplayName() {
            return "JPA Console";
        }

        public Icon getIcon() {
            return JavaeeIcons.JPA_ICON;
        }

        public Project getProject() {
            return this.myProject;
        }

        @Nullable
        public String getSubRunnersTitle() {
            return "Persistence Units";
        }

        @NotNull
        public List<PersistenceConsoleProvider.Runner> getSubRunners() {
            Collections.sort(this.myUnits, (o1, o2) -> Comparing.compare((Comparable)((Object)((VirtualFile)o1).getUrl()), (Comparable)((Object)((VirtualFile)o2).getUrl())));
            List list = (List)JBIterable.from(this.myUnits).map(unit -> new PersistenceConsoleProvider.Runner((PersistencePackagePointer)unit){
                final /* synthetic */ PersistencePackagePointer val$unit;
                {
                    this.val$unit = persistencePackagePointer;
                }

                public String getDisplayName() {
                    PersistenceFacet facet = this.val$unit.getPersistenceFacet();
                    String unitName = this.val$unit.getElementName();
                    return facet.getModule().getName() + "/" + (StringUtil.isNotEmpty((String)unitName) ? unitName : JamMessages.message((String)"unnamed.element.presentable.name", (Object[])new Object[0]));
                }

                public Icon getIcon() {
                    return VirtualFilePresentation.getIcon((VirtualFile)((VirtualFile)this.val$unit));
                }

                public String getSubRunnersTitle() {
                    return "VM and Env Configuration";
                }

                @NotNull
                public List<PersistenceConsoleProvider.Runner> getSubRunners() {
                    List list = JpaConsoleProvider.getCfgSubRunners(myProject, this.val$unit.getElementName(), (Consumer<ConsoleRunConfiguration>)cfg -> this.runInner(this.val$unit, (ConsoleRunConfiguration)cfg, myModel));
                    if (list == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return list;
                }

                public void run() {
                    this.runInner(this.val$unit, ConsoleRunConfiguration.newConfiguration((Project)myProject), myModel);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jpa/JpaConsoleProvider$MyQueryRunner$1", "getSubRunners"));
                }
            }).addAllTo(new ArrayList());
            if (list == null) {
                MyQueryRunner.$$$reportNull$$$0(0);
            }
            return list;
        }

        public void run() {
            this.runInner(this.myUnits.get(0), ConsoleRunConfiguration.newConfiguration((Project)this.myProject), this.myModel);
        }

        protected void runInner(@NotNull PersistencePackagePointer unit, @NotNull ConsoleRunConfiguration configuration, @NotNull QlScriptModel model) {
            if (unit == null) {
                MyQueryRunner.$$$reportNull$$$0(1);
            }
            if (configuration == null) {
                MyQueryRunner.$$$reportNull$$$0(2);
            }
            if (model == null) {
                MyQueryRunner.$$$reportNull$$$0(3);
            }
            String text = (String)model.statements().transform(ScriptModelUtil.TO_TEXT).first();
            JpaConsole console = JpaConsole.newConsole(unit).withRunConfiguration(configuration).withQuery(text).build();
            console.showConsole(false);
            if (console.beforeExecuteQueries(model)) {
                console.executeQueries((Editor)console.getLanguageConsole().getCurrentEditor(), model);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/jpa/JpaConsoleProvider$MyQueryRunner";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "unit";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "configuration";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "model";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSubRunners";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/jpa/JpaConsoleProvider$MyQueryRunner";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "runInner";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class MyRunner
    extends PersistenceConsoleProvider.Runner {
        private final Project myProject;
        private final PersistencePackageAsVirtualFileImpl myUnitFile;

        public MyRunner(Project project, PersistencePackageAsVirtualFileImpl unitFile) {
            this.myProject = project;
            this.myUnitFile = unitFile;
        }

        public Project getProject() {
            return this.myProject;
        }

        public String getDisplayName() {
            return "JPA Console";
        }

        public Icon getIcon() {
            return JavaeeIcons.JPA_ICON;
        }

        public void run() {
            this.runInner(this.createRunConfiguration());
        }

        @NotNull
        protected ConsoleRunConfiguration createRunConfiguration() {
            ConsoleRunConfiguration configuration = ConsoleRunConfiguration.newConfiguration((Project)this.myProject);
            LanguageLevel languageLevel = LanguageLevelProjectExtension.getInstance((Project)this.getProject()).getLanguageLevel();
            if (languageLevel.isAtLeast(LanguageLevel.JDK_1_9)) {
                String parameters = configuration.VM_PARAMETERS;
                configuration.VM_PARAMETERS = (StringUtil.isEmptyOrSpaces((String)parameters) ? "" : parameters) + " --add-modules java.xml.bind";
            }
            ConsoleRunConfiguration consoleRunConfiguration = configuration;
            if (consoleRunConfiguration == null) {
                MyRunner.$$$reportNull$$$0(0);
            }
            return consoleRunConfiguration;
        }

        @NotNull
        public List<PersistenceConsoleProvider.Runner> getSubRunners() {
            List list = JpaConsoleProvider.getCfgSubRunners(this.myProject, this.myUnitFile.getElementName(), (Consumer<ConsoleRunConfiguration>)this::runInner);
            if (list == null) {
                MyRunner.$$$reportNull$$$0(1);
            }
            return list;
        }

        public String getSubRunnersTitle() {
            return "VM and Env Configuration";
        }

        protected void runInner(@NotNull ConsoleRunConfiguration configuration) {
            if (configuration == null) {
                MyRunner.$$$reportNull$$$0(2);
            }
            JpaConsole.newConsole(this.myUnitFile).withRunConfiguration(configuration).build().showConsole(true);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 2: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 2: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/jpa/JpaConsoleProvider$MyRunner";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "configuration";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createRunConfiguration";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSubRunners";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/jpa/JpaConsoleProvider$MyRunner";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "runInner";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

