/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.analysis;

import com.intellij.analysis.AnalysisScope;
import com.intellij.analysis.AnalysisScopeBundle;
import com.intellij.analysis.AnalysisUIOptions;
import com.intellij.analysis.ModelScopeItemView;
import com.intellij.analysis.dialog.CustomScopeItem;
import com.intellij.analysis.dialog.ModelScopeItem;
import com.intellij.analysis.dialog.ModelScopeItemPresenter;
import com.intellij.analysis.dialog.ModuleScopeItem;
import com.intellij.analysis.dialog.OtherScopeItem;
import com.intellij.analysis.dialog.ProjectScopeItem;
import com.intellij.analysis.dialog.VcsScopeItem;
import com.intellij.find.FindSettings;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.Disposer;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.SearchScope;
import com.intellij.refactoring.util.RadioUpDownListener;
import com.intellij.ui.TitledSeparator;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.components.BorderLayoutPanel;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.java.JavaSourceRootType;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;

public class BaseAnalysisActionDialog
extends DialogWrapper {
    private static final Logger LOG = Logger.getInstance(BaseAnalysisActionDialog.class);
    @NotNull
    private final AnalysisUIOptions myOptions;
    private final boolean myRememberScope;
    private final boolean myShowInspectTestSource;
    private final String myAnalysisNoon;
    private final Project myProject;
    private final ButtonGroup myGroup;
    private final JCheckBox myInspectTestSource;
    private final List<ModelScopeItemView> myViewItems;

    @Deprecated
    public BaseAnalysisActionDialog(@NotNull String title, @NotNull String analysisNoon, @NotNull Project project, @NotNull AnalysisScope scope, String moduleName, boolean rememberScope, @NotNull AnalysisUIOptions analysisUIOptions, @Nullable PsiElement context) {
        if (title == null) {
            BaseAnalysisActionDialog.$$$reportNull$$$0(0);
        }
        if (analysisNoon == null) {
            BaseAnalysisActionDialog.$$$reportNull$$$0(1);
        }
        if (project == null) {
            BaseAnalysisActionDialog.$$$reportNull$$$0(2);
        }
        if (scope == null) {
            BaseAnalysisActionDialog.$$$reportNull$$$0(3);
        }
        if (analysisUIOptions == null) {
            BaseAnalysisActionDialog.$$$reportNull$$$0(4);
        }
        this(title, analysisNoon, project, scope, moduleName != null ? ModuleManager.getInstance((Project)project).findModuleByName(moduleName) : null, rememberScope, analysisUIOptions, context);
    }

    @Deprecated
    public BaseAnalysisActionDialog(@NotNull String title, @NotNull String analysisNoon, @NotNull Project project, @NotNull AnalysisScope scope, @Nullable Module module, boolean rememberScope, @NotNull AnalysisUIOptions analysisUIOptions, @Nullable PsiElement context) {
        if (title == null) {
            BaseAnalysisActionDialog.$$$reportNull$$$0(5);
        }
        if (analysisNoon == null) {
            BaseAnalysisActionDialog.$$$reportNull$$$0(6);
        }
        if (project == null) {
            BaseAnalysisActionDialog.$$$reportNull$$$0(7);
        }
        if (scope == null) {
            BaseAnalysisActionDialog.$$$reportNull$$$0(8);
        }
        if (analysisUIOptions == null) {
            BaseAnalysisActionDialog.$$$reportNull$$$0(9);
        }
        this(title, analysisNoon, project, Stream.of(new ProjectScopeItem(project), new CustomScopeItem(project, context), VcsScopeItem.createIfHasVCS(project), ModuleScopeItem.tryCreate(module), OtherScopeItem.tryCreate(scope)).filter(x -> x != null).collect(Collectors.toList()), analysisUIOptions, rememberScope, ModuleUtil.isSupportedRootType((Project)project, (JpsModuleSourceRootType)JavaSourceRootType.TEST_SOURCE));
    }

    public BaseAnalysisActionDialog(@NotNull String title, @NotNull String analysisNoon, @NotNull Project project, @NotNull List<ModelScopeItem> items, @NotNull AnalysisUIOptions options, boolean rememberScope, boolean showInspectTestSource) {
        if (title == null) {
            BaseAnalysisActionDialog.$$$reportNull$$$0(10);
        }
        if (analysisNoon == null) {
            BaseAnalysisActionDialog.$$$reportNull$$$0(11);
        }
        if (project == null) {
            BaseAnalysisActionDialog.$$$reportNull$$$0(12);
        }
        if (items == null) {
            BaseAnalysisActionDialog.$$$reportNull$$$0(13);
        }
        if (options == null) {
            BaseAnalysisActionDialog.$$$reportNull$$$0(14);
        }
        super(true);
        this.myGroup = new ButtonGroup();
        this.myInspectTestSource = new JCheckBox();
        this.myAnalysisNoon = analysisNoon;
        this.myProject = project;
        this.myViewItems = ModelScopeItemPresenter.createOrderedViews(items);
        this.myOptions = options;
        this.myRememberScope = rememberScope;
        this.myShowInspectTestSource = showInspectTestSource;
        this.init();
        this.setTitle(title);
    }

    protected JComponent createCenterPanel() {
        BorderLayoutPanel panel2 = new BorderLayoutPanel();
        TitledSeparator titledSeparator = new TitledSeparator();
        titledSeparator.setText(this.myAnalysisNoon);
        panel2.addToTop((Component)titledSeparator);
        JPanel scopesPanel = new JPanel(new GridBagLayout());
        panel2.addToCenter((Component)scopesPanel);
        int maxColumns = this.myViewItems.stream().mapToInt(x -> x.additionalComponents.size()).max().orElse(0) + 1;
        int gridY = 0;
        JRadioButton[] buttons = new JRadioButton[this.myViewItems.size()];
        GridBagConstraints gbc = new GridBagConstraints();
        for (ModelScopeItemView x2 : this.myViewItems) {
            JRadioButton button = x2.button;
            List<JComponent> components = x2.additionalComponents;
            int gridX = 0;
            buttons[gridY] = button;
            this.myGroup.add(button);
            int countExtraColumns = components.size();
            gbc.gridy = gridY;
            gbc.gridx = gridX;
            gbc.gridwidth = countExtraColumns == 0 ? maxColumns : 1;
            gbc.weightx = 0.0;
            gbc.fill = 0;
            gbc.anchor = 17;
            gbc.insets = JBUI.insetsLeft((int)10);
            scopesPanel.add((Component)button, gbc);
            ++gridX;
            for (JComponent c : components) {
                if (c instanceof Disposable) {
                    Disposer.register((Disposable)this.myDisposable, (Disposable)((Disposable)c));
                }
                gbc.gridy = gridY;
                gbc.gridx = gridX++;
                gbc.gridwidth = 1;
                gbc.weightx = 1.0;
                gbc.fill = 2;
                gbc.anchor = 13;
                gbc.insets = JBUI.insetsLeft((int)5);
                scopesPanel.add((Component)c, gbc);
            }
            ++gridY;
        }
        this.myInspectTestSource.setText(AnalysisScopeBundle.message((String)"scope.option.include.test.sources", (Object[])new Object[0]));
        this.myInspectTestSource.setSelected(this.myOptions.ANALYZE_TEST_SOURCES);
        this.myInspectTestSource.setVisible(this.myShowInspectTestSource);
        gbc.gridy = gridY;
        gbc.gridx = 0;
        gbc.gridwidth = maxColumns;
        gbc.weightx = 1.0;
        gbc.fill = 0;
        gbc.anchor = 17;
        gbc.insets = JBUI.insetsLeft((int)10);
        scopesPanel.add((Component)this.myInspectTestSource, gbc);
        this.preselectButton();
        BorderLayoutPanel wholePanel = new BorderLayoutPanel();
        wholePanel.addToTop((Component)panel2);
        JComponent additionalPanel = this.getAdditionalActionSettings(this.myProject);
        if (additionalPanel != null) {
            wholePanel.addToCenter((Component)additionalPanel);
        }
        new RadioUpDownListener(buttons);
        return wholePanel;
    }

    private void preselectButton() {
        if (this.myRememberScope) {
            int type = this.myOptions.SCOPE_TYPE;
            List preselectedScopes = this.myViewItems.stream().filter(x -> x.scopeId == type).collect(Collectors.toList());
            if (preselectedScopes.size() >= 1) {
                LOG.assertTrue(preselectedScopes.size() == 1, (Object)"preselectedScopes.size() == 1");
                ((ModelScopeItemView)preselectedScopes.get((int)0)).button.setSelected(true);
                return;
            }
        }
        ArrayList<ModelScopeItemView> candidates = new ArrayList<ModelScopeItemView>();
        for (ModelScopeItemView view : this.myViewItems) {
            candidates.add(view);
            if (view.scopeId != 3) continue;
            break;
        }
        Collections.reverse(candidates);
        for (ModelScopeItemView x2 : candidates) {
            int scopeType = x2.scopeId;
            if (scopeType == 8 || scopeType == 10) continue;
            x2.button.setSelected(true);
            break;
        }
    }

    public JComponent getPreferredFocusedComponent() {
        Enumeration<AbstractButton> enumeration = this.myGroup.getElements();
        while (enumeration.hasMoreElements()) {
            AbstractButton button = enumeration.nextElement();
            if (!button.isSelected()) continue;
            return button;
        }
        return super.getPreferredFocusedComponent();
    }

    @Deprecated
    public AnalysisScope getScope(@NotNull AnalysisUIOptions uiOptions, @NotNull AnalysisScope defaultScope, @NotNull Project project, Module module) {
        if (uiOptions == null) {
            BaseAnalysisActionDialog.$$$reportNull$$$0(15);
        }
        if (defaultScope == null) {
            BaseAnalysisActionDialog.$$$reportNull$$$0(16);
        }
        if (project == null) {
            BaseAnalysisActionDialog.$$$reportNull$$$0(17);
        }
        return this.getScope(defaultScope);
    }

    public boolean isProjectScopeSelected() {
        return this.myViewItems.stream().filter(x -> x.scopeId == 1).findFirst().map(x -> x.button.isSelected()).orElse(false);
    }

    public boolean isModuleScopeSelected() {
        return this.myViewItems.stream().filter(x -> x.scopeId == 4).findFirst().map(x -> x.button.isSelected()).orElse(false);
    }

    public boolean isUncommittedFilesSelected() {
        return this.myViewItems.stream().filter(x -> x.scopeId == 10).findFirst().map(x -> x.button.isSelected()).orElse(false);
    }

    @Nullable
    public SearchScope getCustomScope() {
        return this.myViewItems.stream().filter(x -> x.scopeId == 8 && x.button.isSelected()).findFirst().map(x -> x.model.getScope().toSearchScope()).orElse(null);
    }

    public boolean isInspectTestSources() {
        return this.myInspectTestSource.isSelected();
    }

    public AnalysisScope getScope(@NotNull AnalysisScope defaultScope) {
        if (defaultScope == null) {
            BaseAnalysisActionDialog.$$$reportNull$$$0(18);
        }
        AnalysisScope scope = null;
        for (ModelScopeItemView x : this.myViewItems) {
            if (!x.button.isSelected()) continue;
            int type = x.scopeId;
            scope = x.model.getScope();
            if (!this.myRememberScope) continue;
            this.myOptions.SCOPE_TYPE = type;
            if (type != 8) continue;
            this.myOptions.CUSTOM_SCOPE_NAME = scope.toSearchScope().getDisplayName();
        }
        if (scope == null) {
            scope = defaultScope;
            if (this.myRememberScope) {
                this.myOptions.SCOPE_TYPE = scope.getScopeType();
            }
        }
        if (this.myInspectTestSource.isVisible()) {
            if (this.myRememberScope) {
                this.myOptions.ANALYZE_TEST_SOURCES = this.isInspectTestSources();
            }
            scope.setIncludeTestSource(this.isInspectTestSources());
        }
        FindSettings.getInstance().setDefaultScopeName(scope.getDisplayName());
        return scope;
    }

    @Nullable
    protected JComponent getAdditionalActionSettings(Project project) {
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 1: 
            case 6: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "analysisNoon";
                break;
            }
            case 2: 
            case 7: 
            case 12: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 4: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "analysisUIOptions";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "items";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "uiOptions";
                break;
            }
            case 16: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultScope";
                break;
            }
        }
        objectArray2[1] = "com/intellij/analysis/BaseAnalysisActionDialog";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[2] = "getScope";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

