/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.ide.ui.AntialiasingType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.editor.DefaultLanguageHighlighterColors;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorCustomElementRenderer;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.colors.EditorFontType;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.impl.FontInfo;
import com.intellij.openapi.editor.markup.EffectType;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.ui.GraphicsConfig;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.ui.paint.EffectPainter;
import com.intellij.util.Alarm;
import com.intellij.util.ui.GraphicsUtil;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.swing.UIManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ParameterHintsPresentationManager
implements Disposable {
    private static final Key<MyFontMetrics> HINT_FONT_METRICS = Key.create((String)"ParameterHintFontMetrics");
    private static final Key<AnimationStep> ANIMATION_STEP = Key.create((String)"ParameterHintAnimationStep");
    private static final int ANIMATION_STEP_MS = 25;
    private static final int ANIMATION_CHARS_PER_STEP = 3;
    private static final float BACKGROUND_ALPHA = 0.55f;
    private final Alarm myAlarm = new Alarm((Disposable)this);

    public static ParameterHintsPresentationManager getInstance() {
        return (ParameterHintsPresentationManager)ServiceManager.getService(ParameterHintsPresentationManager.class);
    }

    private ParameterHintsPresentationManager() {
    }

    public boolean isParameterHint(@NotNull Inlay inlay) {
        if (inlay == null) {
            ParameterHintsPresentationManager.$$$reportNull$$$0(0);
        }
        return inlay.getRenderer() instanceof MyRenderer;
    }

    public String getHintText(@NotNull Inlay inlay) {
        EditorCustomElementRenderer renderer;
        if (inlay == null) {
            ParameterHintsPresentationManager.$$$reportNull$$$0(1);
        }
        return (renderer = inlay.getRenderer()) instanceof MyRenderer ? ((MyRenderer)renderer).getText() : null;
    }

    public Inlay addHint(@NotNull Editor editor, int offset, boolean relatesToPrecedingText, @NotNull String hintText, boolean useAnimation) {
        if (editor == null) {
            ParameterHintsPresentationManager.$$$reportNull$$$0(2);
        }
        if (hintText == null) {
            ParameterHintsPresentationManager.$$$reportNull$$$0(3);
        }
        MyRenderer renderer = new MyRenderer(editor, hintText, useAnimation);
        Inlay inlay = editor.getInlayModel().addInlineElement(offset, relatesToPrecedingText, (EditorCustomElementRenderer)renderer);
        if (inlay != null && useAnimation) {
            this.scheduleRendererUpdate(editor, inlay);
        }
        return inlay;
    }

    public void deleteHint(@NotNull Editor editor, @NotNull Inlay hint, boolean useAnimation) {
        if (editor == null) {
            ParameterHintsPresentationManager.$$$reportNull$$$0(4);
        }
        if (hint == null) {
            ParameterHintsPresentationManager.$$$reportNull$$$0(5);
        }
        if (useAnimation) {
            this.updateRenderer(editor, hint, null);
        } else {
            Disposer.dispose((Disposable)hint);
        }
    }

    public void replaceHint(@NotNull Editor editor, @NotNull Inlay hint, @NotNull String newText) {
        if (editor == null) {
            ParameterHintsPresentationManager.$$$reportNull$$$0(6);
        }
        if (hint == null) {
            ParameterHintsPresentationManager.$$$reportNull$$$0(7);
        }
        if (newText == null) {
            ParameterHintsPresentationManager.$$$reportNull$$$0(8);
        }
        this.updateRenderer(editor, hint, newText);
    }

    public void setHighlighted(@NotNull Inlay hint, boolean highlighted) {
        if (hint == null) {
            ParameterHintsPresentationManager.$$$reportNull$$$0(9);
        }
        if (!this.isParameterHint(hint)) {
            throw new IllegalArgumentException("Not a parameter hint");
        }
        MyRenderer renderer = (MyRenderer)hint.getRenderer();
        boolean oldValue = renderer.highlighted;
        if (highlighted != oldValue) {
            renderer.highlighted = highlighted;
            hint.repaint();
        }
    }

    public boolean isHighlighted(@NotNull Inlay hint) {
        if (hint == null) {
            ParameterHintsPresentationManager.$$$reportNull$$$0(10);
        }
        if (!this.isParameterHint(hint)) {
            throw new IllegalArgumentException("Not a parameter hint");
        }
        MyRenderer renderer = (MyRenderer)hint.getRenderer();
        return renderer.highlighted;
    }

    public void setCurrent(@NotNull Inlay hint, boolean current) {
        if (hint == null) {
            ParameterHintsPresentationManager.$$$reportNull$$$0(11);
        }
        if (!this.isParameterHint(hint)) {
            throw new IllegalArgumentException("Not a parameter hint");
        }
        MyRenderer renderer = (MyRenderer)hint.getRenderer();
        boolean oldValue = renderer.current;
        if (current != oldValue) {
            renderer.current = current;
            hint.repaint();
        }
    }

    public boolean isCurrent(@NotNull Inlay hint) {
        if (hint == null) {
            ParameterHintsPresentationManager.$$$reportNull$$$0(12);
        }
        if (!this.isParameterHint(hint)) {
            throw new IllegalArgumentException("Not a parameter hint");
        }
        MyRenderer renderer = (MyRenderer)hint.getRenderer();
        return renderer.current;
    }

    private void updateRenderer(@NotNull Editor editor, @NotNull Inlay hint, @Nullable String newText) {
        if (editor == null) {
            ParameterHintsPresentationManager.$$$reportNull$$$0(13);
        }
        if (hint == null) {
            ParameterHintsPresentationManager.$$$reportNull$$$0(14);
        }
        MyRenderer renderer = (MyRenderer)hint.getRenderer();
        renderer.update(editor, newText, true);
        hint.updateSize();
        this.scheduleRendererUpdate(editor, hint);
    }

    public void dispose() {
    }

    private void scheduleRendererUpdate(@NotNull Editor editor, @NotNull Inlay inlay) {
        if (editor == null) {
            ParameterHintsPresentationManager.$$$reportNull$$$0(15);
        }
        if (inlay == null) {
            ParameterHintsPresentationManager.$$$reportNull$$$0(16);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        AnimationStep step = (AnimationStep)editor.getUserData(ANIMATION_STEP);
        if (step == null) {
            step = new AnimationStep(editor);
            editor.putUserData(ANIMATION_STEP, (Object)step);
        }
        step.inlays.add(inlay);
        this.scheduleAnimationStep(step);
    }

    private void scheduleAnimationStep(@NotNull AnimationStep step) {
        if (step == null) {
            ParameterHintsPresentationManager.$$$reportNull$$$0(17);
        }
        this.myAlarm.cancelRequest((Runnable)step);
        this.myAlarm.addRequest((Runnable)step, 25, ModalityState.any());
    }

    public boolean isAnimationInProgress(@NotNull Editor editor) {
        if (editor == null) {
            ParameterHintsPresentationManager.$$$reportNull$$$0(18);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        return editor.getUserData(ANIMATION_STEP) != null;
    }

    private static Font getFont(@NotNull Editor editor) {
        if (editor == null) {
            ParameterHintsPresentationManager.$$$reportNull$$$0(19);
        }
        return ParameterHintsPresentationManager.getFontMetrics(editor).getFont();
    }

    private static MyFontMetrics getFontMetrics(@NotNull Editor editor) {
        if (editor == null) {
            ParameterHintsPresentationManager.$$$reportNull$$$0(20);
        }
        String familyName = UIManager.getFont("Label.font").getFamily();
        int size = Math.max(1, editor.getColorsScheme().getEditorFontSize() - 1);
        MyFontMetrics metrics = (MyFontMetrics)editor.getUserData(HINT_FONT_METRICS);
        if (metrics != null && !metrics.isActual(editor, familyName, size)) {
            metrics = null;
        }
        if (metrics == null) {
            metrics = new MyFontMetrics(editor, familyName, size);
            editor.putUserData(HINT_FONT_METRICS, (Object)metrics);
        }
        return metrics;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inlay";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 13: 
            case 15: 
            case 18: 
            case 19: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hintText";
                break;
            }
            case 5: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hint";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newText";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "step";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInsight/daemon/impl/ParameterHintsPresentationManager";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isParameterHint";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getHintText";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "addHint";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "deleteHint";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "replaceHint";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "setHighlighted";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "isHighlighted";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "setCurrent";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "isCurrent";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[2] = "updateRenderer";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[2] = "scheduleRendererUpdate";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[2] = "scheduleAnimationStep";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[2] = "isAnimationInProgress";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[2] = "getFont";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[2] = "getFontMetrics";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private class AnimationStep
    implements Runnable {
        private final Editor myEditor;
        private final Set<Inlay> inlays;

        AnimationStep(Editor editor) {
            if (editor == null) {
                AnimationStep.$$$reportNull$$$0(0);
            }
            this.inlays = new HashSet<Inlay>();
            this.myEditor = editor;
            Disposer.register((Disposable)((EditorImpl)editor).getDisposable(), () -> ParameterHintsPresentationManager.this.myAlarm.cancelRequest((Runnable)this));
        }

        @Override
        public void run() {
            Iterator<Inlay> it = this.inlays.iterator();
            while (it.hasNext()) {
                Inlay inlay = it.next();
                if (inlay.isValid()) {
                    MyRenderer renderer = (MyRenderer)inlay.getRenderer();
                    if (!renderer.nextStep()) {
                        it.remove();
                    }
                    if (renderer.calcWidthInPixels(this.myEditor) == 0) {
                        Disposer.dispose((Disposable)inlay);
                        continue;
                    }
                    inlay.updateSize();
                    continue;
                }
                it.remove();
            }
            if (this.inlays.isEmpty()) {
                this.myEditor.putUserData(ANIMATION_STEP, null);
            } else {
                ParameterHintsPresentationManager.this.scheduleAnimationStep(this);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/daemon/impl/ParameterHintsPresentationManager$AnimationStep", "<init>"));
        }
    }

    private static class MyRenderer
    implements EditorCustomElementRenderer {
        private String myText;
        private int startWidth;
        private int steps;
        private int step;
        private boolean highlighted;
        private boolean current;

        private MyRenderer(Editor editor, String text, boolean animated) {
            this.updateState(editor, text, animated);
        }

        private String getText() {
            return this.myText;
        }

        public void update(Editor editor, String newText, boolean animated) {
            this.updateState(editor, newText, animated);
        }

        @Nullable
        public String getContextMenuGroupId() {
            return "ParameterNameHints";
        }

        private void updateState(Editor editor, String text, boolean animated) {
            FontMetrics metrics = ParameterHintsPresentationManager.getFontMetrics(editor).metrics;
            this.startWidth = MyRenderer.doCalcWidth(this.myText, metrics);
            this.myText = text;
            int endWidth = MyRenderer.doCalcWidth(this.myText, metrics);
            this.steps = Math.max(1, Math.abs(endWidth - this.startWidth) / metrics.charWidth('a') / 3);
            this.step = animated ? 1 : this.steps + 1;
        }

        public boolean nextStep() {
            return ++this.step <= this.steps;
        }

        public int calcWidthInPixels(@NotNull Editor editor) {
            if (editor == null) {
                MyRenderer.$$$reportNull$$$0(0);
            }
            FontMetrics metrics = ParameterHintsPresentationManager.getFontMetrics(editor).metrics;
            int endWidth = MyRenderer.doCalcWidth(this.myText, metrics);
            return this.step <= this.steps ? Math.max(1, this.startWidth + (endWidth - this.startWidth) / this.steps * this.step) : endWidth;
        }

        private static int doCalcWidth(@Nullable String text, @NotNull FontMetrics fontMetrics) {
            if (fontMetrics == null) {
                MyRenderer.$$$reportNull$$$0(1);
            }
            return text == null ? 0 : fontMetrics.stringWidth(text) + 14;
        }

        public void paint(@NotNull Editor editor, @NotNull Graphics g, @NotNull Rectangle r, @NotNull TextAttributes textAttributes) {
            TextAttributes attributes;
            if (editor == null) {
                MyRenderer.$$$reportNull$$$0(2);
            }
            if (g == null) {
                MyRenderer.$$$reportNull$$$0(3);
            }
            if (r == null) {
                MyRenderer.$$$reportNull$$$0(4);
            }
            if (textAttributes == null) {
                MyRenderer.$$$reportNull$$$0(5);
            }
            if (!(editor instanceof EditorImpl)) {
                return;
            }
            int ascent = ((EditorImpl)editor).getAscent();
            int descent = ((EditorImpl)editor).getDescent();
            Graphics2D g2d = (Graphics2D)g;
            if (this.myText != null && (this.step > this.steps || this.startWidth != 0) && (attributes = editor.getColorsScheme().getAttributes(this.highlighted ? DefaultLanguageHighlighterColors.INLINE_PARAMETER_HINT_HIGHLIGHTED : DefaultLanguageHighlighterColors.INLINE_PARAMETER_HINT)) != null) {
                Color foregroundColor;
                MyFontMetrics fontMetrics = ParameterHintsPresentationManager.getFontMetrics(editor);
                int gap = r.height < fontMetrics.lineHeight + 2 ? 1 : 2;
                Color backgroundColor = attributes.getBackgroundColor();
                if (backgroundColor != null) {
                    GraphicsConfig config = GraphicsUtil.setupAAPainting((Graphics)g);
                    GraphicsUtil.paintWithAlpha((Graphics)g, (float)0.55f);
                    g.setColor(backgroundColor);
                    g.fillRoundRect(r.x + 2, r.y + gap, r.width - 4, r.height - gap * 2, 8, 8);
                    config.restore();
                }
                if ((foregroundColor = attributes.getForegroundColor()) != null) {
                    Object savedHint = g2d.getRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING);
                    Shape savedClip = g.getClip();
                    g.setColor(foregroundColor);
                    g.setFont(ParameterHintsPresentationManager.getFont(editor));
                    g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, AntialiasingType.getKeyForCurrentScope((boolean)false));
                    g.clipRect(r.x + 3, r.y + 2, r.width - 6, r.height - 4);
                    FontMetrics metrics = fontMetrics.metrics;
                    g.drawString(this.myText, r.x + 7, r.y + Math.max(ascent, (r.height + metrics.getAscent() - metrics.getDescent()) / 2) - 1);
                    g.setClip(savedClip);
                    g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, savedHint);
                    if (this.current) {
                        savedHint = g2d.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
                        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                        g.drawRoundRect(r.x + 2, r.y + gap, r.width - 4, r.height - gap * 2, 8, 8);
                        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, savedHint);
                    }
                }
            }
            Color effectColor = textAttributes.getEffectColor();
            EffectType effectType = textAttributes.getEffectType();
            if (effectColor != null) {
                g.setColor(effectColor);
                int xStart = r.x;
                int xEnd = r.x + r.width;
                int y = r.y + ascent;
                Font font = editor.getColorsScheme().getFont(EditorFontType.PLAIN);
                if (effectType == EffectType.LINE_UNDERSCORE) {
                    EffectPainter.LINE_UNDERSCORE.paint(g2d, xStart, y, xEnd - xStart, descent, (Object)font);
                } else if (effectType == EffectType.BOLD_LINE_UNDERSCORE) {
                    EffectPainter.BOLD_LINE_UNDERSCORE.paint(g2d, xStart, y, xEnd - xStart, descent, (Object)font);
                } else if (effectType == EffectType.STRIKEOUT) {
                    EffectPainter.STRIKE_THROUGH.paint(g2d, xStart, y, xEnd - xStart, ((EditorImpl)editor).getCharHeight(), (Object)font);
                } else if (effectType == EffectType.WAVE_UNDERSCORE) {
                    EffectPainter.WAVE_UNDERSCORE.paint(g2d, xStart, y, xEnd - xStart, descent, (Object)font);
                } else if (effectType == EffectType.BOLD_DOTTED_LINE) {
                    EffectPainter.BOLD_DOTTED_UNDERSCORE.paint(g2d, xStart, y, xEnd - xStart, descent, (Object)font);
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fontMetrics";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "g";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "r";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "textAttributes";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/codeInsight/daemon/impl/ParameterHintsPresentationManager$MyRenderer";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "calcWidthInPixels";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "doCalcWidth";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "paint";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class MyFontMetrics {
        private final FontMetrics metrics;
        private final int lineHeight;

        private MyFontMetrics(Editor editor, String familyName, int size) {
            Font font = new Font(familyName, 0, size);
            FontRenderContext context = MyFontMetrics.getCurrentContext(editor);
            this.metrics = FontInfo.getFontMetrics(font, context);
            this.lineHeight = (int)Math.ceil(font.createGlyphVector(context, "Ap").getVisualBounds().getHeight());
        }

        private boolean isActual(Editor editor, String familyName, int size) {
            Font font = this.metrics.getFont();
            if (!familyName.equals(font.getFamily()) || size != font.getSize()) {
                return false;
            }
            FontRenderContext currentContext = MyFontMetrics.getCurrentContext(editor);
            return currentContext.equals(this.metrics.getFontRenderContext());
        }

        private static FontRenderContext getCurrentContext(@NotNull Editor editor) {
            if (editor == null) {
                MyFontMetrics.$$$reportNull$$$0(0);
            }
            FontRenderContext editorContext = FontInfo.getFontRenderContext(editor.getContentComponent());
            return new FontRenderContext(editorContext.getTransform(), AntialiasingType.getKeyForCurrentScope((boolean)false), editor instanceof EditorImpl ? ((EditorImpl)editor).myFractionalMetricsHintValue : RenderingHints.VALUE_FRACTIONALMETRICS_OFF);
        }

        private Font getFont() {
            return this.metrics.getFont();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/daemon/impl/ParameterHintsPresentationManager$MyFontMetrics", "getCurrentContext"));
        }
    }
}

