/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.analysis;

import com.intellij.codeInsight.daemon.XmlErrorMessages;
import com.intellij.codeInsight.editorActions.XmlEditUtil;
import com.intellij.codeInsight.intention.HighPriorityAction;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.ExpressionContext;
import com.intellij.codeInsight.template.Result;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.codeInsight.template.TextResult;
import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.html.HtmlTag;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.xml.XmlChildRole;
import com.intellij.psi.xml.XmlTag;
import com.intellij.xml.XmlAttributeDescriptor;
import com.intellij.xml.XmlElementDescriptor;
import com.intellij.xml.XmlExtension;
import com.intellij.xml.util.HtmlUtil;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InsertRequiredAttributeFix
extends LocalQuickFixAndIntentionActionOnPsiElement
implements HighPriorityAction {
    private final String myAttrName;
    private final String[] myValues;
    @NonNls
    private static final String NAME_TEMPLATE_VARIABLE = "name";

    public InsertRequiredAttributeFix(@NotNull XmlTag tag, @NotNull String attrName, String ... values) {
        if (tag == null) {
            InsertRequiredAttributeFix.$$$reportNull$$$0(0);
        }
        if (attrName == null) {
            InsertRequiredAttributeFix.$$$reportNull$$$0(1);
        }
        if (values == null) {
            InsertRequiredAttributeFix.$$$reportNull$$$0(2);
        }
        super((PsiElement)tag);
        this.myAttrName = attrName;
        this.myValues = values;
    }

    @NotNull
    public String getText() {
        String string = XmlErrorMessages.message("insert.required.attribute.quickfix.text", this.myAttrName);
        if (string == null) {
            InsertRequiredAttributeFix.$$$reportNull$$$0(3);
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = XmlErrorMessages.message("insert.required.attribute.quickfix.family", new Object[0]);
        if (string == null) {
            InsertRequiredAttributeFix.$$$reportNull$$$0(4);
        }
        return string;
    }

    public void invoke(@NotNull Project project, @NotNull PsiFile file2, @Nullable(value="is null when called from inspection") Editor editor, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        boolean anchorIsEmptyTag;
        if (project == null) {
            InsertRequiredAttributeFix.$$$reportNull$$$0(5);
        }
        if (file2 == null) {
            InsertRequiredAttributeFix.$$$reportNull$$$0(6);
        }
        if (startElement == null) {
            InsertRequiredAttributeFix.$$$reportNull$$$0(7);
        }
        if (endElement == null) {
            InsertRequiredAttributeFix.$$$reportNull$$$0(8);
        }
        XmlTag myTag = (XmlTag)startElement;
        ASTNode treeElement = SourceTreeToPsiMap.psiElementToTree((PsiElement)myTag);
        XmlElementDescriptor descriptor = myTag.getDescriptor();
        if (descriptor == null) {
            return;
        }
        XmlAttributeDescriptor attrDescriptor = descriptor.getAttributeDescriptor(this.myAttrName, myTag);
        boolean indirectSyntax = XmlExtension.getExtension(myTag.getContainingFile()).isIndirectSyntax(attrDescriptor);
        boolean insertShorthand = myTag instanceof HtmlTag && attrDescriptor != null && HtmlUtil.isBooleanAttribute(attrDescriptor, (PsiElement)myTag);
        PsiElement anchor2 = SourceTreeToPsiMap.treeElementToPsi(XmlChildRole.EMPTY_TAG_END_FINDER.findChild(treeElement));
        boolean bl = anchorIsEmptyTag = anchor2 != null;
        if (anchor2 == null) {
            anchor2 = SourceTreeToPsiMap.treeElementToPsi(XmlChildRole.START_TAG_END_FINDER.findChild(treeElement));
        }
        if (anchor2 == null) {
            return;
        }
        Template template = TemplateManager.getInstance(project).createTemplate("", "");
        String valuePostfix = "\"";
        if (indirectSyntax) {
            if (anchorIsEmptyTag) {
                template.addTextSegment(">");
            }
            template.addTextSegment("<jsp:attribute name=\"" + this.myAttrName + "\">");
        } else {
            template.addTextSegment(" " + this.myAttrName);
            if (!insertShorthand) {
                String quote = XmlEditUtil.getAttributeQuote(file2);
                XmlExtension.AttributeValuePresentation presentation = XmlExtension.getExtension(file2).getAttributeValuePresentation(attrDescriptor, quote);
                valuePostfix = presentation.getPostfix();
                template.addTextSegment("=" + presentation.getPrefix());
            }
        }
        Expression expression = new Expression(){
            final TextResult result = new TextResult("");

            public Result calculateResult(ExpressionContext context) {
                return this.result;
            }

            public Result calculateQuickResult(ExpressionContext context) {
                return null;
            }

            public LookupElement[] calculateLookupItems(ExpressionContext context) {
                LookupElement[] items = new LookupElement[InsertRequiredAttributeFix.this.myValues.length];
                for (int i = 0; i < items.length; ++i) {
                    items[i] = LookupElementBuilder.create((String)InsertRequiredAttributeFix.this.myValues[i]);
                }
                return items;
            }
        };
        if (!insertShorthand) {
            template.addVariable(NAME_TEMPLATE_VARIABLE, expression, expression, true);
        }
        if (indirectSyntax) {
            template.addTextSegment("</jsp:attribute>");
            template.addEndVariable();
            if (anchorIsEmptyTag) {
                template.addTextSegment("</" + myTag.getName() + ">");
            }
        } else if (!insertShorthand) {
            template.addTextSegment(valuePostfix);
        }
        PsiElement anchor1 = anchor2;
        Runnable runnable2 = () -> {
            if (project == null) {
                InsertRequiredAttributeFix.$$$reportNull$$$0(10);
            }
            ApplicationManager.getApplication().runWriteAction(() -> {
                if (project == null) {
                    InsertRequiredAttributeFix.$$$reportNull$$$0(11);
                }
                int textOffset = anchor1.getTextOffset();
                if (!anchorIsEmptyTag && indirectSyntax) {
                    ++textOffset;
                }
                editor.getCaretModel().moveToOffset(textOffset);
                if (anchorIsEmptyTag && indirectSyntax) {
                    editor.getDocument().deleteString(textOffset, textOffset + 2);
                }
                TemplateManager.getInstance(project).startTemplate(editor, template);
            });
        };
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            Runnable commandRunnable = () -> {
                if (project == null) {
                    InsertRequiredAttributeFix.$$$reportNull$$$0(9);
                }
                CommandProcessor.getInstance().executeCommand(project, runnable2, this.getText(), (Object)this.getFamilyName());
            };
            ApplicationManager.getApplication().invokeLater(commandRunnable);
        } else {
            runnable2.run();
        }
    }

    public boolean startInWriteAction() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tag";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attrName";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "values";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/analysis/InsertRequiredAttributeFix";
                break;
            }
            case 5: 
            case 9: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startElement";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "endElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/analysis/InsertRequiredAttributeFix";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "lambda$invoke$2";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "lambda$invoke$1";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "lambda$null$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

