/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.postfix.settings;

import com.intellij.codeInsight.template.postfix.templates.PostfixTemplate;
import com.intellij.codeInsight.template.postfix.templates.PostfixTemplateProvider;
import com.intellij.codeInsight.template.postfix.templates.PostfixTemplatesUtils;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.util.Factory;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xmlb.SerializationFilter;
import com.intellij.util.xmlb.SkipDefaultValuesSerializationFilters;
import com.intellij.util.xmlb.XmlSerializer;
import com.intellij.util.xmlb.annotations.MapAnnotation;
import java.util.Map;
import java.util.Set;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="PostfixTemplatesSettings", storages={@Storage(value="postfixTemplates.xml")})
public class PostfixTemplatesSettings
implements PersistentStateComponent<Element> {
    public static final Factory<Set<String>> SET_FACTORY = () -> ContainerUtil.newHashSet();
    private Map<String, Set<String>> myLangToDisabledTemplates = ContainerUtil.newHashMap();
    private boolean postfixTemplatesEnabled = true;
    private boolean templatesCompletionEnabled = true;
    private int myShortcut = 9;

    public boolean isTemplateEnabled(@NotNull PostfixTemplate template, @NotNull PostfixTemplateProvider provider) {
        if (template == null) {
            PostfixTemplatesSettings.$$$reportNull$$$0(0);
        }
        if (provider == null) {
            PostfixTemplatesSettings.$$$reportNull$$$0(1);
        }
        String langForProvider = PostfixTemplatesUtils.getLangForProvider(provider);
        return this.isTemplateEnabled(template, langForProvider);
    }

    public boolean isTemplateEnabled(PostfixTemplate template, @NotNull String strictLangForProvider) {
        Set<String> result2;
        if (strictLangForProvider == null) {
            PostfixTemplatesSettings.$$$reportNull$$$0(2);
        }
        return (result2 = this.myLangToDisabledTemplates.get(strictLangForProvider)) == null || !result2.contains(template.getKey());
    }

    public void disableTemplate(@NotNull PostfixTemplate template, @NotNull PostfixTemplateProvider provider) {
        if (template == null) {
            PostfixTemplatesSettings.$$$reportNull$$$0(3);
        }
        if (provider == null) {
            PostfixTemplatesSettings.$$$reportNull$$$0(4);
        }
        String langForProvider = PostfixTemplatesUtils.getLangForProvider(provider);
        this.disableTemplate(template, langForProvider);
    }

    public void disableTemplate(PostfixTemplate template, String langForProvider) {
        Set state = (Set)ContainerUtil.getOrCreate(this.myLangToDisabledTemplates, (Object)langForProvider, SET_FACTORY);
        state.add(template.getKey());
    }

    public boolean isPostfixTemplatesEnabled() {
        return this.postfixTemplatesEnabled;
    }

    public void setPostfixTemplatesEnabled(boolean postfixTemplatesEnabled) {
        this.postfixTemplatesEnabled = postfixTemplatesEnabled;
    }

    public boolean isTemplatesCompletionEnabled() {
        return this.templatesCompletionEnabled;
    }

    public void setTemplatesCompletionEnabled(boolean templatesCompletionEnabled) {
        this.templatesCompletionEnabled = templatesCompletionEnabled;
    }

    @MapAnnotation(entryTagName="disabled-postfix-templates", keyAttributeName="lang", surroundWithTag=false)
    @NotNull
    public Map<String, Set<String>> getLangDisabledTemplates() {
        Map<String, Set<String>> map = this.myLangToDisabledTemplates;
        if (map == null) {
            PostfixTemplatesSettings.$$$reportNull$$$0(5);
        }
        return map;
    }

    public void setLangDisabledTemplates(@NotNull Map<String, Set<String>> templatesState) {
        if (templatesState == null) {
            PostfixTemplatesSettings.$$$reportNull$$$0(6);
        }
        this.myLangToDisabledTemplates = templatesState;
    }

    public int getShortcut() {
        return this.myShortcut;
    }

    public void setShortcut(int shortcut) {
        this.myShortcut = shortcut;
    }

    @Nullable
    public static PostfixTemplatesSettings getInstance() {
        return (PostfixTemplatesSettings)ServiceManager.getService(PostfixTemplatesSettings.class);
    }

    @Nullable
    public Element getState() {
        return XmlSerializer.serialize((Object)this, (SerializationFilter)new SkipDefaultValuesSerializationFilters());
    }

    public void loadState(Element settings) {
        XmlSerializer.deserializeInto((Object)this, (Element)settings);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "template";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "strictLangForProvider";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/template/postfix/settings/PostfixTemplatesSettings";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "templatesState";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/template/postfix/settings/PostfixTemplatesSettings";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getLangDisabledTemplates";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isTemplateEnabled";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "disableTemplate";
                break;
            }
            case 5: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "setLangDisabledTemplates";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

