/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.actions;

import com.intellij.analysis.AnalysisScope;
import com.intellij.analysis.PerformAnalysisInBackgroundOption;
import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.ex.GlobalInspectionContextImpl;
import com.intellij.codeInspection.ex.InspectionManagerEx;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.ex.Tools;
import com.intellij.codeInspection.offline.OfflineProblemDescriptor;
import com.intellij.codeInspection.offlineViewer.OfflineInspectionRVContentProvider;
import com.intellij.codeInspection.offlineViewer.OfflineViewParseUtil;
import com.intellij.codeInspection.reference.RefManagerImpl;
import com.intellij.codeInspection.ui.InspectionResultsView;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionPlaces;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileEditor.impl.LoadTextUtil;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.profile.codeInspection.InspectionProfileManager;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.PsiElement;
import com.intellij.util.PlatformUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ViewOfflineResultsAction
extends AnAction {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInspection.actions.ViewOfflineResultsAction");
    @NonNls
    private static final String XML_EXTENSION = "xml";

    public void update(AnActionEvent event) {
        Presentation presentation = event.getPresentation();
        Project project = (Project)event.getData(CommonDataKeys.PROJECT);
        presentation.setEnabled(project != null);
        presentation.setVisible(ActionPlaces.isMainMenuOrActionSearch((String)event.getPlace()) && !PlatformUtils.isCidr());
    }

    public void actionPerformed(AnActionEvent event) {
        final Project project = (Project)event.getData(CommonDataKeys.PROJECT);
        LOG.assertTrue(project != null);
        FileChooserDescriptor descriptor = new FileChooserDescriptor(false, true, false, false, false, false){

            public Icon getIcon(VirtualFile file2) {
                if (file2.isDirectory() && file2.findChild(".descriptions." + StdFileTypes.XML.getDefaultExtension()) != null) {
                    return AllIcons.Nodes.InspectionResults;
                }
                return super.getIcon(file2);
            }
        };
        descriptor.setTitle("Select Path");
        descriptor.setDescription("Select directory which contains exported inspections results");
        final VirtualFile virtualFile = FileChooser.chooseFile((FileChooserDescriptor)descriptor, (Project)project, null);
        if (virtualFile == null || !virtualFile.isDirectory()) {
            return;
        }
        final HashMap resMap = new HashMap();
        final String[] profileName = new String[1];
        ProgressManager.getInstance().run((Task)new Task.Backgroundable(project, InspectionsBundle.message((String)"parsing.inspections.dump.progress.title", (Object[])new Object[0]), true, new PerformAnalysisInBackgroundOption(project)){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    2.$$$reportNull$$$0(0);
                }
                VirtualFile[] files = virtualFile.getChildren();
                try {
                    for (VirtualFile inspectionFile : files) {
                        if (inspectionFile.isDirectory()) continue;
                        String shortName = inspectionFile.getNameWithoutExtension();
                        String extension = inspectionFile.getExtension();
                        if (shortName.equals(".descriptions")) {
                            profileName[0] = (String)ReadAction.compute(() -> OfflineViewParseUtil.parseProfileName(LoadTextUtil.loadText(inspectionFile).toString()));
                            continue;
                        }
                        if (!ViewOfflineResultsAction.XML_EXTENSION.equals(extension)) continue;
                        resMap.put(shortName, ReadAction.compute(() -> OfflineViewParseUtil.parse(LoadTextUtil.loadText(inspectionFile).toString())));
                    }
                }
                catch (Exception e) {
                    ApplicationManager.getApplication().invokeLater(() -> Messages.showInfoMessage((String)e.getMessage(), (String)InspectionsBundle.message((String)"offline.view.parse.exception.title", (Object[])new Object[0])));
                    throw new ProcessCanceledException();
                }
            }

            public void onSuccess() {
                ApplicationManager.getApplication().invokeLater(() -> {
                    String name = profileName[0];
                    ViewOfflineResultsAction.showOfflineView(project, name, resMap, InspectionsBundle.message((String)"offline.view.title", (Object[])new Object[0]) + " (" + (name != null ? name : InspectionsBundle.message((String)"offline.view.editor.settings.title", (Object[])new Object[0])) + ")");
                });
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/codeInspection/actions/ViewOfflineResultsAction$2", "run"));
            }
        });
    }

    public static InspectionResultsView showOfflineView(@NotNull Project project, @Nullable String profileName, @NotNull Map<String, Map<String, Set<OfflineProblemDescriptor>>> resMap, @NotNull String title) {
        InspectionProfileImpl inspectionProfile;
        InspectionProfileImpl profile2;
        if (project == null) {
            ViewOfflineResultsAction.$$$reportNull$$$0(0);
        }
        if (resMap == null) {
            ViewOfflineResultsAction.$$$reportNull$$$0(1);
        }
        if (title == null) {
            ViewOfflineResultsAction.$$$reportNull$$$0(2);
        }
        if (profileName != null) {
            profile2 = InspectionProjectProfileManager.getInstance(project).getProfile(profileName, false);
            if (profile2 == null) {
                profile2 = InspectionProfileManager.getInstance().getProfile(profileName, false);
            }
        } else {
            profile2 = null;
        }
        if (profile2 != null) {
            inspectionProfile = profile2;
        } else {
            inspectionProfile = new InspectionProfileImpl(profileName != null ? profileName : "Server Side"){

                @Override
                public HighlightDisplayLevel getErrorLevel(@NotNull HighlightDisplayKey key, PsiElement element) {
                    if (key == null) {
                        3.$$$reportNull$$$0(0);
                    }
                    return InspectionProfileManager.getInstance().getCurrentProfile().getErrorLevel(key, element);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/codeInspection/actions/ViewOfflineResultsAction$3", "getErrorLevel"));
                }
            };
            for (String id : resMap.keySet()) {
                if (inspectionProfile.getToolsOrNull(id, project) == null) continue;
                inspectionProfile.enableTool(id, project);
            }
        }
        return ViewOfflineResultsAction.showOfflineView(project, resMap, inspectionProfile, title);
    }

    @NotNull
    public static InspectionResultsView showOfflineView(@NotNull Project project, @NotNull Map<String, Map<String, Set<OfflineProblemDescriptor>>> resMap, @NotNull InspectionProfileImpl inspectionProfile, @NotNull String title) {
        if (project == null) {
            ViewOfflineResultsAction.$$$reportNull$$$0(3);
        }
        if (resMap == null) {
            ViewOfflineResultsAction.$$$reportNull$$$0(4);
        }
        if (inspectionProfile == null) {
            ViewOfflineResultsAction.$$$reportNull$$$0(5);
        }
        if (title == null) {
            ViewOfflineResultsAction.$$$reportNull$$$0(6);
        }
        AnalysisScope scope = new AnalysisScope(project);
        InspectionManagerEx managerEx = (InspectionManagerEx)InspectionManager.getInstance((Project)project);
        GlobalInspectionContextImpl context = managerEx.createNewGlobalContext(false);
        context.setExternalProfile(inspectionProfile);
        context.setCurrentScope(scope);
        context.initializeTools(new ArrayList<Tools>(), new ArrayList<Tools>(), new ArrayList<Tools>());
        InspectionResultsView view = new InspectionResultsView(context, new OfflineInspectionRVContentProvider(resMap, project));
        ((RefManagerImpl)context.getRefManager()).startOfflineView();
        context.addView(view, title, true);
        view.update();
        InspectionResultsView inspectionResultsView = view;
        if (inspectionResultsView == null) {
            ViewOfflineResultsAction.$$$reportNull$$$0(7);
        }
        return inspectionResultsView;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resMap";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inspectionProfile";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/actions/ViewOfflineResultsAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/actions/ViewOfflineResultsAction";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "showOfflineView";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "showOfflineView";
                break;
            }
            case 7: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

