/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.configurationStore;

import com.intellij.configurationStore.StateMapKt;
import com.intellij.openapi.util.JDOMUtil;
import gnu.trove.THashMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicReferenceArray;
import java.util.function.UnaryOperator;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.ArraysKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\b\u0003\n\u0002\u0010$\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010%\n\u0002\b\u0003\u0018\u0000  2\u00020\u0001:\u0001 B%\b\u0002\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u000e\u0010\u0005\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0006\u00a2\u0006\u0002\u0010\u0007J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00042\b\u0010\f\u001a\u0004\u0018\u00010\rJ$\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u00002\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00040\u0011J\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u000b\u001a\u00020\u0004J(\u0010\u0013\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000b\u001a\u00020\u00042\u0016\b\u0002\u0010\u0014\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\r\u0018\u00010\u0015J\u001a\u0010\u0016\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000b\u001a\u00020\u00042\b\b\u0002\u0010\t\u001a\u00020\u0017J\u000e\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u000b\u001a\u00020\u0004J\u0006\u0010\u0019\u001a\u00020\u0017J\u0006\u0010\u001a\u001a\u00020\u0017J\u0011\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u001cJ\u0012\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00010\u001eJ\b\u0010\u001f\u001a\u00020\u0004H\u0016R\u0016\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\bR\u0016\u0010\u0005\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/intellij/configurationStore/StateMap;", "", "names", "", "", "states", "Ljava/util/concurrent/atomic/AtomicReferenceArray;", "([Ljava/lang/String;Ljava/util/concurrent/atomic/AtomicReferenceArray;)V", "[Ljava/lang/String;", "archive", "", "key", "state", "Lorg/jdom/Element;", "compare", "newStates", "diffs", "", "get", "getElement", "newLiveStates", "", "getState", "", "hasState", "hasStates", "isEmpty", "keys", "()[Ljava/lang/String;", "toMutableMap", "", "toString", "Companion", "configuration-store-impl"})
public final class StateMap {
    private final String[] names;
    private final AtomicReferenceArray<Object> states;
    @NotNull
    private static final StateMap EMPTY;
    public static final Companion Companion;

    @NotNull
    public String toString() {
        String string;
        if (Intrinsics.areEqual((Object)this, (Object)Companion.getEMPTY())) {
            string = "EMPTY";
        } else {
            String string2 = this.states.toString();
            string = string2;
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"states.toString()");
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Map<String, Object> toMutableMap() {
        THashMap map = new THashMap(((Object[])this.names).length);
        int n = 0;
        int n2 = this.names.length;
        while (n < n2) {
            void i;
            map.put((Object)this.names[i], this.states.get((int)i));
            ++i;
        }
        return (Map)map;
    }

    @NotNull
    public final String[] keys() {
        return this.names;
    }

    @Nullable
    public final Object get(@NotNull String key) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        int index = Arrays.binarySearch(this.names, key);
        return index < 0 ? null : this.states.get(index);
    }

    @Nullable
    public final Element getElement(@NotNull String key, @Nullable Map<String, ? extends Element> newLiveStates) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        return StateMapKt.stateToElement(key, this.get(key), newLiveStates);
    }

    @Nullable
    public static /* bridge */ /* synthetic */ Element getElement$default(StateMap stateMap, String string, Map map, int n, Object object) {
        if ((n & 2) != 0) {
            map = null;
        }
        return stateMap.getElement(string, map);
    }

    public final boolean isEmpty() {
        Object[] objectArray = this.names;
        return objectArray.length == 0;
    }

    public final boolean hasState(@NotNull String key) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        return this.get(key) instanceof Element;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean hasStates() {
        int element$iv;
        int it;
        if (this.isEmpty()) return false;
        Iterable $receiver$iv = (Iterable)ArraysKt.getIndices((Object[])this.names);
        if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
            return false;
        }
        Iterator iterator = $receiver$iv.iterator();
        do {
            if (!iterator.hasNext()) return false;
        } while (!(this.states.get(it = (element$iv = ((IntIterator)iterator).nextInt())) instanceof Element));
        return true;
    }

    public final void compare(@NotNull String key, @NotNull StateMap newStates, @NotNull Set<String> diffs) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        Intrinsics.checkParameterIsNotNull((Object)newStates, (String)"newStates");
        Intrinsics.checkParameterIsNotNull(diffs, (String)"diffs");
        Object oldState = this.get(key);
        Object newState = newStates.get(key);
        if (oldState instanceof Element) {
            if (!JDOMUtil.areElementsEqual((Element)((Element)oldState), (Element)((Element)newState))) {
                diffs.add(key);
            }
        } else if (oldState == null) {
            if (newState != null) {
                diffs.add(key);
            }
        } else if (newState == null || StateMapKt.getNewByteIfDiffers(key, newState, (byte[])oldState) != null) {
            diffs.add(key);
        }
    }

    @Nullable
    public final Element getState(@NotNull String key, boolean archive) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        int index = Arrays.binarySearch(this.names, key);
        if (index < 0) {
            return null;
        }
        Object prev2 = this.states.getAndUpdate(index, new UnaryOperator<Object>(archive){
            final /* synthetic */ boolean $archive;

            @Nullable
            public final Object apply(@Nullable Object state) {
                return this.$archive && state instanceof Element ? (Object)StateMapKt.archiveState((Element)state).toByteArray() : state;
            }
            {
                this.$archive = bl;
            }
        });
        Object object = prev2;
        if (!(object instanceof Element)) {
            object = null;
        }
        return (Element)object;
    }

    @Nullable
    public static /* bridge */ /* synthetic */ Element getState$default(StateMap stateMap, String string, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return stateMap.getState(string, bl);
    }

    public final void archive(@NotNull String key, @Nullable Element state) {
        byte[] byArray;
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        int index = Arrays.binarySearch(this.names, key);
        if (index < 0) {
            return;
        }
        AtomicReferenceArray<Object> atomicReferenceArray = this.states;
        int n = index;
        Element element = state;
        if (element != null) {
            Element element2 = element;
            int n2 = n;
            AtomicReferenceArray<Object> atomicReferenceArray2 = atomicReferenceArray;
            Element it = element2;
            byte[] byArray2 = StateMapKt.archiveState(state).toByteArray();
            atomicReferenceArray = atomicReferenceArray2;
            n = n2;
            byArray = byArray2;
        } else {
            byArray = null;
        }
        atomicReferenceArray.set(n, byArray);
    }

    private StateMap(String[] names, AtomicReferenceArray<Object> states) {
        this.names = names;
        this.states = states;
    }

    static {
        StateMap stateMap;
        Companion = new Companion(null);
        StateMap stateMap2 = stateMap;
        StateMap stateMap3 = stateMap;
        String[] stringArray = new String[]{};
        stateMap2(stringArray, new AtomicReferenceArray<Object>(0));
        EMPTY = stateMap3;
    }

    public /* synthetic */ StateMap(@NotNull String[] names, @NotNull AtomicReferenceArray states, DefaultConstructorMarker $constructor_marker) {
        this(names, states);
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0007\u001a\u00020\u00042\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00010\tR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000b"}, d2={"Lcom/intellij/configurationStore/StateMap$Companion;", "", "()V", "EMPTY", "Lcom/intellij/configurationStore/StateMap;", "getEMPTY", "()Lcom/intellij/configurationStore/StateMap;", "fromMap", "map", "", "", "configuration-store-impl"})
    public static final class Companion {
        @NotNull
        public final StateMap getEMPTY() {
            return EMPTY;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final StateMap fromMap(@NotNull Map<String, ? extends Object> map) {
            Collection $receiver$iv;
            Intrinsics.checkParameterIsNotNull(map, (String)"map");
            if (map.isEmpty()) {
                return this.getEMPTY();
            }
            Collection collection = $receiver$iv = (Collection)map.keySet();
            if (collection == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.util.Collection<T>");
            }
            Collection thisCollection$iv22 = collection;
            String[] stringArray = thisCollection$iv22.toArray(new String[0]);
            if (stringArray == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            String[] names = stringArray;
            if (!(map instanceof TreeMap)) {
                Arrays.sort(names);
            }
            AtomicReferenceArray<Object> states = new AtomicReferenceArray<Object>(((Object[])names).length);
            int thisCollection$iv22 = 0;
            int n = names.length;
            while (thisCollection$iv22 < n) {
                void i;
                states.set((int)i, map.get(names[i]));
                ++i;
            }
            return new StateMap(names, states, null);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

