/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.conversion.impl;

import com.intellij.application.options.PathMacrosImpl;
import com.intellij.application.options.ReplacePathToMacroMap;
import com.intellij.conversion.CannotConvertException;
import com.intellij.conversion.ComponentManagerSettings;
import com.intellij.conversion.ConversionContext;
import com.intellij.conversion.ConverterProvider;
import com.intellij.conversion.ModuleSettings;
import com.intellij.conversion.ProjectSettings;
import com.intellij.conversion.WorkspaceSettings;
import com.intellij.conversion.impl.ArtifactsSettingsImpl;
import com.intellij.conversion.impl.ComponentManagerSettingsImpl;
import com.intellij.conversion.impl.ConversionRunner;
import com.intellij.conversion.impl.ModuleSettingsImpl;
import com.intellij.conversion.impl.ProjectLibrariesSettingsImpl;
import com.intellij.conversion.impl.ProjectSettingsImpl;
import com.intellij.conversion.impl.RunManagerSettingsImpl;
import com.intellij.conversion.impl.SettingsXmlFile;
import com.intellij.conversion.impl.WorkspaceSettingsImpl;
import com.intellij.ide.impl.convert.JDomConvertingUtil;
import com.intellij.ide.impl.convert.ProjectFileVersionState;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.components.ExpandMacroToPathMap;
import com.intellij.openapi.components.StorageScheme;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileFilters;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PathUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xmlb.XmlSerializer;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.serialization.JDomSerializationUtil;

public class ConversionContextImpl
implements ConversionContext {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.conversion.impl.ConversionContextImpl");
    private final Map<File, SettingsXmlFile> mySettingsFiles = new HashMap<File, SettingsXmlFile>();
    private final StorageScheme myStorageScheme;
    private final File myProjectBaseDir;
    private final File myProjectFile;
    private final File myWorkspaceFile;
    private final File[] myModuleFiles;
    private ProjectSettingsImpl myProjectSettings;
    private WorkspaceSettingsImpl myWorkspaceSettings;
    private final List<File> myNonExistingModuleFiles = new ArrayList<File>();
    private final Map<File, ModuleSettingsImpl> myFile2ModuleSettings = new HashMap<File, ModuleSettingsImpl>();
    private final Map<String, ModuleSettingsImpl> myName2ModuleSettings = new HashMap<String, ModuleSettingsImpl>();
    private RunManagerSettingsImpl myRunManagerSettings;
    private File mySettingsBaseDir;
    private ComponentManagerSettings myCompilerManagerSettings;
    private ComponentManagerSettings myProjectRootManagerSettings;
    private ComponentManagerSettingsImpl myModulesSettings;
    private ProjectLibrariesSettingsImpl myProjectLibrariesSettings;
    private ArtifactsSettingsImpl myArtifactsSettings;
    private ComponentManagerSettings myProjectFileVersionSettings;
    private final Set<String> myPerformedConversionIds;

    public ConversionContextImpl(String projectPath) throws CannotConvertException {
        File modulesFile;
        this.myProjectFile = new File(projectPath);
        if (this.myProjectFile.isDirectory()) {
            this.myStorageScheme = StorageScheme.DIRECTORY_BASED;
            this.myProjectBaseDir = this.myProjectFile;
            this.mySettingsBaseDir = new File(this.myProjectBaseDir.getAbsolutePath(), ".idea");
            modulesFile = new File(this.mySettingsBaseDir, "modules.xml");
            this.myWorkspaceFile = new File(this.mySettingsBaseDir, "workspace.xml");
        } else {
            this.myStorageScheme = StorageScheme.DEFAULT;
            this.myProjectBaseDir = this.myProjectFile.getParentFile();
            modulesFile = this.myProjectFile;
            this.myWorkspaceFile = new File(StringUtil.trimEnd((String)projectPath, (String)".ipr") + ".iws");
        }
        this.myModuleFiles = modulesFile.exists() ? this.findModuleFiles(JDomConvertingUtil.loadDocument(modulesFile).getRootElement()) : new File[]{};
        this.myPerformedConversionIds = this.loadPerformedConversionIds();
    }

    public Set<File> getAllProjectFiles() {
        HashSet<File> files = new HashSet<File>(Arrays.asList(this.myModuleFiles));
        if (this.myStorageScheme == StorageScheme.DEFAULT) {
            files.add(this.myProjectFile);
            files.add(this.myWorkspaceFile);
        } else {
            ConversionContextImpl.addFilesRecursively(this.mySettingsBaseDir, files);
        }
        return files;
    }

    private static void addFilesRecursively(File file2, Set<File> files) {
        if (file2.isDirectory()) {
            File[] children2 = file2.listFiles();
            if (children2 != null) {
                for (File child : children2) {
                    ConversionContextImpl.addFilesRecursively(child, files);
                }
            }
        } else if (StringUtil.endsWithIgnoreCase((String)file2.getName(), (String)".xml") && !file2.getName().startsWith(".")) {
            files.add(file2);
        }
    }

    public boolean isConversionAlreadyPerformed(ConverterProvider provider) {
        return this.myPerformedConversionIds.contains(provider.getId());
    }

    @Override
    @NotNull
    public File getProjectBaseDir() {
        File file2 = this.myProjectBaseDir;
        if (file2 == null) {
            ConversionContextImpl.$$$reportNull$$$0(0);
        }
        return file2;
    }

    @Override
    public File[] getModuleFiles() {
        return this.myModuleFiles;
    }

    private File[] findModuleFiles(Element root) {
        Element modulesManager = JDomSerializationUtil.findComponent((Element)root, (String)"ProjectModuleManager");
        if (modulesManager == null) {
            return new File[0];
        }
        Element modules = modulesManager.getChild("modules");
        if (modules == null) {
            return new File[0];
        }
        ExpandMacroToPathMap macros = this.createExpandMacroMap();
        ArrayList<File> files = new ArrayList<File>();
        for (Element module : modules.getChildren("module")) {
            String filePath = module.getAttributeValue("filepath");
            filePath = macros.substitute(filePath, true);
            files.add(new File(FileUtil.toSystemDependentName((String)filePath)));
        }
        return files.toArray(new File[files.size()]);
    }

    @NotNull
    public String expandPath(@NotNull String path, @NotNull ModuleSettingsImpl moduleSettings) {
        if (path == null) {
            ConversionContextImpl.$$$reportNull$$$0(1);
        }
        if (moduleSettings == null) {
            ConversionContextImpl.$$$reportNull$$$0(2);
        }
        String string = this.createExpandMacroMap(moduleSettings).substitute(path, true);
        if (string == null) {
            ConversionContextImpl.$$$reportNull$$$0(3);
        }
        return string;
    }

    private ExpandMacroToPathMap createExpandMacroMap(@Nullable ModuleSettingsImpl moduleSettings) {
        ExpandMacroToPathMap map = this.createExpandMacroMap();
        if (moduleSettings != null) {
            String modulePath = FileUtil.toSystemIndependentName((String)moduleSettings.getModuleFile().getParentFile().getAbsolutePath());
            map.addMacroExpand("MODULE_DIR", modulePath);
        }
        return map;
    }

    @Override
    @NotNull
    public String expandPath(@NotNull String path) {
        if (path == null) {
            ConversionContextImpl.$$$reportNull$$$0(4);
        }
        ExpandMacroToPathMap map = this.createExpandMacroMap(null);
        String string = map.substitute(path, SystemInfo.isFileSystemCaseSensitive);
        if (string == null) {
            ConversionContextImpl.$$$reportNull$$$0(5);
        }
        return string;
    }

    @Override
    @NotNull
    public String collapsePath(@NotNull String path) {
        if (path == null) {
            ConversionContextImpl.$$$reportNull$$$0(6);
        }
        ReplacePathToMacroMap map = ConversionContextImpl.createCollapseMacroMap("PROJECT_DIR", this.myProjectBaseDir);
        String string = map.substitute(path, SystemInfo.isFileSystemCaseSensitive);
        if (string == null) {
            ConversionContextImpl.$$$reportNull$$$0(7);
        }
        return string;
    }

    public static String collapsePath(@NotNull String path, @NotNull ModuleSettingsImpl moduleSettings) {
        if (path == null) {
            ConversionContextImpl.$$$reportNull$$$0(8);
        }
        if (moduleSettings == null) {
            ConversionContextImpl.$$$reportNull$$$0(9);
        }
        ReplacePathToMacroMap map = ConversionContextImpl.createCollapseMacroMap("MODULE_DIR", moduleSettings.getModuleFile().getParentFile());
        return map.substitute(path, SystemInfo.isFileSystemCaseSensitive);
    }

    private static ReplacePathToMacroMap createCollapseMacroMap(String macroName, File dir) {
        ReplacePathToMacroMap map = new ReplacePathToMacroMap();
        map.addMacroReplacement(FileUtil.toSystemIndependentName((String)dir.getAbsolutePath()), macroName);
        PathMacrosImpl.getInstanceEx().addMacroReplacements(map);
        return map;
    }

    @Override
    public Collection<File> getLibraryClassRoots(@NotNull String name, @NotNull String level) {
        if (name == null) {
            ConversionContextImpl.$$$reportNull$$$0(10);
        }
        if (level == null) {
            ConversionContextImpl.$$$reportNull$$$0(11);
        }
        try {
            Element libraryElement = null;
            if ("project".equals(level)) {
                libraryElement = this.findProjectLibraryElement(name);
            } else if ("application".equals(level)) {
                libraryElement = ConversionContextImpl.findGlobalLibraryElement(name);
            }
            if (libraryElement != null) {
                return this.getClassRoots(libraryElement, null);
            }
            return Collections.emptyList();
        }
        catch (CannotConvertException e) {
            return Collections.emptyList();
        }
    }

    @NotNull
    public List<File> getClassRoots(Element libraryElement, @Nullable ModuleSettingsImpl moduleSettings) {
        ArrayList<File> files = new ArrayList<File>();
        Element classesChild = libraryElement.getChild("CLASSES");
        if (classesChild != null) {
            ExpandMacroToPathMap pathMap = this.createExpandMacroMap(moduleSettings);
            for (Element root : classesChild.getChildren("root")) {
                String url = root.getAttributeValue("url");
                String path = VfsUtilCore.urlToPath((String)url);
                files.add(new File(PathUtil.getLocalPath((String)pathMap.substitute(path, true))));
            }
        }
        ArrayList<File> arrayList = files;
        if (arrayList == null) {
            ConversionContextImpl.$$$reportNull$$$0(12);
        }
        return arrayList;
    }

    @Override
    public ComponentManagerSettings getCompilerSettings() {
        if (this.myCompilerManagerSettings == null) {
            this.myCompilerManagerSettings = this.createProjectSettings("compiler.xml");
        }
        return this.myCompilerManagerSettings;
    }

    @Override
    public ComponentManagerSettings getProjectRootManagerSettings() {
        if (this.myProjectRootManagerSettings == null) {
            this.myProjectRootManagerSettings = this.createProjectSettings("misc.xml");
        }
        return this.myProjectRootManagerSettings;
    }

    @Override
    public ComponentManagerSettings getModulesSettings() {
        if (this.myModulesSettings == null) {
            this.myModulesSettings = this.createProjectSettings("modules.xml");
        }
        return this.myModulesSettings;
    }

    @Nullable
    public ComponentManagerSettings getProjectFileVersionSettings() {
        if (this.myProjectFileVersionSettings == null) {
            this.myProjectFileVersionSettings = this.createProjectSettings("misc.xml");
        }
        return this.myProjectFileVersionSettings;
    }

    @Override
    @Nullable
    public ComponentManagerSettingsImpl createProjectSettings(@NotNull String fileName) {
        if (fileName == null) {
            ConversionContextImpl.$$$reportNull$$$0(13);
        }
        try {
            File file2;
            if (this.myStorageScheme == StorageScheme.DEFAULT) {
                file2 = this.myProjectFile;
            } else {
                file2 = new File(this.mySettingsBaseDir, fileName);
                if (!file2.exists()) {
                    return null;
                }
            }
            return new ComponentManagerSettingsImpl(file2, this);
        }
        catch (CannotConvertException e) {
            LOG.info((Throwable)e);
            return null;
        }
    }

    @Nullable
    private static Element findGlobalLibraryElement(String name) throws CannotConvertException {
        Element root;
        Element libraryTable;
        File file2 = PathManager.getOptionsFile((String)"applicationLibraries");
        if (file2.exists() && (libraryTable = JDomSerializationUtil.findComponent((Element)(root = JDomConvertingUtil.loadDocument(file2).getRootElement()), (String)"libraryTable")) != null) {
            return ConversionContextImpl.findLibraryInTable(libraryTable, name);
        }
        return null;
    }

    @Nullable
    private Element findProjectLibraryElement(String name) throws CannotConvertException {
        Collection<? extends Element> libraries = this.getProjectLibrariesSettings().getProjectLibraries();
        Condition<Element> filter2 = JDomConvertingUtil.createElementWithAttributeFilter("library", "name", name);
        return (Element)ContainerUtil.find(libraries, filter2);
    }

    @Nullable
    private static Element findLibraryInTable(Element tableElement, String name) {
        Condition<Element> filter2 = JDomConvertingUtil.createElementWithAttributeFilter("library", "name", name);
        return JDomConvertingUtil.findChild(tableElement, filter2);
    }

    private ExpandMacroToPathMap createExpandMacroMap() {
        ExpandMacroToPathMap macros = new ExpandMacroToPathMap();
        String projectDir = FileUtil.toSystemIndependentName((String)this.myProjectBaseDir.getAbsolutePath());
        macros.addMacroExpand("PROJECT_DIR", projectDir);
        PathMacrosImpl.getInstanceEx().addMacroExpands(macros);
        return macros;
    }

    @Override
    public File getSettingsBaseDir() {
        return this.mySettingsBaseDir;
    }

    @Override
    @NotNull
    public File getProjectFile() {
        File file2 = this.myProjectFile;
        if (file2 == null) {
            ConversionContextImpl.$$$reportNull$$$0(14);
        }
        return file2;
    }

    @Override
    public ProjectSettings getProjectSettings() throws CannotConvertException {
        if (this.myProjectSettings == null) {
            this.myProjectSettings = new ProjectSettingsImpl(this.myProjectFile, this);
        }
        return this.myProjectSettings;
    }

    @Override
    public RunManagerSettingsImpl getRunManagerSettings() throws CannotConvertException {
        if (this.myRunManagerSettings == null) {
            if (this.myStorageScheme == StorageScheme.DEFAULT) {
                this.myRunManagerSettings = new RunManagerSettingsImpl(this.myWorkspaceFile, this.myProjectFile, null, this);
            } else {
                File[] files = new File(this.mySettingsBaseDir, "runConfigurations").listFiles(FileFilters.filesWithExtension((String)"xml"));
                this.myRunManagerSettings = new RunManagerSettingsImpl(this.myWorkspaceFile, null, files, this);
            }
        }
        return this.myRunManagerSettings;
    }

    @Override
    public WorkspaceSettings getWorkspaceSettings() throws CannotConvertException {
        if (this.myWorkspaceSettings == null) {
            this.myWorkspaceSettings = new WorkspaceSettingsImpl(this.myWorkspaceFile, this);
        }
        return this.myWorkspaceSettings;
    }

    @Override
    public ModuleSettings getModuleSettings(File moduleFile) throws CannotConvertException {
        ModuleSettingsImpl settings = this.myFile2ModuleSettings.get(moduleFile);
        if (settings == null) {
            settings = new ModuleSettingsImpl(moduleFile, this);
            this.myFile2ModuleSettings.put(moduleFile, settings);
            this.myName2ModuleSettings.put(settings.getModuleName(), settings);
        }
        return settings;
    }

    @Override
    public ModuleSettings getModuleSettings(@NotNull String moduleName) {
        if (moduleName == null) {
            ConversionContextImpl.$$$reportNull$$$0(15);
        }
        if (!this.myName2ModuleSettings.containsKey(moduleName)) {
            for (File moduleFile : this.myModuleFiles) {
                try {
                    this.getModuleSettings(moduleFile);
                }
                catch (CannotConvertException cannotConvertException) {
                    // empty catch block
                }
            }
        }
        return this.myName2ModuleSettings.get(moduleName);
    }

    public List<File> getNonExistingModuleFiles() {
        return this.myNonExistingModuleFiles;
    }

    @Override
    @NotNull
    public StorageScheme getStorageScheme() {
        StorageScheme storageScheme = this.myStorageScheme;
        if (storageScheme == null) {
            ConversionContextImpl.$$$reportNull$$$0(16);
        }
        return storageScheme;
    }

    public File getWorkspaceFile() {
        return this.myWorkspaceFile;
    }

    public void saveFiles(Collection<File> files, List<ConversionRunner> usedRunners) throws IOException {
        HashSet<String> performedConversions = new HashSet<String>();
        for (ConversionRunner runner : usedRunners) {
            ConverterProvider provider = runner.getProvider();
            if (provider.canDetermineIfConversionAlreadyPerformedByProjectFiles()) continue;
            performedConversions.add(provider.getId());
        }
        if (!performedConversions.isEmpty()) {
            performedConversions.addAll(this.myPerformedConversionIds);
            ProjectFileVersionState state = new ProjectFileVersionState();
            ArrayList<String> performedConversionsList = new ArrayList<String>(performedConversions);
            Collections.sort(performedConversionsList, String.CASE_INSENSITIVE_ORDER);
            state.setPerformedConversionIds(performedConversionsList);
            ComponentManagerSettings settings = this.getProjectFileVersionSettings();
            if (settings != null) {
                Element element = JDomSerializationUtil.findOrCreateComponentElement((Element)settings.getRootElement(), (String)"ProjectFileVersion");
                XmlSerializer.serializeInto((Object)state, (Element)element);
            }
        }
        for (File file2 : files) {
            SettingsXmlFile xmlFile = this.mySettingsFiles.get(file2);
            if (xmlFile == null) continue;
            xmlFile.save();
        }
    }

    private Set<String> loadPerformedConversionIds() {
        Element componentElement;
        ComponentManagerSettings component = this.getProjectFileVersionSettings();
        if (component != null && (componentElement = component.getComponentElement("ProjectFileVersion")) != null) {
            ProjectFileVersionState state = (ProjectFileVersionState)XmlSerializer.deserialize((Element)componentElement, ProjectFileVersionState.class);
            return new HashSet<String>(state.getPerformedConversionIds());
        }
        return Collections.emptySet();
    }

    public SettingsXmlFile getOrCreateFile(File file2) throws CannotConvertException {
        SettingsXmlFile settingsFile = this.mySettingsFiles.get(file2);
        if (settingsFile == null) {
            settingsFile = new SettingsXmlFile(file2);
            this.mySettingsFiles.put(file2, settingsFile);
        }
        return settingsFile;
    }

    @Override
    public ProjectLibrariesSettingsImpl getProjectLibrariesSettings() throws CannotConvertException {
        if (this.myProjectLibrariesSettings == null) {
            this.myProjectLibrariesSettings = this.myStorageScheme == StorageScheme.DEFAULT ? new ProjectLibrariesSettingsImpl(this.myProjectFile, null, this) : new ProjectLibrariesSettingsImpl(null, this.getSettingsXmlFiles("libraries"), this);
        }
        return this.myProjectLibrariesSettings;
    }

    @Override
    public ArtifactsSettingsImpl getArtifactsSettings() throws CannotConvertException {
        if (this.myArtifactsSettings == null) {
            this.myArtifactsSettings = this.myStorageScheme == StorageScheme.DEFAULT ? new ArtifactsSettingsImpl(this.myProjectFile, null, this) : new ArtifactsSettingsImpl(null, this.getSettingsXmlFiles("artifacts"), this);
        }
        return this.myArtifactsSettings;
    }

    @NotNull
    private File[] getSettingsXmlFiles(@NotNull String dirName) {
        if (dirName == null) {
            ConversionContextImpl.$$$reportNull$$$0(17);
        }
        File librariesDir = new File(this.mySettingsBaseDir, dirName);
        File[] fileArray = (File[])ObjectUtils.notNull((Object)librariesDir.listFiles(FileFilters.filesWithExtension((String)"xml")), (Object)ArrayUtil.EMPTY_FILE_ARRAY);
        if (fileArray == null) {
            ConversionContextImpl.$$$reportNull$$$0(18);
        }
        return fileArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 15: 
            case 17: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 15: 
            case 17: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/conversion/impl/ConversionContextImpl";
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 2: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleSettings";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "level";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleName";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dirName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjectBaseDir";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 15: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/conversion/impl/ConversionContextImpl";
                break;
            }
            case 3: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "expandPath";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "collapsePath";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getClassRoots";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjectFile";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getStorageScheme";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getSettingsXmlFiles";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "expandPath";
                break;
            }
            case 6: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "collapsePath";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getLibraryClassRoots";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "createProjectSettings";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getModuleSettings";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getSettingsXmlFiles";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 15: 
            case 17: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

