/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.tools.util;

import com.intellij.diff.DiffContext;
import com.intellij.diff.impl.DiffSettingsHolder;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.diff.tools.holders.BinaryEditorHolder;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorState;
import com.intellij.openapi.fileEditor.FileEditorStateLevel;
import com.intellij.openapi.fileEditor.TransferableFileEditorState;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.ui.ToggleActionButton;
import com.intellij.util.containers.ContainerUtil;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TransferableFileEditorStateSupport {
    @NotNull
    private static final Key<Map<String, Map<String, String>>> TRANSFERABLE_FILE_EDITOR_STATE = Key.create((String)"Diff.TransferableFileEditorState");
    private static final Condition<BinaryEditorHolder> IS_SUPPORTED = holder -> TransferableFileEditorStateSupport.getEditorState(holder.getEditor()) != null;
    @NotNull
    private final DiffSettingsHolder.DiffSettings mySettings;
    @NotNull
    private final List<BinaryEditorHolder> myHolders;
    private final boolean mySupported;

    public TransferableFileEditorStateSupport(@NotNull DiffSettingsHolder.DiffSettings settings, @NotNull List<BinaryEditorHolder> holders, @NotNull Disposable disposable) {
        if (settings == null) {
            TransferableFileEditorStateSupport.$$$reportNull$$$0(0);
        }
        if (holders == null) {
            TransferableFileEditorStateSupport.$$$reportNull$$$0(1);
        }
        if (disposable == null) {
            TransferableFileEditorStateSupport.$$$reportNull$$$0(2);
        }
        this.mySettings = settings;
        this.myHolders = holders;
        this.mySupported = ContainerUtil.or(this.myHolders, IS_SUPPORTED);
        new MySynchronizer(ContainerUtil.filter(this.myHolders, IS_SUPPORTED)).install(disposable);
    }

    public boolean isSupported() {
        return this.mySupported;
    }

    public boolean isEnabled() {
        return this.mySettings.isSyncBinaryEditorSettings();
    }

    public void setEnabled(boolean enabled) {
        this.mySettings.setSyncBinaryEditorSettings(enabled);
    }

    public void processContextHints(@NotNull DiffRequest request, @NotNull DiffContext context) {
        if (request == null) {
            TransferableFileEditorStateSupport.$$$reportNull$$$0(3);
        }
        if (context == null) {
            TransferableFileEditorStateSupport.$$$reportNull$$$0(4);
        }
        if (!this.isEnabled()) {
            return;
        }
        for (BinaryEditorHolder holder : this.myHolders) {
            FileEditor editor = holder.getEditor();
            TransferableFileEditorState state = TransferableFileEditorStateSupport.getEditorState(holder.getEditor());
            if (state == null) continue;
            TransferableFileEditorStateSupport.readContextData(context, editor, state);
        }
    }

    public void updateContextHints(@NotNull DiffRequest request, @NotNull DiffContext context) {
        if (request == null) {
            TransferableFileEditorStateSupport.$$$reportNull$$$0(5);
        }
        if (context == null) {
            TransferableFileEditorStateSupport.$$$reportNull$$$0(6);
        }
        if (!this.isEnabled()) {
            return;
        }
        HashSet updated = ContainerUtil.newHashSet();
        for (BinaryEditorHolder holder : this.myHolders) {
            boolean processed2;
            TransferableFileEditorState state = TransferableFileEditorStateSupport.getEditorState(holder.getEditor());
            if (state == null || (processed2 = !updated.add(state.getEditorId()))) continue;
            TransferableFileEditorStateSupport.writeContextData(context, state);
        }
    }

    @NotNull
    public AnAction createToggleAction() {
        ToggleSynchronousEditorStatesAction toggleSynchronousEditorStatesAction = new ToggleSynchronousEditorStatesAction(this);
        if (toggleSynchronousEditorStatesAction == null) {
            TransferableFileEditorStateSupport.$$$reportNull$$$0(7);
        }
        return toggleSynchronousEditorStatesAction;
    }

    private static void readContextData(@NotNull DiffContext context, @NotNull FileEditor editor, @NotNull TransferableFileEditorState state) {
        Map map;
        Map options;
        if (context == null) {
            TransferableFileEditorStateSupport.$$$reportNull$$$0(8);
        }
        if (editor == null) {
            TransferableFileEditorStateSupport.$$$reportNull$$$0(9);
        }
        if (state == null) {
            TransferableFileEditorStateSupport.$$$reportNull$$$0(10);
        }
        Map map2 = options = (map = (Map)context.getUserData(TRANSFERABLE_FILE_EDITOR_STATE)) != null ? (Map)map.get(state.getEditorId()) : null;
        if (options == null) {
            return;
        }
        state.setTransferableOptions(options);
        editor.setState((FileEditorState)state);
    }

    private static void writeContextData(@NotNull DiffContext context, @NotNull TransferableFileEditorState state) {
        Map map;
        if (context == null) {
            TransferableFileEditorStateSupport.$$$reportNull$$$0(11);
        }
        if (state == null) {
            TransferableFileEditorStateSupport.$$$reportNull$$$0(12);
        }
        if ((map = (Map)context.getUserData(TRANSFERABLE_FILE_EDITOR_STATE)) == null) {
            map = ContainerUtil.newHashMap();
            context.putUserData(TRANSFERABLE_FILE_EDITOR_STATE, (Object)map);
        }
        map.put(state.getEditorId(), state.getTransferableOptions());
    }

    @Nullable
    private static TransferableFileEditorState getEditorState(@NotNull FileEditor editor) {
        FileEditorState state;
        if (editor == null) {
            TransferableFileEditorStateSupport.$$$reportNull$$$0(13);
        }
        return (state = editor.getState(FileEditorStateLevel.FULL)) instanceof TransferableFileEditorState ? (TransferableFileEditorState)state : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holders";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposable";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "request";
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/diff/tools/util/TransferableFileEditorStateSupport";
                break;
            }
            case 9: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/diff/tools/util/TransferableFileEditorStateSupport";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createToggleAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "processContextHints";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "updateContextHints";
                break;
            }
            case 7: {
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "readContextData";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "writeContextData";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getEditorState";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class ToggleSynchronousEditorStatesAction
    extends ToggleActionButton
    implements DumbAware {
        @NotNull
        private final TransferableFileEditorStateSupport mySupport;

        public ToggleSynchronousEditorStatesAction(TransferableFileEditorStateSupport support) {
            if (support == null) {
                ToggleSynchronousEditorStatesAction.$$$reportNull$$$0(0);
            }
            super("Synchronize Editors Settings", AllIcons.Actions.SyncPanels);
            this.mySupport = support;
        }

        public boolean isVisible() {
            return this.mySupport.isSupported();
        }

        public boolean isSelected(AnActionEvent e) {
            return this.mySupport.isEnabled();
        }

        public void setSelected(AnActionEvent e, boolean state) {
            this.mySupport.setEnabled(state);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "support", "com/intellij/diff/tools/util/TransferableFileEditorStateSupport$ToggleSynchronousEditorStatesAction", "<init>"));
        }
    }

    private class MySynchronizer
    implements PropertyChangeListener {
        @NotNull
        private final List<? extends FileEditor> myEditors;
        private boolean myDuringUpdate;

        public MySynchronizer(List<BinaryEditorHolder> editors) {
            if (editors == null) {
                MySynchronizer.$$$reportNull$$$0(0);
            }
            this.myDuringUpdate = false;
            this.myEditors = ContainerUtil.map(editors, holder -> holder.getEditor());
        }

        public void install(@NotNull Disposable disposable) {
            if (disposable == null) {
                MySynchronizer.$$$reportNull$$$0(1);
            }
            if (this.myEditors.size() < 2) {
                return;
            }
            for (FileEditor fileEditor : this.myEditors) {
                fileEditor.addPropertyChangeListener((PropertyChangeListener)this);
            }
            Disposer.register((Disposable)disposable, (Disposable)new Disposable(){

                public void dispose() {
                    for (FileEditor editor : MySynchronizer.this.myEditors) {
                        editor.removePropertyChangeListener((PropertyChangeListener)MySynchronizer.this);
                    }
                }
            });
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (this.myDuringUpdate || !TransferableFileEditorStateSupport.this.isEnabled()) {
                return;
            }
            if (!(evt.getSource() instanceof FileEditor)) {
                return;
            }
            TransferableFileEditorState sourceState = TransferableFileEditorStateSupport.getEditorState((FileEditor)evt.getSource());
            if (sourceState == null) {
                return;
            }
            Map options = sourceState.getTransferableOptions();
            String id = sourceState.getEditorId();
            for (FileEditor fileEditor : this.myEditors) {
                if (evt.getSource() == fileEditor) continue;
                this.updateEditor(fileEditor, id, options);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void updateEditor(@NotNull FileEditor editor, @NotNull String id, @NotNull Map<String, String> options) {
            if (editor == null) {
                MySynchronizer.$$$reportNull$$$0(2);
            }
            if (id == null) {
                MySynchronizer.$$$reportNull$$$0(3);
            }
            if (options == null) {
                MySynchronizer.$$$reportNull$$$0(4);
            }
            try {
                this.myDuringUpdate = true;
                TransferableFileEditorState state = TransferableFileEditorStateSupport.getEditorState(editor);
                if (state != null && state.getEditorId().equals(id)) {
                    state.setTransferableOptions(options);
                    editor.setState((FileEditorState)state);
                }
            }
            finally {
                this.myDuringUpdate = false;
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editors";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "disposable";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "id";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "options";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/diff/tools/util/TransferableFileEditorStateSupport$MySynchronizer";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "install";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "updateEditor";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

