/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dvcs.ui;

import com.intellij.dvcs.ui.BranchActionGroup;
import com.intellij.dvcs.ui.PopupElementWithAdditionalInfo;
import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionPopupMenu;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.EmptyAction;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.impl.ActionManagerImpl;
import com.intellij.openapi.actionSystem.impl.SimpleDataContext;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupAdapter;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.ui.popup.LightweightWindowEvent;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.WindowStateService;
import com.intellij.openapi.vcs.ui.FlatSpeedSearchPopup;
import com.intellij.ui.ActiveComponent;
import com.intellij.ui.ErrorLabel;
import com.intellij.ui.JBColor;
import com.intellij.ui.ScrollingUtil;
import com.intellij.ui.SeparatorWithText;
import com.intellij.ui.components.panels.NonOpaquePanel;
import com.intellij.ui.components.panels.OpaquePanel;
import com.intellij.ui.popup.KeepingPopupOpenAction;
import com.intellij.ui.popup.PopupFactoryImpl;
import com.intellij.ui.popup.WizardPopup;
import com.intellij.ui.popup.list.IconListPopupRenderer;
import com.intellij.ui.popup.list.ListPopupImpl;
import com.intellij.ui.popup.list.ListPopupModel;
import com.intellij.ui.popup.list.PopupListElementRenderer;
import com.intellij.util.FontUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.plaf.basic.BasicButtonUI;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BranchActionGroupPopup
extends FlatSpeedSearchPopup {
    private static final DataKey<ListPopupModel> POPUP_MODEL = DataKey.create((String)"VcsPopupModel");
    static final String BRANCH_POPUP = "BranchWidget";
    private Project myProject;
    private MyPopupListElementRenderer myListElementRenderer;
    private boolean myShown;
    private boolean myUserSizeChanged;
    private boolean myInternalSizeChanged;
    private int myMeanRowHeight;
    @Nullable
    private final String myKey;
    @NotNull
    private Dimension myPrevSize;
    @Nullable
    private MyToolbarButton myRestoreSizeButton;
    @Nullable
    private MyToolbarButton mySettingsButton;
    private final List<AnAction> mySettingsActions;

    public BranchActionGroupPopup(@NotNull String title, @NotNull Project project, @NotNull Condition<AnAction> preselectActionCondition, @NotNull ActionGroup actions, @Nullable String dimensionKey) {
        if (title == null) {
            BranchActionGroupPopup.$$$reportNull$$$0(0);
        }
        if (project == null) {
            BranchActionGroupPopup.$$$reportNull$$$0(1);
        }
        if (preselectActionCondition == null) {
            BranchActionGroupPopup.$$$reportNull$$$0(2);
        }
        if (actions == null) {
            BranchActionGroupPopup.$$$reportNull$$$0(3);
        }
        super(title, new DefaultActionGroup(new AnAction[]{actions, BranchActionGroupPopup.createBranchSpeedSearchActionGroup(actions)}), SimpleDataContext.getProjectContext(project), preselectActionCondition, true);
        this.myPrevSize = JBUI.emptySize();
        this.mySettingsActions = ContainerUtil.newArrayList();
        this.myProject = project;
        DataManager.registerDataProvider((JComponent)this.getList(), dataId -> POPUP_MODEL.is(dataId) ? this.getListModel() : null);
        this.myKey = dimensionKey;
        if (this.myKey != null) {
            Dimension storedSize = WindowStateService.getInstance((Project)this.myProject).getSizeFor((Object)this.myProject, this.myKey);
            if (storedSize != null) {
                this.setSize(storedSize);
                this.myUserSizeChanged = true;
            }
            this.createTitlePanelToolbar(this.myKey);
        }
        this.myMeanRowHeight = this.getList().getCellBounds((int)0, (int)0).height + UIUtil.getListCellVPadding() * 2;
    }

    private void createTitlePanelToolbar(@NotNull String dimensionKey) {
        if (dimensionKey == null) {
            BranchActionGroupPopup.$$$reportNull$$$0(4);
        }
        NonOpaquePanel panel2 = new NonOpaquePanel();
        panel2.setLayout(new BoxLayout((Container)panel2, 0));
        this.myRestoreSizeButton = new MyToolbarButton("Restore Size", AllIcons.General.CollapseComponent, AllIcons.General.CollapseComponentHover, e -> {
            if (dimensionKey == null) {
                BranchActionGroupPopup.$$$reportNull$$$0(19);
            }
            WindowStateService.getInstance((Project)this.myProject).putSizeFor((Object)this.myProject, dimensionKey, null);
            this.myInternalSizeChanged = true;
            this.pack(true, true);
        }){

            @Override
            protected boolean isButtonEnabled() {
                return BranchActionGroupPopup.this.myUserSizeChanged;
            }
        };
        this.mySettingsButton = new MyToolbarButton("Settings", AllIcons.General.Gear, AllIcons.General.GearHover, e -> {
            ActionPopupMenu popupMenu = ((ActionManagerImpl)ActionManager.getInstance()).createActionPopupMenu(BRANCH_POPUP, (ActionGroup)new DefaultActionGroup(this.mySettingsActions));
            popupMenu.getComponent().show(this.mySettingsButton, 0, ((MyToolbarButton)ObjectUtils.assertNotNull((Object)this.mySettingsButton)).getHeight());
        }){

            @Override
            protected boolean isButtonEnabled() {
                return !BranchActionGroupPopup.this.mySettingsActions.isEmpty();
            }
        };
        this.mySettingsButton.setBorder((Border)JBUI.Borders.emptyLeft((int)4));
        panel2.add(this.myRestoreSizeButton);
        panel2.add(this.mySettingsButton);
        this.getTitle().setButtonComponent((ActiveComponent)new ActiveComponent.Adapter((JPanel)panel2){
            final /* synthetic */ JPanel val$panel;
            {
                this.val$panel = jPanel;
            }

            public JComponent getComponent() {
                return this.val$panel;
            }
        }, (Border)JBUI.Borders.emptyRight((int)2));
    }

    private BranchActionGroupPopup(@Nullable WizardPopup aParent, @NotNull ListPopupStep aStep, @Nullable Object parentValue) {
        if (aStep == null) {
            BranchActionGroupPopup.$$$reportNull$$$0(5);
        }
        super(aParent, aStep, DataContext.EMPTY_CONTEXT, parentValue);
        this.myPrevSize = JBUI.emptySize();
        this.mySettingsActions = ContainerUtil.newArrayList();
        this.myKey = null;
        DataManager.registerDataProvider((JComponent)this.getList(), dataId -> POPUP_MODEL.is(dataId) ? this.getListModel() : null);
    }

    private void trackDimensions(final @Nullable String dimensionKey) {
        final Window popupWindow = this.getPopupWindow();
        if (popupWindow == null) {
            return;
        }
        final ComponentAdapter windowListener = new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                if (BranchActionGroupPopup.this.myShown) {
                    BranchActionGroupPopup.this.processOnSizeChanged();
                }
            }
        };
        popupWindow.addComponentListener(windowListener);
        this.addPopupListener((JBPopupListener)new JBPopupAdapter(){

            public void onClosed(LightweightWindowEvent event) {
                popupWindow.removeComponentListener(windowListener);
                if (dimensionKey != null && BranchActionGroupPopup.this.myUserSizeChanged) {
                    WindowStateService.getInstance((Project)BranchActionGroupPopup.this.myProject).putSizeFor((Object)BranchActionGroupPopup.this.myProject, dimensionKey, BranchActionGroupPopup.this.myPrevSize);
                }
            }
        });
    }

    private void processOnSizeChanged() {
        boolean sizeWasIncreased;
        Dimension newSize = (Dimension)ObjectUtils.assertNotNull((Object)this.getSize());
        int preferredHeight = this.getComponent().getPreferredSize().height;
        int realHeight = this.getComponent().getHeight();
        boolean shouldExpand = preferredHeight + this.myMeanRowHeight < realHeight;
        boolean bl = sizeWasIncreased = this.myPrevSize.height < newSize.height;
        if (!this.myInternalSizeChanged && sizeWasIncreased && shouldExpand) {
            List<MoreAction> mores = this.getMoreActions();
            for (MoreAction more : mores) {
                if (!this.getList().getScrollableTracksViewportHeight()) break;
                if (more.isExpanded()) continue;
                more.setExpanded(true);
                this.getListModel().refilter();
            }
        }
        this.myPrevSize = newSize;
        this.myUserSizeChanged = !this.myInternalSizeChanged;
        this.myInternalSizeChanged = false;
        if (this.myRestoreSizeButton != null) {
            this.myRestoreSizeButton.update();
        }
    }

    @NotNull
    private List<MoreAction> getMoreActions() {
        ArrayList result2 = ContainerUtil.newArrayList();
        ListPopupModel model = this.getListModel();
        for (int i = 0; i < model.getSize(); ++i) {
            MoreAction moreAction = BranchActionGroupPopup.getSpecificAction(model.getElementAt(i), MoreAction.class);
            if (moreAction == null) continue;
            result2.add(moreAction);
        }
        ArrayList arrayList = result2;
        if (arrayList == null) {
            BranchActionGroupPopup.$$$reportNull$$$0(6);
        }
        return arrayList;
    }

    public void addSettingAction(@NotNull AnAction action) {
        if (action == null) {
            BranchActionGroupPopup.$$$reportNull$$$0(7);
        }
        if (this.mySettingsButton != null) {
            this.mySettingsActions.add(action);
            this.mySettingsButton.update();
        }
    }

    @NotNull
    private static ActionGroup createBranchSpeedSearchActionGroup(@NotNull ActionGroup actionGroup) {
        if (actionGroup == null) {
            BranchActionGroupPopup.$$$reportNull$$$0(8);
        }
        DefaultActionGroup defaultActionGroup = new DefaultActionGroup(null, BranchActionGroupPopup.createSpeedSearchActions(actionGroup, true), false);
        if (defaultActionGroup == null) {
            BranchActionGroupPopup.$$$reportNull$$$0(9);
        }
        return defaultActionGroup;
    }

    @Override
    protected boolean isResizable() {
        return true;
    }

    @Override
    protected void afterShow() {
        super.afterShow();
        this.myShown = true;
        Dimension size = this.getSize();
        if (size != null) {
            this.myPrevSize = size;
        }
        this.trackDimensions(this.myKey);
    }

    private static List<AnAction> createSpeedSearchActions(@NotNull ActionGroup parentActionGroup, boolean isFirstLevel) {
        if (parentActionGroup == null) {
            BranchActionGroupPopup.$$$reportNull$$$0(10);
        }
        ArrayList speedSearchActions = ContainerUtil.newArrayList();
        if (!isFirstLevel) {
            speedSearchActions.add(new Separator(parentActionGroup.getTemplatePresentation().getText()));
        }
        for (AnAction child : parentActionGroup.getChildren(null)) {
            if (!(child instanceof ActionGroup)) continue;
            ActionGroup childGroup = (ActionGroup)child;
            if (isFirstLevel) {
                speedSearchActions.addAll(BranchActionGroupPopup.createSpeedSearchActions(childGroup, false));
                continue;
            }
            if (childGroup instanceof BranchActionGroup) {
                speedSearchActions.add(BranchActionGroupPopup.createSpeedSearchActionGroupWrapper(childGroup));
                continue;
            }
            if (!(childGroup instanceof HideableActionGroup)) continue;
            speedSearchActions.add(BranchActionGroupPopup.createSpeedSearchActionGroupWrapper(((HideableActionGroup)childGroup).getDelegate()));
        }
        return speedSearchActions;
    }

    @Override
    public void handleSelect(boolean handleFinalChoices) {
        super.handleSelect(handleFinalChoices, null);
        if (BranchActionGroupPopup.getSpecificAction(this.getList().getSelectedValue(), MoreAction.class) != null) {
            this.getListModel().refilter();
        }
    }

    @Override
    public void handleSelect(boolean handleFinalChoices, InputEvent e) {
        BranchActionGroup branchActionGroup = this.getSelectedBranchGroup();
        if (branchActionGroup != null && e instanceof MouseEvent && this.myListElementRenderer.isIconAt(((MouseEvent)e).getPoint())) {
            branchActionGroup.toggle();
            this.getList().repaint();
        } else {
            super.handleSelect(handleFinalChoices, e);
        }
    }

    @Override
    protected void handleToggleAction() {
        BranchActionGroup branchActionGroup = this.getSelectedBranchGroup();
        if (branchActionGroup != null) {
            branchActionGroup.toggle();
            this.getList().repaint();
        } else {
            super.handleToggleAction();
        }
    }

    @Nullable
    private BranchActionGroup getSelectedBranchGroup() {
        return BranchActionGroupPopup.getSpecificAction(this.getList().getSelectedValue(), BranchActionGroup.class);
    }

    @Override
    protected void onSpeedSearchPatternChanged() {
        this.getList().setSelectedIndex(0);
        super.onSpeedSearchPatternChanged();
        ScrollingUtil.ensureSelectionExists((JList)this.getList());
    }

    @Override
    protected boolean shouldUseStatistics() {
        return false;
    }

    @Override
    protected boolean shouldBeShowing(@NotNull AnAction action) {
        if (action == null) {
            BranchActionGroupPopup.$$$reportNull$$$0(11);
        }
        if (!super.shouldBeShowing(action)) {
            return false;
        }
        if (this.getSpeedSearch().isHoldingFilter()) {
            return !(action instanceof MoreAction);
        }
        if (action instanceof MoreHideableActionGroup) {
            return ((MoreHideableActionGroup)action).shouldBeShown();
        }
        return true;
    }

    @Override
    protected WizardPopup createPopup(WizardPopup parent, PopupStep step, Object parentValue) {
        return this.createListPopupStep(parent, step, parentValue);
    }

    private WizardPopup createListPopupStep(WizardPopup parent, PopupStep step, Object parentValue) {
        if (step instanceof ListPopupStep) {
            return new BranchActionGroupPopup(parent, (ListPopupStep)step, parentValue);
        }
        return super.createPopup(parent, step, parentValue);
    }

    private static <T> T getSpecificAction(Object value, @NotNull Class<T> clazz) {
        if (clazz == null) {
            BranchActionGroupPopup.$$$reportNull$$$0(12);
        }
        if (value instanceof PopupFactoryImpl.ActionItem) {
            AnAction action = ((PopupFactoryImpl.ActionItem)value).getAction();
            if (clazz.isInstance(action)) {
                return clazz.cast(action);
            }
            if (action instanceof EmptyAction.MyDelegatingActionGroup) {
                ActionGroup group = ((EmptyAction.MyDelegatingActionGroup)action).getDelegate();
                return clazz.isInstance(group) ? (T)clazz.cast(group) : null;
            }
        }
        return null;
    }

    @Override
    protected MyPopupListElementRenderer getListElementRenderer() {
        if (this.myListElementRenderer == null) {
            this.myListElementRenderer = new MyPopupListElementRenderer(this);
        }
        return this.myListElementRenderer;
    }

    public static void wrapWithMoreActionIfNeeded(@NotNull Project project, @NotNull DefaultActionGroup parentGroup, @NotNull List<? extends ActionGroup> actionList, int maxIndex, @Nullable String settingName) {
        if (project == null) {
            BranchActionGroupPopup.$$$reportNull$$$0(13);
        }
        if (parentGroup == null) {
            BranchActionGroupPopup.$$$reportNull$$$0(14);
        }
        if (actionList == null) {
            BranchActionGroupPopup.$$$reportNull$$$0(15);
        }
        BranchActionGroupPopup.wrapWithMoreActionIfNeeded(project, parentGroup, actionList, maxIndex, settingName, false);
    }

    public static void wrapWithMoreActionIfNeeded(@NotNull Project project, @NotNull DefaultActionGroup parentGroup, @NotNull List<? extends ActionGroup> actionList, int maxIndex, @Nullable String settingName, boolean defaultExpandValue) {
        if (project == null) {
            BranchActionGroupPopup.$$$reportNull$$$0(16);
        }
        if (parentGroup == null) {
            BranchActionGroupPopup.$$$reportNull$$$0(17);
        }
        if (actionList == null) {
            BranchActionGroupPopup.$$$reportNull$$$0(18);
        }
        if (actionList.size() > maxIndex) {
            boolean hasFavorites = actionList.stream().anyMatch(action -> action instanceof BranchActionGroup && ((BranchActionGroup)((Object)action)).isFavorite());
            MoreAction moreAction = new MoreAction(project, actionList.size() - maxIndex, settingName, defaultExpandValue, hasFavorites);
            for (int i = 0; i < actionList.size(); ++i) {
                parentGroup.add((AnAction)(i < maxIndex ? (AnAction)actionList.get(i) : new HideableActionGroup(actionList.get(i), moreAction)));
            }
            parentGroup.add((AnAction)moreAction);
        } else {
            parentGroup.addAll(actionList);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 1: 
            case 13: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "preselectActionCondition";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actions";
                break;
            }
            case 4: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dimensionKey";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aStep";
                break;
            }
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/dvcs/ui/BranchActionGroupPopup";
                break;
            }
            case 7: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionGroup";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentActionGroup";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 14: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentGroup";
                break;
            }
            case 15: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionList";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/dvcs/ui/BranchActionGroupPopup";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getMoreActions";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "createBranchSpeedSearchActionGroup";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createTitlePanelToolbar";
                break;
            }
            case 6: 
            case 9: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "addSettingAction";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createBranchSpeedSearchActionGroup";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createSpeedSearchActions";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "shouldBeShowing";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getSpecificAction";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "wrapWithMoreActionIfNeeded";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "lambda$createTitlePanelToolbar$1";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static abstract class MyToolbarButton
    extends JButton {
        public MyToolbarButton(@NotNull String text, @NotNull Icon icon, @NotNull Icon rolloverIcon, @NotNull ActionListener buttonListener) {
            if (text == null) {
                MyToolbarButton.$$$reportNull$$$0(0);
            }
            if (icon == null) {
                MyToolbarButton.$$$reportNull$$$0(1);
            }
            if (rolloverIcon == null) {
                MyToolbarButton.$$$reportNull$$$0(2);
            }
            if (buttonListener == null) {
                MyToolbarButton.$$$reportNull$$$0(3);
            }
            super(icon);
            this.setToolTipText(text);
            this.setBorder((Border)JBUI.Borders.empty());
            this.setBorderPainted(false);
            this.setContentAreaFilled(false);
            this.setOpaque(false);
            this.setRolloverEnabled(true);
            this.setRolloverIcon(rolloverIcon);
            this.addActionListener(buttonListener);
            this.update();
            this.setUI(new BasicButtonUI());
        }

        public void update() {
            boolean enabled = this.isButtonEnabled();
            this.setEnabled(enabled);
            this.setVisible(enabled);
        }

        protected abstract boolean isButtonEnabled();

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "text";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "icon";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "rolloverIcon";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[0] = "buttonListener";
                    break;
                }
            }
            objectArray[1] = "com/intellij/dvcs/ui/BranchActionGroupPopup$MyToolbarButton";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class HideableActionGroup
    extends EmptyAction.MyDelegatingActionGroup
    implements MoreHideableActionGroup {
        @NotNull
        private final MoreAction myMoreAction;

        private HideableActionGroup(@NotNull ActionGroup actionGroup, @NotNull MoreAction moreAction) {
            if (actionGroup == null) {
                HideableActionGroup.$$$reportNull$$$0(0);
            }
            if (moreAction == null) {
                HideableActionGroup.$$$reportNull$$$0(1);
            }
            super(actionGroup);
            this.myMoreAction = moreAction;
        }

        @Override
        public boolean shouldBeShown() {
            return this.myMoreAction.isExpanded();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "actionGroup";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "moreAction";
                    break;
                }
            }
            objectArray[1] = "com/intellij/dvcs/ui/BranchActionGroupPopup$HideableActionGroup";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static interface MoreHideableActionGroup {
        public boolean shouldBeShown();
    }

    private static class MoreAction
    extends DumbAwareAction
    implements KeepingPopupOpenAction {
        @NotNull
        private final Project myProject;
        @Nullable
        private final String mySettingName;
        private final boolean myDefaultExpandValue;
        private boolean myIsExpanded;
        @NotNull
        private final String myToCollapseText;
        @NotNull
        private final String myToExpandText;

        public MoreAction(@NotNull Project project, int numberOfHiddenNodes, @Nullable String settingName, boolean defaultExpandValue, boolean hasFavorites) {
            if (project == null) {
                MoreAction.$$$reportNull$$$0(0);
            }
            this.myProject = project;
            this.mySettingName = settingName;
            this.myDefaultExpandValue = defaultExpandValue;
            assert (numberOfHiddenNodes > 0);
            this.myToExpandText = "Show " + numberOfHiddenNodes + " More...";
            this.myToCollapseText = "Show " + (hasFavorites ? "Only Favorites" : "Less");
            this.setExpanded(settingName != null ? PropertiesComponent.getInstance((Project)project).getBoolean(settingName, defaultExpandValue) : defaultExpandValue);
        }

        public void actionPerformed(AnActionEvent e) {
            DataProvider dataProvider;
            this.setExpanded(!this.myIsExpanded);
            InputEvent event = e.getInputEvent();
            if (event != null && event.getSource() instanceof JComponent && (dataProvider = DataManager.getDataProvider((JComponent)((JComponent)event.getSource()))) != null) {
                ((ListPopupModel)ObjectUtils.assertNotNull((Object)POPUP_MODEL.getData(dataProvider))).refilter();
            }
        }

        public boolean isExpanded() {
            return this.myIsExpanded;
        }

        public void setExpanded(boolean isExpanded) {
            this.myIsExpanded = isExpanded;
            this.saveState();
            this.updateActionText();
        }

        private void updateActionText() {
            this.getTemplatePresentation().setText(this.myIsExpanded ? this.myToCollapseText : this.myToExpandText);
        }

        public void saveState() {
            if (this.mySettingName != null) {
                PropertiesComponent.getInstance((Project)this.myProject).setValue(this.mySettingName, this.myIsExpanded, this.myDefaultExpandValue);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/dvcs/ui/BranchActionGroupPopup$MoreAction", "<init>"));
        }
    }

    private static class MyTextSeparator
    extends SeparatorWithText {
        public MyTextSeparator() {
            this.setTextForeground((Color)JBColor.BLACK);
            this.setCaptionCentered(false);
            UIUtil.addInsets((JComponent)((Object)this), (int)4, (int)UIUtil.getListCellHPadding(), (int)0, (int)0);
        }

        protected void paintLine(Graphics g, int x, int y, int width) {
        }
    }

    private class MyPopupListElementRenderer
    extends PopupListElementRenderer<Object>
    implements IconListPopupRenderer {
        private ErrorLabel myInfoLabel;
        private IconComponent myIconLabel;

        public MyPopupListElementRenderer(ListPopupImpl aPopup) {
            super(aPopup);
        }

        protected SeparatorWithText createSeparator() {
            return new MyTextSeparator();
        }

        @Override
        public boolean isIconAt(@NotNull Point point) {
            if (point == null) {
                MyPopupListElementRenderer.$$$reportNull$$$0(0);
            }
            JList list2 = BranchActionGroupPopup.this.getList();
            int index = BranchActionGroupPopup.this.getList().locationToIndex(point);
            Rectangle bounds = BranchActionGroupPopup.this.getList().getCellBounds(index, index);
            Component renderer = this.getListCellRendererComponent(list2, list2.getSelectedValue(), index, true, true);
            renderer.setBounds(bounds);
            renderer.doLayout();
            point.translate(-bounds.x, -bounds.y);
            return SwingUtilities.getDeepestComponentAt(renderer, point.x, point.y) instanceof IconComponent;
        }

        @Override
        protected void customizeComponent(JList list2, Object value, boolean isSelected) {
            MoreAction more = (MoreAction)BranchActionGroupPopup.getSpecificAction(value, MoreAction.class);
            if (more != null) {
                this.myTextLabel.setForeground((Color)JBColor.gray);
            }
            super.customizeComponent(list2, value, isSelected);
            this.myTextLabel.setIcon(null);
            this.myTextLabel.setDisabledIcon(null);
            this.myIconLabel.setIcon(isSelected ? this.myDescriptor.getSelectedIconFor(value) : this.myDescriptor.getIconFor(value));
            PopupElementWithAdditionalInfo additionalInfoAction = (PopupElementWithAdditionalInfo)BranchActionGroupPopup.getSpecificAction(value, PopupElementWithAdditionalInfo.class);
            this.updateInfoComponent(this.myInfoLabel, additionalInfoAction != null ? additionalInfoAction.getInfoText() : null, isSelected);
        }

        private void updateInfoComponent(@NotNull ErrorLabel infoLabel, @Nullable String infoText, boolean isSelected) {
            if (infoLabel == null) {
                MyPopupListElementRenderer.$$$reportNull$$$0(1);
            }
            if (infoText != null) {
                infoLabel.setVisible(true);
                infoLabel.setText(infoText);
                if (isSelected) {
                    this.setSelected((JComponent)infoLabel);
                } else {
                    infoLabel.setBackground(this.getBackground());
                    infoLabel.setForeground((Color)JBColor.GRAY);
                }
            } else {
                infoLabel.setVisible(false);
            }
        }

        @Override
        protected JComponent createItemComponent() {
            this.myTextLabel = new ErrorLabel();
            this.myTextLabel.setOpaque(true);
            this.myTextLabel.setBorder(JBUI.Borders.empty((int)1));
            this.myInfoLabel = new ErrorLabel();
            this.myInfoLabel.setOpaque(true);
            this.myInfoLabel.setBorder((Border)JBUI.Borders.empty((int)1, (int)10, (int)1, (int)1));
            this.myInfoLabel.setFont(FontUtil.minusOne((Font)this.myInfoLabel.getFont()));
            OpaquePanel compoundPanel = new OpaquePanel((LayoutManager)new BorderLayout(), (Color)JBColor.WHITE);
            this.myIconLabel = new IconComponent();
            this.myInfoLabel.setHorizontalAlignment(4);
            OpaquePanel compoundTextPanel = new OpaquePanel((LayoutManager)new BorderLayout(), compoundPanel.getBackground());
            OpaquePanel textPanel = new OpaquePanel((LayoutManager)new BorderLayout(), compoundPanel.getBackground());
            compoundPanel.add((Component)this.myIconLabel, "West");
            textPanel.add((Component)this.myTextLabel, "West");
            textPanel.add((Component)this.myInfoLabel, "Center");
            compoundTextPanel.add((Component)textPanel, "Center");
            compoundPanel.add((Component)compoundTextPanel, "Center");
            return this.layoutComponent((JComponent)compoundPanel);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "point";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "infoLabel";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/dvcs/ui/BranchActionGroupPopup$MyPopupListElementRenderer";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isIconAt";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "updateInfoComponent";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }

        private class IconComponent
        extends JLabel {
            private IconComponent() {
            }
        }
    }
}

