/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.codeInsight.TargetElementUtil;
import com.intellij.codeInsight.daemon.impl.IdentifierUtil;
import com.intellij.codeInsight.highlighting.HighlightManager;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.actions.QualifiedNameProvider;
import com.intellij.ide.dnd.FileCopyPasteUtil;
import com.intellij.openapi.actionSystem.ActionPlaces;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.openapi.wm.ex.StatusBarEx;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiReference;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.LogicalRoot;
import com.intellij.util.LogicalRootsManager;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CopyReferenceAction
extends DumbAwareAction {
    public static final DataFlavor ourFlavor = FileCopyPasteUtil.createJvmDataFlavor(MyTransferable.class);

    public CopyReferenceAction() {
        this.setEnabledInModalContext(true);
        this.setInjectedContext(true);
    }

    public void update(AnActionEvent e) {
        boolean enabled;
        boolean plural = false;
        boolean paths = false;
        DataContext dataContext = e.getDataContext();
        Editor editor = (Editor)CommonDataKeys.EDITOR.getData(dataContext);
        if (editor != null && FileDocumentManager.getInstance().getFile(editor.getDocument()) != null) {
            enabled = true;
        } else {
            List<PsiElement> elements = CopyReferenceAction.getElementsToCopy(editor, dataContext);
            enabled = !elements.isEmpty();
            plural = elements.size() > 1;
            paths = elements.stream().allMatch(el -> el instanceof PsiFileSystemItem && CopyReferenceAction.getQualifiedNameFromProviders(el) == null);
        }
        e.getPresentation().setEnabled(enabled);
        if (ActionPlaces.isPopupPlace((String)e.getPlace())) {
            e.getPresentation().setVisible(enabled);
        } else {
            e.getPresentation().setVisible(true);
        }
        e.getPresentation().setText(paths ? (plural ? "Cop&y Relative Paths" : "Cop&y Relative Path") : (plural ? "Cop&y References" : "Cop&y Reference"));
    }

    public void actionPerformed(AnActionEvent e) {
        DataContext dataContext = e.getDataContext();
        Editor editor = (Editor)CommonDataKeys.EDITOR.getData(dataContext);
        Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        List<PsiElement> elements = CopyReferenceAction.getElementsToCopy(editor, dataContext);
        if (!CopyReferenceAction.doCopy(elements, project, editor) && editor != null && project != null) {
            Document document = editor.getDocument();
            PsiFile file2 = PsiDocumentManager.getInstance((Project)project).getCachedPsiFile(document);
            if (file2 != null) {
                String toCopy = CopyReferenceAction.getFileFqn(file2) + ":" + (editor.getCaretModel().getLogicalPosition().line + 1);
                CopyPasteManager.getInstance().setContents((Transferable)new StringSelection(toCopy));
                CopyReferenceAction.setStatusBarText(project, toCopy + " has been copied");
            }
            return;
        }
        HighlightManager highlightManager = HighlightManager.getInstance((Project)project);
        EditorColorsManager manager = EditorColorsManager.getInstance();
        TextAttributes attributes = manager.getGlobalScheme().getAttributes(EditorColors.SEARCH_RESULT_ATTRIBUTES);
        if (elements.size() == 1 && editor != null && project != null) {
            PsiElement element = elements.get(0);
            PsiElement nameIdentifier = IdentifierUtil.getNameIdentifier(element);
            if (nameIdentifier != null) {
                highlightManager.addOccurrenceHighlights(editor, new PsiElement[]{nameIdentifier}, attributes, true, null);
            } else {
                PsiReference reference = TargetElementUtil.findReference(editor, editor.getCaretModel().getOffset());
                if (reference != null) {
                    highlightManager.addOccurrenceHighlights(editor, new PsiReference[]{reference}, attributes, true, null);
                } else if (element != PsiDocumentManager.getInstance((Project)project).getCachedPsiFile(editor.getDocument())) {
                    highlightManager.addOccurrenceHighlights(editor, new PsiElement[]{element}, attributes, true, null);
                }
            }
        }
    }

    @NotNull
    private static List<PsiElement> getElementsToCopy(@Nullable Editor editor, DataContext dataContext) {
        PsiElement[] psiElements;
        PsiReference reference;
        ArrayList elements = ContainerUtil.newArrayList();
        if (editor != null && (reference = TargetElementUtil.findReference(editor)) != null) {
            ContainerUtil.addIfNotNull((Collection)elements, (Object)reference.getElement());
        }
        if (elements.isEmpty() && (psiElements = (PsiElement[])LangDataKeys.PSI_ELEMENT_ARRAY.getData(dataContext)) != null) {
            Collections.addAll(elements, psiElements);
        }
        if (elements.isEmpty()) {
            ContainerUtil.addIfNotNull((Collection)elements, (Object)CommonDataKeys.PSI_ELEMENT.getData(dataContext));
        }
        if (elements.isEmpty() && editor == null) {
            Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
            VirtualFile[] files = (VirtualFile[])CommonDataKeys.VIRTUAL_FILE_ARRAY.getData(dataContext);
            if (project != null && files != null) {
                for (VirtualFile file2 : files) {
                    ContainerUtil.addIfNotNull((Collection)elements, (Object)PsiManager.getInstance((Project)project).findFile(file2));
                }
            }
        }
        List list2 = ContainerUtil.mapNotNull((Collection)elements, element -> element instanceof PsiFile && !((PsiFile)element).getViewProvider().isPhysical() ? null : CopyReferenceAction.adjustElement(element));
        if (list2 == null) {
            CopyReferenceAction.$$$reportNull$$$0(0);
        }
        return list2;
    }

    private static PsiElement adjustElement(PsiElement element) {
        for (QualifiedNameProvider provider : (QualifiedNameProvider[])Extensions.getExtensions(QualifiedNameProvider.EP_NAME)) {
            PsiElement adjustedElement = provider.adjustElementToCopy(element);
            if (adjustedElement == null) continue;
            return adjustedElement;
        }
        return element;
    }

    public static boolean doCopy(PsiElement element, Project project) {
        return CopyReferenceAction.doCopy(Arrays.asList(element), project, null);
    }

    private static boolean doCopy(List<PsiElement> elements, @Nullable Project project, @Nullable Editor editor) {
        if (elements.isEmpty()) {
            return false;
        }
        ArrayList fqns = ContainerUtil.newArrayList();
        for (PsiElement element : elements) {
            String fqn = CopyReferenceAction.elementToFqn(element, editor);
            if (fqn == null) {
                return false;
            }
            fqns.add(fqn);
        }
        String toCopy = StringUtil.join((Collection)fqns, (String)"\n");
        CopyPasteManager.getInstance().setContents((Transferable)new MyTransferable(toCopy));
        CopyReferenceAction.setStatusBarText(project, IdeBundle.message((String)"message.reference.to.fqn.has.been.copied", (Object[])new Object[]{toCopy}));
        return true;
    }

    private static void setStatusBarText(Project project, String message) {
        StatusBarEx statusBar;
        if (project != null && (statusBar = (StatusBarEx)WindowManager.getInstance().getStatusBar(project)) != null) {
            statusBar.setInfo(message);
        }
    }

    @Nullable
    public static String elementToFqn(@Nullable PsiElement element) {
        return CopyReferenceAction.elementToFqn(element, null);
    }

    @Nullable
    private static String elementToFqn(@Nullable PsiElement element, @Nullable Editor editor) {
        PsiReference reference;
        String result2 = CopyReferenceAction.getQualifiedNameFromProviders(element);
        if (result2 != null) {
            return result2;
        }
        if (editor != null && (reference = TargetElementUtil.findReference(editor, editor.getCaretModel().getOffset())) != null && (result2 = CopyReferenceAction.getQualifiedNameFromProviders(reference.resolve())) != null) {
            return result2;
        }
        if (element instanceof PsiFile) {
            return FileUtil.toSystemIndependentName((String)CopyReferenceAction.getFileFqn((PsiFile)element));
        }
        if (element instanceof PsiDirectory) {
            return FileUtil.toSystemIndependentName((String)CopyReferenceAction.getVirtualFileFqn(((PsiDirectory)element).getVirtualFile(), element.getProject()));
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private static String getQualifiedNameFromProviders(@Nullable PsiElement element) {
        if (element == null) {
            return null;
        }
        DumbService.getInstance((Project)element.getProject()).setAlternativeResolveEnabled(true);
        try {
            for (QualifiedNameProvider provider : (QualifiedNameProvider[])Extensions.getExtensions(QualifiedNameProvider.EP_NAME)) {
                String result2 = provider.getQualifiedName(element);
                if (result2 == null) continue;
                String string = result2;
                return string;
            }
        }
        finally {
            DumbService.getInstance((Project)element.getProject()).setAlternativeResolveEnabled(false);
        }
        return null;
    }

    @NotNull
    private static String getFileFqn(PsiFile file2) {
        VirtualFile virtualFile = file2.getVirtualFile();
        String string = virtualFile == null ? file2.getName() : CopyReferenceAction.getVirtualFileFqn(virtualFile, file2.getProject());
        if (string == null) {
            CopyReferenceAction.$$$reportNull$$$0(1);
        }
        return string;
    }

    private static String getVirtualFileFqn(@NotNull VirtualFile virtualFile, @NotNull Project project) {
        String relative;
        LogicalRoot logicalRoot;
        VirtualFile logicalRootFile;
        if (virtualFile == null) {
            CopyReferenceAction.$$$reportNull$$$0(2);
        }
        if (project == null) {
            CopyReferenceAction.$$$reportNull$$$0(3);
        }
        VirtualFile virtualFile2 = logicalRootFile = (logicalRoot = LogicalRootsManager.getLogicalRootsManager((Project)project).findLogicalRoot(virtualFile)) != null ? logicalRoot.getVirtualFile() : null;
        if (logicalRootFile != null && !virtualFile.equals(logicalRootFile)) {
            return (String)ObjectUtils.assertNotNull((Object)VfsUtilCore.getRelativePath((VirtualFile)virtualFile, (VirtualFile)logicalRootFile, (char)'/'));
        }
        Object outerMostRoot = null;
        ProjectFileIndex index = ProjectRootManager.getInstance((Project)project).getFileIndex();
        for (VirtualFile each = virtualFile; each != null && (each = index.getContentRootForFile(each, false)) != null; each = each.getParent()) {
            outerMostRoot = each;
        }
        if (outerMostRoot != null && !outerMostRoot.equals(virtualFile) && (relative = VfsUtilCore.getRelativePath((VirtualFile)virtualFile, (VirtualFile)outerMostRoot, (char)'/')) != null) {
            return relative;
        }
        return virtualFile.getPath();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/actions/CopyReferenceAction";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementsToCopy";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileFqn";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/actions/CopyReferenceAction";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getVirtualFileFqn";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyTransferable
    implements Transferable {
        private final String fqn;

        public MyTransferable(String fqn) {
            this.fqn = fqn;
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            return new DataFlavor[]{ourFlavor, DataFlavor.stringFlavor};
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor flavor) {
            return ArrayUtilRt.find((Object[])this.getTransferDataFlavors(), (Object)flavor) != -1;
        }

        @Override
        @Nullable
        public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
            if (this.isDataFlavorSupported(flavor)) {
                return this.fqn;
            }
            return null;
        }
    }
}

