/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.diff;

import com.intellij.ide.diff.DiffElement;
import com.intellij.ide.presentation.VirtualFilePresentation;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VFileProperty;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.RefreshQueue;
import com.intellij.pom.Navigatable;
import com.intellij.util.PlatformIcons;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.concurrent.Callable;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VirtualFileDiffElement
extends DiffElement<VirtualFile> {
    private final VirtualFile myFile;

    public VirtualFileDiffElement(@NotNull VirtualFile file2) {
        if (file2 == null) {
            VirtualFileDiffElement.$$$reportNull$$$0(0);
        }
        this.myFile = file2;
    }

    public String getPath() {
        return this.myFile.getPresentableUrl();
    }

    @NotNull
    public String getName() {
        String string = this.myFile.getName();
        if (string == null) {
            VirtualFileDiffElement.$$$reportNull$$$0(1);
        }
        return string;
    }

    public String getPresentablePath() {
        return this.getPath();
    }

    public long getSize() {
        return this.myFile.getLength();
    }

    public long getTimeStamp() {
        return this.myFile.getTimeStamp();
    }

    public boolean isContainer() {
        return this.myFile.isDirectory();
    }

    @Nullable
    public Navigatable getNavigatable(@Nullable Project project) {
        if (project == null || project.isDefault() || !this.myFile.isValid()) {
            return null;
        }
        return new OpenFileDescriptor(project, this.myFile);
    }

    public VirtualFileDiffElement[] getChildren() {
        if (this.myFile.is(VFileProperty.SYMLINK)) {
            return new VirtualFileDiffElement[0];
        }
        VirtualFile[] files = this.myFile.getChildren();
        ArrayList<VirtualFileDiffElement> elements = new ArrayList<VirtualFileDiffElement>();
        for (VirtualFile file2 : files) {
            if (FileTypeManager.getInstance().isFileIgnored(file2) || !file2.isValid()) continue;
            elements.add(new VirtualFileDiffElement(file2));
        }
        return elements.toArray(new VirtualFileDiffElement[elements.size()]);
    }

    @Nullable
    public byte[] getContent() throws IOException {
        return (byte[])ApplicationManager.getApplication().runReadAction((ThrowableComputable)new ThrowableComputable<byte[], IOException>(){

            public byte[] compute() throws IOException {
                return VirtualFileDiffElement.this.myFile.contentsToByteArray();
            }
        });
    }

    public VirtualFile getValue() {
        return this.myFile;
    }

    public Icon getIcon() {
        return this.isContainer() ? PlatformIcons.FOLDER_ICON : VirtualFilePresentation.getIcon((VirtualFile)this.myFile);
    }

    public Callable<DiffElement<VirtualFile>> getElementChooser(Project project) {
        return () -> {
            FileChooserDescriptor descriptor = this.getChooserDescriptor();
            VirtualFile[] result2 = FileChooser.chooseFiles((FileChooserDescriptor)descriptor, (Project)project, (VirtualFile)this.getValue());
            return result2.length == 1 ? this.createElement(result2[0]) : null;
        };
    }

    @Nullable
    protected VirtualFileDiffElement createElement(VirtualFile file2) {
        return new VirtualFileDiffElement(file2);
    }

    protected FileChooserDescriptor getChooserDescriptor() {
        return new FileChooserDescriptor(false, true, false, false, false, false);
    }

    public boolean isOperationsEnabled() {
        return this.myFile.getFileSystem() instanceof LocalFileSystem;
    }

    @NotNull
    public Charset getCharset() {
        Charset charset = this.myFile.getCharset();
        if (charset == null) {
            VirtualFileDiffElement.$$$reportNull$$$0(2);
        }
        return charset;
    }

    public FileType getFileType() {
        return this.myFile.getFileType();
    }

    public VirtualFileDiffElement copyTo(DiffElement<VirtualFile> container, String relativePath) {
        try {
            File src = new File(this.myFile.getPath());
            File trg = new File(((VirtualFile)container.getValue()).getPath() + relativePath + src.getName());
            FileUtil.copy((File)src, (File)trg);
            VirtualFile virtualFile = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(trg);
            if (virtualFile != null) {
                return new VirtualFileDiffElement(virtualFile);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    public boolean delete() {
        try {
            this.myFile.delete((Object)this);
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    public void refresh(boolean userInitiated) {
        VirtualFileDiffElement.refreshFile(userInitiated, this.myFile);
    }

    public static void refreshFile(boolean userInitiated, VirtualFile virtualFile) {
        if (userInitiated) {
            final ArrayList<Document> docsToSave = new ArrayList<Document>();
            final FileDocumentManager manager = FileDocumentManager.getInstance();
            for (Document document : manager.getUnsavedDocuments()) {
                VirtualFile file2 = manager.getFile(document);
                if (file2 == null || !VfsUtilCore.isAncestor((VirtualFile)virtualFile, (VirtualFile)file2, (boolean)false)) continue;
                docsToSave.add(document);
            }
            if (!docsToSave.isEmpty()) {
                new WriteAction(){

                    protected void run(@NotNull Result result2) throws Throwable {
                        if (result2 == null) {
                            2.$$$reportNull$$$0(0);
                        }
                        for (Document document : docsToSave) {
                            manager.saveDocument(document);
                        }
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/ide/diff/VirtualFileDiffElement$2", "run"));
                    }
                }.execute();
            }
            ModalityState modalityState = ProgressManager.getInstance().getProgressIndicator().getModalityState();
            VfsUtil.markDirty((boolean)true, (boolean)true, (VirtualFile[])new VirtualFile[]{virtualFile});
            RefreshQueue.getInstance().refresh(false, true, null, modalityState, new VirtualFile[]{virtualFile});
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/diff/VirtualFileDiffElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/diff/VirtualFileDiffElement";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getCharset";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

