/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.hierarchy;

import com.intellij.ide.CommonActionsManager;
import com.intellij.ide.DefaultTreeExpander;
import com.intellij.ide.ExporterToTextFile;
import com.intellij.ide.actions.CloseTabToolbarAction;
import com.intellij.ide.hierarchy.ExporterToTextFileHierarchy;
import com.intellij.ide.hierarchy.HierarchyBrowser;
import com.intellij.ide.hierarchy.HierarchyBrowserManager;
import com.intellij.ide.hierarchy.HierarchyNodeDescriptor;
import com.intellij.ide.hierarchy.HierarchyNodeRenderer;
import com.intellij.ide.hierarchy.HierarchyTreeBuilder;
import com.intellij.ide.util.treeView.AbstractTreeUi;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.SimpleToolWindowPanel;
import com.intellij.pom.Navigatable;
import com.intellij.psi.NavigatablePsiElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.ui.AutoScrollToSourceHandler;
import com.intellij.ui.TreeSpeedSearch;
import com.intellij.ui.content.Content;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.tree.TreeUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class HierarchyBrowserBase
extends SimpleToolWindowPanel
implements HierarchyBrowser,
Disposable,
DataProvider {
    private static final HierarchyNodeDescriptor[] EMPTY_DESCRIPTORS = new HierarchyNodeDescriptor[0];
    protected final Project myProject;
    protected Content myContent;
    private final AutoScrollToSourceHandler myAutoScrollToSourceHandler;
    private volatile boolean myDisposed;

    protected HierarchyBrowserBase(@NotNull Project project) {
        if (project == null) {
            HierarchyBrowserBase.$$$reportNull$$$0(0);
        }
        super(true, true);
        this.myProject = project;
        this.myAutoScrollToSourceHandler = new AutoScrollToSourceHandler(){

            protected boolean isAutoScrollMode() {
                return HierarchyBrowserManager.getSettings((Project)HierarchyBrowserBase.this.myProject).IS_AUTOSCROLL_TO_SOURCE;
            }

            protected void setAutoScrollMode(boolean state) {
                HierarchyBrowserManager.getSettings((Project)HierarchyBrowserBase.this.myProject).IS_AUTOSCROLL_TO_SOURCE = state;
            }
        };
    }

    public void setContent(Content content) {
        this.myContent = content;
    }

    protected void buildUi(JComponent toolbar, JComponent content) {
        this.setToolbar(toolbar);
        this.setContent(content);
    }

    public void dispose() {
        this.myDisposed = true;
    }

    public boolean isDisposed() {
        return this.myDisposed;
    }

    protected ActionToolbar createToolbar(String place, String helpID) {
        DefaultActionGroup actionGroup = new DefaultActionGroup();
        this.appendActions(actionGroup, helpID);
        ActionToolbar actionToolbar = ActionManager.getInstance().createActionToolbar(place, (ActionGroup)actionGroup, true);
        actionToolbar.setTargetComponent((JComponent)((Object)this));
        return actionToolbar;
    }

    protected void appendActions(@NotNull DefaultActionGroup actionGroup, @Nullable String helpID) {
        if (actionGroup == null) {
            HierarchyBrowserBase.$$$reportNull$$$0(1);
        }
        actionGroup.add((AnAction)this.myAutoScrollToSourceHandler.createToggleAction());
        ActionManager actionManager = ActionManager.getInstance();
        actionGroup.add(actionManager.getAction("ExpandAll"));
        actionGroup.add(actionManager.getAction("PinToolwindowTab"));
        actionGroup.add(CommonActionsManager.getInstance().createExportToTextFileAction((ExporterToTextFile)new ExporterToTextFileHierarchy(this)));
        actionGroup.add((AnAction)new CloseAction());
    }

    protected abstract JTree getCurrentTree();

    protected abstract HierarchyTreeBuilder getCurrentBuilder();

    @Nullable
    protected abstract PsiElement getElementFromDescriptor(@NotNull HierarchyNodeDescriptor var1);

    @Nullable
    protected DefaultMutableTreeNode getSelectedNode() {
        JTree tree = this.getCurrentTree();
        if (tree == null) {
            return null;
        }
        TreePath path = tree.getSelectionPath();
        if (path == null) {
            return null;
        }
        Object lastPathComponent = path.getLastPathComponent();
        if (!(lastPathComponent instanceof DefaultMutableTreeNode)) {
            return null;
        }
        return (DefaultMutableTreeNode)lastPathComponent;
    }

    @Nullable
    protected final PsiElement getSelectedElement() {
        DefaultMutableTreeNode node = this.getSelectedNode();
        HierarchyNodeDescriptor descriptor = node != null ? this.getDescriptor(node) : null;
        return descriptor != null ? this.getElementFromDescriptor(descriptor) : null;
    }

    @Nullable
    protected HierarchyNodeDescriptor getDescriptor(DefaultMutableTreeNode node) {
        Object userObject;
        Object object = userObject = node != null ? node.getUserObject() : null;
        if (userObject instanceof HierarchyNodeDescriptor) {
            return (HierarchyNodeDescriptor)((Object)userObject);
        }
        return null;
    }

    public PsiElement[] getAvailableElements() {
        JTree tree = this.getCurrentTree();
        if (tree == null) {
            return PsiElement.EMPTY_ARRAY;
        }
        TreeModel model = tree.getModel();
        Object root = model.getRoot();
        if (!(root instanceof DefaultMutableTreeNode)) {
            return PsiElement.EMPTY_ARRAY;
        }
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)root;
        HierarchyNodeDescriptor descriptor = this.getDescriptor(node);
        HashSet<PsiElement> result2 = new HashSet<PsiElement>();
        this.collectElements(descriptor, result2);
        return result2.toArray(PsiElement.EMPTY_ARRAY);
    }

    private void collectElements(HierarchyNodeDescriptor descriptor, Set<PsiElement> out) {
        Object[] children2;
        if (descriptor == null) {
            return;
        }
        PsiElement element = this.getElementFromDescriptor(descriptor);
        if (element != null) {
            out.add(element.getNavigationElement());
        }
        if ((children2 = descriptor.getCachedChildren()) == null) {
            return;
        }
        for (Object child : children2) {
            if (!(child instanceof HierarchyNodeDescriptor)) continue;
            HierarchyNodeDescriptor childDescriptor = (HierarchyNodeDescriptor)((Object)child);
            this.collectElements(childDescriptor, out);
        }
    }

    public final HierarchyNodeDescriptor[] getSelectedDescriptors() {
        JTree tree = this.getCurrentTree();
        if (tree == null) {
            return EMPTY_DESCRIPTORS;
        }
        TreePath[] paths = tree.getSelectionPaths();
        if (paths == null || paths.length == 0) {
            return EMPTY_DESCRIPTORS;
        }
        ArrayList<HierarchyNodeDescriptor> list2 = new ArrayList<HierarchyNodeDescriptor>(paths.length);
        for (TreePath path : paths) {
            DefaultMutableTreeNode node;
            HierarchyNodeDescriptor descriptor;
            Object lastPathComponent = path.getLastPathComponent();
            if (!(lastPathComponent instanceof DefaultMutableTreeNode) || (descriptor = this.getDescriptor(node = (DefaultMutableTreeNode)lastPathComponent)) == null) continue;
            list2.add(descriptor);
        }
        return list2.toArray(new HierarchyNodeDescriptor[list2.size()]);
    }

    @NotNull
    protected PsiElement[] getSelectedElements() {
        HierarchyNodeDescriptor[] descriptors = this.getSelectedDescriptors();
        ArrayList<PsiElement> elements = new ArrayList<PsiElement>();
        for (HierarchyNodeDescriptor descriptor : descriptors) {
            PsiElement element = this.getElementFromDescriptor(descriptor);
            if (element == null) continue;
            elements.add(element);
        }
        PsiElement[] psiElementArray = PsiUtilCore.toPsiElementArray(elements);
        if (psiElementArray == null) {
            HierarchyBrowserBase.$$$reportNull$$$0(2);
        }
        return psiElementArray;
    }

    private Navigatable[] getNavigatables() {
        HierarchyNodeDescriptor[] selectedDescriptors = this.getSelectedDescriptors();
        if (selectedDescriptors == null || selectedDescriptors.length == 0) {
            return null;
        }
        ArrayList<Navigatable> result2 = new ArrayList<Navigatable>();
        for (HierarchyNodeDescriptor descriptor : selectedDescriptors) {
            Navigatable navigatable = this.getNavigatable(descriptor);
            if (navigatable == null) continue;
            result2.add(navigatable);
        }
        return result2.toArray(new Navigatable[result2.size()]);
    }

    private Navigatable getNavigatable(HierarchyNodeDescriptor descriptor) {
        if (descriptor instanceof Navigatable && descriptor.isValid()) {
            return (Navigatable)descriptor;
        }
        PsiElement element = this.getElementFromDescriptor(descriptor);
        if (element instanceof NavigatablePsiElement && element.isValid()) {
            return (NavigatablePsiElement)element;
        }
        return null;
    }

    @Nullable
    public Object getData(@NonNls String dataId) {
        JTree tree;
        if (CommonDataKeys.PSI_ELEMENT.is(dataId)) {
            PsiElement anElement = this.getSelectedElement();
            return anElement != null && anElement.isValid() ? anElement : super.getData(dataId);
        }
        if (LangDataKeys.PSI_ELEMENT_ARRAY.is(dataId)) {
            return this.getSelectedElements();
        }
        if (PlatformDataKeys.DELETE_ELEMENT_PROVIDER.is(dataId)) {
            return null;
        }
        if (CommonDataKeys.NAVIGATABLE.is(dataId)) {
            DefaultMutableTreeNode selectedNode = this.getSelectedNode();
            if (selectedNode == null) {
                return null;
            }
            HierarchyNodeDescriptor descriptor = this.getDescriptor(selectedNode);
            if (descriptor == null) {
                return null;
            }
            return this.getNavigatable(descriptor);
        }
        if (CommonDataKeys.NAVIGATABLE_ARRAY.is(dataId)) {
            return this.getNavigatables();
        }
        if (PlatformDataKeys.TREE_EXPANDER.is(dataId) && (tree = this.getCurrentTree()) != null) {
            return new DefaultTreeExpander(tree);
        }
        return super.getData(dataId);
    }

    protected void configureTree(@NotNull Tree tree) {
        if (tree == null) {
            HierarchyBrowserBase.$$$reportNull$$$0(3);
        }
        tree.getSelectionModel().setSelectionMode(4);
        tree.setToggleClickCount(-1);
        tree.setCellRenderer((TreeCellRenderer)((Object)new HierarchyNodeRenderer()));
        UIUtil.setLineStyleAngled((JTree)tree);
        new TreeSpeedSearch((JTree)tree);
        TreeUtil.installActions((JTree)tree);
        this.myAutoScrollToSourceHandler.install((JTree)tree);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionGroup";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/hierarchy/HierarchyBrowserBase";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tree";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/hierarchy/HierarchyBrowserBase";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedElements";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "appendActions";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "configureTree";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private final class CloseAction
    extends CloseTabToolbarAction {
        private CloseAction() {
        }

        public final void actionPerformed(AnActionEvent e) {
            ProgressIndicator progress;
            HierarchyTreeBuilder builder = HierarchyBrowserBase.this.getCurrentBuilder();
            AbstractTreeUi treeUi = builder != null ? builder.getUi() : null;
            ProgressIndicator progressIndicator = progress = treeUi != null ? treeUi.getProgress() : null;
            if (progress != null) {
                progress.cancel();
            }
            HierarchyBrowserBase.this.myContent.getManager().removeContent(HierarchyBrowserBase.this.myContent, true);
        }

        public void update(AnActionEvent e) {
            e.getPresentation().setVisible(HierarchyBrowserBase.this.myContent != null);
        }
    }
}

