/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins;

import com.intellij.diagnostic.PluginException;
import com.intellij.ide.ClassUtilCore;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.StartupProgress;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.IdeaPluginDescriptorImpl;
import com.intellij.ide.plugins.PluginClassCache;
import com.intellij.ide.plugins.PluginXmlPathResolver;
import com.intellij.ide.plugins.cl.PluginClassLoader;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.AreaListener;
import com.intellij.openapi.extensions.ExtensionPoint;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.extensions.ExtensionsArea;
import com.intellij.openapi.extensions.LogProvider;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.extensions.impl.PicoPluginExtensionInitializationException;
import com.intellij.openapi.util.BuildNumber;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.StreamUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.LineSeparator;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.execution.ParametersListUtil;
import com.intellij.util.graph.CachingSemiGraph;
import com.intellij.util.graph.DFSTBuilder;
import com.intellij.util.graph.Graph;
import com.intellij.util.graph.GraphGenerator;
import com.intellij.util.graph.InboundSemiGraph;
import com.intellij.util.io.URLUtil;
import com.intellij.util.lang.UrlClassLoader;
import com.intellij.util.xmlb.JDOMXIncluder;
import com.intellij.util.xmlb.XmlSerializationException;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import gnu.trove.TObjectIntHashMap;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.jdom.Document;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PluginManagerCore {
    private static final Logger LOG = Logger.getInstance(PluginManagerCore.class);
    public static final String DISABLED_PLUGINS_FILENAME = "disabled_plugins.txt";
    public static final String CORE_PLUGIN_ID = "com.intellij";
    public static final String META_INF = "META-INF";
    public static final String PLUGIN_XML = "plugin.xml";
    public static final float PLUGINS_PROGRESS_PART = 0.3f;
    public static final float LOADERS_PROGRESS_PART = 0.35f;
    public static String BUILD_NUMBER;
    private static final TObjectIntHashMap<PluginId> ourId2Index;
    private static final String MODULE_DEPENDENCY_PREFIX = "com.intellij.module";
    private static final Map<String, IdeaPluginDescriptorImpl> ourModulesToContainingPlugins;
    private static final PluginClassCache ourPluginClasses;
    private static final String SPECIAL_IDEA_PLUGIN = "IDEA CORE";
    private static final String PROPERTY_PLUGIN_PATH = "plugin.path";
    static final String DISABLE = "disable";
    static final String ENABLE = "enable";
    static final String EDIT = "edit";
    private static List<String> ourDisabledPlugins;
    private static MultiMap<String, String> ourBrokenPluginVersions;
    private static IdeaPluginDescriptor[] ourPlugins;
    static String myPluginError;
    static List<String> myPlugins2Disable;
    static LinkedHashSet<String> myPlugins2Enable;
    private static List<Runnable> myDisablePluginListeners;

    @NotNull
    public static IdeaPluginDescriptor[] getPlugins() {
        IdeaPluginDescriptor[] ideaPluginDescriptorArray = PluginManagerCore.getPlugins(null);
        if (ideaPluginDescriptorArray == null) {
            PluginManagerCore.$$$reportNull$$$0(0);
        }
        return ideaPluginDescriptorArray;
    }

    @NotNull
    public static synchronized IdeaPluginDescriptor[] getPlugins(@Nullable StartupProgress progress) {
        if (ourPlugins == null) {
            PluginManagerCore.initPlugins(progress);
        }
        if (ourPlugins == null) {
            PluginManagerCore.$$$reportNull$$$0(1);
        }
        return ourPlugins;
    }

    public static synchronized void setPlugins(@NotNull IdeaPluginDescriptor[] descriptors) {
        if (descriptors == null) {
            PluginManagerCore.$$$reportNull$$$0(2);
        }
        ourPlugins = descriptors;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadDisabledPlugins(@NotNull String configPath, @NotNull Collection<String> disabledPlugins) {
        if (configPath == null) {
            PluginManagerCore.$$$reportNull$$$0(3);
        }
        if (disabledPlugins == null) {
            PluginManagerCore.$$$reportNull$$$0(4);
        }
        File file2 = new File(configPath, DISABLED_PLUGINS_FILENAME);
        List requiredPlugins = StringUtil.split((String)System.getProperty("idea.required.plugins.id", ""), (String)",");
        if (file2.isFile()) {
            try {
                try (BufferedReader reader = new BufferedReader(new FileReader(file2));){
                    String id;
                    while ((id = reader.readLine()) != null) {
                        if (requiredPlugins.contains(id = id.trim())) continue;
                        disabledPlugins.add(id);
                    }
                }
                finally {
                    if (!requiredPlugins.isEmpty()) {
                        PluginManagerCore.savePluginsList(disabledPlugins, false, new File(PathManager.getConfigPath(), DISABLED_PLUGINS_FILENAME));
                        PluginManagerCore.fireEditDisablePlugins();
                    }
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    @NotNull
    public static List<String> getDisabledPlugins() {
        if (ourDisabledPlugins == null) {
            ourDisabledPlugins = new ArrayList<String>();
            if (System.getProperty("idea.ignore.disabled.plugins") == null && !PluginManagerCore.isUnitTestMode()) {
                PluginManagerCore.loadDisabledPlugins(PathManager.getConfigPath(), ourDisabledPlugins);
            }
        }
        List<String> list2 = ourDisabledPlugins;
        if (list2 == null) {
            PluginManagerCore.$$$reportNull$$$0(5);
        }
        return list2;
    }

    public static boolean isBrokenPlugin(@NotNull IdeaPluginDescriptor descriptor) {
        PluginId pluginId;
        if (descriptor == null) {
            PluginManagerCore.$$$reportNull$$$0(6);
        }
        if ((pluginId = descriptor.getPluginId()) == null) {
            return true;
        }
        return PluginManagerCore.getBrokenPluginVersions().get((Object)pluginId.getIdString()).contains(descriptor.getVersion());
    }

    @NotNull
    private static MultiMap<String, String> getBrokenPluginVersions() {
        if (ourBrokenPluginVersions == null) {
            ourBrokenPluginVersions = MultiMap.createSet();
            if (System.getProperty("idea.ignore.disabled.plugins") == null && !PluginManagerCore.isUnitTestMode()) {
                BufferedReader br = new BufferedReader(new InputStreamReader(PluginManagerCore.class.getResourceAsStream("/brokenPlugins.txt")));
                try {
                    String s;
                    while ((s = br.readLine()) != null) {
                        List tokens;
                        if ((s = s.trim()).startsWith("//") || (tokens = ParametersListUtil.parse((String)s)).isEmpty()) continue;
                        if (tokens.size() == 1) {
                            throw new RuntimeException("brokenPlugins.txt is broken. The line contains plugin name, but does not contains version: " + s);
                        }
                        String pluginId = (String)tokens.get(0);
                        List versions = tokens.subList(1, tokens.size());
                        ourBrokenPluginVersions.putValues((Object)pluginId, versions);
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException("Failed to read /brokenPlugins.txt", e);
                }
                finally {
                    StreamUtil.closeStream((Closeable)br);
                }
            }
        }
        MultiMap<String, String> multiMap = ourBrokenPluginVersions;
        if (multiMap == null) {
            PluginManagerCore.$$$reportNull$$$0(7);
        }
        return multiMap;
    }

    private static boolean isUnitTestMode() {
        Application app = ApplicationManager.getApplication();
        return app != null && app.isUnitTestMode();
    }

    public static void addDisablePluginListener(@NotNull Runnable listener2) {
        if (listener2 == null) {
            PluginManagerCore.$$$reportNull$$$0(8);
        }
        if (myDisablePluginListeners == null) {
            myDisablePluginListeners = new ArrayList<Runnable>();
        }
        myDisablePluginListeners.add(listener2);
    }

    public static void removeDisablePluginListener(@NotNull Runnable listener2) {
        if (listener2 == null) {
            PluginManagerCore.$$$reportNull$$$0(9);
        }
        if (myDisablePluginListeners != null) {
            myDisablePluginListeners.remove(listener2);
        }
    }

    private static void fireEditDisablePlugins() {
        if (myDisablePluginListeners != null) {
            for (Runnable listener2 : myDisablePluginListeners) {
                listener2.run();
            }
        }
    }

    public static void savePluginsList(@NotNull Collection<String> ids, boolean append, @NotNull File plugins2) throws IOException {
        if (ids == null) {
            PluginManagerCore.$$$reportNull$$$0(10);
        }
        if (plugins2 == null) {
            PluginManagerCore.$$$reportNull$$$0(11);
        }
        if (!plugins2.isFile()) {
            FileUtil.ensureCanCreateFile((File)plugins2);
        }
        PluginManagerCore.writePluginsList(ids, new BufferedWriter(new FileWriter(plugins2, append)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writePluginsList(@NotNull Collection<String> ids, @NotNull Writer writer) throws IOException {
        if (ids == null) {
            PluginManagerCore.$$$reportNull$$$0(12);
        }
        if (writer == null) {
            PluginManagerCore.$$$reportNull$$$0(13);
        }
        Object[] sortedIds = ArrayUtil.toStringArray(ids);
        Arrays.sort(sortedIds);
        try {
            for (Object id : sortedIds) {
                writer.write((String)id);
                writer.write(LineSeparator.getSystemLineSeparator().getSeparatorString());
            }
        }
        finally {
            writer.close();
        }
    }

    public static boolean disablePlugin(@NotNull String id) {
        List<String> disabledPlugins;
        if (id == null) {
            PluginManagerCore.$$$reportNull$$$0(14);
        }
        if ((disabledPlugins = PluginManagerCore.getDisabledPlugins()).contains(id)) {
            return false;
        }
        disabledPlugins.add(id);
        try {
            PluginManagerCore.saveDisabledPlugins(disabledPlugins, false);
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    public static boolean enablePlugin(@NotNull String id) {
        if (id == null) {
            PluginManagerCore.$$$reportNull$$$0(15);
        }
        if (!PluginManagerCore.getDisabledPlugins().contains(id)) {
            return false;
        }
        PluginManagerCore.getDisabledPlugins().remove(id);
        try {
            PluginManagerCore.saveDisabledPlugins(PluginManagerCore.getDisabledPlugins(), false);
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    public static void saveDisabledPlugins(@NotNull Collection<String> ids, boolean append) throws IOException {
        if (ids == null) {
            PluginManagerCore.$$$reportNull$$$0(16);
        }
        PluginManagerCore.saveDisabledPlugins(PathManager.getConfigPath(), ids, append);
    }

    public static void saveDisabledPlugins(@NotNull String configPath, @NotNull Collection<String> ids, boolean append) throws IOException {
        if (configPath == null) {
            PluginManagerCore.$$$reportNull$$$0(17);
        }
        if (ids == null) {
            PluginManagerCore.$$$reportNull$$$0(18);
        }
        File plugins2 = new File(configPath, DISABLED_PLUGINS_FILENAME);
        PluginManagerCore.savePluginsList(ids, append, plugins2);
        ourDisabledPlugins = null;
        PluginManagerCore.fireEditDisablePlugins();
    }

    public static Logger getLogger() {
        return LoggerHolder.ourLogger;
    }

    public static int getPluginLoadingOrder(@NotNull PluginId id) {
        if (id == null) {
            PluginManagerCore.$$$reportNull$$$0(19);
        }
        return ourId2Index.get((Object)id);
    }

    public static boolean isModuleDependency(@NotNull PluginId dependentPluginId) {
        if (dependentPluginId == null) {
            PluginManagerCore.$$$reportNull$$$0(20);
        }
        return dependentPluginId.getIdString().startsWith(MODULE_DEPENDENCY_PREFIX);
    }

    public static void checkDependants(@NotNull IdeaPluginDescriptor pluginDescriptor, @NotNull Function<PluginId, IdeaPluginDescriptor> pluginId2Descriptor, @NotNull Condition<PluginId> check) {
        if (pluginDescriptor == null) {
            PluginManagerCore.$$$reportNull$$$0(21);
        }
        if (pluginId2Descriptor == null) {
            PluginManagerCore.$$$reportNull$$$0(22);
        }
        if (check == null) {
            PluginManagerCore.$$$reportNull$$$0(23);
        }
        PluginManagerCore.checkDependants(pluginDescriptor, pluginId2Descriptor, check, (Set<PluginId>)new THashSet());
    }

    private static boolean checkDependants(@NotNull IdeaPluginDescriptor pluginDescriptor, @NotNull Function<PluginId, IdeaPluginDescriptor> pluginId2Descriptor, @NotNull Condition<PluginId> check, @NotNull Set<PluginId> processed2) {
        if (pluginDescriptor == null) {
            PluginManagerCore.$$$reportNull$$$0(24);
        }
        if (pluginId2Descriptor == null) {
            PluginManagerCore.$$$reportNull$$$0(25);
        }
        if (check == null) {
            PluginManagerCore.$$$reportNull$$$0(26);
        }
        if (processed2 == null) {
            PluginManagerCore.$$$reportNull$$$0(27);
        }
        processed2.add(pluginDescriptor.getPluginId());
        PluginId[] dependentPluginIds = pluginDescriptor.getDependentPluginIds();
        THashSet optionalDependencies = new THashSet(Arrays.asList(pluginDescriptor.getOptionalDependentPluginIds()));
        for (PluginId dependentPluginId : dependentPluginIds) {
            if (processed2.contains(dependentPluginId) || PluginManagerCore.isModuleDependency(dependentPluginId) && (ourModulesToContainingPlugins.isEmpty() || ourModulesToContainingPlugins.containsKey(dependentPluginId.getIdString())) || optionalDependencies.contains(dependentPluginId)) continue;
            if (!check.value((Object)dependentPluginId)) {
                return false;
            }
            IdeaPluginDescriptor dependantPluginDescriptor = (IdeaPluginDescriptor)pluginId2Descriptor.fun((Object)dependentPluginId);
            if (dependantPluginDescriptor == null || PluginManagerCore.checkDependants(dependantPluginDescriptor, pluginId2Descriptor, check, processed2)) continue;
            return false;
        }
        return true;
    }

    public static void addPluginClass(PluginId pluginId) {
        ourPluginClasses.addPluginClass(pluginId);
    }

    @Nullable
    public static PluginId getPluginByClassName(@NotNull String className) {
        if (className == null) {
            PluginManagerCore.$$$reportNull$$$0(28);
        }
        if (className.startsWith("java.") || className.startsWith("javax.") || className.startsWith("kotlin.") || className.startsWith("groovy.")) {
            return null;
        }
        for (IdeaPluginDescriptor descriptor : PluginManagerCore.getPlugins()) {
            if (!PluginManagerCore.hasLoadedClass(className, descriptor.getPluginClassLoader())) continue;
            PluginId id = descriptor.getPluginId();
            return CORE_PLUGIN_ID.equals(id.getIdString()) ? null : id;
        }
        return null;
    }

    private static boolean hasLoadedClass(@NotNull String className, ClassLoader loader) {
        if (className == null) {
            PluginManagerCore.$$$reportNull$$$0(29);
        }
        if (loader instanceof UrlClassLoader) {
            return ((UrlClassLoader)loader).hasLoadedClass(className);
        }
        try {
            return (Boolean)loader.getClass().getMethod("hasLoadedClass", String.class).invoke((Object)loader, className);
        }
        catch (Exception e) {
            return false;
        }
    }

    public static void dumpPluginClassStatistics() {
        ourPluginClasses.dumpPluginClassStatistics();
    }

    private static boolean isDependent(@NotNull IdeaPluginDescriptor descriptor, @NotNull PluginId on, @NotNull Map<PluginId, IdeaPluginDescriptor> map, boolean checkModuleDependencies) {
        if (descriptor == null) {
            PluginManagerCore.$$$reportNull$$$0(30);
        }
        if (on == null) {
            PluginManagerCore.$$$reportNull$$$0(31);
        }
        if (map == null) {
            PluginManagerCore.$$$reportNull$$$0(32);
        }
        for (PluginId id : descriptor.getDependentPluginIds()) {
            if (ArrayUtil.contains((Object)id, (Object[])descriptor.getOptionalDependentPluginIds()) || !checkModuleDependencies && PluginManagerCore.isModuleDependency(id)) continue;
            if (id.equals(on)) {
                return true;
            }
            IdeaPluginDescriptor depDescriptor = map.get(id);
            if (depDescriptor == null || !PluginManagerCore.isDependent(depDescriptor, on, map, checkModuleDependencies)) continue;
            return true;
        }
        return false;
    }

    private static boolean hasModuleDependencies(@NotNull IdeaPluginDescriptor descriptor) {
        PluginId[] dependentPluginIds;
        if (descriptor == null) {
            PluginManagerCore.$$$reportNull$$$0(33);
        }
        for (PluginId dependentPluginId : dependentPluginIds = descriptor.getDependentPluginIds()) {
            if (!PluginManagerCore.isModuleDependency(dependentPluginId)) continue;
            return true;
        }
        return false;
    }

    private static boolean shouldLoadPlugins() {
        try {
            Class.forName("com.intellij.openapi.extensions.Extensions");
        }
        catch (ClassNotFoundException e) {
            return false;
        }
        String loadPlugins = System.getProperty("idea.load.plugins");
        return loadPlugins == null || Boolean.TRUE.toString().equals(loadPlugins);
    }

    public static void configureExtensions() {
        Extensions.setLogProvider((LogProvider)new IdeaLogProvider());
        Extensions.registerAreaClass((String)"IDEA_PROJECT", null);
        Extensions.registerAreaClass((String)"IDEA_MODULE", (String)"IDEA_PROJECT");
    }

    private static Method getAddUrlMethod(@NotNull ClassLoader loader) {
        if (loader == null) {
            PluginManagerCore.$$$reportNull$$$0(34);
        }
        return ReflectionUtil.getDeclaredMethod(loader instanceof URLClassLoader ? URLClassLoader.class : loader.getClass(), (String)"addURL", (Class[])new Class[]{URL.class});
    }

    @Nullable
    private static ClassLoader createPluginClassLoader(@NotNull File[] classPath, @NotNull ClassLoader[] parentLoaders, @NotNull IdeaPluginDescriptor pluginDescriptor) {
        if (classPath == null) {
            PluginManagerCore.$$$reportNull$$$0(35);
        }
        if (parentLoaders == null) {
            PluginManagerCore.$$$reportNull$$$0(36);
        }
        if (pluginDescriptor == null) {
            PluginManagerCore.$$$reportNull$$$0(37);
        }
        if (pluginDescriptor.getUseIdeaClassLoader()) {
            try {
                ClassLoader loader = PluginManagerCore.class.getClassLoader();
                Method addUrlMethod = PluginManagerCore.getAddUrlMethod(loader);
                for (File aClassPath : classPath) {
                    File file2 = aClassPath.getCanonicalFile();
                    addUrlMethod.invoke((Object)loader, file2.toURI().toURL());
                }
                return loader;
            }
            catch (IOException | IllegalAccessException | InvocationTargetException e) {
                PluginManagerCore.getLogger().warn((Throwable)e);
            }
        }
        PluginId pluginId = pluginDescriptor.getPluginId();
        File pluginRoot = pluginDescriptor.getPath();
        if (PluginManagerCore.isUnitTestMode()) {
            return null;
        }
        try {
            ArrayList<URL> urls = new ArrayList<URL>(classPath.length);
            for (File aClassPath : classPath) {
                File file3 = aClassPath.getCanonicalFile();
                urls.add(file3.toURI().toURL());
            }
            return new PluginClassLoader(urls, parentLoaders, pluginId, pluginDescriptor.getVersion(), pluginRoot);
        }
        catch (IOException e) {
            PluginManagerCore.getLogger().warn((Throwable)e);
            return null;
        }
    }

    public static void invalidatePlugins() {
        ourPlugins = null;
        ourDisabledPlugins = null;
    }

    public static boolean isPluginClass(@NotNull String className) {
        if (className == null) {
            PluginManagerCore.$$$reportNull$$$0(38);
        }
        return ourPlugins != null && PluginManagerCore.getPluginByClassName(className) != null;
    }

    private static void logPlugins() {
        ArrayList<String> loadedBundled = new ArrayList<String>();
        ArrayList<String> disabled = new ArrayList<String>();
        ArrayList<String> loadedCustom = new ArrayList<String>();
        for (IdeaPluginDescriptor descriptor : ourPlugins) {
            String version = descriptor.getVersion();
            String s = descriptor.getName() + (version != null ? " (" + version + ")" : "");
            if (descriptor.isEnabled()) {
                if (descriptor.isBundled() || SPECIAL_IDEA_PLUGIN.equals(descriptor.getName())) {
                    loadedBundled.add(s);
                    continue;
                }
                loadedCustom.add(s);
                continue;
            }
            disabled.add(s);
        }
        Collections.sort(loadedBundled);
        Collections.sort(loadedCustom);
        Collections.sort(disabled);
        PluginManagerCore.getLogger().info("Loaded bundled plugins: " + StringUtil.join(loadedBundled, (String)", "));
        if (!loadedCustom.isEmpty()) {
            PluginManagerCore.getLogger().info("Loaded custom plugins: " + StringUtil.join(loadedCustom, (String)", "));
        }
        if (!disabled.isEmpty()) {
            PluginManagerCore.getLogger().info("Disabled plugins: " + StringUtil.join(disabled, (String)", "));
        }
    }

    @NotNull
    private static ClassLoader[] getParentLoaders(@NotNull Map<PluginId, ? extends IdeaPluginDescriptor> idToDescriptorMap, @NotNull PluginId[] pluginIds) {
        if (idToDescriptorMap == null) {
            PluginManagerCore.$$$reportNull$$$0(39);
        }
        if (pluginIds == null) {
            PluginManagerCore.$$$reportNull$$$0(40);
        }
        if (PluginManagerCore.isUnitTestMode()) {
            ClassLoader[] classLoaderArray = new ClassLoader[]{};
            if (classLoaderArray == null) {
                PluginManagerCore.$$$reportNull$$$0(41);
            }
            return classLoaderArray;
        }
        LinkedHashSet<ClassLoader> loaders = new LinkedHashSet<ClassLoader>(pluginIds.length);
        for (PluginId id : pluginIds) {
            IdeaPluginDescriptor pluginDescriptor = idToDescriptorMap.get(id);
            if (pluginDescriptor == null) continue;
            ClassLoader loader = pluginDescriptor.getPluginClassLoader();
            if (loader == null) {
                PluginManagerCore.getLogger().error("Plugin class loader should be initialized for plugin " + id);
            }
            loaders.add(loader);
        }
        ClassLoader[] classLoaderArray = loaders.toArray(new ClassLoader[loaders.size()]);
        if (classLoaderArray == null) {
            PluginManagerCore.$$$reportNull$$$0(42);
        }
        return classLoaderArray;
    }

    public static boolean isRunningFromSources() {
        return Holder.ourIsRunningFromSources;
    }

    private static int countPlugins(@NotNull String pluginsPath) {
        String[] list2;
        File configuredPluginsDir;
        if (pluginsPath == null) {
            PluginManagerCore.$$$reportNull$$$0(43);
        }
        if ((configuredPluginsDir = new File(pluginsPath)).exists() && (list2 = configuredPluginsDir.list()) != null) {
            return list2.length;
        }
        return 0;
    }

    private static void prepareLoadingPluginsErrorMessage(@NotNull List<String> errors) {
        if (errors == null) {
            PluginManagerCore.$$$reportNull$$$0(44);
        }
        if (!errors.isEmpty()) {
            String errorMessage = IdeBundle.message((String)"error.problems.found.loading.plugins", (Object[])new Object[0]) + StringUtil.join(errors, (String)"<p/>");
            Application app = ApplicationManager.getApplication();
            if (app != null && !app.isHeadlessEnvironment() && !app.isUnitTestMode()) {
                myPluginError = myPluginError == null ? errorMessage : myPluginError + "\n" + errorMessage;
            } else {
                PluginManagerCore.getLogger().error(errorMessage);
            }
        }
    }

    private static void addModulesAsDependents(@NotNull Map<PluginId, ? super IdeaPluginDescriptorImpl> map) {
        if (map == null) {
            PluginManagerCore.$$$reportNull$$$0(45);
        }
        for (Map.Entry<String, IdeaPluginDescriptorImpl> entry : ourModulesToContainingPlugins.entrySet()) {
            map.put(PluginId.getId((String)entry.getKey()), entry.getValue());
        }
    }

    @NotNull
    private static Comparator<IdeaPluginDescriptor> getPluginDescriptorComparator(@NotNull Map<PluginId, ? extends IdeaPluginDescriptor> idToDescriptorMap, @NotNull List<String> errors) {
        Graph<PluginId> graph;
        DFSTBuilder builder;
        if (idToDescriptorMap == null) {
            PluginManagerCore.$$$reportNull$$$0(46);
        }
        if (errors == null) {
            PluginManagerCore.$$$reportNull$$$0(47);
        }
        if (!(builder = new DFSTBuilder(graph = PluginManagerCore.createPluginIdGraph(idToDescriptorMap))).isAcyclic()) {
            String cyclePresentation;
            if (ApplicationManager.getApplication().isInternal()) {
                StringBuilder cycles = new StringBuilder();
                for (Collection component : builder.getComponents()) {
                    if (cycles.length() > 0) {
                        cycles.append(';');
                    }
                    for (PluginId id : component) {
                        idToDescriptorMap.get(id).setEnabled(false);
                        cycles.append(id.getIdString()).append(' ');
                    }
                }
                cyclePresentation = cycles.toString();
            } else {
                Couple circularDependency = builder.getCircularDependency();
                PluginId id = (PluginId)circularDependency.getFirst();
                PluginId parentId = (PluginId)circularDependency.getSecond();
                cyclePresentation = id + "->" + parentId + "->...->" + id;
            }
            errors.add(IdeBundle.message((String)"error.plugins.should.not.have.cyclic.dependencies", (Object[])new Object[0]) + " " + cyclePresentation);
        }
        Comparator idComparator = builder.comparator();
        Comparator comparator2 = (o1, o2) -> {
            PluginId pluginId1 = o1.getPluginId();
            PluginId pluginId2 = o2.getPluginId();
            if (pluginId1.getIdString().equals(CORE_PLUGIN_ID)) {
                return -1;
            }
            if (pluginId2.getIdString().equals(CORE_PLUGIN_ID)) {
                return 1;
            }
            return idComparator.compare(pluginId1, pluginId2);
        };
        if (comparator2 == null) {
            PluginManagerCore.$$$reportNull$$$0(48);
        }
        return comparator2;
    }

    @NotNull
    private static Graph<PluginId> createPluginIdGraph(final @NotNull Map<PluginId, ? extends IdeaPluginDescriptor> idToDescriptorMap) {
        if (idToDescriptorMap == null) {
            PluginManagerCore.$$$reportNull$$$0(49);
        }
        final ArrayList<PluginId> ids = new ArrayList<PluginId>(idToDescriptorMap.keySet());
        ids.sort((o1, o2) -> o2.getIdString().compareTo(o1.getIdString()));
        Graph graph = GraphGenerator.generate((InboundSemiGraph)CachingSemiGraph.cache((InboundSemiGraph)new InboundSemiGraph<PluginId>(){

            public Collection<PluginId> getNodes() {
                return ids;
            }

            public Iterator<PluginId> getIn(PluginId pluginId) {
                IdeaPluginDescriptor descriptor = (IdeaPluginDescriptor)idToDescriptorMap.get(pluginId);
                ArrayList<PluginId> plugins2 = new ArrayList<PluginId>();
                for (PluginId dependentPluginId : descriptor.getDependentPluginIds()) {
                    PluginId realPluginId;
                    IdeaPluginDescriptor dep = (IdeaPluginDescriptor)idToDescriptorMap.get(dependentPluginId);
                    if (dep == null || !idToDescriptorMap.containsKey(realPluginId = dep.getPluginId())) continue;
                    plugins2.add(realPluginId);
                }
                return plugins2.iterator();
            }
        }));
        if (graph == null) {
            PluginManagerCore.$$$reportNull$$$0(50);
        }
        return graph;
    }

    @Nullable
    private static IdeaPluginDescriptorImpl loadDescriptorFromDir(@NotNull File file2, @NotNull String pathName) {
        File descriptorFile;
        if (file2 == null) {
            PluginManagerCore.$$$reportNull$$$0(51);
        }
        if (pathName == null) {
            PluginManagerCore.$$$reportNull$$$0(52);
        }
        if ((descriptorFile = new File(file2, "META-INF/" + pathName)).exists()) {
            try {
                IdeaPluginDescriptorImpl descriptor = new IdeaPluginDescriptorImpl(file2);
                descriptor.readExternal(descriptorFile.toURI().toURL());
                return descriptor;
            }
            catch (XmlSerializationException e) {
                PluginManagerCore.getLogger().info("Cannot load " + file2, (Throwable)e);
                PluginManagerCore.prepareLoadingPluginsErrorMessage(Collections.singletonList("File '" + file2.getName() + "' contains invalid plugin descriptor."));
            }
            catch (Throwable e) {
                PluginManagerCore.getLogger().info("Cannot load " + file2, e);
            }
        }
        return null;
    }

    private static IdeaPluginDescriptorImpl loadDescriptorFromJar(@NotNull File file2, @NotNull String pathName, @NotNull JDOMXIncluder.PathResolver pathResolver) {
        if (file2 == null) {
            PluginManagerCore.$$$reportNull$$$0(53);
        }
        if (pathName == null) {
            PluginManagerCore.$$$reportNull$$$0(54);
        }
        if (pathResolver == null) {
            PluginManagerCore.$$$reportNull$$$0(55);
        }
        try (LoadingContext context = new LoadingContext();){
            IdeaPluginDescriptorImpl ideaPluginDescriptorImpl = PluginManagerCore.loadDescriptorFromJar(file2, pathName, pathResolver, context);
            return ideaPluginDescriptorImpl;
        }
    }

    @Nullable
    private static IdeaPluginDescriptorImpl loadDescriptorFromJar(@NotNull File file2, @NotNull String fileName, @NotNull JDOMXIncluder.PathResolver pathResolver, @NotNull LoadingContext context) {
        if (file2 == null) {
            PluginManagerCore.$$$reportNull$$$0(56);
        }
        if (fileName == null) {
            PluginManagerCore.$$$reportNull$$$0(57);
        }
        if (pathResolver == null) {
            PluginManagerCore.$$$reportNull$$$0(58);
        }
        if (context == null) {
            PluginManagerCore.$$$reportNull$$$0(59);
        }
        try {
            ZipEntry entry;
            URL jarURL = URLUtil.getJarEntryURL((File)file2, (String)FileUtil.toCanonicalPath((String)("META-INF/" + fileName), (char)'/'));
            ZipFile zipFile = context.myOpenedFiles.get(file2);
            if (zipFile == null) {
                zipFile = new ZipFile(file2);
                context.myOpenedFiles.put(file2, zipFile);
            }
            if ((entry = zipFile.getEntry("META-INF/" + fileName)) != null) {
                Document document = JDOMUtil.loadDocument((InputStream)zipFile.getInputStream(entry));
                IdeaPluginDescriptorImpl descriptor = new IdeaPluginDescriptorImpl(file2);
                descriptor.readExternal(document, jarURL, pathResolver);
                context.myLastZipFileContainingDescriptor = file2;
                return descriptor;
            }
        }
        catch (XmlSerializationException e) {
            PluginManagerCore.getLogger().info("Cannot load " + file2, (Throwable)e);
            PluginManagerCore.prepareLoadingPluginsErrorMessage(Collections.singletonList("File '" + file2.getName() + "' contains invalid plugin descriptor."));
        }
        catch (Throwable e) {
            PluginManagerCore.getLogger().info("Cannot load " + file2, e);
        }
        return null;
    }

    @Nullable
    public static IdeaPluginDescriptorImpl loadDescriptor(@NotNull File file2, @NotNull String fileName) {
        if (file2 == null) {
            PluginManagerCore.$$$reportNull$$$0(60);
        }
        if (fileName == null) {
            PluginManagerCore.$$$reportNull$$$0(61);
        }
        try (LoadingContext context = new LoadingContext();){
            IdeaPluginDescriptorImpl ideaPluginDescriptorImpl = PluginManagerCore.loadDescriptor(file2, fileName, context);
            return ideaPluginDescriptorImpl;
        }
    }

    @Nullable
    private static IdeaPluginDescriptorImpl loadDescriptor(@NotNull File file2, @NotNull String pathName, @NotNull LoadingContext context) {
        if (file2 == null) {
            PluginManagerCore.$$$reportNull$$$0(62);
        }
        if (pathName == null) {
            PluginManagerCore.$$$reportNull$$$0(63);
        }
        if (context == null) {
            PluginManagerCore.$$$reportNull$$$0(64);
        }
        IdeaPluginDescriptorImpl descriptor = null;
        boolean directory = file2.isDirectory();
        if (directory) {
            descriptor = PluginManagerCore.loadDescriptorFromDir(file2, pathName);
            if (descriptor == null) {
                File libDir = new File(file2, "lib");
                if (!libDir.isDirectory()) {
                    return null;
                }
                File[] files = libDir.listFiles();
                if (files == null || files.length == 0) {
                    return null;
                }
                PluginManagerCore.putMoreLikelyPluginJarsFirst(file2, files);
                PluginXmlPathResolver pathResolver = new PluginXmlPathResolver(files);
                for (File f : files) {
                    IdeaPluginDescriptorImpl descriptor1;
                    if (FileUtil.isJarOrZip((File)f)) {
                        descriptor = PluginManagerCore.loadDescriptorFromJar(f, pathName, pathResolver, context);
                        if (descriptor == null) continue;
                        descriptor.setPath(file2);
                        break;
                    }
                    if (!f.isDirectory() || (descriptor1 = PluginManagerCore.loadDescriptorFromDir(f, pathName)) == null) continue;
                    if (descriptor != null) {
                        PluginManagerCore.getLogger().info("Cannot load " + file2 + " because two or more plugin.xml's detected");
                        return null;
                    }
                    descriptor = descriptor1;
                    descriptor.setPath(file2);
                }
            }
        } else if (StringUtil.endsWithIgnoreCase((String)file2.getName(), (String)".jar") && file2.exists()) {
            descriptor = PluginManagerCore.loadDescriptorFromJar(file2, pathName, JDOMXIncluder.DEFAULT_PATH_RESOLVER, context);
        }
        if (descriptor != null) {
            PluginManagerCore.resolveOptionalDescriptors(pathName, descriptor, (Function<String, IdeaPluginDescriptorImpl>)((Function)optPathName -> {
                URL resource;
                if (context == null) {
                    PluginManagerCore.$$$reportNull$$$0(115);
                }
                if (file2 == null) {
                    PluginManagerCore.$$$reportNull$$$0(116);
                }
                IdeaPluginDescriptorImpl optionalDescriptor = null;
                if (context.myLastZipFileContainingDescriptor != null) {
                    optionalDescriptor = PluginManagerCore.loadDescriptor(context.myLastZipFileContainingDescriptor, optPathName, context);
                }
                if (optionalDescriptor == null) {
                    optionalDescriptor = PluginManagerCore.loadDescriptor(file2, optPathName, context);
                }
                if (optionalDescriptor == null && directory && (resource = PluginManagerCore.class.getClassLoader().getResource("META-INF/" + optPathName)) != null) {
                    optionalDescriptor = PluginManagerCore.loadDescriptorFromResource(resource, optPathName);
                }
                return optionalDescriptor;
            }));
        }
        return descriptor;
    }

    private static void putMoreLikelyPluginJarsFirst(File pluginDir, File[] filesInLibUnderPluginDir) {
        String pluginDirName = pluginDir.getName();
        Arrays.sort(filesInLibUnderPluginDir, (o1, o2) -> {
            boolean o1StartsWithNeededName;
            boolean o1IsVersioned;
            boolean o1StartsWithResources;
            String o2Name = o2.getName();
            String o1Name = o1.getName();
            boolean o2StartsWithResources = o2Name.startsWith("resources");
            if (o2StartsWithResources != (o1StartsWithResources = o1Name.startsWith("resources"))) {
                return o2StartsWithResources ? -1 : 1;
            }
            boolean o2IsVersioned = PluginManagerCore.fileNameIsLikeVersionedLibraryName(o2Name);
            if (o2IsVersioned != (o1IsVersioned = PluginManagerCore.fileNameIsLikeVersionedLibraryName(o1Name))) {
                return o2IsVersioned ? -1 : 1;
            }
            boolean o2StartsWithNeededName = StringUtil.startsWithIgnoreCase((String)o2Name, (String)pluginDirName);
            if (o2StartsWithNeededName != (o1StartsWithNeededName = StringUtil.startsWithIgnoreCase((String)o1Name, (String)pluginDirName))) {
                return o2StartsWithNeededName ? 1 : -1;
            }
            return o1Name.length() - o2Name.length();
        });
    }

    private static boolean fileNameIsLikeVersionedLibraryName(String name) {
        int i = name.lastIndexOf(45);
        if (i == -1) {
            return false;
        }
        if (i + 1 < name.length()) {
            char c = name.charAt(i + 1);
            if (Character.isDigit(c)) {
                return true;
            }
            if ((c == 'm' || c == 'M') && i + 2 < name.length() && Character.isDigit(name.charAt(i + 2))) {
                return true;
            }
        }
        return false;
    }

    public static void resolveOptionalDescriptors(@NotNull String fileName, @NotNull IdeaPluginDescriptorImpl descriptor, @NotNull Function<String, IdeaPluginDescriptorImpl> optionalDescriptorLoader) {
        Map<PluginId, List<String>> optionalConfigs;
        if (fileName == null) {
            PluginManagerCore.$$$reportNull$$$0(65);
        }
        if (descriptor == null) {
            PluginManagerCore.$$$reportNull$$$0(66);
        }
        if (optionalDescriptorLoader == null) {
            PluginManagerCore.$$$reportNull$$$0(67);
        }
        if ((optionalConfigs = descriptor.getOptionalConfigs()) != null && !optionalConfigs.isEmpty()) {
            THashMap descriptors = new THashMap(optionalConfigs.size());
            for (Map.Entry<PluginId, List<String>> entry : optionalConfigs.entrySet()) {
                for (String optionalDescriptorName : entry.getValue()) {
                    if (fileName.equals(optionalDescriptorName)) {
                        PluginManagerCore.getLogger().info("recursive dependency (" + fileName + ") in " + descriptor);
                        continue;
                    }
                    IdeaPluginDescriptorImpl optionalDescriptor = (IdeaPluginDescriptorImpl)optionalDescriptorLoader.fun((Object)optionalDescriptorName);
                    if (optionalDescriptor == null) {
                        PluginManagerCore.getLogger().info("Cannot find optional descriptor " + optionalDescriptorName);
                        continue;
                    }
                    descriptors.computeIfAbsent(entry.getKey(), it -> new SmartList()).add(optionalDescriptor);
                }
            }
            descriptor.setOptionalDescriptors((Map<PluginId, List<IdeaPluginDescriptorImpl>>)descriptors);
        }
    }

    public static void loadDescriptors(@NotNull File pluginsHome, @NotNull List<IdeaPluginDescriptorImpl> result2, @Nullable StartupProgress progress, int pluginsCount) {
        File[] files;
        if (pluginsHome == null) {
            PluginManagerCore.$$$reportNull$$$0(68);
        }
        if (result2 == null) {
            PluginManagerCore.$$$reportNull$$$0(69);
        }
        if ((files = pluginsHome.listFiles()) != null) {
            int i = result2.size();
            HashSet existingResults = ContainerUtil.newHashSet(result2);
            for (File file2 : files) {
                int oldIndex;
                IdeaPluginDescriptorImpl descriptor = PluginManagerCore.loadDescriptor(file2, PLUGIN_XML);
                if (descriptor == null) continue;
                if (descriptor.getName() == null) {
                    PluginManagerCore.getLogger().warn("Skipped plugin without name: " + descriptor);
                }
                if (progress != null) {
                    progress.showProgress(descriptor.getName(), 0.3f * ((float)(++i) / (float)pluginsCount));
                }
                int n = oldIndex = !existingResults.add(descriptor) ? result2.indexOf(descriptor) : -1;
                if (oldIndex >= 0) {
                    IdeaPluginDescriptorImpl oldDescriptor = result2.get(oldIndex);
                    if (StringUtil.compareVersionNumbers((String)oldDescriptor.getVersion(), (String)descriptor.getVersion()) >= 0) continue;
                    result2.set(oldIndex, descriptor);
                    continue;
                }
                result2.add(descriptor);
            }
        }
    }

    private static void filterBadPlugins(@NotNull List<? extends IdeaPluginDescriptor> result2, @NotNull Map<String, String> disabledPluginNames, @NotNull List<String> errors) {
        if (result2 == null) {
            PluginManagerCore.$$$reportNull$$$0(70);
        }
        if (disabledPluginNames == null) {
            PluginManagerCore.$$$reportNull$$$0(71);
        }
        if (errors == null) {
            PluginManagerCore.$$$reportNull$$$0(72);
        }
        THashMap idToDescriptorMap = new THashMap();
        boolean pluginsWithoutIdFound = false;
        Iterator<? extends IdeaPluginDescriptor> it = result2.iterator();
        while (it.hasNext()) {
            IdeaPluginDescriptor descriptor = it.next();
            PluginId id = descriptor.getPluginId();
            if (id == null) {
                pluginsWithoutIdFound = true;
                continue;
            }
            if (idToDescriptorMap.containsKey(id)) {
                errors.add(IdeBundle.message((String)"message.duplicate.plugin.id", (Object[])new Object[0]) + id);
                it.remove();
                continue;
            }
            if (!descriptor.isEnabled()) continue;
            idToDescriptorMap.put(id, descriptor);
        }
        PluginManagerCore.addModulesAsDependents((Map<PluginId, ? super IdeaPluginDescriptorImpl>)idToDescriptorMap);
        SmartList disabledPluginIds = new SmartList();
        LinkedHashSet faultyDescriptors = new LinkedHashSet();
        Iterator<? extends IdeaPluginDescriptor> it2 = result2.iterator();
        while (it2.hasNext()) {
            IdeaPluginDescriptor pluginDescriptor = it2.next();
            PluginManagerCore.checkDependants(pluginDescriptor, (Function<PluginId, IdeaPluginDescriptor>)((Function)((Map)idToDescriptorMap)::get), (Condition<PluginId>)((Condition)arg_0 -> PluginManagerCore.lambda$filterBadPlugins$5((Map)idToDescriptorMap, pluginDescriptor, faultyDescriptors, (List)disabledPluginIds, disabledPluginNames, errors, it2, arg_0)));
        }
        if (!disabledPluginIds.isEmpty()) {
            myPlugins2Disable = disabledPluginIds;
            myPlugins2Enable = faultyDescriptors;
            String error = "<br><a href=\"disable\">Disable ";
            if (disabledPluginIds.size() == 1) {
                PluginId pluginId2Disable = PluginId.getId((String)((String)disabledPluginIds.iterator().next()));
                error = error + (idToDescriptorMap.containsKey(pluginId2Disable) ? ((IdeaPluginDescriptor)idToDescriptorMap.get(pluginId2Disable)).getName() : pluginId2Disable.getIdString());
            } else {
                error = error + "not loaded plugins";
            }
            errors.add(error + "</a>");
            boolean possibleToEnable = true;
            for (String descriptor : faultyDescriptors) {
                if (disabledPluginNames.get(descriptor) != null) continue;
                possibleToEnable = false;
                break;
            }
            if (possibleToEnable) {
                errors.add("<a href=\"enable\">Enable " + (faultyDescriptors.size() == 1 ? disabledPluginNames.get(faultyDescriptors.iterator().next()) : " all necessary plugins") + "</a>");
            }
            errors.add("<a href=\"edit\">Open plugin manager</a>");
        }
        if (pluginsWithoutIdFound) {
            errors.add(IdeBundle.message((String)"error.plugins.without.id.found", (Object[])new Object[0]));
        }
    }

    public static List<? extends IdeaPluginDescriptor> testLoadDescriptorsFromClassPath(@NotNull ClassLoader loader) {
        if (loader == null) {
            PluginManagerCore.$$$reportNull$$$0(73);
        }
        List descriptors = ContainerUtil.newSmartList();
        PluginManagerCore.loadDescriptorsFromClassPath(descriptors, loader, null);
        return descriptors;
    }

    private static void loadDescriptorsFromClassPath(List<IdeaPluginDescriptorImpl> result2, ClassLoader loader, StartupProgress progress) {
        LinkedHashMap urls = ContainerUtil.newLinkedHashMap();
        String platformPrefix = System.getProperty("idea.platform.prefix");
        if (platformPrefix != null) {
            String fileName = platformPrefix + "Plugin.xml";
            URL resource = loader.getResource("META-INF/" + fileName);
            if (resource != null) {
                urls.put(resource, fileName);
            }
        }
        try {
            Enumeration<URL> enumeration = loader.getResources("META-INF/plugin.xml");
            while (enumeration.hasMoreElements()) {
                urls.put(enumeration.nextElement(), PLUGIN_XML);
            }
        }
        catch (IOException e) {
            PluginManagerCore.getLogger().info((Throwable)e);
            return;
        }
        HashSet existingResults = ContainerUtil.newHashSet(result2);
        int i = 0;
        for (URL url : urls.keySet()) {
            IdeaPluginDescriptorImpl descriptor = PluginManagerCore.loadDescriptorFromResource(url, (String)urls.get(url));
            if (descriptor == null || !existingResults.add(descriptor)) continue;
            descriptor.setUseCoreClassLoader(true);
            result2.add(descriptor);
            if (progress == null || SPECIAL_IDEA_PLUGIN.equals(descriptor.getName())) continue;
            progress.showProgress("Plugin loaded: " + descriptor.getName(), 0.3f * (float)(++i) / (float)urls.size());
        }
    }

    @Nullable
    private static IdeaPluginDescriptorImpl loadDescriptorFromResource(@NotNull URL resource, @NotNull String pathName) {
        if (resource == null) {
            PluginManagerCore.$$$reportNull$$$0(74);
        }
        if (pathName == null) {
            PluginManagerCore.$$$reportNull$$$0(75);
        }
        try {
            if ("file".equals(resource.getProtocol())) {
                File descriptorFile = PluginManagerCore.urlToFile(resource);
                String pathname = StringUtil.trimEnd((String)FileUtil.toSystemIndependentName((String)descriptorFile.getPath()), (String)pathName);
                File pluginDir = new File(pathname).getParentFile();
                return PluginManagerCore.loadDescriptor(pluginDir, pathName);
            }
            if ("jar".equals(resource.getProtocol())) {
                String path = resource.getFile();
                File pluginJar = PluginManagerCore.urlToFile(new URL(path.substring(0, path.indexOf("!/"))));
                return PluginManagerCore.loadDescriptor(pluginJar, pathName);
            }
        }
        catch (Throwable e) {
            PluginManagerCore.getLogger().info("Cannot load " + resource, e);
        }
        return null;
    }

    private static File urlToFile(URL url) throws URISyntaxException, MalformedURLException {
        try {
            return new File(url.toURI());
        }
        catch (URISyntaxException e) {
            String str = url.toString();
            if (str.indexOf(32) > 0) {
                return new File(new URL(StringUtil.replace((String)str, (String)" ", (String)"%20")).toURI());
            }
            throw e;
        }
    }

    private static void loadDescriptorsFromProperty(@NotNull List<IdeaPluginDescriptorImpl> result2) {
        String pathProperty;
        if (result2 == null) {
            PluginManagerCore.$$$reportNull$$$0(76);
        }
        if ((pathProperty = System.getProperty(PROPERTY_PLUGIN_PATH)) == null) {
            return;
        }
        StringTokenizer t = new StringTokenizer(pathProperty, File.pathSeparator + ",");
        while (t.hasMoreTokens()) {
            String s = t.nextToken();
            IdeaPluginDescriptorImpl ideaPluginDescriptor = PluginManagerCore.loadDescriptor(new File(s), PLUGIN_XML);
            if (ideaPluginDescriptor == null) continue;
            result2.add(ideaPluginDescriptor);
        }
    }

    @NotNull
    public static IdeaPluginDescriptorImpl[] loadDescriptors(@Nullable StartupProgress progress, @NotNull List<String> errors) {
        if (errors == null) {
            PluginManagerCore.$$$reportNull$$$0(77);
        }
        if (ClassUtilCore.isLoadingOfExternalPluginsDisabled()) {
            if (IdeaPluginDescriptorImpl.EMPTY_ARRAY == null) {
                PluginManagerCore.$$$reportNull$$$0(78);
            }
            return IdeaPluginDescriptorImpl.EMPTY_ARRAY;
        }
        ArrayList<IdeaPluginDescriptorImpl> result2 = new ArrayList<IdeaPluginDescriptorImpl>();
        int pluginsCount = PluginManagerCore.countPlugins(PathManager.getPluginsPath()) + PluginManagerCore.countPlugins(PathManager.getPreInstalledPluginsPath());
        PluginManagerCore.loadDescriptors(new File(PathManager.getPluginsPath()), result2, progress, pluginsCount);
        Application application = ApplicationManager.getApplication();
        boolean fromSources = false;
        if (application == null || !application.isUnitTestMode()) {
            int size = result2.size();
            PluginManagerCore.loadDescriptors(new File(PathManager.getPreInstalledPluginsPath()), result2, progress, pluginsCount);
            fromSources = size == result2.size();
        }
        PluginManagerCore.loadDescriptorsFromProperty(result2);
        PluginManagerCore.loadDescriptorsFromClassPath(result2, PluginManagerCore.class.getClassLoader(), (StartupProgress)(fromSources ? progress : null));
        IdeaPluginDescriptorImpl[] ideaPluginDescriptorImplArray = PluginManagerCore.topoSortPlugins(result2, errors);
        if (ideaPluginDescriptorImplArray == null) {
            PluginManagerCore.$$$reportNull$$$0(79);
        }
        return ideaPluginDescriptorImplArray;
    }

    @NotNull
    public static IdeaPluginDescriptorImpl[] topoSortPlugins(@NotNull List<IdeaPluginDescriptorImpl> result2, @NotNull List<String> errors) {
        if (result2 == null) {
            PluginManagerCore.$$$reportNull$$$0(80);
        }
        if (errors == null) {
            PluginManagerCore.$$$reportNull$$$0(81);
        }
        IdeaPluginDescriptorImpl[] pluginDescriptors = result2.toArray(new IdeaPluginDescriptorImpl[result2.size()]);
        THashMap idToDescriptorMap = new THashMap();
        for (IdeaPluginDescriptorImpl descriptor : pluginDescriptors) {
            PluginId id = descriptor.getPluginId();
            if (id == null) {
                LOG.error("null 'id': " + descriptor);
            }
            idToDescriptorMap.put(id, descriptor);
        }
        Arrays.sort(pluginDescriptors, PluginManagerCore.getPluginDescriptorComparator((Map<PluginId, ? extends IdeaPluginDescriptor>)idToDescriptorMap, errors));
        if (pluginDescriptors == null) {
            PluginManagerCore.$$$reportNull$$$0(82);
        }
        return pluginDescriptors;
    }

    private static void mergeOptionalConfigs(@NotNull Map<PluginId, IdeaPluginDescriptorImpl> descriptors) {
        if (descriptors == null) {
            PluginManagerCore.$$$reportNull$$$0(83);
        }
        THashMap descriptorsWithModules = new THashMap(descriptors);
        PluginManagerCore.addModulesAsDependents((Map<PluginId, ? super IdeaPluginDescriptorImpl>)descriptorsWithModules);
        for (IdeaPluginDescriptorImpl descriptor : descriptors.values()) {
            Map<PluginId, List<IdeaPluginDescriptorImpl>> optionalDescriptors = descriptor.getOptionalDescriptors();
            if (optionalDescriptors == null || optionalDescriptors.isEmpty()) continue;
            for (Map.Entry<PluginId, List<IdeaPluginDescriptorImpl>> entry : optionalDescriptors.entrySet()) {
                if (!descriptorsWithModules.containsKey(entry.getKey())) continue;
                for (IdeaPluginDescriptorImpl optionalDescriptor : entry.getValue()) {
                    descriptor.mergeOptionalConfig(optionalDescriptor);
                }
            }
        }
    }

    public static void initClassLoader(@NotNull ClassLoader parentLoader, @NotNull IdeaPluginDescriptorImpl descriptor) {
        if (parentLoader == null) {
            PluginManagerCore.$$$reportNull$$$0(84);
        }
        if (descriptor == null) {
            PluginManagerCore.$$$reportNull$$$0(85);
        }
        List<File> classPath = descriptor.getClassPath();
        ClassLoader loader = PluginManagerCore.createPluginClassLoader(classPath.toArray(new File[classPath.size()]), new ClassLoader[]{parentLoader}, descriptor);
        descriptor.setLoader(loader);
    }

    static BuildNumber getBuildNumber() {
        return Holder.ourBuildNumber;
    }

    @Nullable
    private static String detectReasonToNotLoad(@NotNull IdeaPluginDescriptor descriptor, @NotNull IdeaPluginDescriptor[] loaded) {
        String reasonToNotLoad;
        boolean checkModuleDependencies;
        String idString;
        if (descriptor == null) {
            PluginManagerCore.$$$reportNull$$$0(86);
        }
        if (loaded == null) {
            PluginManagerCore.$$$reportNull$$$0(87);
        }
        if (CORE_PLUGIN_ID.equals(idString = descriptor.getPluginId().getIdString())) {
            return null;
        }
        String pluginId = System.getProperty("idea.load.plugins.id");
        if (pluginId == null) {
            if (descriptor instanceof IdeaPluginDescriptorImpl && !descriptor.isEnabled()) {
                return "Plugin is not enabled";
            }
            if (!PluginManagerCore.shouldLoadPlugins()) {
                return "Plugins should not be loaded";
            }
        }
        List pluginIds = pluginId == null ? null : StringUtil.split((String)pluginId, (String)",");
        boolean bl = checkModuleDependencies = !ourModulesToContainingPlugins.isEmpty() && !ourModulesToContainingPlugins.containsKey("com.intellij.modules.all");
        if (checkModuleDependencies && !PluginManagerCore.hasModuleDependencies(descriptor)) {
            return "Plugin does not include any module dependency tags in its plugin.xml therefore is assumed legacy and can be loaded only in IntelliJ IDEA";
        }
        String loadPluginCategory = System.getProperty("idea.load.plugins.category");
        if (loadPluginCategory != null) {
            reasonToNotLoad = loadPluginCategory.equals(descriptor.getCategory()) ? null : "Plugin category doesn't match 'idea.load.plugins.category' value";
        } else {
            if (pluginIds != null) {
                String string = reasonToNotLoad = pluginIds.contains(idString) ? null : "'idea.load.plugins.id' doesn't contain this plugin id";
                if (reasonToNotLoad != null) {
                    THashMap map = new THashMap();
                    for (IdeaPluginDescriptor pluginDescriptor : loaded) {
                        map.put(pluginDescriptor.getPluginId(), pluginDescriptor);
                    }
                    PluginManagerCore.addModulesAsDependents((Map<PluginId, ? super IdeaPluginDescriptorImpl>)map);
                    for (String id : pluginIds) {
                        IdeaPluginDescriptor descriptorFromProperty = (IdeaPluginDescriptor)map.get(PluginId.getId((String)id));
                        if (descriptorFromProperty == null || !PluginManagerCore.isDependent(descriptorFromProperty, descriptor.getPluginId(), (Map<PluginId, IdeaPluginDescriptor>)map, checkModuleDependencies)) continue;
                        reasonToNotLoad = null;
                        break;
                    }
                }
            } else {
                String string = reasonToNotLoad = PluginManagerCore.getDisabledPlugins().contains(idString) ? "Plugin is disabled" : null;
            }
            if (reasonToNotLoad == null && descriptor instanceof IdeaPluginDescriptorImpl && PluginManagerCore.isIncompatible(descriptor)) {
                return "Plugin since-build or until-build don't match this product's build number";
            }
        }
        return reasonToNotLoad;
    }

    public static boolean isCompatible(@NotNull IdeaPluginDescriptor descriptor) {
        if (descriptor == null) {
            PluginManagerCore.$$$reportNull$$$0(88);
        }
        return !PluginManagerCore.isIncompatible(descriptor);
    }

    public static boolean isCompatible(@NotNull IdeaPluginDescriptor descriptor, @Nullable BuildNumber buildNumber) {
        if (descriptor == null) {
            PluginManagerCore.$$$reportNull$$$0(89);
        }
        return !PluginManagerCore.isIncompatible(descriptor, buildNumber);
    }

    public static boolean isIncompatible(@NotNull IdeaPluginDescriptor descriptor) {
        if (descriptor == null) {
            PluginManagerCore.$$$reportNull$$$0(90);
        }
        return PluginManagerCore.isIncompatible(descriptor, PluginManagerCore.getBuildNumber());
    }

    public static boolean isIncompatible(@NotNull IdeaPluginDescriptor descriptor, @Nullable BuildNumber buildNumber) {
        if (descriptor == null) {
            PluginManagerCore.$$$reportNull$$$0(91);
        }
        if (buildNumber == null) {
            buildNumber = PluginManagerCore.getBuildNumber();
        }
        try {
            return PluginManagerCore.isIncompatible(buildNumber, descriptor.getSinceBuild(), descriptor.getUntilBuild(), descriptor.getName(), descriptor.toString());
        }
        catch (RuntimeException e) {
            LOG.error((Throwable)e);
            return false;
        }
    }

    public static boolean isIncompatible(@NotNull BuildNumber buildNumber, @Nullable String sinceBuild, @Nullable String untilBuild, @Nullable String descriptorName, @Nullable String descriptorDebugString) {
        BuildNumber untilBuildNumber;
        BuildNumber sinceBuildNumber;
        if (buildNumber == null) {
            PluginManagerCore.$$$reportNull$$$0(92);
        }
        JBIterable messages = JBIterable.empty();
        BuildNumber buildNumber2 = sinceBuildNumber = StringUtil.isEmpty((String)sinceBuild) ? null : BuildNumber.fromString((String)sinceBuild, (String)descriptorName, null);
        if (sinceBuildNumber != null && sinceBuildNumber.compareTo(buildNumber) > 0) {
            messages = messages.append((Object)("since build " + sinceBuildNumber + " > " + buildNumber));
        }
        BuildNumber buildNumber3 = untilBuildNumber = StringUtil.isEmpty((String)untilBuild) ? null : BuildNumber.fromString((String)untilBuild, (String)descriptorName, null);
        if (untilBuildNumber != null && untilBuildNumber.compareTo(buildNumber) < 0) {
            messages = messages.append((Object)("until build " + untilBuildNumber + " < " + buildNumber));
        }
        if (messages.isNotEmpty()) {
            LOG.warn((String)ObjectUtils.coalesce((Object)descriptorName, (Object)descriptorDebugString) + " not loaded: " + StringUtil.join((Iterable)messages, (String)", "));
            return true;
        }
        return false;
    }

    public static boolean shouldSkipPlugin(@NotNull IdeaPluginDescriptor descriptor) {
        if (descriptor == null) {
            PluginManagerCore.$$$reportNull$$$0(93);
        }
        if (descriptor instanceof IdeaPluginDescriptorImpl) {
            IdeaPluginDescriptorImpl descriptorImpl = (IdeaPluginDescriptorImpl)descriptor;
            Boolean skipped = descriptorImpl.getSkipped();
            if (skipped != null) {
                return skipped;
            }
            boolean result2 = PluginManagerCore.detectReasonToNotLoad(descriptor, ourPlugins) != null || PluginManagerCore.isBrokenPlugin(descriptor);
            descriptorImpl.setSkipped(result2);
            return result2;
        }
        return PluginManagerCore.detectReasonToNotLoad(descriptor, ourPlugins) != null || PluginManagerCore.isBrokenPlugin(descriptor);
    }

    private static void checkEssentialPluginsAreAvailable(IdeaPluginDescriptorImpl[] plugins2) {
        Set availableIds = ContainerUtil.map2Set((Object[])plugins2, plugin -> plugin.getPluginId().getIdString());
        List<String> ids = ((ApplicationInfoImpl)ApplicationInfoImpl.getShadowInstance()).getEssentialPluginsIds();
        Set missing = JBIterable.from(ids).filter(id -> !availableIds.contains(id)).toSet();
        if (!missing.isEmpty()) {
            throw new EssentialPluginMissingException(missing);
        }
    }

    private static void initializePlugins(@Nullable StartupProgress progress) {
        int i;
        PluginManagerCore.configureExtensions();
        ArrayList errors = ContainerUtil.newArrayList();
        IdeaPluginDescriptorImpl[] pluginDescriptors = PluginManagerCore.loadDescriptors(progress, errors);
        PluginManagerCore.checkEssentialPluginsAreAvailable(pluginDescriptors);
        Class callerClass = ReflectionUtil.findCallerClass((int)1);
        assert (callerClass != null);
        ClassLoader parentLoader = callerClass.getClassLoader();
        final ArrayList<IdeaPluginDescriptorImpl> result2 = new ArrayList<IdeaPluginDescriptorImpl>();
        THashMap idToDescriptorMap = new THashMap();
        THashMap disabledPluginNames = new THashMap();
        SmartList brokenPluginsList = new SmartList();
        PluginManagerCore.fixDescriptors(pluginDescriptors, parentLoader, (Map<PluginId, IdeaPluginDescriptorImpl>)idToDescriptorMap, (Map<String, String>)disabledPluginNames, (List<String>)brokenPluginsList, result2, errors);
        Graph<PluginId> graph = PluginManagerCore.createPluginIdGraph((Map<PluginId, ? extends IdeaPluginDescriptor>)idToDescriptorMap);
        DFSTBuilder builder = new DFSTBuilder(graph);
        PluginManagerCore.prepareLoadingPluginsErrorMessage(errors);
        Comparator idComparator = builder.comparator();
        result2.sort((o1, o2) -> idComparator.compare(o1.getPluginId(), o2.getPluginId()));
        for (i = 0; i < result2.size(); ++i) {
            ourId2Index.put((Object)((IdeaPluginDescriptorImpl)result2.get(i)).getPluginId(), i);
        }
        i = 0;
        for (IdeaPluginDescriptorImpl pluginDescriptor : result2) {
            if (pluginDescriptor.getPluginId().getIdString().equals(CORE_PLUGIN_ID) || pluginDescriptor.isUseCoreClassLoader()) {
                pluginDescriptor.setLoader(parentLoader);
            } else {
                ClassLoader[] classLoaderArray;
                List<File> classPath = pluginDescriptor.getClassPath();
                PluginId[] dependentPluginIds = pluginDescriptor.getDependentPluginIds();
                ClassLoader[] parentLoaders = PluginManagerCore.getParentLoaders((Map<PluginId, ? extends IdeaPluginDescriptor>)idToDescriptorMap, dependentPluginIds);
                if (parentLoaders.length > 0) {
                    classLoaderArray = parentLoaders;
                } else {
                    ClassLoader[] classLoaderArray2 = new ClassLoader[1];
                    classLoaderArray = classLoaderArray2;
                    classLoaderArray2[0] = parentLoader;
                }
                ClassLoader pluginClassLoader = PluginManagerCore.createPluginClassLoader(classPath.toArray(new File[classPath.size()]), classLoaderArray, pluginDescriptor);
                pluginDescriptor.setLoader(pluginClassLoader);
            }
            if (progress == null) continue;
            progress.showProgress("", 0.3f + (float)i++ / (float)result2.size() * 0.35f);
        }
        PluginManagerCore.registerExtensionPointsAndExtensions(Extensions.getRootArea(), result2);
        Extensions.getRootArea().getExtensionPoint(Extensions.AREA_LISTENER_EXTENSION_POINT).registerExtension((Object)new AreaListener(){

            public void areaCreated(@NotNull String areaClass, @NotNull AreaInstance areaInstance) {
                if (areaClass == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (areaInstance == null) {
                    2.$$$reportNull$$$0(1);
                }
                PluginManagerCore.registerExtensionPointsAndExtensions(Extensions.getArea((AreaInstance)areaInstance), result2);
            }

            public void areaDisposing(@NotNull String areaClass, @NotNull AreaInstance areaInstance) {
                if (areaClass == null) {
                    2.$$$reportNull$$$0(2);
                }
                if (areaInstance == null) {
                    2.$$$reportNull$$$0(3);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "areaClass";
                        break;
                    }
                    case 1: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "areaInstance";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/ide/plugins/PluginManagerCore$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "areaCreated";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "areaDisposing";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        ourPlugins = pluginDescriptors;
    }

    public static void fixDescriptors(@NotNull IdeaPluginDescriptorImpl[] pluginDescriptors, @NotNull ClassLoader parentLoader, @NotNull Map<PluginId, IdeaPluginDescriptorImpl> idToDescriptorMap, @NotNull Map<String, String> disabledPluginNames, @NotNull List<String> brokenPluginsList, @NotNull List<IdeaPluginDescriptorImpl> result2, @NotNull List<String> errors) {
        if (pluginDescriptors == null) {
            PluginManagerCore.$$$reportNull$$$0(94);
        }
        if (parentLoader == null) {
            PluginManagerCore.$$$reportNull$$$0(95);
        }
        if (idToDescriptorMap == null) {
            PluginManagerCore.$$$reportNull$$$0(96);
        }
        if (disabledPluginNames == null) {
            PluginManagerCore.$$$reportNull$$$0(97);
        }
        if (brokenPluginsList == null) {
            PluginManagerCore.$$$reportNull$$$0(98);
        }
        if (result2 == null) {
            PluginManagerCore.$$$reportNull$$$0(99);
        }
        if (errors == null) {
            PluginManagerCore.$$$reportNull$$$0(100);
        }
        PluginManagerCore.checkCanLoadPlugins(pluginDescriptors, parentLoader, disabledPluginNames, brokenPluginsList, result2);
        PluginManagerCore.filterBadPlugins(result2, disabledPluginNames, errors);
        if (!brokenPluginsList.isEmpty()) {
            errors.add("The following plugins are incompatible with the current IDE build: " + StringUtil.join(brokenPluginsList, (String)", "));
        }
        PluginManagerCore.fixDependencies(result2, idToDescriptorMap);
    }

    private static void checkCanLoadPlugins(@NotNull IdeaPluginDescriptorImpl[] pluginDescriptors, @NotNull ClassLoader parentLoader, @NotNull Map<String, String> disabledPluginNames, @NotNull List<String> brokenPluginsList, @NotNull List<IdeaPluginDescriptorImpl> result2) {
        if (pluginDescriptors == null) {
            PluginManagerCore.$$$reportNull$$$0(101);
        }
        if (parentLoader == null) {
            PluginManagerCore.$$$reportNull$$$0(102);
        }
        if (disabledPluginNames == null) {
            PluginManagerCore.$$$reportNull$$$0(103);
        }
        if (brokenPluginsList == null) {
            PluginManagerCore.$$$reportNull$$$0(104);
        }
        if (result2 == null) {
            PluginManagerCore.$$$reportNull$$$0(105);
        }
        for (IdeaPluginDescriptorImpl descriptor : pluginDescriptors) {
            String toNotLoadReason = PluginManagerCore.detectReasonToNotLoad(descriptor, pluginDescriptors);
            if (toNotLoadReason == null && PluginManagerCore.isBrokenPlugin(descriptor)) {
                brokenPluginsList.add(descriptor.getName());
                toNotLoadReason = "This plugin version was marked as incompatible";
            }
            if (toNotLoadReason == null) {
                List<String> modules = descriptor.getModules();
                if (modules != null) {
                    for (String module : modules) {
                        if (ourModulesToContainingPlugins.containsKey(module)) continue;
                        ourModulesToContainingPlugins.put(module, descriptor);
                    }
                }
                result2.add(descriptor);
                continue;
            }
            descriptor.setEnabled(false);
            PluginManagerCore.getLogger().info(String.format("Plugin '%s' can't be loaded because: %s", descriptor.getName(), toNotLoadReason));
            disabledPluginNames.put(descriptor.getPluginId().getIdString(), descriptor.getName());
            PluginManagerCore.initClassLoader(parentLoader, descriptor);
        }
    }

    private static void fixDependencies(@NotNull List<IdeaPluginDescriptorImpl> result2, @NotNull Map<PluginId, IdeaPluginDescriptorImpl> idToDescriptorMap) {
        if (result2 == null) {
            PluginManagerCore.$$$reportNull$$$0(106);
        }
        if (idToDescriptorMap == null) {
            PluginManagerCore.$$$reportNull$$$0(107);
        }
        for (IdeaPluginDescriptorImpl descriptor : result2) {
            idToDescriptorMap.put(descriptor.getPluginId(), descriptor);
        }
        IdeaPluginDescriptor corePluginDescriptor = idToDescriptorMap.get(PluginId.getId((String)CORE_PLUGIN_ID));
        assert (corePluginDescriptor != null) : "com.intellij not found; platform prefix is " + System.getProperty("idea.platform.prefix");
        for (IdeaPluginDescriptorImpl descriptor : result2) {
            if (descriptor == corePluginDescriptor) continue;
            descriptor.insertDependency(corePluginDescriptor);
        }
        PluginManagerCore.mergeOptionalConfigs(idToDescriptorMap);
        PluginManagerCore.addModulesAsDependents(idToDescriptorMap);
    }

    private static void registerExtensionPointsAndExtensions(@NotNull ExtensionsArea area, @NotNull List<IdeaPluginDescriptorImpl> loadedPlugins) {
        if (area == null) {
            PluginManagerCore.$$$reportNull$$$0(108);
        }
        if (loadedPlugins == null) {
            PluginManagerCore.$$$reportNull$$$0(109);
        }
        for (IdeaPluginDescriptorImpl descriptor : loadedPlugins) {
            descriptor.registerExtensionPoints(area);
        }
        ExtensionPoint[] extensionPoints = area.getExtensionPoints();
        THashSet epNames = new THashSet(extensionPoints.length);
        for (ExtensionPoint point : extensionPoints) {
            epNames.add(point.getName());
        }
        for (IdeaPluginDescriptorImpl descriptor : loadedPlugins) {
            for (String epName : epNames) {
                descriptor.registerExtensions(area, epName);
            }
        }
    }

    public static void registerExtensionPointAndExtensions(@NotNull File pluginRoot, @NotNull String fileName, @NotNull ExtensionsArea area) {
        IdeaPluginDescriptorImpl descriptor;
        if (pluginRoot == null) {
            PluginManagerCore.$$$reportNull$$$0(110);
        }
        if (fileName == null) {
            PluginManagerCore.$$$reportNull$$$0(111);
        }
        if (area == null) {
            PluginManagerCore.$$$reportNull$$$0(112);
        }
        if ((descriptor = pluginRoot.isDirectory() ? PluginManagerCore.loadDescriptorFromDir(pluginRoot, fileName) : PluginManagerCore.loadDescriptorFromJar(pluginRoot, fileName, JDOMXIncluder.DEFAULT_PATH_RESOLVER)) != null) {
            PluginManagerCore.registerExtensionPointsAndExtensions(area, Collections.singletonList(descriptor));
        } else {
            PluginManagerCore.getLogger().error("Cannot load " + fileName + " from " + pluginRoot);
        }
    }

    private static void initPlugins(@Nullable StartupProgress progress) {
        long start = System.currentTimeMillis();
        try {
            PluginManagerCore.initializePlugins(progress);
        }
        catch (PicoPluginExtensionInitializationException e) {
            throw new PluginException((Throwable)e, e.getPluginId());
        }
        catch (RuntimeException e) {
            PluginManagerCore.getLogger().error((Throwable)e);
            throw e;
        }
        PluginManagerCore.getLogger().info(ourPlugins.length + " plugins initialized in " + (System.currentTimeMillis() - start) + " ms");
        PluginManagerCore.logPlugins();
        ClassUtilCore.clearJarURLCache();
    }

    private static /* synthetic */ boolean lambda$filterBadPlugins$5(Map idToDescriptorMap, IdeaPluginDescriptor pluginDescriptor, LinkedHashSet faultyDescriptors, List disabledPluginIds, @NotNull Map disabledPluginNames, @NotNull List errors, Iterator it, PluginId pluginId) {
        if (disabledPluginNames == null) {
            PluginManagerCore.$$$reportNull$$$0(113);
        }
        if (errors == null) {
            PluginManagerCore.$$$reportNull$$$0(114);
        }
        if (!idToDescriptorMap.containsKey(pluginId)) {
            pluginDescriptor.setEnabled(false);
            if (!pluginId.getIdString().startsWith(MODULE_DEPENDENCY_PREFIX)) {
                boolean disabled;
                String pluginName;
                faultyDescriptors.add(pluginId.getIdString());
                disabledPluginIds.add(pluginDescriptor.getPluginId().getIdString());
                String name = pluginDescriptor.getName();
                IdeaPluginDescriptor descriptor = (IdeaPluginDescriptor)idToDescriptorMap.get(pluginId);
                if (descriptor == null) {
                    pluginName = pluginId.getIdString();
                    if (disabledPluginNames.containsKey(pluginName)) {
                        pluginName = (String)disabledPluginNames.get(pluginName);
                    }
                } else {
                    pluginName = descriptor.getName();
                }
                errors.add(IdeBundle.message((String)((disabled = PluginManagerCore.getDisabledPlugins().contains(pluginId.getIdString())) ? "error.required.plugin.disabled" : "error.required.plugin.not.installed"), (Object[])new Object[]{name, pluginName}));
            }
            it.remove();
            return false;
        }
        return true;
    }

    static {
        ourId2Index = new TObjectIntHashMap();
        ourModulesToContainingPlugins = new THashMap();
        ourPluginClasses = new PluginClassCache();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 49: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 80: 
            case 81: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 116: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 49: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 80: 
            case 81: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 116: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/plugins/PluginManagerCore";
                break;
            }
            case 2: 
            case 83: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptors";
                break;
            }
            case 3: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configPath";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disabledPlugins";
                break;
            }
            case 6: 
            case 30: 
            case 33: 
            case 66: 
            case 85: 
            case 86: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 93: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 10: 
            case 12: 
            case 16: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ids";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "plugins";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "writer";
                break;
            }
            case 14: 
            case 15: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependentPluginId";
                break;
            }
            case 21: 
            case 24: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginDescriptor";
                break;
            }
            case 22: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginId2Descriptor";
                break;
            }
            case 23: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "check";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processed";
                break;
            }
            case 28: 
            case 29: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "className";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "on";
                break;
            }
            case 32: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map";
                break;
            }
            case 34: 
            case 73: {
                objectArray2 = objectArray3;
                objectArray3[0] = "loader";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classPath";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentLoaders";
                break;
            }
            case 39: 
            case 46: 
            case 49: 
            case 96: 
            case 107: {
                objectArray2 = objectArray3;
                objectArray3[0] = "idToDescriptorMap";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginIds";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginsPath";
                break;
            }
            case 44: 
            case 47: 
            case 72: 
            case 77: 
            case 81: 
            case 100: 
            case 114: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errors";
                break;
            }
            case 51: 
            case 53: 
            case 56: 
            case 60: 
            case 62: 
            case 116: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 52: 
            case 54: 
            case 63: 
            case 75: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathName";
                break;
            }
            case 55: 
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathResolver";
                break;
            }
            case 57: 
            case 61: 
            case 65: 
            case 111: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
            case 59: 
            case 64: 
            case 115: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 67: {
                objectArray2 = objectArray3;
                objectArray3[0] = "optionalDescriptorLoader";
                break;
            }
            case 68: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginsHome";
                break;
            }
            case 69: 
            case 70: 
            case 76: 
            case 80: 
            case 99: 
            case 105: 
            case 106: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 71: 
            case 97: 
            case 103: 
            case 113: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disabledPluginNames";
                break;
            }
            case 74: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resource";
                break;
            }
            case 84: 
            case 95: 
            case 102: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentLoader";
                break;
            }
            case 87: {
                objectArray2 = objectArray3;
                objectArray3[0] = "loaded";
                break;
            }
            case 92: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildNumber";
                break;
            }
            case 94: 
            case 101: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginDescriptors";
                break;
            }
            case 98: 
            case 104: {
                objectArray2 = objectArray3;
                objectArray3[0] = "brokenPluginsList";
                break;
            }
            case 108: 
            case 112: {
                objectArray2 = objectArray3;
                objectArray3[0] = "area";
                break;
            }
            case 109: {
                objectArray2 = objectArray3;
                objectArray3[0] = "loadedPlugins";
                break;
            }
            case 110: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginRoot";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getPlugins";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 49: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 80: 
            case 81: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 116: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/plugins/PluginManagerCore";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisabledPlugins";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getBrokenPluginVersions";
                break;
            }
            case 41: 
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "getParentLoaders";
                break;
            }
            case 48: {
                objectArray = objectArray2;
                objectArray2[1] = "getPluginDescriptorComparator";
                break;
            }
            case 50: {
                objectArray = objectArray2;
                objectArray2[1] = "createPluginIdGraph";
                break;
            }
            case 78: 
            case 79: {
                objectArray = objectArray2;
                objectArray2[1] = "loadDescriptors";
                break;
            }
            case 82: {
                objectArray = objectArray2;
                objectArray2[1] = "topoSortPlugins";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setPlugins";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "loadDisabledPlugins";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isBrokenPlugin";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "addDisablePluginListener";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "removeDisablePluginListener";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "savePluginsList";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "writePluginsList";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "disablePlugin";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "enablePlugin";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "saveDisabledPlugins";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getPluginLoadingOrder";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "isModuleDependency";
                break;
            }
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "checkDependants";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getPluginByClassName";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "hasLoadedClass";
                break;
            }
            case 30: 
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "isDependent";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "hasModuleDependencies";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "getAddUrlMethod";
                break;
            }
            case 35: 
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "createPluginClassLoader";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "isPluginClass";
                break;
            }
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "getParentLoaders";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "countPlugins";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "prepareLoadingPluginsErrorMessage";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "addModulesAsDependents";
                break;
            }
            case 46: 
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "getPluginDescriptorComparator";
                break;
            }
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "createPluginIdGraph";
                break;
            }
            case 51: 
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "loadDescriptorFromDir";
                break;
            }
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "loadDescriptorFromJar";
                break;
            }
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: {
                objectArray = objectArray;
                objectArray[2] = "loadDescriptor";
                break;
            }
            case 65: 
            case 66: 
            case 67: {
                objectArray = objectArray;
                objectArray[2] = "resolveOptionalDescriptors";
                break;
            }
            case 68: 
            case 69: 
            case 77: {
                objectArray = objectArray;
                objectArray[2] = "loadDescriptors";
                break;
            }
            case 70: 
            case 71: 
            case 72: {
                objectArray = objectArray;
                objectArray[2] = "filterBadPlugins";
                break;
            }
            case 73: {
                objectArray = objectArray;
                objectArray[2] = "testLoadDescriptorsFromClassPath";
                break;
            }
            case 74: 
            case 75: {
                objectArray = objectArray;
                objectArray[2] = "loadDescriptorFromResource";
                break;
            }
            case 76: {
                objectArray = objectArray;
                objectArray[2] = "loadDescriptorsFromProperty";
                break;
            }
            case 80: 
            case 81: {
                objectArray = objectArray;
                objectArray[2] = "topoSortPlugins";
                break;
            }
            case 83: {
                objectArray = objectArray;
                objectArray[2] = "mergeOptionalConfigs";
                break;
            }
            case 84: 
            case 85: {
                objectArray = objectArray;
                objectArray[2] = "initClassLoader";
                break;
            }
            case 86: 
            case 87: {
                objectArray = objectArray;
                objectArray[2] = "detectReasonToNotLoad";
                break;
            }
            case 88: 
            case 89: {
                objectArray = objectArray;
                objectArray[2] = "isCompatible";
                break;
            }
            case 90: 
            case 91: 
            case 92: {
                objectArray = objectArray;
                objectArray[2] = "isIncompatible";
                break;
            }
            case 93: {
                objectArray = objectArray;
                objectArray[2] = "shouldSkipPlugin";
                break;
            }
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: {
                objectArray = objectArray;
                objectArray[2] = "fixDescriptors";
                break;
            }
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: {
                objectArray = objectArray;
                objectArray[2] = "checkCanLoadPlugins";
                break;
            }
            case 106: 
            case 107: {
                objectArray = objectArray;
                objectArray[2] = "fixDependencies";
                break;
            }
            case 108: 
            case 109: {
                objectArray = objectArray;
                objectArray[2] = "registerExtensionPointsAndExtensions";
                break;
            }
            case 110: 
            case 111: 
            case 112: {
                objectArray = objectArray;
                objectArray[2] = "registerExtensionPointAndExtensions";
                break;
            }
            case 113: 
            case 114: {
                objectArray = objectArray;
                objectArray[2] = "lambda$filterBadPlugins$5";
                break;
            }
            case 115: 
            case 116: {
                objectArray = objectArray;
                objectArray[2] = "lambda$loadDescriptor$2";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 49: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 80: 
            case 81: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 116: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class EssentialPluginMissingException
    extends RuntimeException {
        final Set<String> pluginIds;

        EssentialPluginMissingException(@NotNull Set<String> ids) {
            if (ids == null) {
                EssentialPluginMissingException.$$$reportNull$$$0(0);
            }
            super("Missing essential plugins: " + StringUtil.join(ids, (String)", "));
            this.pluginIds = ids;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ids", "com/intellij/ide/plugins/PluginManagerCore$EssentialPluginMissingException", "<init>"));
        }
    }

    private static class IdeaLogProvider
    implements LogProvider {
        private IdeaLogProvider() {
        }

        public void error(String message) {
            PluginManagerCore.getLogger().error(message);
        }

        public void error(String message, Throwable t) {
            PluginManagerCore.getLogger().error(message, t);
        }

        public void error(Throwable t) {
            PluginManagerCore.getLogger().error(t);
        }

        public void warn(String message) {
            PluginManagerCore.getLogger().info(message);
        }

        public void warn(String message, Throwable t) {
            PluginManagerCore.getLogger().info(message, t);
        }

        public void warn(Throwable t) {
            PluginManagerCore.getLogger().info(t);
        }
    }

    private static class LoggerHolder {
        private static final Logger ourLogger = Logger.getInstance((String)"#com.intellij.ide.plugins.PluginManager");

        private LoggerHolder() {
        }
    }

    private static class LoadingContext
    implements AutoCloseable {
        final Map<File, ZipFile> myOpenedFiles = new THashMap();
        File myLastZipFileContainingDescriptor;

        private LoadingContext() {
        }

        @Override
        public void close() {
            for (ZipFile file2 : this.myOpenedFiles.values()) {
                try {
                    file2.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private static class Holder {
        private static final BuildNumber ourBuildNumber = Holder.calcBuildNumber();
        private static final boolean ourIsRunningFromSources = new File(PathManager.getHomePath(), ".idea").isDirectory();

        private Holder() {
        }

        private static BuildNumber calcBuildNumber() {
            BuildNumber ourBuildNumber = BuildNumber.fromString((String)System.getProperty("idea.plugins.compatible.build"));
            if (ourBuildNumber == null) {
                BuildNumber buildNumber = ourBuildNumber = BUILD_NUMBER == null ? null : BuildNumber.fromString((String)BUILD_NUMBER);
                if (ourBuildNumber == null) {
                    ourBuildNumber = BuildNumber.currentVersion();
                }
            }
            return ourBuildNumber;
        }
    }
}

