/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui.laf.darcula.ui;

import com.intellij.ide.ui.laf.darcula.DarculaUIUtil;
import com.intellij.ide.ui.laf.darcula.ui.DarculaButtonUI;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.ui.Gray;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.MacUIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.Path2D;
import java.awt.geom.RoundRectangle2D;
import javax.swing.JComponent;
import javax.swing.border.Border;
import javax.swing.plaf.UIResource;

public class DarculaButtonPainter
implements Border,
UIResource {
    private static final int myOffset = 4;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        Graphics2D g2 = (Graphics2D)g.create();
        try {
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, MacUIUtil.USE_QUARTZ ? RenderingHints.VALUE_STROKE_PURE : RenderingHints.VALUE_STROKE_NORMALIZE);
            if (DarculaButtonUI.isSquare(c)) {
                Rectangle r = new Rectangle(width, height);
                g2.translate(r.x, r.y);
                Path2D.Float border = new Path2D.Float(0);
                float lw = DarculaUIUtil.lw(g2);
                float bw = DarculaUIUtil.bw();
                float arc = JBUI.scale((float)2.0f);
                border.append(new RoundRectangle2D.Float(bw, bw, (float)r.width - bw * 2.0f, (float)r.height - bw * 2.0f, arc, arc), false);
                border.append(new RoundRectangle2D.Float(bw + lw, bw + lw, (float)r.width - (bw + lw) * 2.0f, (float)r.height - (bw + lw) * 2.0f, arc - lw, arc - lw), false);
                g2.setColor(DarculaUIUtil.getOutlineColor(c.isEnabled()));
                g2.fill(border);
                if (c.hasFocus()) {
                    DarculaUIUtil.paintFocusBorder(g2, r.width, r.height, arc, true);
                }
            } else {
                int diam = JBUI.scale((int)22);
                if (c.hasFocus()) {
                    int off = JBUI.scale((int)2);
                    if (DarculaButtonUI.isHelpButton((JComponent)c)) {
                        g2.translate((double)off, (double)(height - diam) / 2.0 - (double)off);
                        DarculaUIUtil.paintFocusBorder(g2, width - off * 2, diam + off * 2, (float)diam / 2.0f + 2.0f * (float)off, true);
                    } else {
                        g2.translate(off, off);
                        DarculaUIUtil.paintFocusBorder(g2, width - off * 2, height - off * 2, DarculaUIUtil.arc(), true);
                    }
                } else {
                    Insets ins = this.getBorderInsets(c);
                    int yOff = (ins.top + ins.bottom) / 4;
                    int offset = JBUI.scale((int)this.getOffset());
                    int w = c.getWidth();
                    int h = c.getHeight();
                    g2.setPaint(this.getBorderColor());
                    if (DarculaButtonUI.isHelpButton((JComponent)c)) {
                        g2.drawOval((w - diam) / 2, (h - diam) / 2, diam, diam);
                    } else {
                        g2.translate(x, y);
                        int r = JBUI.scale((int)5);
                        g2.drawRoundRect(offset, yOff, width - 2 * offset, height - 2 * yOff, r, r);
                        g2.translate(-x, -y);
                    }
                }
            }
        }
        finally {
            g2.dispose();
        }
    }

    protected Color getBorderColor() {
        return Gray._100.withAlpha(180);
    }

    @Override
    public Insets getBorderInsets(Component c) {
        if (c.getParent() instanceof ActionToolbar) {
            return JBUI.insets((int)4, (int)16, (int)4, (int)16);
        }
        if (DarculaButtonUI.isSquare(c)) {
            return JBUI.insets((int)3).asUIResource();
        }
        return JBUI.insets((int)8, (int)16, (int)8, (int)14).asUIResource();
    }

    protected int getOffset() {
        return 4;
    }

    @Override
    public boolean isBorderOpaque() {
        return false;
    }
}

