/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui.laf.darcula.ui;

import com.intellij.ide.ui.laf.darcula.DarculaUIUtil;
import com.intellij.openapi.ui.GraphicsConfig;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.ui.Gray;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.ThreeStateCheckBox;
import com.intellij.util.ui.UIUtil;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import javax.swing.AbstractButton;
import javax.swing.CellRendererPane;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.metal.MetalCheckBoxUI;
import javax.swing.text.View;
import sun.swing.SwingUtilities2;

public class DarculaCheckBoxUI
extends MetalCheckBoxUI {
    public static ComponentUI createUI(JComponent c) {
        if (UIUtil.getParentOfType(CellRendererPane.class, (Component)c) != null) {
            c.setBorder(null);
        }
        return new DarculaCheckBoxUI();
    }

    @Override
    public synchronized void paint(Graphics g2d, JComponent c) {
        Graphics2D g = (Graphics2D)g2d;
        Dimension size = c.getSize();
        Rectangle viewRect = new Rectangle(size);
        Rectangle iconRect = new Rectangle();
        Rectangle textRect = new Rectangle();
        AbstractButton b = (AbstractButton)c;
        Font f = c.getFont();
        g.setFont(f);
        FontMetrics fm = SwingUtilities2.getFontMetrics(c, g, f);
        JBInsets.removeFrom((Rectangle)viewRect, (Insets)c.getInsets());
        String text = SwingUtilities.layoutCompoundLabel(c, fm, b.getText(), this.getDefaultIcon(), b.getVerticalAlignment(), b.getHorizontalAlignment(), b.getVerticalTextPosition(), b.getHorizontalTextPosition(), viewRect, iconRect, textRect, b.getIconTextGap());
        if (c.isOpaque()) {
            g.setColor(b.getBackground());
            g.fillRect(0, 0, size.width, size.height);
        }
        this.drawCheckIcon(c, g, b, iconRect, b.isSelected(), b.isEnabled());
        this.drawText(c, g, b, fm, textRect, text);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void drawCheckIcon(JComponent c, Graphics2D g, AbstractButton b, Rectangle iconRect, boolean selected, boolean enabled) {
        if (selected && b.getSelectedIcon() != null) {
            b.getSelectedIcon().paintIcon(b, g, iconRect.x + JBUI.scale((int)4), iconRect.y + JBUI.scale((int)2));
        } else if (!selected && b.getIcon() != null) {
            b.getIcon().paintIcon(b, g, iconRect.x + JBUI.scale((int)4), iconRect.y + JBUI.scale((int)2));
        } else {
            g = (Graphics2D)g.create();
            try {
                boolean overrideBg;
                int off = JBUI.scale((int)3);
                int x = iconRect.x + off;
                int y = iconRect.y + off;
                int w = iconRect.width - 2 * off;
                int h = iconRect.height - 2 * off;
                g.translate(x, y);
                g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                g.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_DEFAULT);
                if (c.isEnabled() || !UIUtil.isUnderDarcula()) {
                    Paint paint = UIUtil.getGradientPaint((float)(w / 2), (float)0.0f, (Color)b.getBackground().brighter(), (float)(w / 2), (float)h, (Color)b.getBackground());
                    g.setPaint(paint);
                    int fillOffset = JBUI.scale((int)1);
                    g.fillRect(fillOffset, fillOffset, w - 2 * fillOffset, h - 2 * fillOffset);
                }
                boolean armed = b.getModel().isArmed();
                int R = JBUI.scale((int)4);
                int offset = 1;
                boolean bl = overrideBg = this.isIndeterminate(b) && this.fillBackgroundForIndeterminateSameAsForSelected();
                if (c.hasFocus()) {
                    g.setPaint(UIUtil.getGradientPaint((float)(w / 2), (float)offset, (Color)this.getFocusedBackgroundColor1(armed, selected || overrideBg), (float)(w / 2), (float)h, (Color)this.getFocusedBackgroundColor2(armed, selected || overrideBg)));
                    g.fillRoundRect(0, 0, w, h, R, R);
                    float bw = DarculaUIUtil.bw();
                    g.translate(-bw, -bw);
                    DarculaUIUtil.paintFocusBorder(g, (int)((float)iconRect.width - bw), (int)((float)iconRect.height - bw), DarculaUIUtil.arc(), true);
                    g.translate(bw, bw);
                } else if (c.isEnabled() || !UIUtil.isUnderDarcula()) {
                    g.setPaint(UIUtil.getGradientPaint((float)(w / 2), (float)offset, (Color)this.getBackgroundColor1(enabled, selected || overrideBg), (float)(w / 2), (float)h, (Color)this.getBackgroundColor2(enabled, selected || overrideBg)));
                    g.fillRoundRect(0, 0, w, h, R, R);
                    Color borderColor1 = this.getBorderColor1(enabled, selected || overrideBg);
                    Color borderColor2 = this.getBorderColor2(enabled, selected || overrideBg);
                    g.setPaint(UIUtil.getGradientPaint((float)(w / 2), (float)offset, (Color)borderColor1, (float)(w / 2), (float)h, (Color)borderColor2));
                    g.drawRoundRect(0, UIUtil.isUnderDarcula() ? offset : 0, w, h - offset, R, R);
                    g.setPaint(this.getInactiveFillColor());
                    g.drawRoundRect(0, 0, w, h - offset, R, R);
                } else {
                    g.setColor((Color)Gray.x58);
                    g.drawRoundRect(0, 0, w, h - offset, R, R);
                }
                if (this.isIndeterminate(b)) {
                    this.paintIndeterminateSign(g, enabled, w, h);
                } else if (b.getModel().isSelected()) {
                    this.paintCheckSign(g, enabled, w, h);
                }
            }
            finally {
                g.dispose();
            }
        }
    }

    protected void paintIndeterminateSign(Graphics2D g, boolean enabled, int w, int h) {
        g.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        g.setStroke(new BasicStroke(1.0f * JBUI.scale((float)2.0f), 1, 1));
        int off = JBUI.scale((int)4);
        int y1 = h / 2;
        g.setColor(this.getShadowColor(enabled, true));
        GraphicsConfig c = new GraphicsConfig((Graphics)g).paintWithAlpha(0.8f);
        g.drawLine(off, y1 + JBUI.scale((int)1), w - off + JBUI.scale((int)1), y1 + JBUI.scale((int)1));
        c.restore();
        g.setColor(this.getCheckSignColor(enabled, true));
        g.drawLine(off, y1, w - off + JBUI.scale((int)1), y1);
    }

    protected void drawText(JComponent c, Graphics2D g, AbstractButton b, FontMetrics fm, Rectangle textRect, String text) {
        if (text != null) {
            View view = (View)c.getClientProperty("html");
            if (view != null) {
                view.paint(g, textRect);
            } else {
                g.setColor(b.isEnabled() ? b.getForeground() : this.getDisabledTextColor());
                int mnemonicIndex = SystemInfo.isMac && !UIManager.getBoolean("Button.showMnemonics") ? -1 : b.getDisplayedMnemonicIndex();
                SwingUtilities2.drawStringUnderlineCharAt(c, g, text, mnemonicIndex, textRect.x, textRect.y + fm.getAscent());
            }
        }
    }

    protected boolean fillBackgroundForIndeterminateSameAsForSelected() {
        return false;
    }

    protected void paintCheckSign(Graphics2D g, boolean enabled, int w, int h) {
        g.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        g.setStroke(new BasicStroke(1.0f * JBUI.scale((float)2.0f), 1, 1));
        int x1 = JBUI.scale((int)4);
        int y1 = JBUI.scale((int)7);
        int x2 = JBUI.scale((int)7);
        int y2 = JBUI.scale((int)11);
        int y3 = JBUI.scale((int)2);
        if (enabled) {
            g.setPaint(this.getShadowColor(true, true));
            g.drawLine(x1, y1, x2, y2);
            g.drawLine(x2, y2, w, y3);
        }
        g.setPaint(this.getCheckSignColor(enabled, true));
        g.translate(0, -2);
        g.drawLine(x1, y1, x2, y2);
        g.drawLine(x2, y2, w, y3);
        g.translate(0, 2);
    }

    protected Color getInactiveFillColor() {
        return DarculaCheckBoxUI.getColor("inactiveFillColor", Gray._40.withAlpha(180));
    }

    protected Color getBorderColor1(boolean enabled, boolean selected) {
        return enabled ? DarculaCheckBoxUI.getColor("borderColor1", Gray._120.withAlpha(90), selected) : DarculaCheckBoxUI.getColor("disabledBorderColor1", Gray._120.withAlpha(90), selected);
    }

    protected Color getBorderColor2(boolean enabled, boolean selected) {
        return enabled ? DarculaCheckBoxUI.getColor("borderColor2", Gray._105.withAlpha(90), selected) : DarculaCheckBoxUI.getColor("disabledBorderColor2", Gray._105.withAlpha(90), selected);
    }

    protected Color getBackgroundColor1(boolean enabled, boolean selected) {
        return DarculaCheckBoxUI.getColor("backgroundColor1", (Color)Gray._110, selected);
    }

    protected Color getBackgroundColor2(boolean enabled, boolean selected) {
        return DarculaCheckBoxUI.getColor("backgroundColor2", (Color)Gray._95, selected);
    }

    protected Color getCheckSignColor(boolean enabled, boolean selected) {
        return enabled ? DarculaCheckBoxUI.getColor("checkSignColor", (Color)Gray._170, selected) : DarculaCheckBoxUI.getColor("checkSignColorDisabled", (Color)Gray._120, selected);
    }

    protected Color getShadowColor(boolean enabled, boolean selected) {
        return enabled ? DarculaCheckBoxUI.getColor("shadowColor", (Color)Gray._30, selected) : DarculaCheckBoxUI.getColor("shadowColorDisabled", (Color)Gray._60, selected);
    }

    protected Color getFocusedBackgroundColor1(boolean armed, boolean selected) {
        return armed ? DarculaCheckBoxUI.getColor("focusedArmed.backgroundColor1", (Color)Gray._100, selected) : DarculaCheckBoxUI.getColor("focused.backgroundColor1", (Color)Gray._120, selected);
    }

    protected Color getFocusedBackgroundColor2(boolean armed, boolean selected) {
        return armed ? DarculaCheckBoxUI.getColor("focusedArmed.backgroundColor2", (Color)Gray._55, selected) : DarculaCheckBoxUI.getColor("focused.backgroundColor2", (Color)Gray._75, selected);
    }

    protected static Color getColor(String shortPropertyName, Color defaultValue) {
        Color color = UIManager.getColor("CheckBox.darcula." + shortPropertyName);
        return color == null ? defaultValue : color;
    }

    protected static Color getColor(String shortPropertyName, Color defaultValue, boolean selected) {
        Color color;
        if (selected && (color = DarculaCheckBoxUI.getColor(shortPropertyName + ".selected", null)) != null) {
            return color;
        }
        return DarculaCheckBoxUI.getColor(shortPropertyName, defaultValue);
    }

    @Override
    public Icon getDefaultIcon() {
        return EmptyIcon.create((int)JBUI.scale((int)20)).asUIResource();
    }

    protected boolean isIndeterminate(AbstractButton checkBox) {
        return "indeterminate".equals(checkBox.getClientProperty("JButton.selectedState")) || checkBox instanceof ThreeStateCheckBox && ((ThreeStateCheckBox)checkBox).getState() == ThreeStateCheckBox.State.DONT_CARE;
    }
}

