/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui.laf.intellij;

import com.intellij.ide.ui.laf.IntelliJLaf;
import com.intellij.ide.ui.laf.darcula.ui.DarculaButtonUI;
import com.intellij.ide.ui.laf.intellij.MacIntelliJButtonBorder;
import com.intellij.ide.ui.laf.intellij.MacIntelliJIconCache;
import com.intellij.ui.Gray;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.MacUIUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.Path2D;
import java.awt.geom.RoundRectangle2D;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import sun.swing.SwingUtilities2;

public class MacIntelliJButtonUI
extends DarculaButtonUI {
    static final int ARC_SIZE = JBUI.scale((int)6);

    public static ComponentUI createUI(JComponent c) {
        return new MacIntelliJButtonUI();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paint(Graphics g, JComponent c) {
        if (!(c.getBorder() instanceof MacIntelliJButtonBorder) && !MacIntelliJButtonUI.isComboButton(c)) {
            super.paint(g, c);
            return;
        }
        int w = c.getWidth();
        int h = c.getHeight();
        if (MacIntelliJButtonUI.isHelpButton(c)) {
            Icon icon = MacIntelliJIconCache.getIcon("helpButton", false, c.hasFocus());
            int x = (w - icon.getIconWidth()) / 2;
            int y = (h - icon.getIconHeight()) / 2;
            icon.paintIcon(c, g, x, y);
        } else {
            AbstractButton b = (AbstractButton)c;
            Graphics2D g2 = (Graphics2D)g.create();
            try {
                g2.translate(0, 0);
                g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                g2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, MacUIUtil.USE_QUARTZ ? RenderingHints.VALUE_STROKE_PURE : RenderingHints.VALUE_STROKE_NORMALIZE);
                float lw = UIUtil.isRetina((Graphics2D)g2) ? 0.5f : 1.0f;
                Insets i = c.getBorder().getBorderInsets(c);
                RoundRectangle2D.Float outerRect = new RoundRectangle2D.Float(i.left, i.top, w - (i.left + i.right), h - (i.top + i.bottom), ARC_SIZE, ARC_SIZE);
                Object p = !b.isEnabled() ? Gray.xF1 : (MacIntelliJButtonUI.isDefaultButton(c) ? (IntelliJLaf.isGraphite() ? new GradientPaint(w / 2, i.top, new Color(0xB2B2B7), w / 2, h - (i.top + i.bottom), new Color(0x929297)) : new GradientPaint(w / 2, i.top, new Color(6861562), w / 2, h - (i.top + i.bottom), new Color(950527))) : Gray.xFF);
                g2.setPaint((Paint)p);
                g2.fill(outerRect);
                Path2D.Float outline = new Path2D.Float(0);
                outline.append(outerRect, false);
                outline.append(new RoundRectangle2D.Float((float)i.left + lw, (float)i.top + lw, (float)w - lw * 2.0f - (float)(i.left + i.right), (float)h - lw * 2.0f - (float)(i.top + i.bottom), (float)ARC_SIZE - lw, (float)ARC_SIZE - lw), false);
                p = !b.isEnabled() ? new GradientPaint(w / 2, i.top, (Color)Gray.xD2, w / 2, h - (i.top + i.bottom), (Color)Gray.xC3) : (MacIntelliJButtonUI.isDefaultButton(c) ? (IntelliJLaf.isGraphite() ? new GradientPaint(w / 2, i.top, new Color(0xA5A5AB), w / 2, h - (i.top + i.bottom), new Color(8224131)) : new GradientPaint(w / 2, i.top, new Color(4956408), w / 2, h - (i.top + i.bottom), new Color(614143))) : new GradientPaint(w / 2, i.top, (Color)Gray.xC9, w / 2, h - (i.top + i.bottom), (Color)Gray.xAC));
                g2.setPaint((Paint)p);
                g2.fill(outline);
                this.paintContents(g2, b);
            }
            finally {
                g2.dispose();
            }
        }
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        Dimension size = super.getPreferredSize(c);
        if (MacIntelliJButtonUI.isHelpButton(c)) {
            Icon icon = MacIntelliJIconCache.getIcon("helpButton", false, false);
            return new Dimension(icon.getIconWidth(), icon.getIconHeight());
        }
        if (c.getBorder() instanceof MacIntelliJButtonBorder || MacIntelliJButtonUI.isComboButton(c)) {
            return JBUI.size((int)(size.width + (MacIntelliJButtonUI.isComboButton(c) ? 10 : 18)), (int)27);
        }
        return JBUI.size((Dimension)size);
    }

    @Override
    protected void paintDisabledText(Graphics g, String text, JComponent c, Rectangle textRect, FontMetrics metrics) {
        int x = textRect.x + this.getTextShiftOffset();
        int y = textRect.y + metrics.getAscent() + this.getTextShiftOffset();
        if (MacIntelliJButtonUI.isDefaultButton(c)) {
            g.setColor((Color)Gray.xCC);
        } else {
            g.setColor(UIManager.getColor("Button.disabledText"));
        }
        SwingUtilities2.drawStringUnderlineCharAt(c, g, text, -1, x, y);
    }
}

