/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui.laf.intellij;

import com.intellij.ide.ui.laf.darcula.ui.DarculaSpinnerUI;
import com.intellij.ide.ui.laf.intellij.MacIntelliJIconCache;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.JBUI;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.geom.Path2D;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JSpinner;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicArrowButton;
import org.jetbrains.annotations.Nullable;

public class MacIntelliJSpinnerUI
extends DarculaSpinnerUI {
    private static final Icon DEFAULT_ICON = EmptyIcon.create((Icon)MacIntelliJIconCache.getIcon("spinnerRight"));

    public static ComponentUI createUI(JComponent c) {
        return new MacIntelliJSpinnerUI();
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        Container parent = c.getParent();
        if (c.isOpaque() && parent != null) {
            g.setColor(parent.getBackground());
            g.fillRect(0, 0, c.getWidth(), c.getHeight());
        }
        Insets i = c.getInsets();
        int x = c.getWidth() - DEFAULT_ICON.getIconWidth() - i.right;
        if (c instanceof JSpinner) {
            Graphics2D g2 = (Graphics2D)g;
            g2.setColor(this.getBackground());
            float arc = JBUI.scale((float)6.0f);
            Path2D.Float rect = new Path2D.Float(0);
            ((Path2D)rect).moveTo(x, i.top);
            ((Path2D)rect).lineTo(x, c.getHeight() - i.bottom);
            ((Path2D)rect).lineTo((float)i.left + arc, c.getHeight() - i.bottom);
            ((Path2D)rect).quadTo(i.left, c.getHeight() - i.bottom, i.left, (float)(c.getHeight() - i.bottom) - arc);
            ((Path2D)rect).lineTo(i.left, (float)i.top + arc);
            ((Path2D)rect).quadTo(i.left, i.top, (float)i.left + arc, i.top);
            rect.closePath();
            g2.fill(rect);
        }
        Icon icon = MacIntelliJIconCache.getIcon("spinnerRight", false, false, c.isEnabled());
        icon.paintIcon(c, g, x, i.top);
    }

    @Override
    protected void paintArrowButton(Graphics g, BasicArrowButton button, int direction) {
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        return this.getSizeWithIcon(super.getPreferredSize(c));
    }

    @Override
    public Dimension getMinimumSize(JComponent c) {
        return this.getSizeWithIcon(super.getMinimumSize(c));
    }

    private Dimension getSizeWithIcon(Dimension d) {
        if (d == null) {
            return null;
        }
        Insets i = this.spinner.getInsets();
        int iconWidth = DEFAULT_ICON.getIconWidth() + i.right;
        int iconHeight = DEFAULT_ICON.getIconHeight() + i.top + i.bottom;
        return new Dimension(Math.max(d.width + JBUI.scale((int)7), iconWidth), Math.max(d.height, iconHeight));
    }

    @Override
    protected LayoutManager createLayout() {
        return new DarculaSpinnerUI.LayoutManagerDelegate(super.createLayout()){

            @Override
            public Dimension preferredLayoutSize(Container parent) {
                Dimension d = super.preferredLayoutSize(parent);
                if (d == null) {
                    return null;
                }
                Insets i = parent.getInsets();
                return new Dimension(Math.max(DEFAULT_ICON.getIconWidth() + JBUI.scale((int)25) + i.left + i.right, d.width), DEFAULT_ICON.getIconHeight() + i.top + i.bottom);
            }

            @Override
            public Dimension minimumLayoutSize(Container parent) {
                Dimension d = super.minimumLayoutSize(parent);
                if (d == null) {
                    return null;
                }
                Insets i = parent.getInsets();
                return new Dimension(Math.max(DEFAULT_ICON.getIconWidth() + JBUI.scale((int)10) + i.left + i.right, d.width), DEFAULT_ICON.getIconHeight() + i.top + i.bottom);
            }
        };
    }

    @Override
    protected void layout() {
        JComponent editor = this.spinner.getEditor();
        if (editor != null) {
            int w = this.spinner.getWidth();
            int h = this.spinner.getHeight();
            Insets i = this.spinner.getInsets();
            editor.setBounds(JBUI.scale((int)2) + i.left, JBUI.scale((int)2) + i.top, w - (i.left + i.right + DEFAULT_ICON.getIconWidth() + JBUI.scale((int)6)), h - (i.top + i.bottom + JBUI.scale((int)2) * 2));
        }
    }

    @Nullable
    Rectangle getArrowButtonBounds() {
        Insets i = this.spinner.getInsets();
        return new Rectangle(this.spinner.getWidth() - DEFAULT_ICON.getIconWidth() - i.right, i.top, DEFAULT_ICON.getIconWidth(), DEFAULT_ICON.getIconHeight());
    }
}

