/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.customFolding;

import com.intellij.ide.IdeBundle;
import com.intellij.lang.folding.FoldingDescriptor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.fileEditor.ex.IdeDocumentHistory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.PopupChooserBuilder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.ui.components.JBList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Stack;
import javax.swing.DefaultListModel;
import javax.swing.ListModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CustomFoldingRegionsPopup {
    @NotNull
    private final JBList<MyFoldingDescriptorWrapper> myRegionsList;
    @NotNull
    private final JBPopup myPopup;
    @NotNull
    private final Editor myEditor;

    CustomFoldingRegionsPopup(@NotNull Collection<FoldingDescriptor> descriptors, @NotNull Editor editor, @NotNull Project project) {
        if (descriptors == null) {
            CustomFoldingRegionsPopup.$$$reportNull$$$0(0);
        }
        if (editor == null) {
            CustomFoldingRegionsPopup.$$$reportNull$$$0(1);
        }
        if (project == null) {
            CustomFoldingRegionsPopup.$$$reportNull$$$0(2);
        }
        this.myEditor = editor;
        this.myRegionsList = new JBList();
        this.myRegionsList.setModel((ListModel)new MyListModel(descriptors));
        this.myRegionsList.setSelectedIndex(0);
        PopupChooserBuilder popupBuilder = JBPopupFactory.getInstance().createListPopupBuilder(this.myRegionsList);
        this.myPopup = popupBuilder.setTitle(IdeBundle.message((String)"goto.custom.region.command", (Object[])new Object[0])).setResizable(false).setMovable(false).setItemChoosenCallback(() -> {
            PsiElement navigationElement;
            if (editor == null) {
                CustomFoldingRegionsPopup.$$$reportNull$$$0(5);
            }
            if (project == null) {
                CustomFoldingRegionsPopup.$$$reportNull$$$0(6);
            }
            if ((navigationElement = this.getNavigationElement()) != null) {
                CustomFoldingRegionsPopup.navigateTo(editor, navigationElement);
                IdeDocumentHistory.getInstance(project).includeCurrentCommandAsNavigation();
            }
        }).createPopup();
    }

    void show() {
        this.myPopup.showInBestPositionFor(this.myEditor);
    }

    @Nullable
    public PsiElement getNavigationElement() {
        Object selection = this.myRegionsList.getSelectedValue();
        if (selection != null) {
            return ((MyFoldingDescriptorWrapper)selection).getDescriptor().getElement().getPsi();
        }
        return null;
    }

    private static Collection<FoldingDescriptor> orderByPosition(Collection<FoldingDescriptor> descriptors) {
        ArrayList<FoldingDescriptor> sorted = new ArrayList<FoldingDescriptor>(descriptors.size());
        sorted.addAll(descriptors);
        Collections.sort(sorted, (descriptor1, descriptor2) -> {
            int pos1 = descriptor1.getElement().getTextRange().getStartOffset();
            int pos2 = descriptor2.getElement().getTextRange().getStartOffset();
            return pos1 - pos2;
        });
        return sorted;
    }

    private static void navigateTo(@NotNull Editor editor, @NotNull PsiElement element) {
        int offset;
        if (editor == null) {
            CustomFoldingRegionsPopup.$$$reportNull$$$0(3);
        }
        if (element == null) {
            CustomFoldingRegionsPopup.$$$reportNull$$$0(4);
        }
        if ((offset = element.getTextRange().getStartOffset()) >= 0 && offset < editor.getDocument().getTextLength()) {
            editor.getCaretModel().removeSecondaryCarets();
            editor.getCaretModel().moveToOffset(offset);
            editor.getScrollingModel().scrollToCaret(ScrollType.CENTER);
            editor.getSelectionModel().removeSelection();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptors";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/customFolding/CustomFoldingRegionsPopup";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "navigateTo";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$new$0";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class MyFoldingDescriptorWrapper {
        @NotNull
        private final FoldingDescriptor myDescriptor;
        private final int myIndent;

        private MyFoldingDescriptorWrapper(@NotNull FoldingDescriptor descriptor, int indent) {
            if (descriptor == null) {
                MyFoldingDescriptorWrapper.$$$reportNull$$$0(0);
            }
            this.myDescriptor = descriptor;
            this.myIndent = indent;
        }

        @NotNull
        public FoldingDescriptor getDescriptor() {
            FoldingDescriptor foldingDescriptor = this.myDescriptor;
            if (foldingDescriptor == null) {
                MyFoldingDescriptorWrapper.$$$reportNull$$$0(1);
            }
            return foldingDescriptor;
        }

        @Nullable
        public String toString() {
            return StringUtil.repeat((String)"   ", (int)this.myIndent) + this.myDescriptor.getPlaceholderText();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/customFolding/CustomFoldingRegionsPopup$MyFoldingDescriptorWrapper";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/customFolding/CustomFoldingRegionsPopup$MyFoldingDescriptorWrapper";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDescriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class MyListModel
    extends DefaultListModel<MyFoldingDescriptorWrapper> {
        private MyListModel(Collection<FoldingDescriptor> descriptors) {
            descriptors = CustomFoldingRegionsPopup.orderByPosition(descriptors);
            Stack<FoldingDescriptor> stack = new Stack<FoldingDescriptor>();
            for (FoldingDescriptor descriptor : descriptors) {
                while (!stack.isEmpty() && descriptor.getRange().getStartOffset() >= ((FoldingDescriptor)stack.peek()).getRange().getEndOffset()) {
                    stack.pop();
                }
                super.addElement(new MyFoldingDescriptorWrapper(descriptor, stack.size()));
                stack.push(descriptor);
            }
        }
    }
}

