/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.actionSystem.impl;

import com.intellij.openapi.actionSystem.AbbreviationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import gnu.trove.THashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.jdom.Element;
import org.jetbrains.annotations.Nullable;

@State(name="AbbreviationManager", storages={@Storage(value="abbreviations.xml", roamingType=RoamingType.PER_OS)})
public class AbbreviationManagerImpl
extends AbbreviationManager
implements PersistentStateComponent<Element> {
    private final Map<String, List<String>> myAbbreviation2ActionId = new THashMap();
    private final Map<String, LinkedHashSet<String>> myActionId2Abbreviations = new THashMap();
    private final Map<String, LinkedHashSet<String>> myPluginsActionId2Abbreviations = new THashMap();

    @Nullable
    public Element getState() {
        Element actions = new Element("actions");
        if (this.myActionId2Abbreviations.isEmpty()) {
            return actions;
        }
        Element abbreviations = null;
        for (String key : this.myActionId2Abbreviations.keySet()) {
            LinkedHashSet<String> pluginAbbrs;
            LinkedHashSet<String> abbrs = this.myActionId2Abbreviations.get(key);
            if (abbrs == (pluginAbbrs = this.myPluginsActionId2Abbreviations.get(key)) || abbrs != null && abbrs.equals(pluginAbbrs) || abbrs == null) continue;
            if (abbreviations == null) {
                abbreviations = new Element("abbreviations");
                actions.addContent(abbreviations);
            }
            Element action = new Element("action");
            action.setAttribute("id", key);
            abbreviations.addContent(action);
            for (String abbr : abbrs) {
                Element abbreviation = new Element("abbreviation");
                abbreviation.setAttribute("name", abbr);
                action.addContent(abbreviation);
            }
        }
        return actions;
    }

    public void loadState(Element state) {
        List actions;
        List abbreviations = state.getChildren("abbreviations");
        if (abbreviations != null && abbreviations.size() == 1 && (actions = ((Element)abbreviations.get(0)).getChildren("action")) != null && actions.size() > 0) {
            for (Element action : actions) {
                String actionId = action.getAttributeValue("id");
                LinkedHashSet values = this.myActionId2Abbreviations.computeIfAbsent(actionId, k -> new LinkedHashSet(1));
                List abbreviation = action.getChildren("abbreviation");
                if (abbreviation == null) continue;
                for (Element abbr : abbreviation) {
                    String abbrValue = abbr.getAttributeValue("name");
                    if (abbrValue == null) continue;
                    values.add(abbrValue);
                    this.myAbbreviation2ActionId.computeIfAbsent(abbrValue, k -> new ArrayList()).add(actionId);
                }
            }
        }
    }

    public Set<String> getAbbreviations() {
        return this.myActionId2Abbreviations.values().stream().flatMap(Collection::stream).collect(Collectors.toSet());
    }

    public Set<String> getAbbreviations(String actionId) {
        LinkedHashSet<String> abbreviations = this.myActionId2Abbreviations.get(actionId);
        if (abbreviations == null) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(abbreviations);
    }

    public List<String> findActions(String abbreviation) {
        List<String> actions = this.myAbbreviation2ActionId.get(abbreviation);
        return actions == null ? Collections.emptyList() : Collections.unmodifiableList(actions);
    }

    public void register(String abbreviation, String actionId, Map<String, LinkedHashSet<String>> storage2) {
        storage2.computeIfAbsent(actionId, k -> new LinkedHashSet(1)).add(abbreviation);
    }

    public void register(String abbreviation, String actionId, boolean fromPluginXml) {
        List ids;
        if (fromPluginXml && this.myActionId2Abbreviations.containsKey(actionId)) {
            this.register(abbreviation, actionId, this.myPluginsActionId2Abbreviations);
            return;
        }
        this.register(abbreviation, actionId, this.myActionId2Abbreviations);
        if (fromPluginXml) {
            this.register(abbreviation, actionId, this.myPluginsActionId2Abbreviations);
        }
        if (!(ids = this.myAbbreviation2ActionId.computeIfAbsent(abbreviation, k -> new ArrayList(0))).contains(actionId)) {
            ids.add(actionId);
        }
    }

    public void register(String abbreviation, String actionId) {
        this.register(abbreviation, actionId, false);
    }

    public void remove(String abbreviation, String actionId) {
        LinkedHashSet<String> abbreviations;
        List<String> actions = this.myAbbreviation2ActionId.get(abbreviation);
        if (actions != null) {
            actions.remove(actionId);
        }
        if ((abbreviations = this.myActionId2Abbreviations.get(actionId)) != null) {
            abbreviations.remove(abbreviation);
        } else {
            LinkedHashSet<String> abbrs = this.myActionId2Abbreviations.get(actionId);
            if (abbrs != null) {
                LinkedHashSet<String> customValues = new LinkedHashSet<String>(abbrs);
                customValues.remove(abbreviation);
                this.myActionId2Abbreviations.put(actionId, customValues);
            }
        }
    }
}

