/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.impl.dir;

import com.intellij.diff.DiffContentFactory;
import com.intellij.diff.chains.DiffRequestProducerException;
import com.intellij.diff.contents.DiffContent;
import com.intellij.diff.contents.EmptyContent;
import com.intellij.diff.impl.CacheDiffRequestProcessor;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.diff.requests.SimpleDiffRequest;
import com.intellij.diff.tools.util.DiffDataKeys;
import com.intellij.diff.tools.util.PrevNextDifferenceIterable;
import com.intellij.diff.util.DiffUserDataKeysEx;
import com.intellij.ide.DataManager;
import com.intellij.ide.diff.DiffElement;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.ShortcutProvider;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.diff.impl.dir.DirDiffElementImpl;
import com.intellij.openapi.diff.impl.dir.DirDiffModelListener;
import com.intellij.openapi.diff.impl.dir.DirDiffTableCellRenderer;
import com.intellij.openapi.diff.impl.dir.DirDiffTableModel;
import com.intellij.openapi.diff.impl.dir.DirDiffWindow;
import com.intellij.openapi.diff.impl.dir.actions.DirDiffToolbarActions;
import com.intellij.openapi.diff.impl.dir.actions.RefreshDirDiffAction;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.pom.Navigatable;
import com.intellij.ui.ClickListener;
import com.intellij.ui.FilterComponent;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.TableSpeedSearch;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBLoadingPanel;
import com.intellij.ui.components.JBLoadingPanelListener;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.table.JBTable;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import javax.swing.text.JTextComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DirDiffPanel
implements Disposable,
DataProvider {
    public static final String DIVIDER_PROPERTY = "dir.diff.panel.divider.location";
    private static final int DIVIDER_PROPERTY_DEFAULT_VALUE = 200;
    private JPanel myDiffPanel;
    private JBTable myTable;
    private JPanel myComponent;
    private JSplitPane mySplitPanel;
    private TextFieldWithBrowseButton mySourceDirField;
    private TextFieldWithBrowseButton myTargetDirField;
    private JBLabel myTargetDirLabel;
    private JBLabel mySourceDirLabel;
    private JPanel myToolBarPanel;
    private JPanel myRootPanel;
    private JPanel myFilterPanel;
    private JBLabel myFilterLabel;
    private JPanel myFilesPanel;
    private JPanel myHeaderPanel;
    private FilterComponent myFilter;
    private final DirDiffTableModel myModel;
    private final DirDiffWindow myDiffWindow;
    private final MyDiffRequestProcessor myDiffRequestProcessor;
    private final PrevNextDifferenceIterable myPrevNextDifferenceIterable;
    private String oldFilter;
    public static final DataKey<DirDiffTableModel> DIR_DIFF_MODEL = DataKey.create((String)"DIR_DIFF_MODEL");
    public static final DataKey<JTable> DIR_DIFF_TABLE = DataKey.create((String)"DIR_DIFF_TABLE");

    public DirDiffPanel(DirDiffTableModel model, DirDiffWindow wnd) {
        Dimension preferredSize;
        this.myModel = model;
        this.myDiffWindow = wnd;
        this.$$$setupUI$$$();
        this.mySourceDirField.setText(model.getSourceDir().getPath());
        this.myTargetDirField.setText(model.getTargetDir().getPath());
        this.mySourceDirField.setBorder((Border)JBUI.Borders.emptyRight((int)8));
        this.myTargetDirField.setBorder((Border)JBUI.Borders.emptyRight((int)12));
        this.mySourceDirLabel.setIcon(model.getSourceDir().getIcon());
        this.myTargetDirLabel.setIcon(model.getTargetDir().getIcon());
        this.myTargetDirLabel.setBorder((Border)JBUI.Borders.emptyLeft((int)8));
        this.myModel.setTable(this.myTable);
        this.myModel.setPanel(this);
        Disposer.register((Disposable)this, (Disposable)this.myModel);
        this.myTable.setModel((TableModel)this.myModel);
        new TableSpeedSearch((JTable)this.myTable);
        DirDiffTableCellRenderer renderer = new DirDiffTableCellRenderer();
        this.myTable.setExpandableItemsEnabled(false);
        this.myTable.setDefaultRenderer(Object.class, (TableCellRenderer)renderer);
        this.myTable.getSelectionModel().setSelectionMode(2);
        final Project project = this.myModel.getProject();
        this.myTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                int ind;
                ListSelectionModel selectionModel = (ListSelectionModel)e.getSource();
                int lastIndex = e.getLastIndex();
                int firstIndex = e.getFirstIndex();
                DirDiffElementImpl last = DirDiffPanel.this.myModel.getElementAt(lastIndex);
                DirDiffElementImpl first = DirDiffPanel.this.myModel.getElementAt(firstIndex);
                if (last == null || first == null) {
                    DirDiffPanel.this.update(false);
                    return;
                }
                if (last.isSeparator() && selectionModel.isSelectedIndex(lastIndex)) {
                    ind = lastIndex + (lastIndex < firstIndex ? 1 : -1);
                    selectionModel.addSelectionInterval(ind, ind);
                }
                if (first.isSeparator() && selectionModel.isSelectedIndex(firstIndex)) {
                    ind = firstIndex + (firstIndex < lastIndex ? 1 : -1);
                    selectionModel.addSelectionInterval(ind, ind);
                } else {
                    DirDiffPanel.this.update(false);
                }
                DirDiffPanel.this.myDiffWindow.setTitle(DirDiffPanel.this.myModel.getTitle());
            }
        });
        if (model.isOperationsEnabled()) {
            new AnAction("Change diff operation"){

                public void actionPerformed(AnActionEvent e) {
                    DirDiffPanel.this.changeOperationForSelection();
                }
            }.registerCustomShortcutSet((ShortcutSet)CustomShortcutSet.fromString((String[])new String[]{"SPACE"}), (JComponent)this.myTable);
            new ClickListener(){

                public boolean onClick(@NotNull MouseEvent e, int clickCount) {
                    if (e == null) {
                        3.$$$reportNull$$$0(0);
                    }
                    if (e.getButton() == 3) {
                        return false;
                    }
                    if (DirDiffPanel.this.myTable.getRowCount() > 0) {
                        int row = DirDiffPanel.this.myTable.rowAtPoint(e.getPoint());
                        int col = DirDiffPanel.this.myTable.columnAtPoint(e.getPoint());
                        if (row != -1 && col == (DirDiffPanel.this.myTable.getColumnCount() - 1) / 2) {
                            DirDiffPanel.this.changeOperationForSelection();
                        }
                    }
                    return true;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/diff/impl/dir/DirDiffPanel$3", "onClick"));
                }
            }.installOn((Component)this.myTable);
        }
        this.myTable.addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                int keyCode = e.getKeyCode();
                int row = keyCode == 40 ? DirDiffPanel.this.getNextRow() : (keyCode == 38 ? DirDiffPanel.this.getPrevRow() : -1);
                if (row != -1) {
                    DirDiffPanel.this.selectRow(row, e.isShiftDown());
                    e.consume();
                }
            }
        });
        TableColumnModel columnModel = this.myTable.getColumnModel();
        TableColumn operationColumn = columnModel.getColumn((columnModel.getColumnCount() - 1) / 2);
        operationColumn.setMaxWidth(JBUI.scale((int)25));
        operationColumn.setMinWidth(JBUI.scale((int)25));
        for (int i = 0; i < columnModel.getColumnCount(); ++i) {
            String name = this.myModel.getColumnName(i);
            TableColumn column = columnModel.getColumn(i);
            if ("Date".equals(name)) {
                column.setMaxWidth(JBUI.scale((int)90));
                column.setMinWidth(JBUI.scale((int)90));
                continue;
            }
            if (!"Size".equals(name)) continue;
            column.setMaxWidth(JBUI.scale((int)120));
            column.setMinWidth(JBUI.scale((int)120));
        }
        DirDiffToolbarActions actions = new DirDiffToolbarActions(this.myModel, this.myDiffPanel);
        final ActionManager actionManager = ActionManager.getInstance();
        ActionToolbar toolbar = actionManager.createActionToolbar("DirDiff", (ActionGroup)actions, true);
        this.registerCustomShortcuts(actions, (JComponent)this.myTable);
        this.myToolBarPanel.add((Component)toolbar.getComponent(), "Center");
        if (model.isOperationsEnabled()) {
            JBLabel label = new JBLabel("Use Space button or mouse click to change operation for the selected elements. Enter to perform.", 0);
            label.setForeground(UIUtil.getInactiveTextColor());
            UIUtil.applyStyle((UIUtil.ComponentStyle)UIUtil.ComponentStyle.MINI, (Component)label);
            this.myFilesPanel.add((Component)label, "South");
        }
        DataManager.registerDataProvider((JComponent)this.myFilesPanel, (DataProvider)this);
        this.myTable.addMouseListener((MouseListener)new PopupHandler(){

            public void invokePopup(Component comp, int x, int y) {
                JPopupMenu popupMenu = actionManager.createActionPopupMenu("DirDiffPanel", (ActionGroup)actionManager.getAction("DirDiffMenu")).getComponent();
                popupMenu.show(comp, x, y);
            }
        });
        JBLoadingPanel loadingPanel = new JBLoadingPanel((LayoutManager)new BorderLayout(), wnd.getDisposable());
        loadingPanel.addListener((JBLoadingPanelListener)new JBLoadingPanelListener.Adapter(){
            boolean showHelp = true;

            public void onLoadingFinish() {
                long count;
                if (this.showHelp && DirDiffPanel.this.myModel.isOperationsEnabled() && DirDiffPanel.this.myModel.getRowCount() > 0 && (count = PropertiesComponent.getInstance().getOrInitLong("dir.diff.space.button.info", 0L)) < 3L) {
                    JBPopupFactory.getInstance().createBalloonBuilder((JComponent)new JLabel(" Use Space button to change operation")).setFadeoutTime(5000L).setContentInsets((Insets)JBUI.insets((int)15)).createBalloon().show(new RelativePoint((Component)DirDiffPanel.this.myTable, new Point(DirDiffPanel.this.myTable.getWidth() / 2, 0)), Balloon.Position.above);
                    PropertiesComponent.getInstance().setValue("dir.diff.space.button.info", String.valueOf(count + 1L));
                }
                this.showHelp = false;
            }
        });
        loadingPanel.add((Component)this.myComponent, (Object)"Center");
        UIUtil.putClientProperty((JComponent)this.myTable, DirDiffTableModel.DECORATOR_KEY, (Object)loadingPanel);
        this.myTable.addComponentListener((ComponentListener)new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent e) {
                DirDiffPanel.this.myTable.removeComponentListener((ComponentListener)this);
                DirDiffPanel.this.myModel.reloadModel(false);
            }
        });
        this.myRootPanel.removeAll();
        this.myRootPanel.add((Component)loadingPanel, "Center");
        this.myFilter = new MyFilterComponent();
        this.myModel.addModelListener(new DirDiffModelListener(){

            @Override
            public void updateStarted() {
                UIUtil.setEnabled((Component)DirDiffPanel.this.myFilter, (boolean)false, (boolean)true);
            }

            @Override
            public void updateFinished() {
                UIUtil.setEnabled((Component)DirDiffPanel.this.myFilter, (boolean)true, (boolean)true);
            }
        });
        this.myFilter.getTextEditor().setColumns(10);
        this.myFilter.setFilter(this.myModel.getSettings().getFilter());
        this.oldFilter = this.myFilter.getFilter();
        this.myFilterPanel.add((Component)this.myFilter, "Center");
        this.myFilterLabel.setLabelFor((Component)this.myFilter);
        Callable srcChooser = this.myModel.getSourceDir().getElementChooser(project);
        Callable trgChooser = this.myModel.getTargetDir().getElementChooser(project);
        this.mySourceDirField.setEditable(false);
        this.myTargetDirField.setEditable(false);
        if (srcChooser != null && this.myModel.getSettings().enableChoosers) {
            this.mySourceDirField.setButtonEnabled(true);
            this.mySourceDirField.addActionListener((ActionListener)new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    try {
                        Callable chooser = DirDiffPanel.this.myModel.getSourceDir().getElementChooser(project);
                        if (chooser == null) {
                            return;
                        }
                        DiffElement newElement = (DiffElement)chooser.call();
                        if (newElement != null && !StringUtil.equals((CharSequence)DirDiffPanel.this.mySourceDirField.getText(), (CharSequence)newElement.getPath())) {
                            DirDiffPanel.this.myModel.setSourceDir(newElement);
                            DirDiffPanel.this.mySourceDirField.setText(newElement.getPath());
                            String shortcutsText = KeymapUtil.getShortcutsText((Shortcut[])RefreshDirDiffAction.REFRESH_SHORTCUT.getShortcuts());
                            DirDiffPanel.this.myModel.clearWithMessage("Source or Target has been changed. Please run Refresh (" + shortcutsText + ")");
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            });
        } else {
            preferredSize = this.mySourceDirField.getPreferredSize();
            this.mySourceDirField.setButtonEnabled(false);
            this.mySourceDirField.getButton().setVisible(false);
            this.mySourceDirField.setPreferredSize(preferredSize);
        }
        if (trgChooser != null && this.myModel.getSettings().enableChoosers) {
            this.myTargetDirField.setButtonEnabled(true);
            this.myTargetDirField.addActionListener((ActionListener)new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    try {
                        Callable chooser = DirDiffPanel.this.myModel.getTargetDir().getElementChooser(project);
                        if (chooser == null) {
                            return;
                        }
                        DiffElement newElement = (DiffElement)chooser.call();
                        if (newElement != null) {
                            DirDiffPanel.this.myModel.setTargetDir(newElement);
                            DirDiffPanel.this.myTargetDirField.setText(newElement.getPath());
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            });
        } else {
            preferredSize = this.myTargetDirField.getPreferredSize();
            this.myTargetDirField.setButtonEnabled(false);
            this.myTargetDirField.getButton().setVisible(false);
            this.myTargetDirField.setPreferredSize(preferredSize);
        }
        this.myDiffRequestProcessor = new MyDiffRequestProcessor(project);
        Disposer.register((Disposable)this, (Disposable)this.myDiffRequestProcessor);
        this.myDiffPanel.add((Component)this.myDiffRequestProcessor.getComponent(), "Center");
        this.myPrevNextDifferenceIterable = new MyPrevNextDifferenceIterable();
    }

    private int getNextRow() {
        DirDiffElementImpl element;
        if (this.myTable.getSelectedRows().length == 0) {
            return -1;
        }
        int rowCount = this.myTable.getRowCount();
        int row = this.myTable.getSelectionModel().getLeadSelectionIndex();
        do {
            if (row >= rowCount) {
                return -1;
            }
            if ((element = this.myModel.getElementAt(++row)) != null) continue;
            return -1;
        } while (element.isSeparator());
        return row;
    }

    private int getPrevRow() {
        DirDiffElementImpl element;
        if (this.myTable.getSelectedRows().length == 0) {
            return -1;
        }
        int row = this.myTable.getSelectionModel().getLeadSelectionIndex();
        do {
            if (row <= 0) {
                return -1;
            }
            if ((element = this.myModel.getElementAt(--row)) != null) continue;
            return -1;
        } while (element.isSeparator());
        return row;
    }

    private void selectRow(int row, boolean extend) {
        if (row == -1) {
            return;
        }
        DirDiffElementImpl element = this.myModel.getElementAt(row);
        if (element == null || element.isSeparator()) {
            return;
        }
        this.myTable.changeSelection(row, (this.myModel.getColumnCount() - 1) / 2, false, extend);
    }

    public AnAction[] getActions() {
        return new DirDiffToolbarActions(this.myModel, this.myDiffPanel).getChildren(null);
    }

    public JComponent extractFilterPanel() {
        this.myHeaderPanel.setVisible(false);
        return this.myFilterPanel;
    }

    private void changeOperationForSelection() {
        for (int row : this.myTable.getSelectedRows()) {
            DirDiffElementImpl element;
            if (row == -1 || (element = this.myModel.getElementAt(row)) == null) continue;
            element.setNextOperation();
            this.myModel.fireTableRowsUpdated(row, row);
        }
    }

    public void update(boolean force) {
        this.myDiffRequestProcessor.updateRequest(force);
    }

    private void registerCustomShortcuts(DirDiffToolbarActions actions, JComponent component) {
        for (AnAction action : actions.getChildren(null)) {
            ShortcutSet shortcut;
            if (!(action instanceof ShortcutProvider) || (shortcut = ((ShortcutProvider)action).getShortcut()) == null) continue;
            action.registerCustomShortcutSet(shortcut, component);
        }
    }

    public void focusTable() {
        Project project = this.myModel.getProject();
        IdeFocusManager focusManager = project == null || project.isDefault() ? IdeFocusManager.getGlobalInstance() : IdeFocusManager.getInstance((Project)project);
        focusManager.requestFocus((Component)this.myTable, true);
    }

    public String getFilter() {
        return this.myFilter.getFilter();
    }

    private void fireFilterUpdated() {
        String newFilter = this.myFilter.getFilter();
        if (!StringUtil.equals((CharSequence)this.oldFilter, (CharSequence)newFilter)) {
            this.oldFilter = newFilter;
            this.myModel.getSettings().setFilter(newFilter);
            this.myModel.applySettings();
        }
    }

    public JComponent getPanel() {
        return this.myRootPanel;
    }

    public JBTable getTable() {
        return this.myTable;
    }

    public void dispose() {
        this.myModel.stopUpdating();
        PropertiesComponent.getInstance().setValue(DIVIDER_PROPERTY, this.mySplitPanel.getDividerLocation(), 200);
    }

    private void createUIComponents() {
        this.mySourceDirField = new TextFieldWithBrowseButton(null, (Disposable)this);
        this.myTargetDirField = new TextFieldWithBrowseButton(null, (Disposable)this);
        final AtomicBoolean callUpdate = new AtomicBoolean(true);
        this.myRootPanel = new JPanel(new BorderLayout()){

            @Override
            protected void paintChildren(Graphics g) {
                super.paintChildren(g);
                if (callUpdate.get()) {
                    callUpdate.set(false);
                    DirDiffPanel.this.myModel.reloadModel(false);
                }
            }
        };
    }

    public void setupSplitter() {
        int value = PropertiesComponent.getInstance().getInt(DIVIDER_PROPERTY, 200);
        this.mySplitPanel.setDividerLocation(value);
    }

    public Object getData(@NonNls String dataId) {
        if (CommonDataKeys.PROJECT.is(dataId)) {
            return this.myModel.getProject();
        }
        if (DIR_DIFF_MODEL.is(dataId)) {
            return this.myModel;
        }
        if (DIR_DIFF_TABLE.is(dataId)) {
            return this.myTable;
        }
        if (DiffDataKeys.NAVIGATABLE_ARRAY.is(dataId)) {
            return this.getNavigatableArray();
        }
        if (DiffDataKeys.PREV_NEXT_DIFFERENCE_ITERABLE.is(dataId)) {
            return this.myPrevNextDifferenceIterable;
        }
        return null;
    }

    @Nullable
    private Navigatable[] getNavigatableArray() {
        Project project = this.myModel.getProject();
        List<DirDiffElementImpl> elements = this.myModel.getSelectedElements();
        ArrayList<Navigatable> navigatables = new ArrayList<Navigatable>();
        for (DirDiffElementImpl element : elements) {
            Navigatable navigatable2;
            DiffElement source = element.getSource();
            DiffElement target2 = element.getTarget();
            Navigatable navigatable1 = source != null ? source.getNavigatable(project) : null;
            Navigatable navigatable = navigatable2 = target2 != null ? target2.getNavigatable(project) : null;
            if (navigatable1 != null) {
                navigatables.add(navigatable1);
            }
            if (navigatable2 == null) continue;
            navigatables.add(navigatable2);
        }
        return (Navigatable[])ArrayUtil.toObjectArray(navigatables, Navigatable.class);
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBTable jBTable;
        JPanel jPanel;
        JBLabel jBLabel;
        JPanel jPanel2;
        JPanel jPanel3;
        JPanel jPanel4;
        JBLabel jBLabel2;
        JBLabel jBLabel3;
        JPanel jPanel5;
        JSplitPane jSplitPane;
        JPanel jPanel6;
        this.createUIComponents();
        JPanel jPanel7 = this.myRootPanel;
        jPanel7.setLayout(new BorderLayout(0, 0));
        this.myComponent = jPanel6 = new JPanel();
        jPanel6.setLayout(new BorderLayout(0, 0));
        jPanel7.add((Component)jPanel6, "Center");
        this.mySplitPanel = jSplitPane = new JSplitPane();
        jSplitPane.setDividerLocation(422);
        jSplitPane.setOrientation(0);
        jPanel6.add((Component)jSplitPane, "Center");
        jSplitPane.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(), null, 0, 0, null, null));
        this.myDiffPanel = jPanel5 = new JPanel();
        jPanel5.setLayout(new BorderLayout(0, 0));
        jSplitPane.setRightComponent(jPanel5);
        JPanel jPanel8 = new JPanel();
        jPanel8.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jSplitPane.setLeftComponent(jPanel8);
        JPanel jPanel9 = new JPanel();
        jPanel9.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel8.add((Component)jPanel9, new GridConstraints(0, 0, 1, 1, 1, 1, 7, 0, null, null, null));
        JPanel jPanel10 = new JPanel();
        jPanel10.setLayout(new BorderLayout(0, 0));
        jPanel9.add((Component)jPanel10, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.mySourceDirLabel = jBLabel3 = new JBLabel();
        jPanel10.add((Component)jBLabel3, "West");
        TextFieldWithBrowseButton textFieldWithBrowseButton = this.mySourceDirField;
        jPanel10.add((Component)textFieldWithBrowseButton, "Center");
        JPanel jPanel11 = new JPanel();
        jPanel11.setLayout(new BorderLayout(0, 0));
        jPanel9.add((Component)jPanel11, new GridConstraints(1, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myTargetDirLabel = jBLabel2 = new JBLabel();
        jPanel11.add((Component)jBLabel2, "West");
        TextFieldWithBrowseButton textFieldWithBrowseButton2 = this.myTargetDirField;
        jPanel11.add((Component)textFieldWithBrowseButton2, "Center");
        JPanel jPanel12 = new JPanel();
        jPanel12.setLayout(new BorderLayout(0, 0));
        jPanel9.add((Component)jPanel12, new GridConstraints(0, 0, 1, 2, 0, 3, 7, 3, null, null, null));
        this.myHeaderPanel = jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel12.add((Component)jPanel4, "Center");
        this.myToolBarPanel = jPanel3 = new JPanel();
        jPanel3.setLayout(new BorderLayout(0, 0));
        jPanel4.add((Component)jPanel3, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myFilterPanel = jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout(0, 0));
        jPanel4.add((Component)jPanel2, new GridConstraints(0, 2, 1, 1, 1, 1, 0, 0, null, null, null));
        this.myFilterLabel = jBLabel = new JBLabel();
        jBLabel.setHorizontalAlignment(2);
        jBLabel.setIconTextGap(0);
        jBLabel.setText("Filter:");
        jBLabel.setDisplayedMnemonic('F');
        jBLabel.setDisplayedMnemonicIndex(0);
        jPanel2.add((Component)jBLabel, "West");
        Spacer spacer = new Spacer();
        jPanel4.add((Component)spacer, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        this.myFilesPanel = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel8.add((Component)jPanel, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JBScrollPane jBScrollPane = new JBScrollPane();
        jPanel.add((Component)jBScrollPane, "Center");
        this.myTable = jBTable = new JBTable();
        jBTable.setIntercellSpacing(new Dimension(0, 0));
        jBTable.setShowHorizontalLines(false);
        jBTable.setShowVerticalLines(false);
        jBScrollPane.setViewportView((Component)jBTable);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myRootPanel;
    }

    private class MyFilterComponent
    extends FilterComponent {
        public MyFilterComponent() {
            super("dir.diff.filter", 15, false);
            DumbAwareAction.create(e -> this.userTriggeredFilter()).registerCustomShortcutSet(CommonShortcuts.ENTER, (JComponent)((Object)this));
        }

        public void filter() {
            DirDiffPanel.this.fireFilterUpdated();
        }

        protected void onEscape(@NotNull KeyEvent e) {
            if (e == null) {
                MyFilterComponent.$$$reportNull$$$0(0);
            }
            e.consume();
            DirDiffPanel.this.focusTable();
        }

        protected JComponent getPopupLocationComponent() {
            return UIUtil.findComponentOfType((JComponent)super.getPopupLocationComponent(), JTextComponent.class);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/diff/impl/dir/DirDiffPanel$MyFilterComponent", "onEscape"));
        }
    }

    private static class ElementWrapper {
        @Nullable
        public final DiffElement sourceElement;
        @Nullable
        public final DiffElement targetElement;

        public ElementWrapper(@NotNull DirDiffElementImpl element) {
            if (element == null) {
                ElementWrapper.$$$reportNull$$$0(0);
            }
            this.sourceElement = element.getSource();
            this.targetElement = element.getTarget();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ElementWrapper wrapper = (ElementWrapper)o;
            if (this.sourceElement != null ? !this.sourceElement.equals(wrapper.sourceElement) : wrapper.sourceElement != null) {
                return false;
            }
            return !(this.targetElement != null ? !this.targetElement.equals(wrapper.targetElement) : wrapper.targetElement != null);
        }

        public int hashCode() {
            int result2 = this.sourceElement != null ? this.sourceElement.hashCode() : 0;
            result2 = 31 * result2 + (this.targetElement != null ? this.targetElement.hashCode() : 0);
            return result2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/openapi/diff/impl/dir/DirDiffPanel$ElementWrapper", "<init>"));
        }
    }

    private class MyDiffRequestProcessor
    extends CacheDiffRequestProcessor<ElementWrapper> {
        public MyDiffRequestProcessor(Project project) {
            super(project, "DirDiff");
        }

        @Override
        @Nullable
        protected String getRequestName(@NotNull ElementWrapper element) {
            if (element == null) {
                MyDiffRequestProcessor.$$$reportNull$$$0(0);
            }
            return null;
        }

        @Override
        protected ElementWrapper getCurrentRequestProvider() {
            DirDiffElementImpl element = DirDiffPanel.this.myModel.getElementAt(DirDiffPanel.this.myTable.getSelectedRow());
            return element != null ? new ElementWrapper(element) : null;
        }

        @Override
        @NotNull
        protected DiffRequest loadRequest(@NotNull ElementWrapper element, @NotNull ProgressIndicator indicator) throws ProcessCanceledException, DiffRequestProducerException {
            if (element == null) {
                MyDiffRequestProcessor.$$$reportNull$$$0(1);
            }
            if (indicator == null) {
                MyDiffRequestProcessor.$$$reportNull$$$0(2);
            }
            Project project = DirDiffPanel.this.myModel.getProject();
            DiffElement sourceElement = element.sourceElement;
            DiffElement targetElement = element.targetElement;
            EmptyContent sourceContent = sourceElement != null ? sourceElement.createDiffContent(project, indicator) : DiffContentFactory.getInstance().createEmpty();
            EmptyContent targetContent = targetElement != null ? targetElement.createDiffContent(project, indicator) : DiffContentFactory.getInstance().createEmpty();
            SimpleDiffRequest simpleDiffRequest = new SimpleDiffRequest(null, (DiffContent)sourceContent, (DiffContent)targetContent, null, null);
            if (simpleDiffRequest == null) {
                MyDiffRequestProcessor.$$$reportNull$$$0(3);
            }
            return simpleDiffRequest;
        }

        @Override
        protected boolean hasNextChange() {
            return DirDiffPanel.this.getNextRow() != -1;
        }

        @Override
        protected boolean hasPrevChange() {
            return DirDiffPanel.this.getPrevRow() != -1;
        }

        @Override
        protected void goToNextChange(boolean fromDifferences) {
            DirDiffPanel.this.selectRow(DirDiffPanel.this.getNextRow(), false);
            this.updateRequest(false, fromDifferences ? DiffUserDataKeysEx.ScrollToPolicy.FIRST_CHANGE : null);
        }

        @Override
        protected void goToPrevChange(boolean fromDifferences) {
            DirDiffPanel.this.selectRow(DirDiffPanel.this.getPrevRow(), false);
            this.updateRequest(false, fromDifferences ? DiffUserDataKeysEx.ScrollToPolicy.LAST_CHANGE : null);
        }

        @Override
        protected boolean isNavigationEnabled() {
            return DirDiffPanel.this.myModel.getRowCount() > 0;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "indicator";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/diff/impl/dir/DirDiffPanel$MyDiffRequestProcessor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/diff/impl/dir/DirDiffPanel$MyDiffRequestProcessor";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "loadRequest";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getRequestName";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "loadRequest";
                    break;
                }
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private class MyPrevNextDifferenceIterable
    implements PrevNextDifferenceIterable {
        private MyPrevNextDifferenceIterable() {
        }

        @Override
        public boolean canGoPrev() {
            return DirDiffPanel.this.getPrevRow() != -1;
        }

        @Override
        public boolean canGoNext() {
            return DirDiffPanel.this.getNextRow() != -1;
        }

        @Override
        public void goPrev() {
            DirDiffPanel.this.selectRow(DirDiffPanel.this.getPrevRow(), false);
        }

        @Override
        public void goNext() {
            DirDiffPanel.this.selectRow(DirDiffPanel.this.getNextRow(), false);
        }
    }
}

