/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.actions;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.EditorSettings;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.ex.EditorSettingsExternalizable;
import com.intellij.openapi.editor.impl.SettingsImpl;
import com.intellij.openapi.editor.impl.softwrap.SoftWrapAppliancePlaces;
import com.intellij.openapi.project.DumbAware;
import java.awt.Point;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractToggleUseSoftWrapsAction
extends ToggleAction
implements DumbAware {
    private final SoftWrapAppliancePlaces myAppliancePlace;
    private final boolean myGlobal;

    public AbstractToggleUseSoftWrapsAction(@NotNull SoftWrapAppliancePlaces appliancePlace, boolean global) {
        if (appliancePlace == null) {
            AbstractToggleUseSoftWrapsAction.$$$reportNull$$$0(0);
        }
        this.myAppliancePlace = appliancePlace;
        this.myGlobal = global;
    }

    public void update(@NotNull AnActionEvent e) {
        EditorSettings settings;
        Editor editor;
        if (e == null) {
            AbstractToggleUseSoftWrapsAction.$$$reportNull$$$0(1);
        }
        if (this.myGlobal && (editor = this.getEditor(e)) != null && (settings = editor.getSettings()) instanceof SettingsImpl && ((SettingsImpl)settings).getSoftWrapAppliancePlace() != this.myAppliancePlace) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        super.update(e);
    }

    public boolean isSelected(AnActionEvent e) {
        if (this.myGlobal) {
            return EditorSettingsExternalizable.getInstance().isUseSoftWraps(this.myAppliancePlace);
        }
        Editor editor = this.getEditor(e);
        return editor != null && editor.getSettings().isUseSoftWraps();
    }

    public void setSelected(AnActionEvent e, boolean state) {
        Editor editor = this.getEditor(e);
        if (editor == null) {
            return;
        }
        AbstractToggleUseSoftWrapsAction.toggleSoftWraps(editor, this.myGlobal ? this.myAppliancePlace : null, state);
    }

    public static void toggleSoftWraps(@NotNull Editor editor, @Nullable SoftWrapAppliancePlaces places, boolean state) {
        if (editor == null) {
            AbstractToggleUseSoftWrapsAction.$$$reportNull$$$0(2);
        }
        Point point = editor.getScrollingModel().getVisibleArea().getLocation();
        LogicalPosition anchorPosition = editor.xyToLogicalPosition(point);
        int intraLineShift = point.y - editor.logicalPositionToXY((LogicalPosition)anchorPosition).y;
        if (places != null) {
            EditorSettingsExternalizable.getInstance().setUseSoftWraps(state, places);
            EditorFactory.getInstance().refreshAllEditors();
        }
        if (editor.getSettings().isUseSoftWraps() != state) {
            editor.getSettings().setUseSoftWraps(state);
        }
        editor.getScrollingModel().disableAnimation();
        editor.getScrollingModel().scrollVertically(editor.logicalPositionToXY((LogicalPosition)anchorPosition).y + intraLineShift);
        editor.getScrollingModel().enableAnimation();
    }

    @Nullable
    protected Editor getEditor(AnActionEvent e) {
        return (Editor)e.getData(CommonDataKeys.EDITOR);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "appliancePlace";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/editor/actions/AbstractToggleUseSoftWrapsAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "toggleSoftWraps";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

