/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.actions;

import com.intellij.application.options.CodeStyle;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorBundle;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.editor.ReadOnlyFragmentModificationException;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.actionSystem.EditorAction;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.actionSystem.EditorActionManager;
import com.intellij.openapi.editor.actionSystem.EditorWriteActionHandler;
import com.intellij.openapi.editor.actions.EditorActionUtil;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.util.EditorUIUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TabAction
extends EditorAction {
    public TabAction() {
        super((EditorActionHandler)new Handler());
        this.setInjectedContext(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void insertTabAtCaret(Editor editor, @NotNull Caret caret, @Nullable Project project) {
        if (caret == null) {
            TabAction.$$$reportNull$$$0(0);
        }
        EditorUIUtil.hideCursorInEditor(editor);
        int columnNumber = caret.hasSelection() ? editor.visualToLogicalPosition((VisualPosition)caret.getSelectionStartPosition()).column : editor.getCaretModel().getLogicalPosition().column;
        CodeStyleSettings settings = project != null ? CodeStyle.getSettings((Project)project) : CodeStyle.getDefaultSettings();
        Document doc = editor.getDocument();
        CommonCodeStyleSettings.IndentOptions indentOptions = settings.getIndentOptionsByDocument(project, doc);
        int tabSize = indentOptions.INDENT_SIZE;
        int spacesToAddCount = tabSize - columnNumber % Math.max(1, tabSize);
        boolean useTab = editor.getSettings().isUseTabCharacter(project);
        CharSequence chars = doc.getCharsSequence();
        if (useTab && indentOptions.SMART_TABS) {
            int offset = editor.getCaretModel().getOffset();
            while (offset > 0) {
                if (chars.charAt(--offset) == '\t') continue;
                if (chars.charAt(offset) == '\n') break;
                useTab = false;
                break;
            }
        }
        doc.startGuardedBlockChecking();
        try {
            EditorModificationUtil.insertStringAtCaret((Editor)editor, (String)(useTab ? "\t" : StringUtil.repeatSymbol((char)' ', (int)spacesToAddCount)), (boolean)false, (boolean)true);
        }
        catch (ReadOnlyFragmentModificationException e) {
            EditorActionManager.getInstance().getReadonlyFragmentModificationHandler(doc).handle(e);
        }
        finally {
            doc.stopGuardedBlockChecking();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "caret", "com/intellij/openapi/editor/actions/TabAction", "insertTabAtCaret"));
    }

    public static class Handler
    extends EditorWriteActionHandler {
        public Handler() {
            super(true);
        }

        public void executeWriteAction(Editor editor, @Nullable Caret caret, DataContext dataContext) {
            if (caret == null) {
                caret = editor.getCaretModel().getPrimaryCaret();
            }
            CommandProcessor.getInstance().setCurrentCommandGroupId(EditorActionUtil.EDIT_COMMAND_GROUP);
            CommandProcessor.getInstance().setCurrentCommandName(EditorBundle.message((String)"typing.command.name", (Object[])new Object[0]));
            Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
            TabAction.insertTabAtCaret(editor, caret, project);
        }

        public boolean isEnabled(Editor editor, DataContext dataContext) {
            return !editor.isOneLineMode() && !((EditorEx)editor).isEmbeddedIntoDialogWrapper() && !editor.isViewer();
        }
    }
}

