/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.ex.util;

import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.ex.util.LayerDescriptor;
import com.intellij.openapi.editor.ex.util.LayeredHighlighterIterator;
import com.intellij.openapi.editor.ex.util.LexerEditorHighlighter;
import com.intellij.openapi.editor.ex.util.LimitedRangeHighlighterIterator;
import com.intellij.openapi.editor.ex.util.SegmentArray;
import com.intellij.openapi.editor.ex.util.SegmentArrayWithData;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.highlighter.HighlighterClient;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.editor.impl.DocumentImpl;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.openapi.fileTypes.SyntaxHighlighterBase;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.containers.FactoryMap;
import com.intellij.util.containers.IntArrayList;
import com.intellij.util.text.MergingCharSequence;
import gnu.trove.TIntIntHashMap;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LayeredLexerEditorHighlighter
extends LexerEditorHighlighter {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.editor.ex.util.LayeredLexerEditorHighlighter");
    private final Map<IElementType, LayerDescriptor> myTokensToLayer;
    private final Map<LayerDescriptor, Mapper> myLayerBuffers;

    public LayeredLexerEditorHighlighter(@NotNull SyntaxHighlighter highlighter, @NotNull EditorColorsScheme scheme2) {
        if (highlighter == null) {
            LayeredLexerEditorHighlighter.$$$reportNull$$$0(0);
        }
        if (scheme2 == null) {
            LayeredLexerEditorHighlighter.$$$reportNull$$$0(1);
        }
        super(highlighter, scheme2);
        this.myTokensToLayer = new HashMap<IElementType, LayerDescriptor>();
        this.myLayerBuffers = new HashMap<LayerDescriptor, Mapper>();
    }

    @Override
    protected SegmentArrayWithData createSegments() {
        return new MappingSegments();
    }

    public synchronized void registerLayer(IElementType tokenType, LayerDescriptor layerHighlighter) {
        this.myTokensToLayer.put(tokenType, layerHighlighter);
        this.getSegments().removeAll();
    }

    public synchronized void unregisterLayer(IElementType tokenType) {
        LayerDescriptor layer = this.myTokensToLayer.remove(tokenType);
        if (layer != null) {
            this.myLayerBuffers.remove(layer);
            this.getSegments().removeAll();
        }
    }

    @Override
    public MappingSegments getSegments() {
        return (MappingSegments)super.getSegments();
    }

    @Override
    public void setText(@NotNull CharSequence text) {
        if (text == null) {
            LayeredLexerEditorHighlighter.$$$reportNull$$$0(2);
        }
        if (this.updateLayers()) {
            this.resetText(text);
        } else {
            super.setText(text);
        }
    }

    @Override
    protected LexerEditorHighlighter.TokenProcessor createTokenProcessor(final int startIndex) {
        return new LexerEditorHighlighter.TokenProcessor(){
            final Map<Mapper, LightMapper> docTexts;
            {
                super(LayeredLexerEditorHighlighter.this);
                this.docTexts = FactoryMap.create(key -> {
                    MappedRange predecessor = ((Mapper)key).findPredecessor(startIndex);
                    return new LightMapper((Mapper)key, predecessor != null ? predecessor.range.getEndOffset() : 0);
                });
            }

            @Override
            public void addToken(int i, int startOffset, int endOffset, int data, IElementType tokenType) {
                LayeredLexerEditorHighlighter.this.getSegments().setElementLight(i, startOffset, endOffset, data);
                Mapper mapper = LayeredLexerEditorHighlighter.this.getMappingDocument(tokenType);
                if (mapper != null) {
                    this.docTexts.get(mapper).addToken(LayeredLexerEditorHighlighter.this.myText.subSequence(startOffset, endOffset), tokenType, i);
                }
            }

            @Override
            public void finish() {
                for (LightMapper mapper : this.docTexts.values()) {
                    mapper.finish();
                }
            }
        };
    }

    protected boolean updateLayers() {
        return false;
    }

    protected boolean updateLayers(@NotNull DocumentEvent e) {
        if (e == null) {
            LayeredLexerEditorHighlighter.$$$reportNull$$$0(3);
        }
        return this.updateLayers();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void documentChanged(DocumentEvent e) {
        boolean changed = this.updateLayers(e);
        LayeredLexerEditorHighlighter layeredLexerEditorHighlighter = this;
        synchronized (layeredLexerEditorHighlighter) {
            if (changed) {
                super.setText(e.getDocument().getImmutableCharSequence());
            } else {
                super.documentChanged(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    @NotNull
    public HighlighterIterator createIterator(int startOffset) {
        LayeredLexerEditorHighlighter layeredLexerEditorHighlighter = this;
        // MONITORENTER : layeredLexerEditorHighlighter
        LayeredHighlighterIteratorImpl layeredHighlighterIteratorImpl = new LayeredHighlighterIteratorImpl(startOffset);
        // MONITOREXIT : layeredLexerEditorHighlighter
        if (layeredHighlighterIteratorImpl != null) return layeredHighlighterIteratorImpl;
        LayeredLexerEditorHighlighter.$$$reportNull$$$0(4);
        return layeredHighlighterIteratorImpl;
    }

    @NotNull
    public HighlighterIterator createBaseIterator(int startOffset) {
        HighlighterIterator highlighterIterator = super.createIterator(startOffset);
        if (highlighterIterator == null) {
            LayeredLexerEditorHighlighter.$$$reportNull$$$0(5);
        }
        return highlighterIterator;
    }

    @Nullable
    private Mapper getMappingDocument(IElementType token) {
        LayerDescriptor descriptor = this.myTokensToLayer.get(token);
        if (descriptor == null) {
            return null;
        }
        Mapper mapper = this.myLayerBuffers.get(descriptor);
        if (mapper == null) {
            mapper = new Mapper(descriptor);
            this.myLayerBuffers.put(descriptor, mapper);
        }
        return mapper;
    }

    @Override
    public void setColorScheme(@NotNull EditorColorsScheme scheme2) {
        if (scheme2 == null) {
            LayeredLexerEditorHighlighter.$$$reportNull$$$0(6);
        }
        super.setColorScheme(scheme2);
        for (MappedRange mapping : this.getSegments().myRanges) {
            Mapper mapper;
            Mapper mapper2 = mapper = mapping == null ? null : mapping.mapper;
            if (mapper == null) continue;
            mapper.resetCachedTextAttributes();
        }
    }

    @Override
    protected boolean hasAdditionalData(int segmentIndex) {
        return this.getSegments().myRanges[segmentIndex] != null;
    }

    @NotNull
    private static <T> T[] reallocateArray(@NotNull T[] array, int index) {
        if (array == null) {
            LayeredLexerEditorHighlighter.$$$reportNull$$$0(7);
        }
        if (index < array.length) {
            if (array == null) {
                LayeredLexerEditorHighlighter.$$$reportNull$$$0(8);
            }
            return array;
        }
        Object[] newArray = (Object[])Array.newInstance(array.getClass().getComponentType(), SegmentArray.calcCapacity(array.length, index));
        System.arraycopy(array, 0, newArray, 0, array.length);
        if (newArray == null) {
            LayeredLexerEditorHighlighter.$$$reportNull$$$0(9);
        }
        return newArray;
    }

    @Override
    public String toString() {
        return this.myText.toString();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 8: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 8: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "highlighter";
                break;
            }
            case 1: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scheme";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 4: 
            case 5: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/editor/ex/util/LayeredLexerEditorHighlighter";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "array";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/editor/ex/util/LayeredLexerEditorHighlighter";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createIterator";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createBaseIterator";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "reallocateArray";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setText";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "updateLayers";
                break;
            }
            case 4: 
            case 5: 
            case 8: 
            case 9: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "setColorScheme";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "reallocateArray";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 8: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class LayeredHighlighterIteratorImpl
    implements LayeredHighlighterIterator {
        private final HighlighterIterator myBaseIterator;
        private HighlighterIterator myLayerIterator;
        private int myLayerStartOffset;
        private Mapper myCurrentMapper;

        private LayeredHighlighterIteratorImpl(int offset) {
            this.myBaseIterator = LayeredLexerEditorHighlighter.this.createBaseIterator(offset);
            if (!this.myBaseIterator.atEnd()) {
                int shift = offset - this.myBaseIterator.getStart();
                this.initLayer(shift);
            }
        }

        private void initLayer(int shiftInToken) {
            if (this.myBaseIterator.atEnd()) {
                this.myLayerIterator = null;
                this.myCurrentMapper = null;
                return;
            }
            MappedRange mapping = LayeredLexerEditorHighlighter.this.getSegments().myRanges[((LexerEditorHighlighter.HighlighterIteratorImpl)this.myBaseIterator).currentIndex()];
            if (mapping != null) {
                this.myCurrentMapper = mapping.mapper;
                this.myLayerIterator = this.myCurrentMapper.createIterator(mapping, shiftInToken);
                this.myLayerStartOffset = this.myBaseIterator.getStart() - mapping.range.getStartOffset();
            } else {
                this.myCurrentMapper = null;
                this.myLayerIterator = null;
            }
        }

        public TextAttributes getTextAttributes() {
            if (this.myCurrentMapper != null) {
                return this.myCurrentMapper.getAttributes(this.getTokenType());
            }
            return this.myBaseIterator.getTextAttributes();
        }

        @Override
        public SyntaxHighlighter getActiveSyntaxHighlighter() {
            if (this.myCurrentMapper != null) {
                return this.myCurrentMapper.mySyntaxHighlighter;
            }
            return LayeredLexerEditorHighlighter.this.getSyntaxHighlighter();
        }

        public int getStart() {
            if (this.myLayerIterator != null) {
                return this.myLayerIterator.getStart() + this.myLayerStartOffset;
            }
            return this.myBaseIterator.getStart();
        }

        public int getEnd() {
            if (this.myLayerIterator != null) {
                return this.myLayerIterator.getEnd() + this.myLayerStartOffset;
            }
            return this.myBaseIterator.getEnd();
        }

        public IElementType getTokenType() {
            return this.myLayerIterator != null ? this.myLayerIterator.getTokenType() : this.myBaseIterator.getTokenType();
        }

        public void advance() {
            if (this.myLayerIterator != null) {
                this.myLayerIterator.advance();
                if (!this.myLayerIterator.atEnd()) {
                    return;
                }
            }
            this.myBaseIterator.advance();
            this.initLayer(0);
        }

        public void retreat() {
            if (this.myLayerIterator != null) {
                this.myLayerIterator.retreat();
                if (!this.myLayerIterator.atEnd()) {
                    return;
                }
            }
            this.myBaseIterator.retreat();
            this.initLayer(this.myBaseIterator.atEnd() ? 0 : this.myBaseIterator.getEnd() - this.myBaseIterator.getStart() - 1);
        }

        public boolean atEnd() {
            return this.myBaseIterator.atEnd();
        }

        public Document getDocument() {
            return this.myBaseIterator.getDocument();
        }
    }

    private static class MappedRange {
        private RangeMarker range;
        private final Mapper mapper;
        private final IElementType outerToken;

        MappedRange(@NotNull Mapper mapper, @NotNull RangeMarker range2, @NotNull IElementType outerToken) {
            if (mapper == null) {
                MappedRange.$$$reportNull$$$0(0);
            }
            if (range2 == null) {
                MappedRange.$$$reportNull$$$0(1);
            }
            if (outerToken == null) {
                MappedRange.$$$reportNull$$$0(2);
            }
            this.mapper = mapper;
            this.range = range2;
            this.outerToken = outerToken;
            assert (mapper.doc == range2.getDocument());
        }

        public String toString() {
            return "MappedRange{range=" + this.range + ", outerToken=" + this.outerToken + '}';
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "mapper";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "range";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "outerToken";
                    break;
                }
            }
            objectArray[1] = "com/intellij/openapi/editor/ex/util/LayeredLexerEditorHighlighter$MappedRange";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class Mapper
    implements HighlighterClient {
        private final DocumentImpl doc;
        private final EditorHighlighter highlighter;
        private final String mySeparator;
        private final Map<IElementType, TextAttributes> myAttributesMap = new HashMap<IElementType, TextAttributes>();
        private final SyntaxHighlighter mySyntaxHighlighter;
        private final TextAttributesKey myBackground;

        private Mapper(LayerDescriptor descriptor) {
            this.doc = new DocumentImpl("", true);
            this.mySyntaxHighlighter = descriptor.getLayerHighlighter();
            this.myBackground = descriptor.getBackgroundKey();
            this.highlighter = new LexerEditorHighlighter(this.mySyntaxHighlighter, LayeredLexerEditorHighlighter.this.getScheme());
            this.mySeparator = descriptor.getTokenSeparator();
            this.highlighter.setEditor((HighlighterClient)this);
            this.doc.addDocumentListener((DocumentListener)this.highlighter);
        }

        public TextAttributes getAttributes(IElementType tokenType) {
            TextAttributes attrs = this.myAttributesMap.get(tokenType);
            if (attrs == null) {
                attrs = LayeredLexerEditorHighlighter.this.convertAttributes(SyntaxHighlighterBase.pack((TextAttributesKey)this.myBackground, (TextAttributesKey[])this.mySyntaxHighlighter.getTokenHighlights(tokenType)));
                this.myAttributesMap.put(tokenType, attrs);
            }
            return attrs;
        }

        public HighlighterIterator createIterator(MappedRange mapper, int shift) {
            int rangeStart = mapper.range.getStartOffset();
            int rangeEnd = mapper.range.getEndOffset();
            return new LimitedRangeHighlighterIterator(this.highlighter.createIterator(rangeStart + shift), rangeStart, rangeEnd);
        }

        public Project getProject() {
            return LayeredLexerEditorHighlighter.this.getClient().getProject();
        }

        public void repaint(int start, int end) {
        }

        public Document getDocument() {
            return LayeredLexerEditorHighlighter.this.getDocument();
        }

        public void resetCachedTextAttributes() {
            this.myAttributesMap.clear();
        }

        public void updateMapping(int tokenIndex, MappedRange oldMapping) {
            CharSequence tokenText = this.getTokenText(tokenIndex);
            int start = oldMapping.range.getStartOffset();
            int end = oldMapping.range.getEndOffset();
            if (Comparing.equal((CharSequence)this.doc.getCharsSequence().subSequence(start, end), (CharSequence)tokenText)) {
                return;
            }
            this.doc.replaceString(start, end, tokenText);
            int newEnd = start + tokenText.length();
            if (oldMapping.range.getStartOffset() != start || oldMapping.range.getEndOffset() != newEnd) {
                assert (oldMapping.range.getDocument() == this.doc);
                oldMapping.range.dispose();
                oldMapping.range = this.doc.createRangeMarker(start, newEnd);
            }
        }

        @NotNull
        private MappedRange insertMapping(int tokenIndex, IElementType outerToken) {
            CharSequence tokenText = this.getTokenText(tokenIndex);
            int length = tokenText.length();
            MappedRange predecessor = this.findPredecessor(tokenIndex);
            int insertOffset = predecessor != null ? predecessor.range.getEndOffset() : 0;
            this.doc.insertString(insertOffset, (CharSequence)new MergingCharSequence((CharSequence)this.mySeparator, tokenText));
            RangeMarker marker = this.doc.createRangeMarker(insertOffset += this.mySeparator.length(), insertOffset + length);
            MappedRange mappedRange = new MappedRange(this, marker, outerToken);
            if (mappedRange == null) {
                Mapper.$$$reportNull$$$0(0);
            }
            return mappedRange;
        }

        private CharSequence getTokenText(int tokenIndex) {
            return LayeredLexerEditorHighlighter.this.myText.subSequence(LayeredLexerEditorHighlighter.this.getSegments().getSegmentStart(tokenIndex), LayeredLexerEditorHighlighter.this.getSegments().getSegmentEnd(tokenIndex));
        }

        @Nullable
        private MappedRange findPredecessor(int token) {
            --token;
            while (token >= 0) {
                MappedRange mappedRange = LayeredLexerEditorHighlighter.this.getSegments().myRanges[token];
                if (mappedRange != null && mappedRange.mapper == this) {
                    return mappedRange;
                }
                --token;
            }
            return null;
        }

        private void removeMapping(MappedRange mapping) {
            RangeMarker rangeMarker = mapping.range;
            if (rangeMarker.isValid()) {
                int start = rangeMarker.getStartOffset();
                int end = rangeMarker.getEndOffset();
                assert (this.doc == rangeMarker.getDocument());
                this.doc.deleteString(start - this.mySeparator.length(), end);
                rangeMarker.dispose();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/ex/util/LayeredLexerEditorHighlighter$Mapper", "insertMapping"));
        }
    }

    private class MappingSegments
    extends SegmentArrayWithData {
        private MappedRange[] myRanges = new MappedRange[64];

        private MappingSegments() {
        }

        @Override
        public void removeAll() {
            if (this.mySegmentCount != 0) {
                Arrays.fill(this.myRanges, null);
            }
            LayeredLexerEditorHighlighter.this.myLayerBuffers.clear();
            super.removeAll();
        }

        @Override
        public void setElementAt(int i, int startOffset, int endOffset, int data) {
            this.setElementLight(i, startOffset, endOffset, (short)data);
            MappedRange range2 = this.myRanges[i];
            if (range2 != null) {
                range2.mapper.removeMapping(range2);
                this.myRanges[i] = null;
            }
            this.updateMappingForToken(i);
        }

        private void setElementLight(int i, int startOffset, int endOffset, int data) {
            super.setElementAt(i, startOffset, endOffset, data);
            this.myRanges = (MappedRange[])LayeredLexerEditorHighlighter.reallocateArray(this.myRanges, i + 1);
        }

        @Override
        public void remove(int startIndex, int endIndex) {
            Map mins = FactoryMap.create(key -> Integer.MAX_VALUE);
            Map maxs = FactoryMap.create(key -> 0);
            for (int i = startIndex; i < endIndex; ++i) {
                MappedRange range2 = this.myRanges[i];
                if (range2 != null && range2.range.isValid()) {
                    mins.put(range2.mapper, Math.min((Integer)mins.get(range2.mapper), range2.range.getStartOffset()));
                    maxs.put(range2.mapper, Math.max((Integer)maxs.get(range2.mapper), range2.range.getEndOffset()));
                }
                this.myRanges[i] = null;
            }
            for (Mapper mapper : maxs.keySet()) {
                mapper.doc.deleteString((Integer)mins.get(mapper), (Integer)maxs.get(mapper));
            }
            this.myRanges = this.remove(this.myRanges, startIndex, endIndex);
            super.remove(startIndex, endIndex);
        }

        @Override
        public void replace(int startOffset, @NotNull SegmentArrayWithData data, int len) {
            if (data == null) {
                MappingSegments.$$$reportNull$$$0(0);
            }
            super.replace(startOffset, data, len);
            for (int i = startOffset; i < startOffset + len; ++i) {
                this.updateMappingForToken(i);
            }
        }

        @NotNull
        private <T> T[] insert(@NotNull T[] array, @NotNull T[] insertArray, int startIndex, int insertLength) {
            if (array == null) {
                MappingSegments.$$$reportNull$$$0(1);
            }
            if (insertArray == null) {
                MappingSegments.$$$reportNull$$$0(2);
            }
            Object[] newArray = LayeredLexerEditorHighlighter.reallocateArray(array, this.mySegmentCount + insertLength);
            if (startIndex < this.mySegmentCount) {
                System.arraycopy(newArray, startIndex, newArray, startIndex + insertLength, this.mySegmentCount - startIndex);
            }
            System.arraycopy(insertArray, 0, newArray, startIndex, insertLength);
            if (newArray == null) {
                MappingSegments.$$$reportNull$$$0(3);
            }
            return newArray;
        }

        @NotNull
        private <T> T[] remove(@NotNull T[] array, int startIndex, int endIndex) {
            if (array == null) {
                MappingSegments.$$$reportNull$$$0(4);
            }
            if (endIndex < this.mySegmentCount) {
                System.arraycopy(array, endIndex, array, startIndex, this.mySegmentCount - endIndex);
            }
            Arrays.fill(array, this.mySegmentCount - (endIndex - startIndex), this.mySegmentCount, null);
            if (array == null) {
                MappingSegments.$$$reportNull$$$0(5);
            }
            return array;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void insert(@NotNull SegmentArrayWithData segmentArray, int startIndex) {
            if (segmentArray == null) {
                MappingSegments.$$$reportNull$$$0(6);
            }
            LayeredLexerEditorHighlighter layeredLexerEditorHighlighter = LayeredLexerEditorHighlighter.this;
            synchronized (layeredLexerEditorHighlighter) {
                super.insert(segmentArray, startIndex);
                int newCount = segmentArray.getSegmentCount();
                MappedRange[] newRanges = new MappedRange[newCount];
                this.myRanges = this.insert(this.myRanges, newRanges, startIndex, newCount);
                int endIndex = startIndex + segmentArray.getSegmentCount();
                LexerEditorHighlighter.TokenProcessor processor2 = LayeredLexerEditorHighlighter.this.createTokenProcessor(startIndex);
                for (int i = startIndex; i < endIndex; ++i) {
                    short data = this.getSegmentData(i);
                    IElementType token = LexerEditorHighlighter.unpackToken(data);
                    processor2.addToken(i, this.getSegmentStart(i), this.getSegmentEnd(i), data, token);
                }
                processor2.finish();
            }
        }

        private void updateMappingForToken(int i) {
            short data = this.getSegmentData(i);
            IElementType token = LexerEditorHighlighter.unpackToken(data);
            Mapper mapper = LayeredLexerEditorHighlighter.this.getMappingDocument(token);
            MappedRange oldMapping = this.myRanges[i];
            if (mapper != null) {
                if (oldMapping != null) {
                    if (oldMapping.mapper == mapper && oldMapping.outerToken == token) {
                        mapper.updateMapping(i, oldMapping);
                    } else {
                        oldMapping.mapper.removeMapping(oldMapping);
                        this.myRanges[i] = mapper.insertMapping(i, token);
                    }
                } else {
                    this.myRanges[i] = mapper.insertMapping(i, token);
                }
            } else if (oldMapping != null) {
                oldMapping.mapper.removeMapping(oldMapping);
                this.myRanges[i] = null;
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "data";
                    break;
                }
                case 1: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "array";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "insertArray";
                    break;
                }
                case 3: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/editor/ex/util/LayeredLexerEditorHighlighter$MappingSegments";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "segmentArray";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/editor/ex/util/LayeredLexerEditorHighlighter$MappingSegments";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "insert";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "remove";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "replace";
                    break;
                }
                case 1: 
                case 2: 
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "insert";
                    break;
                }
                case 3: 
                case 5: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "remove";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private class LightMapper {
        final Mapper mapper;
        final StringBuilder text = new StringBuilder();
        final IntArrayList lengths = new IntArrayList();
        final List<IElementType> tokenTypes = new ArrayList<IElementType>();
        final TIntIntHashMap index2Global = new TIntIntHashMap();
        private final String mySeparator;
        final int insertOffset;

        LightMapper(Mapper mapper, int insertOffset) {
            this.mapper = mapper;
            this.mySeparator = mapper.mySeparator;
            this.insertOffset = insertOffset;
        }

        void addToken(CharSequence tokenText, IElementType tokenType, int globalIndex) {
            this.index2Global.put(this.tokenTypes.size(), globalIndex);
            this.text.append(this.mySeparator).append(tokenText);
            this.lengths.add(tokenText.length());
            this.tokenTypes.add(tokenType);
        }

        void finish() {
            assert (this.insertOffset >= 0);
            DocumentImpl document = this.mapper.doc;
            document.insertString(this.insertOffset, this.text);
            int start = this.insertOffset;
            for (int i = 0; i < this.tokenTypes.size(); ++i) {
                IElementType type = this.tokenTypes.get(i);
                int len = this.lengths.get(i);
                int globalIndex = this.index2Global.get(i);
                this.checkNull(type, LayeredLexerEditorHighlighter.this.getSegments().myRanges[globalIndex]);
                ((MappingSegments)LayeredLexerEditorHighlighter.this.getSegments()).myRanges[globalIndex] = new MappedRange(this.mapper, document.createRangeMarker(start += this.mySeparator.length(), start + len), type);
                start += len;
            }
        }

        private void checkNull(IElementType type, MappedRange range2) {
            if (range2 != null) {
                Document mainDocument = LayeredLexerEditorHighlighter.this.getDocument();
                VirtualFile file2 = mainDocument == null ? null : FileDocumentManager.getInstance().getFile(mainDocument);
                LOG.error("Expected null range on " + type + ", found " + range2 + "; highlighter=" + LayeredLexerEditorHighlighter.this.getSyntaxHighlighter(), new Attachment[]{new Attachment(file2 != null ? file2.getName() : "editorText.txt", LayeredLexerEditorHighlighter.this.myText.toString())});
            }
        }
    }
}

