/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileTypes.impl;

import com.intellij.CommonBundle;
import com.intellij.ide.highlighter.custom.SyntaxTable;
import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileTypes.FileNameMatcher;
import com.intellij.openapi.fileTypes.FileNameMatcherEx;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.fileTypes.FileTypesBundle;
import com.intellij.openapi.fileTypes.UserFileType;
import com.intellij.openapi.fileTypes.impl.AbstractFileType;
import com.intellij.openapi.fileTypes.impl.FileTypeAssocTable;
import com.intellij.openapi.fileTypes.impl.FileTypeManagerImpl;
import com.intellij.openapi.fileTypes.impl.FileTypePatternDialog;
import com.intellij.openapi.fileTypes.impl.FileTypeRenderer;
import com.intellij.openapi.options.BaseConfigurable;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.ui.DialogBuilder;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.psi.templateLanguages.TemplateDataLanguagePatterns;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.AnActionButtonRunnable;
import com.intellij.ui.AnActionButtonUpdater;
import com.intellij.ui.DoubleClickListener;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.ListSpeedSearch;
import com.intellij.ui.ListUtil;
import com.intellij.ui.ScrollingUtil;
import com.intellij.ui.SpeedSearchBase;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.components.JBList;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.ui.JBDimension;
import gnu.trove.THashMap;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileTypeConfigurable
extends BaseConfigurable
implements SearchableConfigurable,
Configurable.NoScroll {
    private RecognizedFileTypes myRecognizedFileType;
    private PatternsPanel myPatterns;
    private FileTypePanel myFileTypePanel;
    private HashSet<FileType> myTempFileTypes;
    private final FileTypeManagerImpl myManager;
    private FileTypeAssocTable<FileType> myTempPatternsTable;
    private final Map<FileNameMatcher, FileType> myReassigned = new THashMap();
    private FileTypeAssocTable<Language> myTempTemplateDataLanguages;
    private final Map<UserFileType, UserFileType> myOriginalToEditedMap = new HashMap<UserFileType, UserFileType>();

    public FileTypeConfigurable(FileTypeManager fileTypeManager) {
        this.myManager = (FileTypeManagerImpl)fileTypeManager;
    }

    public String getDisplayName() {
        return FileTypesBundle.message("filetype.settings.title", new Object[0]);
    }

    public JComponent createComponent() {
        this.myFileTypePanel = new FileTypePanel();
        this.myRecognizedFileType = this.myFileTypePanel.myRecognizedFileType;
        this.myPatterns = this.myFileTypePanel.myPatterns;
        this.myRecognizedFileType.attachActions(this);
        this.myRecognizedFileType.myFileTypesList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(@Nullable ListSelectionEvent e) {
                FileTypeConfigurable.this.updateExtensionList();
            }
        });
        this.myPatterns.attachActions(this);
        this.myFileTypePanel.myIgnoreFilesField.setColumns(30);
        return this.myFileTypePanel.getComponent();
    }

    private void updateFileTypeList() {
        FileType[] types = this.myTempFileTypes.toArray(new FileType[this.myTempFileTypes.size()]);
        Arrays.sort(types, (o1, o2) -> {
            FileType fileType1 = o1;
            FileType fileType2 = o2;
            return fileType1.getDescription().compareToIgnoreCase(fileType2.getDescription());
        });
        this.myRecognizedFileType.setFileTypes(types);
    }

    @NotNull
    private static FileType[] getModifiableFileTypes() {
        FileType[] registeredFileTypes = FileTypeManager.getInstance().getRegisteredFileTypes();
        ArrayList<FileType> result2 = new ArrayList<FileType>();
        for (FileType fileType : registeredFileTypes) {
            if (fileType.isReadOnly()) continue;
            result2.add(fileType);
        }
        FileType[] fileTypeArray = result2.toArray(new FileType[result2.size()]);
        if (fileTypeArray == null) {
            FileTypeConfigurable.$$$reportNull$$$0(0);
        }
        return fileTypeArray;
    }

    public void apply() {
        Set<UserFileType> modifiedUserTypes = this.myOriginalToEditedMap.keySet();
        for (UserFileType oldType : modifiedUserTypes) {
            oldType.copyFrom(this.myOriginalToEditedMap.get(oldType));
        }
        this.myOriginalToEditedMap.clear();
        ApplicationManager.getApplication().runWriteAction(() -> {
            if (!this.myManager.isIgnoredFilesListEqualToCurrent(this.myFileTypePanel.myIgnoreFilesField.getText())) {
                this.myManager.setIgnoredFilesList(this.myFileTypePanel.myIgnoreFilesField.getText());
            }
            this.myManager.setPatternsTable(this.myTempFileTypes, this.myTempPatternsTable);
            for (FileNameMatcher matcher : this.myReassigned.keySet()) {
                this.myManager.getRemovedMappings().put(matcher, (Pair<FileType, Boolean>)Pair.create((Object)this.myReassigned.get(matcher), (Object)true));
            }
            TemplateDataLanguagePatterns.getInstance().setAssocTable(this.myTempTemplateDataLanguages);
        });
    }

    public void reset() {
        this.myTempPatternsTable = this.myManager.getExtensionMap().copy();
        this.myTempTemplateDataLanguages = TemplateDataLanguagePatterns.getInstance().getAssocTable();
        this.myTempFileTypes = new HashSet<FileType>(Arrays.asList(FileTypeConfigurable.getModifiableFileTypes()));
        this.myOriginalToEditedMap.clear();
        this.updateFileTypeList();
        this.updateExtensionList();
        this.myFileTypePanel.myIgnoreFilesField.setText(this.myManager.getIgnoredFilesList());
    }

    public boolean isModified() {
        if (!this.myManager.isIgnoredFilesListEqualToCurrent(this.myFileTypePanel.myIgnoreFilesField.getText())) {
            return true;
        }
        HashSet<FileType> types = new HashSet<FileType>(Arrays.asList(FileTypeConfigurable.getModifiableFileTypes()));
        return !this.myTempPatternsTable.equals((Object)this.myManager.getExtensionMap()) || !this.myTempFileTypes.equals(types) || !this.myOriginalToEditedMap.isEmpty() || !this.myTempTemplateDataLanguages.equals(TemplateDataLanguagePatterns.getInstance().getAssocTable());
    }

    public void disposeUIResources() {
        if (this.myFileTypePanel != null) {
            this.myFileTypePanel.dispose();
        }
        this.myFileTypePanel = null;
        this.myRecognizedFileType = null;
        this.myPatterns = null;
    }

    private void updateExtensionList() {
        FileType type = this.myRecognizedFileType.getSelectedFileType();
        if (type == null) {
            return;
        }
        ArrayList<String> extensions = new ArrayList<String>();
        for (FileNameMatcher assoc : this.myTempPatternsTable.getAssociations((Object)type)) {
            extensions.add(assoc.getPresentableString());
        }
        this.myPatterns.clearList();
        Collections.sort(extensions);
        for (String extension : extensions) {
            this.myPatterns.addPattern(extension);
        }
        this.myPatterns.ensureSelectionExists();
    }

    private void editFileType() {
        TypeEditor<UserFileType> editor;
        FileType fileType = this.myRecognizedFileType.getSelectedFileType();
        if (!FileTypeConfigurable.canBeModified(fileType)) {
            return;
        }
        UserFileType ftToEdit = this.myOriginalToEditedMap.get(fileType);
        if (ftToEdit == null) {
            ftToEdit = ((UserFileType)fileType).clone();
        }
        if ((editor = new TypeEditor<UserFileType>(this.myRecognizedFileType.myFileTypesList, ftToEdit, FileTypesBundle.message("filetype.edit.existing.title", new Object[0]))).showAndGet()) {
            this.myOriginalToEditedMap.put((UserFileType)fileType, ftToEdit);
        }
    }

    private void removeFileType() {
        FileType fileType = this.myRecognizedFileType.getSelectedFileType();
        if (fileType == null) {
            return;
        }
        this.myTempFileTypes.remove(fileType);
        this.myOriginalToEditedMap.remove(fileType);
        this.myTempPatternsTable.removeAllAssociations((Object)fileType);
        this.updateFileTypeList();
        this.updateExtensionList();
    }

    private static boolean canBeModified(FileType fileType) {
        return fileType instanceof AbstractFileType;
    }

    private void addFileType() {
        AbstractFileType type = new AbstractFileType(new SyntaxTable());
        TypeEditor<AbstractFileType> editor = new TypeEditor<AbstractFileType>(this.myRecognizedFileType.myFileTypesList, type, FileTypesBundle.message("filetype.edit.new.title", new Object[0]));
        if (editor.showAndGet()) {
            this.myTempFileTypes.add(type);
            this.updateFileTypeList();
            this.updateExtensionList();
            this.myRecognizedFileType.selectFileType(type);
        }
    }

    private void editPattern() {
        String item = this.myPatterns.getSelectedItem();
        if (item == null) {
            return;
        }
        this.editPattern(item);
    }

    private void editPattern(@Nullable String item) {
        FileType type = this.myRecognizedFileType.getSelectedFileType();
        if (type == null) {
            return;
        }
        String title = item == null ? FileTypesBundle.message("filetype.edit.add.pattern.title", new Object[0]) : FileTypesBundle.message("filetype.edit.edit.pattern.title", new Object[0]);
        Language oldLanguage = item == null ? null : (Language)this.myTempTemplateDataLanguages.findAssociatedFileType((CharSequence)item);
        FileTypePatternDialog dialog2 = new FileTypePatternDialog(item, type, oldLanguage);
        DialogBuilder builder = new DialogBuilder((Component)this.myPatterns);
        builder.setPreferredFocusComponent((JComponent)dialog2.getPatternField());
        builder.setCenterPanel((JComponent)dialog2.getMainPanel());
        builder.setTitle(title);
        builder.showModal(true);
        if (builder.getDialogWrapper().isOK()) {
            String pattern = dialog2.getPatternField().getText();
            if (StringUtil.isEmpty((String)pattern)) {
                return;
            }
            FileNameMatcher matcher = FileTypeManager.parseFromString((String)pattern);
            FileType registeredFileType = this.findExistingFileType(matcher);
            if (registeredFileType != null && registeredFileType != type) {
                if (registeredFileType.isReadOnly()) {
                    Messages.showMessageDialog((Component)this.myPatterns.myPatternsList, (String)FileTypesBundle.message("filetype.edit.add.pattern.exists.error", registeredFileType.getDescription()), (String)title, (Icon)Messages.getErrorIcon());
                    return;
                }
                if (0 == Messages.showOkCancelDialog((Component)this.myPatterns.myPatternsList, (String)FileTypesBundle.message("filetype.edit.add.pattern.exists.message", registeredFileType.getDescription()), (String)FileTypesBundle.message("filetype.edit.add.pattern.exists.title", new Object[0]), (String)FileTypesBundle.message("filetype.edit.add.pattern.reassign.button", new Object[0]), (String)CommonBundle.getCancelButtonText(), (Icon)Messages.getQuestionIcon())) {
                    this.myTempPatternsTable.removeAssociation(matcher, (Object)registeredFileType);
                    if (oldLanguage != null) {
                        this.myTempTemplateDataLanguages.removeAssociation(matcher, (Object)oldLanguage);
                    }
                    this.myReassigned.put(matcher, registeredFileType);
                } else {
                    return;
                }
            }
            if (item != null) {
                FileNameMatcher oldMatcher = FileTypeManager.parseFromString((String)item);
                this.myTempPatternsTable.removeAssociation(oldMatcher, (Object)type);
                if (oldLanguage != null) {
                    this.myTempTemplateDataLanguages.removeAssociation(oldMatcher, (Object)oldLanguage);
                }
            }
            this.myTempPatternsTable.addAssociation(matcher, (Object)type);
            Language language = dialog2.getTemplateDataLanguage();
            if (language != null) {
                this.myTempTemplateDataLanguages.addAssociation(matcher, (Object)language);
            }
            this.updateExtensionList();
            int index = this.myPatterns.getListModel().indexOf(matcher.getPresentableString());
            if (index >= 0) {
                ScrollingUtil.selectItem((JList)this.myPatterns.myPatternsList, (int)index);
            }
            IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus((Component)this.myPatterns.myPatternsList, true));
        }
    }

    private void addPattern() {
        this.editPattern(null);
    }

    @Nullable
    public FileType findExistingFileType(FileNameMatcher matcher) {
        FileType fileTypeByExtension = (FileType)this.myTempPatternsTable.findAssociatedFileType(matcher);
        if (fileTypeByExtension != null && fileTypeByExtension != FileTypes.UNKNOWN) {
            return fileTypeByExtension;
        }
        FileType registeredFileType = FileTypeManager.getInstance().getFileTypeByExtension(matcher.getPresentableString());
        if (registeredFileType != FileTypes.UNKNOWN && registeredFileType.isReadOnly()) {
            return registeredFileType;
        }
        return null;
    }

    @Nullable
    public FileType addNewPattern(FileType type, String pattern) {
        FileNameMatcher matcher = FileTypeManager.parseFromString((String)pattern);
        FileType existing = this.findExistingFileType(matcher);
        if (existing != null) {
            return existing;
        }
        this.myTempPatternsTable.addAssociation(matcher, (Object)type);
        this.myPatterns.addPatternAndSelect(pattern);
        IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus((Component)this.myPatterns.myPatternsList, true));
        return null;
    }

    private void removePattern() {
        FileType type = this.myRecognizedFileType.getSelectedFileType();
        if (type == null) {
            return;
        }
        String extension = this.myPatterns.removeSelected();
        if (extension == null) {
            return;
        }
        FileNameMatcher matcher = FileTypeManager.parseFromString((String)extension);
        this.myTempPatternsTable.removeAssociation(matcher, (Object)type);
        IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus((Component)this.myPatterns.myPatternsList, true));
    }

    public String getHelpTopic() {
        return "preferences.fileTypes";
    }

    @NotNull
    public String getId() {
        String string = this.getHelpTopic();
        if (string == null) {
            FileTypeConfigurable.$$$reportNull$$$0(1);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/openapi/fileTypes/impl/FileTypeConfigurable";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getModifiableFileTypes";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getId";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class TypeEditor<T extends UserFileType<T>>
    extends DialogWrapper {
        private final T myFileType;
        private final SettingsEditor<T> myEditor;

        public TypeEditor(Component parent, T fileType, String title) {
            super(parent, false);
            this.myFileType = fileType;
            this.myEditor = fileType.getEditor();
            this.setTitle(title);
            this.init();
            Disposer.register((Disposable)this.myDisposable, this.myEditor);
        }

        protected void init() {
            super.init();
            this.myEditor.resetFrom(this.myFileType);
        }

        protected JComponent createCenterPanel() {
            return this.myEditor.getComponent();
        }

        protected void doOKAction() {
            try {
                this.myEditor.applyTo(this.myFileType);
            }
            catch (ConfigurationException e) {
                Messages.showErrorDialog((Component)this.getContentPane(), (String)e.getMessage(), (String)e.getTitle());
                return;
            }
            super.doOKAction();
        }

        protected String getHelpId() {
            return "reference.dialogs.newfiletype";
        }
    }

    private static class FileTypePanel {
        private JPanel myWholePanel;
        private RecognizedFileTypes myRecognizedFileType;
        private PatternsPanel myPatterns;
        private JTextField myIgnoreFilesField;

        private FileTypePanel() {
            this.$$$setupUI$$$();
        }

        public JComponent getComponent() {
            return this.myWholePanel;
        }

        public void dispose() {
            this.myRecognizedFileType.setFileTypes(FileType.EMPTY_ARRAY);
            this.myPatterns.clearList();
        }

        private /* synthetic */ void $$$setupUI$$$() {
            JTextField jTextField;
            RecognizedFileTypes recognizedFileTypes;
            PatternsPanel patternsPanel;
            JPanel jPanel;
            this.myWholePanel = jPanel = new JPanel();
            jPanel.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
            this.myPatterns = patternsPanel = new PatternsPanel();
            jPanel.add((Component)patternsPanel, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 7, null, null, null));
            this.myRecognizedFileType = recognizedFileTypes = new RecognizedFileTypes();
            jPanel.add((Component)recognizedFileTypes, new GridConstraints(0, 0, 1, 1, 8, 3, 7, 7, null, null, null));
            JPanel jPanel2 = new JPanel();
            jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 2, 0, 0), -1, -1, false, false));
            jPanel2.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithoutIndent");
            jPanel.add((Component)jPanel2, new GridConstraints(2, 0, 1, 1, 0, 3, 3, 3, null, null, null));
            jPanel2.setBorder(IdeBorderFactory.PlainSmallWithoutIndent.createTitledBorder(null, (String)ResourceBundle.getBundle("messages/IdeBundle").getString("editbox.ignore.files.and.folders"), (int)0, (int)0, null, null));
            this.myIgnoreFilesField = jTextField = new JTextField();
            jTextField.setFocusCycleRoot(false);
            jTextField.setOpaque(true);
            jTextField.setText(".dependency-info;CVS;");
            jPanel2.add((Component)jTextField, new GridConstraints(0, 0, 1, 1, 8, 1, 7, 0, null, new Dimension(150, -1), null));
        }

        public /* synthetic */ JComponent $$$getRootComponent$$$() {
            return this.myWholePanel;
        }
    }

    public static class PatternsPanel
    extends JPanel {
        private final JBList myPatternsList = new JBList(new DefaultListModel());
        private FileTypeConfigurable myController;

        public PatternsPanel() {
            super(new BorderLayout());
            this.myPatternsList.setSelectionMode(0);
            this.myPatternsList.setCellRenderer((ListCellRenderer)new ExtensionRenderer());
            this.myPatternsList.getEmptyText().setText(FileTypesBundle.message("filetype.settings.no.patterns", new Object[0]));
            this.add((Component)ToolbarDecorator.createDecorator((JList)this.myPatternsList).setAddAction(new AnActionButtonRunnable(){

                public void run(AnActionButton button) {
                    myController.addPattern();
                }
            }).setEditAction(new AnActionButtonRunnable(){

                public void run(AnActionButton button) {
                    myController.editPattern();
                }
            }).setRemoveAction(new AnActionButtonRunnable(){

                public void run(AnActionButton button) {
                    myController.removePattern();
                }
            }).disableUpDownActions().createPanel(), "Center");
            this.setBorder((Border)IdeBorderFactory.createTitledBorder((String)FileTypesBundle.message("filetype.registered.patterns.group", new Object[0]), (boolean)false));
        }

        public void attachActions(FileTypeConfigurable controller) {
            this.myController = controller;
        }

        public JComponent getComponent() {
            return this;
        }

        public void clearList() {
            this.getListModel().clear();
            this.myPatternsList.clearSelection();
        }

        private DefaultListModel getListModel() {
            return (DefaultListModel)this.myPatternsList.getModel();
        }

        public void addPattern(String pattern) {
            this.getListModel().addElement(pattern);
        }

        public void ensureSelectionExists() {
            ScrollingUtil.ensureSelectionExists((JList)this.myPatternsList);
        }

        public void addPatternAndSelect(String pattern) {
            this.addPattern(pattern);
            ScrollingUtil.selectItem((JList)this.myPatternsList, (int)(this.getListModel().getSize() - 1));
        }

        public void select(String pattern) {
            for (int i = 0; i < this.myPatternsList.getItemsCount(); ++i) {
                FileNameMatcher matcher;
                Object at = this.myPatternsList.getModel().getElementAt(i);
                if (!(at instanceof String) || !FileNameMatcherEx.acceptsCharSequence((FileNameMatcher)(matcher = FileTypeManager.parseFromString((String)((String)at))), (CharSequence)pattern)) continue;
                ScrollingUtil.selectItem((JList)this.myPatternsList, (int)i);
                return;
            }
        }

        public String removeSelected() {
            Object selectedValue = this.myPatternsList.getSelectedValue();
            if (selectedValue == null) {
                return null;
            }
            ListUtil.removeSelectedItems((JList)this.myPatternsList);
            return (String)selectedValue;
        }

        public String getDefaultExtension() {
            return (String)this.getListModel().getElementAt(0);
        }

        public String getSelectedItem() {
            return (String)this.myPatternsList.getSelectedValue();
        }
    }

    public static class RecognizedFileTypes
    extends JPanel {
        private final JList myFileTypesList = new JBList(new DefaultListModel());
        private final MySpeedSearch mySpeedSearch;
        private FileTypeConfigurable myController;

        public RecognizedFileTypes() {
            super(new BorderLayout());
            this.myFileTypesList.setSelectionMode(0);
            this.myFileTypesList.setCellRenderer(new FileTypeRenderer(new FileTypeRenderer.FileTypeListProvider(){

                @Override
                public Iterable<FileType> getCurrentFileTypeList() {
                    ArrayList<FileType> result2 = new ArrayList<FileType>();
                    for (int i = 0; i < myFileTypesList.getModel().getSize(); ++i) {
                        result2.add((FileType)myFileTypesList.getModel().getElementAt(i));
                    }
                    return result2;
                }
            }));
            new DoubleClickListener(){

                protected boolean onDoubleClick(MouseEvent e) {
                    myController.editFileType();
                    return true;
                }
            }.installOn((Component)this.myFileTypesList);
            ToolbarDecorator toolbarDecorator = ToolbarDecorator.createDecorator((JList)this.myFileTypesList).setAddAction(new AnActionButtonRunnable(){

                public void run(AnActionButton button) {
                    myController.addFileType();
                }
            }).setRemoveAction(new AnActionButtonRunnable(){

                public void run(AnActionButton button) {
                    myController.removeFileType();
                }
            }).setEditAction(new AnActionButtonRunnable(){

                public void run(AnActionButton button) {
                    myController.editFileType();
                }
            }).setEditActionUpdater(new AnActionButtonUpdater(){

                public boolean isEnabled(AnActionEvent e) {
                    FileType fileType = this.getSelectedFileType();
                    return FileTypeConfigurable.canBeModified(fileType);
                }
            }).setRemoveActionUpdater(new AnActionButtonUpdater(){

                public boolean isEnabled(AnActionEvent e) {
                    return FileTypeConfigurable.canBeModified(this.getSelectedFileType());
                }
            }).disableUpDownActions();
            this.add((Component)toolbarDecorator.createPanel(), "Center");
            this.setBorder((Border)IdeBorderFactory.createTitledBorder((String)FileTypesBundle.message("filetype.recognized.group", new Object[0]), (boolean)false));
            this.mySpeedSearch = new MySpeedSearch(this.myFileTypesList);
        }

        public void attachActions(FileTypeConfigurable controller) {
            this.myController = controller;
            this.mySpeedSearch.myController = controller;
        }

        public FileType getSelectedFileType() {
            return (FileType)this.myFileTypesList.getSelectedValue();
        }

        public JComponent getComponent() {
            return this;
        }

        public void setFileTypes(FileType[] types) {
            DefaultListModel listModel = (DefaultListModel)this.myFileTypesList.getModel();
            listModel.clear();
            for (FileType type : types) {
                if (type == FileTypes.UNKNOWN) continue;
                listModel.addElement(type);
            }
            ScrollingUtil.ensureSelectionExists((JList)this.myFileTypesList);
        }

        public int getSelectedIndex() {
            return this.myFileTypesList.getSelectedIndex();
        }

        public void selectFileType(FileType fileType) {
            this.myFileTypesList.setSelectedValue(fileType, true);
            IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus((Component)this.myFileTypesList, true));
        }

        private static class MySpeedSearch
        extends SpeedSearchBase<JList> {
            private final List<Condition<Pair<Object, String>>> myOrderedConvertors = Arrays.asList(p -> {
                String value = p.first.toString();
                if (p.first instanceof FileType) {
                    value = ((FileType)p.first).getDescription();
                }
                return this.getComparator().matchingFragments((String)p.second, value) != null;
            }, p -> p.first instanceof FileType && this.myCurrentType != null && this.myCurrentType.equals(p.first));
            private FileTypeConfigurable myController;
            private Object myCurrentType;
            private String myExtension;

            private MySpeedSearch(JList component) {
                super(component);
            }

            @Override
            protected boolean isMatchingElement(Object element, String pattern) {
                for (Condition<Pair<Object, String>> convertor : this.myOrderedConvertors) {
                    boolean matched = convertor.value((Object)Pair.pair((Object)element, (Object)pattern));
                    if (!matched) continue;
                    return true;
                }
                return false;
            }

            @Override
            @Nullable
            protected final String getElementText(Object element) {
                throw new IllegalStateException();
            }

            @Override
            protected int getSelectedIndex() {
                return ((JList)this.myComponent).getSelectedIndex();
            }

            @Override
            protected Object[] getAllElements() {
                return ListSpeedSearch.getAllListElements((JList)this.myComponent);
            }

            @Override
            protected void selectElement(Object element, String selectedText) {
                ScrollingUtil.selectItem((JList)((JList)this.myComponent), (Object)element);
                if (this.myCurrentType != null && this.myCurrentType.equals(element) && this.myController != null) {
                    this.myController.myPatterns.select(this.myExtension);
                }
            }

            @Override
            protected void onSearchFieldUpdated(String s) {
                if (this.myController == null || this.myController.myTempPatternsTable == null) {
                    return;
                }
                int index = s.lastIndexOf(46);
                if (index < 0) {
                    s = "." + s;
                }
                this.myCurrentType = this.myController.myTempPatternsTable.findAssociatedFileType((CharSequence)s);
                this.myExtension = this.myCurrentType != null ? s : null;
            }
        }
    }

    private static class ExtensionRenderer
    extends DefaultListCellRenderer {
        private ExtensionRenderer() {
        }

        @Override
        @NotNull
        public Component getListCellRendererComponent(@NotNull JList list2, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (list2 == null) {
                ExtensionRenderer.$$$reportNull$$$0(0);
            }
            super.getListCellRendererComponent((JList<?>)list2, value, index, isSelected, cellHasFocus);
            this.setText(" " + this.getText());
            ExtensionRenderer extensionRenderer = this;
            if (extensionRenderer == null) {
                ExtensionRenderer.$$$reportNull$$$0(1);
            }
            return extensionRenderer;
        }

        @Override
        public Dimension getPreferredSize() {
            return new JBDimension(0, 20);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "list";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/fileTypes/impl/FileTypeConfigurable$ExtensionRenderer";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/fileTypes/impl/FileTypeConfigurable$ExtensionRenderer";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getListCellRendererComponent";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getListCellRendererComponent";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

