/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.options.colors.pages;

import com.intellij.application.options.colors.FontEditorPreview;
import com.intellij.application.options.colors.InspectionColorSettingsPage;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.daemon.impl.SeveritiesProvider;
import com.intellij.codeInsight.documentation.DocumentationComponent;
import com.intellij.codeInsight.hint.HintUtil;
import com.intellij.codeInsight.template.impl.TemplateColors;
import com.intellij.ide.IdeTooltipManager;
import com.intellij.openapi.editor.HighlighterColors;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.fileTypes.PlainSyntaxHighlighter;
import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.openapi.options.OptionsBundle;
import com.intellij.openapi.options.colors.AttributesDescriptor;
import com.intellij.openapi.options.colors.ColorDescriptor;
import com.intellij.openapi.options.colors.ColorSettingsPage;
import com.intellij.psi.codeStyle.DisplayPriority;
import com.intellij.psi.codeStyle.DisplayPrioritySortable;
import com.intellij.ui.EditorCustomization;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class GeneralColorsPage
implements ColorSettingsPage,
InspectionColorSettingsPage,
DisplayPrioritySortable,
EditorCustomization {
    private static final String ADDITIONAL_DEMO_TEXT = "\n<todo>//TODO: Visit JB Web resources:</todo>\nJetBrains Home Page: <hyperlink_f>http://www.jetbrains.com</hyperlink_f>\nJetBrains Developer Community: <hyperlink>https://www.jetbrains.com/devnet</hyperlink>\n<ref_hyperlink>ReferenceHyperlink</ref_hyperlink>\n\nSearch:\n  <search_result_wr>result</search_result_wr> = \"<search_text>text</search_text>, <search_text>text</search_text>, <search_text>text</search_text>\";\n  <identifier_write>i</identifier_write> = <search_result>result</search_result>\n  return <identifier>i;</identifier>\n\n<folded_text>Folded text</folded_text>\n<deleted_text>Deleted text</deleted_text>\nTemplate <template_var>VARIABLE</template_var>\nInjected language: <injected_lang>\\.(gif|jpg|png)$</injected_lang>\n\nCode Inspections:\n  <error>Error</error>\n  <warning>Warning</warning>\n  <weak_warning>Weak warning</weak_warning>\n  <deprecated>Deprecated symbol</deprecated>\n  <for_removal>Deprecated symbol marked for removal</for_removal>\n  <unused>Unused symbol</unused>\n  <wrong_ref>Unknown symbol</wrong_ref>\n  <server_error>Problem from server</server_error>\n  <server_duplicate>Duplicate from server</server_duplicate>\n" + GeneralColorsPage.getCustomSeveritiesDemoText();
    private static final AttributesDescriptor[] ATT_DESCRIPTORS = new AttributesDescriptor[]{new AttributesDescriptor(OptionsBundle.message((String)"options.general.attribute.descriptor.default.text", (Object[])new Object[0]), HighlighterColors.TEXT), new AttributesDescriptor(OptionsBundle.message((String)"options.general.attribute.descriptor.folded.text", (Object[])new Object[0]), EditorColors.FOLDED_TEXT_ATTRIBUTES), new AttributesDescriptor(OptionsBundle.message((String)"options.general.attribute.descriptor.deleted.text", (Object[])new Object[0]), EditorColors.DELETED_TEXT_ATTRIBUTES), new AttributesDescriptor(OptionsBundle.message((String)"options.general.attribute.descriptor.search.result", (Object[])new Object[0]), EditorColors.SEARCH_RESULT_ATTRIBUTES), new AttributesDescriptor(OptionsBundle.message((String)"options.general.attribute.descriptor.search.result.write.access", (Object[])new Object[0]), EditorColors.WRITE_SEARCH_RESULT_ATTRIBUTES), new AttributesDescriptor(OptionsBundle.message((String)"options.general.attribute.descriptior.identifier.under.caret", (Object[])new Object[0]), EditorColors.IDENTIFIER_UNDER_CARET_ATTRIBUTES), new AttributesDescriptor(OptionsBundle.message((String)"options.general.attribute.descriptior.identifier.under.caret.write", (Object[])new Object[0]), EditorColors.WRITE_IDENTIFIER_UNDER_CARET_ATTRIBUTES), new AttributesDescriptor(OptionsBundle.message((String)"options.general.attribute.descriptor.text.search.result", (Object[])new Object[0]), EditorColors.TEXT_SEARCH_RESULT_ATTRIBUTES), new AttributesDescriptor(OptionsBundle.message((String)"options.general.attribute.descriptor.live.template", (Object[])new Object[0]), EditorColors.LIVE_TEMPLATE_ATTRIBUTES), new AttributesDescriptor(OptionsBundle.message((String)"options.general.attribute.descriptor.template.variable", (Object[])new Object[0]), TemplateColors.TEMPLATE_VARIABLE_ATTRIBUTES), new AttributesDescriptor(OptionsBundle.message((String)"options.general.color.descriptor.injected.language.fragment", (Object[])new Object[0]), EditorColors.INJECTED_LANGUAGE_FRAGMENT), new AttributesDescriptor(OptionsBundle.message((String)"options.general.color.descriptor.hyperlink.new", (Object[])new Object[0]), CodeInsightColors.HYPERLINK_ATTRIBUTES), new AttributesDescriptor(OptionsBundle.message((String)"options.general.color.descriptor.hyperlink.followed", (Object[])new Object[0]), CodeInsightColors.FOLLOWED_HYPERLINK_ATTRIBUTES), new AttributesDescriptor(OptionsBundle.message((String)"options.general.color.descriptor.reference.hyperlink", (Object[])new Object[0]), EditorColors.REFERENCE_HYPERLINK_COLOR), new AttributesDescriptor(OptionsBundle.message((String)"options.java.attribute.descriptor.matched.brace", (Object[])new Object[0]), CodeInsightColors.MATCHED_BRACE_ATTRIBUTES), new AttributesDescriptor(OptionsBundle.message((String)"options.java.attribute.descriptor.unmatched.brace", (Object[])new Object[0]), CodeInsightColors.UNMATCHED_BRACE_ATTRIBUTES), new AttributesDescriptor(OptionsBundle.message((String)"options.general.color.descriptor.todo.defaults", (Object[])new Object[0]), CodeInsightColors.TODO_DEFAULT_ATTRIBUTES), new AttributesDescriptor(OptionsBundle.message((String)"options.general.color.descriptor.bookmarks", (Object[])new Object[0]), CodeInsightColors.BOOKMARKS_ATTRIBUTES), new AttributesDescriptor(OptionsBundle.message((String)"options.java.color.descriptor.full.coverage", (Object[])new Object[0]), CodeInsightColors.LINE_FULL_COVERAGE), new AttributesDescriptor(OptionsBundle.message((String)"options.java.color.descriptor.partial.coverage", (Object[])new Object[0]), CodeInsightColors.LINE_PARTIAL_COVERAGE), new AttributesDescriptor(OptionsBundle.message((String)"options.java.color.descriptor.none.coverage", (Object[])new Object[0]), CodeInsightColors.LINE_NONE_COVERAGE), new AttributesDescriptor(OptionsBundle.message((String)"options.general.color.descriptor.breadcrumbs.default", (Object[])new Object[0]), EditorColors.BREADCRUMBS_DEFAULT), new AttributesDescriptor(OptionsBundle.message((String)"options.general.color.descriptor.breadcrumbs.hovered", (Object[])new Object[0]), EditorColors.BREADCRUMBS_HOVERED), new AttributesDescriptor(OptionsBundle.message((String)"options.general.color.descriptor.breadcrumbs.current", (Object[])new Object[0]), EditorColors.BREADCRUMBS_CURRENT), new AttributesDescriptor(OptionsBundle.message((String)"options.general.color.descriptor.breadcrumbs.inactive", (Object[])new Object[0]), EditorColors.BREADCRUMBS_INACTIVE)};
    private static final ColorDescriptor[] COLOR_DESCRIPTORS = new ColorDescriptor[]{new ColorDescriptor(OptionsBundle.message((String)"options.general.color.descriptor.background.in.readonly.files", (Object[])new Object[0]), EditorColors.READONLY_BACKGROUND_COLOR, ColorDescriptor.Kind.BACKGROUND), new ColorDescriptor(OptionsBundle.message((String)"options.general.color.descriptor.readonly.fragment.background", (Object[])new Object[0]), EditorColors.READONLY_FRAGMENT_BACKGROUND_COLOR, ColorDescriptor.Kind.BACKGROUND), new ColorDescriptor(OptionsBundle.message((String)"options.general.color.descriptor.gutter.background", (Object[])new Object[0]), EditorColors.GUTTER_BACKGROUND, ColorDescriptor.Kind.BACKGROUND), new ColorDescriptor(OptionsBundle.message((String)"options.general.color.descriptor.notification.background", (Object[])new Object[0]), EditorColors.NOTIFICATION_BACKGROUND, ColorDescriptor.Kind.BACKGROUND), new ColorDescriptor(OptionsBundle.message((String)"options.general.color.descriptor.selection.background", (Object[])new Object[0]), EditorColors.SELECTION_BACKGROUND_COLOR, ColorDescriptor.Kind.BACKGROUND), new ColorDescriptor(OptionsBundle.message((String)"options.general.color.descriptor.selection.foreground", (Object[])new Object[0]), EditorColors.SELECTION_FOREGROUND_COLOR, ColorDescriptor.Kind.FOREGROUND), new ColorDescriptor(OptionsBundle.message((String)"options.general.color.descriptor.caret", (Object[])new Object[0]), EditorColors.CARET_COLOR, ColorDescriptor.Kind.FOREGROUND), new ColorDescriptor(OptionsBundle.message((String)"options.general.color.descriptor.caret.row", (Object[])new Object[0]), EditorColors.CARET_ROW_COLOR, ColorDescriptor.Kind.BACKGROUND), new ColorDescriptor(OptionsBundle.message((String)"options.general.color.descriptor.right.margin", (Object[])new Object[0]), EditorColors.RIGHT_MARGIN_COLOR, ColorDescriptor.Kind.FOREGROUND), new ColorDescriptor(OptionsBundle.message((String)"options.general.color.descriptor.whitespaces", (Object[])new Object[0]), EditorColors.WHITESPACES_COLOR, ColorDescriptor.Kind.FOREGROUND), new ColorDescriptor(OptionsBundle.message((String)"options.general.color.descriptor.indent.guide", (Object[])new Object[0]), EditorColors.INDENT_GUIDE_COLOR, ColorDescriptor.Kind.BACKGROUND), new ColorDescriptor(OptionsBundle.message((String)"options.general.color.descriptor.indent.guide.selected", (Object[])new Object[0]), EditorColors.SELECTED_INDENT_GUIDE_COLOR, ColorDescriptor.Kind.BACKGROUND), new ColorDescriptor(OptionsBundle.message((String)"options.general.color.descriptor.line.number", (Object[])new Object[0]), EditorColors.LINE_NUMBERS_COLOR, ColorDescriptor.Kind.FOREGROUND), new ColorDescriptor(OptionsBundle.message((String)"options.general.color.descriptor.tearline", (Object[])new Object[0]), EditorColors.TEARLINE_COLOR, ColorDescriptor.Kind.FOREGROUND), new ColorDescriptor(OptionsBundle.message((String)"options.general.color.descriptor.tearline.selected", (Object[])new Object[0]), EditorColors.SELECTED_TEARLINE_COLOR, ColorDescriptor.Kind.FOREGROUND), new ColorDescriptor(OptionsBundle.message((String)"options.general.color.descriptor.separator.above", (Object[])new Object[0]), EditorColors.SEPARATOR_ABOVE_COLOR, ColorDescriptor.Kind.FOREGROUND), new ColorDescriptor(OptionsBundle.message((String)"options.general.color.descriptor.separator.below", (Object[])new Object[0]), EditorColors.SEPARATOR_BELOW_COLOR, ColorDescriptor.Kind.FOREGROUND), new ColorDescriptor(OptionsBundle.message((String)"options.java.color.descriptor.method.separator.color", (Object[])new Object[0]), CodeInsightColors.METHOD_SEPARATORS_COLOR, ColorDescriptor.Kind.FOREGROUND), new ColorDescriptor(OptionsBundle.message((String)"options.general.color.soft.wrap.sign", (Object[])new Object[0]), EditorColors.SOFT_WRAP_SIGN_COLOR, ColorDescriptor.Kind.FOREGROUND), new ColorDescriptor(OptionsBundle.message((String)"options.general.color.descriptor.popups.documentation", (Object[])new Object[0]), DocumentationComponent.COLOR_KEY, ColorDescriptor.Kind.BACKGROUND), new ColorDescriptor(OptionsBundle.message((String)"options.general.color.descriptor.popups.information", (Object[])new Object[0]), HintUtil.INFORMATION_COLOR_KEY, ColorDescriptor.Kind.BACKGROUND), new ColorDescriptor(OptionsBundle.message((String)"options.general.color.descriptor.popups.question", (Object[])new Object[0]), HintUtil.QUESTION_COLOR_KEY, ColorDescriptor.Kind.BACKGROUND), new ColorDescriptor(OptionsBundle.message((String)"options.general.color.descriptor.popups.error", (Object[])new Object[0]), HintUtil.ERROR_COLOR_KEY, ColorDescriptor.Kind.BACKGROUND), new ColorDescriptor(OptionsBundle.message((String)"options.general.color.descriptor.popups.tooltip", (Object[])new Object[0]), IdeTooltipManager.TOOLTIP_COLOR_KEY, ColorDescriptor.Kind.BACKGROUND), new ColorDescriptor(OptionsBundle.message((String)"options.general.color.descriptor.visual.guides", (Object[])new Object[0]), EditorColors.VISUAL_INDENT_GUIDE_COLOR, ColorDescriptor.Kind.FOREGROUND)};
    private static final Map<String, TextAttributesKey> ADDITIONAL_HIGHLIGHT_DESCRIPTORS = new HashMap<String, TextAttributesKey>();
    public static final String DISPLAY_NAME = OptionsBundle.message((String)"options.general.display.name", (Object[])new Object[0]);

    @NotNull
    public String getDisplayName() {
        String string = DISPLAY_NAME;
        if (string == null) {
            GeneralColorsPage.$$$reportNull$$$0(0);
        }
        return string;
    }

    public Icon getIcon() {
        return FileTypes.PLAIN_TEXT.getIcon();
    }

    @NotNull
    public AttributesDescriptor[] getAttributeDescriptors() {
        if (ATT_DESCRIPTORS == null) {
            GeneralColorsPage.$$$reportNull$$$0(1);
        }
        return ATT_DESCRIPTORS;
    }

    @NotNull
    public ColorDescriptor[] getColorDescriptors() {
        if (COLOR_DESCRIPTORS == null) {
            GeneralColorsPage.$$$reportNull$$$0(2);
        }
        return COLOR_DESCRIPTORS;
    }

    @NotNull
    public SyntaxHighlighter getHighlighter() {
        PlainSyntaxHighlighter plainSyntaxHighlighter = new PlainSyntaxHighlighter();
        if (plainSyntaxHighlighter == null) {
            GeneralColorsPage.$$$reportNull$$$0(3);
        }
        return plainSyntaxHighlighter;
    }

    @NotNull
    public String getDemoText() {
        String string = FontEditorPreview.getIDEDemoText() + ADDITIONAL_DEMO_TEXT;
        if (string == null) {
            GeneralColorsPage.$$$reportNull$$$0(4);
        }
        return string;
    }

    public Map<String, TextAttributesKey> getAdditionalHighlightingTagToDescriptorMap() {
        return ADDITIONAL_HIGHLIGHT_DESCRIPTORS;
    }

    public DisplayPriority getPriority() {
        return DisplayPriority.GENERAL_SETTINGS;
    }

    @Override
    public void customize(@NotNull EditorEx editor) {
        if (editor == null) {
            GeneralColorsPage.$$$reportNull$$$0(5);
        }
        editor.getSettings().setSoftMargins(Arrays.asList(50, 70));
    }

    private static String getCustomSeveritiesDemoText() {
        StringBuilder buff = new StringBuilder();
        for (SeveritiesProvider provider : (SeveritiesProvider[])Extensions.getExtensions(SeveritiesProvider.EP_NAME)) {
            for (HighlightInfoType highlightInfoType : provider.getSeveritiesHighlightInfoTypes()) {
                String tag = GeneralColorsPage.getHighlightDescTagName(highlightInfoType);
                buff.append("  <").append(tag).append(">");
                buff.append(tag.toLowerCase());
                buff.append("</").append(tag).append(">").append("\n");
            }
        }
        return buff.toString();
    }

    private static String getHighlightDescTagName(HighlightInfoType highlightInfoType) {
        return highlightInfoType.getSeverity(null).myName;
    }

    static {
        ADDITIONAL_HIGHLIGHT_DESCRIPTORS.put("folded_text", EditorColors.FOLDED_TEXT_ATTRIBUTES);
        ADDITIONAL_HIGHLIGHT_DESCRIPTORS.put("deleted_text", EditorColors.DELETED_TEXT_ATTRIBUTES);
        ADDITIONAL_HIGHLIGHT_DESCRIPTORS.put("search_result", EditorColors.SEARCH_RESULT_ATTRIBUTES);
        ADDITIONAL_HIGHLIGHT_DESCRIPTORS.put("search_result_wr", EditorColors.WRITE_SEARCH_RESULT_ATTRIBUTES);
        ADDITIONAL_HIGHLIGHT_DESCRIPTORS.put("search_text", EditorColors.TEXT_SEARCH_RESULT_ATTRIBUTES);
        ADDITIONAL_HIGHLIGHT_DESCRIPTORS.put("identifier", EditorColors.IDENTIFIER_UNDER_CARET_ATTRIBUTES);
        ADDITIONAL_HIGHLIGHT_DESCRIPTORS.put("identifier_write", EditorColors.WRITE_IDENTIFIER_UNDER_CARET_ATTRIBUTES);
        ADDITIONAL_HIGHLIGHT_DESCRIPTORS.put("template_var", TemplateColors.TEMPLATE_VARIABLE_ATTRIBUTES);
        ADDITIONAL_HIGHLIGHT_DESCRIPTORS.put("injected_lang", EditorColors.INJECTED_LANGUAGE_FRAGMENT);
        ADDITIONAL_HIGHLIGHT_DESCRIPTORS.put("todo", CodeInsightColors.TODO_DEFAULT_ATTRIBUTES);
        ADDITIONAL_HIGHLIGHT_DESCRIPTORS.put("hyperlink", CodeInsightColors.HYPERLINK_ATTRIBUTES);
        ADDITIONAL_HIGHLIGHT_DESCRIPTORS.put("hyperlink_f", CodeInsightColors.FOLLOWED_HYPERLINK_ATTRIBUTES);
        ADDITIONAL_HIGHLIGHT_DESCRIPTORS.put("ref_hyperlink", EditorColors.REFERENCE_HYPERLINK_COLOR);
        ADDITIONAL_HIGHLIGHT_DESCRIPTORS.put("wrong_ref", CodeInsightColors.WRONG_REFERENCES_ATTRIBUTES);
        ADDITIONAL_HIGHLIGHT_DESCRIPTORS.put("deprecated", CodeInsightColors.DEPRECATED_ATTRIBUTES);
        ADDITIONAL_HIGHLIGHT_DESCRIPTORS.put("for_removal", CodeInsightColors.MARKED_FOR_REMOVAL_ATTRIBUTES);
        ADDITIONAL_HIGHLIGHT_DESCRIPTORS.put("unused", CodeInsightColors.NOT_USED_ELEMENT_ATTRIBUTES);
        ADDITIONAL_HIGHLIGHT_DESCRIPTORS.put("error", CodeInsightColors.ERRORS_ATTRIBUTES);
        ADDITIONAL_HIGHLIGHT_DESCRIPTORS.put("warning", CodeInsightColors.WARNINGS_ATTRIBUTES);
        ADDITIONAL_HIGHLIGHT_DESCRIPTORS.put("weak_warning", CodeInsightColors.WEAK_WARNING_ATTRIBUTES);
        ADDITIONAL_HIGHLIGHT_DESCRIPTORS.put("server_error", CodeInsightColors.GENERIC_SERVER_ERROR_OR_WARNING);
        ADDITIONAL_HIGHLIGHT_DESCRIPTORS.put("server_duplicate", CodeInsightColors.DUPLICATE_FROM_SERVER);
        for (SeveritiesProvider provider : (SeveritiesProvider[])Extensions.getExtensions(SeveritiesProvider.EP_NAME)) {
            for (HighlightInfoType highlightInfoType : provider.getSeveritiesHighlightInfoTypes()) {
                ADDITIONAL_HIGHLIGHT_DESCRIPTORS.put(GeneralColorsPage.getHighlightDescTagName(highlightInfoType), highlightInfoType.getAttributesKey());
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 5: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 5: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/options/colors/pages/GeneralColorsPage";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getAttributeDescriptors";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getColorDescriptors";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getHighlighter";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getDemoText";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/options/colors/pages/GeneralColorsPage";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "customize";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 5: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

