/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.options.newEditor;

import com.intellij.icons.AllIcons;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.util.treeView.AbstractTreeStructure;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurableGroup;
import com.intellij.openapi.options.OptionsBundle;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.options.UnnamedConfigurable;
import com.intellij.openapi.options.ex.ConfigurableWrapper;
import com.intellij.openapi.options.ex.SortedConfigurableGroup;
import com.intellij.openapi.options.newEditor.CopyAction;
import com.intellij.openapi.options.newEditor.OptionsEditorColleague;
import com.intellij.openapi.options.newEditor.SettingsFilter;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.ui.CellRendererPanel;
import com.intellij.ui.Gray;
import com.intellij.ui.HeldDownKeyListener;
import com.intellij.ui.JBColor;
import com.intellij.ui.RelativeFont;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.TreeUIHelper;
import com.intellij.ui.components.GradientViewport;
import com.intellij.ui.speedSearch.ElementFilter;
import com.intellij.ui.treeStructure.CachingSimpleNode;
import com.intellij.ui.treeStructure.SimpleNode;
import com.intellij.ui.treeStructure.SimpleTree;
import com.intellij.ui.treeStructure.SimpleTreeStructure;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.ui.treeStructure.filtered.FilteringTreeBuilder;
import com.intellij.ui.treeStructure.filtered.FilteringTreeStructure;
import com.intellij.util.ui.GraphicsUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.tree.TreeUtil;
import com.intellij.util.ui.tree.WideSelectionTreeUI;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.datatransfer.Transferable;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.List;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.JViewport;
import javax.swing.TransferHandler;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.plaf.TreeUI;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SettingsTreeView
extends JComponent
implements Accessible,
Disposable,
OptionsEditorColleague {
    private static final int ICON_GAP = 5;
    private static final String NODE_ICON = "settings.tree.view.icon";
    private static final Color WRONG_CONTENT = JBColor.RED;
    private static final Color MODIFIED_CONTENT = JBColor.BLUE;
    public static final Color FOREGROUND = new JBColor((Color)Gray.x1A, (Color)Gray.xBB);
    final SimpleTree myTree;
    final FilteringTreeBuilder myBuilder;
    private final SettingsFilter myFilter;
    private final MyRoot myRoot;
    private final JScrollPane myScroller;
    private final IdentityHashMap<Configurable, MyNode> myConfigurableToNodeMap = new IdentityHashMap();
    private final IdentityHashMap<UnnamedConfigurable, ConfigurableWrapper> myConfigurableToWrapperMap = new IdentityHashMap();
    private final MergingUpdateQueue myQueue = new MergingUpdateQueue("SettingsTreeView", 150, false, (JComponent)this, (Disposable)this, (JComponent)this).setRestartTimerOnAdd(true);
    private Configurable myQueuedConfigurable;
    private boolean myPaintInternalInfo;

    public SettingsTreeView(SettingsFilter filter2, ConfigurableGroup[] groups) {
        this.myFilter = filter2;
        this.myRoot = new MyRoot(groups);
        this.myTree = new MyTree();
        this.myTree.putClientProperty((Object)"TreeTableTree", (Object)Boolean.TRUE);
        this.myTree.setBackground(UIUtil.SIDE_PANEL_BACKGROUND);
        this.myTree.getInputMap().clear();
        TreeUtil.installActions((JTree)this.myTree);
        this.myTree.setOpaque(true);
        this.myTree.getSelectionModel().setSelectionMode(1);
        this.myTree.setCellRenderer((TreeCellRenderer)new MyRenderer());
        this.myTree.setRootVisible(false);
        this.myTree.setShowsRootHandles(false);
        this.myTree.setExpandableItemsEnabled(false);
        RelativeFont.BOLD.install((Component)this.myTree);
        SettingsTreeView.setComponentPopupMenuTo((JTree)this.myTree);
        this.myTree.setTransferHandler(new TransferHandler(){

            @Override
            @Nullable
            protected Transferable createTransferable(JComponent c) {
                return SettingsTreeView.createTransferable(SettingsTreeView.this.myTree.getSelectionPath());
            }

            @Override
            public int getSourceActions(JComponent c) {
                return 1;
            }
        });
        this.myScroller = ScrollPaneFactory.createScrollPane(null, (boolean)true);
        this.myScroller.setViewport((JViewport)((Object)new GradientViewport((Component)this.myTree, (Insets)JBUI.insetsTop((int)5), true){
            private JLabel myHeader;

            @Override
            protected Component getHeader() {
                if (0 == SettingsTreeView.this.myTree.getY()) {
                    return null;
                }
                if (this.myHeader == null) {
                    this.myHeader = new JLabel();
                    this.myHeader.setForeground(FOREGROUND);
                    this.myHeader.setIconTextGap(5);
                    this.myHeader.setBorder(BorderFactory.createEmptyBorder(1, 10 + SettingsTreeView.getLeftMargin(0), 0, 0));
                }
                this.myHeader.setFont(SettingsTreeView.this.myTree.getFont());
                this.myHeader.setIcon(SettingsTreeView.this.myTree.getEmptyHandle());
                int height = this.myHeader.getPreferredSize().height;
                String group = SettingsTreeView.this.findGroupNameAt(0, height + 3);
                if (group == null || !group.equals(SettingsTreeView.this.findGroupNameAt(0, 0))) {
                    return null;
                }
                this.myHeader.setText(group);
                return this.myHeader;
            }
        }));
        if (!Registry.is((String)"ide.scroll.background.auto")) {
            this.myScroller.setBackground(UIUtil.SIDE_PANEL_BACKGROUND);
            this.myScroller.getViewport().setBackground(UIUtil.SIDE_PANEL_BACKGROUND);
            this.myScroller.getVerticalScrollBar().setBackground(UIUtil.SIDE_PANEL_BACKGROUND);
        }
        this.add(this.myScroller);
        this.myTree.addComponentListener((ComponentListener)new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                SettingsTreeView.this.myBuilder.revalidateTree();
            }

            @Override
            public void componentMoved(ComponentEvent e) {
                SettingsTreeView.this.myBuilder.revalidateTree();
            }

            @Override
            public void componentShown(ComponentEvent e) {
                SettingsTreeView.this.myBuilder.revalidateTree();
            }
        });
        this.myTree.getSelectionModel().addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent event) {
                MyNode node = SettingsTreeView.extractNode(event.getNewLeadSelectionPath());
                SettingsTreeView.this.select(node == null ? null : node.myConfigurable);
            }
        });
        if (Registry.is((String)"show.configurables.ids.in.settings")) {
            new HeldDownKeyListener(){

                protected void heldKeyTriggered(JComponent component, boolean pressed) {
                    SettingsTreeView.this.myPaintInternalInfo = pressed;
                    SettingsTreeView.this.setMinimumSize(null);
                    ((Tree)component).setCellRenderer((TreeCellRenderer)new MyRenderer());
                }
            }.installOn((JComponent)this.myTree);
        }
        this.myBuilder = new MyBuilder((SimpleTreeStructure)new SimpleTreeStructure.Impl((SimpleNode)this.myRoot));
        this.myBuilder.setFilteringMerge(300, null);
        Disposer.register((Disposable)this, (Disposable)this.myBuilder);
    }

    private static void setComponentPopupMenuTo(final JTree tree) {
        tree.setComponentPopupMenu(new JPopupMenu(){
            private Transferable transferable;
            {
                this.add(new CopyAction(() -> this.transferable));
            }

            @Override
            public void show(Component invoker, int x, int y) {
                if (invoker != tree) {
                    return;
                }
                TreePath path = tree.getClosestPathForLocation(x, y);
                this.transferable = SettingsTreeView.createTransferable(path);
                if (this.transferable == null) {
                    return;
                }
                Rectangle bounds = tree.getPathBounds(path);
                if (bounds == null || bounds.y > y) {
                    return;
                }
                bounds.y += bounds.height;
                if (bounds.y < y) {
                    return;
                }
                super.show(invoker, x, bounds.y);
            }
        });
    }

    private static Transferable createTransferable(TreePath path) {
        MyNode node = path == null ? null : SettingsTreeView.extractNode(path);
        return node == null ? null : CopyAction.createTransferable(SettingsTreeView.getPathNames(node));
    }

    @NotNull
    Collection<String> getPathNames(Configurable configurable) {
        Collection<String> collection = SettingsTreeView.getPathNames(this.findNode(configurable));
        if (collection == null) {
            SettingsTreeView.$$$reportNull$$$0(0);
        }
        return collection;
    }

    private static Collection<String> getPathNames(MyNode node) {
        ArrayDeque<String> path = new ArrayDeque<String>();
        while (node != null) {
            path.push(node.myDisplayName);
            SimpleNode parent = node.getParent();
            node = parent instanceof MyNode ? (MyNode)parent : null;
        }
        return path;
    }

    static Configurable getConfigurable(SimpleNode node) {
        return node instanceof MyNode ? ((MyNode)node).myConfigurable : null;
    }

    @Nullable
    MyNode findNode(Configurable configurable) {
        ConfigurableWrapper wrapper = this.myConfigurableToWrapperMap.get(configurable);
        return this.myConfigurableToNodeMap.get(wrapper != null ? wrapper : configurable);
    }

    @Nullable
    SearchableConfigurable findConfigurableById(@NotNull String id) {
        if (id == null) {
            SettingsTreeView.$$$reportNull$$$0(1);
        }
        for (Configurable configurable : this.myConfigurableToNodeMap.keySet()) {
            SearchableConfigurable searchable;
            if (!(configurable instanceof SearchableConfigurable) || !id.equals((searchable = (SearchableConfigurable)configurable).getId())) continue;
            return searchable;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    <T extends UnnamedConfigurable> T findConfigurable(@NotNull Class<T> type) {
        if (type == null) {
            SettingsTreeView.$$$reportNull$$$0(2);
        }
        for (UnnamedConfigurable unnamedConfigurable : this.myConfigurableToNodeMap.keySet()) {
            void var3_3;
            if (unnamedConfigurable instanceof ConfigurableWrapper) {
                ConfigurableWrapper wrapper = (ConfigurableWrapper)unnamedConfigurable;
                UnnamedConfigurable unnamedConfigurable2 = wrapper.getConfigurable();
                this.myConfigurableToWrapperMap.put(unnamedConfigurable2, wrapper);
            }
            if (!type.isInstance(var3_3)) continue;
            return (T)((UnnamedConfigurable)type.cast(var3_3));
        }
        return null;
    }

    @Nullable
    Project findConfigurableProject(@Nullable Configurable configurable) {
        MyNode node = this.findNode(configurable);
        return node == null ? null : SettingsTreeView.findConfigurableProject(node, true);
    }

    @Nullable
    private static Project findConfigurableProject(@NotNull MyNode node, boolean checkProjectLevel) {
        Configurable.VariableProjectAppLevel wrapped;
        if (node == null) {
            SettingsTreeView.$$$reportNull$$$0(3);
        }
        Configurable configurable = node.myConfigurable;
        Project project = node.getProject();
        if (checkProjectLevel && (wrapped = ConfigurableWrapper.cast(Configurable.VariableProjectAppLevel.class, (UnnamedConfigurable)configurable)) != null) {
            return wrapped.isProjectLevel() ? project : null;
        }
        if (configurable instanceof ConfigurableWrapper) {
            return project;
        }
        if (configurable instanceof SortedConfigurableGroup) {
            return project;
        }
        SimpleNode parent = node.getParent();
        return parent instanceof MyNode ? SettingsTreeView.findConfigurableProject((MyNode)parent, checkProjectLevel) : null;
    }

    @Nullable
    private static Project prepareProject(CachingSimpleNode parent, Configurable configurable) {
        SortedConfigurableGroup group;
        Configurable[] configurables;
        if (configurable instanceof ConfigurableWrapper) {
            ConfigurableWrapper wrapper = (ConfigurableWrapper)configurable;
            return wrapper.getExtensionPoint().getProject();
        }
        if (configurable instanceof SortedConfigurableGroup && (configurables = (group = (SortedConfigurableGroup)configurable).getConfigurables()) != null && configurables.length != 0) {
            Project project = SettingsTreeView.prepareProject(parent, configurables[0]);
            if (project != null) {
                for (int i = 1; i < configurables.length; ++i) {
                    if (project == SettingsTreeView.prepareProject(parent, configurables[i])) continue;
                    return null;
                }
            }
            return project;
        }
        return parent == null ? null : parent.getProject();
    }

    private static int getLeftMargin(int level) {
        return 3 + level * 16;
    }

    @Nullable
    private String findGroupNameAt(int x, int y) {
        for (TreePath path = this.myTree.getClosestPathForLocation(x - this.myTree.getX(), y - this.myTree.getY()); path != null; path = path.getParentPath()) {
            MyNode node = SettingsTreeView.extractNode(path);
            if (node == null) {
                return null;
            }
            if (this.myRoot != node.getParent()) continue;
            return node.myDisplayName;
        }
        return null;
    }

    @Nullable
    private static MyNode extractNode(@Nullable Object object) {
        DefaultMutableTreeNode node;
        if (object instanceof TreePath) {
            TreePath path = (TreePath)object;
            object = path.getLastPathComponent();
        }
        if (object instanceof DefaultMutableTreeNode) {
            node = (DefaultMutableTreeNode)object;
            object = node.getUserObject();
        }
        if (object instanceof FilteringTreeStructure.FilteringNode) {
            node = (FilteringTreeStructure.FilteringNode)object;
            object = node.getDelegate();
        }
        return object instanceof MyNode ? (MyNode)((Object)object) : null;
    }

    @Override
    public void doLayout() {
        this.myScroller.setBounds(0, 0, this.getWidth(), this.getHeight());
    }

    void selectFirst() {
        for (ConfigurableGroup eachGroup : this.myRoot.myGroups) {
            Configurable[] kids = eachGroup.getConfigurables();
            if (kids.length <= 0) continue;
            this.select(kids[0]);
            return;
        }
    }

    ActionCallback select(final @Nullable Configurable configurable) {
        if (this.myBuilder.isSelectionBeingAdjusted()) {
            return ActionCallback.REJECTED;
        }
        final ActionCallback callback = new ActionCallback();
        this.myQueuedConfigurable = configurable;
        this.myQueue.queue(new Update(this){

            public void run() {
                if (configurable == SettingsTreeView.this.myQueuedConfigurable) {
                    if (configurable == null) {
                        SettingsTreeView.this.fireSelected(null, callback);
                    } else {
                        SettingsTreeView.this.myBuilder.getReady((Object)this).doWhenDone(() -> {
                            if (configurable != SettingsTreeView.this.myQueuedConfigurable) {
                                return;
                            }
                            MyNode editorNode = SettingsTreeView.this.findNode(configurable);
                            FilteringTreeStructure.FilteringNode editorUiNode = SettingsTreeView.this.myBuilder.getVisibleNodeFor((Object)editorNode);
                            if (editorUiNode == null) {
                                return;
                            }
                            if (!SettingsTreeView.this.myBuilder.getSelectedElements().contains(editorUiNode)) {
                                SettingsTreeView.this.myBuilder.select((Object)editorUiNode, () -> SettingsTreeView.this.fireSelected(configurable, callback));
                            } else {
                                SettingsTreeView.this.myBuilder.scrollSelectionToVisible(() -> SettingsTreeView.this.fireSelected(configurable, callback), false);
                            }
                        });
                    }
                }
            }

            public void setRejected() {
                super.setRejected();
                callback.setRejected();
            }
        });
        return callback;
    }

    private void fireSelected(Configurable configurable, ActionCallback callback) {
        ConfigurableWrapper wrapper = this.myConfigurableToWrapperMap.get(configurable);
        this.myFilter.myContext.fireSelected((Configurable)(wrapper != null ? wrapper : configurable), this).doWhenProcessed(callback.createSetDoneRunnable());
    }

    public void dispose() {
        this.myQueuedConfigurable = null;
    }

    @Override
    public ActionCallback onSelected(@Nullable Configurable configurable, Configurable oldConfigurable) {
        return this.select(configurable);
    }

    @Override
    public ActionCallback onModifiedAdded(Configurable configurable) {
        this.myTree.repaint();
        return ActionCallback.DONE;
    }

    @Override
    public ActionCallback onModifiedRemoved(Configurable configurable) {
        this.myTree.repaint();
        return ActionCallback.DONE;
    }

    @Override
    public ActionCallback onErrorsChanged() {
        return ActionCallback.DONE;
    }

    protected void setProjectIcon(JLabel projectIcon, Configurable configurable, @Nullable Project project, boolean selected) {
        if (project != null) {
            projectIcon.setIcon(selected ? AllIcons.General.ProjectConfigurableSelected : AllIcons.General.ProjectConfigurable);
            projectIcon.setToolTipText(OptionsBundle.message((String)(project.isDefault() ? "configurable.default.project.tooltip" : "configurable.current.project.tooltip"), (Object[])new Object[0]));
            projectIcon.setVisible(true);
        } else {
            projectIcon.setVisible(false);
        }
    }

    @Override
    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleSettingsTreeView();
        }
        return this.accessibleContext;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/options/newEditor/SettingsTreeView";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getPathNames";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/options/newEditor/SettingsTreeView";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "findConfigurableById";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "findConfigurable";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findConfigurableProject";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    protected class AccessibleSettingsTreeView
    extends JComponent.AccessibleJComponent {
        protected AccessibleSettingsTreeView() {
            super(SettingsTreeView.this);
        }

        @Override
        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.PANEL;
        }
    }

    private final class MyBuilder
    extends FilteringTreeBuilder {
        List<Object> myToExpandOnResetFilter;
        boolean myRefilteringNow;
        boolean myWasHoldingFilter;

        public MyBuilder(SimpleTreeStructure structure) {
            super((Tree)SettingsTreeView.this.myTree, (ElementFilter)SettingsTreeView.this.myFilter, (AbstractTreeStructure)structure, null);
            SettingsTreeView.this.myTree.addTreeExpansionListener(new TreeExpansionListener(){

                @Override
                public void treeExpanded(TreeExpansionEvent event) {
                    MyBuilder.this.invalidateExpansions();
                }

                @Override
                public void treeCollapsed(TreeExpansionEvent event) {
                    MyBuilder.this.invalidateExpansions();
                }
            });
        }

        private void invalidateExpansions() {
            if (!this.myRefilteringNow) {
                this.myToExpandOnResetFilter = null;
            }
        }

        protected boolean isSelectable(Object object) {
            return object instanceof MyNode;
        }

        public boolean isAutoExpandNode(NodeDescriptor nodeDescriptor) {
            return ((SettingsTreeView)SettingsTreeView.this).myFilter.myContext.isHoldingFilter();
        }

        public boolean isToEnsureSelectionOnFocusGained() {
            return false;
        }

        protected ActionCallback refilterNow(Object preferredSelection, boolean adjustSelection) {
            ArrayList<Object> toRestore = new ArrayList<Object>();
            if (((SettingsTreeView)SettingsTreeView.this).myFilter.myContext.isHoldingFilter() && !this.myWasHoldingFilter && this.myToExpandOnResetFilter == null) {
                this.myToExpandOnResetFilter = SettingsTreeView.this.myBuilder.getUi().getExpandedElements();
            } else if (!((SettingsTreeView)SettingsTreeView.this).myFilter.myContext.isHoldingFilter() && this.myWasHoldingFilter && this.myToExpandOnResetFilter != null) {
                toRestore.addAll(this.myToExpandOnResetFilter);
                this.myToExpandOnResetFilter = null;
            }
            this.myWasHoldingFilter = ((SettingsTreeView)SettingsTreeView.this).myFilter.myContext.isHoldingFilter();
            ActionCallback result2 = super.refilterNow(preferredSelection, adjustSelection);
            this.myRefilteringNow = true;
            return result2.doWhenDone(() -> {
                this.myRefilteringNow = false;
                if (!((SettingsTreeView)SettingsTreeView.this).myFilter.myContext.isHoldingFilter() && this.getSelectedElements().isEmpty()) {
                    this.restoreExpandedState(toRestore);
                }
            });
        }

        private void restoreExpandedState(List<Object> toRestore) {
            TreePath[] selected = SettingsTreeView.this.myTree.getSelectionPaths();
            if (selected == null) {
                selected = new TreePath[]{};
            }
            ArrayList<TreePath> toCollapse = new ArrayList<TreePath>();
            for (int eachRow = 0; eachRow < SettingsTreeView.this.myTree.getRowCount(); ++eachRow) {
                Object eachElement;
                TreePath eachVisiblePath;
                if (!SettingsTreeView.this.myTree.isExpanded(eachRow) || (eachVisiblePath = SettingsTreeView.this.myTree.getPathForRow(eachRow)) == null || toRestore.contains(eachElement = SettingsTreeView.this.myBuilder.getElementFor(eachVisiblePath.getLastPathComponent()))) continue;
                for (TreePath eachSelected : selected) {
                    if (eachVisiblePath.isDescendant(eachSelected)) continue;
                    toCollapse.add(eachVisiblePath);
                }
            }
            for (TreePath each : toCollapse) {
                SettingsTreeView.this.myTree.collapsePath(each);
            }
        }
    }

    private static final class MyTreeUi
    extends WideSelectionTreeUI {
        private MyTreeUi() {
        }

        boolean processMouseEvent(MouseEvent event) {
            if (this.tree instanceof SimpleTree) {
                Component component;
                boolean toggleNow;
                SimpleTree tree = (SimpleTree)this.tree;
                boolean bl = toggleNow = 502 == event.getID() && UIUtil.isActionClick((MouseEvent)event, (int)502) && !this.isToggleEvent(event);
                if ((toggleNow || 501 == event.getID()) && (component = tree.getDeepestRendererComponentAt(event.getX(), event.getY())) != null && SettingsTreeView.NODE_ICON.equals(component.getName())) {
                    if (toggleNow) {
                        this.toggleExpandState(tree.getPathForLocation(event.getX(), event.getY()));
                    }
                    event.consume();
                    return true;
                }
            }
            return false;
        }

        protected boolean shouldPaintExpandControl(TreePath path, int row, boolean isExpanded, boolean hasBeenExpanded, boolean isLeaf) {
            return false;
        }

        protected void paintHorizontalPartOfLeg(Graphics g, Rectangle clipBounds, Insets insets, Rectangle bounds, TreePath path, int row, boolean isExpanded, boolean hasBeenExpanded, boolean isLeaf) {
        }

        protected void paintVerticalPartOfLeg(Graphics g, Rectangle clipBounds, Insets insets, TreePath path) {
        }

        public void paint(Graphics g, JComponent c) {
            GraphicsUtil.setupAntialiasing((Graphics)g);
            super.paint(g, c);
        }

        protected void paintRow(Graphics g, Rectangle clipBounds, Insets insets, Rectangle bounds, TreePath path, int row, boolean isExpanded, boolean hasBeenExpanded, boolean isLeaf) {
            if (this.tree != null) {
                bounds.width = this.tree.getWidth();
                Container parent = this.tree.getParent();
                if (parent instanceof JViewport) {
                    JViewport viewport = (JViewport)parent;
                    bounds.width = viewport.getWidth() - viewport.getViewPosition().x - insets.right / 2;
                }
                bounds.width -= bounds.x;
            }
            super.paintRow(g, clipBounds, insets, bounds, path, row, isExpanded, hasBeenExpanded, isLeaf);
        }

        protected int getRowX(int row, int depth) {
            return SettingsTreeView.getLeftMargin(depth - 1);
        }
    }

    private final class MyTree
    extends SimpleTree {
        private MyTree() {
        }

        public String getToolTipText(MouseEvent event) {
            String text;
            JLabel label;
            Component component;
            if (event != null && (component = this.getDeepestRendererComponentAt(event.getX(), event.getY())) instanceof JLabel && (label = (JLabel)component).getIcon() != null && (text = label.getToolTipText()) != null) {
                return text;
            }
            return super.getToolTipText(event);
        }

        protected boolean paintNodes() {
            return false;
        }

        protected boolean highlightSingleNode() {
            return false;
        }

        public void setUI(TreeUI ui) {
            super.setUI((TreeUI)(ui instanceof MyTreeUi ? ui : new MyTreeUi()));
        }

        protected boolean isCustomUI() {
            return true;
        }

        protected void configureUiHelper(TreeUIHelper helper) {
        }

        public boolean getScrollableTracksViewportWidth() {
            return true;
        }

        public void processKeyEvent(KeyEvent e) {
            TreePath path = SettingsTreeView.this.myTree.getSelectionPath();
            if (path != null) {
                if (e.getKeyCode() == 37) {
                    if (this.isExpanded(path)) {
                        this.collapsePath(path);
                        return;
                    }
                } else if (e.getKeyCode() == 39 && this.isCollapsed(path)) {
                    this.expandPath(path);
                    return;
                }
            }
            super.processKeyEvent(e);
        }

        protected void processMouseEvent(MouseEvent event) {
            MyTreeUi ui = (MyTreeUi)((Object)SettingsTreeView.this.myTree.getUI());
            if (!ui.processMouseEvent(event)) {
                super.processMouseEvent(event);
            }
        }
    }

    private final class MyRenderer
    extends CellRendererPanel
    implements TreeCellRenderer {
        final SimpleColoredComponent myTextLabel = new SimpleColoredComponent();
        final JLabel myNodeIcon = new JLabel();
        final JLabel myProjectIcon = new JLabel();

        MyRenderer() {
            this.setLayout(new BorderLayout(5, 0));
            this.myNodeIcon.setName(SettingsTreeView.NODE_ICON);
            this.myTextLabel.setOpaque(false);
            this.add("Center", (Component)this.myTextLabel);
            this.add("West", this.myNodeIcon);
            this.add("East", this.myProjectIcon);
            this.setBorder(BorderFactory.createEmptyBorder(1, 10, 3, 10));
        }

        public AccessibleContext getAccessibleContext() {
            if (this.accessibleContext == null) {
                this.accessibleContext = new MyAccessibleContext();
            }
            return this.accessibleContext;
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean focused) {
            Configurable configurable;
            this.myTextLabel.clear();
            this.setPreferredSize(null);
            MyNode node = SettingsTreeView.extractNode(value);
            boolean isGroup = node != null && SettingsTreeView.this.myRoot == node.getParent();
            String name = node != null ? node.myDisplayName : String.valueOf(value);
            this.myTextLabel.append(name, isGroup ? SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES : SimpleTextAttributes.REGULAR_ATTRIBUTES);
            this.myTextLabel.setFont(isGroup ? SettingsTreeView.this.myTree.getFont() : UIUtil.getLabelFont());
            this.myTextLabel.setForeground(selected ? UIUtil.getTreeSelectionForeground() : FOREGROUND);
            if (!selected && node != null && (configurable = node.myConfigurable) != null) {
                if (((SettingsTreeView)SettingsTreeView.this).myFilter.myContext.getErrors().containsKey(configurable)) {
                    this.myTextLabel.setForeground(WRONG_CONTENT);
                } else if (((SettingsTreeView)SettingsTreeView.this).myFilter.myContext.getModified().contains(configurable)) {
                    this.myTextLabel.setForeground(MODIFIED_CONTENT);
                }
            }
            Project project = null;
            if (node != null) {
                project = SettingsTreeView.findConfigurableProject(node, false);
            }
            Configurable configurable2 = null;
            if (node != null) {
                configurable2 = node.myConfigurable;
            }
            SettingsTreeView.this.setProjectIcon(this.myProjectIcon, configurable2, project, selected);
            Icon nodeIcon = null;
            if (value instanceof DefaultMutableTreeNode) {
                DefaultMutableTreeNode treeNode = (DefaultMutableTreeNode)value;
                nodeIcon = 0 == treeNode.getChildCount() ? SettingsTreeView.this.myTree.getEmptyHandle() : (SettingsTreeView.this.myTree.isExpanded(new TreePath(treeNode.getPath())) ? SettingsTreeView.this.myTree.getExpandedHandle() : SettingsTreeView.this.myTree.getCollapsedHandle());
            }
            this.myNodeIcon.setIcon(nodeIcon);
            if (node != null && SettingsTreeView.this.myPaintInternalInfo) {
                String pluginId;
                String id = node.myConfigurable instanceof ConfigurableWrapper ? ((ConfigurableWrapper)node.myConfigurable).getId() : (node.myConfigurable instanceof SearchableConfigurable ? ((SearchableConfigurable)node.myConfigurable).getId() : node.myConfigurable.getClass().getSimpleName());
                PluginDescriptor plugin = node.myConfigurable instanceof ConfigurableWrapper ? ((ConfigurableWrapper)node.myConfigurable).getExtensionPoint().getPluginDescriptor() : null;
                String string = pluginId = plugin == null ? null : plugin.getPluginId().getIdString();
                String pluginName = pluginId == null || "com.intellij".equals(pluginId) ? null : (plugin instanceof IdeaPluginDescriptor ? ((IdeaPluginDescriptor)plugin).getName() : pluginId);
                this.myTextLabel.append("   ", SimpleTextAttributes.REGULAR_ATTRIBUTES, false);
                this.myTextLabel.append(pluginName == null ? id : id + " (" + pluginName + ")", SimpleTextAttributes.GRAYED_SMALL_ATTRIBUTES, false);
            }
            if (node != null && tree.isVisible()) {
                JScrollBar bar;
                int width = SettingsTreeView.getLeftMargin(node.myLevel) + this.getPreferredSize().width;
                Insets insets = tree.getInsets();
                if (insets != null) {
                    width += insets.left + insets.right;
                }
                if ((bar = SettingsTreeView.this.myScroller.getVerticalScrollBar()) != null && bar.isVisible()) {
                    width += bar.getWidth();
                }
                width = Math.min(width, 300);
                SettingsTreeView view = SettingsTreeView.this;
                Dimension size = view.getMinimumSize();
                if (size.width < width) {
                    size.width = width;
                    view.setMinimumSize(size);
                    view.revalidate();
                    view.repaint();
                }
            }
            return this;
        }

        private class MyAccessibleContext
        extends JPanel.AccessibleJPanel {
            private MyAccessibleContext() {
                super((JPanel)((Object)MyRenderer.this));
            }

            @Override
            public String getAccessibleName() {
                return MyRenderer.this.myTextLabel.getCharSequence(true).toString();
            }
        }
    }

    private final class MyNode
    extends CachingSimpleNode {
        private final Configurable.Composite myComposite;
        private final Configurable myConfigurable;
        private final String myDisplayName;
        private final int myLevel;

        private MyNode(CachingSimpleNode parent, Configurable configurable, int level) {
            super(SettingsTreeView.prepareProject(parent, configurable), (NodeDescriptor)parent);
            this.myComposite = configurable instanceof Configurable.Composite ? (Configurable.Composite)configurable : null;
            this.myConfigurable = configurable;
            String name = configurable.getDisplayName();
            this.myDisplayName = name != null ? name.replace("\n", " ") : "{ " + configurable.getClass().getSimpleName() + " }";
            this.myLevel = level;
        }

        protected SimpleNode[] buildChildren() {
            if (this.myConfigurable != null) {
                SettingsTreeView.this.myConfigurableToNodeMap.put(this.myConfigurable, this);
            }
            if (this.myComposite == null) {
                return NO_CHILDREN;
            }
            Configurable[] configurables = this.myComposite.getConfigurables();
            if (configurables == null || configurables.length == 0) {
                return NO_CHILDREN;
            }
            SimpleNode[] result2 = new SimpleNode[configurables.length];
            for (int i = 0; i < configurables.length; ++i) {
                result2[i] = new MyNode(this, configurables[i], this.myLevel + 1);
                if (this.myConfigurable == null) continue;
                ((SettingsTreeView)SettingsTreeView.this).myFilter.myContext.registerKid(this.myConfigurable, configurables[i]);
            }
            return result2;
        }

        protected void update(PresentationData presentation) {
            super.update(presentation);
            presentation.addText(this.myDisplayName, this.getPlainAttributes());
        }

        public boolean isAlwaysLeaf() {
            return this.myComposite == null;
        }
    }

    private final class MyRoot
    extends CachingSimpleNode {
        private final ConfigurableGroup[] myGroups;

        private MyRoot(ConfigurableGroup[] groups) {
            super(null);
            this.myGroups = groups;
        }

        protected SimpleNode[] buildChildren() {
            if (this.myGroups == null || this.myGroups.length == 0) {
                return NO_CHILDREN;
            }
            ArrayList<MyNode> list2 = new ArrayList<MyNode>();
            for (ConfigurableGroup group : this.myGroups) {
                for (Configurable configurable : group.getConfigurables()) {
                    list2.add(new MyNode(this, configurable, 0));
                }
            }
            return list2.toArray(new SimpleNode[list2.size()]);
        }
    }
}

