/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.paths;

import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.paths.GlobalPathReferenceProvider;
import com.intellij.openapi.paths.PathReference;
import com.intellij.openapi.paths.PathReferenceManager;
import com.intellij.openapi.paths.PathReferenceProvider;
import com.intellij.openapi.paths.PsiDynaReference;
import com.intellij.openapi.paths.StaticPathReferenceProvider;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.util.SmartList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PathReferenceManagerImpl
extends PathReferenceManager {
    private final StaticPathReferenceProvider myStaticProvider = new StaticPathReferenceProvider(null);
    private final PathReferenceProvider myGlobalPathsProvider = new GlobalPathReferenceProvider();
    private static final Comparator<PsiReference> START_OFFSET_COMPARATOR = (o1, o2) -> o1.getRangeInElement().getStartOffset() - o2.getRangeInElement().getStartOffset();

    @Nullable
    public PathReference getPathReference(@NotNull String path, @NotNull PsiElement element, PathReferenceProvider ... additionalProviders) {
        PathReference pathReference;
        if (path == null) {
            PathReferenceManagerImpl.$$$reportNull$$$0(0);
        }
        if (element == null) {
            PathReferenceManagerImpl.$$$reportNull$$$0(1);
        }
        for (PathReferenceProvider provider : PathReferenceManagerImpl.getProviders()) {
            pathReference = provider.getPathReference(path, element);
            if (pathReference == null) continue;
            return pathReference;
        }
        for (PathReferenceProvider provider : additionalProviders) {
            pathReference = provider.getPathReference(path, element);
            if (pathReference == null) continue;
            return pathReference;
        }
        pathReference = this.myStaticProvider.getPathReference(path, element);
        if (pathReference != null) {
            return pathReference;
        }
        return null;
    }

    @Nullable
    public PathReference getCustomPathReference(@NotNull String path, @NotNull Module module, @NotNull PsiElement element, PathReferenceProvider ... providers) {
        if (path == null) {
            PathReferenceManagerImpl.$$$reportNull$$$0(2);
        }
        if (module == null) {
            PathReferenceManagerImpl.$$$reportNull$$$0(3);
        }
        if (element == null) {
            PathReferenceManagerImpl.$$$reportNull$$$0(4);
        }
        for (PathReferenceProvider provider : providers) {
            PathReference reference = provider.getPathReference(path, element);
            if (reference == null) continue;
            return reference;
        }
        return null;
    }

    @NotNull
    public PathReferenceProvider getGlobalWebPathReferenceProvider() {
        PathReferenceProvider pathReferenceProvider = this.myGlobalPathsProvider;
        if (pathReferenceProvider == null) {
            PathReferenceManagerImpl.$$$reportNull$$$0(5);
        }
        return pathReferenceProvider;
    }

    @NotNull
    public PathReferenceProvider createStaticPathReferenceProvider(boolean relativePathsAllowed) {
        StaticPathReferenceProvider provider = new StaticPathReferenceProvider(null);
        provider.setRelativePathsAllowed(relativePathsAllowed);
        StaticPathReferenceProvider staticPathReferenceProvider = provider;
        if (staticPathReferenceProvider == null) {
            PathReferenceManagerImpl.$$$reportNull$$$0(6);
        }
        return staticPathReferenceProvider;
    }

    @NotNull
    public PsiReference[] createReferences(@NotNull PsiElement psiElement, boolean soft, boolean endingSlashNotAllowed, boolean relativePathsAllowed, PathReferenceProvider ... additionalProviders) {
        if (psiElement == null) {
            PathReferenceManagerImpl.$$$reportNull$$$0(7);
        }
        PsiReference[] psiReferenceArray = this.createReferences(psiElement, soft, endingSlashNotAllowed, relativePathsAllowed, (FileType[])null, additionalProviders);
        if (psiReferenceArray == null) {
            PathReferenceManagerImpl.$$$reportNull$$$0(8);
        }
        return psiReferenceArray;
    }

    @NotNull
    public PsiReference[] createReferences(@NotNull PsiElement psiElement, boolean soft, boolean endingSlashNotAllowed, boolean relativePathsAllowed, FileType[] suitableFileTypes, PathReferenceProvider ... additionalProviders) {
        if (psiElement == null) {
            PathReferenceManagerImpl.$$$reportNull$$$0(9);
        }
        ArrayList<PsiReference> mergedReferences = new ArrayList<PsiReference>();
        PathReferenceManagerImpl.processProvider(psiElement, this.myGlobalPathsProvider, mergedReferences, soft);
        StaticPathReferenceProvider staticProvider = new StaticPathReferenceProvider(suitableFileTypes);
        staticProvider.setEndingSlashNotAllowed(endingSlashNotAllowed);
        staticProvider.setRelativePathsAllowed(relativePathsAllowed);
        PathReferenceManagerImpl.processProvider(psiElement, staticProvider, mergedReferences, soft);
        for (PathReferenceProvider provider : PathReferenceManagerImpl.getProviders()) {
            PathReferenceManagerImpl.processProvider(psiElement, provider, mergedReferences, soft);
        }
        for (PathReferenceProvider provider : additionalProviders) {
            PathReferenceManagerImpl.processProvider(psiElement, provider, mergedReferences, soft);
        }
        for (PathReferenceProvider provider : (PathReferenceProvider[])Extensions.getExtensions((ExtensionPointName)ANCHOR_REFERENCE_PROVIDER_EP)) {
            PathReferenceManagerImpl.processProvider(psiElement, provider, mergedReferences, soft);
        }
        PsiReference[] psiReferenceArray = PathReferenceManagerImpl.mergeReferences(psiElement, mergedReferences);
        if (psiReferenceArray == null) {
            PathReferenceManagerImpl.$$$reportNull$$$0(10);
        }
        return psiReferenceArray;
    }

    @NotNull
    public PsiReference[] createCustomReferences(@NotNull PsiElement psiElement, boolean soft, PathReferenceProvider ... providers) {
        PathReferenceProvider provider;
        boolean processed2;
        if (psiElement == null) {
            PathReferenceManagerImpl.$$$reportNull$$$0(11);
        }
        ArrayList<PsiReference> references = new ArrayList<PsiReference>();
        PathReferenceProvider[] pathReferenceProviderArray = providers;
        int n = pathReferenceProviderArray.length;
        for (int i = 0; i < n && !(processed2 = PathReferenceManagerImpl.processProvider(psiElement, provider = pathReferenceProviderArray[i], references, soft)); ++i) {
        }
        PsiReference[] psiReferenceArray = PathReferenceManagerImpl.mergeReferences(psiElement, references);
        if (psiReferenceArray == null) {
            PathReferenceManagerImpl.$$$reportNull$$$0(12);
        }
        return psiReferenceArray;
    }

    @NotNull
    public PsiReference[] createReferences(@NotNull PsiElement psiElement, boolean soft, PathReferenceProvider ... additionalProviders) {
        if (psiElement == null) {
            PathReferenceManagerImpl.$$$reportNull$$$0(13);
        }
        PsiReference[] psiReferenceArray = this.createReferences(psiElement, soft, false, true, (FileType[])null, additionalProviders);
        if (psiReferenceArray == null) {
            PathReferenceManagerImpl.$$$reportNull$$$0(14);
        }
        return psiReferenceArray;
    }

    private static PsiReference[] mergeReferences(PsiElement element, List<PsiReference> references) {
        if (references.size() <= 1) {
            return references.toArray(new PsiReference[references.size()]);
        }
        Collections.sort(references, START_OFFSET_COMPARATOR);
        ArrayList<PsiReference> intersecting = new ArrayList<PsiReference>();
        ArrayList<PsiReference> notIntersecting = new ArrayList<PsiReference>();
        TextRange intersectingRange = references.get(0).getRangeInElement();
        boolean intersected = false;
        for (int i = 1; i < references.size(); ++i) {
            PsiReference reference = references.get(i);
            TextRange range2 = reference.getRangeInElement();
            int offset = range2.getStartOffset();
            if (intersectingRange.getStartOffset() <= offset && intersectingRange.getEndOffset() >= offset) {
                intersected = true;
                intersecting.add(references.get(i - 1));
                if (i == references.size() - 1) {
                    intersecting.add(reference);
                }
                intersectingRange = intersectingRange.union(range2);
                continue;
            }
            if (intersected) {
                intersecting.add(references.get(i - 1));
                intersected = false;
            } else {
                notIntersecting.add(references.get(i - 1));
            }
            intersectingRange = range2;
            if (i != references.size() - 1) continue;
            notIntersecting.add(reference);
        }
        List<PsiReference> result2 = PathReferenceManagerImpl.doMerge(element, intersecting);
        result2.addAll(notIntersecting);
        return result2.toArray(new PsiReference[result2.size()]);
    }

    private static List<PsiReference> doMerge(PsiElement element, List<PsiReference> references) {
        TextRange range2;
        SmartList list2;
        ArrayList<PsiReference> resolvingRefs = new ArrayList<PsiReference>();
        ArrayList<PsiReference> nonResolvingRefs = new ArrayList<PsiReference>();
        for (int i = 0; i < references.size(); ++i) {
            PsiReference reference = references.get(i);
            assert (element.equals(reference.getElement()));
            if (reference.resolve() != null) {
                resolvingRefs.add(reference);
                continue;
            }
            nonResolvingRefs.add(reference);
        }
        ArrayList<PsiReference> result2 = new ArrayList<PsiReference>(5);
        while (!resolvingRefs.isEmpty()) {
            list2 = new ArrayList(5);
            range2 = PathReferenceManagerImpl.getFirstIntersectingReferences(resolvingRefs, (List<PsiReference>)list2);
            TextRange textRange = PathReferenceManagerImpl.addIntersectingReferences(nonResolvingRefs, (List<PsiReference>)list2, range2);
            PathReferenceManagerImpl.addToResult(element, result2, (List<PsiReference>)list2, textRange);
        }
        while (!nonResolvingRefs.isEmpty()) {
            list2 = new SmartList();
            range2 = PathReferenceManagerImpl.getFirstIntersectingReferences(nonResolvingRefs, (List<PsiReference>)list2);
            int endOffset = range2.getEndOffset();
            for (PsiReference reference : list2) {
                endOffset = Math.min(endOffset, reference.getRangeInElement().getEndOffset());
            }
            PathReferenceManagerImpl.addToResult(element, result2, (List<PsiReference>)list2, new TextRange(range2.getStartOffset(), endOffset));
        }
        return result2;
    }

    private static void addToResult(PsiElement element, List<PsiReference> result2, List<PsiReference> list2, TextRange range2) {
        if (list2.size() == 1) {
            result2.add(list2.get(0));
        } else {
            PsiDynaReference<PsiElement> psiDynaReference = new PsiDynaReference<PsiElement>(element);
            psiDynaReference.addReferences(list2);
            psiDynaReference.setRangeInElement(range2);
            result2.add((PsiReference)psiDynaReference);
        }
    }

    private static TextRange addIntersectingReferences(List<PsiReference> set2, List<PsiReference> toAdd, TextRange range2) {
        int startOffset = range2.getStartOffset();
        int endOffset = range2.getStartOffset();
        Iterator<PsiReference> iterator = set2.iterator();
        while (iterator.hasNext()) {
            PsiReference reference = iterator.next();
            TextRange rangeInElement = reference.getRangeInElement();
            if (!PathReferenceManagerImpl.intersect(range2, rangeInElement)) continue;
            toAdd.add(reference);
            iterator.remove();
            startOffset = Math.min(startOffset, rangeInElement.getStartOffset());
            endOffset = Math.max(endOffset, rangeInElement.getEndOffset());
        }
        return new TextRange(startOffset, endOffset);
    }

    private static boolean intersect(TextRange range1, TextRange range2) {
        return range2.intersectsStrict(range1) || range2.intersects(range1) && (range1.isEmpty() || range2.isEmpty());
    }

    private static TextRange getFirstIntersectingReferences(List<PsiReference> set2, List<PsiReference> toAdd) {
        int startOffset = Integer.MAX_VALUE;
        int endOffset = -1;
        Iterator<PsiReference> it = set2.iterator();
        while (it.hasNext()) {
            PsiReference reference = it.next();
            TextRange range2 = reference.getRangeInElement();
            if (endOffset != -1 && range2.getStartOffset() > endOffset) break;
            startOffset = Math.min(startOffset, range2.getStartOffset());
            endOffset = Math.max(range2.getEndOffset(), endOffset);
            toAdd.add(reference);
            it.remove();
        }
        return new TextRange(startOffset, endOffset);
    }

    private static boolean processProvider(PsiElement psiElement, PathReferenceProvider provider, List<PsiReference> mergedReferences, boolean soft) {
        return provider.createReferences(psiElement, mergedReferences, soft);
    }

    private static PathReferenceProvider[] getProviders() {
        return (PathReferenceProvider[])Extensions.getExtensions((ExtensionPointName)PATH_REFERENCE_PROVIDER_EP);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: 
            case 8: 
            case 10: 
            case 12: 
            case 14: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: 
            case 8: 
            case 10: 
            case 12: 
            case 14: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 5: 
            case 6: 
            case 8: 
            case 10: 
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/paths/PathReferenceManagerImpl";
                break;
            }
            case 7: 
            case 9: 
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/paths/PathReferenceManagerImpl";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getGlobalWebPathReferenceProvider";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createStaticPathReferenceProvider";
                break;
            }
            case 8: 
            case 10: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "createReferences";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "createCustomReferences";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getPathReference";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getCustomPathReference";
                break;
            }
            case 5: 
            case 6: 
            case 8: 
            case 10: 
            case 12: 
            case 14: {
                break;
            }
            case 7: 
            case 9: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "createReferences";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "createCustomReferences";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 8: 
            case 10: 
            case 12: 
            case 14: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

