/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.preview.impl;

import com.intellij.icons.AllIcons;
import com.intellij.ide.ui.UISettings;
import com.intellij.ide.ui.UISettingsListener;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.keymap.Keymap;
import com.intellij.openapi.keymap.KeymapManager;
import com.intellij.openapi.preview.PreviewInfo;
import com.intellij.openapi.preview.PreviewManager;
import com.intellij.openapi.preview.PreviewPanelProvider;
import com.intellij.openapi.preview.PreviewProviderId;
import com.intellij.openapi.preview.impl.PreviewManagerState;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.openapi.wm.ToolWindowContentUiType;
import com.intellij.openapi.wm.ToolWindowId;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.impl.ToolWindowImpl;
import com.intellij.openapi.wm.impl.ToolWindowManagerImpl;
import com.intellij.ui.Gray;
import com.intellij.ui.JBColor;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.content.ContentManagerAdapter;
import com.intellij.ui.content.ContentManagerEvent;
import com.intellij.ui.content.ContentManagerListener;
import com.intellij.util.Alarm;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="PreviewManager", storages={@Storage(value="$WORKSPACE_FILE$")})
public class PreviewManagerImpl
implements PreviewManager,
PersistentStateComponent<PreviewManagerState> {
    private static final Key<PreviewInfo> INFO_KEY = Key.create((String)"preview_info");
    private static final int HISTORY_LIMIT = 10;
    private final Project myProject;
    private final Alarm myAlarm = new Alarm();
    private ToolWindowImpl myToolWindow;
    private ContentManager myContentManager;
    private Content myEmptyStateContent;
    private final JPanel myEmptyStatePanel;
    private ArrayList<PreviewInfo> myHistory = new ArrayList();
    private TreeSet<PreviewPanelProvider> myProviders = new TreeSet((o1, o2) -> {
        int result2 = Float.compare(o1.getMenuOrder(), o2.getMenuOrder());
        return result2 != 0 ? result2 : o1.toString().compareTo(o2.toString());
    });
    private Set<PreviewProviderId> myActiveProviderIds = new HashSet<PreviewProviderId>();
    private Set<PreviewProviderId> myLockedProviderIds = new HashSet<PreviewProviderId>();
    private boolean myInnerSelectionChange;

    private static boolean isAvailable() {
        return UISettings.getInstance().getNavigateToPreview();
    }

    public PreviewManagerImpl(Project project) {
        PreviewPanelProvider[] providers;
        this.myProject = project;
        this.myEmptyStatePanel = new EmptyStatePanel();
        for (PreviewPanelProvider provider : providers = (PreviewPanelProvider[])PreviewPanelProvider.EP_NAME.getExtensions((AreaInstance)project)) {
            this.myProviders.add(provider);
            this.myActiveProviderIds.add(provider.getId());
            Disposer.register((Disposable)project, (Disposable)provider);
        }
        project.getMessageBus().connect().subscribe(UISettingsListener.TOPIC, uiSettings -> this.checkGlobalState());
        this.checkGlobalState();
        this.checkEmptyState();
    }

    @Nullable
    public PreviewManagerState getState() {
        PreviewManagerState state = new PreviewManagerState();
        state.myArtifactFilesMap = new HashMap<String, Boolean>();
        for (PreviewPanelProvider provider : this.myProviders) {
            state.myArtifactFilesMap.put(provider.toString(), this.myActiveProviderIds.contains(provider.getId()));
        }
        return state;
    }

    public void loadState(PreviewManagerState state) {
        if (state == null) {
            return;
        }
        block0: for (Map.Entry<String, Boolean> entry : state.myArtifactFilesMap.entrySet()) {
            if (entry.getValue().booleanValue()) continue;
            Iterator<PreviewProviderId> iterator = this.myActiveProviderIds.iterator();
            while (iterator.hasNext()) {
                PreviewProviderId id = iterator.next();
                if (!id.getVisualName().equals(entry.getKey())) continue;
                iterator.remove();
                continue block0;
            }
        }
    }

    @Nullable
    private <V, C> PreviewPanelProvider<V, C> findProvider(@NotNull PreviewProviderId<V, C> id) {
        if (id == null) {
            PreviewManagerImpl.$$$reportNull$$$0(0);
        }
        for (PreviewPanelProvider provider : this.myProviders) {
            if (id != provider.getId()) continue;
            return provider;
        }
        return null;
    }

    protected void checkGlobalState() {
        ToolWindowManagerImpl toolWindowManager = (ToolWindowManagerImpl)ToolWindowManager.getInstance((Project)this.myProject);
        if (!PreviewManagerImpl.isAvailable() && toolWindowManager.getToolWindow(ToolWindowId.PREVIEW) != null) {
            this.myHistory.clear();
            this.myContentManager.removeAllContents(true);
            toolWindowManager.unregisterToolWindow(ToolWindowId.PREVIEW);
            return;
        }
        if (PreviewManagerImpl.isAvailable() && toolWindowManager.getToolWindow(ToolWindowId.PREVIEW) == null) {
            this.myToolWindow = (ToolWindowImpl)toolWindowManager.registerToolWindow(ToolWindowId.PREVIEW, this.myEmptyStatePanel, ToolWindowAnchor.RIGHT, (Disposable)this.myProject, false);
            this.myContentManager = this.myToolWindow.getContentManager();
            this.myToolWindow.setIcon(AllIcons.Toolwindows.ToolWindowPreview);
            this.myToolWindow.setContentUiType(ToolWindowContentUiType.COMBO, null);
            this.myToolWindow.setAutoHide(true);
            this.myEmptyStateContent = this.myContentManager.getContent(0);
            final MoveToStandardViewAction moveToStandardViewAction = new MoveToStandardViewAction();
            this.myContentManager.addContentManagerListener((ContentManagerListener)new ContentManagerAdapter(){

                public void selectionChanged(ContentManagerEvent event) {
                    if (PreviewManagerImpl.this.myInnerSelectionChange || event.getOperation() != ContentManagerEvent.ContentOperation.add) {
                        return;
                    }
                    PreviewInfo previewInfo = (PreviewInfo)event.getContent().getUserData(INFO_KEY);
                    if (previewInfo != null) {
                        PreviewManagerImpl.this.preview(previewInfo, false);
                        PreviewManagerImpl.this.myToolWindow.setTitleActions(previewInfo.supportsStandardPlace() ? moveToStandardViewAction : null);
                    }
                }
            });
            moveToStandardViewAction.registerCustomShortcutSet(new ShortcutSet(){

                @NotNull
                public Shortcut[] getShortcuts() {
                    Keymap keymap = KeymapManager.getInstance().getActiveKeymap();
                    Shortcut[] shortcutArray = keymap.getShortcuts("ShowContent");
                    if (shortcutArray == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    return shortcutArray;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/preview/impl/PreviewManagerImpl$2", "getShortcuts"));
                }
            }, this.myToolWindow.getComponent());
            this.myToolWindow.setTitleActions(moveToStandardViewAction);
            ArrayList<ContentTypeToggleAction> myGearActions = new ArrayList<ContentTypeToggleAction>();
            for (PreviewPanelProvider provider : this.myProviders) {
                myGearActions.add(new ContentTypeToggleAction(provider));
            }
            this.myToolWindow.setAdditionalGearActions((ActionGroup)new DefaultActionGroup("Preview", myGearActions));
            this.myToolWindow.activate(() -> this.myToolWindow.activate(null));
        }
    }

    private void checkEmptyState() {
        if (this.myContentManager.getContents().length == 0) {
            this.myToolWindow.getComponent().putClientProperty("HideIdLabel", "false");
            this.myContentManager.addContent(this.myEmptyStateContent);
        } else if (this.myContentManager.getContents().length > 1) {
            this.myToolWindow.getComponent().putClientProperty("HideIdLabel", "true");
            this.myContentManager.removeContent(this.myEmptyStateContent, false);
        }
    }

    @Nullable
    private Content getContent(@NotNull PreviewInfo info) {
        if (info == null) {
            PreviewManagerImpl.$$$reportNull$$$0(1);
        }
        for (Content content : this.myContentManager.getContents()) {
            PreviewInfo eachInfo = (PreviewInfo)content.getUserData(INFO_KEY);
            if (!info.equals(eachInfo)) continue;
            return content;
        }
        return null;
    }

    @NotNull
    private Content addContent(PreviewInfo info) {
        this.myHistory.add(info);
        while (this.myHistory.size() > 10) {
            this.close(this.myHistory.remove(0));
        }
        Content content = this.myContentManager.getFactory().createContent(info.getComponent(), info.getTitle(), false);
        this.myContentManager.addContent(content, 0);
        this.checkEmptyState();
        Content content2 = content;
        if (content2 == null) {
            PreviewManagerImpl.$$$reportNull$$$0(2);
        }
        return content2;
    }

    private static void updateContentWithInfo(Content content, PreviewInfo info) {
        content.putUserData(ToolWindow.SHOW_CONTENT_ICON, (Object)Boolean.TRUE);
        content.putUserData(INFO_KEY, (Object)info);
        content.setIcon(info.getIcon());
        content.setPopupIcon(info.getIcon());
    }

    private void close(@NotNull PreviewInfo info) {
        Content content;
        if (info == null) {
            PreviewManagerImpl.$$$reportNull$$$0(3);
        }
        if ((content = this.getContent(info)) != null) {
            this.myContentManager.removeContent(content, false);
            info.release();
            if (this.myContentManager.getContents().length == 0) {
                this.toggleToolWindow(false, null);
            }
            this.checkEmptyState();
        }
    }

    @Override
    public <V, C> C preview(@NotNull PreviewProviderId<V, C> id, V data, boolean requestFocus) {
        if (id == null) {
            PreviewManagerImpl.$$$reportNull$$$0(4);
        }
        if (!this.myActiveProviderIds.contains(id) || this.myLockedProviderIds.contains(id)) {
            return null;
        }
        PreviewPanelProvider<V, C> provider = this.findProvider(id);
        if (provider == null) {
            return null;
        }
        return this.preview(PreviewInfo.create(provider, data), requestFocus);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <V, C> C preview(@NotNull PreviewInfo<V, C> info, boolean requestFocus) {
        if (info == null) {
            PreviewManagerImpl.$$$reportNull$$$0(5);
        }
        this.toggleToolWindow(true, null);
        Content content = this.getContent(info);
        Content selectedContent = this.myContentManager.getSelectedContent();
        if (selectedContent != content) {
            this.myInnerSelectionChange = true;
            try {
                PreviewInfo selectedInfo;
                PreviewInfo previewInfo = selectedInfo = selectedContent != null ? (PreviewInfo)selectedContent.getUserData(INFO_KEY) : null;
                if (selectedInfo != null && selectedInfo.isModified(selectedInfo.getId() == info.getId())) {
                    this.moveToStandardPlaceImpl(selectedInfo.getId(), selectedInfo.getData());
                }
                if (content == null) {
                    content = this.addContent(info);
                }
            }
            finally {
                this.myInnerSelectionChange = false;
            }
        }
        if (content != null) {
            this.myContentManager.addContent(content, 0);
        }
        this.myInnerSelectionChange = true;
        try {
            if (content != null) {
                PreviewManagerImpl.updateContentWithInfo(content, info);
                this.myContentManager.setSelectedContent(content, requestFocus);
            }
            C c = info.initComponent(requestFocus);
            return c;
        }
        finally {
            this.myInnerSelectionChange = false;
        }
    }

    @Override
    public <V, C> void close(@NotNull PreviewProviderId<V, C> id, V data) {
        if (id == null) {
            PreviewManagerImpl.$$$reportNull$$$0(6);
        }
        for (Content content : this.myContentManager.getContents()) {
            PreviewInfo info = (PreviewInfo)content.getUserData(INFO_KEY);
            if (info == null || info.getId() != id || !info.getProvider().contentsAreEqual(info.getData(), data)) continue;
            this.close(info);
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <V, C> void moveToStandardPlaceImpl(@NotNull PreviewProviderId<V, C> id, V data) {
        PreviewPanelProvider<V, C> provider;
        if (id == null) {
            PreviewManagerImpl.$$$reportNull$$$0(7);
        }
        if ((provider = this.findProvider(id)) == null) {
            return;
        }
        this.myLockedProviderIds.add(id);
        try {
            provider.showInStandardPlace(data);
        }
        finally {
            this.myLockedProviderIds.remove(id);
        }
        this.close(id, data);
    }

    private void toggleToolWindow(boolean activate, Runnable runnable2) {
        ToolWindow toolWindow = ToolWindowManager.getInstance((Project)this.myProject).getToolWindow(ToolWindowId.PREVIEW);
        if (toolWindow != null && activate != toolWindow.isActive()) {
            if (activate) {
                toolWindow.activate(runnable2, true);
            } else if (!this.myAlarm.isEmpty()) {
                toolWindow.hide(null);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/preview/impl/PreviewManagerImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/preview/impl/PreviewManagerImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "addContent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findProvider";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getContent";
                break;
            }
            case 2: {
                break;
            }
            case 3: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "close";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "preview";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "moveToStandardPlaceImpl";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class EmptyStatePanel
    extends JPanel {
        public EmptyStatePanel() {
            this.setOpaque(true);
        }

        @Override
        public void paint(Graphics g) {
            boolean isDarkBackground = UIUtil.isUnderDarcula();
            UISettings.setupAntialiasing((Graphics)g);
            UIUtil.TextPainter painter = new UIUtil.TextPainter().withLineSpacing(1.5f).withColor((Color)new JBColor((Color)(isDarkBackground ? Gray._230 : Gray._80), (Color)Gray._160)).withFont((Font)JBUI.Fonts.label((float)(isDarkBackground ? 24.0f : 20.0f))).withShadow(true, (Color)new JBColor(Gray._200.withAlpha(100), Gray._0.withAlpha(255)));
            painter.appendLine("No files are open");
            painter.draw(g, (width, height) -> {
                Dimension s = this.getSize();
                return Couple.of((Object)((s.width - width) / 2), (Object)((s.height - height) / 2));
            });
        }
    }

    private class ContentTypeToggleAction
    extends ToggleAction {
        private final PreviewPanelProvider myProvider;

        ContentTypeToggleAction(PreviewPanelProvider provider) {
            super(provider.getId().getVisualName());
            this.myProvider = provider;
        }

        public boolean isSelected(AnActionEvent e) {
            return PreviewManagerImpl.this.myActiveProviderIds.contains(this.myProvider.getId());
        }

        public void setSelected(AnActionEvent e, boolean state) {
            if (state) {
                PreviewManagerImpl.this.myActiveProviderIds.add(this.myProvider.getId());
            } else {
                PreviewManagerImpl.this.myActiveProviderIds.remove(this.myProvider.getId());
                Iterator iterator = PreviewManagerImpl.this.myHistory.iterator();
                while (iterator.hasNext()) {
                    PreviewInfo info = (PreviewInfo)iterator.next();
                    if (!info.getId().equals(this.myProvider.getId())) continue;
                    Content content = PreviewManagerImpl.this.getContent(info);
                    if (content != null) {
                        PreviewManagerImpl.this.myContentManager.removeContent(content, true);
                    }
                    iterator.remove();
                }
                PreviewManagerImpl.this.checkEmptyState();
            }
        }
    }

    private class MoveToStandardViewAction
    extends AnAction {
        public MoveToStandardViewAction() {
            super("Move to standard view", "Move to standard view", AllIcons.Actions.MoveToStandardPlace);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            Content selectedContent;
            if (e == null) {
                MoveToStandardViewAction.$$$reportNull$$$0(0);
            }
            if ((selectedContent = PreviewManagerImpl.this.myContentManager.getSelectedContent()) == null) {
                return;
            }
            PreviewInfo previewInfo = (PreviewInfo)selectedContent.getUserData(INFO_KEY);
            if (previewInfo != null) {
                PreviewManagerImpl.this.moveToStandardPlaceImpl(previewInfo.getId(), previewInfo.getData());
                PreviewManagerImpl.this.toggleToolWindow(false, null);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/preview/impl/PreviewManagerImpl$MoveToStandardViewAction", "actionPerformed"));
        }
    }
}

