/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util;

import com.intellij.ide.CopyProvider;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.impl.ActionToolbarImpl;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.Bitness;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.Version;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.JBColor;
import com.intellij.ui.ListCellRendererWrapper;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.JdkBundle;
import com.intellij.util.JdkBundleList;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Locale;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SwitchBootJdkAction
extends AnAction
implements DumbAware {
    @NotNull
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.ide.actions.SwitchBootJdkAction");
    @NotNull
    private static final String productJdkConfigFileName = SwitchBootJdkAction.getExecutable() + (SystemInfo.isWindows ? (SystemInfo.is64Bit ? "64.exe.jdk" : ".exe.jdk") : ".jdk");
    @Nullable
    private static final String pathsSelector = PathManager.getPathsSelector();
    @NotNull
    private static final File productJdkConfigDir = new File(pathsSelector != null ? PathManager.getDefaultConfigPathFor((String)pathsSelector) : PathManager.getConfigPath());
    @NotNull
    private static final File productJdkConfigFile = new File(productJdkConfigDir, productJdkConfigFileName);
    @NotNull
    private static final File bundledJdkFile = SwitchBootJdkAction.getBundledJDKFile();
    private static final String STANDARD_JDK_LOCATION_ON_MAC_OS_X = "/Library/Java/JavaVirtualMachines/";
    private static final String[] STANDARD_JVM_LOCATIONS_ON_LINUX = new String[]{"/usr/lib/jvm/", "/usr/java/"};
    private static final String STANDARD_JVM_X64_LOCATIONS_ON_WINDOWS = "Program Files/Java";
    private static final String STANDARD_JVM_X86_LOCATIONS_ON_WINDOWS = "Program Files (x86)/Java";
    private static final Version JDK8_VERSION = new Version(1, 8, 0);

    @NotNull
    private static File getBundledJDKFile() {
        File file2 = new File(SystemInfo.isMac ? "jdk" : "jre" + (JdkBundle.runtimeBitness == Bitness.x64 ? "64" : ""));
        if (file2 == null) {
            SwitchBootJdkAction.$$$reportNull$$$0(0);
        }
        return file2;
    }

    public void update(AnActionEvent e) {
        e.getPresentation().setText("Switch Boot JDK");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void actionPerformed(AnActionEvent event) {
        SwitchBootJdkDialog dialog2;
        if (!productJdkConfigDir.exists()) {
            try {
                if (!productJdkConfigDir.mkdirs()) {
                    LOG.error("Could not create " + productJdkConfigDir + " productJdkConfigDir");
                    return;
                }
                if (!productJdkConfigFile.exists() && !productJdkConfigFile.createNewFile()) {
                    LOG.error("Could not create " + productJdkConfigFileName + " productJdkConfigFile");
                    return;
                }
            }
            catch (IOException e) {
                LOG.error((Throwable)e);
                return;
            }
        }
        if ((dialog2 = new SwitchBootJdkDialog()).showAndGet()) {
            File selectedJdkBundleFile = dialog2.getSelectedFile();
            if (selectedJdkBundleFile == null) {
                LOG.error("SwitchBootJdkDialog returns null selection");
                return;
            }
            FileWriter fooWriter = null;
            try {
                fooWriter = new FileWriter(productJdkConfigFile, false);
                fooWriter.write(selectedJdkBundleFile.getPath());
            }
            catch (IOException e) {
                LOG.error((Throwable)e);
            }
            finally {
                try {
                    if (fooWriter != null) {
                        fooWriter.close();
                    }
                }
                catch (IOException e) {
                    LOG.error((Throwable)e);
                }
            }
            ApplicationManager.getApplication().restart();
        }
    }

    @NotNull
    public static JdkBundleList findJdkPaths() {
        JdkBundle bundledJdk;
        JdkBundle bootJdk = JdkBundle.createBoot();
        JdkBundleList jdkBundleList = new JdkBundleList();
        if (bootJdk != null) {
            jdkBundleList.addBundle(bootJdk, true);
        }
        if (new File(PathManager.getHomePath() + File.separator + bundledJdkFile).exists() && (bundledJdk = JdkBundle.createBundle(bundledJdkFile, false, true)) != null) {
            jdkBundleList.addBundle(bundledJdk, true);
        }
        if (SystemInfo.isMac) {
            jdkBundleList.addBundlesFromLocation(STANDARD_JDK_LOCATION_ON_MAC_OS_X, JDK8_VERSION, null);
        } else if (SystemInfo.isLinux) {
            for (String location : STANDARD_JVM_LOCATIONS_ON_LINUX) {
                jdkBundleList.addBundlesFromLocation(location, JDK8_VERSION, null);
            }
        } else if (SystemInfo.isWindows) {
            for (File root : File.listRoots()) {
                if (SystemInfo.is32Bit) {
                    jdkBundleList.addBundlesFromLocation(new File(root, STANDARD_JVM_X86_LOCATIONS_ON_WINDOWS).getAbsolutePath(), JDK8_VERSION, null);
                    continue;
                }
                jdkBundleList.addBundlesFromLocation(new File(root, STANDARD_JVM_X64_LOCATIONS_ON_WINDOWS).getAbsolutePath(), JDK8_VERSION, null);
            }
        }
        JdkBundleList jdkBundleList2 = jdkBundleList;
        if (jdkBundleList2 == null) {
            SwitchBootJdkAction.$$$reportNull$$$0(1);
        }
        return jdkBundleList2;
    }

    @NotNull
    private static String getExecutable() {
        String executable = System.getProperty("idea.executable");
        String string = executable != null ? executable : ApplicationNamesInfo.getInstance().getProductName().toLowerCase(Locale.US);
        if (string == null) {
            SwitchBootJdkAction.$$$reportNull$$$0(2);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/openapi/util/SwitchBootJdkAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getBundledJDKFile";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "findJdkPaths";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getExecutable";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class SwitchBootJdkDialog
    extends DialogWrapper
    implements DataProvider,
    CopyProvider {
        @NotNull
        private final ComboBox myComboBox;

        private SwitchBootJdkDialog() {
            super((Project)null, false);
            final JdkBundleList pathsList = SwitchBootJdkAction.findJdkPaths();
            this.myComboBox = new ComboBox();
            final DefaultComboBoxModel<JdkBundleItem> model = new DefaultComboBoxModel<JdkBundleItem>();
            for (JdkBundle jdkBundlePath : pathsList.toArrayList()) {
                model.addElement(new JdkBundleItem(jdkBundlePath));
            }
            model.addElement(new JdkBundleItem(null));
            this.myComboBox.setModel(model);
            this.myComboBox.setRenderer((ListCellRenderer)new ListCellRendererWrapper(){

                public void customize(JList list2, Object value, int index, boolean selected, boolean hasFocus) {
                    JdkBundle jdkBundleDescriptor = ((JdkBundleItem)value).getBundle();
                    if (jdkBundleDescriptor != null) {
                        if (jdkBundleDescriptor.isBoot()) {
                            this.setForeground((Color)JBColor.DARK_GRAY);
                        }
                        this.setText(jdkBundleDescriptor.getVisualRepresentation());
                    } else {
                        this.setText("...");
                    }
                }
            });
            this.myComboBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (myComboBox.getSelectedItem() == null) {
                        LOG.error("Unexpected nullable selection");
                        return;
                    }
                    JdkBundleItem item = (JdkBundleItem)myComboBox.getSelectedItem();
                    if (item.getBundle() == null) {
                        FileChooserDescriptor descriptor = new FileChooserDescriptor(false, true, false, false, false, false){
                            JdkBundle selectedBundle;

                            public boolean isFileSelectable(VirtualFile file2) {
                                this.selectedBundle = null;
                                if (!super.isFileSelectable(file2)) {
                                    return false;
                                }
                                JdkBundle bundle = JdkBundle.createBundle(new File(file2.getPath()), false, false, false);
                                if (bundle == null) {
                                    return false;
                                }
                                Version version = bundle.getVersion();
                                this.selectedBundle = bundle;
                                return version != null && !version.lessThan(Integer.valueOf(JDK8_VERSION.major), Integer.valueOf(JDK8_VERSION.minor), Integer.valueOf(JDK8_VERSION.bugfix));
                            }

                            public void validateSelectedFiles(VirtualFile[] files) throws Exception {
                                super.validateSelectedFiles(files);
                                assert (files.length == 1);
                                if (this.selectedBundle == null) {
                                    throw new Exception("Invalid JDK bundle!");
                                }
                                if (this.selectedBundle.getBitness() != JdkBundle.runtimeBitness) {
                                    throw new Exception("JDK arch mismatch! Your IDE's arch is " + JdkBundle.runtimeBitness);
                                }
                            }
                        };
                        FileChooser.chooseFiles((FileChooserDescriptor)descriptor, null, null, files -> {
                            if (files.size() > 0) {
                                JdkBundleItem jdkBundleItem;
                                File jdkFile = new File(((VirtualFile)files.get(0)).getPath());
                                JdkBundle selectedJdk = pathsList.getBundle(jdkFile.getPath());
                                if (selectedJdk == null) {
                                    selectedJdk = JdkBundle.createBundle(jdkFile, false, false);
                                    if (selectedJdk == null) {
                                        LOG.error("Cannot create bundle for path: " + jdkFile.getPath());
                                        return;
                                    }
                                    pathsList.addBundle(selectedJdk, true);
                                    if (model.getSize() > 0) {
                                        jdkBundleItem = new JdkBundleItem(selectedJdk);
                                        model.insertElementAt(jdkBundleItem, model.getSize() - 1);
                                    } else {
                                        jdkBundleItem = new JdkBundleItem(selectedJdk);
                                        model.addElement(jdkBundleItem);
                                    }
                                } else {
                                    jdkBundleItem = new JdkBundleItem(selectedJdk);
                                }
                                myComboBox.setSelectedItem((Object)jdkBundleItem);
                            }
                        });
                    }
                    if ((item = (JdkBundleItem)myComboBox.getSelectedItem()) == null || item.getBundle() == null) {
                        item = (JdkBundleItem)model.getElementAt(0);
                        myComboBox.setSelectedItem((Object)item);
                    }
                    this.setOKActionEnabled(item.getBundle() != null && !item.getBundle().isBoot());
                }
            });
            this.myComboBox.putClientProperty((Object)"JComboBox.isTableCellEditor", (Object)Boolean.TRUE);
            this.setTitle("Switch IDE Boot JDK");
            this.setOKActionEnabled(false);
            this.init();
        }

        @Nullable
        protected JComponent createNorthPanel() {
            return new JBLabel("Select Boot JDK");
        }

        @Nullable
        protected JComponent createCenterPanel() {
            JPanel panel2 = new JPanel(new BorderLayout());
            panel2.add((Component)this.myComboBox, "Center");
            ActionToolbarImpl toolbar = (ActionToolbarImpl)ActionManager.getInstance().createActionToolbar("SwitchBootJDKCopyAction", (ActionGroup)new DefaultActionGroup(new AnAction[]{ActionManager.getInstance().getAction("$Copy")}), true);
            toolbar.setReservePlaceAutoPopupIcon(false);
            panel2.add((Component)toolbar, "East");
            return panel2;
        }

        @Nullable
        public JComponent getPreferredFocusedComponent() {
            return this.myComboBox;
        }

        @Nullable
        public File getSelectedFile() {
            JdkBundleItem item = (JdkBundleItem)this.myComboBox.getSelectedItem();
            if (item == null) {
                return null;
            }
            JdkBundle bundle = item.getBundle();
            return bundle != null ? bundle.getLocation() : null;
        }

        public void performCopy(@NotNull DataContext dataContext) {
            File file2;
            if (dataContext == null) {
                SwitchBootJdkDialog.$$$reportNull$$$0(0);
            }
            if ((file2 = this.getSelectedFile()) == null) {
                return;
            }
            CopyPasteManager.getInstance().setContents((Transferable)new StringSelection(file2.getAbsolutePath()));
        }

        public boolean isCopyEnabled(@NotNull DataContext dataContext) {
            if (dataContext == null) {
                SwitchBootJdkDialog.$$$reportNull$$$0(1);
            }
            return this.getSelectedFile() != null;
        }

        public boolean isCopyVisible(@NotNull DataContext dataContext) {
            if (dataContext == null) {
                SwitchBootJdkDialog.$$$reportNull$$$0(2);
            }
            return this.getSelectedFile() != null;
        }

        @Nullable
        public Object getData(String dataId) {
            if (PlatformDataKeys.COPY_PROVIDER.is(dataId)) {
                return this;
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "dataContext";
            objectArray2[1] = "com/intellij/openapi/util/SwitchBootJdkAction$SwitchBootJdkDialog";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "performCopy";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isCopyEnabled";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isCopyVisible";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }

        static class JdkBundleItem {
            @Nullable
            private JdkBundle myBundle;

            public JdkBundleItem(@Nullable JdkBundle bundle) {
                this.myBundle = bundle;
            }

            @Nullable
            public JdkBundle getBundle() {
                return this.myBundle;
            }
        }
    }
}

