/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListData;
import com.intellij.openapi.vcs.changes.ChangeListWorker;
import com.intellij.openapi.vcs.changes.DelayedNotificator;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.local.AddList;
import com.intellij.openapi.vcs.changes.local.ChangeListCommand;
import com.intellij.openapi.vcs.changes.local.EditComment;
import com.intellij.openapi.vcs.changes.local.EditName;
import com.intellij.openapi.vcs.changes.local.MoveChanges;
import com.intellij.openapi.vcs.changes.local.RemoveList;
import com.intellij.openapi.vcs.changes.local.SetDefault;
import com.intellij.openapi.vcs.changes.local.SetReadOnly;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Modifier {
    private final ChangeListWorker myWorker;
    private boolean myInsideUpdate;
    private final List<ChangeListCommand> myCommandQueue;
    private final DelayedNotificator myNotificator;

    public Modifier(ChangeListWorker worker, DelayedNotificator notificator) {
        this.myWorker = worker;
        this.myNotificator = notificator;
        this.myCommandQueue = new ArrayList<ChangeListCommand>();
    }

    @NotNull
    public LocalChangeList addChangeList(@NotNull String name, @Nullable String comment, @Nullable ChangeListData data) {
        if (name == null) {
            Modifier.$$$reportNull$$$0(0);
        }
        AddList command = new AddList(name, comment, data);
        this.impl(command);
        LocalChangeList localChangeList = command.getNewListCopy();
        if (localChangeList == null) {
            Modifier.$$$reportNull$$$0(1);
        }
        return localChangeList;
    }

    public void setDefault(String name) {
        SetDefault command = new SetDefault(name);
        this.impl(command);
    }

    public void removeChangeList(@NotNull String name) {
        if (name == null) {
            Modifier.$$$reportNull$$$0(2);
        }
        RemoveList command = new RemoveList(name);
        this.impl(command);
    }

    public void moveChangesTo(String name, @NotNull Change[] changes) {
        if (changes == null) {
            Modifier.$$$reportNull$$$0(3);
        }
        MoveChanges command = new MoveChanges(name, changes);
        this.impl(command);
    }

    public boolean setReadOnly(String name, boolean value) {
        SetReadOnly command = new SetReadOnly(name, value);
        this.impl(command);
        return command.isResult();
    }

    public boolean editName(@NotNull String fromName, @NotNull String toName) {
        if (fromName == null) {
            Modifier.$$$reportNull$$$0(4);
        }
        if (toName == null) {
            Modifier.$$$reportNull$$$0(5);
        }
        EditName command = new EditName(fromName, toName);
        this.impl(command);
        return command.isResult();
    }

    @Nullable
    public String editComment(@NotNull String fromName, @NotNull String newComment) {
        if (fromName == null) {
            Modifier.$$$reportNull$$$0(6);
        }
        if (newComment == null) {
            Modifier.$$$reportNull$$$0(7);
        }
        EditComment command = new EditComment(fromName, newComment);
        this.impl(command);
        return command.getOldComment();
    }

    private void impl(ChangeListCommand command) {
        if (this.myInsideUpdate) {
            command.apply(this.myWorker);
            this.myCommandQueue.add(command);
        } else {
            command.apply(this.myWorker);
            this.myNotificator.callNotify(command);
        }
    }

    public boolean isInsideUpdate() {
        return this.myInsideUpdate;
    }

    public void enterUpdate() {
        this.myInsideUpdate = true;
    }

    public void finishUpdate(@Nullable ChangeListWorker updatedWorker) {
        this.myInsideUpdate = false;
        if (updatedWorker != null) {
            for (ChangeListCommand command : this.myCommandQueue) {
                command.apply(updatedWorker);
            }
        }
        for (ChangeListCommand command : this.myCommandQueue) {
            this.myNotificator.callNotify(command);
        }
        this.myCommandQueue.clear();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/changes/Modifier";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changes";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fromName";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toName";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newComment";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/changes/Modifier";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "addChangeList";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addChangeList";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "removeChangeList";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "moveChangesTo";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "editName";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "editComment";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

