/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.shelf;

import com.intellij.concurrency.JobScheduler;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.impl.LaterInvocator;
import com.intellij.openapi.components.AbstractProjectComponent;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.PathMacroManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diff.impl.patch.ApplyPatchStatus;
import com.intellij.openapi.diff.impl.patch.BaseRevisionTextPatchEP;
import com.intellij.openapi.diff.impl.patch.FilePatch;
import com.intellij.openapi.diff.impl.patch.IdeaTextPatchBuilder;
import com.intellij.openapi.diff.impl.patch.PatchEP;
import com.intellij.openapi.diff.impl.patch.PatchReader;
import com.intellij.openapi.diff.impl.patch.PatchSyntaxException;
import com.intellij.openapi.diff.impl.patch.SelectFilesToAddTextsToPatchPanel;
import com.intellij.openapi.diff.impl.patch.TextFilePatch;
import com.intellij.openapi.diff.impl.patch.UnifiedDiffWriter;
import com.intellij.openapi.diff.impl.patch.apply.ApplyFilePatchBase;
import com.intellij.openapi.diff.impl.patch.formove.CustomBinaryPatchApplier;
import com.intellij.openapi.diff.impl.patch.formove.PatchApplier;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.options.NonLazySchemeProcessor;
import com.intellij.openapi.options.SchemeManager;
import com.intellij.openapi.options.SchemeManagerFactory;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizable;
import com.intellij.openapi.util.JDOMExternalizerUtil;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsConfiguration;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vcs.VcsType;
import com.intellij.openapi.vcs.changes.BinaryContentRevision;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListChange;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ChangeListUtil;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.CommitContext;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.patch.ApplyPatchDefaultExecutor;
import com.intellij.openapi.vcs.changes.shelf.ShelfFileProcessorUtil;
import com.intellij.openapi.vcs.changes.shelf.ShelvedBinaryFile;
import com.intellij.openapi.vcs.changes.shelf.ShelvedBinaryFilePatch;
import com.intellij.openapi.vcs.changes.shelf.ShelvedChange;
import com.intellij.openapi.vcs.changes.shelf.ShelvedChangeList;
import com.intellij.openapi.vcs.changes.shelf.ShelvedChangesViewManager;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNode;
import com.intellij.openapi.vcs.changes.ui.ChangesViewContentManager;
import com.intellij.openapi.vcs.changes.ui.RollbackChangesDialog;
import com.intellij.openapi.vcs.changes.ui.RollbackWorker;
import com.intellij.openapi.vcs.changes.ui.ShelvedChangeListDragBean;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.project.ProjectKt;
import com.intellij.util.Consumer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PathUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.Topic;
import com.intellij.util.text.CharArrayCharSequence;
import com.intellij.util.ui.UIUtil;
import com.intellij.vcsUtil.FilesProgress;
import com.intellij.vcsUtil.VcsUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.swing.Icon;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jdom.Element;
import org.jdom.Parent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ShelveChangesManager
extends AbstractProjectComponent
implements JDOMExternalizable {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.vcs.changes.shelf.ShelveChangesManager");
    @NonNls
    private static final String ELEMENT_CHANGELIST = "changelist";
    @NonNls
    private static final String ELEMENT_RECYCLED_CHANGELIST = "recycled_changelist";
    @NonNls
    private static final String DEFAULT_PATCH_NAME = "shelved";
    @NonNls
    private static final String REMOVE_FILES_FROM_SHELF_STRATEGY = "remove_strategy";
    @NotNull
    private final PathMacroManager myPathMacroSubstitutor;
    @NotNull
    private SchemeManager<ShelvedChangeList> mySchemeManager;
    private ScheduledFuture<?> myCleaningFuture;
    private boolean myRemoveFilesFromShelf;
    private static final String SHELVE_MANAGER_DIR_PATH = "shelf";
    public static final String DEFAULT_PROJECT_PRESENTATION_PATH = "<Project>/shelf";
    private final MessageBus myBus;
    @NonNls
    private static final String ATTRIBUTE_SHOW_RECYCLED = "show_recycled";
    public static final Topic<ChangeListener> SHELF_TOPIC = new Topic("shelf updates", ChangeListener.class);
    private boolean myShowRecycled;

    public static ShelveChangesManager getInstance(Project project) {
        return (ShelveChangesManager)((Object)project.getComponent(ShelveChangesManager.class));
    }

    @NotNull
    public static String getDefaultShelfPath(@NotNull Project project) {
        if (project == null) {
            ShelveChangesManager.$$$reportNull$$$0(0);
        }
        String string = VcsUtil.getFilePath((VirtualFile)((VirtualFile)ObjectUtils.chooseNotNull((Object)ProjectKt.getProjectStoreDirectory(project.getBaseDir()), (Object)project.getBaseDir())), (String)SHELVE_MANAGER_DIR_PATH).getPath();
        if (string == null) {
            ShelveChangesManager.$$$reportNull$$$0(1);
        }
        return string;
    }

    public ShelveChangesManager(Project project, MessageBus bus) {
        super(project);
        this.myPathMacroSubstitutor = PathMacroManager.getInstance((ComponentManager)this.myProject);
        this.myBus = bus;
        this.mySchemeManager = this.createShelveSchemeManager(project, VcsConfiguration.getInstance((Project)project).CUSTOM_SHELF_PATH);
        this.myCleaningFuture = JobScheduler.getScheduler().scheduleWithFixedDelay(() -> this.cleanSystemUnshelvedOlderOneWeek(), 1L, 1L, TimeUnit.DAYS);
        Disposer.register((Disposable)project, (Disposable)new Disposable(){

            public void dispose() {
                ShelveChangesManager.this.stopCleanScheduler();
            }
        });
        File shelfDirectory = this.mySchemeManager.getRootDirectory();
        if (shelfDirectory.exists()) {
            ChangeListManager.getInstance((Project)project).addDirectoryToIgnoreImplicitly(shelfDirectory.getAbsolutePath());
        }
    }

    private void stopCleanScheduler() {
        if (this.myCleaningFuture != null) {
            this.myCleaningFuture.cancel(false);
            this.myCleaningFuture = null;
        }
    }

    @NotNull
    private SchemeManager<ShelvedChangeList> createShelveSchemeManager(@NotNull Project project, @Nullable String customPath) {
        if (project == null) {
            ShelveChangesManager.$$$reportNull$$$0(2);
        }
        FilePath customShelfFilePath = customPath != null ? VcsUtil.getFilePath((String)this.myPathMacroSubstitutor.expandPath(customPath)) : null;
        final boolean shouldCollapsePath = !VcsConfiguration.getInstance((Project)this.myProject).USE_CUSTOM_SHELF_PATH;
        SchemeManager<ShelvedChangeList> schemeManager2 = SchemeManagerFactory.getInstance(project).create(customShelfFilePath != null ? customShelfFilePath.getName() : SHELVE_MANAGER_DIR_PATH, new NonLazySchemeProcessor<ShelvedChangeList, ShelvedChangeList>(){

            @Override
            @NotNull
            public ShelvedChangeList readScheme(@NotNull Element element, boolean duringLoad) throws InvalidDataException {
                if (element == null) {
                    2.$$$reportNull$$$0(0);
                }
                ShelvedChangeList shelvedChangeList = ShelveChangesManager.this.readOneShelvedChangeList(element);
                if (shelvedChangeList == null) {
                    2.$$$reportNull$$$0(1);
                }
                return shelvedChangeList;
            }

            @Override
            @NotNull
            public Parent writeScheme(@NotNull ShelvedChangeList scheme2) throws WriteExternalException {
                if (scheme2 == null) {
                    2.$$$reportNull$$$0(2);
                }
                Element child = new Element(ShelveChangesManager.ELEMENT_CHANGELIST);
                scheme2.writeExternal(child);
                if (shouldCollapsePath) {
                    ShelveChangesManager.this.myPathMacroSubstitutor.collapsePaths(child);
                }
                Element element = child;
                if (element == null) {
                    2.$$$reportNull$$$0(3);
                }
                return element;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: 
                    case 3: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: 
                    case 3: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "element";
                        break;
                    }
                    case 1: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/openapi/vcs/changes/shelf/ShelveChangesManager$2";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "scheme";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/openapi/vcs/changes/shelf/ShelveChangesManager$2";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "readScheme";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "writeScheme";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "readScheme";
                        break;
                    }
                    case 1: 
                    case 3: {
                        break;
                    }
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "writeScheme";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: 
                    case 3: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        }, null, customPath != null ? Paths.get(customPath, new String[0]) : null);
        if (schemeManager2 == null) {
            ShelveChangesManager.$$$reportNull$$$0(3);
        }
        return schemeManager2;
    }

    public void projectOpened() {
        try {
            this.mySchemeManager.loadSchemes();
            this.filterNonValidShelvedChangeLists();
            this.cleanSystemUnshelvedOlderOneWeek();
        }
        catch (Exception e) {
            LOG.error("Couldn't read shelf information", (Throwable)e);
        }
    }

    private void filterNonValidShelvedChangeLists() {
        ArrayList allSchemes = ContainerUtil.newArrayList(this.mySchemeManager.getAllSchemes());
        ContainerUtil.process((List)allSchemes, shelvedChangeList -> {
            if (!shelvedChangeList.isValid()) {
                this.mySchemeManager.removeScheme((ShelvedChangeList)shelvedChangeList);
            }
            return true;
        });
    }

    public void checkAndMigrateUnderProgress(final @NotNull File fromFile, final @NotNull File toFile, final boolean wasCustom) {
        if (fromFile == null) {
            ShelveChangesManager.$$$reportNull$$$0(4);
        }
        if (toFile == null) {
            ShelveChangesManager.$$$reportNull$$$0(5);
        }
        final SchemeManager<ShelvedChangeList> newSchemeManager = this.createShelveSchemeManager(this.myProject, VcsUtil.getFilePath((File)toFile).getPath());
        newSchemeManager.loadSchemes();
        if (VcsConfiguration.getInstance((Project)this.myProject).MOVE_SHELVES && fromFile.exists()) {
            new Task.Modal(this.myProject, "Moving Shelves to the New Directory...", true){

                public void run(@NotNull ProgressIndicator indicator) {
                    if (indicator == null) {
                        3.$$$reportNull$$$0(0);
                    }
                    for (ShelvedChangeList list2 : ShelveChangesManager.this.mySchemeManager.getAllSchemes()) {
                        if (!list2.isValid()) continue;
                        ShelvedChangeList migratedList = ShelvedChangeList.copy(list2);
                        File newTargetDirectory = ShelveChangesManager.suggestPatchName(this.myProject, migratedList.DESCRIPTION, toFile, "");
                        ShelveChangesManager.migrateResourcesTo(migratedList, newTargetDirectory, false);
                        newSchemeManager.addScheme(migratedList, false);
                        indicator.checkCanceled();
                    }
                    ShelveChangesManager.this.clearShelvedLists(ShelveChangesManager.this.mySchemeManager.getAllSchemes(), false);
                }

                public void onSuccess() {
                    super.onSuccess();
                    ShelveChangesManager.this.updateShelveSchemaManager(newSchemeManager);
                }

                public void onCancel() {
                    super.onCancel();
                    this.suggestToCancelMigrationOrRevertPathToPrevious();
                }

                private void suggestToCancelMigrationOrRevertPathToPrevious() {
                    if (Messages.showOkCancelDialog((Project)this.myProject, (String)"Shelves moving failed. <br/>Would you like to use new shelf directory path or revert it to previous?", (String)"Shelf Error", (String)"&Use New", (String)"&Revert", (Icon)UIUtil.getWarningIcon()) == 0) {
                        ShelveChangesManager.this.updateShelveSchemaManager(newSchemeManager);
                    } else {
                        VcsConfiguration vcsConfiguration = VcsConfiguration.getInstance((Project)this.myProject);
                        vcsConfiguration.USE_CUSTOM_SHELF_PATH = wasCustom;
                        if (wasCustom) {
                            vcsConfiguration.CUSTOM_SHELF_PATH = FileUtil.toSystemIndependentName((String)fromFile.getPath());
                        }
                    }
                }

                public void onThrowable(@NotNull Throwable error) {
                    if (error == null) {
                        3.$$$reportNull$$$0(1);
                    }
                    super.onThrowable(error);
                    this.suggestToCancelMigrationOrRevertPathToPrevious();
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "indicator";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "error";
                            break;
                        }
                    }
                    objectArray2[1] = "com/intellij/openapi/vcs/changes/shelf/ShelveChangesManager$3";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "run";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[2] = "onThrowable";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            }.queue();
        } else {
            this.updateShelveSchemaManager(newSchemeManager);
        }
    }

    private void updateShelveSchemaManager(SchemeManager<ShelvedChangeList> newSchemeManager) {
        this.myProject.save();
        ApplicationManager.getApplication().saveSettings();
        SchemeManagerFactory.getInstance(this.myProject).dispose(this.mySchemeManager);
        this.mySchemeManager = newSchemeManager;
        this.notifyStateChanged();
    }

    @NotNull
    public File getShelfResourcesDirectory() {
        File file2 = this.mySchemeManager.getRootDirectory();
        if (file2 == null) {
            ShelveChangesManager.$$$reportNull$$$0(6);
        }
        return file2;
    }

    @NotNull
    private ShelvedChangeList readOneShelvedChangeList(@NotNull Element element) throws InvalidDataException {
        if (element == null) {
            ShelveChangesManager.$$$reportNull$$$0(7);
        }
        ShelvedChangeList data = new ShelvedChangeList();
        this.myPathMacroSubstitutor.expandPaths(element);
        data.readExternal(element);
        ShelvedChangeList shelvedChangeList = data;
        if (shelvedChangeList == null) {
            ShelveChangesManager.$$$reportNull$$$0(8);
        }
        return shelvedChangeList;
    }

    @NonNls
    @NotNull
    public String getComponentName() {
        if ("ShelveChangesManager" == null) {
            ShelveChangesManager.$$$reportNull$$$0(9);
        }
        return "ShelveChangesManager";
    }

    public void readExternal(Element element) throws InvalidDataException {
        this.myShowRecycled = Boolean.parseBoolean(element.getAttributeValue(ATTRIBUTE_SHOW_RECYCLED));
        this.myRemoveFilesFromShelf = Boolean.parseBoolean(JDOMExternalizerUtil.readField((Element)element, (String)REMOVE_FILES_FROM_SHELF_STRATEGY));
        this.migrateOldShelfInfo(element, true);
        this.migrateOldShelfInfo(element, false);
    }

    private void migrateOldShelfInfo(@NotNull Element element, boolean recycled) throws InvalidDataException {
        Element changeSetElement;
        ShelvedChangeList list2;
        if (element == null) {
            ShelveChangesManager.$$$reportNull$$$0(10);
        }
        Iterator iterator = element.getChildren(recycled ? ELEMENT_RECYCLED_CHANGELIST : ELEMENT_CHANGELIST).iterator();
        while (iterator.hasNext() && (list2 = this.readOneShelvedChangeList(changeSetElement = (Element)iterator.next())).isValid()) {
            File uniqueDir = this.generateUniqueSchemePatchDir(list2.DESCRIPTION, false);
            list2.setName(uniqueDir.getName());
            list2.setRecycled(recycled);
            this.mySchemeManager.addScheme(list2, false);
        }
    }

    @NotNull
    public Collection<String> checkAndMigrateOldPatchResourcesToNewSchemeStorage() {
        ArrayList nonMigratedPaths = ContainerUtil.newArrayList();
        for (ShelvedChangeList list2 : this.mySchemeManager.getAllSchemes()) {
            File newPatchDir = new File(this.getShelfResourcesDirectory(), list2.getName());
            if (newPatchDir.exists() || !newPatchDir.mkdirs()) continue;
            nonMigratedPaths.addAll(ShelveChangesManager.migrateResourcesTo(list2, newPatchDir, true));
        }
        ArrayList arrayList = nonMigratedPaths;
        if (arrayList == null) {
            ShelveChangesManager.$$$reportNull$$$0(11);
        }
        return arrayList;
    }

    @NotNull
    private static Collection<String> migrateResourcesTo(@NotNull ShelvedChangeList list2, @NotNull File targetDirectory, boolean deleteOld) {
        if (list2 == null) {
            ShelveChangesManager.$$$reportNull$$$0(12);
        }
        if (targetDirectory == null) {
            ShelveChangesManager.$$$reportNull$$$0(13);
        }
        ArrayList nonMigratedPaths = ContainerUtil.newArrayList();
        File patchFile = new File(list2.PATH);
        if (patchFile.exists()) {
            File newPatchFile = ShelveChangesManager.getPatchFileInConfigDir(targetDirectory);
            try {
                FileUtil.copy((File)patchFile, (File)newPatchFile);
                list2.PATH = FileUtil.toSystemIndependentName((String)newPatchFile.getPath());
                if (deleteOld) {
                    FileUtil.delete((File)patchFile);
                }
            }
            catch (IOException e) {
                nonMigratedPaths.add(list2.PATH);
            }
        }
        for (ShelvedBinaryFile file2 : list2.getBinaryFiles()) {
            if (file2.SHELVED_PATH == null) continue;
            File shelvedFile = new File(file2.SHELVED_PATH);
            if (StringUtil.isEmptyOrSpaces((String)file2.AFTER_PATH) || !shelvedFile.exists()) continue;
            File newShelvedFile = new File(targetDirectory, PathUtil.getFileName((String)file2.AFTER_PATH));
            try {
                FileUtil.copy((File)shelvedFile, (File)newShelvedFile);
                file2.SHELVED_PATH = FileUtil.toSystemIndependentName((String)newShelvedFile.getPath());
                if (!deleteOld) continue;
                FileUtil.delete((File)shelvedFile);
            }
            catch (IOException e) {
                nonMigratedPaths.add(shelvedFile.getPath());
            }
        }
        ArrayList arrayList = nonMigratedPaths;
        if (arrayList == null) {
            ShelveChangesManager.$$$reportNull$$$0(14);
        }
        return arrayList;
    }

    public void writeExternal(Element element) throws WriteExternalException {
        if (this.myShowRecycled) {
            element.setAttribute(ATTRIBUTE_SHOW_RECYCLED, Boolean.toString(true));
        }
        if (this.isRemoveFilesFromShelf()) {
            JDOMExternalizerUtil.writeField((Element)element, (String)REMOVE_FILES_FROM_SHELF_STRATEGY, (String)Boolean.toString(true));
        }
    }

    @NotNull
    public List<ShelvedChangeList> getShelvedChangeLists() {
        List<ShelvedChangeList> list2 = this.getRecycled(false);
        if (list2 == null) {
            ShelveChangesManager.$$$reportNull$$$0(15);
        }
        return list2;
    }

    @NotNull
    private List<ShelvedChangeList> getRecycled(boolean recycled) {
        List list3 = ContainerUtil.newUnmodifiableList((List)ContainerUtil.filter(this.mySchemeManager.getAllSchemes(), list2 -> recycled == list2.isRecycled()));
        if (list3 == null) {
            ShelveChangesManager.$$$reportNull$$$0(16);
        }
        return list3;
    }

    public ShelvedChangeList shelveChanges(Collection<Change> changes, String commitMessage, boolean rollback) throws IOException, VcsException {
        return this.shelveChanges(changes, commitMessage, rollback, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ShelvedChangeList shelveChanges(Collection<Change> changes, String commitMessage, boolean rollback, boolean markToBeDeleted) throws IOException, VcsException {
        ShelvedChangeList changeList;
        ProgressIndicator progressIndicator = ProgressManager.getInstance().getProgressIndicator();
        if (progressIndicator != null) {
            progressIndicator.setText(VcsBundle.message((String)"shelve.changes.progress.title", (Object[])new Object[0]));
        }
        File schemePatchDir = this.generateUniqueSchemePatchDir(commitMessage, true);
        ArrayList<Change> textChanges = new ArrayList<Change>();
        ArrayList<ShelvedBinaryFile> binaryFiles = new ArrayList<ShelvedBinaryFile>();
        for (Change change : changes) {
            if (ChangesUtil.getFilePath((Change)change).isDirectory()) continue;
            if (change.getBeforeRevision() instanceof BinaryContentRevision || change.getAfterRevision() instanceof BinaryContentRevision) {
                binaryFiles.add(this.shelveBinaryFile(schemePatchDir, change));
                continue;
            }
            textChanges.add(change);
        }
        try {
            File patchFile = ShelveChangesManager.getPatchFileInConfigDir(schemePatchDir);
            ProgressManager.checkCanceled();
            List<FilePatch> patches = IdeaTextPatchBuilder.buildPatch(this.myProject, textChanges, this.myProject.getBaseDir().getPresentableUrl(), false);
            ProgressManager.checkCanceled();
            CommitContext commitContext = new CommitContext();
            this.baseRevisionsOfDvcsIntoContext(textChanges, commitContext);
            ShelfFileProcessorUtil.savePatchFile(this.myProject, patchFile, patches, null, commitContext);
            changeList = new ShelvedChangeList(patchFile.toString(), commitMessage.replace('\n', ' '), binaryFiles);
            changeList.markToDelete(markToBeDeleted);
            changeList.setName(schemePatchDir.getName());
            ProgressManager.checkCanceled();
            this.mySchemeManager.addScheme(changeList, false);
            if (rollback) {
                this.rollbackChangesAfterShelve(changes);
            }
        }
        finally {
            this.notifyStateChanged();
        }
        return changeList;
    }

    private void rollbackChangesAfterShelve(@NotNull Collection<Change> changes) {
        ProgressIndicator progressIndicator;
        if (changes == null) {
            ShelveChangesManager.$$$reportNull$$$0(17);
        }
        if ((progressIndicator = ProgressManager.getInstance().getProgressIndicator()) != null) {
            progressIndicator.startNonCancelableSection();
        }
        String operationName = UIUtil.removeMnemonic((String)RollbackChangesDialog.operationNameByChanges(this.myProject, changes));
        boolean modalContext = ApplicationManager.getApplication().isDispatchThread() && LaterInvocator.isInModalContext();
        new RollbackWorker(this.myProject, operationName, modalContext).doRollback(changes, true, null, VcsBundle.message((String)"shelve.changes.action", (Object[])new Object[0]));
    }

    @NotNull
    private static File getPatchFileInConfigDir(@NotNull File schemePatchDir) {
        if (schemePatchDir == null) {
            ShelveChangesManager.$$$reportNull$$$0(18);
        }
        File file2 = new File(schemePatchDir, "shelved.patch");
        if (file2 == null) {
            ShelveChangesManager.$$$reportNull$$$0(19);
        }
        return file2;
    }

    private void baseRevisionsOfDvcsIntoContext(List<Change> textChanges, CommitContext commitContext) {
        ProjectLevelVcsManager vcsManager = ProjectLevelVcsManager.getInstance((Project)this.myProject);
        if (this.dvcsUsedInProject() && VcsConfiguration.getInstance((Project)this.myProject).INCLUDE_TEXT_INTO_SHELF) {
            Set<Change> big = SelectFilesToAddTextsToPatchPanel.getBig(textChanges);
            ArrayList<FilePath> toKeep = new ArrayList<FilePath>();
            for (Change change : textChanges) {
                FilePath filePath;
                AbstractVcs vcs;
                if (change.getBeforeRevision() == null || change.getAfterRevision() == null || big.contains(change) || (vcs = vcsManager.getVcsFor(filePath = ChangesUtil.getFilePath((Change)change))) == null || !VcsType.distributed.equals((Object)vcs.getType())) continue;
                toKeep.add(filePath);
            }
            commitContext.putUserData(BaseRevisionTextPatchEP.ourPutBaseRevisionTextKey, (Object)true);
            commitContext.putUserData(BaseRevisionTextPatchEP.ourBaseRevisionPaths, toKeep);
        }
    }

    private boolean dvcsUsedInProject() {
        return Arrays.stream(ProjectLevelVcsManager.getInstance((Project)this.myProject).getAllActiveVcss()).anyMatch(vcs -> VcsType.distributed.equals((Object)vcs.getType()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ShelvedChangeList importFilePatches(String fileName, List<FilePatch> patches, PatchEP[] patchTransitExtensions) throws IOException {
        try {
            File schemePatchDir = this.generateUniqueSchemePatchDir(fileName, true);
            File patchFile = ShelveChangesManager.getPatchFileInConfigDir(schemePatchDir);
            ShelfFileProcessorUtil.savePatchFile(this.myProject, patchFile, patches, patchTransitExtensions, new CommitContext());
            ShelvedChangeList changeList = new ShelvedChangeList(patchFile.toString(), fileName.replace('\n', ' '), (List<ShelvedBinaryFile>)new SmartList());
            changeList.setName(schemePatchDir.getName());
            this.mySchemeManager.addScheme(changeList, false);
            ShelvedChangeList shelvedChangeList = changeList;
            return shelvedChangeList;
        }
        finally {
            this.notifyStateChanged();
        }
    }

    public List<VirtualFile> gatherPatchFiles(Collection<VirtualFile> files) {
        ArrayList<VirtualFile> result2 = new ArrayList<VirtualFile>();
        LinkedList<VirtualFile> filesQueue = new LinkedList<VirtualFile>(files);
        while (!filesQueue.isEmpty()) {
            ProgressManager.checkCanceled();
            VirtualFile file2 = filesQueue.removeFirst();
            if (file2.isDirectory()) {
                filesQueue.addAll(Arrays.asList(file2.getChildren()));
                continue;
            }
            if (!"PATCH".equals(file2.getFileType().getName())) continue;
            result2.add(file2);
        }
        return result2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ShelvedChangeList> importChangeLists(Collection<VirtualFile> files, Consumer<VcsException> exceptionConsumer) {
        ArrayList<ShelvedChangeList> result2 = new ArrayList<ShelvedChangeList>(files.size());
        try {
            FilesProgress filesProgress = new FilesProgress(files.size(), "Processing ");
            for (VirtualFile file2 : files) {
                filesProgress.updateIndicator(file2);
                String description = file2.getNameWithoutExtension().replace('_', ' ');
                File schemeNameDir = this.generateUniqueSchemePatchDir(description, true);
                File patchPath = ShelveChangesManager.getPatchFileInConfigDir(schemeNameDir);
                ShelvedChangeList list2 = new ShelvedChangeList(patchPath.getPath(), description, (List<ShelvedBinaryFile>)new SmartList(), file2.getTimeStamp());
                list2.setName(schemeNameDir.getName());
                try {
                    List<TextFilePatch> patchesList = ShelveChangesManager.loadPatches(this.myProject, file2.getPath(), new CommitContext());
                    if (patchesList.isEmpty()) continue;
                    FileUtil.copy((File)new File(file2.getPath()), (File)patchPath);
                    this.mySchemeManager.addScheme(list2, false);
                    result2.add(list2);
                }
                catch (PatchSyntaxException | IOException e) {
                    exceptionConsumer.consume((Object)new VcsException((Throwable)e));
                }
            }
        }
        finally {
            this.notifyStateChanged();
        }
        return result2;
    }

    private ShelvedBinaryFile shelveBinaryFile(@NotNull File schemePatchDir, Change change) throws IOException {
        if (schemePatchDir == null) {
            ShelveChangesManager.$$$reportNull$$$0(20);
        }
        ContentRevision beforeRevision = change.getBeforeRevision();
        ContentRevision afterRevision = change.getAfterRevision();
        File beforeFile = beforeRevision == null ? null : beforeRevision.getFile().getIOFile();
        File afterFile = afterRevision == null ? null : afterRevision.getFile().getIOFile();
        String shelvedPath = null;
        if (afterFile != null) {
            String shelvedFileName = afterFile.getName();
            String name = FileUtil.getNameWithoutExtension((String)shelvedFileName);
            String extension = FileUtilRt.getExtension((String)shelvedFileName);
            File shelvedFile = FileUtil.findSequentNonexistentFile((File)schemePatchDir, (String)name, (String)extension);
            FileUtil.copy((File)afterRevision.getFile().getIOFile(), (File)shelvedFile);
            shelvedPath = shelvedFile.getPath();
        }
        String beforePath = ChangesUtil.getProjectRelativePath((Project)this.myProject, (File)beforeFile);
        String afterPath = ChangesUtil.getProjectRelativePath((Project)this.myProject, (File)afterFile);
        return new ShelvedBinaryFile(beforePath, afterPath, shelvedPath);
    }

    private void notifyStateChanged() {
        if (!this.myProject.isDisposed()) {
            ((ChangeListener)this.myBus.syncPublisher(SHELF_TOPIC)).stateChanged(new ChangeEvent((Object)this));
        }
    }

    @NotNull
    private File generateUniqueSchemePatchDir(@Nullable String defaultName, boolean createResourceDirectory) {
        this.ignoreShelfDirectoryIfFirstShelf();
        File shelfResourcesDirectory = this.getShelfResourcesDirectory();
        File dir = ShelveChangesManager.suggestPatchName(this.myProject, defaultName, shelfResourcesDirectory, "");
        if (createResourceDirectory && !dir.exists()) {
            dir.mkdirs();
        }
        File file2 = dir;
        if (file2 == null) {
            ShelveChangesManager.$$$reportNull$$$0(21);
        }
        return file2;
    }

    private void ignoreShelfDirectoryIfFirstShelf() {
        File shelfDir = this.getShelfResourcesDirectory();
        if (!shelfDir.exists()) {
            ChangeListManager.getInstance((Project)this.myProject).addDirectoryToIgnoreImplicitly(shelfDir.getAbsolutePath());
        }
    }

    @NotNull
    public static File suggestPatchName(Project project, @Nullable String commitMessage, File file2, String extension) {
        File nonexistentFile;
        String defaultPath = ShelveChangesManager.shortenAndSanitize(commitMessage);
        while ((nonexistentFile = FileUtil.findSequentNonexistentFile((File)file2, (String)defaultPath, (String)(extension == null ? VcsConfiguration.getInstance((Project)project).getPatchFileExtension() : extension))).getName().length() >= 100) {
            defaultPath = defaultPath.substring(0, defaultPath.length() - 1);
        }
        File file3 = nonexistentFile;
        if (file3 == null) {
            ShelveChangesManager.$$$reportNull$$$0(22);
        }
        return file3;
    }

    @NotNull
    private static String shortenAndSanitize(@Nullable String commitMessage) {
        String defaultPath = PathUtil.suggestFileName((String)StringUtil.notNullize((String)commitMessage));
        if (defaultPath.isEmpty()) {
            defaultPath = "unnamed";
        }
        if (defaultPath.length() > 90) {
            defaultPath = defaultPath.substring(0, 90);
        }
        String string = defaultPath;
        if (string == null) {
            ShelveChangesManager.$$$reportNull$$$0(23);
        }
        return string;
    }

    public void unshelveChangeList(ShelvedChangeList changeList, @Nullable List<ShelvedChange> changes, @Nullable List<ShelvedBinaryFile> binaryFiles, @Nullable LocalChangeList targetChangeList, boolean showSuccessNotification) {
        this.unshelveChangeList(changeList, changes, binaryFiles, targetChangeList, showSuccessNotification, false, false, null, null);
    }

    public void unshelveChangeList(ShelvedChangeList changeList, @Nullable List<ShelvedChange> changes, @Nullable List<ShelvedBinaryFile> binaryFiles, @Nullable LocalChangeList targetChangeList, boolean showSuccessNotification, boolean systemOperation, boolean reverse, String leftConflictTitle, String rightConflictTitle) {
        List<TextFilePatch> textFilePatches;
        ArrayList<FilePatch> remainingPatches = new ArrayList<FilePatch>();
        CommitContext commitContext = new CommitContext();
        try {
            textFilePatches = ShelveChangesManager.loadTextPatches(this.myProject, changeList, changes, remainingPatches, commitContext);
        }
        catch (IOException e) {
            LOG.info((Throwable)e);
            PatchApplier.showError(this.myProject, "Cannot load patch(es): " + e.getMessage());
            return;
        }
        catch (PatchSyntaxException e) {
            PatchApplier.showError(this.myProject, "Cannot load patch(es): " + e.getMessage());
            LOG.info((Throwable)e);
            return;
        }
        ArrayList<TextFilePatch> patches = new ArrayList<TextFilePatch>(textFilePatches);
        ArrayList<ShelvedBinaryFile> remainingBinaries = new ArrayList<ShelvedBinaryFile>();
        List<ShelvedBinaryFile> binaryFilesToUnshelve = ShelveChangesManager.getBinaryFilesToUnshelve(changeList, binaryFiles, remainingBinaries);
        for (ShelvedBinaryFile shelvedBinaryFile : binaryFilesToUnshelve) {
            patches.add((TextFilePatch)new ShelvedBinaryFilePatch(shelvedBinaryFile));
        }
        ApplicationManager.getApplication().invokeAndWait(() -> {
            BinaryPatchApplier binaryPatchApplier = new BinaryPatchApplier();
            PatchApplier<ShelvedBinaryFilePatch> patchApplier = new PatchApplier<ShelvedBinaryFilePatch>(this.myProject, this.myProject.getBaseDir(), (List<FilePatch>)patches, targetChangeList, binaryPatchApplier, commitContext, reverse, leftConflictTitle, rightConflictTitle);
            patchApplier.setIsSystemOperation(systemOperation);
            patchApplier.execute(showSuccessNotification, systemOperation);
            if (this.isRemoveFilesFromShelf() || systemOperation) {
                remainingPatches.addAll(patchApplier.getRemainingPatches());
                if (remainingPatches.isEmpty() && remainingBinaries.isEmpty()) {
                    this.recycleChangeList(changeList);
                } else {
                    this.saveRemainingPatches(changeList, remainingPatches, remainingBinaries, commitContext);
                }
            }
        });
    }

    private static List<TextFilePatch> loadTextPatches(Project project, ShelvedChangeList changeList, List<ShelvedChange> changes, List<FilePatch> remainingPatches, CommitContext commitContext) throws IOException, PatchSyntaxException {
        List<TextFilePatch> textFilePatches = ShelveChangesManager.loadPatches(project, changeList.PATH, commitContext);
        if (changes != null) {
            Iterator<TextFilePatch> iterator = textFilePatches.iterator();
            while (iterator.hasNext()) {
                TextFilePatch patch = iterator.next();
                if (ShelveChangesManager.needUnshelve((FilePatch)patch, changes)) continue;
                remainingPatches.add((FilePatch)patch);
                iterator.remove();
            }
        }
        return textFilePatches;
    }

    public void setRemoveFilesFromShelf(boolean removeFilesFromShelf) {
        this.myRemoveFilesFromShelf = removeFilesFromShelf;
    }

    public boolean isRemoveFilesFromShelf() {
        return this.myRemoveFilesFromShelf;
    }

    private void cleanSystemUnshelvedOlderOneWeek() {
        Calendar cal = Calendar.getInstance();
        cal.add(5, -7);
        this.cleanUnshelved(true, cal.getTimeInMillis());
    }

    public void cleanUnshelved(boolean onlyMarkedToDelete, long timeBefore) {
        Date limitDate = new Date(timeBefore);
        List toDelete = ContainerUtil.filter(this.mySchemeManager.getAllSchemes(), list2 -> list2.isRecycled() && list2.DATE.before(limitDate) && (!onlyMarkedToDelete || list2.isMarkedToDelete()));
        this.clearShelvedLists(toDelete, true);
    }

    public void shelveSilentlyUnderProgress(@NotNull List<Change> changes) {
        if (changes == null) {
            ShelveChangesManager.$$$reportNull$$$0(24);
        }
        ArrayList result2 = ContainerUtil.newArrayList();
        boolean completed = (Boolean)ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> {
            if (changes == null) {
                ShelveChangesManager.$$$reportNull$$$0(46);
            }
            return result2.addAll(this.shelveChangesInSeparatedLists(changes));
        }, VcsBundle.getString((String)"shelve.changes.progress.title"), true, this.myProject);
        if (completed) {
            VcsNotifier.getInstance(this.myProject).notifySuccess("Changes shelved successfully");
            if (result2.size() == 1 && this.isShelfContentActive()) {
                ShelvedChangesViewManager.getInstance(this.myProject).startEditing((ShelvedChangeList)result2.get(0));
            }
        }
    }

    private boolean isShelfContentActive() {
        return ToolWindowManager.getInstance((Project)this.myProject).getToolWindow(ChangesViewContentManager.TOOLWINDOW_ID).isVisible() && ((ChangesViewContentManager)ChangesViewContentManager.getInstance(this.myProject)).isContentSelected("Shelf");
    }

    @NotNull
    public List<ShelvedChangeList> shelveChangesInSeparatedLists(@NotNull Collection<Change> changes) {
        if (changes == null) {
            ShelveChangesManager.$$$reportNull$$$0(25);
        }
        ArrayList failedChangeLists = ContainerUtil.newArrayList();
        ArrayList result2 = ContainerUtil.newArrayList();
        ArrayList shelvedChanges = ContainerUtil.newArrayList();
        List changeLists = ChangeListManager.getInstance((Project)this.myProject).getChangeLists();
        for (LocalChangeList list2 : changeLists) {
            HashSet changeSet = new HashSet(list2.getChanges());
            ArrayList<Change> changesForChangelist = new ArrayList<Change>();
            for (Change change : changes) {
                boolean inChangelist = change instanceof ChangeListChange ? ((ChangeListChange)change).getChangeListId().equals(list2.getId()) : changeSet.contains(change);
                if (!inChangelist) continue;
                changesForChangelist.add(change);
            }
            if (changesForChangelist.isEmpty()) continue;
            try {
                result2.add(this.shelveChanges(changesForChangelist, list2.getName(), false));
                shelvedChanges.addAll(changesForChangelist);
            }
            catch (Exception e) {
                LOG.warn((Throwable)e);
                failedChangeLists.add(list2.getName());
            }
        }
        this.rollbackChangesAfterShelve(shelvedChanges);
        if (!failedChangeLists.isEmpty()) {
            VcsNotifier.getInstance(this.myProject).notifyError("Shelf Failed", String.format("Shelving changes for %s [%s] failed", StringUtil.pluralize((String)ELEMENT_CHANGELIST, (int)failedChangeLists.size()), StringUtil.join((Collection)failedChangeLists, (String)",")));
        }
        ArrayList arrayList = result2;
        if (arrayList == null) {
            ShelveChangesManager.$$$reportNull$$$0(26);
        }
        return arrayList;
    }

    public static void unshelveSilentlyWithDnd(@NotNull Project project, @NotNull ShelvedChangeListDragBean shelvedChangeListDragBean, @Nullable ChangesBrowserNode dropRootNode) {
        if (project == null) {
            ShelveChangesManager.$$$reportNull$$$0(27);
        }
        if (shelvedChangeListDragBean == null) {
            ShelveChangesManager.$$$reportNull$$$0(28);
        }
        FileDocumentManager.getInstance().saveAllDocuments();
        LocalChangeList predefinedChangeList = dropRootNode != null ? (LocalChangeList)ObjectUtils.tryCast(dropRootNode.getUserObject(), LocalChangeList.class) : null;
        ShelveChangesManager.getInstance(project).unshelveSilentlyAsynchronously(project, shelvedChangeListDragBean.getShelvedChangelists(), shelvedChangeListDragBean.getChanges(), shelvedChangeListDragBean.getBinaryFiles(), predefinedChangeList);
    }

    public void unshelveSilentlyAsynchronously(@NotNull Project project, final @NotNull List<ShelvedChangeList> selectedChangeLists, final @NotNull List<ShelvedChange> selectedChanges, final @NotNull List<ShelvedBinaryFile> selectedBinaryChanges, final @Nullable LocalChangeList forcePredefinedOneChangelist) {
        if (project == null) {
            ShelveChangesManager.$$$reportNull$$$0(29);
        }
        if (selectedChangeLists == null) {
            ShelveChangesManager.$$$reportNull$$$0(30);
        }
        if (selectedChanges == null) {
            ShelveChangesManager.$$$reportNull$$$0(31);
        }
        if (selectedBinaryChanges == null) {
            ShelveChangesManager.$$$reportNull$$$0(32);
        }
        ProgressManager.getInstance().run((Task)new Task.Backgroundable(project, VcsBundle.getString((String)"unshelve.changes.progress.title"), true){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    4.$$$reportNull$$$0(0);
                }
                for (ShelvedChangeList changeList : selectedChangeLists) {
                    ArrayList changesForChangelist = ContainerUtil.newArrayList((Iterable)ContainerUtil.intersection(changeList.getChanges(this.myProject), (Collection)selectedChanges));
                    ArrayList binariesForChangelist = ContainerUtil.newArrayList((Iterable)ContainerUtil.intersection(changeList.getBinaryFiles(), (Collection)selectedBinaryChanges));
                    boolean shouldUnshelveAllList = changesForChangelist.isEmpty() && binariesForChangelist.isEmpty();
                    ShelveChangesManager.this.unshelveChangeList(changeList, shouldUnshelveAllList ? null : changesForChangelist, shouldUnshelveAllList ? null : binariesForChangelist, forcePredefinedOneChangelist != null ? forcePredefinedOneChangelist : ShelveChangesManager.this.getChangeListUnshelveTo(changeList), true);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/openapi/vcs/changes/shelf/ShelveChangesManager$4", "run"));
            }
        });
    }

    @NotNull
    private LocalChangeList getChangeListUnshelveTo(@NotNull ShelvedChangeList list2) {
        ChangeListManager manager;
        LocalChangeList localChangeList;
        if (list2 == null) {
            ShelveChangesManager.$$$reportNull$$$0(33);
        }
        LocalChangeList localChangeList2 = (localChangeList = ChangeListUtil.getPredefinedChangeList(list2, manager = ChangeListManager.getInstance((Project)this.myProject))) != null ? localChangeList : manager.addChangeList(ChangeListUtil.getChangeListNameForUnshelve(list2), "");
        if (localChangeList2 == null) {
            ShelveChangesManager.$$$reportNull$$$0(34);
        }
        return localChangeList2;
    }

    private static List<ShelvedBinaryFile> getBinaryFilesToUnshelve(ShelvedChangeList changeList, List<ShelvedBinaryFile> binaryFiles, List<ShelvedBinaryFile> remainingBinaries) {
        if (binaryFiles == null) {
            return new ArrayList<ShelvedBinaryFile>(changeList.getBinaryFiles());
        }
        ArrayList<ShelvedBinaryFile> result2 = new ArrayList<ShelvedBinaryFile>();
        for (ShelvedBinaryFile file2 : changeList.getBinaryFiles()) {
            if (binaryFiles.contains(file2)) {
                result2.add(file2);
                continue;
            }
            remainingBinaries.add(file2);
        }
        return result2;
    }

    private void unshelveBinaryFile(ShelvedBinaryFile file2, final @NotNull VirtualFile patchTarget) throws IOException {
        if (patchTarget == null) {
            ShelveChangesManager.$$$reportNull$$$0(35);
        }
        final Ref ex = new Ref();
        final Ref patchedFileRef = new Ref();
        final File shelvedFile = file2.SHELVED_PATH == null ? null : new File(file2.SHELVED_PATH);
        ApplicationManager.getApplication().runWriteAction(new Runnable(){

            @Override
            public void run() {
                try {
                    if (shelvedFile == null) {
                        patchTarget.delete((Object)this);
                    } else {
                        patchTarget.setBinaryContent(FileUtil.loadFileBytes((File)shelvedFile));
                        patchedFileRef.set((Object)patchTarget);
                    }
                }
                catch (IOException e) {
                    ex.set((Object)e);
                }
            }
        });
        if (!ex.isNull()) {
            throw (IOException)ex.get();
        }
    }

    private static boolean needUnshelve(FilePatch patch, List<ShelvedChange> changes) {
        for (ShelvedChange change : changes) {
            if (!Comparing.equal((String)patch.getBeforeName(), (String)change.getBeforePath())) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writePatchesToFile(Project project, String path, List<FilePatch> remainingPatches, CommitContext commitContext) {
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(path), CharsetToolkit.UTF8_CHARSET);){
            UnifiedDiffWriter.write((Project)project, remainingPatches, (Writer)writer, (String)"\n", (CommitContext)commitContext);
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
    }

    public void saveRemainingPatches(ShelvedChangeList changeList, List<FilePatch> remainingPatches, List<ShelvedBinaryFile> remainingBinaries, CommitContext commitContext) {
        ShelvedChangeList listCopy;
        try {
            listCopy = !changeList.isRecycled() ? this.createRecycledChangelist(changeList) : null;
        }
        catch (IOException e) {
            return;
        }
        ShelveChangesManager.writePatchesToFile(this.myProject, changeList.PATH, remainingPatches, commitContext);
        changeList.getBinaryFiles().retainAll(remainingBinaries);
        changeList.clearLoadedChanges();
        if (listCopy != null) {
            this.recycleChangeList(listCopy, changeList);
            this.mySchemeManager.addScheme(listCopy, false);
        }
        this.notifyStateChanged();
    }

    @NotNull
    private ShelvedChangeList createRecycledChangelist(ShelvedChangeList changeList) throws IOException {
        File newPatchDir = this.generateUniqueSchemePatchDir(changeList.DESCRIPTION, true);
        File newPath = ShelveChangesManager.getPatchFileInConfigDir(newPatchDir);
        FileUtil.copy((File)new File(changeList.PATH), (File)newPath);
        ShelvedChangeList listCopy = new ShelvedChangeList(newPath.getAbsolutePath(), changeList.DESCRIPTION, new ArrayList<ShelvedBinaryFile>(changeList.getBinaryFiles()));
        listCopy.markToDelete(changeList.isMarkedToDelete());
        listCopy.setName(newPatchDir.getName());
        ShelvedChangeList shelvedChangeList = listCopy;
        if (shelvedChangeList == null) {
            ShelveChangesManager.$$$reportNull$$$0(36);
        }
        return shelvedChangeList;
    }

    public void restoreList(@NotNull ShelvedChangeList changeList) {
        ShelvedChangeList list2;
        if (changeList == null) {
            ShelveChangesManager.$$$reportNull$$$0(37);
        }
        if ((list2 = this.mySchemeManager.findSchemeByName(changeList.getName())) != null) {
            list2.setRecycled(false);
            list2.updateDate();
        }
        this.notifyStateChanged();
    }

    @NotNull
    public List<ShelvedChangeList> getRecycledShelvedChangeLists() {
        List<ShelvedChangeList> list2 = this.getRecycled(true);
        if (list2 == null) {
            ShelveChangesManager.$$$reportNull$$$0(38);
        }
        return list2;
    }

    public void clearRecycled() {
        this.clearShelvedLists(this.getRecycledShelvedChangeLists(), true);
    }

    private void clearShelvedLists(@NotNull List<ShelvedChangeList> shelvedLists, boolean updateView) {
        if (shelvedLists == null) {
            ShelveChangesManager.$$$reportNull$$$0(39);
        }
        if (shelvedLists.isEmpty()) {
            return;
        }
        for (ShelvedChangeList list2 : shelvedLists) {
            this.deleteListImpl(list2);
            this.mySchemeManager.removeScheme(list2);
        }
        if (updateView) {
            this.notifyStateChanged();
        }
    }

    private void recycleChangeList(@NotNull ShelvedChangeList listCopy, @Nullable ShelvedChangeList newList) {
        if (listCopy == null) {
            ShelveChangesManager.$$$reportNull$$$0(40);
        }
        if (newList != null) {
            Iterator<ShelvedBinaryFile> shelvedChangeListIterator = listCopy.getBinaryFiles().iterator();
            while (shelvedChangeListIterator.hasNext()) {
                ShelvedBinaryFile binaryFile = shelvedChangeListIterator.next();
                for (ShelvedBinaryFile newBinary : newList.getBinaryFiles()) {
                    if (!Comparing.equal((String)newBinary.BEFORE_PATH, (String)binaryFile.BEFORE_PATH) || !Comparing.equal((String)newBinary.AFTER_PATH, (String)binaryFile.AFTER_PATH)) continue;
                    shelvedChangeListIterator.remove();
                }
            }
            Iterator<ShelvedChange> iterator = listCopy.getChanges(this.myProject).iterator();
            while (iterator.hasNext()) {
                ShelvedChange change = iterator.next();
                for (ShelvedChange newChange : newList.getChanges(this.myProject)) {
                    if (!Comparing.equal((String)change.getBeforePath(), (String)newChange.getBeforePath()) || !Comparing.equal((String)change.getAfterPath(), (String)newChange.getAfterPath())) continue;
                    iterator.remove();
                }
            }
            try {
                CommitContext commitContext = new CommitContext();
                ArrayList<FilePatch> patches = new ArrayList<FilePatch>();
                for (ShelvedChange change : listCopy.getChanges(this.myProject)) {
                    patches.add((FilePatch)change.loadFilePatch(this.myProject, commitContext));
                }
                ShelveChangesManager.writePatchesToFile(this.myProject, listCopy.PATH, patches, commitContext);
            }
            catch (PatchSyntaxException | IOException e) {
                LOG.info((Throwable)e);
            }
        }
        if (!listCopy.getBinaryFiles().isEmpty() || !listCopy.getChanges(this.myProject).isEmpty()) {
            listCopy.setRecycled(true);
            listCopy.updateDate();
            this.notifyStateChanged();
        }
    }

    public void recycleChangeList(@NotNull ShelvedChangeList changeList) {
        if (changeList == null) {
            ShelveChangesManager.$$$reportNull$$$0(41);
        }
        this.recycleChangeList(changeList, null);
        this.notifyStateChanged();
    }

    public void deleteChangeList(@NotNull ShelvedChangeList changeList) {
        if (changeList == null) {
            ShelveChangesManager.$$$reportNull$$$0(42);
        }
        this.deleteListImpl(changeList);
        this.mySchemeManager.removeScheme(changeList);
        this.notifyStateChanged();
    }

    private void deleteListImpl(@NotNull ShelvedChangeList changeList) {
        if (changeList == null) {
            ShelveChangesManager.$$$reportNull$$$0(43);
        }
        FileUtil.delete((File)new File(this.getShelfResourcesDirectory(), changeList.getName()));
        FileUtil.delete((File)new File(changeList.PATH));
        for (ShelvedBinaryFile binaryFile : changeList.getBinaryFiles()) {
            String path = binaryFile.SHELVED_PATH;
            if (path == null) continue;
            FileUtil.delete((File)new File(path));
        }
    }

    public void renameChangeList(ShelvedChangeList changeList, String newName) {
        changeList.DESCRIPTION = newName;
    }

    @NotNull
    public static List<TextFilePatch> loadPatches(Project project, String patchPath, @Nullable CommitContext commitContext) throws IOException, PatchSyntaxException {
        List<TextFilePatch> list2 = ShelveChangesManager.loadPatches(project, patchPath, commitContext, true);
        if (list2 == null) {
            ShelveChangesManager.$$$reportNull$$$0(44);
        }
        return list2;
    }

    @NotNull
    static List<? extends FilePatch> loadPatchesWithoutContent(Project project, String patchPath, @Nullable CommitContext commitContext) throws IOException, PatchSyntaxException {
        List<TextFilePatch> list2 = ShelveChangesManager.loadPatches(project, patchPath, commitContext, false);
        if (list2 == null) {
            ShelveChangesManager.$$$reportNull$$$0(45);
        }
        return list2;
    }

    private static List<TextFilePatch> loadPatches(Project project, String patchPath, @Nullable CommitContext commitContext, boolean loadContent) throws IOException, PatchSyntaxException {
        char[] text = FileUtil.loadFileText((File)new File(patchPath), (String)"UTF-8");
        PatchReader reader = new PatchReader((CharSequence)new CharArrayCharSequence(text), loadContent);
        List<TextFilePatch> textFilePatches = reader.readTextPatches();
        ApplyPatchDefaultExecutor.applyAdditionalInfoBefore(project, reader.getAdditionalInfo(null), commitContext);
        return textFilePatches;
    }

    public boolean isShowRecycled() {
        return this.myShowRecycled;
    }

    public void setShowRecycled(boolean showRecycled) {
        this.myShowRecycled = showRecycled;
        this.notifyStateChanged();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 8: 
            case 9: 
            case 11: 
            case 14: 
            case 15: 
            case 16: 
            case 19: 
            case 21: 
            case 22: 
            case 23: 
            case 26: 
            case 34: 
            case 36: 
            case 38: 
            case 44: 
            case 45: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 8: 
            case 9: 
            case 11: 
            case 14: 
            case 15: 
            case 16: 
            case 19: 
            case 21: 
            case 22: 
            case 23: 
            case 26: 
            case 34: 
            case 36: 
            case 38: 
            case 44: 
            case 45: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 8: 
            case 9: 
            case 11: 
            case 14: 
            case 15: 
            case 16: 
            case 19: 
            case 21: 
            case 22: 
            case 23: 
            case 26: 
            case 34: 
            case 36: 
            case 38: 
            case 44: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/changes/shelf/ShelveChangesManager";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fromFile";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toFile";
                break;
            }
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 12: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetDirectory";
                break;
            }
            case 17: 
            case 24: 
            case 25: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changes";
                break;
            }
            case 18: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "schemePatchDir";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "shelvedChangeListDragBean";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectedChangeLists";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectedChanges";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectedBinaryChanges";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "patchTarget";
                break;
            }
            case 37: 
            case 41: 
            case 42: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changeList";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "shelvedLists";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listCopy";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/changes/shelf/ShelveChangesManager";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultShelfPath";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createShelveSchemeManager";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getShelfResourcesDirectory";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "readOneShelvedChangeList";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponentName";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "checkAndMigrateOldPatchResourcesToNewSchemeStorage";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "migrateResourcesTo";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getShelvedChangeLists";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getRecycled";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getPatchFileInConfigDir";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "generateUniqueSchemePatchDir";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "suggestPatchName";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "shortenAndSanitize";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "shelveChangesInSeparatedLists";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "getChangeListUnshelveTo";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "createRecycledChangelist";
                break;
            }
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "getRecycledShelvedChangeLists";
                break;
            }
            case 44: {
                objectArray = objectArray2;
                objectArray2[1] = "loadPatches";
                break;
            }
            case 45: {
                objectArray = objectArray2;
                objectArray2[1] = "loadPatchesWithoutContent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultShelfPath";
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 8: 
            case 9: 
            case 11: 
            case 14: 
            case 15: 
            case 16: 
            case 19: 
            case 21: 
            case 22: 
            case 23: 
            case 26: 
            case 34: 
            case 36: 
            case 38: 
            case 44: 
            case 45: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createShelveSchemeManager";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "checkAndMigrateUnderProgress";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "readOneShelvedChangeList";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "migrateOldShelfInfo";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "migrateResourcesTo";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "rollbackChangesAfterShelve";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getPatchFileInConfigDir";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "shelveBinaryFile";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "shelveSilentlyUnderProgress";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "shelveChangesInSeparatedLists";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "unshelveSilentlyWithDnd";
                break;
            }
            case 29: 
            case 30: 
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "unshelveSilentlyAsynchronously";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "getChangeListUnshelveTo";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "unshelveBinaryFile";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "restoreList";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "clearShelvedLists";
                break;
            }
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "recycleChangeList";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "deleteChangeList";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "deleteListImpl";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "lambda$shelveSilentlyUnderProgress$6";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 8: 
            case 9: 
            case 11: 
            case 14: 
            case 15: 
            case 16: 
            case 19: 
            case 21: 
            case 22: 
            case 23: 
            case 26: 
            case 34: 
            case 36: 
            case 38: 
            case 44: 
            case 45: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class BinaryPatchApplier
    implements CustomBinaryPatchApplier<ShelvedBinaryFilePatch> {
        private final List<FilePatch> myAppliedPatches = new ArrayList<FilePatch>();

        private BinaryPatchApplier() {
        }

        @Override
        @NotNull
        public ApplyPatchStatus apply(List<Pair<VirtualFile, ApplyFilePatchBase<ShelvedBinaryFilePatch>>> patches) throws IOException {
            for (Pair<VirtualFile, ApplyFilePatchBase<ShelvedBinaryFilePatch>> patch : patches) {
                ShelvedBinaryFilePatch shelvedPatch = (ShelvedBinaryFilePatch)((Object)((ApplyFilePatchBase)patch.getSecond()).getPatch());
                ShelveChangesManager.this.unshelveBinaryFile(shelvedPatch.getShelvedBinaryFile(), (VirtualFile)patch.getFirst());
                this.myAppliedPatches.add(shelvedPatch);
            }
            ApplyPatchStatus applyPatchStatus = ApplyPatchStatus.SUCCESS;
            if (applyPatchStatus == null) {
                BinaryPatchApplier.$$$reportNull$$$0(0);
            }
            return applyPatchStatus;
        }

        @Override
        @NotNull
        public List<FilePatch> getAppliedPatches() {
            List<FilePatch> list2 = this.myAppliedPatches;
            if (list2 == null) {
                BinaryPatchApplier.$$$reportNull$$$0(1);
            }
            return list2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/intellij/openapi/vcs/changes/shelf/ShelveChangesManager$BinaryPatchApplier";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "apply";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAppliedPatches";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }
}

