/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.ui;

import com.intellij.diff.DiffDialogHints;
import com.intellij.diff.util.DiffUserDataKeysEx;
import com.intellij.ide.DeleteProvider;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.ListSelection;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.TypeSafeDataProvider;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.actionSystem.ex.CheckboxAction;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileChooser.actions.VirtualFileDeleteProvider;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.RemoteRevisionsCache;
import com.intellij.openapi.vcs.changes.actions.diff.ShowDiffAction;
import com.intellij.openapi.vcs.changes.actions.diff.ShowDiffContext;
import com.intellij.openapi.vcs.changes.ui.ChangeNodeDecorator;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowser;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNode;
import com.intellij.openapi.vcs.changes.ui.ChangesListView;
import com.intellij.openapi.vcs.changes.ui.ChangesTreeList;
import com.intellij.openapi.vcs.changes.ui.RemoteStatusChangeNodeDecorator;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.KeyEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Stream;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import org.intellij.lang.annotations.JdkConstants;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class OldChangesBrowserBase<T>
extends JPanel
implements TypeSafeDataProvider,
Disposable {
    private static final Logger LOG = Logger.getInstance(OldChangesBrowserBase.class);
    private boolean myDataIsDirty;
    protected final Class<T> myClass;
    protected final ChangesTreeList<T> myViewer;
    protected final JScrollPane myViewerScrollPane;
    protected ChangeList mySelectedChangeList;
    protected List<T> myChangesToDisplay;
    protected final Project myProject;
    private final boolean myCapableOfExcludingChanges;
    protected final JPanel myHeaderPanel;
    private JComponent myBottomPanel;
    private DefaultActionGroup myToolBarGroup;
    private String myToggleActionTitle;
    private JComponent myDiffBottomComponent;
    public static DataKey<OldChangesBrowserBase> DATA_KEY = DataKey.create((String)"com.intellij.openapi.vcs.changes.ui.ChangesBrowser");
    private AnAction myDiffAction;
    private final VirtualFile myToSelect;
    @NotNull
    private final DeleteProvider myDeleteProvider;

    public void setChangesToDisplay(List<T> changes) {
        this.myChangesToDisplay = changes;
        this.myViewer.setChangesToDisplay(changes);
    }

    public void setDecorator(ChangeNodeDecorator decorator) {
        this.myViewer.setChangeDecorator(decorator);
    }

    protected OldChangesBrowserBase(@NotNull Project project, @NotNull List<T> changes, boolean capableOfExcludingChanges, boolean highlightProblems, @Nullable Runnable inclusionListener, @NotNull ChangesBrowser.MyUseCase useCase, @Nullable VirtualFile toSelect2, @NotNull Class<T> clazz) {
        if (project == null) {
            OldChangesBrowserBase.$$$reportNull$$$0(0);
        }
        if (changes == null) {
            OldChangesBrowserBase.$$$reportNull$$$0(1);
        }
        if (useCase == null) {
            OldChangesBrowserBase.$$$reportNull$$$0(2);
        }
        if (clazz == null) {
            OldChangesBrowserBase.$$$reportNull$$$0(3);
        }
        super(new BorderLayout());
        this.myToggleActionTitle = VcsBundle.message((String)"commit.dialog.include.action.name", (Object[])new Object[0]);
        this.myDeleteProvider = new VirtualFileDeleteProvider();
        this.setFocusable(false);
        this.myClass = clazz;
        this.myDataIsDirty = false;
        this.myProject = project;
        this.myCapableOfExcludingChanges = capableOfExcludingChanges;
        this.myToSelect = toSelect2;
        RemoteStatusChangeNodeDecorator decorator = ChangesBrowser.MyUseCase.LOCAL_CHANGES.equals((Object)useCase) ? RemoteRevisionsCache.getInstance(this.myProject).getChangesNodeDecorator() : null;
        this.myViewer = new ChangesTreeList<T>(this.myProject, changes, capableOfExcludingChanges, highlightProblems, inclusionListener, decorator){

            @Override
            protected DefaultTreeModel buildTreeModel(List<T> changes, ChangeNodeDecorator changeNodeDecorator) {
                return OldChangesBrowserBase.this.buildTreeModel(changes, changeNodeDecorator, this.isShowFlatten());
            }

            @Override
            protected List<T> getSelectedObjects(ChangesBrowserNode<?> node) {
                return OldChangesBrowserBase.this.getSelectedObjects(node);
            }

            @Override
            @Nullable
            protected T getLeadSelectedObject(ChangesBrowserNode<?> node) {
                return OldChangesBrowserBase.this.getLeadSelectedObject(node);
            }

            @Override
            public void setScrollPaneBorder(Border border) {
                OldChangesBrowserBase.this.myViewerScrollPane.setBorder(border);
            }
        };
        this.myViewerScrollPane = ScrollPaneFactory.createScrollPane(this.myViewer);
        this.myHeaderPanel = new JPanel(new BorderLayout());
    }

    protected void init() {
        this.add((Component)this.myViewerScrollPane, "Center");
        this.myHeaderPanel.add((Component)this.createToolbar(), "Center");
        this.add((Component)this.myHeaderPanel, "North");
        this.myBottomPanel = new JPanel(new BorderLayout());
        this.add((Component)this.myBottomPanel, "South");
        this.myViewer.installPopupHandler((ActionGroup)this.myToolBarGroup);
        this.myViewer.setDoubleClickHandler(this.getDoubleClickHandler());
    }

    @NotNull
    protected abstract DefaultTreeModel buildTreeModel(List<T> var1, ChangeNodeDecorator var2, boolean var3);

    @NotNull
    protected abstract List<T> getSelectedObjects(@NotNull ChangesBrowserNode<?> var1);

    @Nullable
    protected abstract T getLeadSelectedObject(@NotNull ChangesBrowserNode<?> var1);

    @NotNull
    protected Runnable getDoubleClickHandler() {
        Runnable runnable2 = () -> this.showDiff();
        if (runnable2 == null) {
            OldChangesBrowserBase.$$$reportNull$$$0(4);
        }
        return runnable2;
    }

    protected void setInitialSelection(List<? extends ChangeList> changeLists, @NotNull List<T> changes, ChangeList initialListSelection) {
        if (changes == null) {
            OldChangesBrowserBase.$$$reportNull$$$0(5);
        }
        this.mySelectedChangeList = initialListSelection;
    }

    public void dispose() {
    }

    public void addToolbarAction(AnAction action) {
        this.myToolBarGroup.add(action);
    }

    public void setDiffBottomComponent(JComponent diffBottomComponent) {
        this.myDiffBottomComponent = diffBottomComponent;
    }

    public void setToggleActionTitle(String toggleActionTitle) {
        this.myToggleActionTitle = toggleActionTitle;
    }

    public JPanel getHeaderPanel() {
        return this.myHeaderPanel;
    }

    public ChangesTreeList<T> getViewer() {
        return this.myViewer;
    }

    @NotNull
    public JScrollPane getViewerScrollPane() {
        JScrollPane jScrollPane = this.myViewerScrollPane;
        if (jScrollPane == null) {
            OldChangesBrowserBase.$$$reportNull$$$0(6);
        }
        return jScrollPane;
    }

    public void calcData(DataKey key, DataSink sink) {
        if (key == VcsDataKeys.CHANGES) {
            List<Change> list2 = this.getSelectedChanges();
            if (list2.isEmpty()) {
                list2 = this.getAllChanges();
            }
            sink.put(VcsDataKeys.CHANGES, (Object)list2.toArray(new Change[list2.size()]));
        } else if (key == VcsDataKeys.CHANGES_SELECTION) {
            sink.put(VcsDataKeys.CHANGES_SELECTION, this.getChangesSelection());
        } else if (key == VcsDataKeys.CHANGE_LISTS) {
            sink.put(VcsDataKeys.CHANGE_LISTS, (Object)this.getSelectedChangeLists());
        } else if (key == VcsDataKeys.CHANGE_LEAD_SELECTION) {
            Change[] changeArray;
            Change highestSelection = (Change)ObjectUtils.tryCast(this.myViewer.getHighestLeadSelection(), Change.class);
            if (highestSelection == null) {
                changeArray = new Change[]{};
            } else {
                Change[] changeArray2 = new Change[1];
                changeArray = changeArray2;
                changeArray2[0] = highestSelection;
            }
            sink.put(VcsDataKeys.CHANGE_LEAD_SELECTION, (Object)changeArray);
        } else if (key == CommonDataKeys.VIRTUAL_FILE_ARRAY) {
            sink.put(CommonDataKeys.VIRTUAL_FILE_ARRAY, this.getSelectedFiles().toArray(VirtualFile[]::new));
        } else if (key == CommonDataKeys.NAVIGATABLE_ARRAY) {
            sink.put(CommonDataKeys.NAVIGATABLE_ARRAY, (Object)ChangesUtil.getNavigatableArray((Project)this.myProject, this.getNavigatableFiles()));
        } else if (VcsDataKeys.IO_FILE_ARRAY.equals(key)) {
            sink.put(VcsDataKeys.IO_FILE_ARRAY, (Object)this.getSelectedIoFiles());
        } else if (key == DATA_KEY) {
            sink.put(DATA_KEY, (Object)this);
        } else if (VcsDataKeys.SELECTED_CHANGES_IN_DETAILS.equals(key)) {
            List<Change> selectedChanges = this.getSelectedChanges();
            sink.put(VcsDataKeys.SELECTED_CHANGES_IN_DETAILS, (Object)selectedChanges.toArray(new Change[selectedChanges.size()]));
        } else if (ChangesListView.UNVERSIONED_FILES_DATA_KEY.equals((Object)key)) {
            sink.put(ChangesListView.UNVERSIONED_FILES_DATA_KEY, ChangesListView.getVirtualFiles(this.myViewer.getSelectionPaths(), ChangesBrowserNode.UNVERSIONED_FILES_TAG));
        } else if (PlatformDataKeys.DELETE_ELEMENT_PROVIDER.equals(key)) {
            sink.put(PlatformDataKeys.DELETE_ELEMENT_PROVIDER, (Object)this.myDeleteProvider);
        }
    }

    public void select(List<T> changes) {
        this.myViewer.select(changes);
    }

    public JComponent getBottomPanel() {
        return this.myBottomPanel;
    }

    protected void showDiffForChanges(Change[] changesArray, int indexInSelection) {
        ShowDiffContext context = new ShowDiffContext(OldChangesBrowserBase.isInFrame() ? DiffDialogHints.FRAME : DiffDialogHints.MODAL);
        context.addActions(this.createDiffActions());
        if (this.myDiffBottomComponent != null) {
            context.putChainContext(DiffUserDataKeysEx.BOTTOM_PANEL, this.myDiffBottomComponent);
        }
        this.updateDiffContext(context);
        ShowDiffAction.showDiffForChange(this.myProject, Arrays.asList(changesArray), indexInSelection, context);
    }

    protected void updateDiffContext(@NotNull ShowDiffContext context) {
        if (context == null) {
            OldChangesBrowserBase.$$$reportNull$$$0(7);
        }
    }

    private boolean canShowDiff() {
        return ShowDiffAction.canShowDiff(this.myProject, this.getChangesSelection().getList());
    }

    private void showDiff() {
        ListSelection<Change> selection = this.getChangesSelection();
        List changes = selection.getList();
        Change[] changesArray = changes.toArray(new Change[changes.size()]);
        this.showDiffForChanges(changesArray, selection.getSelectedIndex());
        this.afterDiffRefresh();
    }

    @NotNull
    protected ListSelection<Change> getChangesSelection() {
        List<Change> allChanges;
        Change leadSelection = (Change)ObjectUtils.tryCast(this.myViewer.getLeadSelection(), Change.class);
        List<Change> changes = this.getSelectedChanges();
        if (changes.size() < 2 && ((allChanges = this.getAllChanges()).size() > 1 || changes.isEmpty())) {
            changes = allChanges;
        }
        if (leadSelection != null && !changes.contains(leadSelection)) {
            ListSelection listSelection = ListSelection.createSingleton((Object)leadSelection);
            if (listSelection == null) {
                OldChangesBrowserBase.$$$reportNull$$$0(8);
            }
            return listSelection;
        }
        ListSelection listSelection = ListSelection.create(changes, (Object)leadSelection);
        if (listSelection == null) {
            OldChangesBrowserBase.$$$reportNull$$$0(9);
        }
        return listSelection;
    }

    protected void afterDiffRefresh() {
    }

    private static boolean isInFrame() {
        return ModalityState.current().equals(ModalityState.NON_MODAL);
    }

    protected List<AnAction> createDiffActions() {
        ArrayList<AnAction> actions = new ArrayList<AnAction>();
        if (this.myCapableOfExcludingChanges) {
            actions.add((AnAction)new ToggleChangeAction());
        }
        return actions;
    }

    public void rebuildList() {
        this.myViewer.setChangesToDisplay(this.getCurrentDisplayedObjects(), this.myToSelect);
    }

    public void setAlwayExpandList(boolean value) {
        this.myViewer.setAlwaysExpandList(value);
    }

    @NotNull
    protected JComponent createToolbar() {
        DefaultActionGroup toolbarGroups = new DefaultActionGroup();
        this.myToolBarGroup = new DefaultActionGroup();
        toolbarGroups.add((AnAction)this.myToolBarGroup);
        this.buildToolBar(this.myToolBarGroup);
        toolbarGroups.addSeparator();
        DefaultActionGroup treeActionsGroup = new DefaultActionGroup();
        toolbarGroups.add((AnAction)treeActionsGroup);
        for (AnAction action : this.myViewer.getTreeActions()) {
            treeActionsGroup.add(action);
        }
        ActionToolbar toolbar = ActionManager.getInstance().createActionToolbar("ChangesBrowser", (ActionGroup)toolbarGroups, true);
        toolbar.setTargetComponent((JComponent)this);
        JComponent jComponent = toolbar.getComponent();
        if (jComponent == null) {
            OldChangesBrowserBase.$$$reportNull$$$0(10);
        }
        return jComponent;
    }

    protected void buildToolBar(DefaultActionGroup toolBarGroup) {
        this.myDiffAction = new DumbAwareAction(){

            public void update(AnActionEvent e) {
                e.getPresentation().setEnabled(OldChangesBrowserBase.this.canShowDiff() || e.getInputEvent() instanceof KeyEvent);
            }

            public void actionPerformed(AnActionEvent e) {
                OldChangesBrowserBase.this.showDiff();
            }
        };
        ActionUtil.copyFrom((AnAction)this.myDiffAction, (String)"Diff.ShowDiff");
        this.myDiffAction.registerCustomShortcutSet(this.myViewer, null);
        toolBarGroup.add(this.myDiffAction);
    }

    @NotNull
    public abstract List<Change> getCurrentIncludedChanges();

    @NotNull
    public List<Change> getCurrentDisplayedChanges() {
        ArrayList arrayList = this.mySelectedChangeList != null ? ContainerUtil.newArrayList((Iterable)this.mySelectedChangeList.getChanges()) : Collections.emptyList();
        if (arrayList == null) {
            OldChangesBrowserBase.$$$reportNull$$$0(11);
        }
        return arrayList;
    }

    @NotNull
    public abstract List<T> getCurrentDisplayedObjects();

    @NotNull
    public List<VirtualFile> getIncludedUnversionedFiles() {
        List<VirtualFile> list2 = Collections.emptyList();
        if (list2 == null) {
            OldChangesBrowserBase.$$$reportNull$$$0(12);
        }
        return list2;
    }

    public int getUnversionedFilesCount() {
        return 0;
    }

    public ChangeList getSelectedChangeList() {
        return this.mySelectedChangeList;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myViewer.getPreferredFocusedComponent();
    }

    private ChangeList[] getSelectedChangeLists() {
        if (this.mySelectedChangeList != null) {
            return new ChangeList[]{this.mySelectedChangeList};
        }
        return null;
    }

    private File[] getSelectedIoFiles() {
        List<Change> changes = this.getSelectedChanges();
        ArrayList<File> files = new ArrayList<File>();
        for (Change change : changes) {
            ContentRevision afterRevision = change.getAfterRevision();
            if (afterRevision == null) continue;
            FilePath file2 = afterRevision.getFile();
            File ioFile = file2.getIOFile();
            files.add(ioFile);
        }
        return files.toArray(new File[files.size()]);
    }

    @NotNull
    public abstract List<Change> getSelectedChanges();

    @NotNull
    public abstract List<Change> getAllChanges();

    @NotNull
    protected Stream<VirtualFile> getSelectedFiles() {
        Stream<VirtualFile> stream = Stream.concat(ChangesUtil.getAfterRevisionsFiles(this.getSelectedChanges().stream()), ChangesListView.getVirtualFiles(this.myViewer.getSelectionPaths(), null)).distinct();
        if (stream == null) {
            OldChangesBrowserBase.$$$reportNull$$$0(13);
        }
        return stream;
    }

    @NotNull
    protected Stream<VirtualFile> getNavigatableFiles() {
        Stream<VirtualFile> stream = Stream.concat(ChangesUtil.getFiles(this.getSelectedChanges().stream()), ChangesListView.getVirtualFiles(this.myViewer.getSelectionPaths(), null)).distinct();
        if (stream == null) {
            OldChangesBrowserBase.$$$reportNull$$$0(14);
        }
        return stream;
    }

    public AnAction getDiffAction() {
        return this.myDiffAction;
    }

    public boolean isDataIsDirty() {
        return this.myDataIsDirty;
    }

    public void setDataIsDirty(boolean dataIsDirty) {
        this.myDataIsDirty = dataIsDirty;
    }

    public void setSelectionMode(@JdkConstants.TreeSelectionMode int mode) {
        this.myViewer.setSelectionMode(mode);
    }

    @Contract(pure=true)
    @NotNull
    protected static <T> List<Change> findChanges(@NotNull Collection<T> items) {
        if (items == null) {
            OldChangesBrowserBase.$$$reportNull$$$0(15);
        }
        List list2 = ContainerUtil.findAll(items, Change.class);
        if (list2 == null) {
            OldChangesBrowserBase.$$$reportNull$$$0(16);
        }
        return list2;
    }

    static boolean isUnderUnversioned(@NotNull ChangesBrowserNode node) {
        if (node == null) {
            OldChangesBrowserBase.$$$reportNull$$$0(17);
        }
        return ChangesListView.isUnderTag(new TreePath(node.getPath()), ChangesBrowserNode.UNVERSIONED_FILES_TAG);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changes";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "useCase";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/changes/ui/OldChangesBrowserBase";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "items";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/changes/ui/OldChangesBrowserBase";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getDoubleClickHandler";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getViewerScrollPane";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getChangesSelection";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "createToolbar";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getCurrentDisplayedChanges";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getIncludedUnversionedFiles";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedFiles";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getNavigatableFiles";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "findChanges";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setInitialSelection";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "updateDiffContext";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "findChanges";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "isUnderUnversioned";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class ToggleChangeAction
    extends CheckboxAction {
        public ToggleChangeAction() {
            super(OldChangesBrowserBase.this.myToggleActionTitle);
        }

        public boolean isSelected(AnActionEvent e) {
            Object change = ObjectUtils.tryCast((Object)e.getData(VcsDataKeys.CURRENT_CHANGE), OldChangesBrowserBase.this.myClass);
            if (change == null) {
                return false;
            }
            return OldChangesBrowserBase.this.myViewer.isIncluded(change);
        }

        public void setSelected(AnActionEvent e, boolean state) {
            Object change = ObjectUtils.tryCast((Object)e.getData(VcsDataKeys.CURRENT_CHANGE), OldChangesBrowserBase.this.myClass);
            if (change == null) {
                return;
            }
            if (state) {
                OldChangesBrowserBase.this.myViewer.includeChange(change);
            } else {
                OldChangesBrowserBase.this.myViewer.excludeChange(change);
            }
        }
    }
}

