/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.ex;

import com.intellij.diff.util.Range;
import com.intellij.openapi.vcs.ex.DocumentTracker;
import com.intellij.util.EventDispatcher;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u001a\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u0007H\u0002JR\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00070\r2<\u0010\u000e\u001a8\u0012\u0019\u0012\u0017\u0012\u0004\u0012\u00020\u00070\r\u00a2\u0006\f\b\u0010\u0012\b\b\u0011\u0012\u0004\b\b(\u0012\u0012\u0013\u0012\u00110\u0007\u00a2\u0006\f\b\u0010\u0012\b\b\u0011\u0012\u0004\b\b(\u0013\u0012\u0004\u0012\u00020\u000b0\u000fR\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/intellij/openapi/vcs/ex/MergingBlockProcessor;", "", "dispatcher", "Lcom/intellij/util/EventDispatcher;", "Lcom/intellij/openapi/vcs/ex/DocumentTracker$Listener;", "(Lcom/intellij/util/EventDispatcher;)V", "mergeBlocks", "Lcom/intellij/openapi/vcs/ex/DocumentTracker$Block;", "block1", "block2", "processMergedBlocks", "", "group", "", "processBlock", "Lkotlin/Function2;", "Lkotlin/ParameterName;", "name", "original", "merged", "diff-impl"})
final class MergingBlockProcessor {
    private final EventDispatcher<DocumentTracker.Listener> dispatcher;

    public final void processMergedBlocks(@NotNull List<DocumentTracker.Block> group, @NotNull Function2<? super List<DocumentTracker.Block>, ? super DocumentTracker.Block, Unit> processBlock) {
        boolean bl;
        Intrinsics.checkParameterIsNotNull(group, (String)"group");
        Intrinsics.checkParameterIsNotNull(processBlock, (String)"processBlock");
        boolean bl2 = bl = !group.isEmpty();
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        List originalGroup = new ArrayList();
        DocumentTracker.Block merged = null;
        for (DocumentTracker.Block block : group) {
            if (merged == null) {
                originalGroup.add(block);
                merged = block;
                continue;
            }
            DocumentTracker.Block newMerged = this.mergeBlocks(merged, block);
            if (newMerged != null) {
                originalGroup.add(block);
                merged = newMerged;
                continue;
            }
            processBlock.invoke((Object)originalGroup, (Object)merged);
            originalGroup.clear();
            originalGroup.add(block);
            merged = block;
        }
        DocumentTracker.Block block = merged;
        if (block == null) {
            Intrinsics.throwNpe();
        }
        processBlock.invoke((Object)originalGroup, (Object)block);
    }

    private final DocumentTracker.Block mergeBlocks(DocumentTracker.Block block1, DocumentTracker.Block block2) {
        boolean isDirty = block1.isDirty$diff_impl() || block2.isDirty$diff_impl();
        boolean isTooBig = block1.isTooBig$diff_impl() || block2.isTooBig$diff_impl();
        Range range2 = new Range(block1.getRange().start1, block2.getRange().end1, block1.getRange().start2, block2.getRange().end2);
        DocumentTracker.Block merged = new DocumentTracker.Block(range2, isDirty, isTooBig);
        for (DocumentTracker.Listener listener2 : this.dispatcher.getListeners()) {
            if (listener2.onRangesMerged(block1, block2, merged)) continue;
            return null;
        }
        return merged;
    }

    public MergingBlockProcessor(@NotNull EventDispatcher<DocumentTracker.Listener> dispatcher) {
        Intrinsics.checkParameterIsNotNull(dispatcher, (String)"dispatcher");
        this.dispatcher = dispatcher;
    }
}

