/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.impl;

import com.google.common.collect.Multiset;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationAdapter;
import com.intellij.openapi.application.ApplicationListener;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.components.ProjectComponent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.event.EditorFactoryAdapter;
import com.intellij.openapi.editor.event.EditorFactoryEvent;
import com.intellij.openapi.editor.event.EditorFactoryListener;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.impl.DirectoryIndex;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.FileStatusListener;
import com.intellij.openapi.vcs.FileStatusManager;
import com.intellij.openapi.vcs.VcsApplicationSettings;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.changes.ChangeListAdapter;
import com.intellij.openapi.vcs.changes.ChangeListListener;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ChangeListManagerImpl;
import com.intellij.openapi.vcs.changes.ChangeListWorker;
import com.intellij.openapi.vcs.changes.CurrentContentRevision;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.ex.LineStatusTracker;
import com.intellij.openapi.vcs.ex.PartialLocalLineStatusTracker;
import com.intellij.openapi.vcs.ex.SimpleLocalLineStatusTracker;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vcs.impl.LineStatusTrackerManager;
import com.intellij.openapi.vcs.impl.LineStatusTrackerManagerI;
import com.intellij.openapi.vcs.impl.LineStatusTrackerManagerKt$sam$Runnable$8bb02b6c;
import com.intellij.openapi.vcs.impl.LineStatusTrackerSettingListener;
import com.intellij.openapi.vcs.impl.Result;
import com.intellij.openapi.vcs.impl.SingleThreadLoader;
import com.intellij.openapi.vcs.impl.VcsBaseContentProvider;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileMoveEvent;
import com.intellij.openapi.vfs.VirtualFilePropertyEvent;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.ui.GuiUtils;
import com.intellij.util.containers.HashMap;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.vcsUtil.VcsUtil;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u00c8\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0011\u0018\u0000 Z2\u00020\u00012\u00020\u0002:\rZ[\\]^_`abcdefB7\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\b\b\u0001\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0002\u0010\u000fJ\u0010\u0010#\u001a\u00020\u001b2\u0006\u0010$\u001a\u00020%H\u0016J\u0010\u0010&\u001a\u00020\u001b2\u0006\u0010$\u001a\u00020%H\u0002J\u0012\u0010'\u001a\u00020\u001b2\b\u0010$\u001a\u0004\u0018\u00010%H\u0002J\u0010\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020\u0016H\u0003J\u0013\u0010+\u001a\b\u0012\u0004\u0012\u00020-0,H\u0001\u00a2\u0006\u0002\b.J\b\u0010/\u001a\u00020)H\u0016J\u0016\u00100\u001a\u00020)2\f\u00101\u001a\b\u0012\u0004\u0012\u00020)02H\u0002J\b\u00103\u001a\u000204H\u0017J\u0016\u00105\u001a\b\u0012\u0002\b\u0003\u0018\u0001062\u0006\u0010*\u001a\u00020\u0016H\u0016J\u0016\u00105\u001a\b\u0012\u0002\b\u0003\u0018\u0001062\u0006\u00107\u001a\u00020%H\u0016J\b\u00108\u001a\u000209H\u0002J\b\u0010:\u001a\u00020)H\u0016J\u0018\u0010;\u001a\u00020)2\u0006\u0010$\u001a\u00020%2\u0006\u0010*\u001a\u00020\u0016H\u0003J0\u0010;\u001a\u00020)2\u0006\u0010$\u001a\u00020%2\u0006\u0010*\u001a\u00020\u00162\b\u0010<\u001a\u0004\u0018\u0001042\f\u0010=\u001a\b\u0012\u0004\u0012\u00020>0,H\u0003J\u0010\u0010?\u001a\u00020)2\u0006\u00101\u001a\u00020@H\u0016J\u001a\u0010A\u001a\u00020)2\u0006\u0010B\u001a\u0002042\b\u00107\u001a\u0004\u0018\u00010%H\u0002J\b\u0010C\u001a\u00020)H\u0003J\u0010\u0010D\u001a\u00020)2\u0006\u0010$\u001a\u00020%H\u0003J \u0010E\u001a\u00020)2\n\u0010F\u001a\u0006\u0012\u0002\b\u0003062\n\b\u0002\u0010G\u001a\u0004\u0018\u000104H\u0003J\u0014\u0010H\u001a\u00020)2\n\u0010F\u001a\u0006\u0012\u0002\b\u000306H\u0002J\u0010\u0010I\u001a\u00020)2\u0006\u0010*\u001a\u00020\u0016H\u0003J\u0018\u0010J\u001a\u00020)2\u0006\u0010*\u001a\u00020\u00162\u0006\u0010K\u001a\u00020\u0011H\u0017J\u0018\u0010L\u001a\u00020)2\u0006\u0010*\u001a\u00020\u00162\u0006\u0010K\u001a\u00020\u0011H\u0017J$\u0010M\u001a\u00020)2\n\u0010F\u001a\u0006\u0012\u0002\b\u0003062\u0006\u0010N\u001a\u00020O2\u0006\u0010P\u001a\u00020OH\u0002J\u001b\u0010Q\u001a\u00020)2\f\u0010R\u001a\b\u0012\u0004\u0012\u00020-0,H\u0001\u00a2\u0006\u0002\bSJ\u001a\u0010T\u001a\u00020\u001b2\b\u0010U\u001a\u0004\u0018\u00010V2\u0006\u0010W\u001a\u00020VH\u0002J\u0014\u0010X\u001a\u00020)2\n\u0010F\u001a\u0006\u0012\u0002\b\u000306H\u0002J\u001a\u0010Y\u001a\u00020)2\u0006\u0010B\u001a\u0002042\b\u0010*\u001a\u0004\u0018\u00010\u0016H\u0002J\u001a\u0010Y\u001a\u00020)2\u0006\u0010B\u001a\u0002042\b\u00107\u001a\u0004\u0018\u00010%H\u0002R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0017\u001a\u0014\u0012\u0004\u0012\u00020\u0016\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00110\u00190\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\u001e\u0012\u0004\u0012\u00020\u001f0\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010!\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\"0\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006g"}, d2={"Lcom/intellij/openapi/vcs/impl/LineStatusTrackerManager;", "Lcom/intellij/openapi/components/ProjectComponent;", "Lcom/intellij/openapi/vcs/impl/LineStatusTrackerManagerI;", "project", "Lcom/intellij/openapi/project/Project;", "application", "Lcom/intellij/openapi/application/Application;", "statusProvider", "Lcom/intellij/openapi/vcs/impl/VcsBaseContentProvider;", "changeListManager", "Lcom/intellij/openapi/vcs/changes/ChangeListManagerImpl;", "fileDocumentManager", "Lcom/intellij/openapi/fileEditor/FileDocumentManager;", "makeSureIndexIsInitializedFirst", "Lcom/intellij/openapi/roots/impl/DirectoryIndex;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/application/Application;Lcom/intellij/openapi/vcs/impl/VcsBaseContentProvider;Lcom/intellij/openapi/vcs/changes/ChangeListManagerImpl;Lcom/intellij/openapi/fileEditor/FileDocumentManager;Lcom/intellij/openapi/roots/impl/DirectoryIndex;)V", "LOCK", "", "disposable", "Lcom/intellij/openapi/Disposable;", "documentsInDefaultChangeList", "Ljava/util/HashSet;", "Lcom/intellij/openapi/editor/Document;", "forcedDocuments", "Lcom/intellij/util/containers/HashMap;", "Lcom/google/common/collect/Multiset;", "isDisposed", "", "loader", "Lcom/intellij/openapi/vcs/impl/SingleThreadLoader;", "Lcom/intellij/openapi/vcs/impl/LineStatusTrackerManager$RefreshRequest;", "Lcom/intellij/openapi/vcs/impl/LineStatusTrackerManager$RefreshData;", "partialChangeListsEnabled", "trackers", "Lcom/intellij/openapi/vcs/impl/LineStatusTrackerManager$TrackerData;", "arePartialChangelistsEnabled", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "canCreatePartialTrackerFor", "canGetBaseRevisionFor", "checkIfTrackerCanBeReleased", "", "document", "collectPartiallyChangedFilesStates", "", "Lcom/intellij/openapi/vcs/ex/PartialLocalLineStatusTracker$State;", "collectPartiallyChangedFilesStates$vcs_impl", "disposeComponent", "edt", "task", "Lkotlin/Function0;", "getComponentName", "", "getLineStatusTracker", "Lcom/intellij/openapi/vcs/ex/LineStatusTracker;", "file", "getTrackingMode", "Lcom/intellij/openapi/vcs/ex/LineStatusTracker$Mode;", "initComponent", "installTracker", "oldChangesChangelistId", "events", "Lcom/intellij/openapi/editor/event/DocumentEvent;", "invokeAfterUpdate", "Ljava/lang/Runnable;", "log", "message", "onEverythingChanged", "onFileChanged", "refreshTracker", "tracker", "changelistId", "registerTrackerInCLM", "releaseTracker", "releaseTrackerFor", "requester", "requestTrackerFor", "reregisterTrackerInCLM", "oldPath", "Lcom/intellij/openapi/vcs/FilePath;", "newPath", "restoreTrackersForPartiallyChangedFiles", "trackerStates", "restoreTrackersForPartiallyChangedFiles$vcs_impl", "shouldBeUpdated", "oldInfo", "Lcom/intellij/openapi/vcs/impl/LineStatusTrackerManager$ContentInfo;", "newInfo", "unregisterTrackerInCLM", "warn", "Companion", "ContentInfo", "MyApplicationListener", "MyBaseRevisionLoader", "MyChangeListListener", "MyDocumentListener", "MyEditorFactoryListener", "MyFileStatusListener", "MyLineStatusTrackerSettingListener", "MyVirtualFileListener", "RefreshData", "RefreshRequest", "TrackerData", "vcs-impl"})
public final class LineStatusTrackerManager
implements ProjectComponent,
LineStatusTrackerManagerI {
    private final Object LOCK;
    private final Disposable disposable;
    private boolean isDisposed;
    private final HashMap<Document, TrackerData> trackers;
    private final HashMap<Document, Multiset<Object>> forcedDocuments;
    private final boolean partialChangeListsEnabled;
    private final HashSet<Document> documentsInDefaultChangeList;
    private final SingleThreadLoader<RefreshRequest, RefreshData> loader;
    private final Project project;
    private final Application application;
    private final VcsBaseContentProvider statusProvider;
    private final ChangeListManagerImpl changeListManager;
    private final FileDocumentManager fileDocumentManager;
    private static final Logger LOG;
    public static final Companion Companion;

    public void initComponent() {
        StartupManager.getInstance((Project)this.project).registerPreStartupActivity(new Runnable(this){
            final /* synthetic */ LineStatusTrackerManager this$0;

            public final void run() {
                if (LineStatusTrackerManager.access$isDisposed$p(this.this$0)) {
                    return;
                }
                LineStatusTrackerManager.access$getApplication$p(this.this$0).addApplicationListener((ApplicationListener)this.this$0.new MyApplicationListener(), LineStatusTrackerManager.access$getDisposable$p(this.this$0));
                MessageBusConnection busConnection = LineStatusTrackerManager.access$getProject$p(this.this$0).getMessageBus().connect(LineStatusTrackerManager.access$getDisposable$p(this.this$0));
                busConnection.subscribe(LineStatusTrackerSettingListener.TOPIC, (Object)this.this$0.new MyLineStatusTrackerSettingListener());
                FileStatusManager fsManager = FileStatusManager.getInstance((Project)LineStatusTrackerManager.access$getProject$p(this.this$0));
                fsManager.addFileStatusListener((FileStatusListener)this.this$0.new MyFileStatusListener(), LineStatusTrackerManager.access$getDisposable$p(this.this$0));
                EditorFactory editorFactory = EditorFactory.getInstance();
                editorFactory.addEditorFactoryListener((EditorFactoryListener)this.this$0.new MyEditorFactoryListener(), LineStatusTrackerManager.access$getDisposable$p(this.this$0));
                if (LineStatusTrackerManager.access$getPartialChangeListsEnabled$p(this.this$0)) {
                    editorFactory.getEventMulticaster().addDocumentListener((DocumentListener)this.this$0.new MyDocumentListener(), LineStatusTrackerManager.access$getDisposable$p(this.this$0));
                }
                LineStatusTrackerManager.access$getChangeListManager$p(this.this$0).addChangeListListener((ChangeListListener)this.this$0.new MyChangeListListener());
                VirtualFileManager virtualFileManager = VirtualFileManager.getInstance();
                virtualFileManager.addVirtualFileListener((VirtualFileListener)this.this$0.new MyVirtualFileListener(), LineStatusTrackerManager.access$getDisposable$p(this.this$0));
            }
            {
                this.this$0 = lineStatusTrackerManager;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disposeComponent() {
        this.isDisposed = true;
        Disposer.dispose((Disposable)this.disposable);
        Object object = this.LOCK;
        synchronized (object) {
            Map map = (Map)this.forcedDocuments;
            Iterator iterator = map.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry;
                Map.Entry entry2 = entry = iterator.next();
                Document document = (Document)entry2.getKey();
                entry2 = entry;
                Multiset multiset2 = (Multiset)entry2.getValue();
                for (Object requester : multiset2.elementSet()) {
                    this.warn("Tracker for is being held on dispose by " + requester, document);
                }
            }
            this.forcedDocuments.clear();
            for (TrackerData data : this.trackers.values()) {
                this.unregisterTrackerInCLM(data.getTracker());
                data.getTracker().release();
            }
            this.trackers.clear();
            this.loader.clear();
            iterator = Unit.INSTANCE;
        }
    }

    @NonNls
    @NotNull
    public String getComponentName() {
        return "LineStatusTrackerManager";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public LineStatusTracker<?> getLineStatusTracker(@NotNull Document document) {
        Intrinsics.checkParameterIsNotNull((Object)document, (String)"document");
        Object object = this.LOCK;
        synchronized (object) {
            TrackerData trackerData = (TrackerData)this.trackers.get((Object)document);
            LineStatusTracker<?> lineStatusTracker = trackerData != null ? trackerData.getTracker() : null;
            return lineStatusTracker;
        }
    }

    @Override
    @Nullable
    public LineStatusTracker<?> getLineStatusTracker(@NotNull VirtualFile file2) {
        Document document;
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        Document document2 = this.fileDocumentManager.getCachedDocument(file2);
        if (document2 == null) {
            return null;
        }
        Document document3 = document = document2;
        Intrinsics.checkExpressionValueIsNotNull((Object)document3, (String)"document");
        return this.getLineStatusTracker(document3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void requestTrackerFor(@NotNull Document document, @NotNull Object requester) {
        Intrinsics.checkParameterIsNotNull((Object)document, (String)"document");
        Intrinsics.checkParameterIsNotNull((Object)requester, (String)"requester");
        Object object = this.LOCK;
        synchronized (object) {
            Multiset multiset2 = (Multiset)this.forcedDocuments.computeIfAbsent((Object)document, (Function)requestTrackerFor.1.multiset.1.INSTANCE);
            multiset2.add(requester);
            if (this.trackers.get((Object)document) == null) {
                VirtualFile virtualFile;
                VirtualFile virtualFile2 = this.fileDocumentManager.getFile(document);
                if (virtualFile2 == null) {
                    return;
                }
                VirtualFile virtualFile3 = virtualFile = virtualFile2;
                Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile3, (String)"virtualFile");
                this.installTracker(virtualFile3, document);
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void releaseTrackerFor(@NotNull Document document, @NotNull Object requester) {
        Intrinsics.checkParameterIsNotNull((Object)document, (String)"document");
        Intrinsics.checkParameterIsNotNull((Object)requester, (String)"requester");
        Object object = this.LOCK;
        synchronized (object) {
            Multiset multiset2 = (Multiset)this.forcedDocuments.get((Object)document);
            if (multiset2 == null || !multiset2.contains(requester)) {
                this.warn("Tracker release underflow by " + requester, document);
                return;
            }
            multiset2.remove(requester);
            if (multiset2.isEmpty()) {
                this.forcedDocuments.remove((Object)document);
                this.checkIfTrackerCanBeReleased(document);
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    @Override
    public void invokeAfterUpdate(@NotNull Runnable task) {
        Intrinsics.checkParameterIsNotNull((Object)task, (String)"task");
        this.loader.addAfterUpdateRunnable(task);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void checkIfTrackerCanBeReleased(Document document) {
        Object object = this.LOCK;
        synchronized (object) {
            TrackerData trackerData = (TrackerData)this.trackers.get((Object)document);
            if (trackerData == null) {
                return;
            }
            TrackerData data = trackerData;
            if (this.forcedDocuments.containsKey((Object)document)) {
                return;
            }
            if (data.getTracker() instanceof PartialLocalLineStatusTracker) {
                boolean hasPartialChanges = ((PartialLocalLineStatusTracker)data.getTracker()).getAffectedChangeListsIds().size() > 1;
                boolean isLoading = this.loader.hasRequest(new RefreshRequest(document, null, 2, null));
                if (hasPartialChanges || isLoading) {
                    return;
                }
            }
            this.releaseTracker(document);
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void onEverythingChanged() {
        Object object = this.LOCK;
        synchronized (object) {
            if (this.isDisposed) {
                return;
            }
            this.log("onEverythingChanged", null);
            HashSet<VirtualFile> files = new HashSet<VirtualFile>();
            for (TrackerData data : this.trackers.values()) {
                files.add(data.getTracker().getVirtualFile());
            }
            for (Document document : this.forcedDocuments.keySet()) {
                VirtualFile file2 = this.fileDocumentManager.getFile(document);
                if (file2 == null) continue;
                files.add(file2);
            }
            Unit unit = files.iterator();
            while (unit.hasNext()) {
                VirtualFile file3;
                VirtualFile virtualFile = file3 = (VirtualFile)unit.next();
                Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile, (String)"file");
                this.onFileChanged(virtualFile);
            }
            unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void onFileChanged(VirtualFile virtualFile) {
        Document document = this.fileDocumentManager.getCachedDocument(virtualFile);
        if (document == null) {
            return;
        }
        Document document2 = document;
        Object object = this.LOCK;
        synchronized (object) {
            LineStatusTracker<?> tracker;
            if (this.isDisposed) {
                return;
            }
            this.log("onFileChanged", virtualFile);
            TrackerData trackerData = (TrackerData)this.trackers.get((Object)document2);
            LineStatusTracker<Object> lineStatusTracker = tracker = trackerData != null ? trackerData.getTracker() : null;
            if (tracker == null) {
                if (this.forcedDocuments.containsKey((Object)document2)) {
                    Document document3 = document2;
                    Intrinsics.checkExpressionValueIsNotNull((Object)document3, (String)"document");
                    this.installTracker(virtualFile, document3);
                }
            } else {
                boolean isPartialTracker;
                boolean isPartialTrackerExpected = this.canCreatePartialTrackerFor(virtualFile);
                if (isPartialTrackerExpected == (isPartialTracker = tracker instanceof PartialLocalLineStatusTracker)) {
                    LineStatusTrackerManager.refreshTracker$default(this, tracker, null, 2, null);
                } else {
                    Document document4 = document2;
                    Intrinsics.checkExpressionValueIsNotNull((Object)document4, (String)"document");
                    this.releaseTracker(document4);
                    this.installTracker(virtualFile, document2);
                }
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    private final void registerTrackerInCLM(LineStatusTracker<?> tracker) {
        if (tracker instanceof PartialLocalLineStatusTracker) {
            FilePath filePath = VcsUtil.getFilePath((VirtualFile)tracker.getVirtualFile());
            this.changeListManager.registerChangeTracker(filePath, (ChangeListWorker.PartialChangeTracker)((Object)tracker));
        }
    }

    private final void unregisterTrackerInCLM(LineStatusTracker<?> tracker) {
        if (tracker instanceof PartialLocalLineStatusTracker) {
            FilePath filePath = VcsUtil.getFilePath((VirtualFile)tracker.getVirtualFile());
            this.changeListManager.unregisterChangeTracker(filePath, (ChangeListWorker.PartialChangeTracker)((Object)tracker));
        }
    }

    private final void reregisterTrackerInCLM(LineStatusTracker<?> tracker, FilePath oldPath, FilePath newPath) {
        if (tracker instanceof PartialLocalLineStatusTracker) {
            this.changeListManager.unregisterChangeTracker(oldPath, (ChangeListWorker.PartialChangeTracker)((Object)tracker));
            this.changeListManager.registerChangeTracker(newPath, (ChangeListWorker.PartialChangeTracker)((Object)tracker));
        }
    }

    private final boolean canGetBaseRevisionFor(VirtualFile virtualFile) {
        if (this.isDisposed) {
            return false;
        }
        if (virtualFile == null || virtualFile instanceof LightVirtualFile || !virtualFile.isValid()) {
            return false;
        }
        if (virtualFile.getFileType().isBinary() || FileUtilRt.isTooLarge((long)virtualFile.getLength())) {
            return false;
        }
        if (!this.statusProvider.isSupported(virtualFile)) {
            return false;
        }
        FileStatus status = FileStatusManager.getInstance((Project)this.project).getStatus(virtualFile);
        return !Intrinsics.areEqual((Object)status, (Object)FileStatus.ADDED) && !Intrinsics.areEqual((Object)status, (Object)FileStatus.DELETED) && !Intrinsics.areEqual((Object)status, (Object)FileStatus.UNKNOWN) && !Intrinsics.areEqual((Object)status, (Object)FileStatus.IGNORED);
    }

    private final boolean canCreatePartialTrackerFor(VirtualFile virtualFile) {
        if (!this.arePartialChangelistsEnabled(virtualFile)) {
            return false;
        }
        FileStatus status = FileStatusManager.getInstance((Project)this.project).getStatus(virtualFile);
        if (Intrinsics.areEqual((Object)status, (Object)FileStatus.MODIFIED) ^ true && Intrinsics.areEqual((Object)status, (Object)FileStatus.NOT_CHANGED) ^ true) {
            return false;
        }
        Change change = ChangeListManager.getInstance((Project)this.project).getChange(virtualFile);
        return change != null && Intrinsics.areEqual(change.getClass(), Change.class) && Intrinsics.areEqual((Object)change.getType(), (Object)Change.Type.MODIFICATION) && change.getAfterRevision() instanceof CurrentContentRevision;
    }

    @Override
    public boolean arePartialChangelistsEnabled(@NotNull VirtualFile virtualFile) {
        Intrinsics.checkParameterIsNotNull((Object)virtualFile, (String)"virtualFile");
        if (!this.partialChangeListsEnabled) {
            return false;
        }
        if (Intrinsics.areEqual((Object)((Object)this.getTrackingMode()), (Object)((Object)LineStatusTracker.Mode.SILENT))) {
            return false;
        }
        AbstractVcs vcs = VcsUtil.getVcsFor((Project)this.project, (VirtualFile)virtualFile);
        return vcs != null && vcs.arePartialChangelistsSupported();
    }

    private final void installTracker(VirtualFile virtualFile, Document document) {
        if (!this.canGetBaseRevisionFor(virtualFile)) {
            return;
        }
        LocalChangeList localChangeList = this.changeListManager.getChangeList(virtualFile);
        String changelistId = localChangeList != null ? localChangeList.getId() : null;
        this.installTracker(virtualFile, document, changelistId, CollectionsKt.emptyList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void installTracker(VirtualFile virtualFile, Document document, String oldChangesChangelistId, List<? extends DocumentEvent> events) {
        Object object = this.LOCK;
        synchronized (object) {
            if (this.isDisposed) {
                return;
            }
            if (this.trackers.get((Object)document) != null) {
                return;
            }
            LineStatusTracker tracker = this.canCreatePartialTrackerFor(virtualFile) ? (LineStatusTracker)PartialLocalLineStatusTracker.Companion.createTracker(this.project, document, virtualFile, this.getTrackingMode(), events) : (LineStatusTracker)SimpleLocalLineStatusTracker.Companion.createTracker(this.project, document, virtualFile, this.getTrackingMode());
            this.trackers.put((Object)document, (Object)new TrackerData(tracker, null, 2, null));
            this.registerTrackerInCLM(tracker);
            this.refreshTracker(tracker, oldChangesChangelistId);
            this.log("Tracker installed", virtualFile);
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void releaseTracker(Document document) {
        Object object = this.LOCK;
        synchronized (object) {
            if (this.isDisposed) {
                return;
            }
            TrackerData trackerData = (TrackerData)this.trackers.remove((Object)document);
            if (trackerData == null) {
                return;
            }
            TrackerData data = trackerData;
            this.unregisterTrackerInCLM(data.getTracker());
            data.getTracker().release();
            this.log("Tracker released", data.getTracker().getVirtualFile());
            Unit unit = Unit.INSTANCE;
        }
    }

    private final LineStatusTracker.Mode getTrackingMode() {
        VcsApplicationSettings settings = VcsApplicationSettings.getInstance();
        if (!settings.SHOW_LST_GUTTER_MARKERS) {
            return LineStatusTracker.Mode.SILENT;
        }
        if (settings.SHOW_WHITESPACES_IN_LST) {
            return LineStatusTracker.Mode.SMART;
        }
        return LineStatusTracker.Mode.DEFAULT;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void refreshTracker(LineStatusTracker<?> tracker, String changelistId) {
        Object object = this.LOCK;
        synchronized (object) {
            if (this.isDisposed) {
                return;
            }
            this.loader.scheduleRefresh(new RefreshRequest(tracker.getDocument(), changelistId));
            this.log("Refresh queued", tracker.getVirtualFile());
            Unit unit = Unit.INSTANCE;
        }
    }

    static /* bridge */ /* synthetic */ void refreshTracker$default(LineStatusTrackerManager lineStatusTrackerManager, LineStatusTracker lineStatusTracker, String string, int n, Object object) {
        if ((n & 2) != 0) {
            string = null;
        }
        lineStatusTrackerManager.refreshTracker(lineStatusTracker, string);
    }

    private final boolean shouldBeUpdated(ContentInfo oldInfo, ContentInfo newInfo) {
        if (oldInfo == null) {
            return true;
        }
        if (Intrinsics.areEqual((Object)oldInfo.getRevision(), (Object)newInfo.getRevision()) && Intrinsics.areEqual((Object)oldInfo.getRevision(), (Object)VcsRevisionNumber.NULL) ^ true) {
            return Intrinsics.areEqual((Object)oldInfo.getCharset(), (Object)newInfo.getCharset()) ^ true;
        }
        return true;
    }

    private final void edt(Function0<Unit> task) {
        Object object = task;
        if (object != null) {
            Function0<Unit> function0 = object;
            object = new LineStatusTrackerManagerKt$sam$Runnable$8bb02b6c(function0);
        }
        GuiUtils.invokeLaterIfNeeded((Runnable)((Runnable)object), (ModalityState)ModalityState.any());
    }

    private final void log(String message, VirtualFile file2) {
        if (LineStatusTrackerManager.Companion.getLOG().isDebugEnabled()) {
            if (file2 != null) {
                LineStatusTrackerManager.Companion.getLOG().debug(message + "; file: " + file2.getPath());
            } else {
                LineStatusTrackerManager.Companion.getLOG().debug(message);
            }
        }
    }

    private final void warn(String message, Document document) {
        VirtualFile virtualFile;
        Document document2 = document;
        if (document2 != null) {
            Document document3;
            Document it = document3 = document2;
            virtualFile = this.fileDocumentManager.getFile(it);
        } else {
            virtualFile = null;
        }
        VirtualFile file2 = virtualFile;
        this.warn(message, file2);
    }

    private final void warn(String message, VirtualFile file2) {
        if (file2 != null) {
            LineStatusTrackerManager.Companion.getLOG().warn(message + "; file: " + file2.getPath());
        } else {
            LineStatusTrackerManager.Companion.getLOG().warn(message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final List<PartialLocalLineStatusTracker.State> collectPartiallyChangedFilesStates$vcs_impl() {
        List result2 = new ArrayList();
        Object object = this.LOCK;
        synchronized (object) {
            for (TrackerData data : this.trackers.values()) {
                boolean hasPartialChanges;
                LineStatusTracker<?> tracker = data.getTracker();
                if (!(tracker instanceof PartialLocalLineStatusTracker) || !(hasPartialChanges = ((PartialLocalLineStatusTracker)tracker).getAffectedChangeListsIds().size() > 1)) continue;
                result2.add(((PartialLocalLineStatusTracker)tracker).storeTrackerState());
            }
            Unit unit = Unit.INSTANCE;
        }
        return result2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void restoreTrackersForPartiallyChangedFiles$vcs_impl(@NotNull List<PartialLocalLineStatusTracker.State> trackerStates) {
        Intrinsics.checkParameterIsNotNull(trackerStates, (String)"trackerStates");
        Object object = this.LOCK;
        synchronized (object) {
            for (PartialLocalLineStatusTracker.State state : trackerStates) {
                Document document;
                VirtualFile virtualFile = state.getVirtualFile();
                if (this.fileDocumentManager.getDocument(virtualFile) == null) {
                    continue;
                }
                if (!this.canCreatePartialTrackerFor(virtualFile)) continue;
                Document document2 = document;
                Intrinsics.checkExpressionValueIsNotNull((Object)document2, (String)"document");
                PartialLocalLineStatusTracker tracker = PartialLocalLineStatusTracker.Companion.createTracker(this.project, document2, virtualFile, this.getTrackingMode(), state);
                TrackerData oldTracker = (TrackerData)this.trackers.put((Object)document, (Object)new TrackerData(tracker, null, 2, null));
                if (oldTracker != null) {
                    this.unregisterTrackerInCLM(oldTracker.getTracker());
                    oldTracker.getTracker().release();
                }
                this.registerTrackerInCLM(tracker);
                LineStatusTrackerManager.refreshTracker$default(this, tracker, null, 2, null);
                this.log("Tracker restored from config", virtualFile);
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    public LineStatusTrackerManager(@NotNull Project project, @NotNull Application application, @NotNull VcsBaseContentProvider statusProvider, @NotNull ChangeListManagerImpl changeListManager, @NotNull FileDocumentManager fileDocumentManager, @NotNull DirectoryIndex makeSureIndexIsInitializedFirst) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)application, (String)"application");
        Intrinsics.checkParameterIsNotNull((Object)statusProvider, (String)"statusProvider");
        Intrinsics.checkParameterIsNotNull((Object)changeListManager, (String)"changeListManager");
        Intrinsics.checkParameterIsNotNull((Object)fileDocumentManager, (String)"fileDocumentManager");
        Intrinsics.checkParameterIsNotNull((Object)makeSureIndexIsInitializedFirst, (String)"makeSureIndexIsInitializedFirst");
        this.project = project;
        this.application = application;
        this.statusProvider = statusProvider;
        this.changeListManager = changeListManager;
        this.fileDocumentManager = fileDocumentManager;
        this.LOCK = new Object();
        Disposable disposable = Disposer.newDisposable();
        Intrinsics.checkExpressionValueIsNotNull((Object)disposable, (String)"Disposer.newDisposable()");
        this.disposable = disposable;
        this.trackers = new HashMap();
        this.forcedDocuments = new HashMap();
        this.partialChangeListsEnabled = Registry.is((String)"vcs.enable.partial.changelists");
        this.documentsInDefaultChangeList = new HashSet();
        this.loader = new MyBaseRevisionLoader();
    }

    static {
        Companion = new Companion(null);
        LOG = Logger.getInstance(LineStatusTrackerManager.class);
    }

    public static final /* synthetic */ void access$setDisposed$p(LineStatusTrackerManager $this, boolean bl) {
        $this.isDisposed = bl;
    }

    @NotNull
    public static final /* synthetic */ Application access$getApplication$p(LineStatusTrackerManager $this) {
        return $this.application;
    }

    @NotNull
    public static final /* synthetic */ Disposable access$getDisposable$p(LineStatusTrackerManager $this) {
        return $this.disposable;
    }

    @JvmStatic
    @NotNull
    public static final LineStatusTrackerManagerI getInstance(@NotNull Project project) {
        return Companion.getInstance(project);
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0005\u00a2\u0006\u0002\u0010\u0004J\u001e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00030\tH\u0014J\u0016\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00030\t2\u0006\u0010\u0007\u001a\u00020\u0002H\u0014\u00a8\u0006\u000b"}, d2={"Lcom/intellij/openapi/vcs/impl/LineStatusTrackerManager$MyBaseRevisionLoader;", "Lcom/intellij/openapi/vcs/impl/SingleThreadLoader;", "Lcom/intellij/openapi/vcs/impl/LineStatusTrackerManager$RefreshRequest;", "Lcom/intellij/openapi/vcs/impl/LineStatusTrackerManager$RefreshData;", "(Lcom/intellij/openapi/vcs/impl/LineStatusTrackerManager;)V", "handleResult", "", "request", "result", "Lcom/intellij/openapi/vcs/impl/Result;", "loadRequest", "vcs-impl"})
    private final class MyBaseRevisionLoader
    extends SingleThreadLoader<RefreshRequest, RefreshData> {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @NotNull
        protected Result<RefreshData> loadRequest(@NotNull RefreshRequest request) {
            Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
            if (LineStatusTrackerManager.this.isDisposed) {
                return new Result.Canceled();
            }
            Document document = request.getDocument();
            VirtualFile virtualFile = LineStatusTrackerManager.this.fileDocumentManager.getFile(document);
            LineStatusTrackerManager.this.log("Loading started", virtualFile);
            if (virtualFile == null || !virtualFile.isValid()) {
                LineStatusTrackerManager.this.log("Loading error: virtual file is not valid", virtualFile);
                return new Result.Error();
            }
            if (!LineStatusTrackerManager.this.canGetBaseRevisionFor(virtualFile)) {
                LineStatusTrackerManager.this.log("Loading error: cant get base revision", virtualFile);
                return new Result.Error();
            }
            VcsBaseContentProvider.BaseContent baseContent = LineStatusTrackerManager.this.statusProvider.getBaseRevision(virtualFile);
            if (baseContent == null) {
                LineStatusTrackerManager.this.log("Loading error: base revision not found", virtualFile);
                return new Result.Error();
            }
            VcsRevisionNumber vcsRevisionNumber = baseContent.getRevisionNumber();
            Intrinsics.checkExpressionValueIsNotNull((Object)vcsRevisionNumber, (String)"baseContent.revisionNumber");
            Charset charset = virtualFile.getCharset();
            Intrinsics.checkExpressionValueIsNotNull((Object)charset, (String)"virtualFile.charset");
            ContentInfo newContentInfo = new ContentInfo(vcsRevisionNumber, charset);
            Object object = LineStatusTrackerManager.this.LOCK;
            synchronized (object) {
                block11: {
                    TrackerData data;
                    block10: {
                        data = (TrackerData)LineStatusTrackerManager.this.trackers.get((Object)document);
                        if (data != null) break block10;
                        LineStatusTrackerManager.this.log("Loading cancelled: tracker not found", virtualFile);
                        Result result2 = new Result.Canceled();
                        return result2;
                    }
                    if (LineStatusTrackerManager.this.shouldBeUpdated(data.getContentInfo(), newContentInfo)) break block11;
                    LineStatusTrackerManager.this.log("Loading cancelled: no need to update", virtualFile);
                    Result result3 = new Result.Canceled();
                    return result3;
                }
                Unit unit = Unit.INSTANCE;
            }
            String lastUpToDateContent = baseContent.loadContent();
            if (lastUpToDateContent == null) {
                LineStatusTrackerManager.this.log("Loading error: provider failure", virtualFile);
                return new Result.Error();
            }
            String converted = StringUtil.convertLineSeparators((String)lastUpToDateContent);
            LineStatusTrackerManager.this.log("Loading successful", virtualFile);
            String string = converted;
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"converted");
            return new Result.Success<RefreshData>(new RefreshData(string, newContentInfo));
        }

        @Override
        protected void handleResult(@NotNull RefreshRequest request, @NotNull Result<RefreshData> result2) {
            Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
            Intrinsics.checkParameterIsNotNull(result2, (String)"result");
            Document document = request.getDocument();
            Result<RefreshData> result3 = result2;
            if (!(result3 instanceof Result.Canceled)) {
                if (result3 instanceof Result.Error) {
                    LineStatusTrackerManager.this.edt((Function0<Unit>)((Function0)new Function0<Unit>(this, document){
                        final /* synthetic */ MyBaseRevisionLoader this$0;
                        final /* synthetic */ Document $document;

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public final void invoke() {
                            Object object = LineStatusTrackerManager.access$getLOCK$p(this.this$0.LineStatusTrackerManager.this);
                            synchronized (object) {
                                TrackerData trackerData = (TrackerData)LineStatusTrackerManager.access$getTrackers$p(this.this$0.LineStatusTrackerManager.this).get((Object)this.$document);
                                if (trackerData == null) {
                                    return;
                                }
                                TrackerData data = trackerData;
                                data.getTracker().dropBaseRevision();
                                data.setContentInfo(null);
                                LineStatusTrackerManager.access$checkIfTrackerCanBeReleased(this.this$0.LineStatusTrackerManager.this, this.$document);
                                Unit unit = Unit.INSTANCE;
                            }
                        }
                        {
                            this.this$0 = myBaseRevisionLoader;
                            this.$document = document;
                            super(0);
                        }
                    }));
                } else if (result3 instanceof Result.Success) {
                    LineStatusTrackerManager.this.edt((Function0<Unit>)((Function0)new Function0<Unit>(this, document, result2, request){
                        final /* synthetic */ MyBaseRevisionLoader this$0;
                        final /* synthetic */ Document $document;
                        final /* synthetic */ Result $result;
                        final /* synthetic */ RefreshRequest $request;

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public final void invoke() {
                            VirtualFile virtualFile = LineStatusTrackerManager.access$getFileDocumentManager$p(this.this$0.LineStatusTrackerManager.this).getFile(this.$document);
                            if (virtualFile == null) {
                                Intrinsics.throwNpe();
                            }
                            VirtualFile virtualFile2 = virtualFile;
                            RefreshData refreshData = (RefreshData)((Result.Success)this.$result).getData();
                            Object object = LineStatusTrackerManager.access$getLOCK$p(this.this$0.LineStatusTrackerManager.this);
                            synchronized (object) {
                                TrackerData data = (TrackerData)LineStatusTrackerManager.access$getTrackers$p(this.this$0.LineStatusTrackerManager.this).get((Object)this.$document);
                                if (data == null) {
                                    LineStatusTrackerManager.access$log(this.this$0.LineStatusTrackerManager.this, "Loading finished: tracker already released", virtualFile2);
                                    return;
                                }
                                if (!LineStatusTrackerManager.access$shouldBeUpdated(this.this$0.LineStatusTrackerManager.this, data.getContentInfo(), refreshData.getInfo())) {
                                    LineStatusTrackerManager.access$log(this.this$0.LineStatusTrackerManager.this, "Loading finished: no need to update", virtualFile2);
                                    return;
                                }
                                data.setContentInfo(refreshData.getInfo());
                                if (data.getTracker() instanceof PartialLocalLineStatusTracker) {
                                    String string = this.$request.getChangelistId();
                                    if (string == null) {
                                        LocalChangeList localChangeList = LineStatusTrackerManager.access$getChangeListManager$p(this.this$0.LineStatusTrackerManager.this).getChangeList(virtualFile2);
                                        string = localChangeList != null ? localChangeList.getId() : null;
                                    }
                                    String changelist = string;
                                    ((PartialLocalLineStatusTracker)data.getTracker()).setBaseRevision(refreshData.getText(), changelist);
                                } else {
                                    data.getTracker().setBaseRevision(refreshData.getText());
                                }
                                LineStatusTrackerManager.access$log(this.this$0.LineStatusTrackerManager.this, "Loading finished: success", virtualFile2);
                                Unit unit = Unit.INSTANCE;
                            }
                        }
                        {
                            this.this$0 = myBaseRevisionLoader;
                            this.$document = document;
                            this.$result = result2;
                            this.$request = refreshRequest;
                            super(0);
                        }
                    }));
                }
            }
        }

        public MyBaseRevisionLoader() {
            super(LineStatusTrackerManager.this.project);
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\u0004H\u0016\u00a8\u0006\b"}, d2={"Lcom/intellij/openapi/vcs/impl/LineStatusTrackerManager$MyFileStatusListener;", "Lcom/intellij/openapi/vcs/FileStatusListener;", "(Lcom/intellij/openapi/vcs/impl/LineStatusTrackerManager;)V", "fileStatusChanged", "", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "fileStatusesChanged", "vcs-impl"})
    private final class MyFileStatusListener
    implements FileStatusListener {
        public void fileStatusesChanged() {
            LineStatusTrackerManager.this.onEverythingChanged();
        }

        public void fileStatusChanged(@NotNull VirtualFile virtualFile) {
            Intrinsics.checkParameterIsNotNull((Object)virtualFile, (String)"virtualFile");
            LineStatusTrackerManager.this.onFileChanged(virtualFile);
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002\u00a8\u0006\f"}, d2={"Lcom/intellij/openapi/vcs/impl/LineStatusTrackerManager$MyEditorFactoryListener;", "Lcom/intellij/openapi/editor/event/EditorFactoryAdapter;", "(Lcom/intellij/openapi/vcs/impl/LineStatusTrackerManager;)V", "editorCreated", "", "event", "Lcom/intellij/openapi/editor/event/EditorFactoryEvent;", "editorReleased", "isTrackedEditor", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "vcs-impl"})
    private final class MyEditorFactoryListener
    extends EditorFactoryAdapter {
        public void editorCreated(@NotNull EditorFactoryEvent event) {
            Editor editor;
            Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
            Editor editor2 = editor = event.getEditor();
            Intrinsics.checkExpressionValueIsNotNull((Object)editor2, (String)"editor");
            if (this.isTrackedEditor(editor2)) {
                Document document = editor.getDocument();
                Intrinsics.checkExpressionValueIsNotNull((Object)document, (String)"editor.document");
                LineStatusTrackerManager.this.requestTrackerFor(document, editor);
            }
        }

        public void editorReleased(@NotNull EditorFactoryEvent event) {
            Editor editor;
            Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
            Editor editor2 = editor = event.getEditor();
            Intrinsics.checkExpressionValueIsNotNull((Object)editor2, (String)"editor");
            if (this.isTrackedEditor(editor2)) {
                Document document = editor.getDocument();
                Intrinsics.checkExpressionValueIsNotNull((Object)document, (String)"editor.document");
                LineStatusTrackerManager.this.releaseTrackerFor(document, editor);
            }
        }

        private final boolean isTrackedEditor(Editor editor) {
            return editor.getProject() == null || Intrinsics.areEqual((Object)editor.getProject(), (Object)LineStatusTrackerManager.this.project);
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\bH\u0016J*\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000b2\u0018\u0010\f\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u000f0\u000e0\rH\u0002\u00a8\u0006\u0010"}, d2={"Lcom/intellij/openapi/vcs/impl/LineStatusTrackerManager$MyVirtualFileListener;", "Lcom/intellij/openapi/vfs/VirtualFileListener;", "(Lcom/intellij/openapi/vcs/impl/LineStatusTrackerManager;)V", "beforeFileMovement", "", "event", "Lcom/intellij/openapi/vfs/VirtualFileMoveEvent;", "beforePropertyChange", "Lcom/intellij/openapi/vfs/VirtualFilePropertyEvent;", "handleFileMovement", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "getPaths", "Lkotlin/Function0;", "Lkotlin/Pair;", "Lcom/intellij/openapi/vcs/FilePath;", "vcs-impl"})
    private final class MyVirtualFileListener
    implements VirtualFileListener {
        public void beforePropertyChange(@NotNull VirtualFilePropertyEvent event) {
            Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
            if (Intrinsics.areEqual((Object)"encoding", (Object)event.getPropertyName())) {
                VirtualFile virtualFile = event.getFile();
                Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile, (String)"event.file");
                LineStatusTrackerManager.this.onFileChanged(virtualFile);
            }
            if (Intrinsics.areEqual((Object)"name", (Object)event.getPropertyName())) {
                VirtualFile file2 = event.getFile();
                VirtualFile parent = event.getParent();
                if (parent != null) {
                    VirtualFile virtualFile = file2;
                    Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile, (String)"file");
                    this.handleFileMovement(virtualFile, (Function0<? extends Pair<? extends FilePath, ? extends FilePath>>)((Function0)new Function0<Pair<? extends FilePath, ? extends FilePath>>(parent, event){
                        final /* synthetic */ VirtualFile $parent;
                        final /* synthetic */ VirtualFilePropertyEvent $event;

                        @NotNull
                        public final Pair<FilePath, FilePath> invoke() {
                            Object object = this.$event.getOldValue();
                            if (object == null) {
                                throw new TypeCastException("null cannot be cast to non-null type kotlin.String");
                            }
                            Object object2 = this.$event.getNewValue();
                            if (object2 == null) {
                                throw new TypeCastException("null cannot be cast to non-null type kotlin.String");
                            }
                            return new Pair((Object)VcsUtil.getFilePath((VirtualFile)this.$parent, (String)((String)object)), (Object)VcsUtil.getFilePath((VirtualFile)this.$parent, (String)((String)object2)));
                        }
                        {
                            this.$parent = virtualFile;
                            this.$event = virtualFilePropertyEvent;
                            super(0);
                        }
                    }));
                }
            }
        }

        public void beforeFileMovement(@NotNull VirtualFileMoveEvent event) {
            VirtualFile file2;
            Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
            VirtualFile virtualFile = file2 = event.getFile();
            Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile, (String)"file");
            this.handleFileMovement(virtualFile, (Function0<? extends Pair<? extends FilePath, ? extends FilePath>>)((Function0)new Function0<Pair<? extends FilePath, ? extends FilePath>>(event, file2){
                final /* synthetic */ VirtualFileMoveEvent $event;
                final /* synthetic */ VirtualFile $file;

                @NotNull
                public final Pair<FilePath, FilePath> invoke() {
                    return new Pair((Object)VcsUtil.getFilePath((VirtualFile)this.$event.getOldParent(), (String)this.$file.getName()), (Object)VcsUtil.getFilePath((VirtualFile)this.$event.getNewParent(), (String)this.$file.getName()));
                }
                {
                    this.$event = virtualFileMoveEvent;
                    this.$file = virtualFile;
                    super(0);
                }
            }));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        private final void handleFileMovement(VirtualFile file2, Function0<? extends Pair<? extends FilePath, ? extends FilePath>> getPaths) {
            if (!LineStatusTrackerManager.this.partialChangeListsEnabled) {
                return;
            }
            Object object = LineStatusTrackerManager.this.LOCK;
            synchronized (object) {
                Unit unit;
                LineStatusTracker<?> tracker = LineStatusTrackerManager.this.getLineStatusTracker(file2);
                if (tracker != null) {
                    void oldPath;
                    unit = (Pair)getPaths.invoke();
                    FilePath filePath = (FilePath)unit.component1();
                    FilePath newPath = (FilePath)unit.component2();
                    LineStatusTrackerManager.this.reregisterTrackerInCLM(tracker, (FilePath)oldPath, newPath);
                }
                unit = Unit.INSTANCE;
            }
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lcom/intellij/openapi/vcs/impl/LineStatusTrackerManager$MyDocumentListener;", "Lcom/intellij/openapi/editor/event/DocumentListener;", "(Lcom/intellij/openapi/vcs/impl/LineStatusTrackerManager;)V", "documentChanged", "", "event", "Lcom/intellij/openapi/editor/event/DocumentEvent;", "vcs-impl"})
    private final class MyDocumentListener
    implements DocumentListener {
        public void documentChanged(@NotNull DocumentEvent event) {
            Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
            Document document = event.getDocument();
            if (LineStatusTrackerManager.this.documentsInDefaultChangeList.contains(document)) {
                return;
            }
            VirtualFile virtualFile = LineStatusTrackerManager.this.fileDocumentManager.getFile(document);
            if (virtualFile == null) {
                return;
            }
            VirtualFile virtualFile2 = virtualFile;
            Document document2 = document;
            Intrinsics.checkExpressionValueIsNotNull((Object)document2, (String)"document");
            if (LineStatusTrackerManager.this.getLineStatusTracker(document2) != null) {
                return;
            }
            VirtualFile virtualFile3 = virtualFile2;
            Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile3, (String)"virtualFile");
            if (!LineStatusTrackerManager.this.canCreatePartialTrackerFor(virtualFile3)) {
                return;
            }
            LocalChangeList changeList = LineStatusTrackerManager.this.changeListManager.getChangeList(virtualFile2);
            if (changeList != null && !changeList.isDefault()) {
                LineStatusTrackerManager.this.installTracker(virtualFile2, document, changeList.getId(), CollectionsKt.listOf((Object)event));
                return;
            }
            LineStatusTrackerManager.this.documentsInDefaultChangeList.add(document);
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lcom/intellij/openapi/vcs/impl/LineStatusTrackerManager$MyApplicationListener;", "Lcom/intellij/openapi/application/ApplicationAdapter;", "(Lcom/intellij/openapi/vcs/impl/LineStatusTrackerManager;)V", "afterWriteActionFinished", "", "action", "", "vcs-impl"})
    private final class MyApplicationListener
    extends ApplicationAdapter {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        public void afterWriteActionFinished(@NotNull Object action) {
            Intrinsics.checkParameterIsNotNull((Object)action, (String)"action");
            LineStatusTrackerManager.this.documentsInDefaultChangeList.clear();
            Object object = LineStatusTrackerManager.this.LOCK;
            synchronized (object) {
                void $receiver$iv$iv;
                Iterable $receiver$iv = LineStatusTrackerManager.this.trackers.values();
                Object object2 = $receiver$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
                for (Object item$iv$iv : $receiver$iv$iv) {
                    void it;
                    TrackerData trackerData = (TrackerData)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    Document document = it.getTracker().getDocument();
                    collection.add(document);
                }
                List documents = (List)destination$iv$iv;
                for (Document document : documents) {
                    LineStatusTrackerManager.this.checkIfTrackerCanBeReleased(document);
                }
                object2 = Unit.INSTANCE;
            }
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016\u00a8\u0006\u0005"}, d2={"Lcom/intellij/openapi/vcs/impl/LineStatusTrackerManager$MyLineStatusTrackerSettingListener;", "Lcom/intellij/openapi/vcs/impl/LineStatusTrackerSettingListener;", "(Lcom/intellij/openapi/vcs/impl/LineStatusTrackerManager;)V", "settingsUpdated", "", "vcs-impl"})
    private final class MyLineStatusTrackerSettingListener
    implements LineStatusTrackerSettingListener {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void settingsUpdated() {
            Object object = LineStatusTrackerManager.this.LOCK;
            synchronized (object) {
                LineStatusTracker.Mode mode = LineStatusTrackerManager.this.getTrackingMode();
                for (TrackerData data : LineStatusTrackerManager.this.trackers.values()) {
                    boolean isPartialTracker;
                    LineStatusTracker<?> tracker = data.getTracker();
                    Document document = tracker.getDocument();
                    VirtualFile virtualFile = tracker.getVirtualFile();
                    if (Intrinsics.areEqual((Object)((Object)tracker.getMode()), (Object)((Object)mode))) continue;
                    boolean isPartialTrackerExpected = LineStatusTrackerManager.this.canCreatePartialTrackerFor(virtualFile);
                    if (isPartialTrackerExpected == (isPartialTracker = tracker instanceof PartialLocalLineStatusTracker)) {
                        tracker.setMode(mode);
                        continue;
                    }
                    LineStatusTrackerManager.this.releaseTracker(document);
                    LineStatusTrackerManager.this.installTracker(virtualFile, document);
                }
                Unit unit = Unit.INSTANCE;
            }
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\u0006H\u0016\u00a8\u0006\b"}, d2={"Lcom/intellij/openapi/vcs/impl/LineStatusTrackerManager$MyChangeListListener;", "Lcom/intellij/openapi/vcs/changes/ChangeListAdapter;", "(Lcom/intellij/openapi/vcs/impl/LineStatusTrackerManager;)V", "defaultListChanged", "", "oldDefaultList", "Lcom/intellij/openapi/vcs/changes/ChangeList;", "newDefaultList", "vcs-impl"})
    private final class MyChangeListListener
    extends ChangeListAdapter {
        public void defaultListChanged(@Nullable ChangeList oldDefaultList, @Nullable ChangeList newDefaultList) {
            LineStatusTrackerManager.this.edt((Function0<Unit>)defaultListChanged.1.INSTANCE);
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006R\u001c\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u0015\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\r"}, d2={"Lcom/intellij/openapi/vcs/impl/LineStatusTrackerManager$TrackerData;", "", "tracker", "Lcom/intellij/openapi/vcs/ex/LineStatusTracker;", "contentInfo", "Lcom/intellij/openapi/vcs/impl/LineStatusTrackerManager$ContentInfo;", "(Lcom/intellij/openapi/vcs/ex/LineStatusTracker;Lcom/intellij/openapi/vcs/impl/LineStatusTrackerManager$ContentInfo;)V", "getContentInfo", "()Lcom/intellij/openapi/vcs/impl/LineStatusTrackerManager$ContentInfo;", "setContentInfo", "(Lcom/intellij/openapi/vcs/impl/LineStatusTrackerManager$ContentInfo;)V", "getTracker", "()Lcom/intellij/openapi/vcs/ex/LineStatusTracker;", "vcs-impl"})
    private static final class TrackerData {
        @NotNull
        private final LineStatusTracker<?> tracker;
        @Nullable
        private ContentInfo contentInfo;

        @NotNull
        public final LineStatusTracker<?> getTracker() {
            return this.tracker;
        }

        @Nullable
        public final ContentInfo getContentInfo() {
            return this.contentInfo;
        }

        public final void setContentInfo(@Nullable ContentInfo contentInfo) {
            this.contentInfo = contentInfo;
        }

        public TrackerData(@NotNull LineStatusTracker<?> tracker, @Nullable ContentInfo contentInfo) {
            Intrinsics.checkParameterIsNotNull(tracker, (String)"tracker");
            this.tracker = tracker;
            this.contentInfo = contentInfo;
        }

        public /* synthetic */ TrackerData(LineStatusTracker lineStatusTracker, ContentInfo contentInfo, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                contentInfo = null;
            }
            this(lineStatusTracker, contentInfo);
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lcom/intellij/openapi/vcs/impl/LineStatusTrackerManager$ContentInfo;", "", "revision", "Lcom/intellij/openapi/vcs/history/VcsRevisionNumber;", "charset", "Ljava/nio/charset/Charset;", "(Lcom/intellij/openapi/vcs/history/VcsRevisionNumber;Ljava/nio/charset/Charset;)V", "getCharset", "()Ljava/nio/charset/Charset;", "getRevision", "()Lcom/intellij/openapi/vcs/history/VcsRevisionNumber;", "vcs-impl"})
    private static final class ContentInfo {
        @NotNull
        private final VcsRevisionNumber revision;
        @NotNull
        private final Charset charset;

        @NotNull
        public final VcsRevisionNumber getRevision() {
            return this.revision;
        }

        @NotNull
        public final Charset getCharset() {
            return this.charset;
        }

        public ContentInfo(@NotNull VcsRevisionNumber revision, @NotNull Charset charset) {
            Intrinsics.checkParameterIsNotNull((Object)revision, (String)"revision");
            Intrinsics.checkParameterIsNotNull((Object)charset, (String)"charset");
            this.revision = revision;
            this.charset = charset;
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u0013\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u000e\u001a\u00020\u000fH\u0016R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0010"}, d2={"Lcom/intellij/openapi/vcs/impl/LineStatusTrackerManager$RefreshRequest;", "", "document", "Lcom/intellij/openapi/editor/Document;", "changelistId", "", "(Lcom/intellij/openapi/editor/Document;Ljava/lang/String;)V", "getChangelistId", "()Ljava/lang/String;", "getDocument", "()Lcom/intellij/openapi/editor/Document;", "equals", "", "other", "hashCode", "", "vcs-impl"})
    private static final class RefreshRequest {
        @NotNull
        private final Document document;
        @Nullable
        private final String changelistId;

        public boolean equals(@Nullable Object other) {
            return other instanceof RefreshRequest && Intrinsics.areEqual((Object)this.document, (Object)((RefreshRequest)other).document);
        }

        public int hashCode() {
            return this.document.hashCode();
        }

        @NotNull
        public final Document getDocument() {
            return this.document;
        }

        @Nullable
        public final String getChangelistId() {
            return this.changelistId;
        }

        public RefreshRequest(@NotNull Document document, @Nullable String changelistId) {
            Intrinsics.checkParameterIsNotNull((Object)document, (String)"document");
            this.document = document;
            this.changelistId = changelistId;
        }

        public /* synthetic */ RefreshRequest(Document document, String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                string = null;
            }
            this(document, string);
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lcom/intellij/openapi/vcs/impl/LineStatusTrackerManager$RefreshData;", "", "text", "", "info", "Lcom/intellij/openapi/vcs/impl/LineStatusTrackerManager$ContentInfo;", "(Ljava/lang/String;Lcom/intellij/openapi/vcs/impl/LineStatusTrackerManager$ContentInfo;)V", "getInfo", "()Lcom/intellij/openapi/vcs/impl/LineStatusTrackerManager$ContentInfo;", "getText", "()Ljava/lang/String;", "vcs-impl"})
    private static final class RefreshData {
        @NotNull
        private final String text;
        @NotNull
        private final ContentInfo info;

        @NotNull
        public final String getText() {
            return this.text;
        }

        @NotNull
        public final ContentInfo getInfo() {
            return this.info;
        }

        public RefreshData(@NotNull String text, @NotNull ContentInfo info) {
            Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
            Intrinsics.checkParameterIsNotNull((Object)info, (String)"info");
            this.text = text;
            this.info = info;
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0007R\u0014\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000b"}, d2={"Lcom/intellij/openapi/vcs/impl/LineStatusTrackerManager$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "getInstance", "Lcom/intellij/openapi/vcs/impl/LineStatusTrackerManagerI;", "project", "Lcom/intellij/openapi/project/Project;", "vcs-impl"})
    public static final class Companion {
        private final Logger getLOG() {
            return LOG;
        }

        @JvmStatic
        @NotNull
        public final LineStatusTrackerManagerI getInstance(@NotNull Project project) {
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            Object object = project.getComponent(LineStatusTrackerManagerI.class);
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"project.getComponent(Lin\u2026ckerManagerI::class.java)");
            return (LineStatusTrackerManagerI)object;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

