/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.newvfs;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VFileProperty;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.impl.ArchiveHandler;
import com.intellij.openapi.vfs.newvfs.ArchiveFileSystem;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.ManagingFS;
import com.intellij.openapi.vfs.newvfs.NewVirtualFile;
import com.intellij.openapi.vfs.newvfs.NewVirtualFileSystem;
import com.intellij.openapi.vfs.newvfs.RefreshQueue;
import com.intellij.openapi.vfs.newvfs.events.VFileContentChangeEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileCreateEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileMoveEvent;
import com.intellij.openapi.vfs.newvfs.events.VFilePropertyChangeEvent;
import com.intellij.util.Consumer;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.TObjectHashingStrategy;
import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VfsImplUtil {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.vfs.newvfs.VfsImplUtil");
    private static final String FILE_SEPARATORS = "/" + File.separator;
    private static final AtomicBoolean ourSubscribed = new AtomicBoolean(false);
    private static final Object ourLock = new Object();
    private static final Map<String, Pair<ArchiveFileSystem, ArchiveHandler>> ourHandlers = ContainerUtil.newTroveMap((TObjectHashingStrategy)FileUtil.PATH_HASHING_STRATEGY);
    private static final Map<String, Set<String>> ourDominatorsMap = ContainerUtil.newTroveMap((TObjectHashingStrategy)FileUtil.PATH_HASHING_STRATEGY);

    private VfsImplUtil() {
    }

    @Nullable
    public static NewVirtualFile findFileByPath(@NotNull NewVirtualFileSystem vfs, @NotNull String path) {
        Pair<NewVirtualFile, Iterable<String>> data;
        if (vfs == null) {
            VfsImplUtil.$$$reportNull$$$0(0);
        }
        if (path == null) {
            VfsImplUtil.$$$reportNull$$$0(1);
        }
        if ((data = VfsImplUtil.prepare(vfs, path)) == null) {
            return null;
        }
        NewVirtualFile file2 = (NewVirtualFile)data.first;
        for (String pathElement : (Iterable)data.second) {
            NewVirtualFile canonicalFile;
            if (pathElement.isEmpty() || ".".equals(pathElement)) continue;
            file2 = "..".equals(pathElement) ? (file2.is(VFileProperty.SYMLINK) ? ((canonicalFile = file2.getCanonicalFile()) != null ? canonicalFile.getParent() : null) : file2.getParent()) : file2.findChild(pathElement);
            if (file2 != null) continue;
            return null;
        }
        return file2;
    }

    @Nullable
    public static NewVirtualFile findFileByPathIfCached(@NotNull NewVirtualFileSystem vfs, @NotNull String path) {
        if (vfs == null) {
            VfsImplUtil.$$$reportNull$$$0(2);
        }
        if (path == null) {
            VfsImplUtil.$$$reportNull$$$0(3);
        }
        return (NewVirtualFile)VfsImplUtil.findCachedFileByPath((NewVirtualFileSystem)vfs, (String)path).first;
    }

    @NotNull
    public static Pair<NewVirtualFile, NewVirtualFile> findCachedFileByPath(@NotNull NewVirtualFileSystem vfs, @NotNull String path) {
        Pair<NewVirtualFile, Iterable<String>> data;
        if (vfs == null) {
            VfsImplUtil.$$$reportNull$$$0(4);
        }
        if (path == null) {
            VfsImplUtil.$$$reportNull$$$0(5);
        }
        if ((data = VfsImplUtil.prepare(vfs, path)) == null) {
            Pair pair = Pair.empty();
            if (pair == null) {
                VfsImplUtil.$$$reportNull$$$0(6);
            }
            return pair;
        }
        NewVirtualFile file2 = (NewVirtualFile)data.first;
        for (String pathElement : (Iterable)data.second) {
            if (pathElement.isEmpty() || ".".equals(pathElement)) continue;
            NewVirtualFile last = file2;
            if ("..".equals(pathElement)) {
                if (file2.is(VFileProperty.SYMLINK)) {
                    String canonicalPath = file2.getCanonicalPath();
                    NewVirtualFile canonicalFile = canonicalPath != null ? (NewVirtualFile)VfsImplUtil.findCachedFileByPath((NewVirtualFileSystem)vfs, (String)canonicalPath).first : null;
                    file2 = canonicalFile != null ? canonicalFile.getParent() : null;
                } else {
                    file2 = file2.getParent();
                }
            } else {
                file2 = file2.findChildIfCached(pathElement);
            }
            if (file2 != null) continue;
            Pair pair = Pair.pair(null, (Object)last);
            if (pair == null) {
                VfsImplUtil.$$$reportNull$$$0(7);
            }
            return pair;
        }
        Pair pair = Pair.pair((Object)file2, null);
        if (pair == null) {
            VfsImplUtil.$$$reportNull$$$0(8);
        }
        return pair;
    }

    @Nullable
    public static NewVirtualFile refreshAndFindFileByPath(@NotNull NewVirtualFileSystem vfs, @NotNull String path) {
        Pair<NewVirtualFile, Iterable<String>> data;
        if (vfs == null) {
            VfsImplUtil.$$$reportNull$$$0(9);
        }
        if (path == null) {
            VfsImplUtil.$$$reportNull$$$0(10);
        }
        if ((data = VfsImplUtil.prepare(vfs, path)) == null) {
            return null;
        }
        NewVirtualFile file2 = (NewVirtualFile)data.first;
        for (String pathElement : (Iterable)data.second) {
            if (pathElement.isEmpty() || ".".equals(pathElement)) continue;
            if ("..".equals(pathElement)) {
                if (file2.is(VFileProperty.SYMLINK)) {
                    String canonicalPath = file2.getCanonicalPath();
                    NewVirtualFile canonicalFile = canonicalPath != null ? VfsImplUtil.refreshAndFindFileByPath(vfs, canonicalPath) : null;
                    file2 = canonicalFile != null ? canonicalFile.getParent() : null;
                } else {
                    file2 = file2.getParent();
                }
            } else {
                file2 = file2.refreshAndFindChild(pathElement);
            }
            if (file2 != null) continue;
            return null;
        }
        return file2;
    }

    @Nullable
    private static Pair<NewVirtualFile, Iterable<String>> prepare(@NotNull NewVirtualFileSystem vfs, @NotNull String path) {
        String normalizedPath;
        if (vfs == null) {
            VfsImplUtil.$$$reportNull$$$0(11);
        }
        if (path == null) {
            VfsImplUtil.$$$reportNull$$$0(12);
        }
        if (StringUtil.isEmptyOrSpaces((String)(normalizedPath = VfsImplUtil.normalize(vfs, path)))) {
            return null;
        }
        String basePath = vfs.extractRootPath(normalizedPath);
        if (basePath.length() > normalizedPath.length() || basePath.isEmpty()) {
            LOG.warn(vfs + " failed to extract root path '" + basePath + "' from '" + normalizedPath + "' (original '" + path + "')");
            return null;
        }
        NewVirtualFile root = ManagingFS.getInstance().findRoot(basePath, vfs);
        if (root == null || !root.exists()) {
            return null;
        }
        Iterable parts = StringUtil.tokenize((String)normalizedPath.substring(basePath.length()), (String)FILE_SEPARATORS);
        return Pair.create((Object)root, (Object)parts);
    }

    public static void refresh(@NotNull NewVirtualFileSystem vfs, boolean asynchronous) {
        VirtualFile[] roots;
        if (vfs == null) {
            VfsImplUtil.$$$reportNull$$$0(13);
        }
        if ((roots = ManagingFS.getInstance().getRoots(vfs)).length > 0) {
            RefreshQueue.getInstance().refresh(asynchronous, true, null, roots);
        }
    }

    public static String normalize(@NotNull NewVirtualFileSystem vfs, @NotNull String path) {
        if (vfs == null) {
            VfsImplUtil.$$$reportNull$$$0(14);
        }
        if (path == null) {
            VfsImplUtil.$$$reportNull$$$0(15);
        }
        return vfs.normalize(path);
    }

    public static void forceSyncRefresh(@NotNull VirtualFile file2) {
        if (file2 == null) {
            VfsImplUtil.$$$reportNull$$$0(16);
        }
        RefreshQueue.getInstance().processSingleEvent((VFileEvent)new VFileContentChangeEvent(null, file2, file2.getModificationStamp(), -1L, true));
    }

    @NotNull
    public static <T extends ArchiveHandler> T getHandler(@NotNull ArchiveFileSystem vfs, @NotNull VirtualFile entryFile, @NotNull Function<String, T> producer) {
        if (vfs == null) {
            VfsImplUtil.$$$reportNull$$$0(17);
        }
        if (entryFile == null) {
            VfsImplUtil.$$$reportNull$$$0(18);
        }
        if (producer == null) {
            VfsImplUtil.$$$reportNull$$$0(19);
        }
        String localPath = vfs.extractLocalPath(vfs.extractRootPath(entryFile.getPath()));
        T t = VfsImplUtil.getHandler(vfs, localPath, producer);
        if (t == null) {
            VfsImplUtil.$$$reportNull$$$0(20);
        }
        return t;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private static <T extends ArchiveHandler> T getHandler(@NotNull ArchiveFileSystem vfs, @NotNull String localPath, @NotNull Function<String, T> producer) {
        ArchiveHandler handler2;
        if (vfs == null) {
            VfsImplUtil.$$$reportNull$$$0(21);
        }
        if (localPath == null) {
            VfsImplUtil.$$$reportNull$$$0(22);
        }
        if (producer == null) {
            VfsImplUtil.$$$reportNull$$$0(23);
        }
        VfsImplUtil.checkSubscription();
        Object object = ourLock;
        synchronized (object) {
            Pair record = ourHandlers.get(localPath);
            if (record == null) {
                handler2 = (ArchiveHandler)producer.fun((Object)localPath);
                record = Pair.create((Object)vfs, (Object)handler2);
                ourHandlers.put(localPath, (Pair<ArchiveFileSystem, ArchiveHandler>)record);
                VfsImplUtil.forEachDirectoryComponent(localPath, (Consumer<String>)((Consumer)containingDirectoryPath -> {
                    if (localPath == null) {
                        VfsImplUtil.$$$reportNull$$$0(25);
                    }
                    Set handlers = ourDominatorsMap.computeIfAbsent((String)containingDirectoryPath, __ -> ContainerUtil.newTroveSet());
                    handlers.add(localPath);
                }));
            }
            handler2 = (ArchiveHandler)record.second;
        }
        ArchiveHandler archiveHandler = handler2;
        if (archiveHandler == null) {
            VfsImplUtil.$$$reportNull$$$0(24);
        }
        return (T)archiveHandler;
    }

    private static void forEachDirectoryComponent(String rootPath, Consumer<String> consumer) {
        int index = rootPath.lastIndexOf(47);
        while (index > 0) {
            String containingDirectoryPath = rootPath.substring(0, index);
            consumer.consume((Object)containingDirectoryPath);
            index = rootPath.lastIndexOf(47, index - 1);
        }
    }

    private static void checkSubscription() {
        if (ourSubscribed.getAndSet(true)) {
            return;
        }
        Application app = ApplicationManager.getApplication();
        if (app.isDisposeInProgress()) {
            return;
        }
        app.getMessageBus().connect((Disposable)app).subscribe(VirtualFileManager.VFS_CHANGES, (Object)new BulkFileListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void after(@NotNull List<? extends VFileEvent> events) {
                if (events == null) {
                    1.$$$reportNull$$$0(0);
                }
                InvalidationState state = null;
                Object object = ourLock;
                synchronized (object) {
                    for (VFileEvent vFileEvent : events) {
                        if (!(vFileEvent.getFileSystem() instanceof LocalFileSystem) || vFileEvent instanceof VFileCreateEvent || vFileEvent instanceof VFilePropertyChangeEvent && !"name".equals(((VFilePropertyChangeEvent)vFileEvent).getPropertyName())) continue;
                        String path = vFileEvent.getPath();
                        if (vFileEvent instanceof VFilePropertyChangeEvent) {
                            path = ((VFilePropertyChangeEvent)vFileEvent).getOldPath();
                        } else if (vFileEvent instanceof VFileMoveEvent) {
                            path = ((VFileMoveEvent)vFileEvent).getOldPath();
                        }
                        VirtualFile file2 = vFileEvent.getFile();
                        if (file2 == null || !file2.isDirectory()) {
                            state = InvalidationState.invalidate(state, path);
                            continue;
                        }
                        Collection affectedPaths = (Collection)ourDominatorsMap.get(path);
                        if (affectedPaths == null) continue;
                        affectedPaths = ContainerUtil.newArrayList((Iterable)affectedPaths);
                        for (String affectedPath : affectedPaths) {
                            state = InvalidationState.invalidate(state, affectedPath);
                        }
                    }
                }
                if (state != null) {
                    state.scheduleRefresh();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "events", "com/intellij/openapi/vfs/newvfs/VfsImplUtil$1", "after"));
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 20: 
            case 24: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 20: 
            case 24: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vfs";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 10: 
            case 12: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 20: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vfs/newvfs/VfsImplUtil";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entryFile";
                break;
            }
            case 19: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "producer";
                break;
            }
            case 22: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vfs/newvfs/VfsImplUtil";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "findCachedFileByPath";
                break;
            }
            case 20: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getHandler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findFileByPath";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findFileByPathIfCached";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "findCachedFileByPath";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 20: 
            case 24: {
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "refreshAndFindFileByPath";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "prepare";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "refresh";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "normalize";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "forceSyncRefresh";
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getHandler";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getHandler$1";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 20: 
            case 24: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class InvalidationState {
        private Set<NewVirtualFile> myRootsToRefresh;

        private InvalidationState() {
        }

        @Nullable
        static InvalidationState invalidate(@Nullable InvalidationState state, String path) {
            Pair handlerPair = (Pair)ourHandlers.remove(path);
            if (handlerPair != null) {
                ((ArchiveHandler)handlerPair.second).dispose();
                VfsImplUtil.forEachDirectoryComponent(path, (Consumer<String>)containingDirectoryPath -> {
                    Set handlers = (Set)ourDominatorsMap.get(containingDirectoryPath);
                    if (handlers != null && handlers.remove(path) && handlers.isEmpty()) {
                        ourDominatorsMap.remove(containingDirectoryPath);
                    }
                });
                if (state == null) {
                    state = new InvalidationState();
                }
                state.registerPathToRefresh(path, (ArchiveFileSystem)handlerPair.first);
            }
            return state;
        }

        private void registerPathToRefresh(String path, ArchiveFileSystem vfs) {
            NewVirtualFile root = ManagingFS.getInstance().findRoot(vfs.composeRootPath(path), (NewVirtualFileSystem)vfs);
            if (root != null) {
                if (this.myRootsToRefresh == null) {
                    this.myRootsToRefresh = ContainerUtil.newHashSet();
                }
                this.myRootsToRefresh.add(root);
            }
        }

        void scheduleRefresh() {
            if (this.myRootsToRefresh != null) {
                for (NewVirtualFile root : this.myRootsToRefresh) {
                    root.markDirtyRecursively();
                }
                boolean async = !ApplicationManager.getApplication().isUnitTestMode();
                RefreshQueue.getInstance().refresh(async, true, null, this.myRootsToRefresh);
            }
        }
    }
}

