/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.newvfs.persistent;

import com.intellij.concurrency.ConcurrentCollectionFactory;
import com.intellij.concurrency.JobSchedulerImpl;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.components.ApplicationComponent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectLocator;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.LowMemoryWatcher;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.ShutDownTracker;
import com.intellij.openapi.util.io.BufferExposingByteArrayInputStream;
import com.intellij.openapi.util.io.BufferExposingByteArrayOutputStream;
import com.intellij.openapi.util.io.ByteArraySequence;
import com.intellij.openapi.util.io.FileAttributes;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.InvalidVirtualFileAccessException;
import com.intellij.openapi.vfs.PersistentFSConstants;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.openapi.vfs.VirtualFileWithId;
import com.intellij.openapi.vfs.encoding.EncodingManager;
import com.intellij.openapi.vfs.encoding.EncodingProjectManager;
import com.intellij.openapi.vfs.ex.temp.TempFileSystem;
import com.intellij.openapi.vfs.newvfs.ArchiveFileSystem;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.FileAttribute;
import com.intellij.openapi.vfs.newvfs.NewVirtualFile;
import com.intellij.openapi.vfs.newvfs.NewVirtualFileSystem;
import com.intellij.openapi.vfs.newvfs.VfsImplUtil;
import com.intellij.openapi.vfs.newvfs.events.VFileContentChangeEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileCopyEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileCreateEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileDeleteEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileMoveEvent;
import com.intellij.openapi.vfs.newvfs.events.VFilePropertyChangeEvent;
import com.intellij.openapi.vfs.newvfs.impl.FakeVirtualFile;
import com.intellij.openapi.vfs.newvfs.impl.FileNameCache;
import com.intellij.openapi.vfs.newvfs.impl.StubVirtualFile;
import com.intellij.openapi.vfs.newvfs.impl.VfsData;
import com.intellij.openapi.vfs.newvfs.impl.VirtualDirectoryImpl;
import com.intellij.openapi.vfs.newvfs.impl.VirtualFileSystemEntry;
import com.intellij.openapi.vfs.newvfs.persistent.FSRecords;
import com.intellij.openapi.vfs.newvfs.persistent.PersistentFS;
import com.intellij.util.ArrayUtil;
import com.intellij.util.BitUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.UriUtil;
import com.intellij.util.containers.ConcurrentIntObjectMap;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.IntObjectMap;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.io.ReplicatorInputStream;
import com.intellij.util.messages.MessageBus;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import gnu.trove.TIntArrayList;
import gnu.trove.TIntHashSet;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PersistentFSImpl
extends PersistentFS
implements ApplicationComponent,
Disposable {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.vfs.newvfs.persistent.PersistentFS");
    private final Map<String, VirtualFileSystemEntry> myRoots;
    private final IntObjectMap<VirtualFileSystemEntry> myRootsById;
    private final ConcurrentIntObjectMap<VirtualFileSystemEntry> myIdToDirCache;
    private final Object myInputLock;
    private final AtomicBoolean myShutDown;
    private final AtomicInteger myStructureModificationCount;
    private final BulkFileListener myPublisher;

    public PersistentFSImpl(@NotNull MessageBus bus) {
        if (bus == null) {
            PersistentFSImpl.$$$reportNull$$$0(0);
        }
        this.myRoots = ConcurrentCollectionFactory.createMap(10, 0.4f, JobSchedulerImpl.getCPUCoresCount(), FileUtil.PATH_HASHING_STRATEGY);
        this.myRootsById = ContainerUtil.createConcurrentIntObjectMap((int)10, (float)0.4f, (int)JobSchedulerImpl.getCPUCoresCount());
        this.myIdToDirCache = ContainerUtil.createConcurrentIntObjectSoftValueMap();
        this.myInputLock = new Object();
        this.myShutDown = new AtomicBoolean(false);
        this.myStructureModificationCount = new AtomicInteger();
        ShutDownTracker.getInstance().registerShutdownTask(this::performShutdown);
        LowMemoryWatcher.register(this::clearIdCache, (Disposable)this);
        this.myPublisher = (BulkFileListener)bus.syncPublisher(VirtualFileManager.VFS_CHANGES);
    }

    public void initComponent() {
        FSRecords.connect();
    }

    public void disposeComponent() {
        this.performShutdown();
    }

    public void dispose() {
    }

    private void performShutdown() {
        if (this.myShutDown.compareAndSet(false, true)) {
            LOG.info("VFS dispose started");
            FSRecords.dispose();
            LOG.info("VFS dispose completed");
        }
    }

    @NonNls
    @NotNull
    public String getComponentName() {
        if ("app.component.PersistentFS" == null) {
            PersistentFSImpl.$$$reportNull$$$0(1);
        }
        return "app.component.PersistentFS";
    }

    public boolean areChildrenLoaded(@NotNull VirtualFile dir) {
        if (dir == null) {
            PersistentFSImpl.$$$reportNull$$$0(2);
        }
        return PersistentFSImpl.areChildrenLoaded(PersistentFSImpl.getFileId(dir));
    }

    public long getCreationTimestamp() {
        return FSRecords.getCreationTimestamp();
    }

    @NotNull
    public VirtualFileSystemEntry getOrCacheDir(int id, @NotNull VfsData.Segment segment, @NotNull VfsData.DirectoryData o, @NotNull VirtualDirectoryImpl parent) {
        VirtualFileSystemEntry dir;
        if (segment == null) {
            PersistentFSImpl.$$$reportNull$$$0(3);
        }
        if (o == null) {
            PersistentFSImpl.$$$reportNull$$$0(4);
        }
        if (parent == null) {
            PersistentFSImpl.$$$reportNull$$$0(5);
        }
        if ((dir = (VirtualFileSystemEntry)((Object)this.myIdToDirCache.get(id))) != null) {
            VirtualFileSystemEntry virtualFileSystemEntry = dir;
            if (virtualFileSystemEntry == null) {
                PersistentFSImpl.$$$reportNull$$$0(6);
            }
            return virtualFileSystemEntry;
        }
        dir = new VirtualDirectoryImpl(id, segment, o, parent, parent.getFileSystem());
        VirtualFileSystemEntry virtualFileSystemEntry = (VirtualFileSystemEntry)((Object)this.myIdToDirCache.cacheOrGet(id, (Object)dir));
        if (virtualFileSystemEntry == null) {
            PersistentFSImpl.$$$reportNull$$$0(7);
        }
        return virtualFileSystemEntry;
    }

    public VirtualFileSystemEntry getCachedDir(int id) {
        return (VirtualFileSystemEntry)((Object)this.myIdToDirCache.get(id));
    }

    @NotNull
    private static NewVirtualFileSystem getDelegate(@NotNull VirtualFile file2) {
        if (file2 == null) {
            PersistentFSImpl.$$$reportNull$$$0(8);
        }
        NewVirtualFileSystem newVirtualFileSystem = (NewVirtualFileSystem)file2.getFileSystem();
        if (newVirtualFileSystem == null) {
            PersistentFSImpl.$$$reportNull$$$0(9);
        }
        return newVirtualFileSystem;
    }

    public boolean wereChildrenAccessed(@NotNull VirtualFile dir) {
        if (dir == null) {
            PersistentFSImpl.$$$reportNull$$$0(10);
        }
        return FSRecords.wereChildrenAccessed(PersistentFSImpl.getFileId(dir));
    }

    @NotNull
    public String[] list(@NotNull VirtualFile file2) {
        if (file2 == null) {
            PersistentFSImpl.$$$reportNull$$$0(11);
        }
        int id = PersistentFSImpl.getFileId(file2);
        Object[] nameIds = FSRecords.listAll(id);
        if (!PersistentFSImpl.areChildrenLoaded(id)) {
            nameIds = PersistentFSImpl.persistAllChildren(file2, id, (FSRecords.NameId[])nameIds);
        }
        String[] stringArray = (String[])ContainerUtil.map2Array((Object[])nameIds, String.class, id1 -> id1.name.toString());
        if (stringArray == null) {
            PersistentFSImpl.$$$reportNull$$$0(12);
        }
        return stringArray;
    }

    @Override
    @NotNull
    public String[] listPersisted(@NotNull VirtualFile parent) {
        if (parent == null) {
            PersistentFSImpl.$$$reportNull$$$0(13);
        }
        String[] stringArray = PersistentFSImpl.listPersisted(FSRecords.list(PersistentFSImpl.getFileId(parent)));
        if (stringArray == null) {
            PersistentFSImpl.$$$reportNull$$$0(14);
        }
        return stringArray;
    }

    @NotNull
    private static String[] listPersisted(@NotNull int[] childrenIds) {
        if (childrenIds == null) {
            PersistentFSImpl.$$$reportNull$$$0(15);
        }
        String[] names = ArrayUtil.newStringArray((int)childrenIds.length);
        for (int i = 0; i < childrenIds.length; ++i) {
            names[i] = FSRecords.getName(childrenIds[i]);
        }
        if (names == null) {
            PersistentFSImpl.$$$reportNull$$$0(16);
        }
        return names;
    }

    @NotNull
    private static FSRecords.NameId[] persistAllChildren(@NotNull VirtualFile file2, int id, @NotNull FSRecords.NameId[] current) {
        NewVirtualFileSystem fs;
        Object[] delegateNames;
        if (file2 == null) {
            PersistentFSImpl.$$$reportNull$$$0(17);
        }
        if (current == null) {
            PersistentFSImpl.$$$reportNull$$$0(18);
        }
        if ((delegateNames = VfsUtil.filterNames((String[])(fs = PersistentFSImpl.replaceWithNativeFS(PersistentFSImpl.getDelegate(file2))).list(file2))).length == 0 && current.length > 0) {
            if (current == null) {
                PersistentFSImpl.$$$reportNull$$$0(19);
            }
            return current;
        }
        HashSet toAdd = ContainerUtil.newHashSet((Object[])delegateNames);
        for (FSRecords.NameId nameId : current) {
            toAdd.remove(nameId.name.toString());
        }
        TIntArrayList childrenIds = new TIntArrayList(current.length + toAdd.size());
        ArrayList nameIds = ContainerUtil.newArrayListWithCapacity((int)(current.length + toAdd.size()));
        for (FSRecords.NameId nameId : current) {
            childrenIds.add(nameId.id);
            nameIds.add(nameId);
        }
        for (String newName : toAdd) {
            FakeVirtualFile child = new FakeVirtualFile(file2, newName);
            FileAttributes attributes = fs.getAttributes((VirtualFile)child);
            if (attributes == null) continue;
            int childId = PersistentFSImpl.createAndFillRecord(fs, (VirtualFile)child, id, attributes);
            childrenIds.add(childId);
            nameIds.add(new FSRecords.NameId(childId, FileNameCache.storeName(newName), newName));
        }
        FSRecords.updateList(id, childrenIds.toNativeArray());
        PersistentFSImpl.setChildrenCached(id);
        FSRecords.NameId[] nameIdArray = nameIds.toArray(new FSRecords.NameId[nameIds.size()]);
        if (nameIdArray == null) {
            PersistentFSImpl.$$$reportNull$$$0(20);
        }
        return nameIdArray;
    }

    private static void setChildrenCached(int id) {
        int flags = FSRecords.getFlags(id);
        FSRecords.setFlags(id, flags | 1, true);
    }

    @Override
    @NotNull
    public FSRecords.NameId[] listAll(@NotNull VirtualFile parent) {
        if (parent == null) {
            PersistentFSImpl.$$$reportNull$$$0(21);
        }
        int parentId = PersistentFSImpl.getFileId(parent);
        FSRecords.NameId[] nameIds = FSRecords.listAll(parentId);
        if (!PersistentFSImpl.areChildrenLoaded(parentId)) {
            FSRecords.NameId[] nameIdArray = PersistentFSImpl.persistAllChildren(parent, parentId, nameIds);
            if (nameIdArray == null) {
                PersistentFSImpl.$$$reportNull$$$0(22);
            }
            return nameIdArray;
        }
        if (nameIds == null) {
            PersistentFSImpl.$$$reportNull$$$0(23);
        }
        return nameIds;
    }

    private static boolean areChildrenLoaded(int parentId) {
        return BitUtil.isSet((int)FSRecords.getFlags(parentId), (int)1);
    }

    @Nullable
    public DataInputStream readAttribute(@NotNull VirtualFile file2, @NotNull FileAttribute att) {
        if (file2 == null) {
            PersistentFSImpl.$$$reportNull$$$0(24);
        }
        if (att == null) {
            PersistentFSImpl.$$$reportNull$$$0(25);
        }
        return FSRecords.readAttributeWithLock(PersistentFSImpl.getFileId(file2), att);
    }

    @NotNull
    public DataOutputStream writeAttribute(@NotNull VirtualFile file2, @NotNull FileAttribute att) {
        if (file2 == null) {
            PersistentFSImpl.$$$reportNull$$$0(26);
        }
        if (att == null) {
            PersistentFSImpl.$$$reportNull$$$0(27);
        }
        com.intellij.util.io.DataOutputStream dataOutputStream = FSRecords.writeAttribute(PersistentFSImpl.getFileId(file2), att);
        if (dataOutputStream == null) {
            PersistentFSImpl.$$$reportNull$$$0(28);
        }
        return dataOutputStream;
    }

    @Nullable
    private static DataInputStream readContent(@NotNull VirtualFile file2) {
        if (file2 == null) {
            PersistentFSImpl.$$$reportNull$$$0(29);
        }
        return FSRecords.readContent(PersistentFSImpl.getFileId(file2));
    }

    @Nullable
    private static DataInputStream readContentById(int contentId) {
        return FSRecords.readContentById(contentId);
    }

    @NotNull
    private static DataOutputStream writeContent(@NotNull VirtualFile file2, boolean readOnly) {
        if (file2 == null) {
            PersistentFSImpl.$$$reportNull$$$0(30);
        }
        com.intellij.util.io.DataOutputStream dataOutputStream = FSRecords.writeContent(PersistentFSImpl.getFileId(file2), readOnly);
        if (dataOutputStream == null) {
            PersistentFSImpl.$$$reportNull$$$0(31);
        }
        return dataOutputStream;
    }

    private static void writeContent(@NotNull VirtualFile file2, ByteArraySequence content, boolean readOnly) {
        if (file2 == null) {
            PersistentFSImpl.$$$reportNull$$$0(32);
        }
        FSRecords.writeContent(PersistentFSImpl.getFileId(file2), content, readOnly);
    }

    @Override
    public int storeUnlinkedContent(@NotNull byte[] bytes) {
        if (bytes == null) {
            PersistentFSImpl.$$$reportNull$$$0(33);
        }
        return FSRecords.storeUnlinkedContent(bytes);
    }

    public int getModificationCount(@NotNull VirtualFile file2) {
        if (file2 == null) {
            PersistentFSImpl.$$$reportNull$$$0(34);
        }
        return FSRecords.getModCount(PersistentFSImpl.getFileId(file2));
    }

    public int getModificationCount() {
        return FSRecords.getLocalModCount();
    }

    public int getStructureModificationCount() {
        return this.myStructureModificationCount.get();
    }

    public void incStructuralModificationCount() {
        this.myStructureModificationCount.incrementAndGet();
    }

    public int getFilesystemModificationCount() {
        return FSRecords.getModCount();
    }

    private static boolean writeAttributesToRecord(int id, int parentId, @NotNull VirtualFile file2, @NotNull NewVirtualFileSystem fs, @NotNull FileAttributes attributes) {
        if (file2 == null) {
            PersistentFSImpl.$$$reportNull$$$0(35);
        }
        if (fs == null) {
            PersistentFSImpl.$$$reportNull$$$0(36);
        }
        if (attributes == null) {
            PersistentFSImpl.$$$reportNull$$$0(37);
        }
        assert (id > 0) : id;
        String name = file2.getName();
        if (!name.isEmpty() ? PersistentFSImpl.namesEqual((VirtualFileSystem)fs, name, FSRecords.getNameSequence(id)) : PersistentFSImpl.areChildrenLoaded(id)) {
            return false;
        }
        FSRecords.writeAttributesToRecord(id, parentId, attributes, name);
        return true;
    }

    @Override
    public int getFileAttributes(int id) {
        assert (id > 0);
        return FSRecords.getFlags(id);
    }

    public boolean isDirectory(@NotNull VirtualFile file2) {
        if (file2 == null) {
            PersistentFSImpl.$$$reportNull$$$0(38);
        }
        return PersistentFSImpl.isDirectory(this.getFileAttributes(PersistentFSImpl.getFileId(file2)));
    }

    private static boolean namesEqual(@NotNull VirtualFileSystem fs, @NotNull CharSequence n1, CharSequence n2) {
        if (fs == null) {
            PersistentFSImpl.$$$reportNull$$$0(39);
        }
        if (n1 == null) {
            PersistentFSImpl.$$$reportNull$$$0(40);
        }
        return Comparing.equal((CharSequence)n1, (CharSequence)n2, (boolean)fs.isCaseSensitive());
    }

    public boolean exists(@NotNull VirtualFile fileOrDirectory) {
        if (fileOrDirectory == null) {
            PersistentFSImpl.$$$reportNull$$$0(41);
        }
        return ((VirtualFileWithId)fileOrDirectory).getId() > 0;
    }

    public long getTimeStamp(@NotNull VirtualFile file2) {
        if (file2 == null) {
            PersistentFSImpl.$$$reportNull$$$0(42);
        }
        return FSRecords.getTimestamp(PersistentFSImpl.getFileId(file2));
    }

    public void setTimeStamp(@NotNull VirtualFile file2, long modStamp) throws IOException {
        if (file2 == null) {
            PersistentFSImpl.$$$reportNull$$$0(43);
        }
        int id = PersistentFSImpl.getFileId(file2);
        FSRecords.setTimestamp(id, modStamp);
        PersistentFSImpl.getDelegate(file2).setTimeStamp(file2, modStamp);
    }

    private static int getFileId(@NotNull VirtualFile file2) {
        int id;
        if (file2 == null) {
            PersistentFSImpl.$$$reportNull$$$0(44);
        }
        if ((id = ((VirtualFileWithId)file2).getId()) <= 0) {
            throw new InvalidVirtualFileAccessException(file2);
        }
        return id;
    }

    public boolean isSymLink(@NotNull VirtualFile file2) {
        if (file2 == null) {
            PersistentFSImpl.$$$reportNull$$$0(45);
        }
        return PersistentFSImpl.isSymLink(this.getFileAttributes(PersistentFSImpl.getFileId(file2)));
    }

    public String resolveSymLink(@NotNull VirtualFile file2) {
        if (file2 == null) {
            PersistentFSImpl.$$$reportNull$$$0(46);
        }
        throw new UnsupportedOperationException();
    }

    public boolean isWritable(@NotNull VirtualFile file2) {
        if (file2 == null) {
            PersistentFSImpl.$$$reportNull$$$0(47);
        }
        return !BitUtil.isSet((int)this.getFileAttributes(PersistentFSImpl.getFileId(file2)), (int)4);
    }

    @Override
    public boolean isHidden(@NotNull VirtualFile file2) {
        if (file2 == null) {
            PersistentFSImpl.$$$reportNull$$$0(48);
        }
        return BitUtil.isSet((int)this.getFileAttributes(PersistentFSImpl.getFileId(file2)), (int)64);
    }

    public void setWritable(@NotNull VirtualFile file2, boolean writableFlag) throws IOException {
        if (file2 == null) {
            PersistentFSImpl.$$$reportNull$$$0(49);
        }
        PersistentFSImpl.getDelegate(file2).setWritable(file2, writableFlag);
        boolean oldWritable = this.isWritable(file2);
        if (oldWritable != writableFlag) {
            this.processEvent((VFileEvent)new VFilePropertyChangeEvent((Object)this, file2, "writable", (Object)oldWritable, (Object)writableFlag, false));
        }
    }

    @Override
    public int getId(@NotNull VirtualFile parent, @NotNull String childName, @NotNull NewVirtualFileSystem fs) {
        int parentId;
        int[] children2;
        if (parent == null) {
            PersistentFSImpl.$$$reportNull$$$0(50);
        }
        if (childName == null) {
            PersistentFSImpl.$$$reportNull$$$0(51);
        }
        if (fs == null) {
            PersistentFSImpl.$$$reportNull$$$0(52);
        }
        if ((children2 = FSRecords.list(parentId = PersistentFSImpl.getFileId(parent))).length > 0) {
            int nameId = FSRecords.getNameId(childName);
            int[] nArray = children2;
            int n = nArray.length;
            for (int i = 0; i < n; ++i) {
                int childId = nArray[i];
                if (nameId != FSRecords.getNameId(childId)) continue;
                return childId;
            }
        }
        for (int childId : children2) {
            if (!PersistentFSImpl.namesEqual((VirtualFileSystem)fs, childName, FSRecords.getNameSequence(childId))) continue;
            return childId;
        }
        FakeVirtualFile fake = new FakeVirtualFile(parent, childName);
        FileAttributes attributes = fs.getAttributes((VirtualFile)fake);
        if (attributes != null) {
            int child = PersistentFSImpl.createAndFillRecord(fs, (VirtualFile)fake, parentId, attributes);
            FSRecords.updateList(parentId, ArrayUtil.append((int[])children2, (int)child));
            return child;
        }
        return 0;
    }

    public long getLength(@NotNull VirtualFile file2) {
        if (file2 == null) {
            PersistentFSImpl.$$$reportNull$$$0(53);
        }
        return PersistentFSImpl.mustReloadContent(file2) ? PersistentFSImpl.reloadLengthFromDelegate(file2, PersistentFSImpl.getDelegate(file2)) : this.getLastRecordedLength(file2);
    }

    @Override
    public long getLastRecordedLength(@NotNull VirtualFile file2) {
        if (file2 == null) {
            PersistentFSImpl.$$$reportNull$$$0(54);
        }
        int id = PersistentFSImpl.getFileId(file2);
        return FSRecords.getLength(id);
    }

    @NotNull
    public VirtualFile copyFile(Object requestor, @NotNull VirtualFile file2, @NotNull VirtualFile parent, @NotNull String name) throws IOException {
        if (file2 == null) {
            PersistentFSImpl.$$$reportNull$$$0(55);
        }
        if (parent == null) {
            PersistentFSImpl.$$$reportNull$$$0(56);
        }
        if (name == null) {
            PersistentFSImpl.$$$reportNull$$$0(57);
        }
        PersistentFSImpl.getDelegate(file2).copyFile(requestor, file2, parent, name);
        this.processEvent((VFileEvent)new VFileCopyEvent(requestor, file2, parent, name));
        VirtualFile child = parent.findChild(name);
        if (child == null) {
            throw new IOException("Cannot create child");
        }
        VirtualFile virtualFile = child;
        if (virtualFile == null) {
            PersistentFSImpl.$$$reportNull$$$0(58);
        }
        return virtualFile;
    }

    @NotNull
    public VirtualFile createChildDirectory(Object requestor, @NotNull VirtualFile parent, @NotNull String dir) throws IOException {
        if (parent == null) {
            PersistentFSImpl.$$$reportNull$$$0(59);
        }
        if (dir == null) {
            PersistentFSImpl.$$$reportNull$$$0(60);
        }
        PersistentFSImpl.getDelegate(parent).createChildDirectory(requestor, parent, dir);
        this.processEvent((VFileEvent)new VFileCreateEvent(requestor, parent, dir, true, false));
        VirtualFile child = parent.findChild(dir);
        if (child == null) {
            throw new IOException("Cannot create child directory '" + dir + "' at " + parent.getPath());
        }
        VirtualFile virtualFile = child;
        if (virtualFile == null) {
            PersistentFSImpl.$$$reportNull$$$0(61);
        }
        return virtualFile;
    }

    @NotNull
    public VirtualFile createChildFile(Object requestor, @NotNull VirtualFile parent, @NotNull String file2) throws IOException {
        if (parent == null) {
            PersistentFSImpl.$$$reportNull$$$0(62);
        }
        if (file2 == null) {
            PersistentFSImpl.$$$reportNull$$$0(63);
        }
        PersistentFSImpl.getDelegate(parent).createChildFile(requestor, parent, file2);
        this.processEvent((VFileEvent)new VFileCreateEvent(requestor, parent, file2, false, false));
        VirtualFile child = parent.findChild(file2);
        if (child == null) {
            throw new IOException("Cannot create child file '" + file2 + "' at " + parent.getPath());
        }
        if (child.getCharset().equals(CharsetToolkit.UTF8_CHARSET)) {
            EncodingManager encodingManager;
            Project project = ProjectLocator.getInstance().guessProjectForFile(child);
            Object object = encodingManager = project == null ? EncodingManager.getInstance() : EncodingProjectManager.getInstance((Project)project);
            if (encodingManager.shouldAddBOMForNewUtf8File()) {
                child.setBOM(CharsetToolkit.UTF8_BOM);
            }
        }
        VirtualFile virtualFile = child;
        if (virtualFile == null) {
            PersistentFSImpl.$$$reportNull$$$0(64);
        }
        return virtualFile;
    }

    public void deleteFile(Object requestor, @NotNull VirtualFile file2) throws IOException {
        if (file2 == null) {
            PersistentFSImpl.$$$reportNull$$$0(65);
        }
        NewVirtualFileSystem delegate = PersistentFSImpl.getDelegate(file2);
        delegate.deleteFile(requestor, file2);
        if (!delegate.exists(file2)) {
            this.processEvent((VFileEvent)new VFileDeleteEvent(requestor, file2, false));
        }
    }

    public void renameFile(Object requestor, @NotNull VirtualFile file2, @NotNull String newName) throws IOException {
        if (file2 == null) {
            PersistentFSImpl.$$$reportNull$$$0(66);
        }
        if (newName == null) {
            PersistentFSImpl.$$$reportNull$$$0(67);
        }
        PersistentFSImpl.getDelegate(file2).renameFile(requestor, file2, newName);
        String oldName = file2.getName();
        if (!newName.equals(oldName)) {
            this.processEvent((VFileEvent)new VFilePropertyChangeEvent(requestor, file2, "name", (Object)oldName, (Object)newName, false));
        }
    }

    @NotNull
    public byte[] contentsToByteArray(@NotNull VirtualFile file2) throws IOException {
        if (file2 == null) {
            PersistentFSImpl.$$$reportNull$$$0(68);
        }
        byte[] byArray = this.contentsToByteArray(file2, true);
        if (byArray == null) {
            PersistentFSImpl.$$$reportNull$$$0(69);
        }
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public byte[] contentsToByteArray(@NotNull VirtualFile file2, boolean cacheContent) throws IOException {
        byte[] byArray;
        boolean reloadFromDelegate;
        boolean outdated;
        int fileId;
        if (file2 == null) {
            PersistentFSImpl.$$$reportNull$$$0(70);
        }
        DataInputStream contentStream = null;
        long length = -1L;
        Object object = this.myInputLock;
        synchronized (object) {
            fileId = PersistentFSImpl.getFileId(file2);
            outdated = PersistentFSImpl.checkFlag(fileId, 8) || (length = FSRecords.getLength(fileId)) == -1L;
            reloadFromDelegate = outdated || (contentStream = PersistentFSImpl.readContent(file2)) == null;
        }
        if (reloadFromDelegate) {
            byte[] content;
            NewVirtualFileSystem delegate = PersistentFSImpl.getDelegate(file2);
            if (outdated) {
                FSRecords.setLength(fileId, delegate.getLength(file2));
                content = delegate.contentsToByteArray(file2);
            } else {
                content = delegate.contentsToByteArray(file2);
                FSRecords.setLength(fileId, content.length);
            }
            Application application = ApplicationManager.getApplication();
            if ((!delegate.isReadOnly() || cacheContent && !application.isInternal() && !application.isUnitTestMode()) && (long)content.length <= PersistentFSConstants.FILE_LENGTH_TO_CACHE_THRESHOLD) {
                Object object2 = this.myInputLock;
                synchronized (object2) {
                    PersistentFSImpl.writeContent(file2, new ByteArraySequence(content), delegate.isReadOnly());
                    PersistentFSImpl.setFlag(file2, 8, false);
                }
            }
            if (content == null) {
                PersistentFSImpl.$$$reportNull$$$0(71);
            }
            return content;
        }
        try {
            assert (length >= 0L) : file2;
            byArray = FileUtil.loadBytes((InputStream)contentStream, (int)((int)length));
        }
        catch (IOException e) {
            FSRecords.handleError(e);
            if (ArrayUtil.EMPTY_BYTE_ARRAY == null) {
                PersistentFSImpl.$$$reportNull$$$0(73);
            }
            return ArrayUtil.EMPTY_BYTE_ARRAY;
        }
        if (byArray == null) {
            PersistentFSImpl.$$$reportNull$$$0(72);
        }
        return byArray;
    }

    @Override
    @NotNull
    public byte[] contentsToByteArray(int contentId) throws IOException {
        DataInputStream stream = PersistentFSImpl.readContentById(contentId);
        assert (stream != null) : contentId;
        byte[] byArray = FileUtil.loadBytes((InputStream)stream);
        if (byArray == null) {
            PersistentFSImpl.$$$reportNull$$$0(74);
        }
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public InputStream getInputStream(@NotNull VirtualFile file2) throws IOException {
        DataInputStream contentStream;
        if (file2 == null) {
            PersistentFSImpl.$$$reportNull$$$0(75);
        }
        Object object = this.myInputLock;
        // MONITORENTER : object
        if (!PersistentFSImpl.mustReloadContent(file2) && !FileUtilRt.isTooLarge((long)file2.getLength()) && (contentStream = PersistentFSImpl.readContent(file2)) != null) {
            DataInputStream dataInputStream = contentStream;
            // MONITOREXIT : object
            if (dataInputStream != null) return dataInputStream;
            PersistentFSImpl.$$$reportNull$$$0(78);
            return dataInputStream;
        }
        NewVirtualFileSystem delegate = PersistentFSImpl.getDelegate(file2);
        long len = PersistentFSImpl.reloadLengthFromDelegate(file2, delegate);
        InputStream nativeStream = delegate.getInputStream(file2);
        if (len > PersistentFSConstants.FILE_LENGTH_TO_CACHE_THRESHOLD) {
            InputStream inputStream = nativeStream;
            // MONITOREXIT : object
            if (inputStream != null) return inputStream;
            PersistentFSImpl.$$$reportNull$$$0(76);
            return inputStream;
        }
        InputStream inputStream = this.createReplicator(file2, nativeStream, len, delegate.isReadOnly());
        // MONITOREXIT : object
        if (inputStream != null) return inputStream;
        PersistentFSImpl.$$$reportNull$$$0(77);
        return inputStream;
    }

    private static long reloadLengthFromDelegate(@NotNull VirtualFile file2, @NotNull NewVirtualFileSystem delegate) {
        if (file2 == null) {
            PersistentFSImpl.$$$reportNull$$$0(79);
        }
        if (delegate == null) {
            PersistentFSImpl.$$$reportNull$$$0(80);
        }
        long len = delegate.getLength(file2);
        FSRecords.setLength(PersistentFSImpl.getFileId(file2), len);
        return len;
    }

    /*
     * WARNING - void declaration
     */
    private InputStream createReplicator(final @NotNull VirtualFile file2, InputStream nativeStream, final long fileLength, boolean bl) {
        void readOnly;
        if (file2 == null) {
            PersistentFSImpl.$$$reportNull$$$0(81);
        }
        if (nativeStream instanceof BufferExposingByteArrayInputStream) {
            BufferExposingByteArrayInputStream byteStream = (BufferExposingByteArrayInputStream)nativeStream;
            byte[] bytes = byteStream.getInternalBuffer();
            this.storeContentToStorage(fileLength, file2, (boolean)readOnly, bytes, bytes.length);
            return nativeStream;
        }
        BufferExposingByteArrayOutputStream cache = new BufferExposingByteArrayOutputStream((int)fileLength);
        return new ReplicatorInputStream(nativeStream, cache, (boolean)readOnly, cache){
            final /* synthetic */ boolean val$readOnly;
            final /* synthetic */ BufferExposingByteArrayOutputStream val$cache;
            {
                this.val$readOnly = bl;
                this.val$cache = bufferExposingByteArrayOutputStream;
                super(x0, x1);
            }

            public void close() throws IOException {
                super.close();
                PersistentFSImpl.this.storeContentToStorage(fileLength, file2, this.val$readOnly, this.val$cache.getInternalBuffer(), this.val$cache.size());
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private void storeContentToStorage(long fileLength, @NotNull VirtualFile file2, boolean readOnly, @NotNull byte[] bytes, int n) {
        if (file2 == null) {
            PersistentFSImpl.$$$reportNull$$$0(82);
        }
        if (bytes == null) {
            PersistentFSImpl.$$$reportNull$$$0(83);
        }
        Object object = this.myInputLock;
        synchronized (object) {
            void bytesLength;
            if ((long)bytesLength == fileLength) {
                PersistentFSImpl.writeContent(file2, new ByteArraySequence(bytes, 0, (int)bytesLength), readOnly);
                PersistentFSImpl.setFlag(file2, 8, false);
            } else {
                PersistentFSImpl.setFlag(file2, 8, true);
            }
        }
    }

    private static boolean mustReloadContent(@NotNull VirtualFile file2) {
        int fileId;
        if (file2 == null) {
            PersistentFSImpl.$$$reportNull$$$0(84);
        }
        return PersistentFSImpl.checkFlag(fileId = PersistentFSImpl.getFileId(file2), 8) || FSRecords.getLength(fileId) == -1L;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public OutputStream getOutputStream(final @NotNull VirtualFile file2, final Object requestor, final long modStamp, long l) {
        void timeStamp;
        if (file2 == null) {
            PersistentFSImpl.$$$reportNull$$$0(85);
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream((long)timeStamp){
            private boolean closed;
            final /* synthetic */ long val$timeStamp;
            {
                this.val$timeStamp = l2;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void close() throws IOException {
                if (this.closed) {
                    return;
                }
                super.close();
                ApplicationManager.getApplication().assertWriteAccessAllowed();
                VFileContentChangeEvent event = new VFileContentChangeEvent(requestor, file2, file2.getModificationStamp(), modStamp, false);
                List<VFileContentChangeEvent> events = Collections.singletonList(event);
                PersistentFSImpl.this.myPublisher.before(events);
                NewVirtualFileSystem delegate = PersistentFSImpl.getDelegate(file2);
                OutputStream ioFileStream = delegate.getOutputStream(file2, requestor, modStamp, this.val$timeStamp);
                DataOutputStream persistenceStream = PersistentFSImpl.writeContent(file2, delegate.isReadOnly());
                try {
                    ((OutputStream)persistenceStream).write(this.buf, 0, this.count);
                }
                finally {
                    try {
                        ioFileStream.write(this.buf, 0, this.count);
                    }
                    finally {
                        this.closed = true;
                        ((OutputStream)persistenceStream).close();
                        ioFileStream.close();
                        PersistentFSImpl.executeTouch(file2, false, event.getModificationStamp());
                        PersistentFSImpl.this.myPublisher.after(events);
                    }
                }
            }
        };
        if (byteArrayOutputStream == null) {
            PersistentFSImpl.$$$reportNull$$$0(86);
        }
        return byteArrayOutputStream;
    }

    @Override
    public int acquireContent(@NotNull VirtualFile file2) {
        if (file2 == null) {
            PersistentFSImpl.$$$reportNull$$$0(87);
        }
        return FSRecords.acquireFileContent(PersistentFSImpl.getFileId(file2));
    }

    @Override
    public void releaseContent(int contentId) {
        FSRecords.releaseContent(contentId);
    }

    @Override
    public int getCurrentContentId(@NotNull VirtualFile file2) {
        if (file2 == null) {
            PersistentFSImpl.$$$reportNull$$$0(88);
        }
        return FSRecords.getContentId(PersistentFSImpl.getFileId(file2));
    }

    public void moveFile(Object requestor, @NotNull VirtualFile file2, @NotNull VirtualFile newParent) throws IOException {
        if (file2 == null) {
            PersistentFSImpl.$$$reportNull$$$0(89);
        }
        if (newParent == null) {
            PersistentFSImpl.$$$reportNull$$$0(90);
        }
        PersistentFSImpl.getDelegate(file2).moveFile(requestor, file2, newParent);
        this.processEvent((VFileEvent)new VFileMoveEvent(requestor, file2, newParent));
    }

    private void processEvent(@NotNull VFileEvent event) {
        if (event == null) {
            PersistentFSImpl.$$$reportNull$$$0(91);
        }
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        if (event.isValid()) {
            List<VFileEvent> events = Collections.singletonList(event);
            this.myPublisher.before(events);
            this.applyEvent(event);
            this.myPublisher.after(events);
        }
    }

    private static int groupByPath(@NotNull List<VFileEvent> inEvents, int startIndex, @NotNull Set<String> files, @NotNull Set<String> middleDirs) {
        VFileEvent event;
        String path;
        int i;
        if (inEvents == null) {
            PersistentFSImpl.$$$reportNull$$$0(92);
        }
        if (files == null) {
            PersistentFSImpl.$$$reportNull$$$0(93);
        }
        if (middleDirs == null) {
            PersistentFSImpl.$$$reportNull$$$0(94);
        }
        for (i = startIndex; i < inEvents.size() && !PersistentFSImpl.checkIfConflictingEvent(path = (event = inEvents.get(i)).getPath(), files, middleDirs); ++i) {
            String path2 = null;
            if (event instanceof VFilePropertyChangeEvent && ((VFilePropertyChangeEvent)event).getPropertyName().equals("name")) {
                VFilePropertyChangeEvent pce = (VFilePropertyChangeEvent)event;
                VirtualFile parent = pce.getFile().getParent();
                String newName = (String)pce.getNewValue();
                path2 = parent == null ? newName : parent.getPath() + "/" + newName;
            } else if (event instanceof VFileCopyEvent) {
                path2 = ((VFileCopyEvent)event).getFile().getPath();
            } else if (event instanceof VFileMoveEvent) {
                VFileMoveEvent vme = (VFileMoveEvent)event;
                String newName = vme.getFile().getName();
                path2 = vme.getNewParent().getPath() + "/" + newName;
            }
            if (path2 != null && !path2.equals(path) && PersistentFSImpl.checkIfConflictingEvent(path2, files, middleDirs)) break;
        }
        return i;
    }

    private static boolean checkIfConflictingEvent(@NotNull String path, @NotNull Set<String> files, @NotNull Set<String> middleDirs) {
        int liPrev;
        if (path == null) {
            PersistentFSImpl.$$$reportNull$$$0(95);
        }
        if (files == null) {
            PersistentFSImpl.$$$reportNull$$$0(96);
        }
        if (middleDirs == null) {
            PersistentFSImpl.$$$reportNull$$$0(97);
        }
        if (!files.add(path) || middleDirs.contains(path)) {
            return true;
        }
        int li = path.length();
        while ((liPrev = path.lastIndexOf(47, li - 1)) != -1) {
            String parentDir = path.substring(0, liPrev);
            if (files.contains(parentDir)) {
                return true;
            }
            if (!middleDirs.add(parentDir)) break;
            li = liPrev;
        }
        return false;
    }

    private int groupAndValidate(@NotNull List<VFileEvent> events, int startIndex, @NotNull List<Runnable> outApplyEvents, @NotNull List<VFileEvent> outValidatedEvents, @NotNull Set<String> files, @NotNull Set<String> middleDirs) {
        if (events == null) {
            PersistentFSImpl.$$$reportNull$$$0(98);
        }
        if (outApplyEvents == null) {
            PersistentFSImpl.$$$reportNull$$$0(99);
        }
        if (outValidatedEvents == null) {
            PersistentFSImpl.$$$reportNull$$$0(100);
        }
        if (files == null) {
            PersistentFSImpl.$$$reportNull$$$0(101);
        }
        if (middleDirs == null) {
            PersistentFSImpl.$$$reportNull$$$0(102);
        }
        int endIndex = PersistentFSImpl.groupByPath(events, startIndex, files, middleDirs);
        this.groupCreations(events, startIndex, endIndex, outValidatedEvents, outApplyEvents);
        this.groupDeletions(events, startIndex, endIndex, outValidatedEvents, outApplyEvents);
        this.groupOthers(events, startIndex, endIndex, outValidatedEvents, outApplyEvents);
        return endIndex;
    }

    private void groupCreations(@NotNull List<VFileEvent> events, final int start, final int end, @NotNull List<VFileEvent> outValidated, @NotNull List<Runnable> outApplyEvents) {
        if (events == null) {
            PersistentFSImpl.$$$reportNull$$$0(103);
        }
        if (outValidated == null) {
            PersistentFSImpl.$$$reportNull$$$0(104);
        }
        if (outApplyEvents == null) {
            PersistentFSImpl.$$$reportNull$$$0(105);
        }
        MultiMap<VirtualDirectoryImpl, VFileCreateEvent> grouped = new MultiMap<VirtualDirectoryImpl, VFileCreateEvent>(){

            @NotNull
            protected Map<VirtualDirectoryImpl, Collection<VFileCreateEvent>> createMap() {
                THashMap tHashMap = new THashMap(end - start);
                if (tHashMap == null) {
                    3.$$$reportNull$$$0(0);
                }
                return tHashMap;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/newvfs/persistent/PersistentFSImpl$3", "createMap"));
            }
        };
        for (int i = start; i < end; ++i) {
            VFileEvent e = events.get(i);
            if (!(e instanceof VFileCreateEvent)) continue;
            VFileCreateEvent event = (VFileCreateEvent)e;
            VirtualDirectoryImpl parent = (VirtualDirectoryImpl)event.getParent();
            grouped.putValue((Object)parent, (Object)event);
        }
        boolean hasValidEvents = false;
        for (Map.Entry entry : grouped.entrySet()) {
            VirtualDirectoryImpl directory = (VirtualDirectoryImpl)((Object)entry.getKey());
            List createEvents = (List)entry.getValue();
            directory.validateChildrenToCreate(createEvents);
            hasValidEvents |= !createEvents.isEmpty();
            outValidated.addAll(createEvents);
        }
        if (hasValidEvents) {
            outApplyEvents.add(() -> this.lambda$groupCreations$1((MultiMap)grouped));
        }
    }

    private void groupDeletions(@NotNull List<VFileEvent> events, final int start, final int end, @NotNull List<VFileEvent> outValidated, @NotNull List<Runnable> outApplyEvents) {
        if (events == null) {
            PersistentFSImpl.$$$reportNull$$$0(106);
        }
        if (outValidated == null) {
            PersistentFSImpl.$$$reportNull$$$0(107);
        }
        if (outApplyEvents == null) {
            PersistentFSImpl.$$$reportNull$$$0(108);
        }
        MultiMap<VirtualDirectoryImpl, VFileDeleteEvent> grouped = new MultiMap<VirtualDirectoryImpl, VFileDeleteEvent>(){

            @NotNull
            protected Map<VirtualDirectoryImpl, Collection<VFileDeleteEvent>> createMap() {
                HashMap<VirtualDirectoryImpl, Collection<VFileDeleteEvent>> hashMap = new HashMap<VirtualDirectoryImpl, Collection<VFileDeleteEvent>>(end - start);
                if (hashMap == null) {
                    4.$$$reportNull$$$0(0);
                }
                return hashMap;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/newvfs/persistent/PersistentFSImpl$4", "createMap"));
            }
        };
        boolean hasValidEvents = false;
        for (int i = start; i < end; ++i) {
            VFileEvent event = events.get(i);
            if (!(event instanceof VFileDeleteEvent) || !event.isValid()) continue;
            VFileDeleteEvent de = (VFileDeleteEvent)event;
            VirtualDirectoryImpl parent = (VirtualDirectoryImpl)de.getFile().getParent();
            grouped.putValue((Object)parent, (Object)de);
            outValidated.add(event);
            hasValidEvents = true;
        }
        if (hasValidEvents) {
            outApplyEvents.add(() -> this.lambda$groupDeletions$2((MultiMap)grouped));
        }
    }

    private void groupOthers(@NotNull List<VFileEvent> events, int start, int end, @NotNull List<VFileEvent> outValidated, @NotNull List<Runnable> outApplyEvents) {
        if (events == null) {
            PersistentFSImpl.$$$reportNull$$$0(109);
        }
        if (outValidated == null) {
            PersistentFSImpl.$$$reportNull$$$0(110);
        }
        if (outApplyEvents == null) {
            PersistentFSImpl.$$$reportNull$$$0(111);
        }
        for (int i = start; i < end; ++i) {
            VFileEvent event = events.get(i);
            if (event instanceof VFileCreateEvent || event instanceof VFileDeleteEvent || !event.isValid()) continue;
            outValidated.add(event);
            outApplyEvents.add(() -> this.applyEvent(event));
        }
    }

    @Override
    public void processEvents(@NotNull List<VFileEvent> events) {
        if (events == null) {
            PersistentFSImpl.$$$reportNull$$$0(112);
        }
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        int startIndex = 0;
        ArrayList<Runnable> applyEvents = new ArrayList<Runnable>(events.size());
        THashSet files = new THashSet(events.size());
        THashSet middleDirs = new THashSet(events.size());
        while (startIndex != events.size()) {
            applyEvents.clear();
            ArrayList<VFileEvent> validated = new ArrayList<VFileEvent>(events.size() - startIndex);
            files.clear();
            middleDirs.clear();
            startIndex = this.groupAndValidate(events, startIndex, applyEvents, validated, (Set<String>)files, (Set<String>)middleDirs);
            if (validated.isEmpty()) continue;
            List<VFileEvent> toSend = Collections.unmodifiableList(validated);
            this.myPublisher.before(toSend);
            applyEvents.forEach(Runnable::run);
            this.myPublisher.after(toSend);
        }
    }

    private void applyDeletions(@NotNull MultiMap<VirtualDirectoryImpl, VFileDeleteEvent> deletions) {
        if (deletions == null) {
            PersistentFSImpl.$$$reportNull$$$0(113);
        }
        for (Map.Entry entry : deletions.entrySet()) {
            VirtualDirectoryImpl parent = (VirtualDirectoryImpl)((Object)entry.getKey());
            Collection deleteEvents = (Collection)entry.getValue();
            if (parent == null || !parent.isValid()) {
                deleteEvents.forEach(this::applyEvent);
                return;
            }
            int parentId = PersistentFSImpl.getFileId((VirtualFile)parent);
            int[] oldIds = FSRecords.list(parentId);
            TIntHashSet parentChildrenIds = new TIntHashSet(Math.max(deleteEvents.size(), oldIds.length));
            parentChildrenIds.addAll(oldIds);
            ArrayList<CharSequence> childrenNamesDeleted = new ArrayList<CharSequence>(deleteEvents.size());
            TIntHashSet childrenIdsDeleted = new TIntHashSet(deleteEvents.size());
            for (VFileDeleteEvent event : deleteEvents) {
                VirtualFile file2 = event.getFile();
                int id = PersistentFSImpl.getFileId(file2);
                childrenNamesDeleted.add(file2.getNameSequence());
                childrenIdsDeleted.add(id);
                FSRecords.deleteRecordRecursively(id);
                PersistentFSImpl.invalidateSubtree(file2);
                parentChildrenIds.remove(id);
            }
            parent.removeChildren(childrenIdsDeleted, childrenNamesDeleted);
            FSRecords.updateList(parentId, parentChildrenIds.toArray());
        }
    }

    private void applyCreations(@NotNull MultiMap<VirtualDirectoryImpl, VFileCreateEvent> creations) {
        if (creations == null) {
            PersistentFSImpl.$$$reportNull$$$0(114);
        }
        for (Map.Entry entry : creations.entrySet()) {
            VirtualDirectoryImpl parent = (VirtualDirectoryImpl)((Object)entry.getKey());
            Collection createEvents = (Collection)entry.getValue();
            int parentId = PersistentFSImpl.getFileId((VirtualFile)parent);
            int[] oldIds = FSRecords.list(parentId);
            TIntHashSet parentChildrenIds = new TIntHashSet(Math.max(createEvents.size(), oldIds.length));
            parentChildrenIds.addAll(oldIds);
            ArrayList<FSRecords.NameId> childrenAdded = new ArrayList<FSRecords.NameId>(createEvents.size());
            NewVirtualFileSystem delegate = PersistentFSImpl.replaceWithNativeFS(PersistentFSImpl.getDelegate((VirtualFile)parent));
            delegate.list((VirtualFile)parent);
            for (VFileCreateEvent createEvent : createEvents) {
                createEvent.resetCache();
                String name = createEvent.getChildName();
                FakeVirtualFile fake = new FakeVirtualFile((VirtualFile)parent, name);
                FileAttributes attributes = delegate.getAttributes((VirtualFile)fake);
                if (attributes == null) continue;
                int childId = PersistentFSImpl.createAndFillRecord(delegate, (VirtualFile)fake, parentId, attributes);
                childrenAdded.add(new FSRecords.NameId(childId, -1, name));
                parentChildrenIds.add(childId);
            }
            parent.createAndAddChildren(childrenAdded);
            if (ApplicationManager.getApplication().isUnitTestMode() && !ApplicationInfoImpl.isInStressTest()) {
                long count = Arrays.stream(parentChildrenIds.toArray()).mapToObj(this::findFileById).filter(Objects::nonNull).map(VirtualFile::getName).distinct().count();
                assert (count == (long)parentChildrenIds.size());
            }
            FSRecords.updateList(parentId, parentChildrenIds.toArray());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public VirtualFileSystemEntry findRoot(@NotNull String path, @NotNull NewVirtualFileSystem fs) {
        boolean mark;
        String rootPath;
        String rootName;
        if (path == null) {
            PersistentFSImpl.$$$reportNull$$$0(115);
        }
        if (fs == null) {
            PersistentFSImpl.$$$reportNull$$$0(116);
        }
        if (path.isEmpty()) {
            LOG.error("Invalid root, fs=" + fs);
            return null;
        }
        String rootUrl = PersistentFSImpl.normalizeRootUrl(path, fs);
        VirtualFileSystemEntry root = this.myRoots.get(rootUrl);
        if (root != null) {
            return root;
        }
        if (fs instanceof ArchiveFileSystem) {
            ArchiveFileSystem afs = (ArchiveFileSystem)fs;
            VirtualFile localFile = afs.findLocalByRootPath(path);
            if (localFile == null) {
                return null;
            }
            rootName = localFile.getName();
            rootPath = afs.getRootPathByLocal(localFile);
        } else {
            rootName = rootPath = path;
        }
        FileAttributes attributes = fs.getAttributes((VirtualFile)new StubVirtualFile(){

            @NotNull
            public String getPath() {
                String string = rootPath;
                if (string == null) {
                    5.$$$reportNull$$$0(0);
                }
                return string;
            }

            @Nullable
            public VirtualFile getParent() {
                return null;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/newvfs/persistent/PersistentFSImpl$5", "getPath"));
            }
        });
        if (attributes == null || !attributes.isDirectory()) {
            return null;
        }
        int rootId = FSRecords.findRootRecord(rootUrl);
        VfsData.Segment segment = VfsData.getSegment(rootId, true);
        VfsData.DirectoryData directoryData = new VfsData.DirectoryData();
        FsRoot newRoot = new FsRoot(rootId, segment, directoryData, fs, rootName, StringUtil.trimEnd((String)rootPath, (char)'/'));
        Map<String, VirtualFileSystemEntry> map = this.myRoots;
        synchronized (map) {
            root = this.myRoots.get(rootUrl);
            if (root != null) {
                return root;
            }
            try {
                VfsData.initFile(rootId, segment, -1, directoryData);
            }
            catch (VfsData.FileAlreadyCreatedException e) {
                for (Map.Entry<String, VirtualFileSystemEntry> entry : this.myRoots.entrySet()) {
                    VirtualFileSystemEntry existingRoot = entry.getValue();
                    if (Math.abs(existingRoot.getId()) != rootId) continue;
                    throw new RuntimeException("Duplicate FS roots: " + rootUrl + " and " + entry.getKey() + ", id=" + rootId + ", valid=" + existingRoot.isValid(), e);
                }
                throw new RuntimeException("No root duplication, roots=" + Arrays.toString(FSRecords.listAll(1)), e);
            }
            this.incStructuralModificationCount();
            mark = PersistentFSImpl.writeAttributesToRecord(rootId, 0, (VirtualFile)newRoot, fs, attributes);
            this.myRoots.put(rootUrl, newRoot);
            this.myRootsById.put(rootId, (Object)newRoot);
            this.myIdToDirCache.put(rootId, (Object)newRoot);
        }
        if (!mark && attributes.lastModified != FSRecords.getTimestamp(rootId)) {
            ((VirtualFileSystemEntry)newRoot).markDirtyRecursively();
        }
        LOG.assertTrue(rootId == newRoot.getId(), (Object)("root=" + (Object)((Object)newRoot) + " expected=" + rootId + " actual=" + newRoot.getId()));
        return newRoot;
    }

    @NotNull
    private static String normalizeRootUrl(@NotNull String basePath, @NotNull NewVirtualFileSystem fs) {
        if (basePath == null) {
            PersistentFSImpl.$$$reportNull$$$0(117);
        }
        if (fs == null) {
            PersistentFSImpl.$$$reportNull$$$0(118);
        }
        String normalized = VfsImplUtil.normalize(fs, FileUtil.toCanonicalPath((String)basePath));
        String protocol = fs.getProtocol();
        StringBuilder result2 = new StringBuilder(protocol.length() + "://".length() + normalized.length());
        result2.append(protocol).append("://").append(normalized);
        String string = StringUtil.endsWithChar((CharSequence)result2, (char)'/') ? UriUtil.trimTrailingSlashes(result2.toString()) : result2.toString();
        if (string == null) {
            PersistentFSImpl.$$$reportNull$$$0(119);
        }
        return string;
    }

    @Override
    public void clearIdCache() {
        int[] ids;
        for (int id : ids = this.myIdToDirCache.keys()) {
            if (this.myRootsById.containsKey(id)) continue;
            this.myIdToDirCache.remove(id);
        }
    }

    @Nullable
    public NewVirtualFile findFileById(int id) {
        return this.findFileById(id, false);
    }

    @Override
    public NewVirtualFile findFileByIdIfCached(int id) {
        return this.findFileById(id, true);
    }

    @Nullable
    private VirtualFileSystemEntry findFileById(int id, boolean cachedOnly) {
        VirtualFileSystemEntry cached = (VirtualFileSystemEntry)((Object)this.myIdToDirCache.get(id));
        if (cached != null) {
            return cached;
        }
        Pair<TIntArrayList, VirtualFileSystemEntry> pair = FSRecords.getParents(id, this.myIdToDirCache);
        TIntArrayList parents = (TIntArrayList)pair.getFirst();
        VirtualFileSystemEntry cachedDir = (VirtualFileSystemEntry)((Object)pair.getSecond());
        if (cachedDir == null) {
            return null;
        }
        VirtualFileSystemEntry result2 = cachedDir;
        for (int i = parents.size() - 2; i >= 0; --i) {
            VirtualFileSystemEntry old;
            if (!(result2 instanceof VirtualDirectoryImpl)) {
                return null;
            }
            int parentId = parents.get(i);
            if (!((result2 = ((VirtualDirectoryImpl)result2).findChildById(parentId, cachedOnly)) instanceof VirtualDirectoryImpl) || (old = (VirtualFileSystemEntry)((Object)this.myIdToDirCache.putIfAbsent(parentId, (Object)result2))) == null) continue;
            result2 = old;
        }
        return result2;
    }

    @NotNull
    public VirtualFile[] getRoots() {
        Collection<VirtualFileSystemEntry> roots = this.myRoots.values();
        VirtualFile[] virtualFileArray = VfsUtilCore.toVirtualFileArray(roots);
        if (virtualFileArray == null) {
            PersistentFSImpl.$$$reportNull$$$0(120);
        }
        return virtualFileArray;
    }

    @NotNull
    public VirtualFile[] getRoots(@NotNull NewVirtualFileSystem fs) {
        if (fs == null) {
            PersistentFSImpl.$$$reportNull$$$0(121);
        }
        ArrayList<NewVirtualFile> roots = new ArrayList<NewVirtualFile>();
        for (NewVirtualFile newVirtualFile : this.myRoots.values()) {
            if (newVirtualFile.getFileSystem() != fs) continue;
            roots.add(newVirtualFile);
        }
        VirtualFile[] virtualFileArray = VfsUtilCore.toVirtualFileArray(roots);
        if (virtualFileArray == null) {
            PersistentFSImpl.$$$reportNull$$$0(122);
        }
        return virtualFileArray;
    }

    @NotNull
    public VirtualFile[] getLocalRoots() {
        List roots = ContainerUtil.newSmartList();
        for (NewVirtualFile newVirtualFile : this.myRoots.values()) {
            if (!newVirtualFile.isInLocalFileSystem() || newVirtualFile.getFileSystem() instanceof TempFileSystem) continue;
            roots.add(newVirtualFile);
        }
        VirtualFile[] virtualFileArray = VfsUtilCore.toVirtualFileArray((Collection)roots);
        if (virtualFileArray == null) {
            PersistentFSImpl.$$$reportNull$$$0(123);
        }
        return virtualFileArray;
    }

    private void applyEvent(@NotNull VFileEvent event) {
        if (event == null) {
            PersistentFSImpl.$$$reportNull$$$0(124);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Applying " + event);
        }
        try {
            if (event instanceof VFileCreateEvent) {
                VFileCreateEvent createEvent = (VFileCreateEvent)event;
                this.executeCreateChild(createEvent.getParent(), createEvent.getChildName());
            } else if (event instanceof VFileDeleteEvent) {
                VFileDeleteEvent deleteEvent = (VFileDeleteEvent)event;
                this.executeDelete(deleteEvent.getFile());
            } else if (event instanceof VFileContentChangeEvent) {
                VFileContentChangeEvent contentUpdateEvent = (VFileContentChangeEvent)event;
                PersistentFSImpl.executeTouch(contentUpdateEvent.getFile(), contentUpdateEvent.isFromRefresh(), contentUpdateEvent.getModificationStamp());
            } else if (event instanceof VFileCopyEvent) {
                VFileCopyEvent copyEvent = (VFileCopyEvent)event;
                this.executeCreateChild(copyEvent.getNewParent(), copyEvent.getNewChildName());
            } else if (event instanceof VFileMoveEvent) {
                VFileMoveEvent moveEvent = (VFileMoveEvent)event;
                this.executeMove(moveEvent.getFile(), moveEvent.getNewParent());
            } else if (event instanceof VFilePropertyChangeEvent) {
                VFilePropertyChangeEvent propertyChangeEvent = (VFilePropertyChangeEvent)event;
                VirtualFile file2 = propertyChangeEvent.getFile();
                Object newValue = propertyChangeEvent.getNewValue();
                if ("name".equals(propertyChangeEvent.getPropertyName())) {
                    PersistentFSImpl.executeRename(file2, (String)newValue);
                } else if ("writable".equals(propertyChangeEvent.getPropertyName())) {
                    PersistentFSImpl.executeSetWritable(file2, (Boolean)newValue);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("File " + file2 + " writable=" + file2.isWritable() + " id=" + PersistentFSImpl.getFileId(file2));
                    }
                } else if ("HIDDEN".equals(propertyChangeEvent.getPropertyName())) {
                    PersistentFSImpl.executeSetHidden(file2, (Boolean)newValue);
                } else if ("symlink".equals(propertyChangeEvent.getPropertyName())) {
                    PersistentFSImpl.executeSetTarget(file2, (String)newValue);
                    this.markForContentReloadRecursively(PersistentFSImpl.getFileId(file2));
                }
            }
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
        }
    }

    @NotNull
    @NonNls
    public String toString() {
        if ("PersistentFS" == null) {
            PersistentFSImpl.$$$reportNull$$$0(125);
        }
        return "PersistentFS";
    }

    private void executeCreateChild(@NotNull VirtualFile parent, @NotNull String name) {
        FakeVirtualFile fake;
        NewVirtualFileSystem delegate;
        FileAttributes attributes;
        if (parent == null) {
            PersistentFSImpl.$$$reportNull$$$0(126);
        }
        if (name == null) {
            PersistentFSImpl.$$$reportNull$$$0(127);
        }
        if ((attributes = (delegate = PersistentFSImpl.getDelegate(parent)).getAttributes((VirtualFile)(fake = new FakeVirtualFile(parent, name)))) != null) {
            int parentId = PersistentFSImpl.getFileId(parent);
            int childId = PersistentFSImpl.createAndFillRecord(delegate, (VirtualFile)fake, parentId, attributes);
            PersistentFSImpl.appendIdToParentList(parentId, childId);
            assert (parent instanceof VirtualDirectoryImpl) : parent;
            VirtualDirectoryImpl dir = (VirtualDirectoryImpl)parent;
            VirtualFileSystemEntry child = dir.createChild(name, childId, dir.getFileSystem());
            dir.addChild(child);
            this.incStructuralModificationCount();
        }
    }

    private static int createAndFillRecord(@NotNull NewVirtualFileSystem delegateSystem, @NotNull VirtualFile delegateFile, int parentId, @NotNull FileAttributes attributes) {
        if (delegateSystem == null) {
            PersistentFSImpl.$$$reportNull$$$0(128);
        }
        if (delegateFile == null) {
            PersistentFSImpl.$$$reportNull$$$0(129);
        }
        if (attributes == null) {
            PersistentFSImpl.$$$reportNull$$$0(130);
        }
        int childId = FSRecords.createRecord();
        PersistentFSImpl.writeAttributesToRecord(childId, parentId, delegateFile, delegateSystem, attributes);
        return childId;
    }

    private static void appendIdToParentList(int parentId, int childId) {
        int[] childrenList = FSRecords.list(parentId);
        childrenList = ArrayUtil.append((int[])childrenList, (int)childId);
        FSRecords.updateList(parentId, childrenList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeDelete(@NotNull VirtualFile file2) {
        int parentId;
        if (file2 == null) {
            PersistentFSImpl.$$$reportNull$$$0(131);
        }
        if (!file2.exists()) {
            LOG.error("Deleting a file which does not exist: " + ((VirtualFileWithId)file2).getId() + " " + file2.getPath());
            return;
        }
        this.clearIdCache();
        int id = PersistentFSImpl.getFileId(file2);
        VirtualFile parent = file2.getParent();
        int n = parentId = parent == null ? 0 : PersistentFSImpl.getFileId(parent);
        if (parentId == 0) {
            String rootUrl = PersistentFSImpl.normalizeRootUrl(file2.getPath(), (NewVirtualFileSystem)file2.getFileSystem());
            Map<String, VirtualFileSystemEntry> map = this.myRoots;
            synchronized (map) {
                this.myRoots.remove(rootUrl);
                this.myRootsById.remove(id);
                this.myIdToDirCache.remove(id);
                FSRecords.deleteRootRecord(id);
            }
        } else {
            PersistentFSImpl.removeIdFromParentList(parentId, id, parent, file2);
            VirtualDirectoryImpl directory = (VirtualDirectoryImpl)file2.getParent();
            assert (directory != null) : file2;
            directory.removeChild(file2);
        }
        FSRecords.deleteRecordRecursively(id);
        PersistentFSImpl.invalidateSubtree(file2);
        this.incStructuralModificationCount();
    }

    private static void invalidateSubtree(@NotNull VirtualFile file2) {
        if (file2 == null) {
            PersistentFSImpl.$$$reportNull$$$0(132);
        }
        VirtualFileSystemEntry impl = (VirtualFileSystemEntry)file2;
        impl.invalidate();
        for (VirtualFile child : impl.getCachedChildren()) {
            PersistentFSImpl.invalidateSubtree(child);
        }
    }

    private static void removeIdFromParentList(int parentId, int id, @NotNull VirtualFile parent, VirtualFile file2) {
        int[] childList;
        int index;
        if (parent == null) {
            PersistentFSImpl.$$$reportNull$$$0(133);
        }
        if ((index = ArrayUtil.indexOf((int[])(childList = FSRecords.list(parentId)), (int)id)) == -1) {
            throw new RuntimeException("Cannot find child (" + id + ")" + file2 + "\n\tin (" + parentId + ")" + parent + "\n\tactual children:" + Arrays.toString(childList));
        }
        childList = ArrayUtil.remove((int[])childList, (int)index);
        FSRecords.updateList(parentId, childList);
    }

    private static void executeRename(@NotNull VirtualFile file2, @NotNull String newName) {
        if (file2 == null) {
            PersistentFSImpl.$$$reportNull$$$0(134);
        }
        if (newName == null) {
            PersistentFSImpl.$$$reportNull$$$0(135);
        }
        int id = PersistentFSImpl.getFileId(file2);
        FSRecords.setName(id, newName);
        ((VirtualFileSystemEntry)file2).setNewName(newName);
    }

    private static void executeSetWritable(@NotNull VirtualFile file2, boolean writableFlag) {
        if (file2 == null) {
            PersistentFSImpl.$$$reportNull$$$0(136);
        }
        PersistentFSImpl.setFlag(file2, 4, !writableFlag);
        ((VirtualFileSystemEntry)file2).updateProperty("writable", writableFlag);
    }

    private static void executeSetHidden(@NotNull VirtualFile file2, boolean hiddenFlag) {
        if (file2 == null) {
            PersistentFSImpl.$$$reportNull$$$0(137);
        }
        PersistentFSImpl.setFlag(file2, 64, hiddenFlag);
        ((VirtualFileSystemEntry)file2).updateProperty("HIDDEN", hiddenFlag);
    }

    private static void executeSetTarget(@NotNull VirtualFile file2, String target2) {
        if (file2 == null) {
            PersistentFSImpl.$$$reportNull$$$0(138);
        }
        ((VirtualFileSystemEntry)file2).setLinkTarget(target2);
    }

    private static void setFlag(@NotNull VirtualFile file2, int mask, boolean value) {
        if (file2 == null) {
            PersistentFSImpl.$$$reportNull$$$0(139);
        }
        PersistentFSImpl.setFlag(PersistentFSImpl.getFileId(file2), mask, value);
    }

    private static void setFlag(int id, int mask, boolean value) {
        int flags;
        int oldFlags = FSRecords.getFlags(id);
        int n = flags = value ? oldFlags | mask : oldFlags & ~mask;
        if (oldFlags != flags) {
            FSRecords.setFlags(id, flags, true);
        }
    }

    private static boolean checkFlag(int fileId, int mask) {
        return BitUtil.isSet((int)FSRecords.getFlags(fileId), (int)mask);
    }

    private static void executeTouch(@NotNull VirtualFile file2, boolean reloadContentFromDelegate, long newModificationStamp) {
        if (file2 == null) {
            PersistentFSImpl.$$$reportNull$$$0(140);
        }
        if (reloadContentFromDelegate) {
            PersistentFSImpl.setFlag(file2, 8, true);
        }
        NewVirtualFileSystem delegate = PersistentFSImpl.getDelegate(file2);
        FileAttributes attributes = delegate.getAttributes(file2);
        FSRecords.setLength(PersistentFSImpl.getFileId(file2), attributes != null ? attributes.length : 0L);
        FSRecords.setTimestamp(PersistentFSImpl.getFileId(file2), attributes != null ? attributes.lastModified : 0L);
        ((VirtualFileSystemEntry)file2).setModificationStamp(newModificationStamp);
    }

    private void executeMove(@NotNull VirtualFile file2, @NotNull VirtualFile newParent) {
        if (file2 == null) {
            PersistentFSImpl.$$$reportNull$$$0(141);
        }
        if (newParent == null) {
            PersistentFSImpl.$$$reportNull$$$0(142);
        }
        this.clearIdCache();
        int fileId = PersistentFSImpl.getFileId(file2);
        int newParentId = PersistentFSImpl.getFileId(newParent);
        int oldParentId = PersistentFSImpl.getFileId(file2.getParent());
        PersistentFSImpl.removeIdFromParentList(oldParentId, fileId, file2.getParent(), file2);
        FSRecords.setParent(fileId, newParentId);
        PersistentFSImpl.appendIdToParentList(newParentId, fileId);
        ((VirtualFileSystemEntry)file2).setParent(newParent);
    }

    @Override
    public String getName(int id) {
        assert (id > 0);
        return FSRecords.getName(id);
    }

    public void cleanPersistedContents() {
        int[] roots;
        for (int root : roots = FSRecords.listRoots()) {
            this.markForContentReloadRecursively(root);
        }
    }

    private void markForContentReloadRecursively(int id) {
        if (PersistentFSImpl.isDirectory(this.getFileAttributes(id))) {
            for (int child : FSRecords.list(id)) {
                this.markForContentReloadRecursively(child);
            }
        } else {
            PersistentFSImpl.setFlag(id, 8, true);
        }
    }

    private static boolean looksCanonical(@NotNull String pathBeforeSlash) {
        int i;
        if (pathBeforeSlash == null) {
            PersistentFSImpl.$$$reportNull$$$0(143);
        }
        if (pathBeforeSlash.endsWith("/")) {
            return false;
        }
        int start = 0;
        while ((i = pathBeforeSlash.indexOf("..", start)) != -1) {
            if (i != 0 && pathBeforeSlash.charAt(i - 1) == '/') {
                return false;
            }
            if (i < pathBeforeSlash.length() - 2 && pathBeforeSlash.charAt(i + 2) == '/') {
                return false;
            }
            start = i + 1;
        }
        return true;
    }

    private /* synthetic */ void lambda$groupDeletions$2(MultiMap grouped) {
        this.clearIdCache();
        this.applyDeletions((MultiMap<VirtualDirectoryImpl, VFileDeleteEvent>)grouped);
        this.incStructuralModificationCount();
    }

    private /* synthetic */ void lambda$groupCreations$1(MultiMap grouped) {
        this.applyCreations((MultiMap<VirtualDirectoryImpl, VFileCreateEvent>)grouped);
        this.incStructuralModificationCount();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 6: 
            case 7: 
            case 9: 
            case 12: 
            case 14: 
            case 16: 
            case 19: 
            case 20: 
            case 22: 
            case 23: 
            case 28: 
            case 31: 
            case 58: 
            case 61: 
            case 64: 
            case 69: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 76: 
            case 77: 
            case 78: 
            case 86: 
            case 119: 
            case 120: 
            case 122: 
            case 123: 
            case 125: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 6: 
            case 7: 
            case 9: 
            case 12: 
            case 14: 
            case 16: 
            case 19: 
            case 20: 
            case 22: 
            case 23: 
            case 28: 
            case 31: 
            case 58: 
            case 61: 
            case 64: 
            case 69: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 76: 
            case 77: 
            case 78: 
            case 86: 
            case 119: 
            case 120: 
            case 122: 
            case 123: 
            case 125: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bus";
                break;
            }
            case 1: 
            case 6: 
            case 7: 
            case 9: 
            case 12: 
            case 14: 
            case 16: 
            case 19: 
            case 20: 
            case 22: 
            case 23: 
            case 28: 
            case 31: 
            case 58: 
            case 61: 
            case 64: 
            case 69: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 76: 
            case 77: 
            case 78: 
            case 86: 
            case 119: 
            case 120: 
            case 122: 
            case 123: 
            case 125: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vfs/newvfs/persistent/PersistentFSImpl";
                break;
            }
            case 2: 
            case 10: 
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "segment";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
            case 5: 
            case 13: 
            case 21: 
            case 50: 
            case 56: 
            case 59: 
            case 62: 
            case 126: 
            case 133: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 8: 
            case 11: 
            case 17: 
            case 24: 
            case 26: 
            case 29: 
            case 30: 
            case 32: 
            case 34: 
            case 35: 
            case 38: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 53: 
            case 54: 
            case 55: 
            case 63: 
            case 65: 
            case 66: 
            case 68: 
            case 70: 
            case 75: 
            case 79: 
            case 81: 
            case 82: 
            case 84: 
            case 85: 
            case 87: 
            case 88: 
            case 89: 
            case 131: 
            case 132: 
            case 134: 
            case 136: 
            case 137: 
            case 138: 
            case 139: 
            case 140: 
            case 141: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "childrenIds";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "current";
                break;
            }
            case 25: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "att";
                break;
            }
            case 33: 
            case 83: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bytes";
                break;
            }
            case 36: 
            case 39: 
            case 52: 
            case 116: 
            case 118: 
            case 121: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fs";
                break;
            }
            case 37: 
            case 130: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributes";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "n1";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileOrDirectory";
                break;
            }
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "childName";
                break;
            }
            case 57: 
            case 127: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 67: 
            case 135: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
            case 80: {
                objectArray2 = objectArray3;
                objectArray3[0] = "delegate";
                break;
            }
            case 90: 
            case 142: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newParent";
                break;
            }
            case 91: 
            case 124: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 92: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inEvents";
                break;
            }
            case 93: 
            case 96: 
            case 101: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 94: 
            case 97: 
            case 102: {
                objectArray2 = objectArray3;
                objectArray3[0] = "middleDirs";
                break;
            }
            case 95: 
            case 115: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 98: 
            case 103: 
            case 106: 
            case 109: 
            case 112: {
                objectArray2 = objectArray3;
                objectArray3[0] = "events";
                break;
            }
            case 99: 
            case 105: 
            case 108: 
            case 111: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outApplyEvents";
                break;
            }
            case 100: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outValidatedEvents";
                break;
            }
            case 104: 
            case 107: 
            case 110: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outValidated";
                break;
            }
            case 113: {
                objectArray2 = objectArray3;
                objectArray3[0] = "deletions";
                break;
            }
            case 114: {
                objectArray2 = objectArray3;
                objectArray3[0] = "creations";
                break;
            }
            case 117: {
                objectArray2 = objectArray3;
                objectArray3[0] = "basePath";
                break;
            }
            case 128: {
                objectArray2 = objectArray3;
                objectArray3[0] = "delegateSystem";
                break;
            }
            case 129: {
                objectArray2 = objectArray3;
                objectArray3[0] = "delegateFile";
                break;
            }
            case 143: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathBeforeSlash";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vfs/newvfs/persistent/PersistentFSImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponentName";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCacheDir";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getDelegate";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "list";
                break;
            }
            case 14: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "listPersisted";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "persistAllChildren";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "listAll";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "writeAttribute";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "writeContent";
                break;
            }
            case 58: {
                objectArray = objectArray2;
                objectArray2[1] = "copyFile";
                break;
            }
            case 61: {
                objectArray = objectArray2;
                objectArray2[1] = "createChildDirectory";
                break;
            }
            case 64: {
                objectArray = objectArray2;
                objectArray2[1] = "createChildFile";
                break;
            }
            case 69: 
            case 71: 
            case 72: 
            case 73: 
            case 74: {
                objectArray = objectArray2;
                objectArray2[1] = "contentsToByteArray";
                break;
            }
            case 76: 
            case 77: 
            case 78: {
                objectArray = objectArray2;
                objectArray2[1] = "getInputStream";
                break;
            }
            case 86: {
                objectArray = objectArray2;
                objectArray2[1] = "getOutputStream";
                break;
            }
            case 119: {
                objectArray = objectArray2;
                objectArray2[1] = "normalizeRootUrl";
                break;
            }
            case 120: 
            case 122: {
                objectArray = objectArray2;
                objectArray2[1] = "getRoots";
                break;
            }
            case 123: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocalRoots";
                break;
            }
            case 125: {
                objectArray = objectArray2;
                objectArray2[1] = "toString";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 6: 
            case 7: 
            case 9: 
            case 12: 
            case 14: 
            case 16: 
            case 19: 
            case 20: 
            case 22: 
            case 23: 
            case 28: 
            case 31: 
            case 58: 
            case 61: 
            case 64: 
            case 69: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 76: 
            case 77: 
            case 78: 
            case 86: 
            case 119: 
            case 120: 
            case 122: 
            case 123: 
            case 125: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "areChildrenLoaded";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getOrCacheDir";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getDelegate";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "wereChildrenAccessed";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "list";
                break;
            }
            case 13: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "listPersisted";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "persistAllChildren";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "listAll";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "readAttribute";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "writeAttribute";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "readContent";
                break;
            }
            case 30: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "writeContent";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "storeUnlinkedContent";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "getModificationCount";
                break;
            }
            case 35: 
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "writeAttributesToRecord";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "isDirectory";
                break;
            }
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "namesEqual";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "exists";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "getTimeStamp";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "setTimeStamp";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "getFileId";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "isSymLink";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "resolveSymLink";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "isWritable";
                break;
            }
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "isHidden";
                break;
            }
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "setWritable";
                break;
            }
            case 50: 
            case 51: 
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "getId";
                break;
            }
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "getLength";
                break;
            }
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "getLastRecordedLength";
                break;
            }
            case 55: 
            case 56: 
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "copyFile";
                break;
            }
            case 59: 
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "createChildDirectory";
                break;
            }
            case 62: 
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "createChildFile";
                break;
            }
            case 65: {
                objectArray = objectArray;
                objectArray[2] = "deleteFile";
                break;
            }
            case 66: 
            case 67: {
                objectArray = objectArray;
                objectArray[2] = "renameFile";
                break;
            }
            case 68: 
            case 70: {
                objectArray = objectArray;
                objectArray[2] = "contentsToByteArray";
                break;
            }
            case 75: {
                objectArray = objectArray;
                objectArray[2] = "getInputStream";
                break;
            }
            case 79: 
            case 80: {
                objectArray = objectArray;
                objectArray[2] = "reloadLengthFromDelegate";
                break;
            }
            case 81: {
                objectArray = objectArray;
                objectArray[2] = "createReplicator";
                break;
            }
            case 82: 
            case 83: {
                objectArray = objectArray;
                objectArray[2] = "storeContentToStorage";
                break;
            }
            case 84: {
                objectArray = objectArray;
                objectArray[2] = "mustReloadContent";
                break;
            }
            case 85: {
                objectArray = objectArray;
                objectArray[2] = "getOutputStream";
                break;
            }
            case 87: {
                objectArray = objectArray;
                objectArray[2] = "acquireContent";
                break;
            }
            case 88: {
                objectArray = objectArray;
                objectArray[2] = "getCurrentContentId";
                break;
            }
            case 89: 
            case 90: {
                objectArray = objectArray;
                objectArray[2] = "moveFile";
                break;
            }
            case 91: {
                objectArray = objectArray;
                objectArray[2] = "processEvent";
                break;
            }
            case 92: 
            case 93: 
            case 94: {
                objectArray = objectArray;
                objectArray[2] = "groupByPath";
                break;
            }
            case 95: 
            case 96: 
            case 97: {
                objectArray = objectArray;
                objectArray[2] = "checkIfConflictingEvent";
                break;
            }
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: {
                objectArray = objectArray;
                objectArray[2] = "groupAndValidate";
                break;
            }
            case 103: 
            case 104: 
            case 105: {
                objectArray = objectArray;
                objectArray[2] = "groupCreations";
                break;
            }
            case 106: 
            case 107: 
            case 108: {
                objectArray = objectArray;
                objectArray[2] = "groupDeletions";
                break;
            }
            case 109: 
            case 110: 
            case 111: {
                objectArray = objectArray;
                objectArray[2] = "groupOthers";
                break;
            }
            case 112: {
                objectArray = objectArray;
                objectArray[2] = "processEvents";
                break;
            }
            case 113: {
                objectArray = objectArray;
                objectArray[2] = "applyDeletions";
                break;
            }
            case 114: {
                objectArray = objectArray;
                objectArray[2] = "applyCreations";
                break;
            }
            case 115: 
            case 116: {
                objectArray = objectArray;
                objectArray[2] = "findRoot";
                break;
            }
            case 117: 
            case 118: {
                objectArray = objectArray;
                objectArray[2] = "normalizeRootUrl";
                break;
            }
            case 121: {
                objectArray = objectArray;
                objectArray[2] = "getRoots";
                break;
            }
            case 124: {
                objectArray = objectArray;
                objectArray[2] = "applyEvent";
                break;
            }
            case 126: 
            case 127: {
                objectArray = objectArray;
                objectArray[2] = "executeCreateChild";
                break;
            }
            case 128: 
            case 129: 
            case 130: {
                objectArray = objectArray;
                objectArray[2] = "createAndFillRecord";
                break;
            }
            case 131: {
                objectArray = objectArray;
                objectArray[2] = "executeDelete";
                break;
            }
            case 132: {
                objectArray = objectArray;
                objectArray[2] = "invalidateSubtree";
                break;
            }
            case 133: {
                objectArray = objectArray;
                objectArray[2] = "removeIdFromParentList";
                break;
            }
            case 134: 
            case 135: {
                objectArray = objectArray;
                objectArray[2] = "executeRename";
                break;
            }
            case 136: {
                objectArray = objectArray;
                objectArray[2] = "executeSetWritable";
                break;
            }
            case 137: {
                objectArray = objectArray;
                objectArray[2] = "executeSetHidden";
                break;
            }
            case 138: {
                objectArray = objectArray;
                objectArray[2] = "executeSetTarget";
                break;
            }
            case 139: {
                objectArray = objectArray;
                objectArray[2] = "setFlag";
                break;
            }
            case 140: {
                objectArray = objectArray;
                objectArray[2] = "executeTouch";
                break;
            }
            case 141: 
            case 142: {
                objectArray = objectArray;
                objectArray[2] = "executeMove";
                break;
            }
            case 143: {
                objectArray = objectArray;
                objectArray[2] = "looksCanonical";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 6: 
            case 7: 
            case 9: 
            case 12: 
            case 14: 
            case 16: 
            case 19: 
            case 20: 
            case 22: 
            case 23: 
            case 28: 
            case 31: 
            case 58: 
            case 61: 
            case 64: 
            case 69: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 76: 
            case 77: 
            case 78: 
            case 86: 
            case 119: 
            case 120: 
            case 122: 
            case 123: 
            case 125: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class FsRoot
    extends VirtualDirectoryImpl {
        private final String myName;
        private final String myPathBeforeSlash;

        private FsRoot(int id, @NotNull VfsData.Segment segment, @NotNull VfsData.DirectoryData data, @NotNull NewVirtualFileSystem fs, @NotNull String name, @NotNull String pathBeforeSlash) {
            if (segment == null) {
                FsRoot.$$$reportNull$$$0(0);
            }
            if (data == null) {
                FsRoot.$$$reportNull$$$0(1);
            }
            if (fs == null) {
                FsRoot.$$$reportNull$$$0(2);
            }
            if (name == null) {
                FsRoot.$$$reportNull$$$0(3);
            }
            if (pathBeforeSlash == null) {
                FsRoot.$$$reportNull$$$0(4);
            }
            super(id, segment, data, null, fs);
            this.myName = name;
            if (!PersistentFSImpl.looksCanonical(pathBeforeSlash)) {
                throw new IllegalArgumentException("path must be canonical but got: '" + pathBeforeSlash + "'");
            }
            this.myPathBeforeSlash = pathBeforeSlash;
        }

        @Override
        @NotNull
        public CharSequence getNameSequence() {
            String string = this.myName;
            if (string == null) {
                FsRoot.$$$reportNull$$$0(5);
            }
            return string;
        }

        @Override
        @NotNull
        protected char[] appendPathOnFileSystem(int pathLength, int[] position) {
            char[] chars = new char[pathLength + this.myPathBeforeSlash.length()];
            position[0] = FsRoot.copyString(chars, position[0], this.myPathBeforeSlash);
            if (chars == null) {
                FsRoot.$$$reportNull$$$0(6);
            }
            return chars;
        }

        @Override
        public void setNewName(@NotNull String newName) {
            if (newName == null) {
                FsRoot.$$$reportNull$$$0(7);
            }
            throw new IncorrectOperationException();
        }

        @Override
        public final void setParent(@NotNull VirtualFile newParent) {
            if (newParent == null) {
                FsRoot.$$$reportNull$$$0(8);
            }
            throw new IncorrectOperationException();
        }

        @Override
        @NotNull
        public String getPath() {
            String string = this.myPathBeforeSlash + '/';
            if (string == null) {
                FsRoot.$$$reportNull$$$0(9);
            }
            return string;
        }

        @Override
        @NotNull
        public String getUrl() {
            String string = this.getFileSystem().getProtocol() + "://" + this.getPath();
            if (string == null) {
                FsRoot.$$$reportNull$$$0(10);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 5: 
                case 6: 
                case 9: 
                case 10: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 5: 
                case 6: 
                case 9: 
                case 10: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "segment";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "data";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fs";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "pathBeforeSlash";
                    break;
                }
                case 5: 
                case 6: 
                case 9: 
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/vfs/newvfs/persistent/PersistentFSImpl$FsRoot";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "newName";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "newParent";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/vfs/newvfs/persistent/PersistentFSImpl$FsRoot";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getNameSequence";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "appendPathOnFileSystem";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPath";
                    break;
                }
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getUrl";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 5: 
                case 6: 
                case 9: 
                case 10: {
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "setNewName";
                    break;
                }
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "setParent";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 5: 
                case 6: 
                case 9: 
                case 10: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

